// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

#ifndef PETE_PETE_ERRORTYPE_H
#define PETE_PETE_ERRORTYPE_H

//-----------------------------------------------------------------------------
// ErrorType
//
// ErrorType is a special type that can be used in traits computations to
// signify an illegal or undefined result.  Currently ErrorType is only used
// in CreateLeaf, in other places (EngineTraits for example) types are just
// left undefined to generate an error at compile time.
// ErrorType is used here for some types that end up not being used.  We want
// to avoid some compile time type computations, but don't want to generate an
// error.  For example, we define several operators:
// operator+(Array<D,T,E>,Array<D2,T2,E2>)
// operator+(T,Array<D2,T2,E2>)
// operator+(Array<D,T,E>,T2)
// Suppose we add two expressions (a+b+c)+(d+e+f).  The compiler will compute
// the return types to each operator+ before it decides that Array+Array is the
// most specialized.  For the second and third versions the return type
// would perform some hairy template metaprograms on Scalar<Array<...>> which
// never actually get used.  (This problem caused the compiler to self-destruct
// for expressions with sums of 15 or so terms.)  To avoid this problem, there
// are CreateLeaf specializations that just return ErrorType.
//-----------------------------------------------------------------------------

struct ErrorType
{
};

#endif // PETE_PETE_ERRORTYPE_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: ErrorType.h,v $   $Author: swhaney $
// $Revision: 1.1 $   $Date: 2000/07/20 15:39:28 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
