// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Class:
// FunctorResult
//-----------------------------------------------------------------------------

#ifndef POOMA_POOMA_FUNCTORRESULT_H
#define POOMA_POOMA_FUNCTORRESULT_H

//////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
// Overview: 
//
// FunctorResult<Functor,T>::Type_t is the return type of a pooma functor
// object.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//
// Full Description:
//
// Where Pooma uses functor objects, STL functors can typically be used,
// where operator() is used to define the function.
//
// STL functors typically either give no type information about the argument
// and return, or specify both through argument_type and result_type.
// For Pooma, we prefer to use templated functors, so result_type is a
// function of argument_type, which is why we use the class FunctorResult<>
// to externally provide the mapping from argument_type to result_type.
//
// The default behaviour simply uses the argument_type for the result_type
// which is sufficient for most STL function objects and most pooma function
// objects.  A couple of examples where you would want to specialize this
// class for different behaviour are:
//
// template<class T>
// struct FunctorResult<logical_not<T>,T>
// {
//   typedef bool Type_t;
// };
//
// template<int D, class T>
// struct FunctorResult<MyNorm,Vector<D,T> >
// {
//   typedef T Type_t;
// };
//-----------------------------------------------------------------------------

template<class Functor, class ArgumentType>
struct FunctorResult
{
  typedef ArgumentType Type_t;
};

#endif     // POOMA_POOMA_FUNCTORRESULT_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: FunctorResult.h,v $   $Author: swhaney $
// $Revision: 1.2 $   $Date: 2000/03/07 13:18:02 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
