// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
//
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without
// charge, provided that this Notice and any statement of authorship are
// reproduced on all copies.  Neither the Government nor the University
// makes any warranty, express or implied, or assumes any liability or
// responsibility for the use of this SOFTWARE.
//
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
//
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Grid.h"
#include "Domain/Range.h"
#include "Tulip/RemoteProxy.h"

#define BARRIER

#ifndef BARRIER
# if POOMA_CHEETAH
#  define BARRIER Pooma::controller()->barrier()
# else
#  define BARRIER
# endif
#endif

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  tester.out() << "Testing Grid broadcasting . . ." << std::endl;

  // Hmmm... If I comment out the following output statement,
  // then the Inform object does not correctly limit itself to
  // context 0 only, nor does the barrier appear to work.
  // What is going on here???

  // JCC: I think I figured out what was wrong.  The first output 
  // statement above did not pass std::endl to the Inform object,
  // so no flush() was ever done.  Later on, the output context
  // for the Inform object is set to all contexts.  When std::endl
  // is finally passed to the Inform object, all the contexts print
  // out everything in the buffer since the last flush().  The second
  // output statement below had a std::endl in it already, causing a
  // a flush() of the buffer and output only by context 0.  I went 
  // ahead and added a std::endl to the first output statement above,
  // just to avoid any confusion or future problems.  The barrier seems
  // to work just fine, with or without these output statements.

  tester.out() << "Running on " << Pooma::contexts() 
  	       << " contexts." << std::endl;

  Grid<1> g;

  if (Pooma::context() == 0)
    {
      Range<1> r(0, 16, 2);

      g = Grid<1>(r);
    }

  RemoteProxy<Grid<1> > broadcast(g);
  Grid<1> ans = broadcast.value();

  BARRIER;

  tester.out().setOutputContext(-1);
  tester.out() << ans << std::endl;

  BARRIER;

  tester.check(ans == Grid<1>(Range<1>(0,16,2)));

  int ret = tester.results("GridBroadcast Test");
  Pooma::finalize();

  return ret;
}

