// Here's a ctype.h for SunOS-3 and vax 4.3BSD.  
// It will probably work on most BSD derived systems. 
// Just compare it to the C version to verify.
// No big deal, but it will save you some typing.
   
#ifndef _ctype_h
#pragma once
#define _ctype_h

#include <stdio.h>  /* sorry, but needed for USG stuff */
   
static const int _U = 01;
static const int _L = 02;
static const int _N = 04;
static const int _S = 010;
static const int _P = 020;
static const int _C = 040;


#ifdef USG
static const int _B = 0100;	/* different from BSD */
static const int _X = 0200;	/* different from BSD */
#else
static const int _X = 0100;
static const int _B = 0200;
#endif


#ifdef DGUX
#define CTYPE_TYPE	short
#else
#define CTYPE_TYPE	char
#endif

#if defined(USG) || defined(hpux)
#define _ctype_ ctype
#endif

extern	CTYPE_TYPE	_ctype_[];
   
inline int isalpha(char c)  { return ((_ctype_+1)[c]&(_U|_L)); }
inline int isupper(char c)  { return ((_ctype_+1)[c]&_U); }
inline int islower(char c)  { return ((_ctype_+1)[c]&_L); }
inline int isdigit(char c)  { return ((_ctype_+1)[c]&_N); }
inline int isxdigit(char c) { return ((_ctype_+1)[c]&_X); }
inline int isspace(char c)  { return ((_ctype_+1)[c]&_S); }
inline int ispunct(char c)  { return ((_ctype_+1)[c]&_P); }
inline int isalnum(char c)  { return ((_ctype_+1)[c]&(_U|_L|_N)); }
inline int isprint(char c)  { return ((_ctype_+1)[c]&(_P|_U|_L|_N|_B)); }
inline int isgraph(char c)  { return ((_ctype_+1)[c]&(_P|_U|_L|_N)); }
inline int iscntrl(char c)  { return ((_ctype_+1)[c]&_C); }
inline int isascii(char c)  { return ((unsigned)(c)<=0177); }
inline int toupper(char c)  { return islower(c)? (c-'a'+'A') : c; }
inline int tolower(char c)  { return isupper(c)? (c-'A'+'a') : c; }
inline int toascii(char c)  { return ((c)&0177); }


#ifdef _ctype_
#undef _ctype_
#endif

#ifdef CTYPE_TYPE
#undef CTYPE_TYPE
#endif

#endif _ctype_h
