// Components for manipulating sequences of characters -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 21  Strings library
//

// Written by Jason Merrill based upon the specification by Takanori Adachi
// in ANSI X3J16/94-0013R2.

#include <bits/std_algorithm.h>
#include <bits/std_string.h>
#if 0
#include <bits/std_ios.h>
#endif //981007 bkoz

// Instantiation configuration.
#ifndef C
# define C char
#endif

namespace std 
{

// Do instantiate.
#ifdef TRAITS
template class char_traits<C>;
#endif

typedef basic_string<C> S;

#ifdef MAIN
template class basic_string<C>;
#endif

#if 0
#ifdef IOS
template class basic_ios<C>;
#endif 

#ifdef BIST
template class basic_istream<C>;
#endif

#ifdef BOST
template class basic_ostream<C>;
#endif
#endif //981007 bkoz

#if 0
  // Already defined via the explicit specialization in char_traits.h.
  //#ifdef CHTR
  //template class char_traits<C>;
  //#endif
#endif //981007 bkoz

#ifdef ADDSS
template S operator+ (const S&, const S&);
#endif
#ifdef ADDPS
template S operator+ (const C*, const S&);
#endif
#ifdef ADDCS
template S operator+ (C, const S&);
#endif
#ifdef ADDSP
template S operator+ (const S&, const C*);
#endif
#ifdef ADDSC
template S operator+ (const S&, C);
#endif
#ifdef EQSS
template bool operator== (const S&, const S&);
#endif
#ifdef EQPS
template bool operator== (const C*, const S&);
#endif
#ifdef EQSP
template bool operator== (const S&, const C*);
#endif
#ifdef NESS
template bool operator!= (const S&, const S&);
#endif
#ifdef NEPS
template bool operator!= (const C*, const S&);
#endif
#ifdef NESP
template bool operator!= (const S&, const C*);
#endif
#ifdef LTSS
template bool operator< (const S&, const S&);
#endif
#ifdef LTPS
template bool operator< (const C*, const S&);
#endif
#ifdef LTSP
template bool operator< (const S&, const C*);
#endif
#ifdef GTSS
template bool operator> (const S&, const S&);
#endif
#ifdef GTPS
template bool operator> (const C*, const S&);
#endif
#ifdef GTSP
template bool operator> (const S&, const C*);
#endif
#ifdef LESS
template bool operator<= (const S&, const S&);
#endif
#ifdef LEPS
template bool operator<= (const C*, const S&);
#endif
#ifdef LESP
template bool operator<= (const S&, const C*);
#endif
#ifdef GESS
template bool operator>= (const S&, const S&);
#endif
#ifdef GEPS
template bool operator>= (const C*, const S&);
#endif
#ifdef GESP
template bool operator>= (const S&, const C*);
#endif
#if 0 //981007 bkoz
#ifdef EXTRACT
template basic_istream<C>& operator>> (basic_istream<C>&, S&);
#endif
#ifdef INSERT
template basic_ostream<C>& operator<< (basic_ostream<C>&, const S&);
#endif
#ifdef GETLINE
template basic_istream<C>& getline (basic_istream<C>&, S&, C);
#endif
#endif //981007 bkoz
#ifdef SCOPY
template void _S_string_copy(const S&, C*, allocator<C>::size_type);
#endif

} // std























