// Input streams -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.6.1  Input streams
//

#ifndef _CPP_ISTREAM
#define _CPP_ISTREAM	1

#include <bits/c++config.h>
#include <bits/std_ios.h>
#include <bits/sbuf_iter.h>

namespace std {

  // 27.6.1.1 Template class basic_istream
  template<typename _CharT, typename _Traits>
    class basic_istream : virtual public basic_ios<_CharT, _Traits>
    {
      // Types (inherited from basic_ios (27.4.4)):
      typedef _CharT                     		char_type;
      typedef typename _Traits::int_type 		int_type;
      typedef typename _Traits::pos_type 		pos_type;
      typedef typename _Traits::off_type 		off_type;
      typedef _Traits                    		traits_type;
      
      // Non-standard Types:
      typedef basic_streambuf<_CharT, _Traits> 		__streambuf_type;
      typedef basic_ios<_CharT, _Traits>		__ios_type;
      typedef basic_istream<_CharT, _Traits>		__istream_type;
      typedef istreambuf_iterator<_CharT>		__istreambuf_iter;
      typedef num_get<_CharT, __istreambuf_iter>        __numget_type;

    protected:
      // Data Members:
      streamsize 		_M_gcount;
      const __numget_type* 	_M_fnumget;

    public:
      // 27.6.1.1.1 Constructor/destructor:
      explicit 
      basic_istream(__streambuf_type* __sb) : __ios_type(__sb)  
      { 
	// XXX Need to fix for imbue events, as currently _M_fnumput
	// is not updated on pubimbue calls. Need a callback? Needs to
	// be moved down do basic_ios??
	_M_gcount = streamsize(0);
	_M_fnumget =  &use_facet<__numget_type>(this->getloc());
      }

      // Needed for [io]stringstream/[io]fstream classes. This assumes
      // that basic_ios has already been initialized _M_streambuf with
      // some relevant buffer.
      explicit 
      basic_istream() 
      { 
	// XXX Need to fix for imbue events, as currently _M_fnumput
	// is not updated on pubimbue calls. Need a callback? Needs to
	// be moved down do basic_ios??
	_M_gcount = streamsize(0);
	_M_fnumget =  &use_facet<__numget_type>(this->getloc());
      }

      virtual 
      ~basic_istream() 
      {
	_M_gcount = streamsize(0);
	_M_fnumget = NULL; 
      }

      // 27.6.1.1.2 Prefix/suffix:
      class sentry;
      friend class sentry;

      // 27.6.1.2 Formatted input:
      __istream_type&
      operator>>(__istream_type& (*__pf)(__istream_type&))
      {
	__pf(*this);
	return *this;
      }

      __istream_type&
      operator>>(__ios_type& (*__pf)(__ios_type&))
      {
	__pf(*this);
	return *this;
      }

      __istream_type&
      operator>>(ios_base& (*__pf)(ios_base&))
      {
	__pf(*this);
	return *this;
      }

      __istream_type& 
      operator>>(bool& __n);
      
      __istream_type& 
      operator>>(short& __n);
      
      __istream_type& 
      operator>>(unsigned short& __n);

      __istream_type& 
      operator>>(int& __n);
      
      __istream_type& 
      operator>>(unsigned int& __n);
      
      __istream_type& 
      operator>>(long& __n);
      
      __istream_type& 
      operator>>(unsigned long& __n);
      
#ifdef _G_USE_LONG_LONG
      __istream_type& 
      operator>>(long long& __n);

      __istream_type& 
      operator>>(unsigned long long& __n);
#endif
      __istream_type& 
      operator>>(float& __f);

      __istream_type& 
      operator>>(double& __f);

      __istream_type& 
      operator>>(long double& __f);

      __istream_type& 
      operator>>(void*& __p);

      __istream_type& 
      operator>>(__streambuf_type* __sb);
      
      // 27.6.1.3 Unformatted input:
      streamsize 
      gcount() const 
      { return _M_gcount; }
      
      int_type 
      get();

      __istream_type& 
      get(char_type& __c);

      __istream_type& 
      get(char_type* __s, streamsize __n)
      { return get(__s, __n, widen('\n')); }

      __istream_type& 
      get(char_type* __s, streamsize __n, char_type __delim)
      { return get(__s, __n, widen(__delim)); }

      __istream_type&
      get(__streambuf_type& __sb)
      { return get(__sb, widen('\n')); }

      __istream_type&
      get (basic_streambuf<char_type,_Traits>& __sb, char_type __delim)
        { return get (__sb, widen(__delim)); }

      __istream_type& 
      getline (char_type* __s, streamsize __n)
	{ return getline (__s, __n, widen ('\n')); }

      __istream_type& 
      getline (char_type* __s, streamsize __n, char_type __delim)
      { return getline(__s, __n, widen(__delim)); }

      __istream_type& 
      ignore(streamsize __n = 1, int_type __delim = _Traits::eof ());
      
      int_type 
      peek();
      
      __istream_type& 
      read(char_type* __s, streamsize __n);

      streamsize 
      readsome(char_type* __s, streamsize __n);
      
      __istream_type& 
      putback(char_type __c)
      {
	if (this->good() && _M_streambuf->sputbackc(__c) == traits_type::eof())
	  clear (ios_base::badbit);
	return *this;
      }

      __istream_type& 
      unget()
      {
	if (this->good() && _M_streambuf->sungetc() == traits_type::eof())
	  clear(ios_base::badbit);
	return *this;
      }

      int 
      sync();

      pos_type 
      tellg();

      __istream_type& 
      seekg(pos_type);

      __istream_type& 
      seekg(off_type, ios_base::seekdir);
      
      // this crashes the compiler.  Why?
      template <class _Ch, class _Tr, class _Alloc>
      friend basic_istream<_Ch,_Tr>&
      getline(basic_istream<_Ch,_Tr>& __is,
               basic_string<_Ch,_Tr,_Alloc>& __s, _Ch __delim);
    };

  template<typename _CharT, typename _Traits>
    class basic_istream<_CharT, _Traits>::sentry
    {
      typedef _Traits traits_type;
      bool _M_ok;
    public:
      explicit 
      sentry (basic_istream<_CharT, _Traits>& __is, bool __noskipws = false);

      operator bool () { return _M_ok; }
    };

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>::sentry::
    sentry(basic_istream<_CharT, _Traits>& __is, bool __noskipws)
    {
      if (!__is.good())
	{
	  _M_ok = false;
	  return;
	}

      // Synchronize with associated stream.
      if (__is.tie())
	__is.tie()->flush();

      if (!__noskipws && (__is.flags() & ios_base::skipws))
	{
	  typename _Traits::int_type __c = __is.rdbuf ()->sgetc ();
#if 1  /* XXX should use getloc */
	  while (__c != _Traits::eof () && isspace(__c))
#else
	    typedef ctype<_CharT> _Ctype;
	  const _Ctype& __ctype = use_facet<_Ctype> (__is.getloc ());
	  while (__c != _Traits::eof () && __ctype.is (__ctype.space, __c))
#endif
	    __c = __is.rdbuf ()->snextc ();
	}
      
      _M_ok = true;
    }


  // 27.6.1.2.3 Character extraction templates:
  template<typename _CharT, typename _Traits>
    typename _Traits::int_type
    basic_istream<_CharT, _Traits>::get()
    {
      sentry __cerb(*this);
      if (!__cerb)
	{
	  _M_gcount = 0;
	  return traits_type::eof ();
	}
      int_type __ch = _M_streambuf->sbumpc();
      if (__ch == traits_type::eof())
	{
	  setstate(ios_base::eofbit);
	  _M_gcount = 0;
	}
      else
	_M_gcount = 1;
      return __ch;
    }

  template<typename _CharT, typename _Traits>
    inline basic_istream<_CharT, _Traits>&
    operator>>(basic_istream<_CharT, _Traits>& __in, _CharT& __c)
    {
      return __in.get(__c);
    }

  template<class _Traits>
    inline basic_istream<char, _Traits> &
    operator>>(basic_istream<char, _Traits>& __in, unsigned char& __c)
    {
      return __in.get(static_cast<char&>(__c));
    }

  template<class _Traits>
    inline basic_istream<char, _Traits> &
    operator>>(basic_istream<char, _Traits>& __in, signed char& __c)
    {
      return __in.get(static_cast<char&> (__c));
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits> &
    operator>>(basic_istream<_CharT, _Traits>&, _CharT*);
  
  template<class _Traits>
    basic_istream<char,_Traits> &
    operator>>(basic_istream<char,_Traits>&, unsigned char*);

  template<class _Traits>
    basic_istream<char,_Traits> &
    operator>>(basic_istream<char,_Traits>&, signed char*);

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& ws (basic_istream<_CharT, _Traits>& __is);

  // 27.6.1.5 Template class basic_iostream
  template<typename _CharT, typename _Traits>
    class basic_iostream
    : public basic_istream<_CharT, _Traits>,
      public basic_ostream<_CharT, _Traits>
    {
      // Non-standard Types:
      typedef basic_istream<_CharT, _Traits>		__istream_type;
      typedef basic_ostream<_CharT, _Traits>		__ostream_type;

    public:
      explicit 
      basic_iostream(basic_streambuf<_CharT, _Traits>* __sb)
      : __istream_type(__sb), __ostream_type(__sb)
      { }

      virtual 
      ~basic_iostream() { }
    };

} // namespace std

#endif	/* _CPP_ISTREAM */


