// -*- C++ -*- C math library.

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 26.5  C library
//

// Note: this is not a conforming implementation.

#ifndef _CPP_CMATH
#define _CPP_CMATH 1
# include_next <math.h>
# include_next <stdlib.h>

#include <bits/c++config.h>

namespace std {

    inline long
    abs(long __l) { return ::labs(__l); }
    inline ldiv_t
    div(long __a, long __b) { return ::ldiv(__a, __b); }

    // XXX: using floating-point promotion
    inline float
    abs(float __x) { return ::fabs(__x); }

    inline float
    acos(float __x) { return ::acos(__x); }

    inline float
    asin(float __x) { return ::asin(__x); }

    inline float
    atan(float __x) { return ::atan(__x); }

    inline float
    atan2(float __x, float __y) { return ::atan2(__x, __y); }

    inline float
    ceil(float __x) { return ::ceil(__x); }

    inline float
    cos(float __x) { return ::cos(__x); }

    inline float
    cosh(float __x) { return ::cosh(__x); }

    inline float
    exp(float __x) { return ::exp(__x); }

    inline float
    fabs(float __x) { return ::fabs(__x); }

    inline float
    floor(float __x) { return ::floor(__x); }

    inline float
    fmod(float __x, float __y) { return ::fmod(__x, __y); }

    inline float
    frexp(float __x, int* __p) { return ::frexp(__x, __p); }

    inline float
    ldexp(float __x, int __i) { return ::ldexp(__x, __i); }

    inline float
    log(float __x) { return ::log(__x); }

    inline float
    log10(float __x) { return ::log10(__x); }

    // 1999-06-17 gdr modff isn't defined in <math.h> on hpux10.20
    // XXX: handle this with autoconf
#if 0    
    inline float
    modf(float __x, float* __y) { return ::modff(__x, __y); }
#endif    

    inline float
    pow(float __x, float __y) { return ::pow(__x, __y); }

    inline float
    pow(float __x, int __i) { return ::pow(__x, __i); }

#if 0
    //#ifdef _GLIBCPP_HAS_BUILTIN_SINF
    inline float
    sin(float __x) { return __builtin_sinf(__x); }
#endif

    inline float
    sin(float __x) { return ::sin(__x); }

    inline float
    sinh(float __x) { return ::sinh(__x); }

    inline float
    sqrt(float __x) { return ::sqrt(__x); }

    inline float
    tan(float __x) { return ::tan(__x); }

    inline float
    tanh(float __x) { return ::tanh(__x); }

    

    inline double
    abs(double __x) { return ::fabs(__x); }

    // XXX: replace this stub with an efficient implementation
    // 990602 bkoz redefinition on hpux10.20
#if 0
    inline double
    pow(double __x, int __i) { return ::pow(__x, __i); }
#endif

} // std

#endif // _CPP_CMATH


