//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if the -fall-virtual option is *not* used, you can
// still make (implicit) calls to the overloaded method call operator
// (for non-virtual functions).
//
// This code causes a compiler segfault using 1.34.1 g++.  If the
// type of the "vtable_index" parameter to the method call operator
// in the "base" class is changed to "void*" however, no errors or
// segfaults occur.

class base {
public:
	base () {}
	void method (int i) {}
	void* operator ->() (int vtable_index, int arg_byte_count, ...) {}
};


base* bp;

int main ()
{
	bp = new base;
	bp->method (99);
}

