//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Options: -fall-virtual
//
// Check that the __user_new can be called (implicitly) and that
// a proper set of arguments will be passed to it.


extern void* malloc (int size);

enum location { local, remote };

class base {
	int data_member_0;
	int data_member_1;
public:
	virtual void member_function_0 () {}	// vindex = 0
	virtual void member_function_1 () {}	// vindex = 1
	virtual void member_function_2 () {}	// vindex = 2

	base (int ii, int jj, int kk) {}	// vindex = 3

	base (int ii, int jj)			// vindex = 4
	{
		data_member_0 = ii;
		data_member_1 = jj;
	}

	base () {}				// vindex = 5

	virtual void member_function_6 () {}	// vindex = 6
};

typedef base* (base::*base_member_func_SI_SI_ptr) (int, int);

// Note that mfp here contains the actual address of the
// constructor function, *not* the vindex for it.

base_member_func_SI_SI_ptr mfp = &base::base;

base* bp;

overload __user_new;

void* __user_new (
	int sizeof_class,
	char* class_name,
	int ctor,
	int ctor_arg_bytes,
	int new_param_0,
	int new_param_1,
	...);

int main ()
{
	bp = new {88, 99} base (22, 33);
	return (bp == 0) ? 1 : 0;
}

void* __user_new (
	int sizeof_class,
	char* class_name,
	int ctor,
	int ctor_arg_bytes,
	int new_param_0,
	int new_param_1,
	...)
{
	if (sizeof_class != 12) {
		printf ("sizeof_class expected = %d, got = %d\n", 12, sizeof_class);
		return 0;
	}
	if (strcmp (class_name, "base")) {
		printf ("class_name expected = %s, got = %s\n", "base", class_name);
		return 0;
	}
	if (ctor != 0x80000004) {
		printf ("ctor expected = 0x%08x, got = 0x%08x\n", 0x80000004, ctor);
		return 0;
	}
	if (ctor_arg_bytes != 12) {
		printf ("ctor_arg_bytes expected = %d, got = %d\n", 12, ctor_arg_bytes);
		return 0;
	}
	if (new_param_0 != 88) {
		printf ("new_param_0 expected = %d, got = %d\n", 88, new_param_0);
		return 0;
	}
	if (new_param_1 != 99) {
		printf ("new_param_1 expected = %d, got = %d\n", 99, new_param_1);
		return 0;
	}
	return malloc(sizeof_class);
}
