//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal for non-constructor member
// functions (and operators) to include "header" calls
// to base and/or member constructors (as are allowed for
// constructors).

struct base {
	int data_member;

	base () {}
	base (int i) {}
};

struct derived : public base {
	int data_member;

	derived (int i) : base (i)			// legal!
	{
	}

	void function_member (int i) : base (i)		// ERROR
	{
	}

	int operator+ (int i) : base (i)		// ERROR
	{
		i = i;					// avoid warnings
		return 0;
	}

	~derived () : base ()				// ERROR
	{
	}
};
