//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if there is a user defined class-specific operator
// new for a given class, that operator is invoked when a new
// object of the class is requested, regardless of whether or not
// there is also a constructor for the given class, and regardless
// of whether or not the constructor for the given class is defined
// before or after the new operator is even declared.

typedef unsigned long size_t;

struct base {
	int i;

	base ()
	{
		i = 7;
	}

	void * operator new (size_t size);
	void operator delete (void*);
};

class derived : public base {
	int j;
};

int new_call_count = 0;
int expected_size = 0;
int errors = 0;

int main ()
{
	base*		base_ptr;
	derived*	derived_ptr;

	expected_size = 4;
	base_ptr = new base;
	expected_size = 8;
	derived_ptr = new derived ();
	return ((new_call_count != 2) || (errors != 0));
}

char allocation_space[1000];
char* allocation_ptr = allocation_space;

void base::operator delete (void* p)
{
}

void *base::operator new (size_t size)
{
	char* return_value = allocation_ptr;

	new_call_count++;
	if (size != expected_size)
		errors++;
	allocation_pointer = allocation_pointer + size;
	return (void*) return_value;
}
