//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a reference is initialized to refer to a value
// which is returned from a function call, the actual call to
// the function is only invoked for the original initialization
// of the reference, and not for each subsequent use of the
// reference.
//
// This test fails with G++ 1.35.0- (pre-release).
// Reported 4/4/89 by Kim Smith

struct base {
	int data_member;

	base () {}
	void function_member ();
};

base base_object;

base base_returning_function ();

int call_count = 0;

int main ()
{
	base& base_ref = base_returning_function ();

	base_ref.function_member ();
	base_ref.function_member ();
	base_ref.data_member  = 99;
	return (call_count == 1) ? 0 : 1;
}

base base_returning_function ()
{
	base local_base_object;

	call_count++;
	return local_base_object;
}

void base::function_member ()
{
}
