/* Startup code needed by GCC C++ output code.  */
/* When compiling this file stand alone, use -fPIC */
/* Copyright (C) 1991 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, if you link this file with files
   compiled with GCC to produce an executable, this does not cause
   the resulting executable to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

/*  init.c: Originally developed by James Kempf for SUN,
 *               adapted and commented for FSF by Heinz Seidl (hgs@cygnus.com)
 */

/*************************************************************************
 *              exports: void INITIALIZE_MODULE()
 *                       void FINALIZE_MODULE()
 *              imports: ep_fp * __function_list_addr
 *
 * Shared libraries should link a copy of this module into them. The
 * dynamic initialization/finalization function can look up these
 * functions and call them to do static ctor/dtor work.
 * This file is also used for the main module.
 ************************************************************************/

/* 
 * The __C/DTOR_LIST__ have the folowing form:
 * 
 * entry_pt * __C/DTOR_LIST__[] = {
 *	_first_entry_point,
 *	_second_entry_point,
 *	...
 *	0
 * }
 *
 * Both lists are in _proper_ order; i.e. the destructor list is in reverse
 * order of the constructor list.
 *
 * In case OLD_FORMAT is defined, init.c understands the format generated by
 * gld 1.x and used by gnulib3.
 */

#include "init_main.h"

extern ep_fp * __function_list_addr;

/* 
 * Semaphore for indicating whether the library has already been initialized. 
 */
static int initialized = 0;

enum Direction { FORWARD, BACKWARD };

static inline
void do_fns( ep_fp * fns, enum Direction d )
{
  ep_fp fn;
  while( *fns )
    {
	    if (d == FORWARD) 
	      fn = *fns++;
	    else
	      fn = *fns--;

	    fn();
    }
}

void INITIALIZE_MODULE()
{
    if ( __function_list_addr && *__function_list_addr && ! initialized ) {
	initialized = 1;
#ifdef OLD_FORMAT
	do_fns( __function_list_addr + 1, FORWARD);
#else
	do_fns( __function_list_addr, FORWARD );
#endif
    }
}

void FINALIZE_MODULE()
{
#ifdef OLD_FORMAT
	 long offset = 0;
#endif
    if ( __function_list_addr && *__function_list_addr && initialized ) {
	 initialized = 0;
#ifdef OLD_FORMAT
	 offset = (long) *__function_list_addr;
	 *__function_list_addr = 0;
	 __function_list_addr += offset;
	 do_fns( __function_list_addr, BACKWARD );
#else
	 do_fns( __function_list_addr, FORWARD );
#endif
    }
}
