;;- Machine description for Intel 860 chip for GNU C compiler
;;   Copyright (C) 1989 Free Software Foundation, Inc.

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

;;- Operand classes for the register allocator:

/* Bit-test instructions.  */

(define_insn ""
  [(set (cc0) (eq (and:SI (match_operand:SI 0 "register_operand" "r")
			  (match_operand:SI 1 "logic_operand" "rL"))
		  (const_int 0)))]
  ""
  "*
{
  cc_status.flags |= CC_ONLY_EQ;
  return \"and %1,%0,r0\";
}")

(define_insn ""
  [(set (cc0) (ne (and:SI (match_operand:SI 0 "register_operand" "r")
			  (match_operand:SI 1 "logic_operand" "rL"))
		  (const_int 0)))]
  ""
  "*
{
  cc_status.flags |= CC_NEGATED;
  cc_status.flags |= CC_ONLY_EQ;
  return \"and %1,%0,r0\";
}")

(define_insn ""
  [(set (cc0) (eq (and:SI (match_operand:SI 0 "register_operand" "r")
			  (match_operand:SI 1 "immediate_operand" "i"))
		  (const_int 0)))]
  "GET_CODE (operands[1]) == CONST_INT && (INTVAL (operands[1]) & 0xffff) == 0"
  "*
{
  cc_status.flags |= CC_ONLY_EQ;
  return \"andh h%%%1,%0,r0\";
}")

(define_insn ""
  [(set (cc0) (ne (and:SI (match_operand:SI 0 "register_operand" "r")
			  (match_operand:SI 1 "immediate_operand" "i"))
		  (const_int 0)))]
  "GET_CODE (operands[1]) == CONST_INT && (INTVAL (operands[1]) & 0xffff) == 0"
  "*
{
  cc_status.flags |= CC_NEGATED;
  cc_status.flags |= CC_ONLY_EQ;
  return \"andh h%%%1,%0,r0\";
}")

(define_insn ""
  [(set (cc0) (eq (ashiftrt:SI
		   (sign_extend:SI
		    (ashift:QI (match_operand:QI 0 "register_operand" "r")
			       (match_operand:QI 1 "logic_int" "n")))
		   (match_operand:SI 2 "logic_int" "n"))
		  (const_int 0)))]
  ""
  "*
{
  int width = 8 - INTVAL (operands[2]);
  int pos = 8 - width - INTVAL (operands[1]);
  operands[2] = gen_rtx (CONST_INT, VOIDmode,
			 ~((-1) << width) << pos);
  return \"and %2,%0,r0\";
}")

;; Compare instructions.
;; This controls RTL generation and register allocation.

;; Put cmpsi first among compare insns so it matches two CONST_INT operands.

(define_insn "cmpeqsi"
  [(set (cc0) (eq (match_operand:SI 0 "logic_operand" "r,rL")
		  (match_operand:SI 1 "logic_operand" "L,r")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_EQ;
  if (REG_P (operands[0]))
    return \"xor %1,%0,r0\";
  return \"xor %0,%1,r0\";
}")

(define_insn "cmpltsi"
  [(set (cc0) (lt (match_operand:SI 0 "arith_operand" "r,rI")
		  (match_operand:SI 1 "arith_operand" "I,r")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LT;
  if (REG_P (operands[1]))
    return \"subs %0,%1,r0\";
  cc_status.flags |= CC_REVERSED;
  operands[1] = gen_rtx (CONST_INT, VOIDmode, - INTVAL (operands[1]));
  return \"adds %1,%0,r0\";
}")

(define_insn "cmpgtsi"
  [(set (cc0) (gt (match_operand:SI 0 "arith_operand" "r,rI")
		  (match_operand:SI 1 "arith_operand" "I,r")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LT;
  if (REG_P (operands[0]))
    return \"subs %1,%0,r0\";
  cc_status.flags |= CC_REVERSED;
  operands[0] = gen_rtx (CONST_INT, VOIDmode, - INTVAL (operands[0]));
  return \"adds %0,%1,r0\";
}")

(define_insn "cmpgeusi"
  [(set (cc0) (geu (match_operand:SI 0 "arith_operand" "r,rI")
		   (match_operand:SI 1 "arith_operand" "I,r")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LEU;
  if (REG_P (operands[1]))
    return \"subu %0,%1,r0\";
  cc_status.flags |= CC_REVERSED;
  operands[1] = gen_rtx (CONST_INT, VOIDmode, - INTVAL (operands[1]));
  return \"addu %1,%0,r0\";
}")

(define_insn "cmpleusi"
  [(set (cc0) (leu (match_operand:SI 0 "arith_operand" "r,rI")
		   (match_operand:SI 1 "arith_operand" "I,r")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LEU;
  if (REG_P (operands[0]))
    return \"subu %1,%0,r0\";
  cc_status.flags |= CC_REVERSED;
  operands[0] = gen_rtx (CONST_INT, VOIDmode, - INTVAL (operands[0]));
  return \"addu %0,%1,r0\";
}")

(define_insn "cmpeqsf"
  [(set (cc0) (eq (match_operand:SF 0 "reg_or_0_operand" "fG")
		  (match_operand:SF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_EQ;
  return \"pfeq.s %r1,%r0\";
}")

(define_insn "cmpltsf"
  [(set (cc0) (lt (match_operand:SF 0 "reg_or_0_operand" "fG")
		  (match_operand:SF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LT;
  return \"pfgt.s %r1,%r0\";
}")

(define_insn "cmpgtsf"
  [(set (cc0) (gt (match_operand:SF 0 "reg_or_0_operand" "fG")
		  (match_operand:SF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LT;
  return \"pfgt.s %r0,%r1\";
}")

(define_insn "cmplesf"
  [(set (cc0) (le (match_operand:SF 0 "reg_or_0_operand" "fG")
		  (match_operand:SF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LE;
  return \"pfle.s %r1,%r0\";
}")

(define_insn "cmpgesf"
  [(set (cc0) (ge (match_operand:SF 0 "reg_or_0_operand" "fG")
		  (match_operand:SF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LE;
  return \"pfle.s %r0,%r1\";
}")

(define_insn "cmpeqdf"
  [(set (cc0) (eq (match_operand:DF 0 "reg_or_0_operand" "fG")
		  (match_operand:DF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_EQ;
  return \"pfeq.d %r1,%r0\";
}")

(define_insn "cmpltdf"
  [(set (cc0) (lt (match_operand:DF 0 "reg_or_0_operand" "fG")
		  (match_operand:DF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LT;
  return \"pfgt.d %r1,%r0\";
}")

(define_insn "cmpgtdf"
  [(set (cc0) (gt (match_operand:DF 0 "reg_or_0_operand" "fG")
		  (match_operand:DF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LT;
  return \"pfgt.d %r0,%r1\";
}")

(define_insn "cmpledf"
  [(set (cc0) (le (match_operand:DF 0 "reg_or_0_operand" "fG")
		  (match_operand:DF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LE;
  return \"pfle.d %r1,%r0\";
}")

(define_insn "cmpgedf"
  [(set (cc0) (ge (match_operand:DF 0 "reg_or_0_operand" "fG")
		  (match_operand:DF 1 "reg_or_0_operand" "fG")))]
  ""
  "*
{
  cc_status.flags &= ~ CC_CONDITION_MASK;
  cc_status.flags |= CC_ONLY_LE;
  return \"pfle.d %r0,%r1\";
}")

(define_insn ""
  [(set (cc0) (eq (zero_extend:SI (match_operand:HI 0 "load_operand" "m"))
	          (match_operand:SI 1 "small_int" "I")))]
  "INTVAL (operands[1]) >= 0"
  "ld.s %0,r31\;xor %1,r31,r0")

(define_insn ""
  [(set (cc0) (eq (match_operand:SI 0 "small_int" "I")
	          (zero_extend:SI (match_operand:HI 1 "load_operand" "m"))))]
  "INTVAL (operands[0]) >= 0"
  "ld.s %1,r31\;xor %0,r31,r0")

;; Define the real conditional branch instructions.

(define_insn "cbranch"
  [(set (pc) (if_then_else (cc0) (label_ref (match_operand 0 "" "")) (pc)))]
  ""
  "*
{
  if (cc_prev_status.flags & CC_NEGATED)
    return \"bnc %l0\";
  else
    return \"bc %l0\";
}")

(define_insn "inverse_cbranch"
  [(set (pc) (if_then_else (cc0) (pc) (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  if (cc_prev_status.flags & CC_NEGATED)
    return \"bc %l0\";
  else
    return \"bnc %l0\";
}")

;; Other conditional branches, made by combining.

(define_insn ""
  [(set (pc) (if_then_else (eq (match_operand:SI 0 "bte_operand" "%rK")
			       (match_operand:SI 1 "bte_operand" "rJ"))
			   (label_ref (match_operand 2 "" ""))
			   (pc)))]
  "GET_CODE (operands[0]) == REG || GET_CODE (operands[1]) == REG"
  "bte %0,%r1,%2")

(define_insn ""
  [(set (pc) (if_then_else (eq (match_operand:SI 0 "bte_operand" "%rK")
			       (match_operand:SI 1 "bte_operand" "rJ"))
			   (pc)
			   (label_ref (match_operand 2 "" ""))))]
  "GET_CODE (operands[0]) == REG || GET_CODE (operands[1]) == REG"
  "btne %0,%r1,%2")

;; Optimize fetching an unsigned half word and comparing against constant.
;; No need to zero-extend.

(define_insn ""
  [(set (pc) (if_then_else (eq (zero_extend:SI (match_operand:HI 0 "load_operand" "m"))
			       (match_operand:SI 1 "immediate_operand" "K"))
			   (label_ref (match_operand 2 "" ""))
			   (pc)))]
  "GET_CODE (operands[1]) == CONST_INT
   && INTVAL (operands[1]) < 0x10 && INTVAL (operands[1]) >= 0"
  "ld.s %0,r31\;bte %1,r31,%2")

(define_insn ""
  [(set (pc) (if_then_else (eq (match_operand:SI 0 "immediate_operand" "K")
			       (zero_extend:SI (match_operand:HI 1 "load_operand" "m")))
			   (label_ref (match_operand 2 "" ""))
			   (pc)))]
  "GET_CODE (operands[0]) == CONST_INT
   && INTVAL (operands[0]) < 0x10 && INTVAL (operands[0]) >= 0"
  "ld.s %1,r31\;bte %0,r31,%2")

(define_insn ""
  [(set (pc) (if_then_else (eq (zero_extend:SI (match_operand:HI 0 "load_operand" "m"))
			       (match_operand:SI 1 "immediate_operand" "K"))
			   (pc)
			   (label_ref (match_operand 2 "" ""))))]
  "GET_CODE (operands[1]) == CONST_INT
   && INTVAL (operands[1]) < 0x10 && INTVAL (operands[1]) >= 0"
  "ld.s %0,r31\;btne %1,r31,%2")

(define_insn ""
  [(set (pc) (if_then_else (eq (match_operand:SI 0 "immediate_operand" "K")
			       (zero_extend:SI (match_operand:HI 1 "load_operand" "m")))
			   (pc)
			   (label_ref (match_operand 2 "" ""))))]
  "GET_CODE (operands[0]) == CONST_INT
   && INTVAL (operands[0]) < 0x10 && INTVAL (operands[0]) >= 0"
  "ld.s %1,r31\;btne %0,r31,%2")

(define_insn ""
  [(set (pc) (if_then_else (eq (zero_extend:SI (match_operand:QI 0 "load_operand" "m"))
			       (match_operand:SI 1 "immediate_operand" "K"))
			   (label_ref (match_operand 2 "" ""))
			   (pc)))]
  "GET_CODE (operands[1]) == CONST_INT
   && INTVAL (operands[1]) < 0x10 && INTVAL (operands[1]) >= 0"
  "ld.b %0,r31\;bte %1,r31,%2")

(define_insn ""
  [(set (pc) (if_then_else (eq (match_operand:SI 0 "immediate_operand" "K")
			       (zero_extend:SI (match_operand:QI 1 "load_operand" "m")))
			   (label_ref (match_operand 2 "" ""))
			   (pc)))]
  "GET_CODE (operands[0]) == CONST_INT
   && INTVAL (operands[0]) < 0x10 && INTVAL (operands[0]) >= 0"
  "ld.b %1,r31\;bte %0,r31,%2")

(define_insn ""
  [(set (pc) (if_then_else (eq (zero_extend:SI (match_operand:QI 0 "load_operand" "m"))
			       (match_operand:SI 1 "immediate_operand" "K"))
			   (pc)
			   (label_ref (match_operand 2 "" ""))))]
  "GET_CODE (operands[1]) == CONST_INT
   && INTVAL (operands[1]) < 0x10 && INTVAL (operands[1]) >= 0"
  "ld.b %0,r31\;btne %1,r31,%2")

(define_insn ""
  [(set (pc) (if_then_else (eq (match_operand:SI 0 "immediate_operand" "K")
			       (zero_extend:SI (match_operand:QI 1 "load_operand" "m")))
			   (pc)
			   (label_ref (match_operand 2 "" ""))))]
  "GET_CODE (operands[0]) == CONST_INT
   && INTVAL (operands[0]) < 0x10 && INTVAL (operands[0]) >= 0"
  "ld.b %1,r31\;btne %0,r31,%2")

;; Generation of conditionals.

;; The first step is the emission of a standard-looking compare insn.
;; Then a standard-named conditional branch pattern is run.
;; That branch pattern looks back at the compare insn and deletes it.
;; It then emits a machine-specific compare insn and a branch-if-true
;; or a branch-if-false.

;; These patterns have `abort' because they are supposed to be deleted
;; in that fashion.

(define_insn "cmpsi"
  [(set (cc0) (compare (match_operand:SI 0 "compare_operand" "")
		       (match_operand:SI 1 "compare_operand" "")))]
  ""
  "* abort ();")

(define_insn "cmpsf"
  [(set (cc0) (compare (match_operand:SF 0 "register_operand" "")
		       (match_operand:SF 1 "register_operand" "")))]
  ""
  "* abort ();")

(define_insn "cmpdf"
  [(set (cc0) (compare (match_operand:DF 0 "register_operand" "")
		       (match_operand:DF 1 "register_operand" "")))]
  ""
  "* abort ();")

;; These are the standard-named conditional branch patterns.
;; Detailed comments are found in the first one only.

(define_expand "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  /* Get out of the sequence just started for us.  */

  end_sequence ();
  prev = get_last_insn ();

  /* Examine the preceding compare insn, and get rid of it.  */

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));

  /* Now once again start a sequence for our new instructions.  */

  start_sequence ();

  /* Emit a single-condition compare insn according to
     the type of operands and the condition to be tested.  */

  if (code == CODE_FOR_cmpsi)
    emit_insn (gen_cmpeqsi (recog_operand[0], recog_operand[1]));
  else if (code == CODE_FOR_cmpsf)
    emit_insn (gen_cmpeqsf (recog_operand[0], recog_operand[1]));
  else if (code == CODE_FOR_cmpdf)
    emit_insn (gen_cmpeqdf (recog_operand[0], recog_operand[1]));
  else
    abort ();

  /* Emit branch-if-true.  */

  emit_jump_insn (gen_cbranch (label));

  DONE;
}")

(define_expand "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    emit_insn (gen_cmpeqsi (recog_operand[0], recog_operand[1]));
  else if (code == CODE_FOR_cmpsf)
    emit_insn (gen_cmpeqsf (recog_operand[0], recog_operand[1]));
  else if (code == CODE_FOR_cmpdf)
    emit_insn (gen_cmpeqdf (recog_operand[0], recog_operand[1]));
  else
    abort ();
  emit_jump_insn (gen_inverse_cbranch (label));

  DONE;
}")

(define_expand "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    emit_insn (gen_cmpgtsi (recog_operand[0], recog_operand[1]));
  else if (code == CODE_FOR_cmpsf)
    emit_insn (gen_cmpgtsf (recog_operand[0], recog_operand[1]));
  else if (code == CODE_FOR_cmpdf)
    emit_insn (gen_cmpgtdf (recog_operand[0], recog_operand[1]));
  else
    abort ();
  emit_jump_insn (gen_cbranch (label));
  DONE;
}")

(define_expand "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    emit_insn (gen_cmpltsi (recog_operand[0], recog_operand[1]));
  else if (code == CODE_FOR_cmpsf)
    emit_insn (gen_cmpltsf (recog_operand[0], recog_operand[1]));
  else if (code == CODE_FOR_cmpdf)
    emit_insn (gen_cmpltdf (recog_operand[0], recog_operand[1]));
  else
    abort ();
  emit_jump_insn (gen_cbranch (label));
  DONE;
}")

(define_expand "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    {
      emit_insn (gen_cmpgtsi (recog_operand[0], recog_operand[1]));
      emit_jump_insn (gen_inverse_cbranch (label));
    }
  else
    {
      if (code == CODE_FOR_cmpsf)
	emit_insn (gen_cmplesf (recog_operand[0], recog_operand[1]));
      else if (code == CODE_FOR_cmpdf)
	emit_insn (gen_cmpledf (recog_operand[0], recog_operand[1]));
      else
	abort ();
      emit_jump_insn (gen_cbranch (label));
    }
  DONE;
}")

(define_expand "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    {
      emit_insn (gen_cmpltsi (recog_operand[0], recog_operand[1]));
      emit_jump_insn (gen_inverse_cbranch (label));
    }
  else
    {
      if (code == CODE_FOR_cmpsf)
	emit_insn (gen_cmpgesf (recog_operand[0], recog_operand[1]));
      else if (code == CODE_FOR_cmpdf)
	emit_insn (gen_cmpgedf (recog_operand[0], recog_operand[1]));
      else
        abort ();
      emit_jump_insn (gen_cbranch (label));
    }
  DONE;
}")

(define_expand "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    emit_insn (gen_cmpleusi (recog_operand[0], recog_operand[1]));
  else
    abort ();
  emit_jump_insn (gen_inverse_cbranch (label));
  DONE;
}")

(define_expand "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    emit_insn (gen_cmpgeusi (recog_operand[0], recog_operand[1]));
  else
    abort ();
  emit_jump_insn (gen_inverse_cbranch (label));
  DONE;
}")

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    emit_insn (gen_cmpgeusi (recog_operand[0], recog_operand[1]));
  else
    abort ();
  emit_jump_insn (gen_cbranch (label));
  DONE;
}")

(define_expand "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  rtx label = operands[0];
  enum insn_code code;
  rtx prev;

  end_sequence ();
  prev = get_last_insn ();

  code = recog_memoized (prev);
  insn_extract (prev);
  NEXT_INSN (PREV_INSN (prev)) = 0;
  set_last_insn (PREV_INSN (prev));
  start_sequence ();

  if (code == CODE_FOR_cmpsi)
    emit_insn (gen_cmpleusi (recog_operand[0], recog_operand[1]));
  else
    abort ();
  emit_jump_insn (gen_cbranch (label));
  DONE;
}")

;; Move instructions

(define_insn "movsi"
  [(set (match_operand:SI 0 "general_operand" "=r,m,f")
	(match_operand:SI 1 "general_operand" "rmif,rfJ,rmfJ"))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    {
      if (CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
	return output_store (operands);
      if (FP_REG_P (operands[1]))
	return \"fst.l %1,%0\";
      return \"st.l %r1,%0\";
    }
  if (GET_CODE (operands[1]) == MEM)
    {
      if (CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
	return output_load (operands);
      if (FP_REG_P (operands[0]))
	return \"fld.l %1,%0\";
      return \"ld.l %1,%0\";
    }
  if (FP_REG_P (operands[1]) && FP_REG_P (operands[0]))
    return \"fmov.ss %1,%0\";
  if (FP_REG_P (operands[1]))
    return \"fxfr %1,%0\";
  if (FP_REG_P (operands[0]) && operands[1] == const0_rtx)
    return \"fmov.ss f0,%0\";
  if (FP_REG_P (operands[0]))
    return \"ixfr %1,%0\";
  return \"mov %1,%0\";
}")

(define_insn "movhi"
  [(set (match_operand:HI 0 "general_operand" "=r,m")
	(match_operand:HI 1 "general_operand" "rmi,rJ"))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    {
      if (CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
	return output_store (operands);
      return \"st.s %r1,%0\";
    }
  if (GET_CODE (operands[1]) == MEM)
    {
      if (CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
	return output_load (operands);
      return \"ld.s %1,%0\";
    }
  return \"mov %1,%0\";
}")

(define_insn "movqi"
  [(set (match_operand:QI 0 "general_operand" "=r,m")
	(match_operand:QI 1 "general_operand" "rmi,rJ"))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    {
      if (CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
	return output_store (operands);
      return \"st.b %r1,%0\";
    }
  if (GET_CODE (operands[1]) == MEM)
    {
      if (CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
	return output_load (operands);
      return \"ld.b %1,%0\";
    }
  return \"mov %1,%0\";
}")

;; The definition of this insn does not really explain what it does,
;; but it should suffice
;; that anything generated as this insn will be recognized as one
;; and that it won't successfully combine with anything.
(define_expand "movstrsi"
  [(parallel [(set (mem:BLK (match_operand:BLK 0 "general_operand" ""))
		   (mem:BLK (match_operand:BLK 1 "general_operand" "")))
	      (use (match_operand:SI 2 "nonmemory_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (clobber (match_dup 4))
	      (clobber (match_dup 5))
	      (clobber (match_dup 6))
	      (clobber (match_dup 0))
	      (clobber (match_dup 1))])]
  ""
  "
{
  operands[0] = copy_to_mode_reg (SImode, XEXP (operands[0], 0));
  operands[1] = copy_to_mode_reg (SImode, XEXP (operands[1], 0));
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = gen_reg_rtx (SImode);
  operands[6] = gen_reg_rtx (SImode);
}")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "r"))
	(mem:BLK (match_operand:SI 1 "register_operand" "r")))
   (use (match_operand:SI 2 "nonmemory_operand" "rn"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (match_operand:SI 5 "register_operand" "=r"))
   (clobber (match_operand:SI 6 "register_operand" "=r"))
   (clobber (match_dup 0))
   (clobber (match_dup 1))]
  ""
  "* return output_block_move (operands);")

;; Floating point move insns

;; This pattern forces (set (reg:DF ...) (const_double ...))
;; to be reloaded by putting the constant into memory.
;; It must come before the more general movdf pattern.
(define_insn ""
  [(set (match_operand:DF 0 "general_operand" "=r,f,o")
	(match_operand:DF 1 "" "mG,m,G"))]
  "GET_CODE (operands[1]) == CONST_DOUBLE"
  "*
{
  if (FP_REG_P (operands[0]))
    return output_fp_move_double (operands);
  if (operands[1] == dconst0_rtx && GET_CODE (operands[0]) == REG)
    {
      operands[1] = gen_rtx (REG, SImode, REGNO (operands[0]) + 1);
      return \"mov r0,%0\;mov r0,%1\";
    }
  if (operands[1] == dconst0_rtx && GET_CODE (operands[0]) == MEM)
    {
      if (CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
	{
	  if (! ((cc_prev_status.flags & CC_KNOW_HI_R31)
		 && (cc_prev_status.flags & CC_HI_R31_ADJ)
		 && XEXP (operands[0], 0) == cc_prev_status.mdep))
	    {
	      cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
	      cc_status.mdep = XEXP (operands[0], 0);
	      output_asm_insn (\"orh ha%%%m0,r0,r31\", operands);
	    }
	  return \"st.l r0,l%%%%m0(r31)\;st.l r0,l%%%%m0+4(r31)\";
	}
      operands[1] = adj_offsettable_operand (operands[0], 4);
      return \"st.l r0,%0\;st.l r0,%1\";
    }
  return output_move_double (operands);
}")

(define_insn "movdf"
  [(set (match_operand:DF 0 "general_operand" "=*rm,&*r,?f,?*rm")
	(match_operand:DF 1 "general_operand" "*r,m,*rfmG,f"))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM
      && CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
    return output_store (operands);
  if (GET_CODE (operands[1]) == MEM
      && CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
    return output_load (operands);

  if (FP_REG_P (operands[0]) || FP_REG_P (operands[1]))
    return output_fp_move_double (operands);
  return output_move_double (operands);
}")

(define_insn "movdi"
  [(set (match_operand:DI 0 "general_operand" "=rm,&r,?f,?rm")
	(match_operand:DI 1 "general_operand" "r,mi,rfm,f"))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM
      && CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
    return output_store (operands);
  if (GET_CODE (operands[1]) == MEM
      && CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
    return output_load (operands);

  if (FP_REG_P (operands[0]) || FP_REG_P (operands[1]))
    return output_fp_move_double (operands);
  return output_move_double (operands);
}")

(define_insn "movsf"
  [(set (match_operand:SF 0 "general_operand" "=*rf,m")
	(match_operand:SF 1 "general_operand" "*rfmG,*rf"))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM
      && CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
    return output_store (operands);
  if (GET_CODE (operands[1]) == MEM
      && CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
    return output_load (operands);
  if (FP_REG_P (operands[0]))
    {
      if (FP_REG_P (operands[1]))
	return \"fmov.ss %1,%0\";
      if (GET_CODE (operands[1]) == REG)
	return \"ixfr %1,%0\";
      if (operands[1] == fconst0_rtx)
        return \"fmov.ss f0,%0\";
      if (CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
	{
	  cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
	  cc_status.mdep = XEXP (operands[1], 0);
	  return \"orh ha%%%m1,r0,r31\;fld.l l%%%m1(r31),%0\";
	}
      return \"fld.l %1,%0\";
    }
  if (FP_REG_P (operands[1]))
    {
      if (GET_CODE (operands[0]) == REG)
	return \"fxfr %1,%0\";
      if (CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
	{
	  if (! ((cc_prev_status.flags & CC_KNOW_HI_R31)
		 && (cc_prev_status.flags & CC_HI_R31_ADJ)
		 && XEXP (operands[0], 0) == cc_prev_status.mdep))
	    {
	      cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
	      cc_status.mdep = XEXP (operands[0], 0);
	      output_asm_insn (\"orh ha%%%m0,r0,r31\", operands);
	    }
	  return \"fst.l %r1,l%%%m0(r31)\";
	}
      return \"fst.l %r1,%0\";
    }
  if (GET_CODE (operands[0]) == MEM)
    return \"st.l %r1,%0\";
  if (GET_CODE (operands[1]) == MEM)
    return \"ld.l %1,%0\";
  if (operands[1] == fconst0_rtx)
    return \"mov r0,%0\";
  return \"mov %1,%0\";
}")

;; Special load insns for REG+REG addresses.
;; Such addresses are not "legitimate" because st rejects them.

(define_insn ""
  [(set (match_operand:DF 0 "register_operand" "rf")
	(match_operand:DF 1 "indexed_operand" "m"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    return output_fp_move_double (operands);
  return output_move_double (operands);
}")

(define_insn ""
  [(set (match_operand:SF 0 "register_operand" "rf")
	(match_operand:SF 1 "indexed_operand" "m"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    return \"fld.l %1,%0\";
  return \"ld.l %1,%0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "rf")
	(match_operand:SI 1 "indexed_operand" "m"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    return \"fld.l %1,%0\";
  return \"ld.l %1,%0\";
}")

(define_insn ""
  [(set (match_operand:HI 0 "register_operand" "r")
	(match_operand:HI 1 "indexed_operand" "m"))]
  ""
  "ld.s %1,%0")

(define_insn ""
  [(set (match_operand:QI 0 "register_operand" "r")
	(match_operand:QI 1 "indexed_operand" "m"))]
  ""
  "ld.b %1,%0")

;; Likewise for floating-point store insns.

(define_insn ""
  [(set (match_operand:DF 0 "indexed_operand" "m")
	(match_operand:DF 1 "register_operand" "f"))]
  ""
  "fst.d %1,%0")

(define_insn ""
  [(set (match_operand:SF 0 "indexed_operand" "m")
	(match_operand:SF 1 "register_operand" "f"))]
  ""
  "fst.l %1,%0")

;;- truncation instructions
(define_insn "truncsiqi2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(truncate:QI
	 (match_operand:SI 1 "register_operand" "r")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    if (CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
      {
	if (! ((cc_prev_status.flags & CC_KNOW_HI_R31)
	       && (cc_prev_status.flags & CC_HI_R31_ADJ)
	       && XEXP (operands[0], 0) == cc_prev_status.mdep))
	  {
	    cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
	    cc_status.mdep = XEXP (operands[0], 0);
	    output_asm_insn (\"orh ha%%%m0,r0,r31\", operands);
	  }
	return \"st.b %1,l%%%m0(r31)\";
      }
    else
      return \"st.b %1,%0\";
  return \"mov %1,%0\";
}")

(define_insn "trunchiqi2"
  [(set (match_operand:QI 0 "general_operand" "=g")
	(truncate:QI
	 (match_operand:HI 1 "register_operand" "r")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    if (CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
      {
	if (! ((cc_prev_status.flags & CC_KNOW_HI_R31)
	       && (cc_prev_status.flags & CC_HI_R31_ADJ)
	       && XEXP (operands[0], 0) == cc_prev_status.mdep))
	  {
	    cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
	    cc_status.mdep = XEXP (operands[0], 0);
	    output_asm_insn (\"orh ha%%%m0,r0,r31\", operands);
	  }
	return \"st.b %1,l%%%m0(r31)\";
      }
    else
      return \"st.b %1,%0\";
  return \"mov %1,%0\";
}")

(define_insn "truncsihi2"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(truncate:HI
	 (match_operand:SI 1 "register_operand" "r")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    if (CONSTANT_ADDRESS_P (XEXP (operands[0], 0)))
      {
	if (! ((cc_prev_status.flags & CC_KNOW_HI_R31)
	       && (cc_prev_status.flags & CC_HI_R31_ADJ)
	       && XEXP (operands[0], 0) == cc_prev_status.mdep))
	  {
	    cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
	    cc_status.mdep = XEXP (operands[0], 0);
	    output_asm_insn (\"orh ha%%%m0,r0,r31\", operands);
	  }
	return \"st.s %1,l%%%m0(r31)\";
      }
    else
      return \"st.s %1,%0\";
  return \"mov %1,%0\";
}")

;;- zero extension instructions

;; Note that the one starting from HImode comes before those for QImode
;; so that a constant operand will match HImode, not QImode.

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI
	 (match_operand:HI 1 "register_operand" "r")))]
  ""
  "and 0xffff,%1,%0")

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(zero_extend:HI
	 (match_operand:QI 1 "register_operand" "r")))]
  ""
  "and 0xff,%1,%0")

(define_insn "zero_extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(zero_extend:SI
	 (match_operand:QI 1 "register_operand" "r")))]
  ""
  "and 0xff,%1,%0")

;;- sign extension instructions
;; Note that the one starting from HImode comes before those for QImode
;; so that a constant operand will match HImode, not QImode.

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI
	 (match_operand:HI 1 "general_operand" "mr")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"shl 16,%1,%0\;shra 16,%0,%0\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  if (CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
    {
      cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
      cc_status.mdep = XEXP (operands[1], 0);
      return \"orh ha%%%m1,r0,r31\;ld.s l%%%m1(r31),%0\";
    }
  else
    return \"ld.s %1,%0\";
}")

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(sign_extend:HI
	 (match_operand:QI 1 "general_operand" "mr")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"shl 24,%1,%0\;shra 24,%0,%0\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  if (CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
    {
      cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
      cc_status.mdep = XEXP (operands[1], 0);
      return \"orh ha%%%m1,r0,r31\;ld.b l%%%m1(r31),%0\";
    }
  else
    return \"ld.b %1,%0\";
}")

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI
	 (match_operand:QI 1 "general_operand" "mr")))]
  ""
  "*
{
  if (REG_P (operands[1]))
    return \"shl 24,%1,%0\;shra 24,%0,%0\";
  if (GET_CODE (operands[1]) == CONST_INT)
    abort ();
  if (CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
    {
      cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
      cc_status.mdep = XEXP (operands[1], 0);
      return \"orh ha%%%m1,r0,r31\;ld.b l%%%m1(r31),%0\";
    }
  else
    return \"ld.b %1,%0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI
	 (match_operand:HI 1 "indexed_operand" "m")))]
  ""
  "ld.s %1,%0")

(define_insn ""
  [(set (match_operand:HI 0 "register_operand" "=r")
	(sign_extend:HI
	 (match_operand:QI 1 "indexed_operand" "m")))]
  ""
  "ld.b %1,%0")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(sign_extend:SI
	 (match_operand:QI 1 "indexed_operand" "m")))]
  ""
  "ld.b %1,%0")

;; Signed bitfield extractions come out looking like
;;	(shiftrt (sign_extend (shift <Y> <C1>)) <C2>)
;; which we expand poorly as four shift insns.
;; These patters yeild two shifts:
;;	(shiftrt (shift <Y> <C3>) <C4>)
(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashiftrt:SI
	 (sign_extend:SI
	  (match_operand:QI 1 "register_operand" "r"))
	 (match_operand:SI 2 "logic_int" "n")))]
  ""
  "*
{
  return \"shl 24,%1,%0\;shra 24+%2,%0,%0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashiftrt:SI
	 (sign_extend:SI
	  (subreg:QI (ashift:SI (match_operand:SI 1 "register_operand" "r")
				(match_operand:SI 2 "logic_int" "n")) 0))
	 (match_operand:SI 3 "logic_int" "n")))]
  ""
  "*
{
  return \"shl 0x18+%2,%1,%0\;shra 0x18+%3,%0,%0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashiftrt:SI
	 (sign_extend:SI
	  (ashift:QI (match_operand:QI 1 "register_operand" "r")
		     (match_operand:QI 2 "logic_int" "n")))
	 (match_operand:SI 3 "logic_int" "n")))]
  ""
  "*
{
  return \"shl 0x18+%2,%1,%0\;shra 0x18+%3,%0,%0\";
}")

;; Special patterns for optimizing bit-field instructions.

;; First two patterns are for bitfields that came from memory
;; testing only the high bit.  They work with old combiner.

(define_insn ""
  [(set (cc0)
	(eq (zero_extend:SI (subreg:QI (lshiftrt:SI (match_operand:SI 0 "register_operand" "r")
						    (const_int 7)) 0))
	    (const_int 0)))]
  ""
  "and 128,%0,r0")

(define_insn ""
  [(set (cc0)
	(eq (sign_extend:SI (subreg:QI (ashiftrt:SI (match_operand:SI 0 "register_operand" "r")
						    (const_int 7)) 0))
	    (const_int 0)))]
  ""
  "and 128,%0,r0")

;; next two patterns are good for bitfields coming from memory
;; (via pseudo-register) or from a register, though this optimization
;; is only good for values contained wholly within the bottom 13 bits
(define_insn ""
  [(set (cc0)
	(eq 
	 (and:SI (lshiftrt:SI (match_operand:SI 0 "register_operand" "r")
			      (match_operand:SI 1 "logic_int" "n"))
		 (match_operand:SI 2 "logic_int" "n"))
	 (const_int 0)))]
  "LOGIC_INTVAL (INTVAL (operands[2]) << INTVAL (operands[1]))"
  "*
{
  operands[2] = gen_rtx (CONST_INT, VOIDmode,
			 (INTVAL (operands[2]) << INTVAL (operands[1])));
  return \"and %2,%0,r0\";
}")

(define_insn ""
  [(set (cc0)
	(eq 
	 (and:SI (ashiftrt:SI (match_operand:SI 0 "register_operand" "r")
			      (match_operand:SI 1 "logic_int" "n"))
		 (match_operand:SI 2 "logic_int" "n"))
	 (const_int 0)))]
  "LOGIC_INTVAL (INTVAL (operands[2]) << INTVAL (operands[1]))"
  "*
{
  operands[2] = gen_rtx (CONST_INT, VOIDmode,
			 (INTVAL (operands[2]) << INTVAL (operands[1])));
  return \"and %2,%0,r0\";
}")

;; Conversions between float and double.

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(float_extend:DF
	 (match_operand:SF 1 "register_operand" "f")))]
  ""
  "fmov.sd %1,%0")

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(float_truncate:SF
	 (match_operand:DF 1 "register_operand" "f")))]
  ""
  "fmov.ds %1,%0")

;; Conversion between fixed point and floating point.
;; Note that among the fix-to-float insns
;; the ones that start with SImode come first.
;; That is so that an operand that is a CONST_INT
;; (and therefore lacks a specific machine mode).
;; will be recognized as SImode (which is always valid)
;; rather than as QImode or HImode.

;; This pattern forces (set (reg:SF ...) (float:SF (const_int ...)))
;; to be reloaded by putting the constant into memory.
;; It must come before the more general floatsisf2 pattern.
(define_expand "floatsidf2"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (xor:SI (match_operand:SI 1 "register_operand" "")
			      (const_int -2147483648)))
   (set (subreg:SI (match_dup 5) 1) (match_dup 4))
   (set (subreg:SI (match_dup 5) 0) (subreg:SI (match_dup 2) 0))
   (set (match_operand:DF 0 "register_operand" "")
	(minus:DF (match_dup 5) (match_dup 2)))]
  ""
  "
{
  /* Generate desired value, in float format of host machine.  */
  double d = (double) (1 << 30) * ((double) (1 << 22) + (double) (1 << 1));
  operands[2] = gen_reg_rtx (DFmode);
  operands[3] = immed_double_const (d, DFmode);
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = gen_reg_rtx (DFmode);
}")

;; Floating to fixed conversion.

(define_expand "fix_truncdfsi2"
  ;; This first insn produces a double-word value
  ;; in which only the low word is valid.
  [(set (match_dup 2)
	(fix:DI (fix:DF (match_operand:DF 1 "register_operand" "f"))))
   (set (match_operand:SI 0 "register_operand" "=f")
	(subreg:SI (match_dup 2) 0))]
  ""
  "
{
  operands[2] = gen_reg_rtx (DImode);
}")

;; Recognize the first insn generated above.
;; This RTL looks like a fix_truncdfdi2 insn,
;; but we dont call it that, because only 32 bits
;; of the result are valid.
;; This pattern will work for the intended purposes 
;; as long as we do not have any fixdfdi2 or fix_truncdfdi2.
(define_insn ""
  [(set (match_operand:DI 0 "register_operand" "=f")
	(fix:DI (fix:DF (match_operand:DF 1 "register_operand" "f"))))]
  ""
  "ftrunc.dd %1,%0")

(define_expand "fix_truncsfsi2"
  ;; This first insn produces a double-word value
  ;; in which only the low word is valid.
  [(set (match_dup 2)
	(fix:DI (fix:SF (match_operand:SF 1 "register_operand" "f"))))
   (set (match_operand:SI 0 "register_operand" "=f")
	(subreg:SI (match_dup 2) 0))]
  ""
  "
{
  operands[2] = gen_reg_rtx (DImode);
}")

;; Recognize the first insn generated above.
;; This RTL looks like a fix_truncsfdi2 insn,
;; but we dont call it that, because only 32 bits
;; of the result are valid.
;; This pattern will work for the intended purposes 
;; as long as we do not have any fixsfdi2 or fix_truncsfdi2.
(define_insn ""
  [(set (match_operand:DI 0 "register_operand" "=f")
	(fix:DI (fix:SF (match_operand:SF 1 "register_operand" "f"))))]
  ""
  "ftrunc.sd %1,%0")

;;- arithmetic instructions

(define_insn "addsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,*f")
	(plus:SI (match_operand:SI 1 "nonmemory_operand" "%r,*f")
		 (match_operand:SI 2 "nonmemory_operand" "rn,*f")))]
  ""
  "*
{
  if (which_alternative == 1)
    return \"fiadd.ss %2,%1,%0\";
  if (REG_P (operands[2]))
    return \"addu %2,%1,%0\";
  if (SMALL_INT (operands[2]))
    return \"addu %2,%1,%0\";
  cc_status.flags &= ~CC_KNOW_HI_R31;
  return \"orh h%%%2,r0,r31\;or l%%%2,r31,r31\;addu %1,r31,%0\";
}")

(define_insn "adddi3"
  [(set (match_operand:DI 0 "register_operand" "=f")
	(plus:DI (match_operand:DI 1 "register_operand" "%f")
		 (match_operand:DI 2 "register_operand" "f")))]
  ""
  "fiadd.ss %1,%2,%0")

(define_insn "subsi3"
  [(set (match_operand:SI 0 "register_operand" "=r,r,*f")
	(minus:SI (match_operand:SI 1 "register_operand" "r,I,*f")
		  (match_operand:SI 2 "nonmemory_operand" "rn,r,*f")))]
  ""
  "*
{
  if (which_alternative == 2)
    return \"fisub.ss %1,%2,%0\";
  if (REG_P (operands[2]))
    return \"subu %1,%2,%0\";
  if (SMALL_INT (operands[2]) && INTVAL (operands[2]) != -0x10000)
    {
      operands[2] = gen_rtx (CONST_INT, VOIDmode, - INTVAL (operands[2]));
      return \"addu %2,%1,%0\";
    }
  cc_status.flags &= ~CC_KNOW_HI_R31;
  return \"orh h%%%2,r0,r31\;or l%%%2,r31,r31\;sub %1,r31,%0\";
}")

(define_insn "subdi3"
  [(set (match_operand:DI 0 "register_operand" "=f")
	(minus:DI (match_operand:DI 1 "register_operand" "%f")
		  (match_operand:DI 2 "register_operand" "f")))]
  ""
  "fisub.ss %1,%2,%0")

(define_expand "mulsi3"
  [(set (subreg:SI (match_dup 4) 0) (match_operand:SI 1 "general_operand" ""))
   (set (subreg:SI (match_dup 5) 0) (match_operand:SI 2 "general_operand" ""))
   (clobber (match_dup 3))
   (set (subreg:SI (match_dup 3) 0)
	(mult:SI (subreg:SI (match_dup 4) 0) (subreg:SI (match_dup 5) 0)))
   (set (match_operand:SI 0 "register_operand" "") (subreg:SI (match_dup 3) 0))]
  ""
  "
{
  operands[3] = gen_reg_rtx (DImode);
  operands[4] = gen_reg_rtx (DImode);
  operands[5] = gen_reg_rtx (DImode);
}")

(define_insn ""
  [(set (subreg:SI (match_operand:DI 0 "register_operand" "=f") 0)
	(mult:SI (subreg:SI (match_operand:DI 1 "register_operand" "f") 0)
		 (subreg:SI (match_operand:DI 2 "register_operand" "f") 0)))]
  ""
  "fmlow.dd %2,%1,%0")

;;- and instructions (with compliment also)			   
(define_insn "andsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(and:SI (match_operand:SI 1 "nonmemory_operand" "%r")
		(match_operand:SI 2 "nonmemory_operand" "rn")))]
  ""
  "*
{
  rtx xop[3];

  if (REG_P (operands[2]) || LOGIC_INT (operands[2]))
    return \"and %2,%1,%0\";
  if ((INTVAL (operands[2]) & 0xffff) == 0)
    {
      operands[2] = gen_rtx (CONST_INT, VOIDmode, 
			     (unsigned) INTVAL (operands[2]) >> 16);
      return \"andh %2,%1,%0\";
    }
  xop[0] = operands[0];
  xop[1] = operands[1];
  xop[2] = gen_rtx (CONST_INT, VOIDmode, ~(INTVAL (operands[2]) & 0xffff));
  output_asm_insn (\"andnot %2,%1,%0\", xop);
  operands[2] = gen_rtx (CONST_INT, VOIDmode, 
			 ~(unsigned) INTVAL (operands[2]) >> 16);
  return \"andnoth %2,%0,%0\";
}")

(define_insn "andcbsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(and:SI (match_operand:SI 1 "register_operand" "r")
		(not:SI (match_operand:SI 2 "register_operand" "rn"))))]
  ""
  "*
{
  rtx xop[3];

  if (REG_P (operands[2]) || LOGIC_INT (operands[2]))
    return \"andnot %2,%1,%0\";
  if ((INTVAL (operands[2]) & 0xffff) == 0)
    {
      operands[2] = gen_rtx (CONST_INT, VOIDmode, 
			     (unsigned) INTVAL (operands[2]) >> 16);
      return \"andnoth %2,%1,%0\";
    }
  xop[0] = operands[0];
  xop[1] = operands[1];
  xop[2] = gen_rtx (CONST_INT, VOIDmode, (INTVAL (operands[2]) & 0xffff));
  output_asm_insn (\"andnot %2,%1,%0\", xop);
  operands[2] = gen_rtx (CONST_INT, VOIDmode, 
			 (unsigned) INTVAL (operands[2]) >> 16);
  return \"andnoth %2,%0,%0\";
}")

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ior:SI (match_operand:SI 1 "nonmemory_operand" "%r")
		(match_operand:SI 2 "nonmemory_operand" "rn")))]
  ""
  "*
{
  rtx xop[3];

  if (REG_P (operands[2]) || LOGIC_INT (operands[2]))
    return \"or %2,%1,%0\";
  if ((INTVAL (operands[2]) & 0xffff) == 0)
    {
      operands[2] = gen_rtx (CONST_INT, VOIDmode, 
			     (unsigned) INTVAL (operands[2]) >> 16);
      return \"orh %2,%1,%0\";
    }
  xop[0] = operands[0];
  xop[1] = operands[1];
  xop[2] = gen_rtx (CONST_INT, VOIDmode, (INTVAL (operands[2]) & 0xffff));
  output_asm_insn (\"or %2,%1,%0\", xop);
  operands[2] = gen_rtx (CONST_INT, VOIDmode, 
			 (unsigned) INTVAL (operands[2]) >> 16);
  return \"orh %2,%0,%0\";
}")

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(xor:SI (match_operand:SI 1 "nonmemory_operand" "%r")
		(match_operand:SI 2 "nonmemory_operand" "rn")))]
  ""
  "*
{
  rtx xop[3];

  if (REG_P (operands[2]) || LOGIC_INT (operands[2]))
    return \"xor %2,%1,%0\";
  if ((INTVAL (operands[2]) & 0xffff) == 0)
    {
      operands[2] = gen_rtx (CONST_INT, VOIDmode, 
			     (unsigned) INTVAL (operands[2]) >> 16);
      return \"xorh %2,%1,%0\";
    }
  xop[0] = operands[0];
  xop[1] = operands[1];
  xop[2] = gen_rtx (CONST_INT, VOIDmode, (INTVAL (operands[2]) & 0xffff));
  output_asm_insn (\"xor %2,%1,%0\", xop);
  operands[2] = gen_rtx (CONST_INT, VOIDmode, 
			 (unsigned) INTVAL (operands[2]) >> 16);
  return \"xorh %2,%0,%0\";
}")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "general_operand" "=r")
	(neg:SI (match_operand:SI 1 "arith_operand" "rI")))]
  ""
  "subu r0,%1,%0")

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "general_operand" "=r")
	(not:SI (match_operand:SI 1 "arith_operand" "r")))]
  ""
  "subu -1,%1,%0")

;; Floating point arithmetic instructions.

(define_insn "adddf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(plus:DF (match_operand:DF 1 "register_operand" "f")
		 (match_operand:DF 2 "register_operand" "f")))]
  ""
  "fadd.dd %1,%2,%0")

(define_insn "addsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(plus:SF (match_operand:SF 1 "register_operand" "f")
		 (match_operand:SF 2 "register_operand" "f")))]
  ""
  "fadd.ss %1,%2,%0")

(define_insn "subdf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(minus:DF (match_operand:DF 1 "register_operand" "f")
		  (match_operand:DF 2 "register_operand" "f")))]
  ""
  "fsub.dd %1,%2,%0")

(define_insn "subsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(minus:SF (match_operand:SF 1 "register_operand" "f")
		  (match_operand:SF 2 "register_operand" "f")))]
  ""
  "fsub.ss %1,%2,%0")

(define_insn "muldf3"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(mult:DF (match_operand:DF 1 "register_operand" "f")
		 (match_operand:DF 2 "register_operand" "f")))]
  ""
  "fmul.dd %1,%2,%0")

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(mult:SF (match_operand:SF 1 "register_operand" "f")
		 (match_operand:SF 2 "register_operand" "f")))]
  ""
  "fmul.ss %1,%2,%0")

(define_insn "negdf2"
  [(set (match_operand:DF 0 "register_operand" "=f")
	(neg:DF (match_operand:DF 1 "register_operand" "f")))]
  ""
  "fsub.dd f0,%1,%0")

(define_insn "negsf2"
  [(set (match_operand:SF 0 "register_operand" "=f")
	(neg:SF (match_operand:SF 1 "register_operand" "f")))]
  ""
  "fsub.ss f0,%1,%0")

;; Shift instructions

;; Optimized special case of shifting.
;; Must precede the general case.

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "*
{
  if (CONSTANT_ADDRESS_P (XEXP (operands[1], 0)))
    {
      cc_status.flags |= CC_KNOW_HI_R31 | CC_HI_R31_ADJ;
      cc_status.mdep = XEXP (operands[1], 0);
      return \"orh ha%%%m1,r0,r31\;ld.b l%%%m1(r31),%0\";
    }
  return \"ld.b %1,%0\";
}")


;;- arithmetic shift instructions
(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashift:SI (match_operand:SI 1 "register_operand" "r")
		   (match_operand:SI 2 "nonmemory_operand" "rn")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) >= 32)
    return \"mov r0,%0\";
  return \"shl %2,%1,%0\";
}")

(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(ashift:HI (match_operand:HI 1 "register_operand" "r")
		   (match_operand:HI 2 "nonmemory_operand" "rn")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) >= 16)
    return \"mov r0,%0\";
  return \"shl %2,%1,%0\";
}")

(define_insn "ashlqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(ashift:QI (match_operand:QI 1 "register_operand" "r")
		   (match_operand:QI 2 "nonmemory_operand" "rn")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) >= 8)
    return \"mov r0,%0\";
  return \"shl %2,%1,%0\";
}")

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "register_operand" "r")
		     (match_operand:SI 2 "nonmemory_operand" "rn")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) >= 32)
    return \"shra 31,%1,%0\";
  return \"shra %2,%1,%0\";
}")

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "register_operand" "r")
		     (match_operand:SI 2 "nonmemory_operand" "rn")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) >= 32)
    return \"mov r0,%0\";
  return \"shr %2,%1,%0\";
}")

;; Unconditional and other jump instructions

(define_insn "jump"
  [(set (pc) (label_ref (match_operand 0 "" "")))]
  ""
  "*
{
  return \"br %l0\;nop\";
}")

;; Here are two simple peepholes which fill the delay slot of
;; an unconditional branch.

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=rf")
	(match_operand:SI 1 "single_insn_src_p" "p"))
   (set (pc) (label_ref (match_operand 2 "" "")))]
  ""
  "* return output_delayed_branch (\"br %l2\", operands, insn);")

(define_peephole
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(match_operand:SI 1 "reg_or_0_operand" "rfJ"))
   (set (pc) (label_ref (match_operand 2 "" "")))]
  ""
  "* return output_delayed_branch (\"br %l2\", operands, insn);")

(define_insn "tablejump"
  [(set (pc) (match_operand:SI 0 "register_operand" "r"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "bri %0\;nop")

(define_peephole
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(match_operand:SI 1 "reg_or_0_operand" "rfJ"))
   (set (pc) (match_operand:SI 2 "register_operand" "r"))
   (use (label_ref (match_operand 3 "" "")))]
  ""
  "* return output_delayed_branch (\"bri %2\", operands, insn);")

;;- jump to subroutine
(define_expand "call"
  [(call (match_operand:SI 0 "memory_operand" "m")
	 (match_operand 1 "" "i"))]
  ;; operand[2] is next_arg_register
  ""
  "
{
  if (INTVAL (operands[1]) > 0)
    {
      emit_move_insn (arg_pointer_rtx, stack_pointer_rtx);
      emit_insn (gen_rtx (USE, VOIDmode, arg_pointer_rtx));
    }
}")

;;- jump to subroutine
(define_insn ""
  [(call (match_operand:SI 0 "memory_operand" "m")
	 (match_operand 1 "" "i"))]
  ;; operand[2] is next_arg_register
  ""
  "*
{
  /* strip the MEM.  */
  operands[0] = XEXP (operands[0], 0);
  CC_STATUS_INIT;
  if (GET_CODE (operands[0]) == REG)
    return \"calli %0\;nop\";
  return \"call %0\;nop\";
}")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=rf")
	(match_operand:SI 1 "single_insn_src_p" "p"))
   (call (match_operand:SI 2 "memory_operand" "m")
	 (match_operand 3 "" "i"))]
  ;;- Don't use operand 1 for most machines.
  "! reg_mentioned_p (operands[0], operands[2])"
  "*
{
  /* strip the MEM.  */
  operands[2] = XEXP (operands[2], 0);
  if (GET_CODE (operands[2]) == REG)
    return output_delayed_branch (\"calli %2\", operands, insn);
  return output_delayed_branch (\"call %2\", operands, insn);
}")

(define_peephole
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(match_operand:SI 1 "reg_or_0_operand" "rfJ"))
   (call (match_operand:SI 2 "memory_operand" "m")
	 (match_operand 3 "" "i"))]
  ;;- Don't use operand 1 for most machines.
  ""
  "*
{
  /* strip the MEM.  */
  operands[2] = XEXP (operands[2], 0);
  if (GET_CODE (operands[2]) == REG)
    return output_delayed_branch (\"calli %2\", operands, insn);
  return output_delayed_branch (\"call %2\", operands, insn);
}")

(define_expand "call_value"
  [(set (match_operand 0 "register_operand" "rf")
	(call (match_operand:SI 1 "memory_operand" "m")
	      (match_operand 2 "" "i")))]
  ;; operand 3 is next_arg_register
  ""
  "
{
  if (INTVAL (operands[2]) > 0)
    {
      emit_move_insn (arg_pointer_rtx, stack_pointer_rtx);
      emit_insn (gen_rtx (USE, VOIDmode, arg_pointer_rtx));
    }
}")

(define_insn ""
  [(set (match_operand 0 "register_operand" "=rf")
	(call (match_operand:SI 1 "memory_operand" "m")
	      (match_operand 2 "" "i")))]
  ;; operand 3 is next_arg_register
  ""
  "*
{
  /* strip the MEM.  */
  operands[1] = XEXP (operands[1], 0);
  CC_STATUS_INIT;
  if (GET_CODE (operands[1]) == REG)
    return \"calli %1\;nop\";
  return \"call %1\;nop\";
}")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=rf")
	(match_operand:SI 1 "single_insn_src_p" "p"))
   (set (match_operand 2 "" "=rf")
	(call (match_operand:SI 3 "memory_operand" "m")
	      (match_operand 4 "" "i")))]
  ;;- Don't use operand 4 for most machines.
  "! reg_mentioned_p (operands[0], operands[3])"
  "*
{
  /* strip the MEM.  */
  operands[3] = XEXP (operands[3], 0);
  if (GET_CODE (operands[3]) == REG)
    return output_delayed_branch (\"calli %3\", operands, insn);
  return output_delayed_branch (\"call %3\", operands, insn);
}")

(define_peephole
  [(set (match_operand:SI 0 "memory_operand" "=m")
	(match_operand:SI 1 "reg_or_0_operand" "rJf"))
   (set (match_operand 2 "" "=rf")
	(call (match_operand:SI 3 "memory_operand" "m")
	      (match_operand 4 "" "i")))]
  ;;- Don't use operand 4 for most machines.
  ""
  "*
{
  /* strip the MEM.  */
  operands[3] = XEXP (operands[3], 0);
  if (GET_CODE (operands[3]) == REG)
    return output_delayed_branch (\"calli %3\", operands, insn);
  return output_delayed_branch (\"call %3\", operands, insn);
}")

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "r")
	(mem:SI (plus:SI (match_operand:SI 1 "register_operand" "r")
			 (label_ref (match_operand 2 "" "")))))]
  ""
  "*
{
  cc_status.flags = 0;
  return \"mov %l2,r31\;ld.l r31(%1),%0\";
}")
  
(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=rf")
	(match_operand:SI 1 "single_insn_src_p" "p"))
   (set (pc) (match_operand:SI 2 "register_operand" "r"))
   (use (label_ref (match_operand 3 "" "")))]
  "REGNO (operands[0]) != REGNO (operands[2])"
  "* return output_delayed_branch (\"bri %2\", operands, insn);")

;;- Local variables:
;;- mode:emacs-lisp
;;- comment-start: ";;- "
;;- eval: (set-syntax-table (copy-sequence (syntax-table)))
;;- eval: (modify-syntax-entry ?[ "(]")
;;- eval: (modify-syntax-entry ?] ")[")
;;- eval: (modify-syntax-entry ?{ "(}")
;;- eval: (modify-syntax-entry ?} "){")
;;- End:

