unsigned long int
random_bitstring ()
{
  unsigned long int x;
  int ran, n_bits;

  x = 0;
  for (;;)
    {
      ran = random ();
      n_bits = (ran >> 1) % 32;

      if (n_bits == 0)
	return x;
      else
	{
	  /* Would we get a too large result in the shift?  */
	  if ((x >> (32 - n_bits)) != 0)
	    return x;

	  x <<= n_bits;
	  if (ran & 1)
	    x |= (1 << n_bits) - 1;
	}
    }
}

#ifndef FOO
void *malloc ();

main (argc, argv)
     int argc;
     char **argv;
{
  int i;
  unsigned long int cnst;

  printf ("foo (t)\n");
  printf ("     unsigned long int *t;\n");
  printf ("{\n");
  printf ("  unsigned long int i, cnst;\n");

  for (i = 0; i < NCONSTS; i++)
    {
      cnst = random_bitstring ();
      printf ("  t[%d]=0x%x;\n", i, cnst);
    }

  printf ("  for (i = 0; i < %d; i++)\n", NCONSTS);
  printf ("    {\n");
  printf ("      cnst = random_bitstring ();\n");
  printf ("      if (t[i] != cnst)\n");
  printf ("        {\n");
  printf ("          printf (\"error %%x stored as %%x\\n\", cnst, t[i]);\n");
  printf ("          abort ();\n");
  printf ("        }\n");
  printf ("    }\n");
  printf ("}\n");
  printf ("\n");
  printf ("main ()\n");
  printf ("{\n");
  printf ("  unsigned long int tab[%d];\n", NCONSTS);
  printf ("  foo (tab);\n");
  printf ("}\n");

  exit (0);
}
#endif
