unsigned long int
random_bitstring ()
{
  unsigned long int x;
  int ran, n_bits;

  x = 0;
  for (;;)
    {
      ran = random ();
      n_bits = (ran >> 1) % 32;

      if (n_bits == 0)
	return x;
      else
	{
	  /* Would we get a too large result in the shift?  */
	  if ((x >> (32 - n_bits)) != 0)
	    return x;

	  x <<= n_bits;
	  if (ran & 1)
	    x |= (1 << n_bits) - 1;
	}
    }
}

#ifndef NSWITCHES
#define NSWITCHES 10
#endif

#ifndef NCASES_MAX
#define NCASES_MAX 10
#endif

void *malloc ();

main (argc, argv)
     int argc;
     char **argv;
{
  int i;
  unsigned long int start, cnst, ncases, cases;

  for (i = 0; i < NSWITCHES; i++)
    {
      start = random_bitstring ();
      ncases = random () % NCASES_MAX;

      printf ("f%d (t,a) unsigned int t,a;\n", i);
      printf ("{\n");
      printf ("  if (a == 0) return 0x%08x;\n", start);
      printf ("  if (a == 1) return %d;\n", ncases);
      printf ("  switch (t)\n");
      printf ("    {\n");

      cnst = start;
      for (cases = 0; cases < ncases; cases++)
	{
	  printf ("    case 0x%08x:return 0x%08x;\n", cnst, ~cnst);
	  cnst++;
	}

      printf ("    }\n");
      printf ("  return 0;\n");
      printf ("}\n");

    }

  printf ("int (*ftab[])() =\n");
  printf ("  {\n");
  for (i = 0; i < NSWITCHES; i++)
    {
      printf ("    f%d,\n", i);
    }
  printf ("  };\n");

  printf ("main ()\n");
  printf ("{\n");
  printf ("  unsigned int i, ii, base, ncases;\n");
  printf ("  for (i = 0; i < %d; i++)\n", NSWITCHES);
  printf ("    {\n");
  printf ("      base = (ftab[i]) (0,0);\n", i);
  printf ("      ncases = (ftab[i]) (0,1);\n");
  printf ("      for (ii = 0; ii < ncases; ii++)\n");
  printf ("        if ((ftab[i]) (base + ii, 2) != ~(base + ii)) abort();\n");
  printf ("      if ((ftab[i]) (base + ncases, 2) != 0) abort();\n");
  printf ("      if ((ftab[i]) (base - 1, 2) != 0) abort();\n");
  printf ("    }\n");
  printf ("  exit (0);\n");
  printf ("}\n");

  exit (0);
}
