/*
** Copyright 1988 by Brown University, Providence, Rhode Island
** 
**                         All Rights Reserved
** 
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted,
** provided that the above copyright notice appear in all copies and that
** both that copyright notice and this permission notice appear in
** supporting documentation, and that the name of Brown University not be
** used in advertising or publicity pertaining to distribution of the
** software without specific, written prior permission.
** 
** BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
** SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
** FITNESS, IN NO EVENT SHALL BROWN BE LIABLE FOR ANY SPECIAL, INDIRECT
** OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
** OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
** OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
** OR PERFORMANCE OF THIS SOFTWARE.
**
*/
//For Gnu C++ (requires support for ANSI preprocessor string concatenator ##)
//By Page Starr, who has better things to do, and can maybe even do them now
// that this works
#ifndef generics_H
#define generics_H
  /*generic class macros: for #include-ing */
#include <generic.h>
#include <std.h>
#include <stddef.h>
  //the following two code clumps are to prevent preprocessor errors if
  //both Generics.h and generics.h are included
#ifndef _$DVEC
#define _$DVEC 1
#define Dvec(Type) GENERIC2(DvEc,Type)
#endif

#ifndef _$SET
#define _$SET 1
#define Set(Type) GENERIC2(SeT,Type)
#define NullSet(Type) GENERIC2(NuLlSeT,Type)
#endif

#ifndef _$PTR
#define _$PTR 1
#define Ptr(Type) GENERIC2(_$P,Type)
#endif

/* Dynamic vector generic code
For type Foo, a class Dvec(Foo) is declared by the following:
      Dvecdeclare(Foo, Num)
where Num is the default size of the array
WARNING: do not use a default size of zero

A class Set(Foo) is externally declared by the following:
      exDvecdeclare(Foo)

To declare a dynamic array of type Foo, the following are acceptable:
      Dvec(Foo) bar;	 // the initial size of this array is the default (Num)
      Dvec(Foo) bar(20);          // the initial size of this array is 20
	
Dvec(Foo) bar = kludge;     // kludge is of type Dvec(Foo)
	Dvec(Foo) bar(vec,20);      // vec is a twenty Foo element vector

Examples using dynamic arrays bar and kludge of type Dvec(int):
	for (long i=0; i< bar.size(); i++)
	// bar.size() returns the size of the array
	bar[i] = i;		

	int crunch[] = bar;
	// we define casts from Dvec(Foo) to Foo[]

	Dvec(int) sum;
	for (long i=0; i< (bar.max > kludge.max)? kludge.max : bar.max; i++)
		sum[i] = bar.val[i] + kludge.val[i];
	// direct access is a bit faster
*/

#define exDvecdeclare(Type)                                                   \
/* Type is the type of the array element*/                                    \
/* initialization size */                                                     \
/* Note: NEVER use the double slash comment convention in macro definitions */\
  typedef Type *Ptr(Type);						      \
									      \
extern class Dvec(Type) {                                                     \
  long alloc;	   /* size of array allocated */			      \
  long sz;                                                                    \
public:                                       				      \
  long size(void);						              \
  Ptr(Type) val;       /* ptr to array of Type*/           		      \
  /* val is public since a direct access to the array is quicker */ 	      \
  /* except for bounds checking, one only really has to use the  */  	      \
  /* operator[] for lvalue expressions				  */ 	      \
									      \
									      \
  Dvec(Type)(long);							      \
  Dvec(Type)(Dvec(Type) &);						      \
  Dvec(Type)(Type [],long);						      \
  ~Dvec(Type)();							      \
			                              			      \
  Type& operator[](long);                                                     \
  Dvec(Type) operator=(Dvec(Type) operand);                                   \
  operator Ptr(Type)();							      \
};                                                                            \
									      \
/* end of exDvec macro: have fun reading cpp output of a Dvec declaration     \


/* Set generic code
For type Foo, a class Set(Foo) is declared by the following:
	Dvecdeclare(Foo,Num)   //if you haven't declared a dvec for Foo already
	Setdeclare(Foo)

A class Set(Foo) is externally declared by the following:
        exSetdeclare(Foo)

To declare a set of type Foo, the following are acceptable:
	Set(Foo) bar;		// Sets are initially empty
	Set(Foo) bar = bent;	// bent is a set

Examples using sets bar and kludge with integer elements:
	bar = bar + 3 + 4;	// union of bar and the elements 3 and 4
        bar = bar - 3 - 4;      // difference of bar and the set {3,4}
                                // (NOT equivalent to bar - (3 + 4) )

	bar = bar * kludge;	// intersection of bar and kludge
	if (bar == NullSet(int))// logical equivalence
	                        // NullSet predefined for your convenience
	 cout << "Equivalent sets";
	if (bar != kludge)	// logical inequivalence
	 cout << "Sets not equivalent"
	if (2 ^ bar)		// set membership
	 cout << "2 is a member of bar";
	for (i=0; i<bar.size(); i++)   // set enumeration
	 cout << bar[i] << "is in the set \n";
				// NOTE: operator[] does not allow lvalues
        Dvec(int) crunch = bar; // casts available for Set->Dvec and Set->vec
	int crunch2[] = bar;
*/

#define exSetdeclare(Type)                                                    \
extern class Set(Type) {                                                      \
   Dvec(Type) Set;			/*The actual storage */		      \
  public:                                                                     \
   long size(void);							      \
   Set(Type)();								      \
   Set(Type)(Set(Type) &);						      \
   Set(Type) operator+(Set(Type));                                            \
   Set(Type) operator+(Type);                                                 \
   Set(Type) operator-(Set(Type));                                            \
   Set(Type) operator-(Type);                                                 \
   Set(Type) operator*(Set(Type));                                            \
   int operator==(Set(Type));				     	     	      \
   int operator!=( Set(Type));						      \
   friend operator^(Type,Set(Type));					      \
   Type operator[](long);						      \
   operator Dvec(Type)();						      \
   operator Ptr(Type)();						      \
   Set(Type) operator=(Set(Type));					      \
 };           	                                                              \
									      \
extern Set(Type) NullSet(Type);                                               \
/* end of Set definition macro */					      \

#endif
