#!/bin/sh
# shell script for generating classes from prototypes
#
# usage: genclass [-2] type1 {ref, val} [type2 {ref, val}] proto 


# search in standard g++ prototype directory & in current

PROTODIR=/usr/local/lib/g++-include
CURRENTDIR=`pwd`

N=""
T2=""
T2ACC=""

case $1 in
 -2) N="2"; shift;;
  *) ;;
esac

T1=$1;
T1NAME=$T1.;

case $2 in
 ref) T1ACC="\&";;
 val) T1ACC=" ";;
 *)   echo "Must specify type1 access: ref or val"; exit 1;;
esac

case $N in
 2) T2=$3;
    T2NAME=$T2.;
    case $4 in
     ref) T2ACC="\&";;
     val) T2ACC=" ";;
     *)   echo "Must specify type2 access: ref or val"; exit 1;;
    esac;
    CLASS=$5;;
 *) CLASS=$3;;
esac

# .h and .cc parts done separately in case only a .h

HSRC=$CLASS.hP
HOUT=$T1NAME$T2NAME$CLASS.h

if   test -f $CURRENTDIR/$HSRC
then HSRC=$CURRENTDIR/$HSRC
elif test -f $PROTODIR/$HSRC
then HSRC=$PROTODIR/$HSRC
else echo "genclass: $HSRC: no such file"; exit 1;
fi

sed < $HSRC > $HOUT -e "s/<T>/$T1/g" -e "s/<T&>/$T1$T1ACC/g" -e "s/<C>/$T2/g" -e "s/<C&>/$T2$T2ACC/g"

CCSRC=$CLASS.ccP
CCOUT=$T1NAME$T2NAME$CLASS.cc

if   test -f $CURRENTDIR/$CCSRC
then CCSRC=$CURRENTDIR/$CCSRC
elif test -f $PROTODIR/$CCSRC
then CCSRC=$PROTODIR/$CCSRC
else echo "genclass warning: class has a .h but no .cc file"; exit 0;
fi

sed < $CCSRC > $CCOUT -e "s/<T>/$T1/g" -e "s/<T&>/$T1$T1ACC/g" -e "s/<C>/$T2/g" -e "s/<C&>/$T2$T2ACC/g"
