/* mcparameters.h -- This file is part of Archimedes release 0.0.1.
   Archimedes is a simulator for Submicron 2D Silicon
   Devices. It implements the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method.

   Copyright (C) 2004 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// ######################################################
// Created on 05 sep.2004, Siracusa, J.M.Sellier
// Last modif. : 07 Oct.2004, Siracusa, J.M.Sellier
// ######################################################

// Definition of the variables needed for taking into
// account scatterings from acoustic and optical,non-polar
// phonons (which are the most relevant scatterings in Silicon)

void
MCparameters(void)
{
 real wo,no,dos,aco,oge[7],oga[7];
 real initialenergy,sei,finalenergy,sef;
 int ie,i;

 ISEED = 38467.;  //  initial value for random number generator

 BKTQ=KB*TL/Q; // in eV
 QH=Q/HBAR;
 SMH=sqrt(2.*mstar*M*Q)/HBAR;
 HHM=HBAR*HBAR/(2.*mstar*M*Q);
 HM=HBAR/(mstar*M);
// Density of states
 dos=pow((sqrt(2.*mstar*M)*sqrt(Q)/HBAR),3.)/(4.*PI*PI);
// constant for the acoustic phonon
 aco=2.*PI*(SiDA/Q)*SiDA*(BKTQ/HBAR)*(Q/(SiRHO*UL*UL));
// Constants for the 6 Silicon non-polar optical phonons
 for(i=1;i<=6;i++){
// i-th Optical Phonon
   wo=SiHWO[i-1]*Q/HBAR; // frequency of phonon
   no=1./(exp(SiHWO[i-1]/BKTQ) - 1.); // population of phonons
   oge[i]=ZF[i-1]*PI*(SiDTK[i-1]*Q/wo)*((SiDTK[i-1]*Q/SiRHO)/Q)*(no+1.);
   oga[i]=oge[i]*no/(1.+no);
 }
// Calculation of scattering rates
 for(ie=1; ie<=DIME; ++ie) SWK[0][ie]=0.;
 for(ie=1; ie<=DIME; ++ie){
   initialenergy=DE*((real) ie);
   sei=sqrt(initialenergy);
// non polar optical phonons
   for(i=1;i<=6;i++){
     finalenergy=initialenergy-SiHWO[i-1];
     SWK[i*2-1][ie]=SWK[i*2-2][ie];
     if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+alphaSILICON*finalenergy));
      SWK[i*2-1][ie]=SWK[i*2-2][ie]
                    +oge[i]*sef*dos*(1.+2.*alphaSILICON*finalenergy);
     }
     finalenergy=initialenergy+SiHWO[i-1];
     SWK[i*2][ie]=SWK[i*2-1][ie];
     if(finalenergy>0.){
      sef=sqrt(finalenergy*(1.+alphaSILICON*finalenergy));
      SWK[i*2][ie]=SWK[i*2-1][ie]
                  +oga[i]*sef*dos*(1.+2.*alphaSILICON*finalenergy);
     }
   }
// Acoustic phonon
   finalenergy=initialenergy;
   sef=sqrt(finalenergy*(1.+alphaSILICON*finalenergy));
   SWK[13][ie]=SWK[12][ie]+aco*sef*dos*(1.+2.*alphaSILICON*finalenergy);
  }

// Evaluation of gamma
  GM=SWK[13][1];
  for(ie=1;ie<=DIME;++ie)
    if(SWK[13][ie]>GM) GM=SWK[13][ie];
  printf("GAMMA = %g \n", GM);
  for(ie=1;ie<=DIME;ie++)
    for(i=1;i<=13;i++)
      SWK[i][ie]/=GM;
}

// =======================================================
