/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (directive.h)
 *  
 *  It has been AutoGen-ed  Tuesday May 18, 2004 at 08:49:07 PM PDT
 *  From the definitions    directive.def
 *  and the template file   directive
 *
 *  copyright 1992-2004 Bruce Korb
 *
 *  AutoGen is free software.
 *  
 *  You may redistribute it and/or modify it under the terms of the
 *  GNU General Public License, as published by the Free Software
 *  Foundation; either version 2, or (at your option) any later version.
 *  
 *  AutoGen is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with AutoGen.  See the file "COPYING".  If not,
 *  write to:  The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 */
#ifndef DIRECTIVE_DIRECTIVE_H_GUARD
#define DIRECTIVE_DIRECTIVE_H_GUARD
#ifdef DEFINING

typedef char* (tDirProc)( char* pzArg, char* pzScan );

typedef struct dir_table tDirTable;
struct dir_table {
    size_t      nameSize;
    tCC*        pzDirName;
    tDirProc*   pDirProc;
    int         unused;
};

/*
 *  Declare the procedures that will handle the directives
 */
static tDirProc doDir_IGNORE;
static tDirProc doDir_define;
static tDirProc doDir_elif;
static tDirProc doDir_else;
static tDirProc doDir_endif;
static tDirProc doDir_endshell;
static tDirProc doDir_error;
static tDirProc doDir_if;
static tDirProc doDir_ifdef;
static tDirProc doDir_ifndef;
static tDirProc doDir_include;
static tDirProc doDir_line;
static tDirProc doDir_option;
static tDirProc doDir_shell;
static tDirProc doDir_undef;

/*
 *  Define the constant string names for each directive
 */
static const char zAssert[]     = "assert";
static const char zDefine[]     = "define";
static const char zElif[]       = "elif";
static const char zElse[]       = "else";
static const char zEndif[]      = "endif";
static const char zEndshell[]   = "endshell";
static const char zError[]      = "error";
static const char zIdent[]      = "ident";
static const char zIf[]         = "if";
static const char zIfdef[]      = "ifdef";
static const char zIfndef[]     = "ifndef";
static const char zInclude[]    = "include";
static const char zLine[]       = "line";
static const char zOption[]     = "option";
static const char zPragma[]     = "pragma";
static const char zShell[]      = "shell";
static const char zUndef[]      = "undef";

/*
 *  Enumerate the directives
 */
typedef enum {
    DIR_ASSERT,
    DIR_DEFINE,
    DIR_ELIF,
    DIR_ELSE,
    DIR_ENDIF,
    DIR_ENDSHELL,
    DIR_ERROR,
    DIR_IDENT,
    DIR_IF,
    DIR_IFDEF,
    DIR_IFNDEF,
    DIR_INCLUDE,
    DIR_LINE,
    DIR_OPTION,
    DIR_PRAGMA,
    DIR_SHELL,
    DIR_UNDEF
} teDirectives;

#define DIRECTIVE_CT  17
static tDirTable dirTable[ DIRECTIVE_CT ] = {
    { sizeof( zAssert )-1,   zAssert,   doDir_IGNORE,   0 },
    { sizeof( zDefine )-1,   zDefine,   doDir_define,   0 },
    { sizeof( zElif )-1,     zElif,     doDir_elif,     0 },
    { sizeof( zElse )-1,     zElse,     doDir_else,     0 },
    { sizeof( zEndif )-1,    zEndif,    doDir_endif,    0 },
    { sizeof( zEndshell )-1, zEndshell, doDir_endshell, 0 },
    { sizeof( zError )-1,    zError,    doDir_error,    0 },
    { sizeof( zIdent )-1,    zIdent,    doDir_IGNORE,   0 },
    { sizeof( zIf )-1,       zIf,       doDir_if,       0 },
    { sizeof( zIfdef )-1,    zIfdef,    doDir_ifdef,    0 },
    { sizeof( zIfndef )-1,   zIfndef,   doDir_ifndef,   0 },
    { sizeof( zInclude )-1,  zInclude,  doDir_include,  0 },
    { sizeof( zLine )-1,     zLine,     doDir_line,     0 },
    { sizeof( zOption )-1,   zOption,   doDir_option,   0 },
    { sizeof( zPragma )-1,   zPragma,   doDir_IGNORE,   0 },
    { sizeof( zShell )-1,    zShell,    doDir_shell,    0 },
    { sizeof( zUndef )-1,    zUndef,    doDir_undef,    0 } };

/*
 *  This text has been extracted from ./schemedef.scm
 */
#define SCHEME_INIT_FILE "directive.h"
#define SCHEME_INIT_LINE  131
tSCC zSchemeInit[] =
"(use-modules (ice-9 common-list))\n\
(define identifier?\n\
(lambda (x) (or (string? x) (symbol? x))))\n\
(define normalize-identifier\n\
(lambda (x)\n\
(if (string? x) (string->symbol x) x)))\n\
(define coerce->string\n\
(lambda (x)\n\
(let ((char->string (lambda (x) (make-string 1 x)))\n\
(coercable? (lambda (x)\n\
(or (string? x) (boolean? x) (char? x)\n\
(symbol? x) (list? x) (number? x)) )) )\n\
(if (not (coercable? x))\n\
(error \"Wrong type to coerce->string\" x))\n\
(cond\n\
((string? x)  (string-append\n\
(char->string #\\\") x (char->string #\\\")  ))\n\
((boolean? x) (if x \"#t\" \"#f\"))\n\
((char? x)    (char->string x))\n\
((number? x)  (number->string x))\n\
((symbol? x)  (symbol->string x))\n\
((list? x)    (if (every coercable? x)\n\
(apply string-append (map coerce->string x))  ))\n\
) ) ) )\n\
(define alist->autogen-def\n\
(lambda (lst . recursive)\n\
(if (null? recursive) (set! recursive #f)\n\
(set! recursive #t))\n\
(let ((res (if recursive \"{\\n\" \"\"))\n\
(list-nnul? (lambda (x) (and (list? x) (not (null? x))))))\n\
(do ((i lst (cdr i)))\n\
((null? i) (if recursive\n\
(string-append res \"}\")\n\
res))\n\
(let* ((kvpair (car i))\n\
(value (cdr kvpair))\n\
(value-is-alist (if (and (list-nnul? value)\n\
(list-nnul? (car value))\n\
(list-nnul? (caar value))\n\
(identifier? (caaar value)))\n\
#t #f)))\n\
(set! res (string-append res\n\
(coerce->string (normalize-identifier (car kvpair)))\n\
\" = \"\n\
(if value-is-alist\n\
(alist->autogen-def (car value) 1)\n\
(coerce->string (cdr kvpair)))\n\
\";\\n\"\n\
) ) ) ) ) )         )\n\
(define header-file  \"\")\n\
(define header-guard \"\")\n\
(define (make-header-guard hdr-pfx)\n\
(begin\n\
(set! header-file  (out-name))\n\
(set! header-guard (string-upcase! (string->c-name! (string-append\n\
(if (string? hdr-pfx) hdr-pfx \"HEADER\") \"_\" header-file \"_GUARD\"\n\
))))\n\
(sprintf \"#ifndef %1$s\\n#define %1$s\" header-guard)\n\
) )\n\
(define autogen-version \"5.6.2\")\n\
(define-macro (defined-as predicate symbol)\n\
`(and (defined? ',symbol) (,predicate ,symbol)))\n\
(define html-escape-encode (lambda (str)\n\
(string-substitute str\n\
'(\"&\"      \"<\"     \">\")\n\
'(\"&amp;\"  \"&lt;\"  \"&gt;\") ) ))\n\
(use-modules (ice-9 debug))\n\
(read-enable 'positions)";
#endif /* DEFINING */
#endif /* DIRECTIVE_DIRECTIVE_H_GUARD */
