/*
 * Copyright (C) 1999-2000 Free Software Foundation, Inc.
 * This file is part of the GNU LIBICONV Library.
 *
 * The GNU LIBICONV Library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The GNU LIBICONV Library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the GNU LIBICONV Library; see the file COPYING.LIB.
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place -
 * Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * CNS 11643-1986 plane 14 part 1
 */

static const unsigned short cns11643_3_2uni_page21[6147] = {
  /* 0x21 */
  0x4e28, 0x4e36, 0x4e3f, 0x4e85, 0x4e05, 0x4e04, 0x5182, 0x5196,
  0x5338, 0x5369, 0x53b6, 0x4e2a, 0x4e87, 0x4e49, 0x51e2, 0x4e46,
  0x4e8f, 0x4ebc, 0x4ebe, 0x5166, 0x51e3, 0x5204, 0x529c, 0xfffd,
  0x5902, 0x590a, 0x5b80, 0x5ddb, 0x5e7a, 0x5e7f, 0x5ef4, 0x5f50,
  0x5f51, 0x5f61, 0x961d, 0xfffd, 0x4e63, 0x4e62, 0x4ea3, 0x5185,
  0x4ec5, 0x4ecf, 0x4ece, 0x4ecc, 0x5184, 0x5186, 0xfffd, 0xfffd,
  0x51e4, 0x5205, 0x529e, 0x529d, 0x52fd, 0x5300, 0x533a, 0xfffd,
  0x5346, 0x535d, 0x5386, 0x53b7, 0xfffd, 0x53cc, 0xfffd, 0x53ce,
  0x5721, 0xfffd, 0x5e00, 0x5f0c, 0x6237, 0x6238, 0x6534, 0x6535,
  0x65e0, 0xfffd, 0x738d, 0x4e97, 0x4ee0, 0xfffd, 0xfffd, 0x4ee7,
  0xfffd, 0x4ee6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x56d8, 0x518b,
  0x518c, 0x5199, 0x51e5, 0xfffd, 0x520b, 0xfffd,
  /* 0x22 */
  0xfffd, 0x5304, 0x5303, 0x5307, 0xfffd, 0x531e, 0x535f, 0x536d,
  0x5389, 0x53ba, 0x53d0, 0xfffd, 0x53f6, 0x53f7, 0x53f9, 0xfffd,
  0x53f4, 0xfffd, 0xfffd, 0x5724, 0x5904, 0x5918, 0x5932, 0x5930,
  0x5934, 0xfffd, 0x5975, 0xfffd, 0x5b82, 0x5bf9, 0x5c14, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x5e81, 0x5e83,
  0x5f0d, 0x5f52, 0xfffd, 0x5fca, 0x5fc7, 0x6239, 0xfffd, 0x624f,
  0x65e7, 0x672f, 0x6b7a, 0x6c39, 0xfffd, 0xfffd, 0x6c37, 0x6c44,
  0x6c45, 0x738c, 0x7592, 0x7676, 0x9093, 0x9092, 0xfffd, 0xfffd,
  0x4e21, 0x4e20, 0x4e22, 0x4e68, 0x4e89, 0x4e98, 0x4ef9, 0x4eef,
  0xfffd, 0xfffd, 0x4ef8, 0x4f06, 0x4f03, 0x4efc, 0x4eee, 0x4f16,
  0xfffd, 0x4f28, 0x4f1c, 0x4f07, 0x4f1a, 0x4efa, 0x4f17, 0x514a,
  0xfffd, 0x5172, 0xfffd, 0x51b4, 0x51b3, 0x51b2,
  /* 0x23 */
  0xfffd, 0x51e8, 0xfffd, 0x5214, 0x520f, 0x5215, 0x5218, 0x52a8,
  0xfffd, 0x534b, 0x534f, 0xfffd, 0x5350, 0xfffd, 0x538b, 0xfffd,
  0x53be, 0xfffd, 0x53d2, 0x5416, 0x53ff, 0xfffd, 0x5400, 0xfffd,
  0x5405, 0x5413, 0x5415, 0xfffd, 0xfffd, 0x56e3, 0x5735, 0x5736,
  0x5731, 0x5732, 0x58ee, 0x5905, 0x4e54, 0xfffd, 0x5936, 0xfffd,
  0xfffd, 0xfffd, 0x597a, 0xfffd, 0x5986, 0xfffd, 0xfffd, 0x5b86,
  0x5f53, 0x5c18, 0xfffd, 0x5c3d, 0x5c78, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0x5c80, 0xfffd, 0x5e08, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x5ef5, 0x5f0e, 0xfffd, 0xfffd, 0xfffd, 0x5fd3, 0x5fda, 0xfffd,
  0x5fdb, 0xfffd, 0x620f, 0x625d, 0x625f, 0x6267, 0x6257, 0x9f50,
  0xfffd, 0x65eb, 0x65ea, 0xfffd, 0x6737, 0xfffd, 0x6732, 0x6736,
  0x6b22, 0x6bce, 0xfffd, 0x6c58, 0x6c51, 0x6c77,
  /* 0x24 */
  0x6c3c, 0xfffd, 0x6c5a, 0xfffd, 0x6c53, 0x706f, 0x7072, 0x706e,
  0xfffd, 0xfffd, 0x7073, 0x72b1, 0x72b2, 0xfffd, 0x738f, 0xfffd,
  0xfffd, 0xfffd, 0x793c, 0xfffd, 0x808d, 0x808e, 0xfffd, 0x827b,
  0xfffd, 0x8d71, 0x8fb9, 0x9096, 0x909a, 0xfffd, 0x4e24, 0x4e71,
  0xfffd, 0x4e9c, 0x4f45, 0x4f4a, 0x4f39, 0x4f37, 0xfffd, 0x4f32,
  0x4f42, 0xfffd, 0x4f44, 0x4f4b, 0xfffd, 0x4f40, 0x4f35, 0x4f31,
  0x5151, 0xfffd, 0x5150, 0x514e, 0xfffd, 0xfffd, 0x519d, 0xfffd,
  0x51b5, 0x51b8, 0x51ec, 0x5223, 0x5227, 0x5226, 0x521f, 0x522b,
  0x5220, 0x52b4, 0x52b3, 0xfffd, 0x5325, 0x533b, 0x5374, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x544d, 0xfffd, 0xfffd, 0x543a,
  0xfffd, 0xfffd, 0x5444, 0x544c, 0x5423, 0x541a, 0x5432, 0x544b,
  0x5421, 0xfffd, 0x5434, 0x5449, 0x5450, 0x5422,
  /* 0x25 */
  0x543f, 0x5451, 0x545a, 0x542f, 0xfffd, 0x56e9, 0x56f2, 0x56f3,
  0x56ef, 0x56ed, 0x56ec, 0x56e6, 0x5748, 0xfffd, 0x5744, 0x573f,
  0x573c, 0x5753, 0x5756, 0xfffd, 0x575f, 0x5743, 0x5758, 0x5757,
  0xfffd, 0xfffd, 0xfffd, 0x5746, 0xfffd, 0x573d, 0xfffd, 0x5742,
  0x5754, 0x5755, 0x58f1, 0x58f2, 0x58f0, 0x590b, 0x9ea6, 0x56f1,
  0x593d, 0xfffd, 0x5994, 0x598c, 0xfffd, 0x599c, 0xfffd, 0xfffd,
  0x599f, 0xfffd, 0x599b, 0xfffd, 0x5989, 0x599a, 0xfffd, 0x6588,
  0xfffd, 0x5b8d, 0xfffd, 0x5bfe, 0x5bff, 0x5bfd, 0x5c2b, 0xfffd,
  0x5c84, 0x5c8e, 0x5c9c, 0xfffd, 0xfffd, 0x5c85, 0x5df5, 0x5e09,
  0xfffd, 0xfffd, 0x5e0b, 0xfffd, 0x5e92, 0x5e90, 0x5f03, 0xfffd,
  0x5f1e, 0x5f63, 0xfffd, 0x5fe7, 0x5ffe, 0x5fe6, 0x5fdc, 0x5fce,
  0xfffd, 0x5ffc, 0x5fdf, 0x5fec, 0x5ff6, 0xfffd,
  /* 0x26 */
  0x5ff2, 0x5ff0, 0x5ff9, 0xfffd, 0x6213, 0xfffd, 0xfffd, 0x623b,
  0x623c, 0x6282, 0xfffd, 0xfffd, 0xfffd, 0x6278, 0x628b, 0xfffd,
  0x629e, 0x62a5, 0x629b, 0x629c, 0x6299, 0x628d, 0x6285, 0x629d,
  0x6275, 0xfffd, 0xfffd, 0xfffd, 0x65f6, 0xfffd, 0xfffd, 0xfffd,
  0x66f5, 0x675b, 0xfffd, 0x6754, 0x6752, 0xfffd, 0x6758, 0x6744,
  0x674a, 0x6761, 0xfffd, 0x6c7f, 0x6c91, 0x6c9e, 0xfffd, 0x6c6e,
  0x6c7c, 0x6c9f, 0x6c75, 0xfffd, 0x6c56, 0x6ca2, 0x6c79, 0xfffd,
  0x6ca1, 0xfffd, 0x6caa, 0x6ca0, 0xfffd, 0x7079, 0x7077, 0x707e,
  0xfffd, 0x7075, 0x707b, 0x7264, 0xfffd, 0x72bb, 0x72bc, 0x72c7,
  0x72b9, 0x72be, 0x72b6, 0xfffd, 0xfffd, 0x7398, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x7593, 0x7680, 0xfffd, 0x7683, 0x76c0, 0x76c1,
  0xfffd, 0xfffd, 0x77f4, 0x77f5, 0xfffd, 0x7acc,
  /* 0x27 */
  0x7acd, 0x7cfa, 0x809f, 0x8091, 0x8097, 0x8094, 0xfffd, 0x8286,
  0x828c, 0xfffd, 0x8295, 0xfffd, 0x866c, 0xfffd, 0x8fb5, 0x8fbe,
  0x8fc7, 0xfffd, 0x8fc1, 0x90a9, 0x90a4, 0xfffd, 0xfffd, 0xfffd,
  0x90a8, 0x9627, 0x9626, 0x962b, 0x9633, 0x9634, 0x9629, 0x4e3d,
  0xfffd, 0x4e9d, 0x4f93, 0x4f8a, 0xfffd, 0xfffd, 0x4f6d, 0x4f8e,
  0x4fa0, 0x4fa2, 0x4fa1, 0x4f9f, 0x4fa3, 0xfffd, 0x4f72, 0xfffd,
  0x4f8c, 0x5156, 0xfffd, 0xfffd, 0x5190, 0xfffd, 0xfffd, 0xfffd,
  0x51ed, 0x51fe, 0x522f, 0xfffd, 0x523c, 0x5234, 0x5239, 0x52b9,
  0x52b5, 0x52bf, 0x5355, 0xfffd, 0x5376, 0x537a, 0x5393, 0xfffd,
  0x53c1, 0x53c2, 0x53d5, 0x5485, 0xfffd, 0x545f, 0x5493, 0x5489,
  0x5479, 0x9efe, 0x548f, 0x5469, 0x546d, 0xfffd, 0x5494, 0x546a,
  0x548a, 0xfffd, 0x56fd, 0x56fb, 0x56f8, 0xfffd,
  /* 0x28 */
  0x56fc, 0x56f6, 0x5765, 0x5781, 0x5763, 0x5767, 0xfffd, 0x576e,
  0x5778, 0x577f, 0xfffd, 0xfffd, 0x58f3, 0x594b, 0x594c, 0xfffd,
  0xfffd, 0xfffd, 0x59ad, 0xfffd, 0x59c4, 0xfffd, 0x59c2, 0x59b0,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x59bf, 0xfffd, 0x59c9, 0x59b8,
  0x59ac, 0xfffd, 0xfffd, 0xfffd, 0x59b7, 0x59d7, 0xfffd, 0x5b60,
  0xfffd, 0x5b96, 0x5b9e, 0x5b94, 0x5b9f, 0x5b9d, 0xfffd, 0x5c00,
  0x5c19, 0xfffd, 0xfffd, 0x5c49, 0x5c4a, 0xfffd, 0x5cbb, 0x5cc1,
  0xfffd, 0xfffd, 0xfffd, 0x5cb9, 0x5c9e, 0x5cb4, 0x5cba, 0x5df6,
  0x5e13, 0x5e12, 0x5e77, 0xfffd, 0x5e98, 0xfffd, 0x5e99, 0x5e9d,
  0x5ef8, 0xfffd, 0x5ef9, 0xfffd, 0x5f06, 0x5f21, 0xfffd, 0x5f25,
  0x5f55, 0xfffd, 0xfffd, 0xfffd, 0x5f84, 0x5f83, 0x6030, 0x6007,
  0xfffd, 0x6036, 0xfffd, 0xfffd, 0xfffd, 0x5fe9,
  /* 0x29 */
  0x603d, 0x6008, 0xfffd, 0xfffd, 0x62ba, 0x62b2, 0xfffd, 0x62b7,
  0x62e4, 0x62a7, 0xfffd, 0xfffd, 0xfffd, 0x62d5, 0x62e1, 0x62dd,
  0x62a6, 0x62c1, 0x62c5, 0x62c0, 0x62df, 0x62e0, 0x62de, 0xfffd,
  0x6589, 0xfffd, 0x65a6, 0x65ba, 0xfffd, 0x65ff, 0xfffd, 0x6617,
  0x6618, 0x6601, 0x65fe, 0xfffd, 0x670c, 0xfffd, 0x676b, 0x6796,
  0x6782, 0x678a, 0xfffd, 0x67a3, 0xfffd, 0x67a2, 0x678f, 0xfffd,
  0x67f9, 0x6780, 0x6b26, 0x6b27, 0x6b68, 0x6b69, 0xfffd, 0x6b81,
  0x6bb4, 0x6bd1, 0xfffd, 0xfffd, 0x6c1c, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x6c97, 0x6c6c, 0x6cdf, 0xfffd, 0x6cea, 0xfffd,
  0x6ce4, 0x6cd8, 0x6cb2, 0x6cce, 0x6cc8, 0xfffd, 0x708b, 0x7088,
  0x7090, 0x708f, 0xfffd, 0x7087, 0x7089, 0x708d, 0x7081, 0xfffd,
  0x708c, 0xfffd, 0xfffd, 0x7240, 0xfffd, 0xfffd,
  /* 0x2a */
  0x7265, 0x7266, 0x7268, 0xfffd, 0xfffd, 0x72cd, 0x72d3, 0x72db,
  0xfffd, 0x72cf, 0x73a7, 0x73a3, 0x739e, 0xfffd, 0x73af, 0xfffd,
  0xfffd, 0x73aa, 0x739c, 0xfffd, 0x7542, 0x7544, 0x753b, 0x7541,
  0xfffd, 0x759b, 0x759e, 0xfffd, 0x79c4, 0x79c3, 0x79c6, 0xfffd,
  0xfffd, 0x79c7, 0xfffd, 0x79ca, 0xfffd, 0xfffd, 0x7acf, 0x7c76,
  0x7c74, 0x7cff, 0x7cfc, 0xfffd, 0xfffd, 0x7f59, 0x80a8, 0xfffd,
  0xfffd, 0x80b0, 0xfffd, 0x80b3, 0xfffd, 0x80a4, 0x80b6, 0x80a7,
  0x80ac, 0xfffd, 0x80a6, 0x5367, 0x820e, 0x82c4, 0x833e, 0x829c,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x82aa, 0xfffd, 0x82c9,
  0xfffd, 0xfffd, 0x82a6, 0x82b2, 0xfffd, 0xfffd, 0xfffd, 0x8fcc,
  0x8fd9, 0x8fca, 0x8fd8, 0x8fcf, 0x90b7, 0xfffd, 0x90ad, 0x90b9,
  0x9637, 0xfffd, 0x9641, 0x963e, 0x96b6, 0x9751,
  /* 0x2b */
  0x9763, 0x4e57, 0x4e79, 0x4eb2, 0x4eb0, 0x4eaf, 0x4eb1, 0x4fd2,
  0x4fd5, 0xfffd, 0x4fbe, 0x4fb8, 0x4fb0, 0x4fb1, 0x4fc8, 0xfffd,
  0xfffd, 0x4fc6, 0x4fcc, 0x4fe5, 0x4fe3, 0x4fb4, 0x516a, 0xfffd,
  0x519f, 0xfffd, 0x51c1, 0xfffd, 0x51c2, 0x51c3, 0x5245, 0x5248,
  0xfffd, 0xfffd, 0x524f, 0xfffd, 0xfffd, 0x52c5, 0x52ca, 0x52c4,
  0x5327, 0x5358, 0x537d, 0xfffd, 0x53dd, 0x53dc, 0x53da, 0x53d9,
  0x54b9, 0xfffd, 0x54d0, 0x54b4, 0x54ca, 0xfffd, 0x54a3, 0x54da,
  0x54a4, 0xfffd, 0x54b2, 0x549e, 0x549f, 0x54b5, 0xfffd, 0xfffd,
  0x54cd, 0xfffd, 0x54cc, 0xfffd, 0x5700, 0x57ac, 0x5791, 0x578e,
  0x578d, 0x5792, 0x57a1, 0x5790, 0x57a6, 0x57a8, 0xfffd, 0x579c,
  0x5796, 0x57a7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x58f5, 0xfffd,
  0x5909, 0x5908, 0xfffd, 0x5952, 0xfffd, 0xfffd,
  /* 0x2c */
  0x59df, 0xfffd, 0x59eb, 0x59ef, 0x59f0, 0x59d5, 0x5a0d, 0x5a04,
  0x59f9, 0x5a02, 0x59f8, 0x59e2, 0x59d9, 0x59e7, 0x5b6a, 0xfffd,
  0xfffd, 0x5bab, 0xfffd, 0x5c1b, 0x5c2f, 0xfffd, 0x663c, 0xfffd,
  0xfffd, 0xfffd, 0x5cd1, 0x5cdc, 0x5ce6, 0x5ce1, 0x5ccd, 0xfffd,
  0x5ce2, 0x5cdd, 0x5ce5, 0x5dfb, 0x5dfa, 0x5e1e, 0xfffd, 0x5ea1,
  0xfffd, 0xfffd, 0x5efc, 0x5efb, 0x5f2f, 0xfffd, 0xfffd, 0x5f66,
  0xfffd, 0xfffd, 0xfffd, 0x605c, 0xfffd, 0x604e, 0x6051, 0xfffd,
  0xfffd, 0x6023, 0x6031, 0x607c, 0x6052, 0xfffd, 0x6060, 0x604a,
  0x6061, 0xfffd, 0x6218, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x631f, 0x6317, 0x62ea, 0x6321, 0x6304, 0x6305,
  0xfffd, 0x6531, 0x6544, 0x6540, 0xfffd, 0x6542, 0x65be, 0xfffd,
  0x6629, 0x661b, 0xfffd, 0x6623, 0x662c, 0x661a,
  /* 0x2d */
  0x6630, 0x663b, 0x661e, 0x6637, 0x6638, 0xfffd, 0x670e, 0xfffd,
  0xfffd, 0x67e8, 0x67d6, 0xfffd, 0x67c7, 0x67bc, 0x6852, 0x67bf,
  0x67d5, 0x67fe, 0x8363, 0x67fb, 0xfffd, 0x67b1, 0x6801, 0x6805,
  0x6800, 0x67d7, 0xfffd, 0x6b2a, 0x6b6b, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0x6be1, 0xfffd, 0xfffd, 0x6d23, 0x6cff, 0x6d14, 0x6d05,
  0x6d13, 0x6d06, 0x6d21, 0xfffd, 0x6d15, 0x6caf, 0x6cf4, 0x6d02,
  0x6d45, 0xfffd, 0x6d26, 0xfffd, 0x6d44, 0xfffd, 0x6d24, 0x70a5,
  0xfffd, 0x70a3, 0xfffd, 0x70a2, 0x70bb, 0x70a0, 0x70aa, 0xfffd,
  0xfffd, 0x70a8, 0x70b6, 0x70b2, 0x70a7, 0xfffd, 0xfffd, 0x70b9,
  0x722e, 0xfffd, 0x723c, 0xfffd, 0x726d, 0xfffd, 0xfffd, 0x72e7,
  0x72ed, 0xfffd, 0x72ec, 0x72e5, 0x72e2, 0xfffd, 0x73c4, 0x73bd,
  0x73cf, 0x73c9, 0x73c1, 0x73d0, 0xfffd, 0x73ce,
  /* 0x2e */
  0x74ed, 0x74eb, 0xfffd, 0x74ef, 0x7549, 0x7550, 0x7546, 0x754a,
  0xfffd, 0x754d, 0x75a6, 0xfffd, 0xfffd, 0xfffd, 0x75a8, 0xfffd,
  0xfffd, 0x76c7, 0x76ff, 0xfffd, 0x76fd, 0x77e6, 0x780a, 0xfffd,
  0x7804, 0x780b, 0x7807, 0xfffd, 0x7815, 0x7808, 0xfffd, 0x79d3,
  0x79d4, 0x79d0, 0x79d7, 0x7a7c, 0xfffd, 0xfffd, 0x7a7d, 0x7a83,
  0x7a82, 0xfffd, 0x7ad4, 0x7ad5, 0x7ad3, 0x7ad0, 0x7ad2, 0x7afe,
  0x7afc, 0x7c77, 0x7c7c, 0x7c7b, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x7f8f, 0x80d3, 0xfffd, 0x80cb,
  0x80d2, 0xfffd, 0x8109, 0x80e2, 0x80df, 0x80c6, 0xfffd, 0x8224,
  0x82f7, 0x82d8, 0x82dd, 0xfffd, 0xfffd, 0x82f8, 0x82fc, 0xfffd,
  0xfffd, 0x82e9, 0xfffd, 0x82ee, 0xfffd, 0x82d0, 0x830e, 0x82e2,
  0x830b, 0x82fd, 0x5179, 0x8676, 0xfffd, 0x8678,
  /* 0x2f */
  0xfffd, 0xfffd, 0x8675, 0x867d, 0xfffd, 0x8842, 0x8866, 0xfffd,
  0x898c, 0x8a05, 0xfffd, 0x8a06, 0xfffd, 0x8c9f, 0xfffd, 0x8ff1,
  0x8fe7, 0x8fe9, 0x8fef, 0x90c2, 0x90bc, 0xfffd, 0x90c6, 0x90c0,
  0xfffd, 0xfffd, 0x90cd, 0x90c9, 0xfffd, 0x90c4, 0xfffd, 0x9581,
  0xfffd, 0x9cec, 0x5032, 0x4ff9, 0x501d, 0x4fff, 0x5004, 0x4ff0,
  0x5003, 0xfffd, 0x5002, 0x4ffc, 0x4ff2, 0x5024, 0x5008, 0x5036,
  0x502e, 0xfffd, 0x5010, 0x5038, 0x5039, 0x4ffd, 0x5056, 0x4ffb,
  0x51a3, 0x51a6, 0x51a1, 0xfffd, 0xfffd, 0x51c7, 0x51c9, 0x5260,
  0x5264, 0x5259, 0x5265, 0x5267, 0x5257, 0x5263, 0xfffd, 0x5253,
  0xfffd, 0x52cf, 0xfffd, 0x52ce, 0x52d0, 0x52d1, 0x52cc, 0xfffd,
  0xfffd, 0xfffd, 0x550d, 0x54f4, 0xfffd, 0x5513, 0x54ef, 0x54f5,
  0x54f9, 0x5502, 0x5500, 0xfffd, 0xfffd, 0x5518,
  /* 0x30 */
  0x54f0, 0x54f6, 0xfffd, 0xfffd, 0x5519, 0xfffd, 0x5705, 0x57c9,
  0xfffd, 0x57b7, 0x57cd, 0xfffd, 0xfffd, 0xfffd, 0x57be, 0x57bb,
  0xfffd, 0x57db, 0x57c8, 0x57c4, 0x57c5, 0x57d1, 0x57ca, 0x57c0,
  0xfffd, 0xfffd, 0x5a21, 0x5a2a, 0xfffd, 0x5a1d, 0xfffd, 0x5a0b,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x5a22, 0xfffd, 0xfffd, 0x5a24,
  0xfffd, 0x5a14, 0x5a31, 0xfffd, 0x5a2f, 0x5a1a, 0x5a12, 0xfffd,
  0xfffd, 0x5a26, 0xfffd, 0xfffd, 0x5bbc, 0x5bbb, 0x5bb7, 0x5c05,
  0x5c06, 0x5c52, 0x5c53, 0xfffd, 0xfffd, 0x5cfa, 0x5ceb, 0xfffd,
  0x5cf3, 0x5cf5, 0x5ce9, 0x5cef, 0xfffd, 0x5e2a, 0x5e30, 0x5e2e,
  0x5e2c, 0x5e2f, 0x5eaf, 0x5ea9, 0xfffd, 0x5efd, 0x5f32, 0x5f8e,
  0x5f93, 0x5f8f, 0x604f, 0x6099, 0xfffd, 0x607e, 0xfffd, 0x6074,
  0x604b, 0x6073, 0x6075, 0xfffd, 0xfffd, 0x6056,
  /* 0x31 */
  0x60a9, 0x608b, 0x60a6, 0xfffd, 0x6093, 0x60ae, 0x609e, 0x60a7,
  0x6245, 0xfffd, 0xfffd, 0x632e, 0xfffd, 0x6352, 0x6330, 0x635b,
  0xfffd, 0x6319, 0x631b, 0xfffd, 0x6331, 0x635d, 0x6337, 0x6335,
  0x6353, 0xfffd, 0x635c, 0x633f, 0x654b, 0xfffd, 0xfffd, 0x658b,
  0xfffd, 0x659a, 0x6650, 0x6646, 0x664e, 0x6640, 0xfffd, 0x664b,
  0x6648, 0xfffd, 0x6660, 0x6644, 0x664d, 0xfffd, 0x6837, 0x6824,
  0xfffd, 0xfffd, 0x681b, 0x6836, 0xfffd, 0x682c, 0x6819, 0x6856,
  0x6847, 0x683e, 0x681e, 0xfffd, 0x6815, 0x6822, 0x6827, 0x6859,
  0x6858, 0x6855, 0x6830, 0x6823, 0x6b2e, 0x6b2b, 0x6b30, 0x6b6c,
  0xfffd, 0x6b8b, 0xfffd, 0x6be9, 0x6bea, 0x6be5, 0x6d6b, 0xfffd,
  0xfffd, 0x6d73, 0x6d57, 0xfffd, 0xfffd, 0x6d5d, 0x6d56, 0x6d8f,
  0x6d5b, 0x6d1c, 0x6d9a, 0x6d9b, 0x6d99, 0xfffd,
  /* 0x32 */
  0x6d81, 0x6d71, 0xfffd, 0xfffd, 0x6d72, 0x6d5c, 0x6d96, 0x70c4,
  0x70db, 0x70cc, 0x70d0, 0x70e3, 0x70df, 0xfffd, 0x70d6, 0x70ee,
  0x70d5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x727a, 0xfffd, 0x72f5,
  0x7302, 0xfffd, 0xfffd, 0x73e2, 0x73ec, 0x73d5, 0x73f9, 0x73df,
  0x73e6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x73e4, 0x73e1, 0x74f3,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x7556, 0x7555, 0x7558, 0x7557,
  0x755e, 0x75c3, 0xfffd, 0xfffd, 0x75b4, 0xfffd, 0x75b1, 0xfffd,
  0xfffd, 0x76cb, 0x76cc, 0x772a, 0xfffd, 0x7716, 0x770f, 0xfffd,
  0xfffd, 0x773f, 0x772b, 0x770e, 0x7724, 0xfffd, 0x7721, 0x7718,
  0x77dd, 0xfffd, 0xfffd, 0x7824, 0x7836, 0xfffd, 0x7958, 0x7959,
  0xfffd, 0x7962, 0x79da, 0x79d9, 0xfffd, 0x79e1, 0x79e5, 0x79e8,
  0x79db, 0xfffd, 0x79e2, 0x79f0, 0xfffd, 0xfffd,
  /* 0x33 */
  0xfffd, 0xfffd, 0x7ada, 0x7add, 0xfffd, 0x7adb, 0x7adc, 0xfffd,
  0xfffd, 0x7b0d, 0x7b0b, 0x7b14, 0x7c8e, 0x7c86, 0xfffd, 0x7c87,
  0x7c83, 0x7c8b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x7d24, 0xfffd,
  0xfffd, 0xfffd, 0x7d25, 0x7f62, 0x7f93, 0x7f99, 0x7f97, 0xfffd,
  0xfffd, 0x7fc4, 0x7fc6, 0x800a, 0xfffd, 0xfffd, 0x8040, 0x803c,
  0x803b, 0x80f6, 0x80ff, 0x80ee, 0x8104, 0x8103, 0x8107, 0xfffd,
  0xfffd, 0x80f7, 0xfffd, 0xfffd, 0x822d, 0xfffd, 0x8227, 0x8229,
  0x831f, 0x8357, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8321, 0xfffd,
  0xfffd, 0x8318, 0x8358, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x8684, 0x869f, 0x869b, 0x8689, 0x86a6, 0x8692, 0x868f, 0x86a0,
  0x884f, 0x8878, 0x887a, 0x886e, 0x887b, 0x8884, 0x8873, 0xfffd,
  0xfffd, 0x8a0d, 0x8a0b, 0x8a19, 0xfffd, 0xfffd,
  /* 0x34 */
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ff9, 0x9009, 0x9008, 0xfffd,
  0x90de, 0x9151, 0xfffd, 0xfffd, 0x91db, 0x91df, 0x91de, 0x91d6,
  0x91e0, 0x9585, 0x9660, 0x9659, 0xfffd, 0x9656, 0xfffd, 0xfffd,
  0x96bd, 0xfffd, 0xfffd, 0x5042, 0x5059, 0xfffd, 0x5044, 0x5066,
  0x5052, 0x5054, 0x5071, 0x5050, 0x507b, 0x507c, 0x5058, 0xfffd,
  0xfffd, 0x5079, 0x506c, 0x5078, 0x51a8, 0x51d1, 0x51cf, 0x5268,
  0x5276, 0x52d4, 0xfffd, 0x53a0, 0x53c4, 0xfffd, 0x5558, 0x554c,
  0x5568, 0xfffd, 0x5549, 0xfffd, 0xfffd, 0x555d, 0x5529, 0xfffd,
  0x5554, 0x5553, 0xfffd, 0x555a, 0xfffd, 0x553a, 0x553f, 0x552b,
  0x57ea, 0xfffd, 0x57ef, 0xfffd, 0xfffd, 0x57dd, 0x57fe, 0xfffd,
  0x57de, 0x57e6, 0xfffd, 0x57e8, 0x57ff, 0x5803, 0x58f7, 0x68a6,
  0x591f, 0xfffd, 0x595b, 0x595d, 0x595e, 0xfffd,
  /* 0x35 */
  0xfffd, 0x5a2b, 0xfffd, 0x5a3b, 0xfffd, 0xfffd, 0x5a61, 0x5a3a,
  0x5a6e, 0x5a4b, 0x5a6b, 0xfffd, 0xfffd, 0x5a45, 0x5a4e, 0x5a68,
  0x5a3d, 0x5a71, 0x5a3f, 0x5a6f, 0x5a75, 0xfffd, 0x5a73, 0x5a2c,
  0x5a59, 0x5a54, 0x5a4f, 0x5a63, 0xfffd, 0xfffd, 0x5bc8, 0xfffd,
  0x5bc3, 0xfffd, 0x5c5b, 0x5c61, 0xfffd, 0x5d21, 0x5d0a, 0x5d09,
  0xfffd, 0x5d2c, 0x5d08, 0xfffd, 0xfffd, 0x5d2a, 0x5d15, 0xfffd,
  0x5d10, 0x5d13, 0xfffd, 0x5d2f, 0x5d18, 0xfffd, 0x5de3, 0x5e39,
  0x5e35, 0x5e3a, 0x5e32, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x5ebb,
  0x5eba, 0x5f34, 0x5f39, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x6098,
  0xfffd, 0x60d0, 0xfffd, 0xfffd, 0xfffd, 0x60d7, 0x60aa, 0xfffd,
  0x60a1, 0x60a4, 0xfffd, 0x60ee, 0xfffd, 0x60e7, 0xfffd, 0xfffd,
  0x60de, 0xfffd, 0xfffd, 0x637e, 0x638b, 0xfffd,
  /* 0x36 */
  0xfffd, 0x6379, 0x6386, 0x6393, 0xfffd, 0x6373, 0x636a, 0xfffd,
  0x636c, 0xfffd, 0x637f, 0xfffd, 0x63b2, 0x63ba, 0xfffd, 0xfffd,
  0x6366, 0x6374, 0xfffd, 0x655a, 0xfffd, 0x654e, 0x654d, 0x658d,
  0x658e, 0x65ad, 0xfffd, 0x65c7, 0x65ca, 0xfffd, 0x65c9, 0xfffd,
  0x65e3, 0x6657, 0xfffd, 0x6663, 0x6667, 0x671a, 0x6719, 0x6716,
  0xfffd, 0xfffd, 0x689e, 0x68b6, 0x6898, 0x6873, 0xfffd, 0x689a,
  0x688e, 0x68b7, 0x68db, 0x68a5, 0x686c, 0x68c1, 0x6884, 0xfffd,
  0xfffd, 0x6895, 0x687a, 0x6899, 0xfffd, 0x68b8, 0x68b9, 0x6870,
  0xfffd, 0x6b35, 0xfffd, 0x6b90, 0x6bbb, 0x6bed, 0xfffd, 0xfffd,
  0xfffd, 0x6dc1, 0x6dc3, 0x6dce, 0xfffd, 0xfffd, 0x6dad, 0x6e04,
  0xfffd, 0x6db9, 0xfffd, 0x6de7, 0xfffd, 0x6e08, 0x6e06, 0xfffd,
  0x6e0a, 0x6db0, 0xfffd, 0x6df8, 0x6e0c, 0xfffd,
  /* 0x37 */
  0x6db1, 0xfffd, 0x6e02, 0x6e07, 0x6e09, 0x6e01, 0x6e17, 0x6dff,
  0x6e12, 0xfffd, 0xfffd, 0x7103, 0x7107, 0x7101, 0x70f5, 0x70f1,
  0x7108, 0x70f2, 0x710f, 0xfffd, 0x70fe, 0xfffd, 0xfffd, 0xfffd,
  0x731a, 0x7310, 0x730e, 0x7402, 0x73f3, 0xfffd, 0xfffd, 0x73fb,
  0xfffd, 0xfffd, 0xfffd, 0x751b, 0x7523, 0x7561, 0x7568, 0xfffd,
  0x7567, 0x75d3, 0xfffd, 0xfffd, 0x7690, 0xfffd, 0xfffd, 0x76d5,
  0x76d7, 0x76d6, 0x7730, 0xfffd, 0x7726, 0xfffd, 0x7740, 0xfffd,
  0x771e, 0xfffd, 0xfffd, 0xfffd, 0x7847, 0xfffd, 0x784b, 0x7851,
  0x784f, 0x7842, 0x7846, 0xfffd, 0x796e, 0x796c, 0x79f2, 0xfffd,
  0x79f1, 0x79f5, 0x79f3, 0x79f9, 0xfffd, 0xfffd, 0xfffd, 0x7a9a,
  0x7a93, 0x7a91, 0x7ae1, 0xfffd, 0xfffd, 0x7b21, 0x7b1c, 0x7b16,
  0x7b17, 0x7b36, 0x7b1f, 0xfffd, 0x7c93, 0x7c99,
  /* 0x38 */
  0x7c9a, 0x7c9c, 0xfffd, 0x7d49, 0xfffd, 0x7d34, 0x7d37, 0xfffd,
  0x7d2d, 0xfffd, 0x7d4c, 0xfffd, 0xfffd, 0x7d48, 0xfffd, 0xfffd,
  0x7f3b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8008, 0x801a, 0xfffd,
  0x801d, 0xfffd, 0x8049, 0x8045, 0x8044, 0x7c9b, 0xfffd, 0xfffd,
  0x812a, 0x812e, 0xfffd, 0xfffd, 0x8131, 0xfffd, 0x811a, 0x8134,
  0x8117, 0xfffd, 0xfffd, 0xfffd, 0x831d, 0x8371, 0x8384, 0x8380,
  0x8372, 0x83a1, 0xfffd, 0x8379, 0x8391, 0xfffd, 0x839f, 0x83ad,
  0xfffd, 0xfffd, 0x8323, 0xfffd, 0x8385, 0x839c, 0x83b7, 0x8658,
  0x865a, 0xfffd, 0x8657, 0x86b2, 0xfffd, 0x86ae, 0xfffd, 0xfffd,
  0xfffd, 0x8845, 0x889c, 0x8894, 0x88a3, 0x888f, 0x88a5, 0x88a9,
  0x88a6, 0x888a, 0x88a0, 0x8890, 0x8992, 0x8991, 0x8994, 0xfffd,
  0x8a26, 0x8a32, 0x8a28, 0xfffd, 0xfffd, 0x8a1c,
  /* 0x39 */
  0xfffd, 0x8a2b, 0x8a20, 0xfffd, 0x8a29, 0xfffd, 0xfffd, 0xfffd,
  0x8a21, 0x8c3a, 0xfffd, 0x8c5b, 0x8c58, 0x8c7c, 0xfffd, 0x8ca6,
  0x8cae, 0x8cad, 0x8d65, 0xfffd, 0x8d7e, 0xfffd, 0x8d7c, 0x8d7f,
  0x8d7a, 0x8dbd, 0xfffd, 0xfffd, 0x8dc0, 0x8dbb, 0x8ead, 0x8eaf,
  0x8ed6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x8ed9, 0xfffd,
  0xfffd, 0x9012, 0x900e, 0x9025, 0xfffd, 0x9013, 0x90ee, 0xfffd,
  0x90ab, 0x90f7, 0xfffd, 0x9159, 0x9154, 0x91f2, 0x91f0, 0x91e5,
  0x91f6, 0xfffd, 0xfffd, 0x9587, 0xfffd, 0x965a, 0xfffd, 0xfffd,
  0x966e, 0xfffd, 0xfffd, 0xfffd, 0x9679, 0xfffd, 0x98e1, 0x98e6,
  0xfffd, 0x9ec4, 0x9ed2, 0x4e80, 0xfffd, 0x4e81, 0x508f, 0x5097,
  0x5088, 0x5089, 0xfffd, 0xfffd, 0x5081, 0x5160, 0xfffd, 0xfffd,
  0x5e42, 0x51d3, 0xfffd, 0xfffd, 0x51d2, 0x51d6,
  /* 0x3a */
  0x5273, 0xfffd, 0x5270, 0xfffd, 0xfffd, 0xfffd, 0x53a8, 0x53a6,
  0x53c5, 0x5597, 0x55de, 0xfffd, 0xfffd, 0x5596, 0x55b4, 0xfffd,
  0x5585, 0xfffd, 0x559b, 0x55a0, 0xfffd, 0x5559, 0xfffd, 0x5586,
  0xfffd, 0xfffd, 0x55af, 0x557a, 0xfffd, 0xfffd, 0xfffd, 0x559e,
  0xfffd, 0x55a9, 0x570f, 0x570e, 0x581a, 0xfffd, 0x581f, 0xfffd,
  0x583c, 0x5818, 0x583e, 0x5826, 0xfffd, 0x583a, 0xfffd, 0x5822,
  0xfffd, 0x58fb, 0x5963, 0x5964, 0xfffd, 0x5aa8, 0x5aa3, 0x5a82,
  0x5a88, 0x5aa1, 0x5a85, 0x5a98, 0xfffd, 0x5a99, 0xfffd, 0x5a89,
  0x5a81, 0x5a96, 0x5a80, 0xfffd, 0xfffd, 0x5a91, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x5acf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0x5a87, 0x5aa0, 0xfffd, 0x5a79, 0xfffd, 0x5a86, 0x5aab,
  0x5aaa, 0x5aa4, 0x5a8d, 0x5a7e, 0xfffd, 0x5bd5,
  /* 0x3b */
  0xfffd, 0xfffd, 0xfffd, 0x5c1e, 0x5c5f, 0x5c5e, 0x5d44, 0x5d3e,
  0xfffd, 0x5d48, 0x5d1c, 0xfffd, 0x5d5b, 0x5d4d, 0xfffd, 0xfffd,
  0x5d57, 0xfffd, 0x5d53, 0x5d4f, 0xfffd, 0x5d3b, 0x5d46, 0xfffd,
  0xfffd, 0x5e46, 0x5e47, 0xfffd, 0x5e48, 0x5ec0, 0x5ebd, 0x5ebf,
  0xfffd, 0x5f11, 0xfffd, 0x5f3e, 0x5f3b, 0xfffd, 0x5f3a, 0xfffd,
  0xfffd, 0xfffd, 0x5fa7, 0xfffd, 0x60ea, 0xfffd, 0x6107, 0x6122,
  0x610c, 0xfffd, 0xfffd, 0x60b3, 0x60d6, 0x60d2, 0xfffd, 0x60e3,
  0x60e5, 0x60e9, 0xfffd, 0xfffd, 0x6111, 0x60fd, 0xfffd, 0xfffd,
  0x611e, 0x6120, 0x6121, 0x621e, 0xfffd, 0x63e2, 0x63de, 0x63e6,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x63f8, 0xfffd, 0x63fe, 0x63c1,
  0x63bf, 0x63f7, 0x63d1, 0x655f, 0x6560, 0x6561, 0xfffd, 0xfffd,
  0x65d1, 0xfffd, 0xfffd, 0x667d, 0x666b, 0x667f,
  /* 0x3c */
  0xfffd, 0xfffd, 0x6673, 0x6681, 0x666d, 0x6669, 0xfffd, 0xfffd,
  0x671e, 0x68ed, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x6903, 0xfffd,
  0x68fe, 0x68e5, 0x691e, 0x6902, 0xfffd, 0xfffd, 0x6909, 0x68ca,
  0x6900, 0xfffd, 0x6901, 0x6918, 0x68e2, 0x68cf, 0xfffd, 0x692e,
  0x68c5, 0x68ff, 0xfffd, 0x691c, 0x68c3, 0xfffd, 0x6b6f, 0xfffd,
  0x6b6e, 0xfffd, 0x6bbe, 0xfffd, 0x6bf4, 0x6c2d, 0xfffd, 0x6db6,
  0x6e75, 0x6e1e, 0xfffd, 0x6e18, 0xfffd, 0x6e48, 0xfffd, 0x6e4f,
  0xfffd, 0x6e42, 0x6e6a, 0x6e70, 0x6dfe, 0xfffd, 0xfffd, 0x6e6d,
  0xfffd, 0x6e7b, 0x6e7e, 0x6e59, 0xfffd, 0x6e57, 0xfffd, 0x6e80,
  0x6e50, 0xfffd, 0x6e29, 0x6e76, 0x6e2a, 0x6e4c, 0x712a, 0xfffd,
  0x7135, 0x712c, 0x7137, 0x711d, 0xfffd, 0xfffd, 0x7138, 0xfffd,
  0x7134, 0x712b, 0x7133, 0x7127, 0x7124, 0xfffd,
  /* 0x3d */
  0x712d, 0x7232, 0x7283, 0x7282, 0x7287, 0x7306, 0x7324, 0x7338,
  0x732a, 0x732c, 0x732b, 0xfffd, 0x732f, 0x7328, 0x7417, 0xfffd,
  0xfffd, 0x7419, 0x7438, 0xfffd, 0x741f, 0x7414, 0x743c, 0x73f7,
  0x741c, 0x7415, 0x7418, 0x7439, 0x74f9, 0x7524, 0xfffd, 0xfffd,
  0xfffd, 0x756e, 0x756d, 0x7571, 0x758e, 0xfffd, 0x75e5, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x7694, 0x76b3, 0xfffd, 0x76d9, 0xfffd,
  0x7748, 0x7749, 0x7743, 0xfffd, 0xfffd, 0x7742, 0x77df, 0xfffd,
  0x7863, 0x7876, 0xfffd, 0x785f, 0x7866, 0x7966, 0x7971, 0xfffd,
  0xfffd, 0x7976, 0x7984, 0x7975, 0x79ff, 0x7a07, 0xfffd, 0x7a0e,
  0x7a09, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x7ae7,
  0x7ae2, 0x7b55, 0xfffd, 0xfffd, 0x7b43, 0x7b57, 0x7b6c, 0x7b42,
  0x7b53, 0xfffd, 0x7b41, 0xfffd, 0xfffd, 0x7ca7,
  /* 0x3e */
  0x7ca0, 0x7ca6, 0x7ca4, 0x7d74, 0xfffd, 0x7d59, 0xfffd, 0x7d60,
  0x7d57, 0x7d6c, 0x7d7e, 0x7d64, 0xfffd, 0x7d5a, 0x7d5d, 0xfffd,
  0xfffd, 0xfffd, 0x7d76, 0x7d4d, 0x7d75, 0xfffd, 0x7fd3, 0x7fd6,
  0xfffd, 0xfffd, 0x8060, 0x804e, 0x8145, 0x813b, 0xfffd, 0x8148,
  0x8142, 0x8149, 0x8140, 0x8114, 0x8141, 0xfffd, 0x81ef, 0x81f6,
  0x8203, 0xfffd, 0x83ed, 0xfffd, 0x83da, 0x8418, 0x83d2, 0x8408,
  0xfffd, 0x8400, 0xfffd, 0xfffd, 0xfffd, 0x8417, 0x8346, 0x8414,
  0x83d3, 0x8405, 0x841f, 0x8402, 0x8416, 0x83cd, 0x83e6, 0xfffd,
  0x865d, 0x86d5, 0x86e1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x86ee,
  0x8847, 0x8846, 0xfffd, 0xfffd, 0x88bb, 0xfffd, 0x88bf, 0x88b4,
  0xfffd, 0x88b5, 0xfffd, 0x899a, 0x8a43, 0xfffd, 0xfffd, 0x8a5a,
  0xfffd, 0xfffd, 0xfffd, 0x8a35, 0x8a38, 0x8a42,
  /* 0x3f */
  0x8a49, 0x8a5d, 0x8a4b, 0x8a3d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x8c60, 0x8c5e, 0x8c7f, 0x8c7e, 0x8c83, 0xfffd, 0x8cb1, 0x8d87,
  0xfffd, 0xfffd, 0x8d88, 0x8d83, 0xfffd, 0xfffd, 0x8d86, 0x8d8b,
  0x8d82, 0x8dca, 0x8dd2, 0xfffd, 0xfffd, 0x8dd4, 0x8dc9, 0x8eb0,
  0xfffd, 0xfffd, 0xfffd, 0x8ef2, 0x8ee4, 0x8ef3, 0x8eea, 0xfffd,
  0x8efd, 0xfffd, 0x8f9d, 0x902b, 0x902a, 0xfffd, 0x9028, 0x9029,
  0x902c, 0xfffd, 0xfffd, 0x903a, 0x9030, 0x9037, 0x903b, 0xfffd,
  0x910a, 0xfffd, 0xfffd, 0xfffd, 0x91fe, 0x9220, 0xfffd, 0x920b,
  0xfffd, 0x9218, 0x9222, 0xfffd, 0x921b, 0x9208, 0xfffd, 0x920e,
  0x9213, 0xfffd, 0xfffd, 0x9595, 0xfffd, 0xfffd, 0xfffd, 0x968c,
  0x967b, 0x967f, 0x9681, 0xfffd, 0x9682, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x96ee, 0x96ed, 0xfffd, 0x96ec,
  /* 0x40 */
  0x975f, 0x976f, 0xfffd, 0x976d, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x98f0, 0xfffd, 0xfffd, 0xfffd, 0x9aa9, 0xfffd,
  0xfffd, 0x9ae0, 0x4eb7, 0xfffd, 0xfffd, 0x50cc, 0x50bc, 0xfffd,
  0x50aa, 0x50b9, 0xfffd, 0x50ab, 0x50c3, 0x50cd, 0x517e, 0x527e,
  0x5279, 0xfffd, 0xfffd, 0x52e1, 0x52e0, 0x52e7, 0x5380, 0x53ab,
  0x53aa, 0x53a9, 0x53e0, 0x55ea, 0xfffd, 0x55d7, 0xfffd, 0xfffd,
  0x55c1, 0x5715, 0xfffd, 0x586c, 0xfffd, 0x585c, 0x5850, 0x5861,
  0x586a, 0x5869, 0x5856, 0x5860, 0x5866, 0x585f, 0x5923, 0x5966,
  0x5968, 0xfffd, 0xfffd, 0x5ace, 0xfffd, 0x5ac5, 0x5ac3, 0xfffd,
  0xfffd, 0x5ad0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x5b74, 0x5b76, 0x5bdc, 0x5bd7, 0x5bda, 0x5bdb, 0xfffd, 0x5c20,
  0x5d6d, 0x5d66, 0xfffd, 0x5d64, 0x5d6e, 0xfffd,
  /* 0x41 */
  0x5d60, 0x5f42, 0x5f5a, 0x5f6e, 0xfffd, 0xfffd, 0x6130, 0x613a,
  0x612a, 0x6143, 0x6119, 0x6131, 0xfffd, 0x613d, 0xfffd, 0xfffd,
  0xfffd, 0x6408, 0x6432, 0x6438, 0xfffd, 0x6431, 0xfffd, 0x6419,
  0xfffd, 0x6411, 0xfffd, 0xfffd, 0x6429, 0x641d, 0xfffd, 0xfffd,
  0xfffd, 0x643c, 0xfffd, 0x6446, 0x6447, 0xfffd, 0xfffd, 0x643a,
  0x6407, 0xfffd, 0x656b, 0xfffd, 0x6570, 0x656d, 0xfffd, 0x65e4,
  0x6693, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x668f, 0xfffd, 0xfffd,
  0x6692, 0xfffd, 0x668e, 0xfffd, 0x6946, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x6931, 0xfffd, 0xfffd, 0x693e,
  0xfffd, 0x697c, 0x6943, 0xfffd, 0x6973, 0xfffd, 0x6955, 0xfffd,
  0xfffd, 0x6985, 0x694d, 0x6950, 0x6947, 0x6967, 0x6936, 0x6964,
  0x6961, 0xfffd, 0x697d, 0x6b44, 0x6b40, 0x6b71,
  /* 0x42 */
  0x6b73, 0x6b9c, 0xfffd, 0xfffd, 0xfffd, 0x6bc1, 0xfffd, 0x6bfa,
  0x6c31, 0x6c32, 0xfffd, 0xfffd, 0x6eb8, 0x6ea8, 0xfffd, 0x6e91,
  0x6ebb, 0xfffd, 0x6e9a, 0xfffd, 0xfffd, 0x6ea9, 0xfffd, 0xfffd,
  0x6eb5, 0x6e6c, 0x6ee8, 0xfffd, 0x6edd, 0x6eda, 0x6ee6, 0x6eac,
  0xfffd, 0xfffd, 0xfffd, 0x6ed9, 0x6ee3, 0x6ee9, 0x6edb, 0xfffd,
  0x716f, 0xfffd, 0xfffd, 0x7148, 0xfffd, 0x714a, 0x716b, 0xfffd,
  0x714f, 0x7157, 0x7174, 0xfffd, 0xfffd, 0xfffd, 0x7145, 0x7151,
  0x716d, 0xfffd, 0x7251, 0x7250, 0x724e, 0xfffd, 0x7341, 0xfffd,
  0x732e, 0x7346, 0xfffd, 0x7427, 0xfffd, 0x7448, 0x7453, 0x743d,
  0xfffd, 0x745d, 0x7456, 0xfffd, 0x741e, 0x7447, 0x7443, 0x7458,
  0x7449, 0xfffd, 0x744c, 0x7445, 0x743e, 0xfffd, 0x7501, 0x751e,
  0xfffd, 0xfffd, 0x757a, 0x75ee, 0x7602, 0x7697,
  /* 0x43 */
  0x7698, 0xfffd, 0xfffd, 0xfffd, 0x775d, 0x7764, 0x7753, 0x7758,
  0x7882, 0x7890, 0x788a, 0xfffd, 0x787a, 0x787d, 0xfffd, 0x788b,
  0x7878, 0xfffd, 0xfffd, 0x788d, 0x7888, 0x7892, 0x7881, 0x797e,
  0x7983, 0xfffd, 0xfffd, 0xfffd, 0x7980, 0xfffd, 0xfffd, 0xfffd,
  0x7a0f, 0xfffd, 0xfffd, 0x7a1d, 0xfffd, 0x7aa1, 0x7aa4, 0xfffd,
  0x7ae9, 0x7aea, 0xfffd, 0x7b62, 0x7b6b, 0xfffd, 0x7b5e, 0xfffd,
  0x7b79, 0xfffd, 0xfffd, 0x7b6f, 0x7b68, 0xfffd, 0xfffd, 0x7cae,
  0xfffd, 0xfffd, 0xfffd, 0x7cb0, 0xfffd, 0x7d90, 0xfffd, 0x7d8a,
  0xfffd, 0x7d8b, 0x7d99, 0x7d95, 0xfffd, 0x7d87, 0x7d78, 0x7d97,
  0x7d89, 0x7d98, 0xfffd, 0xfffd, 0xfffd, 0x7fa3, 0xfffd, 0xfffd,
  0xfffd, 0x7fdd, 0x8057, 0xfffd, 0x8163, 0x816a, 0x816c, 0xfffd,
  0xfffd, 0xfffd, 0x815d, 0x8175, 0xfffd, 0x815f,
  /* 0x44 */
  0xfffd, 0x817d, 0x816d, 0xfffd, 0xfffd, 0x8241, 0x844f, 0x8484,
  0xfffd, 0x847f, 0xfffd, 0x8448, 0x842a, 0x847b, 0x8472, 0x8464,
  0x842e, 0x845c, 0x8453, 0xfffd, 0x8441, 0x84c8, 0xfffd, 0x8462,
  0x8480, 0x843e, 0x8483, 0x8471, 0xfffd, 0x844a, 0x8455, 0x8458,
  0xfffd, 0xfffd, 0xfffd, 0x86fc, 0x86fd, 0x8715, 0xfffd, 0x8716,
  0x86ff, 0xfffd, 0xfffd, 0xfffd, 0x8858, 0x88cf, 0x88e0, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x89e7, 0x8a6a, 0x8a80, 0xfffd, 0x8a6f,
  0x8a65, 0xfffd, 0x8a78, 0x8a7d, 0x8a88, 0xfffd, 0xfffd, 0x8a64,
  0x8a7e, 0xfffd, 0x8a67, 0x8c63, 0x8c88, 0xfffd, 0x8ccd, 0xfffd,
  0x8cc9, 0xfffd, 0x8ded, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x8eb1, 0xfffd, 0xfffd, 0x8f04, 0x8f9e, 0x8fa0,
  0x9043, 0x9046, 0x9048, 0x9045, 0x9040, 0x904c,
  /* 0x45 */
  0xfffd, 0xfffd, 0x910c, 0x9113, 0x9115, 0xfffd, 0x916b, 0x9167,
  0x925d, 0x9255, 0x9235, 0xfffd, 0x9259, 0x922f, 0x923c, 0x928f,
  0x925c, 0x926a, 0x9262, 0x925f, 0x926b, 0x926e, 0x923b, 0x9244,
  0x9241, 0x959a, 0xfffd, 0x9599, 0xfffd, 0xfffd, 0xfffd, 0x968f,
  0xfffd, 0x9696, 0xfffd, 0xfffd, 0xfffd, 0x96f4, 0x96fc, 0xfffd,
  0x9755, 0xfffd, 0x9779, 0xfffd, 0xfffd, 0xfffd, 0x97ee, 0x97f5,
  0xfffd, 0x980b, 0xfffd, 0x98f3, 0xfffd, 0xfffd, 0x98f7, 0x98ff,
  0x98f5, 0xfffd, 0x98ec, 0x98f1, 0xfffd, 0xfffd, 0x999a, 0xfffd,
  0x9ae2, 0x9b3d, 0x9b5d, 0x9ce8, 0xfffd, 0x9ceb, 0x9cef, 0x9cee,
  0x9e81, 0x9f14, 0x50d0, 0x50d9, 0x50dc, 0x50d8, 0xfffd, 0x50e1,
  0x50eb, 0xfffd, 0xfffd, 0x50f4, 0x50e2, 0x50de, 0xfffd, 0xfffd,
  0xfffd, 0x51f4, 0xfffd, 0xfffd, 0xfffd, 0x52ed,
  /* 0x46 */
  0x52ea, 0xfffd, 0x5332, 0xfffd, 0x53ae, 0x53b0, 0xfffd, 0x55fb,
  0x5603, 0x560b, 0xfffd, 0x5607, 0xfffd, 0x55f8, 0xfffd, 0x5628,
  0x561e, 0xfffd, 0x5618, 0x5611, 0x5651, 0x5605, 0x5717, 0x5892,
  0xfffd, 0x588c, 0xfffd, 0x5878, 0x5884, 0x5873, 0x58ad, 0x5897,
  0x5895, 0x5877, 0x5872, 0x5896, 0x588d, 0x5910, 0xfffd, 0x596c,
  0xfffd, 0x5ae7, 0xfffd, 0x5ae4, 0xfffd, 0xfffd, 0x5aef, 0x5626,
  0xfffd, 0xfffd, 0x5af0, 0x5d7b, 0xfffd, 0x5d83, 0xfffd, 0xfffd,
  0x5d8b, 0x5d8c, 0xfffd, 0x5d78, 0x5e52, 0xfffd, 0xfffd, 0x5ed0,
  0x5ecf, 0xfffd, 0x5fb3, 0x5fb4, 0xfffd, 0xfffd, 0xfffd, 0x617b,
  0xfffd, 0x616f, 0x6181, 0x613c, 0x6142, 0x6138, 0x6133, 0xfffd,
  0x6160, 0x6169, 0x617d, 0x6186, 0x622c, 0x6228, 0xfffd, 0x644c,
  0xfffd, 0x6457, 0x647c, 0xfffd, 0xfffd, 0x6455,
  /* 0x47 */
  0x6462, 0x6471, 0x646a, 0x6456, 0x643b, 0x6481, 0xfffd, 0x644f,
  0x647e, 0x6464, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x6571,
  0xfffd, 0xfffd, 0x66a5, 0x669a, 0x669c, 0xfffd, 0x66a6, 0xfffd,
  0x66a4, 0x698f, 0x69c5, 0x69c8, 0x6992, 0x69b2, 0xfffd, 0xfffd,
  0xfffd, 0x69e3, 0x69c0, 0x69d6, 0x69d1, 0x699f, 0x69a2, 0x69d2,
  0xfffd, 0xfffd, 0xfffd, 0x69e1, 0x69d5, 0x699d, 0xfffd, 0xfffd,
  0x6998, 0xfffd, 0x6b74, 0x6ba1, 0xfffd, 0x6ef0, 0x6ef3, 0xfffd,
  0xfffd, 0x6f1b, 0x6f0c, 0x6f1d, 0x6f34, 0x6f28, 0x6f17, 0xfffd,
  0x6f44, 0x6f42, 0x6f04, 0x6f11, 0x6efa, 0x6f4a, 0x7191, 0x718e,
  0xfffd, 0x718b, 0x718d, 0x717f, 0x718c, 0x717e, 0x717c, 0x7183,
  0xfffd, 0x7188, 0xfffd, 0xfffd, 0x7294, 0xfffd, 0x7355, 0x7353,
  0x734f, 0x7354, 0x746c, 0x7465, 0x7466, 0x7461,
  /* 0x48 */
  0x746b, 0x7468, 0x7476, 0xfffd, 0x7460, 0xfffd, 0x7474, 0x7506,
  0x760e, 0xfffd, 0x7607, 0xfffd, 0xfffd, 0x76b9, 0xfffd, 0x76b7,
  0x76e2, 0xfffd, 0x7774, 0x7777, 0x7776, 0x7775, 0xfffd, 0x7778,
  0x7771, 0xfffd, 0x777a, 0x715b, 0x777b, 0x78a6, 0x78ae, 0x78b8,
  0xfffd, 0xfffd, 0xfffd, 0x78b1, 0x78af, 0xfffd, 0x7989, 0x7987,
  0xfffd, 0xfffd, 0x7a29, 0xfffd, 0x7a2a, 0xfffd, 0x7a2d, 0x7a2c,
  0xfffd, 0x7a32, 0xfffd, 0x7aec, 0x7af0, 0x7b81, 0x7b9e, 0x7b83,
  0xfffd, 0x7b92, 0xfffd, 0x7ba3, 0x7b9f, 0x7b93, 0xfffd, 0x7b86,
  0x7cb8, 0x7cb7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x7dc8,
  0x7db6, 0xfffd, 0x7dd1, 0xfffd, 0x7da8, 0x7dab, 0xfffd, 0x7db3,
  0x7dcd, 0xfffd, 0x7dcf, 0x7da4, 0xfffd, 0xfffd, 0x7f41, 0x7f6f,
  0x7f71, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  /* 0x49 */
  0xfffd, 0x8023, 0x805b, 0xfffd, 0x8061, 0x805f, 0x8181, 0xfffd,
  0xfffd, 0x8184, 0x8213, 0xfffd, 0x824a, 0x824c, 0xfffd, 0xfffd,
  0xfffd, 0x84bd, 0x8495, 0xfffd, 0x8492, 0x84c3, 0xfffd, 0x8496,
  0x84a5, 0x84b5, 0x84b3, 0x84a3, 0x84e4, 0x84d8, 0x84d5, 0xfffd,
  0x84b7, 0x84ad, 0x84da, 0x8493, 0x8736, 0xfffd, 0xfffd, 0xfffd,
  0x873d, 0x872b, 0x8747, 0x8739, 0xfffd, 0x8745, 0x871d, 0xfffd,
  0x88ff, 0x88ea, 0xfffd, 0x88f5, 0xfffd, 0x8900, 0x88ed, 0x8903,
  0x88e9, 0xfffd, 0xfffd, 0x89ea, 0xfffd, 0x8a9b, 0x8a8e, 0x8aa2,
  0xfffd, 0x8a9c, 0x8a94, 0x8a90, 0x8aa9, 0x8aac, 0xfffd, 0x8a9f,
  0xfffd, 0xfffd, 0x8a9d, 0xfffd, 0x8c67, 0xfffd, 0xfffd, 0x8cd0,
  0x8cd6, 0x8cd4, 0x8d98, 0x8d9a, 0x8d97, 0xfffd, 0xfffd, 0xfffd,
  0x8e0b, 0x8e08, 0x8e01, 0x8eb4, 0x8eb3, 0xfffd,
  /* 0x4a */
  0x8fa1, 0x8fa2, 0xfffd, 0x905a, 0xfffd, 0x9061, 0x905f, 0xfffd,
  0xfffd, 0x9125, 0x917b, 0x9176, 0x917c, 0xfffd, 0x9289, 0x92f6,
  0x92b1, 0x92ad, 0x9292, 0x9281, 0x9284, 0xfffd, 0x92ae, 0x9290,
  0x929e, 0xfffd, 0xfffd, 0xfffd, 0x95a2, 0x95a7, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x96a0, 0x969d, 0x969f, 0x96d0, 0xfffd,
  0x96d1, 0xfffd, 0xfffd, 0x9759, 0xfffd, 0x9764, 0xfffd, 0xfffd,
  0xfffd, 0x9819, 0xfffd, 0x9814, 0x9815, 0x981a, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x9906, 0xfffd, 0x98f8, 0x9901, 0xfffd, 0x99be,
  0x99bc, 0x99b7, 0x99b6, 0x99c0, 0xfffd, 0x99b8, 0xfffd, 0xfffd,
  0xfffd, 0x99c4, 0xfffd, 0x99bf, 0xfffd, 0x9ada, 0x9ae4, 0x9ae9,
  0x9ae8, 0x9aea, 0x9ae5, 0xfffd, 0x9b26, 0xfffd, 0xfffd, 0x9b40,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  /* 0x4b */
  0xfffd, 0x9ebd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x510e, 0xfffd,
  0x50f7, 0xfffd, 0x50fc, 0x510d, 0x5101, 0x51da, 0x51d9, 0x51db,
  0x5286, 0x528e, 0x52ee, 0x5333, 0x53b1, 0xfffd, 0x5647, 0x562d,
  0x5654, 0xfffd, 0x564b, 0x5652, 0x5631, 0x5644, 0x5656, 0x5650,
  0x562b, 0xfffd, 0x564d, 0x5637, 0x564f, 0x58a2, 0x58b7, 0xfffd,
  0x58b2, 0xfffd, 0x58aa, 0x58b5, 0x58b0, 0xfffd, 0x58b4, 0x58a4,
  0x58a7, 0xfffd, 0x5926, 0x5afe, 0xfffd, 0x5b04, 0xfffd, 0x5afc,
  0xfffd, 0x5b06, 0x5b0a, 0x5afa, 0x5b0d, 0x5b00, 0x5b0e, 0xfffd,
  0xfffd, 0xfffd, 0x5d91, 0xfffd, 0x5d8f, 0x5d90, 0x5d98, 0x5da4,
  0x5d9b, 0x5da3, 0x5d96, 0x5de4, 0x5e5a, 0xfffd, 0xfffd, 0x5e5e,
  0xfffd, 0x5fb8, 0x6157, 0x615c, 0x61a6, 0x6195, 0x6188, 0xfffd,
  0x61a3, 0x618f, 0xfffd, 0x6164, 0xfffd, 0x6159,
  /* 0x4c */
  0x6178, 0xfffd, 0x6185, 0x6187, 0x619e, 0xfffd, 0xfffd, 0x6198,
  0x619c, 0xfffd, 0xfffd, 0x622f, 0x6480, 0x649b, 0x648e, 0x648d,
  0x6494, 0x64c6, 0xfffd, 0x64a8, 0x6483, 0xfffd, 0x64b9, 0x6486,
  0x64b4, 0x64af, 0x6491, 0xfffd, 0x64aa, 0x64a1, 0x64a7, 0x66b6,
  0x66b3, 0xfffd, 0x66bc, 0x66ac, 0xfffd, 0x66ad, 0x6a0e, 0xfffd,
  0x6a1c, 0x6a1a, 0xfffd, 0xfffd, 0x6a0b, 0xfffd, 0x69ef, 0x6a0c,
  0x69f0, 0x6a22, 0xfffd, 0x69d8, 0xfffd, 0x6a12, 0x69fa, 0xfffd,
  0x6a2a, 0xfffd, 0x6a10, 0xfffd, 0xfffd, 0x6a29, 0x69f9, 0x69ea,
  0x6a2c, 0x6a24, 0xfffd, 0x69e9, 0x6b52, 0x6b4f, 0x6b53, 0xfffd,
  0xfffd, 0x6f10, 0x6f65, 0x6f75, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x6fd0, 0xfffd, 0x6f5c, 0x6f3d, 0x6f71, 0xfffd, 0x6f91, 0x6f0b,
  0x6f79, 0x6f81, 0x6f8f, 0xfffd, 0x6f59, 0x6f74,
  /* 0x4d */
  0xfffd, 0x71ae, 0xfffd, 0x71a3, 0x71ad, 0xfffd, 0xfffd, 0x71ab,
  0x71a6, 0x71a2, 0xfffd, 0x52f2, 0x7257, 0x7255, 0x7299, 0x734b,
  0x747a, 0xfffd, 0xfffd, 0xfffd, 0x748c, 0x7484, 0xfffd, 0xfffd,
  0x7482, 0x7493, 0x747b, 0xfffd, 0x7509, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x778a, 0xfffd, 0x7790, 0xfffd, 0x78c6,
  0x78d3, 0x78c0, 0x78d2, 0x78c7, 0x78c2, 0xfffd, 0x799f, 0x799d,
  0x799e, 0xfffd, 0x7a41, 0xfffd, 0x7a38, 0x7a3a, 0x7a42, 0xfffd,
  0xfffd, 0x7a3e, 0x7ab0, 0x7bae, 0x7bb3, 0xfffd, 0xfffd, 0x7bbf,
  0xfffd, 0xfffd, 0x7bcd, 0xfffd, 0x7bb2, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x7cc4, 0x7ccd, 0x7cc2, 0x7cc6,
  0x7cc3, 0x7cc9, 0x7cc7, 0xfffd, 0x7df8, 0xfffd, 0x7ded, 0x7de2,
  0xfffd, 0xfffd, 0xfffd, 0x7ddc, 0x7e02, 0x7e01,
  /* 0x4e */
  0xfffd, 0x7dd6, 0xfffd, 0x7de4, 0x7dfe, 0xfffd, 0x7e00, 0x7dfc,
  0x7dfd, 0xfffd, 0x7df5, 0x7dff, 0xfffd, 0x7deb, 0x7de5, 0x7f78,
  0x7fae, 0x7fe7, 0xfffd, 0x8065, 0x806a, 0x8066, 0x8068, 0x806b,
  0x8194, 0x81a1, 0x8192, 0x8196, 0x8193, 0xfffd, 0xfffd, 0x8501,
  0xfffd, 0x84f8, 0xfffd, 0x84f5, 0xfffd, 0x8504, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x851b, 0x8503, 0x8533, 0x8534, 0x84ed, 0xfffd,
  0xfffd, 0x8535, 0xfffd, 0x8505, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x877d, 0xfffd, 0xfffd, 0xfffd, 0x8771, 0xfffd, 0x885c, 0x88e6,
  0x890f, 0x891b, 0xfffd, 0x89a9, 0x89a5, 0x89ee, 0x8ab1, 0xfffd,
  0x8acc, 0x8ace, 0xfffd, 0x8ab7, 0xfffd, 0x8ab5, 0x8ae9, 0x8ab4,
  0xfffd, 0x8ab3, 0x8ac1, 0x8aaf, 0x8aca, 0x8ad0, 0xfffd, 0xfffd,
  0xfffd, 0x8c8e, 0xfffd, 0xfffd, 0x8ce9, 0x8cdb,
  /* 0x4f */
  0xfffd, 0x8ceb, 0x8da4, 0xfffd, 0x8da2, 0x8d9d, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x8e2a, 0x8e28, 0xfffd, 0xfffd, 0x8eb8, 0x8eb6,
  0x8eb9, 0x8eb7, 0x8f22, 0x8f2b, 0x8f27, 0x8f19, 0x8fa4, 0xfffd,
  0x8fb3, 0xfffd, 0x9071, 0x906a, 0xfffd, 0xfffd, 0x9188, 0x918c,
  0x92bf, 0x92b8, 0x92be, 0x92dc, 0x92e5, 0xfffd, 0xfffd, 0x92d4,
  0x92d6, 0xfffd, 0x92da, 0x92ed, 0x92f3, 0x92db, 0xfffd, 0x92b9,
  0x92e2, 0x92eb, 0x95af, 0xfffd, 0x95b2, 0x95b3, 0xfffd, 0xfffd,
  0xfffd, 0x96a3, 0x96a5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x970a,
  0xfffd, 0x9787, 0x9789, 0x978c, 0x97ef, 0x982a, 0x9822, 0xfffd,
  0x981f, 0xfffd, 0x9919, 0xfffd, 0x99ca, 0x99da, 0xfffd, 0xfffd,
  0xfffd, 0x99de, 0x99c8, 0x99e0, 0xfffd, 0x9ab6, 0x9ab5, 0xfffd,
  0x9af4, 0xfffd, 0x9b6b, 0x9b69, 0x9b72, 0x9b63,
  /* 0x50 */
  0xfffd, 0x9d0d, 0xfffd, 0x9d01, 0x9d0c, 0xfffd, 0x9cf8, 0xfffd,
  0xfffd, 0x9cfe, 0x9d02, 0x9e84, 0xfffd, 0x9eab, 0x9eaa, 0x511d,
  0x5116, 0xfffd, 0x512b, 0x511e, 0x511b, 0x5290, 0x5294, 0x5314,
  0xfffd, 0xfffd, 0x5667, 0xfffd, 0x567b, 0xfffd, 0x565f, 0x5661,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x58c3,
  0x58ca, 0x58bb, 0x58c0, 0x58c4, 0x5901, 0x5b1f, 0x5b18, 0x5b11,
  0x5b15, 0xfffd, 0x5b12, 0x5b1c, 0xfffd, 0x5b22, 0x5b79, 0x5da6,
  0xfffd, 0x5db3, 0x5dab, 0x5eea, 0xfffd, 0x5f5b, 0xfffd, 0xfffd,
  0x61b7, 0x61ce, 0x61b9, 0x61bd, 0x61cf, 0x61c0, 0x6199, 0x6197,
  0xfffd, 0x61bb, 0x61d0, 0x61c4, 0x6231, 0xfffd, 0x64d3, 0x64c0,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x64dc, 0x64d1, 0x64c8, 0xfffd,
  0x64d5, 0x66c3, 0xfffd, 0xfffd, 0x66bf, 0x66c5,
  /* 0x51 */
  0xfffd, 0x66cd, 0x66c1, 0x6706, 0xfffd, 0x6724, 0x6a63, 0x6a42,
  0x6a52, 0xfffd, 0x6a43, 0x6a33, 0xfffd, 0x6a6c, 0x6a57, 0xfffd,
  0x6a4c, 0x6a6e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x6a37,
  0xfffd, 0x6a71, 0x6a4a, 0x6a36, 0xfffd, 0x6a53, 0xfffd, 0x6a45,
  0x6a70, 0xfffd, 0xfffd, 0x6a5c, 0x6b58, 0x6b57, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x6fbb, 0xfffd, 0xfffd, 0x6fbe,
  0xfffd, 0xfffd, 0xfffd, 0x6fb5, 0x6fd3, 0x6f9f, 0xfffd, 0x6fb7,
  0x6ff5, 0x71b7, 0xfffd, 0x71bb, 0xfffd, 0x71d1, 0xfffd, 0x71ba,
  0xfffd, 0x71b6, 0x71cc, 0xfffd, 0xfffd, 0x71d3, 0x749b, 0xfffd,
  0xfffd, 0x7496, 0x74a2, 0x749d, 0x750a, 0x750e, 0xfffd, 0x7581,
  0x762c, 0x7637, 0x7636, 0x763b, 0xfffd, 0x76a1, 0xfffd, 0xfffd,
  0x7798, 0xfffd, 0x7796, 0xfffd, 0xfffd, 0xfffd,
  /* 0x52 */
  0x78d6, 0x78eb, 0xfffd, 0x78dc, 0xfffd, 0x79a5, 0x79a9, 0x9834,
  0x7a53, 0x7a45, 0xfffd, 0x7a4f, 0xfffd, 0x7abd, 0x7abb, 0x7af1,
  0xfffd, 0xfffd, 0x7bec, 0x7bed, 0xfffd, 0xfffd, 0x7cd3, 0xfffd,
  0x7ce1, 0xfffd, 0x7e19, 0xfffd, 0xfffd, 0xfffd, 0x7e27, 0x7e26,
  0xfffd, 0xfffd, 0x806e, 0x81af, 0xfffd, 0xfffd, 0x81ad, 0xfffd,
  0x81aa, 0x8218, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x856f, 0x854c,
  0xfffd, 0x8542, 0xfffd, 0x855c, 0x8570, 0x855f, 0xfffd, 0x855a,
  0x854b, 0x853f, 0x878a, 0xfffd, 0x878b, 0x87a1, 0x878e, 0xfffd,
  0xfffd, 0x8799, 0x885e, 0x885f, 0x8924, 0x89a7, 0x8aea, 0x8afd,
  0x8af9, 0x8ae3, 0x8ae5, 0xfffd, 0xfffd, 0x8aec, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x8cf2, 0xfffd, 0x8cef, 0xfffd, 0x8da6, 0xfffd,
  0xfffd, 0xfffd, 0x8e3b, 0x8e43, 0xfffd, 0x8e32,
  /* 0x53 */
  0x8f31, 0x8f30, 0xfffd, 0x8f2d, 0x8f3c, 0x8fa7, 0x8fa5, 0xfffd,
  0xfffd, 0xfffd, 0x9137, 0x9195, 0x918e, 0xfffd, 0x9196, 0xfffd,
  0x9345, 0x930a, 0xfffd, 0xfffd, 0x92fd, 0x9317, 0x931c, 0x9307,
  0x9331, 0x9332, 0x932c, 0x9330, 0x9303, 0x9305, 0xfffd, 0x95c2,
  0xfffd, 0x95b8, 0xfffd, 0x95c1, 0xfffd, 0xfffd, 0xfffd, 0x96ab,
  0x96b7, 0xfffd, 0xfffd, 0x9715, 0x9714, 0xfffd, 0xfffd, 0x970c,
  0x9717, 0xfffd, 0x9793, 0xfffd, 0x97d2, 0xfffd, 0xfffd, 0x9836,
  0x9831, 0x9833, 0x983c, 0x982e, 0x983a, 0xfffd, 0x983d, 0xfffd,
  0x98b5, 0x9922, 0x9923, 0x9920, 0x991c, 0x991d, 0xfffd, 0x99a0,
  0xfffd, 0x99ef, 0x99e8, 0x99eb, 0xfffd, 0xfffd, 0xfffd, 0x99e1,
  0x99e6, 0xfffd, 0xfffd, 0x9af8, 0x9af5, 0xfffd, 0xfffd, 0x9b83,
  0x9b94, 0x9b84, 0xfffd, 0x9b8b, 0x9b8f, 0xfffd,
  /* 0x54 */
  0x9b8c, 0xfffd, 0x9b89, 0xfffd, 0x9b8e, 0xfffd, 0xfffd, 0xfffd,
  0x9d24, 0x9d0f, 0xfffd, 0x9d13, 0x9d0a, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0x9d2a, 0x9d1a, 0xfffd, 0x9d27, 0x9d16, 0x9d21, 0xfffd,
  0x9e85, 0x9eac, 0x9ec6, 0x9ec5, 0x9ed7, 0x9f53, 0xfffd, 0x5128,
  0x5127, 0x51df, 0xfffd, 0x5335, 0x53b3, 0xfffd, 0x568a, 0x567d,
  0x5689, 0xfffd, 0x58cd, 0x58d0, 0xfffd, 0x5b2b, 0x5b33, 0x5b29,
  0x5b35, 0x5b31, 0x5b37, 0x5c36, 0x5dbe, 0xfffd, 0x5db9, 0xfffd,
  0x5dbb, 0xfffd, 0x61e2, 0x61db, 0x61dd, 0x61dc, 0x61da, 0xfffd,
  0x61d9, 0xfffd, 0xfffd, 0x64df, 0xfffd, 0xfffd, 0x64e1, 0xfffd,
  0x64ee, 0xfffd, 0x65b5, 0x66d4, 0x66d5, 0xfffd, 0x66d0, 0x66d1,
  0x66ce, 0x66d7, 0xfffd, 0xfffd, 0x6a7d, 0x6a8a, 0xfffd, 0x6aa7,
  0xfffd, 0x6a99, 0x6a82, 0x6a88, 0xfffd, 0xfffd,
  /* 0x55 */
  0x6a86, 0xfffd, 0x6a98, 0x6a9d, 0xfffd, 0xfffd, 0x6a8f, 0xfffd,
  0x6aaa, 0xfffd, 0x6b5d, 0xfffd, 0x6c0a, 0xfffd, 0x6fd7, 0x6fd6,
  0x6fe5, 0xfffd, 0xfffd, 0xfffd, 0x6fd9, 0x6fda, 0x6fea, 0xfffd,
  0x6ff6, 0xfffd, 0xfffd, 0x71e3, 0xfffd, 0x71e9, 0xfffd, 0x71eb,
  0x71ef, 0x71f3, 0x71ea, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x7371, 0xfffd, 0x74ae, 0xfffd, 0x74b3, 0xfffd, 0x74ac, 0xfffd,
  0xfffd, 0x7583, 0x7645, 0x764e, 0x7644, 0x76a3, 0x76a5, 0x77a6,
  0x77a4, 0xfffd, 0x77a9, 0x77af, 0xfffd, 0xfffd, 0xfffd, 0x78f0,
  0x78f8, 0x78f1, 0xfffd, 0x7a49, 0xfffd, 0xfffd, 0xfffd, 0x7ac2,
  0x7af2, 0x7af3, 0x7bfa, 0xfffd, 0x7bf6, 0x7bfc, 0x7c18, 0x7c08,
  0x7c12, 0xfffd, 0xfffd, 0x7cdb, 0x7cda, 0xfffd, 0xfffd, 0xfffd,
  0x7e2c, 0x7e4d, 0xfffd, 0xfffd, 0x7f46, 0x7ff6,
  /* 0x56 */
  0x802b, 0x8074, 0x81b8, 0x81c8, 0xfffd, 0xfffd, 0xfffd, 0x8592,
  0x8593, 0xfffd, 0x857f, 0x85ab, 0x8597, 0xfffd, 0xfffd, 0x85ac,
  0xfffd, 0xfffd, 0xfffd, 0x87ce, 0xfffd, 0x87cd, 0xfffd, 0xfffd,
  0x87c1, 0x87b1, 0x87c7, 0xfffd, 0x8940, 0xfffd, 0x893f, 0x8939,
  0xfffd, 0x8943, 0xfffd, 0xfffd, 0xfffd, 0x89ab, 0xfffd, 0x8b1f,
  0x8b09, 0x8b0c, 0xfffd, 0xfffd, 0x8c40, 0xfffd, 0x8c96, 0xfffd,
  0x8cf6, 0x8cf7, 0xfffd, 0x8e46, 0x8e4f, 0xfffd, 0xfffd, 0xfffd,
  0x8f3d, 0x8f41, 0x9366, 0x9378, 0x935d, 0x9369, 0x9374, 0x937d,
  0x936e, 0x9372, 0x9373, 0x9362, 0x9348, 0x9353, 0x935f, 0x9368,
  0xfffd, 0x937f, 0x936b, 0xfffd, 0x95c4, 0xfffd, 0x96af, 0x96ad,
  0x96b2, 0xfffd, 0xfffd, 0x971a, 0x971b, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0x979b, 0x979f, 0xfffd, 0xfffd, 0xfffd,
  /* 0x57 */
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9840, 0xfffd, 0x9847,
  0xfffd, 0x98b7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x99a2,
  0xfffd, 0xfffd, 0x9a00, 0x99f3, 0xfffd, 0xfffd, 0x99f5, 0xfffd,
  0xfffd, 0x9abd, 0x9b00, 0x9b02, 0xfffd, 0x9b34, 0x9b49, 0x9b9f,
  0xfffd, 0x9ba3, 0x9bcd, 0x9b99, 0x9b9d, 0xfffd, 0xfffd, 0x9d39,
  0xfffd, 0x9d44, 0xfffd, 0xfffd, 0x9d35, 0xfffd, 0xfffd, 0x9eaf,
  0xfffd, 0x512f, 0xfffd, 0xfffd, 0x9f8e, 0xfffd, 0x569f, 0x569b,
  0x569e, 0x5696, 0x5694, 0x56a0, 0xfffd, 0x5b3b, 0xfffd, 0xfffd,
  0x5b3a, 0x5dc1, 0x5f4d, 0x5f5d, 0x61f3, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0x64f6, 0x64e5, 0x64ea, 0x64e7, 0x6505, 0xfffd, 0x64f9,
  0xfffd, 0xfffd, 0xfffd, 0x6aab, 0x6aed, 0x6ab2, 0x6ab0, 0x6ab5,
  0x6abe, 0x6ac1, 0x6ac8, 0xfffd, 0x6ac0, 0x6abc,
  /* 0x58 */
  0x6ab1, 0x6ac4, 0x6abf, 0xfffd, 0xfffd, 0x7008, 0x7003, 0x6ffd,
  0x7010, 0x7002, 0x7013, 0xfffd, 0x71fa, 0x7200, 0x74b9, 0x74bc,
  0xfffd, 0x765b, 0x7651, 0x764f, 0x76eb, 0x77b8, 0xfffd, 0x77b9,
  0x77c1, 0x77c0, 0x77be, 0x790b, 0xfffd, 0x7907, 0x790a, 0x7908,
  0xfffd, 0x790d, 0x7906, 0x7915, 0x79af, 0xfffd, 0xfffd, 0xfffd,
  0x7af5, 0xfffd, 0xfffd, 0x7c2e, 0xfffd, 0x7c1b, 0xfffd, 0x7c1a,
  0x7c24, 0xfffd, 0xfffd, 0x7ce6, 0x7ce3, 0xfffd, 0xfffd, 0x7e5d,
  0x7e4f, 0x7e66, 0x7e5b, 0x7f47, 0x7fb4, 0xfffd, 0xfffd, 0xfffd,
  0x7ffa, 0x802e, 0xfffd, 0xfffd, 0x81ce, 0xfffd, 0xfffd, 0x8219,
  0xfffd, 0xfffd, 0x85cc, 0x85b2, 0xfffd, 0x85bb, 0x85c1, 0xfffd,
  0xfffd, 0xfffd, 0x87e9, 0x87ee, 0x87f0, 0x87d6, 0x880e, 0x87da,
  0x8948, 0x894a, 0x894e, 0x894d, 0x89b1, 0x89b0,
  /* 0x59 */
  0x89b3, 0xfffd, 0x8b38, 0x8b32, 0xfffd, 0x8b2d, 0xfffd, 0x8b34,
  0xfffd, 0x8b29, 0x8c74, 0xfffd, 0xfffd, 0x8d03, 0xfffd, 0xfffd,
  0x8da9, 0x8e58, 0xfffd, 0xfffd, 0x8ebf, 0x8ec1, 0x8f4a, 0x8fac,
  0xfffd, 0x9089, 0x913d, 0x913c, 0x91a9, 0x93a0, 0xfffd, 0x9390,
  0xfffd, 0x9393, 0x938b, 0x93ad, 0x93bb, 0x93b8, 0xfffd, 0xfffd,
  0x939c, 0x95d8, 0x95d7, 0xfffd, 0xfffd, 0xfffd, 0x975d, 0x97a9,
  0x97da, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x9854, 0xfffd, 0x9855,
  0x984b, 0xfffd, 0x983f, 0x98b9, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x9938, 0x9936, 0x9940, 0xfffd, 0x993b, 0x9939, 0x99a4, 0xfffd,
  0xfffd, 0x9a08, 0x9a0c, 0xfffd, 0x9a10, 0xfffd, 0x9b07, 0xfffd,
  0x9bd2, 0xfffd, 0x9bc2, 0x9bbb, 0x9bcc, 0x9bcb, 0xfffd, 0xfffd,
  0x9d4d, 0x9d63, 0x9d4e, 0xfffd, 0x9d50, 0x9d55,
  /* 0x5a */
  0xfffd, 0x9d5e, 0xfffd, 0x9e90, 0x9eb2, 0x9eb1, 0xfffd, 0x9eca,
  0x9f02, 0x9f27, 0x9f26, 0xfffd, 0x56af, 0x58e0, 0x58dc, 0xfffd,
  0x5b39, 0xfffd, 0xfffd, 0x5b7c, 0x5bf3, 0xfffd, 0xfffd, 0x5c6b,
  0x5dc4, 0x650b, 0x6508, 0x650a, 0xfffd, 0xfffd, 0x65dc, 0xfffd,
  0xfffd, 0x66e1, 0x66df, 0x6ace, 0x6ad4, 0x6ae3, 0x6ad7, 0x6ae2,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x6ad8, 0x6ad5, 0x6ad2, 0xfffd,
  0xfffd, 0x701e, 0x702c, 0x7025, 0x6ff3, 0x7204, 0x7208, 0x7215,
  0xfffd, 0x74c4, 0x74c9, 0x74c7, 0x74c8, 0x76a9, 0x77c6, 0x77c5,
  0x7918, 0x791a, 0x7920, 0xfffd, 0x7a66, 0x7a64, 0x7a6a, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x7c35, 0x7c34, 0xfffd,
  0xfffd, 0x7e6c, 0xfffd, 0x7e6e, 0x7e71, 0xfffd, 0x81d4, 0x81d6,
  0x821a, 0x8262, 0x8265, 0x8276, 0x85db, 0x85d6,
  /* 0x5b */
  0xfffd, 0x85e7, 0xfffd, 0xfffd, 0x85f4, 0xfffd, 0x87fd, 0x87d5,
  0x8807, 0xfffd, 0x880f, 0x87f8, 0xfffd, 0xfffd, 0x8987, 0xfffd,
  0x89b5, 0x89f5, 0xfffd, 0x8b3f, 0x8b43, 0x8b4c, 0xfffd, 0x8d0b,
  0x8e6b, 0x8e68, 0x8e70, 0x8e75, 0x8e77, 0xfffd, 0x8ec3, 0xfffd,
  0x93e9, 0x93ea, 0x93cb, 0x93c5, 0x93c6, 0xfffd, 0x93ed, 0x93d3,
  0xfffd, 0x93e5, 0xfffd, 0xfffd, 0x93db, 0x93eb, 0x93e0, 0x93c1,
  0xfffd, 0xfffd, 0x95dd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x97b2, 0x97b4, 0x97b1, 0x97b5,
  0x97f2, 0xfffd, 0xfffd, 0xfffd, 0x9856, 0xfffd, 0xfffd, 0xfffd,
  0x9944, 0xfffd, 0x9a26, 0x9a1f, 0x9a18, 0x9a21, 0x9a17, 0xfffd,
  0x9b09, 0xfffd, 0xfffd, 0x9bc5, 0x9bdf, 0xfffd, 0x9be3, 0xfffd,
  0x9be9, 0x9bee, 0xfffd, 0xfffd, 0x9d66, 0x9d7a,
  /* 0x5c */
  0xfffd, 0x9d6e, 0x9d91, 0x9d83, 0x9d76, 0x9d7e, 0x9d6d, 0xfffd,
  0x9e95, 0x9ee3, 0xfffd, 0xfffd, 0x9f03, 0x9f04, 0xfffd, 0x9f17,
  0xfffd, 0x5136, 0xfffd, 0x5336, 0xfffd, 0x5b42, 0xfffd, 0xfffd,
  0x5b44, 0x5b46, 0x5b7e, 0x5dca, 0x5dc8, 0x5dcc, 0x5ef0, 0xfffd,
  0x6585, 0x66e5, 0x66e7, 0xfffd, 0xfffd, 0xfffd, 0x6af4, 0xfffd,
  0x6ae9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x703d, 0xfffd,
  0x7036, 0xfffd, 0x7216, 0xfffd, 0x7212, 0x720f, 0x7217, 0x7211,
  0x720b, 0xfffd, 0xfffd, 0x74cd, 0x74d0, 0x74cc, 0x74ce, 0x74d1,
  0xfffd, 0x7589, 0xfffd, 0x7a6f, 0x7c4b, 0x7c44, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0xfffd, 0x7e7f, 0x8b71, 0xfffd, 0x802f, 0x807a,
  0x807b, 0x807c, 0xfffd, 0xfffd, 0xfffd, 0x85fc, 0x8610, 0x8602,
  0xfffd, 0xfffd, 0x85ee, 0x8603, 0xfffd, 0x860d,
  /* 0x5d */
  0x8613, 0x8608, 0x860f, 0x8818, 0x8812, 0xfffd, 0xfffd, 0x8967,
  0x8965, 0x89bb, 0x8b69, 0x8b62, 0xfffd, 0x8b6e, 0xfffd, 0x8b61,
  0xfffd, 0x8b64, 0x8b4d, 0x8c51, 0xfffd, 0xfffd, 0x8e83, 0x8ec6,
  0xfffd, 0x941f, 0xfffd, 0x9404, 0x9417, 0x9408, 0x9405, 0xfffd,
  0x93f3, 0x941e, 0x9402, 0x941a, 0x941b, 0x9427, 0x941c, 0xfffd,
  0x96b5, 0xfffd, 0xfffd, 0x9733, 0xfffd, 0x9734, 0x9731, 0x97b8,
  0x97ba, 0xfffd, 0x97fc, 0xfffd, 0xfffd, 0x98c3, 0xfffd, 0x994d,
  0xfffd, 0x9a2f, 0xfffd, 0xfffd, 0xfffd, 0x9ac9, 0xfffd, 0x9ac8,
  0x9ac4, 0x9b2a, 0x9b38, 0x9b50, 0xfffd, 0x9c0a, 0x9bfb, 0x9c04,
  0x9bfc, 0x9bfe, 0xfffd, 0xfffd, 0xfffd, 0x9c02, 0x9bf6, 0x9c1b,
  0x9bf9, 0x9c15, 0x9c10, 0x9bff, 0x9c00, 0x9c0c, 0xfffd, 0xfffd,
  0x9d95, 0x9da5, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  /* 0x5e */
  0x9e98, 0x9ec1, 0xfffd, 0x9f5a, 0x5164, 0x56bb, 0xfffd, 0x58e6,
  0x5b49, 0x5bf7, 0xfffd, 0xfffd, 0x5dd0, 0xfffd, 0x5fc2, 0xfffd,
  0x6511, 0xfffd, 0x6aff, 0x6afe, 0x6afd, 0xfffd, 0x6b01, 0xfffd,
  0xfffd, 0x704b, 0x704d, 0x7047, 0x74d3, 0x7668, 0x7667, 0xfffd,
  0xfffd, 0x77d1, 0x7930, 0x7932, 0x792e, 0xfffd, 0x9f9d, 0x7ac9,
  0x7ac8, 0xfffd, 0x7c56, 0x7c51, 0xfffd, 0xfffd, 0xfffd, 0x7e85,
  0x7e89, 0x7e8e, 0x7e84, 0xfffd, 0x826a, 0x862b, 0x862f, 0x8628,
  0xfffd, 0x8616, 0x8615, 0x861d, 0x881a, 0xfffd, 0xfffd, 0xfffd,
  0x89bc, 0x8b75, 0x8b7c, 0xfffd, 0x8d11, 0x8d12, 0x8f5c, 0x91bb,
  0xfffd, 0x93f4, 0xfffd, 0xfffd, 0x942d, 0xfffd, 0xfffd, 0x96e4,
  0x9737, 0x9736, 0x9767, 0x97be, 0x97bd, 0x97e2, 0x9868, 0x9866,
  0x98c8, 0x98ca, 0x98c7, 0x98dc, 0xfffd, 0x994f,
  /* 0x5f */
  0x99a9, 0x9a3c, 0xfffd, 0x9a3b, 0x9ace, 0xfffd, 0x9b14, 0x9b53,
  0xfffd, 0x9c2e, 0xfffd, 0x9c1f, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x9db0, 0x9dbd, 0xfffd, 0xfffd, 0x9dae, 0x9dc4, 0x9e7b, 0xfffd,
  0xfffd, 0x9e9e, 0xfffd, 0x9f05, 0xfffd, 0x9f69, 0x9fa1, 0x56c7,
  0x571d, 0x5b4a, 0x5dd3, 0xfffd, 0x5f72, 0x6202, 0xfffd, 0x6235,
  0x6527, 0x651e, 0x651f, 0xfffd, 0xfffd, 0x6b07, 0x6b06, 0xfffd,
  0xfffd, 0x7054, 0x721c, 0x7220, 0x7af8, 0xfffd, 0x7c5d, 0x7c58,
  0xfffd, 0x7e92, 0x7f4e, 0xfffd, 0xfffd, 0xfffd, 0x8827, 0xfffd,
  0x8b81, 0x8b83, 0xfffd, 0x8c44, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x9442, 0x944d, 0x9454, 0x944e, 0xfffd, 0x9443, 0xfffd, 0xfffd,
  0x973c, 0x9740, 0x97c0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x995a,
  0x9a51, 0xfffd, 0x9add, 0xfffd, 0xfffd, 0x9c38,
  /* 0x60 */
  0xfffd, 0x9c45, 0x9c3a, 0xfffd, 0x9c35, 0xfffd, 0xfffd, 0xfffd,
  0x9ef1, 0xfffd, 0x9f93, 0x529a, 0xfffd, 0xfffd, 0x8641, 0x5dd7,
  0xfffd, 0x6528, 0xfffd, 0xfffd, 0xfffd, 0x7053, 0x7059, 0xfffd,
  0x7221, 0xfffd, 0x766f, 0x7937, 0x79b5, 0x7c62, 0x7c5e, 0x7cf5,
  0xfffd, 0xfffd, 0x863d, 0xfffd, 0x882d, 0x8989, 0x8b8d, 0x8b87,
  0x8b90, 0x8d1a, 0x8e99, 0xfffd, 0xfffd, 0xfffd, 0x945f, 0xfffd,
  0xfffd, 0x9456, 0x9461, 0x945b, 0x945a, 0x945c, 0x9465, 0xfffd,
  0x9741, 0xfffd, 0xfffd, 0x986e, 0x986c, 0x986d, 0xfffd, 0x99aa,
  0x9a5c, 0x9a58, 0x9ade, 0xfffd, 0x9c4f, 0x9c51, 0xfffd, 0x9c53,
  0xfffd, 0xfffd, 0xfffd, 0x9dfc, 0x9f39, 0xfffd, 0x513e, 0xfffd,
  0x56d2, 0xfffd, 0x5b4f, 0x6b14, 0xfffd, 0x7a72, 0x7a73, 0xfffd,
  0xfffd, 0xfffd, 0x8b91, 0xfffd, 0xfffd, 0x91bf,
  /* 0x61 */
  0xfffd, 0x946c, 0xfffd, 0xfffd, 0x96e6, 0x9745, 0xfffd, 0x97c8,
  0x97e4, 0x995d, 0xfffd, 0x9b21, 0xfffd, 0x9b2c, 0x9b57, 0xfffd,
  0xfffd, 0x9c5d, 0x9c61, 0x9c65, 0x9e08, 0xfffd, 0xfffd, 0xfffd,
  0xfffd, 0xfffd, 0x9f45, 0xfffd, 0xfffd, 0x6205, 0x66ef, 0x6b1b,
  0x6b1d, 0x7225, 0x7224, 0x7c6d, 0xfffd, 0x8642, 0x8649, 0xfffd,
  0x8978, 0x898a, 0x8b97, 0xfffd, 0x8c9b, 0x8d1c, 0xfffd, 0x8ea2,
  0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
  0x9c6c, 0xfffd, 0x9c6f, 0xfffd, 0x9e0e, 0xfffd, 0x9f08, 0x9f1d,
  0x9fa3, 0xfffd, 0xfffd, 0x5f60, 0x6b1c, 0xfffd, 0xfffd, 0xfffd,
  0x7cf3, 0xfffd, 0x8b9b, 0x8ea7, 0x91c4, 0xfffd, 0x947a, 0xfffd,
  0xfffd, 0x9a61, 0x9a63, 0x9ad7, 0x9c76, 0xfffd, 0x9fa5, 0xfffd,
  0x7067, 0xfffd, 0x72ab, 0x864a, 0x897d, 0x8b9d,
  /* 0x62 */
  0x8c53, 0x8f65, 0x947b, 0xfffd, 0x98cd, 0x98dd, 0xfffd, 0x9b30,
  0x9e16, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0x96e7, 0x9e18,
  0x9ea2, 0xfffd, 0x9f7c, 0xfffd, 0x7e9e, 0x9484, 0xfffd, 0x9e1c,
  0xfffd, 0x7c71, 0x97ca, 0xfffd, 0xfffd, 0xfffd, 0x9ea3, 0xfffd,
  0x9c7b, 0x9f97, 0xfffd, 0xfffd, 0x9750,
};

static int
cns11643_3_mbtowc (conv_t conv, ucs4_t *pwc, const unsigned char *s, int n)
{
  unsigned char c1 = s[0];
  if ((c1 >= 0x21 && c1 <= 0x62)) {
    if (n >= 2) {
      unsigned char c2 = s[1];
      if (c2 >= 0x21 && c2 < 0x7f) {
        unsigned int i = 94 * (c1 - 0x21) + (c2 - 0x21);
        unsigned short wc = 0xfffd;
        {
          if (i < 6147)
            wc = cns11643_3_2uni_page21[i];
        }
        if (wc != 0xfffd) {
          *pwc = (ucs4_t) wc;
          return 2;
        }
      }
      return RET_ILSEQ;
    }
    return RET_TOOFEW(0);
  }
  return RET_ILSEQ;
}

