/* prototype declarations for Dominion: I plan on switching to ANSI C */

#include "dominion.h"

#ifndef _PROTO_H___
#define _PROTO_H___

char *contents(int money, int metal, int jewels, int food,
	       int people, int army, Pt *title, int sp);
Sarmy *get_army(Snation *np, int id);
void init_screen();
void online_info();
void read_races();
void read_world(Sworld *wp, char fname[]);
void load_world_options();
int check_compressed_world();
int read_int(FILE *fp, int *valp);
int write_int(FILE *fp, int value);
void read_sector(FILE *fp, Ssector *sp);
void write_sector(FILE *fp, Ssector *sp);
void write_geo(FILE *fp, Sgeo *geo);
void write_nation(Snation *np, FILE *fp);
void write_nation_struct(FILE *fp, Snation *np);
int write_army(FILE *fp, Sarmy *ap);
int write_point_list(FILE *fp, struct pt_list *plist);
void read_nation_struct(FILE *fp, Snation *np);
int read_army(FILE *fp, Sarmy *ap);
void insert_army_nation(Snation *np, Sarmy *ap, int chosen_id);
void insert_army_sector(Ssector *sp, Sarmy *ap);
void read_point_list(FILE *fp, struct pt_list *plist);
void load_master_execs();
void print_nations();
void usageerr(int argc, char *argv[]);
void init();
void init_user(int innation, char nation[]);
void init_keymap();
void noncritical(), critical();
void intro(Sworld *wp, Snation *np);
void main_loop();
void cleanup();
int is_master_lock();
void read_initial_diplo(Sdiplo **dm, int n);
int read_in_diplo(Sdiplo **dm, int n);
void read_diplo_item(FILE *fp, Sdiplo *dm);
void statline(char s1[], char s2[]);
void statline2(char s1[], char s2[]);
void statline2_err(char s1[], char s2[]);
char pager(char fname[]);
void draw_map_regular();
void draw_map_compact();
void draw_map();
void set_cursor();
int to_getch();
int re_center(int x, int y);
void wrap(Pt *pp);
int army_is_in_sector(Ssector *sp, int owner, int id);
int first_sect_army(Ssector *sp);
int sect_n_armies(Ssector *sp);
void get_army_status(Sarmy *ap, char s[]);
void addsector(Snation *np, int x, int y);

void gen_exec(char *s);
void clean_exit();
void del_lock(int id);
int is_active_ntn(Snation *np);
int torus_wrapx(int x, int y);
int torus_wrapy(int x, int y);
int latitude(int x, int y);
int torus_latitude(int y);
int xdist(int x, int y, int x1, int y1);
int ydist(int x, int y, int x1, int y1);
int are_patrols(Snation *np, Sarmy *moving_ap, Ssector *sp);
int get_diplo_status(Sdiplo **dm, int nation1, int nation2);
void read_geo(FILE *fp, Sgeo *geo);
void read_nation(Snation *np, FILE *fp, Sworld *wp);
void load_options(Snation *np);
void load_bonds(Snation *np);
void init_wrap();
int sect_is_patrolled(Ssector *sp, int flag);
int is_coastal_sect(Snation *np, Ssector *sp, Sarmy *ap);
void write_world(Sworld *wp, char fname[]);
void read_races();
void set_master_lock();
void mem_error();
void init_options(Snation *np);
void load_options(Snation *np);
void save_options(Snation *np);
int assign_race(Snation *np, char racename[]);
void convert_point_to_net(Pt *to, Pt *from);
void convert_cargo_to_net(Scargo *to, Scargo *from);
void convert_point_to_host(Pt *to, Pt *from);
void load_nation(int id, Snation *np);
void load_params(Snation *np);
void show_help();
int getexec(FILE *fp, struct argument args[]);
void run_exec_line(Snation *np, struct argument args[]);
int  parse_exec_line(char line[], struct argument args[]);
int are_all_digits(char *s);
void show_nation(Snation *np);
int get_n_civil(Snation *np);
int free_nation_mark(Sworld *wp, Symbol c);
int get_n_soldiers(Snation *np);
void getline(char s[], int n);
void get_crypt_pass(char prompt[], char pass[], WINDOW *w, char def_pass[]);
void cpass(Snation *np, char pass[]);
int which_mark(int x, int y, Suser *up);
int map_alt(int altitude);
void show_file(char name[]);
void delete_army_sector(Ssector *sp, Sarmy *ap);
void delete_army_nation(Snation *np, Sarmy *ap);
int is_spirit(Sarmy *ap);
Sh_spell *is_spelled(Sarmy *ap);
void delete_hanging_spell(Sh_spell *sp1);
void destroy_nation(int id);

int is_under_sectw(int x, int y);
void end_help_win();
void get_space();
void online_info();
int basic_move_rate(Snation *np);
void show_armies(Ssector *sp);
void show_sector(int x, int y);
int xrel(int x, int y, Pt cap);
int yrel(int x, int y, Pt cap);
void get_apparent_type(Sarmy *ap, char type[]);
void load_army_types();
void load_spirit_types();
int get_generic_move_cost(Snation *np, Ssector *sp);
void bad_key();
int write_cargo(FILE *fp, Scargo *cargo);
int read_cargo(FILE *fp, Scargo *cargo);
void redraw();
void write_diplo(FILE *fp, Sdiplo *dm);
void init_diplo(int n);
void set_update_time();
int is_any_lock();
int unique_name(char name[]);
int has_visible_army(Ssector *sp, Suser *up);

void draw_budget_screen(WINDOW *w, Snation *np);

void get_spirits(Suser *up, int skill);
int get_nation_id(char name[]);

void handle_locks(int id);

void get_avail_armies(Suser *up, int skill);
void get_spells(Suser *up, int skill);
void load_h_spells(Suser *up);
void find_visible_sectors(int **visible_sectors);
void army_visibility(int **visible_sectors, Sarmy *ap);
void options();
int mygetch();
void ask_for_forwarding(WINDOW *win);
void ask_for_news_forwarding(WINDOW *win);
void ask_for_editor(WINDOW *win);
void touch_all_wins();
int wget_string(WINDOW *w, char *rets, int len);
void ask_for_mail_reader(WINDOW *win);
void set_lock(int id);
int calc_sect_revenue(Snation *np, Ssector *sp);
int n_workers(Ssector *sp);
int calc_revenue(Snation *np);
int sector_metal(Ssector *sp);
int sector_jewels(Ssector *sp);
int sector_food(Ssector *sp);
int calc_expend(Snation *np);
int military_maint(Snation *np);
int non_profit_maint(Snation *np);
int calc_expend_metal(Snation *np);
int military_maint_metal(Snation *np);
int military_maint_jewels(Snation *np);
int calc_expend_food(Snation *np);
int army_maint_money(Sarmy *ap);
int army_type_index(char type[]);
void convert_race_to_host(Srace *to, Srace *from);
void convert_race_to_net(Srace *to, Srace *from);
int get_army_move_cost(Snation *np, Ssector *sp, Sarmy *ap);

void del_master_lock();
int is_good_order(char name[]);
int get_n_cities(Snation *np);
void statline_prompt(char s1[], char s2[]);
void statline2_prompt(char s1[], char s2[]);
int get_n_students(Snation *np);
int get_n_priests(Snation *np);
int get_spell_pts_maint(Sarmy *ap);
int isolated(int x, int y);
int good_altitude(Ssector *sp, Snation *np);

void storage_budget(Snation *np);
void do_tech_budget(WINDOW *w, Snation *np);
void do_magic_budget(WINDOW *w, Snation *np);
void dump_current_screen(WINDOW *w, char def_filename[]);
int wget_number(WINDOW *w, int *num);
int calc_jewels(Snation *np);
int calc_expend_jewels(Snation *np);
int has_connected_mass(int x, int y, int n_wanted, struct pt_list **ptlist_p);
int sect_desire(Snation *np, int x, int y);
int default_desig(Ssector *sp);
void free_ptlist(struct pt_list *ptlist);
void add_special_mag(Snation *np, char mag_ord[]);
void save_params(Snation *np);
void change_params(Snation *np, WINDOW *w);
void draw_comp_params(WINDOW *w, Snation *np);
void init_params(Snation *np);
int calc_metal(Snation *np);
int calc_food(Snation *np);
int gen_spell_pts(Snation *np);
void draw_storage_budget(WINDOW *w, Snation *np);
int new_tech_skill(Snation *np);
int univ_intel(Snation *np);
void get_new_techno(Snation *np, int old_skill, int new_skill, FILE *mailfile);
void get_tech_entry(FILE *fp, Snation *np, FILE *mailfile);
void skip_tech_entry(FILE *fp);
void dotechno(Snation *np, FILE *mailfile);
void start_help_win();
void just_moved();
int get_max_employed(Ssector *sp);
void name_sector(WINDOW *w);
int redesignate(Snation *np, WINDOW *w, int confirm, int old_desig);
void move_capital(Snation *np, Ssector *sp);
void cmoney(Snation *np, int m);
void cpeople_sector(Ssector *sp, int p);
void cmetal(Snation *np, int m);
void cjewels(Snation *np, int j);
void cspell_pts(Snation *np, int pts);
void cfood(Snation *np, int f);
void ctech_skill(Snation *np, int change);
int mail_send(char mailfile[], int sender, int receiver, char subject[]);
void cmag_skill(Snation *np, int change);
void mail_read(int reader);
void mail_write();
void mail();
int wget_name(WINDOW *w, char *name);
int has_mail_lock(int id);
void edit(char *fname);
void lock_mail(int nation);
void unlock_mail(int nation);
void docivilians(Snation *np);
void dobattles();
void update_diplo();
void post_statistics();
void remove_all_dead_hspells();
void clear_h_spells();
void lock_diplo(Snation *np);
void unlock_diplo();
void handle_meet(Sdiplo **dm, int nation1, int nation2);
int have_met(Sdiplo **dm, int nation1, int nation2);
void get_indices(Sdiplo **dm, int nation1, int nation2, int *n1, int *n2);
int first_sect_mage_id(Snation *np, Ssector *sp);
void list_spells(Suser *up);
void list_spirits(Suser *up);
void summon(Suser *up, WINDOW *w);
void cast_spell(Suser *up, WINDOW *w);
void initiate_mage(Suser *up, WINDOW *w);
void show_hanging_spells(Suser *up);
int is_mage(Sarmy *ap);
int spirit_type_index(char type[]);
void exec_summon(int type_index, char name[]);
void exec_initiate(char name[]);
int exec_spell(Sspell *spellp, WINDOW *w);
int free_army_id(Snation *np);
void aflag_set(Sarmy *ap, int flag);
void zoom_on_h_spell(Sh_spell *h_list, WINDOW *sw);
void zoom_del_h_spell(Sh_spell *h_list, WINDOW *sw, Suser *up);
void fix_sector_line(char line[], char s[]);
void increase_diplo(Sdiplo **dm_old, Sdiplo **dm_new, int n, Snation *np);
void free_diplo(Sdiplo **dm, int n);
void set_diplo_status(Sdiplo **dm, int nation1, int nation2, int New_Status);
int are_allied(int id1, int id2);
int diplo_is_locked();
int effective_status(Sdiplo **dm, int id1, int id2);
int are_at_allied(Sdiplo **dm, int id1, int id2);
int are_at_treaty(Sdiplo **dm, int id1, int id2);
int are_at_war(Sdiplo **dm, int id1, int id2);
void dump_diplo(Snation *np, Sdiplo **dm, int n);
void write_h_spells();
int army_move_rate(Snation *np, Sarmy *ap);
int add_flag(char *s, int flags, int i, int has_slash);
int army_cost(Sarmy *ap);
int is_army(Sarmy *ap);
int army_cost_metal(Sarmy *ap);
int army_cost_jewels(Sarmy *ap);
void change_dip_status(Sdiplo **dm, Sdiplo **initial_dm, int n1, int n2);
void report_menu();
char diplo_report(Snation *np);
char budget_report(Snation *np);
char bonds_report(Snation *np);
void army_menu();
void move_army(int id, WINDOW *aw);
int jarmy();
void transport();
void previous_army();
void next_army();
void change_army_status(WINDOW *aw, int id);
void list_available_armies(Suser *up, WINDOW *aw);
void draft_army(Snation *np);
void zoom_armies(Suser *up, Ssector *sp);
void army_merge(Sarmy *ap);
int prev_nation_army(Snation *np, int old_id);
int next_nation_army(Snation *np, int old_id);
void army_disband(Ssector *sp, Sarmy *ap);
void army_examine(Sarmy *ap);
void army_split(Sarmy *ap);
int cargo_not_empty(Scargo *cargop);
void donate_army(Sarmy *ap, Ssector *sp);
int next_sect_army(Ssector *sp, Sarmy *ap);
int prev_sect_army(Ssector *sp, Sarmy *ap);
int can_occupy(Sarmy *ap);
int can_patrol(Sarmy *ap);
int can_intercept(Sarmy *ap);
int can_garrison(Sarmy *ap);
int is_trade_place(Ssector *sp);
int legal_move(Pt pt, Snation *np, int id);
int army_move_comment(char *s);
int is_avail_army_type(Suser *up, char type[]);
void army_name(Sarmy *ap);
void zoom_army_page(WINDOW *azlw, Sarmy *armies, Ssector *sp,
		    int page, int len_page, int show_cargo);
void zoom_list_armies(WINDOW *azlw, Sarmy *armies, struct armyid *aid,
		      int start_army, int len_win, int cargo);
void donate_cargo(int x, int y, int from_id, int to_id, Scargo *cargo);
void draw_info_screen(WINDOW *w, Snation *np);
void change_passwd(Snation *np);
void change_leader(Snation *np, WINDOW *w);
int priestliness(Snation *np);
int military_maint_spell_pts(Snation *np);
void draw_production_screen(WINDOW *w, Snation *np);
int get_employed(Snation *np);
int get_emp_met(Snation *np);
int get_emp_jwl(Snation *np);
int get_emp_farm(Snation *np);
int get_emp_serv(Snation *np);
int get_unemployed(Snation *np);
int get_unemp_met(Snation *np);
int get_unemp_jwl(Snation *np);
int get_unemp_farm(Snation *np);
int get_unemp_serv(Snation *np);
int calc_serv_revenue(Snation *np);
void my_scr_dump(WINDOW *w, char fname[]);
void my_scr_restore(char fname[]);
int army_weight(Sarmy *ap);
void root_edit();
void root_edit_sector();
void root_edit_nation();
int subtsector(Snation *np, int x, int y);
void cowner_sector(Ssector *sp, int owner);
void csoil_sector(Ssector *sp, int change);
void cmetal_sector(Ssector *sp, int change);
void cjewels_sector(Ssector *sp, int change);
void caltitude_sector(Ssector *sp, int change);
void root_destroy_nation(Snation *np);
char next_free_nation_mark();
char info_report(Snation *np);
void spy_report(int id);
int spy_figure(int n, int expend, Snation *spying_np, Snation *spied_np,
	       int cost_fact);
int spy_tech_steal(int n, int expend, Snation *spying_np, Snation *spied_np);
void spy_found_notification(Snation *spying_np, Snation *spied_np);
int good_army_altitude(Snation *np, Ssector *sp, Sarmy *ap);
void take_capital(Snation *np1, Snation *np2, FILE *mfile);
void post_news_file(char *news_file, char *group_name, char *subject, int id);
void insert_mail(char *in_name, FILE *out_pntr);
void post_news_to_users(char *filename);
int get_avg_money(Sworld *wp);
int get_avg_metal(Sworld *wp);
int get_avg_jewels(Sworld *wp);
int get_avg_food(Sworld *wp);
int get_avg_civil(Sworld *wp);
int get_avg_soldiers(Sworld *wp);
int get_avg_sectors(Sworld *wp);
int get_per_occu_land(Sworld *wp);
int get_per_occu_water(Sworld *wp);
int is_navy(Sarmy *ap);
void add_army_type(Suser *up, char type[]);
int new_mag_skill(Snation *np);
int new_spell_pts(Snation *np);
void list_user_spells(Suser *up);
void show_spell(Sspell *spellp);
void show_spirit(Sspirit *spiritp);
void windows();
int is_valid_spirit_type(Snation *np, char type[]);
int get_n_act_ntn(Sworld *wp);
void fill_work_data(Snation *np);
void move_the_people(Snation *np);
void add_to_plist(struct pt_list **ptlist, int x, int y);
void sort_ptlist(struct pt_list **ptlist);
void aflag_clear(Sarmy *ap, int flag);
void add_h_spell(Sh_spell **listp, Sh_spell *h_spellp);
void prepare_h_spell(Sh_spell *h_spellp, char name[],
		     int nat_id, int thons_left, int n_lines);
void write_h_spells();
int good_loading_place(Snation *np, Ssector *sp, char type, int quantity);
int good_unloading_place(Snation *np, Ssector *sp, char type, int quantity);
void unlock_cargo();
int caravan_weight(Sarmy *ap);
int is_dead_spell(Sh_spell *sp, int flag);
void got_dead_h_spell(Sh_spell *sp1);
void load_all_dead_hspells();
void load_dead_hspells(int id);
void write_dead_spell(Sh_spell *sp1);
int is_army_spell(Sh_spell *sp1);
int h_spell_compare(Sh_spell *sp1, Sh_spell *sp2);
void reset_spelled_flags();
void free_h_spell(Sh_spell *sp1);
void reset_one_spell(Sh_spell *sp1);
void move_space_avail(Snation *np, struct pt_list *curr_pt,
		     int *peop, int tot_emp, int tot_peop);
void mail_reader(char *fname);

#endif /* _PROTO_H___ */
