/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.MeasureListener;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class Array
extends EDialog {
    private static final int SPACING_EDGE = 1;
    private static final int SPACING_CENTER = 2;
    private static final int SPACING_ESSENTIALBND = 3;
    private static final int SPACING_MEASURED = 4;
    private static int lastXRepeat = 1;
    private static int lastYRepeat = 1;
    private static double lastXDistance = 0.0;
    private static double lastYDistance = 0.0;
    private static boolean lastXFlip = false;
    private static boolean lastYFlip = false;
    private static boolean lastXStagger = false;
    private static boolean lastYStagger = false;
    private static boolean lastXCenter = false;
    private static boolean lastYCenter = false;
    private static boolean lastLinearDiagonal = false;
    private static boolean lastAddNames = false;
    private static boolean lastDRCGood = false;
    private static boolean lastTranspose = false;
    private static int lastSpacingType = 1;
    private double spacingOverX;
    private double spacingOverY;
    private double spacingCenterlineX;
    private double spacingCenterlineY;
    private double essentialBndX;
    private double essentialBndY;
    private double spacingMeasuredX;
    private double spacingMeasuredY;
    private HashMap<Geometric, Geometric> selected;
    private Rectangle2D bounds;
    private JButton cancel;
    private JCheckBox centerXAboutOriginal;
    private JCheckBox centerYAboutOriginal;
    private JCheckBox flipAlternateColumns;
    private JCheckBox flipAlternateRows;
    private JCheckBox generateArrayIndices;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JCheckBox linearDiagonalArray;
    private JButton ok;
    private JCheckBox onlyDRCCorrect;
    private JRadioButton spaceByCenterlineDistance;
    private JRadioButton spaceByEdgeOverlap;
    private JRadioButton spaceByEssentialBnd;
    private JRadioButton spaceByMeasuredDistance;
    private ButtonGroup spacing;
    private JCheckBox staggerAlternateColumns;
    private JCheckBox staggerAlternateRows;
    private JCheckBox transposePlacement;
    private JLabel xOverlapLabel;
    private JTextField xRepeat;
    private JTextField xSpacing;
    private JLabel yOverlapLabel;
    private JTextField yRepeat;
    private JTextField ySpacing;

    public static void showArrayDialog() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot array: nothing is highlighted in this window.");
            return;
        }
        List<Geometric> highs = highlighter.getHighlightedEObjs(true, true);
        if (highs.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Select some objects before arraying them.");
            return;
        }
        Array dialog = new Array(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private Array(Frame parent) {
        super(parent, true);
        Dimension2D dim;
        ElectricObject eObj;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.xRepeat.setText(Integer.toString(lastXRepeat));
        this.flipAlternateColumns.setSelected(lastXFlip);
        this.staggerAlternateColumns.setSelected(lastXStagger);
        this.centerXAboutOriginal.setSelected(lastXCenter);
        this.yRepeat.setText(Integer.toString(lastYRepeat));
        this.flipAlternateRows.setSelected(lastYFlip);
        this.staggerAlternateRows.setSelected(lastYStagger);
        this.centerYAboutOriginal.setSelected(lastYCenter);
        this.onlyDRCCorrect.setEnabled(false);
        EditWindow wnd = EditWindow.getCurrent();
        List<Geometric> highs = wnd.getHighlighter().getHighlightedEObjs(true, true);
        if (highs.size() == 1 && (eObj = (ElectricObject)highs.get(0)) instanceof NodeInst) {
            this.onlyDRCCorrect.setEnabled(true);
        }
        this.linearDiagonalArray.setSelected(lastLinearDiagonal);
        this.generateArrayIndices.setSelected(lastAddNames);
        this.onlyDRCCorrect.setSelected(lastDRCGood);
        this.transposePlacement.setSelected(lastTranspose);
        this.essentialBndY = 0.0;
        this.essentialBndX = 0.0;
        boolean haveChar = false;
        for (Geometric eObj2 : highs) {
            Cell subCell;
            Rectangle2D spacing;
            NodeInst ni;
            if (!(eObj2 instanceof NodeInst) || !(ni = (NodeInst)eObj2).isCellInstance() || (spacing = (subCell = (Cell)ni.getProto()).findEssentialBounds()) == null) continue;
            double thisDistX = spacing.getWidth();
            double thisDistY = spacing.getHeight();
            if (ni.isMirroredAboutXAxis() ^ ni.isMirroredAboutYAxis()) {
                double swap = thisDistX;
                thisDistX = thisDistY;
                thisDistY = swap;
            }
            if (haveChar && (this.essentialBndX != thisDistX || this.essentialBndY != thisDistY)) {
                haveChar = false;
                break;
            }
            this.essentialBndX = thisDistX;
            this.essentialBndY = thisDistY;
            haveChar = true;
        }
        this.spaceByEssentialBnd.setEnabled(haveChar);
        if (haveChar) {
            if (lastSpacingType == 3) {
                lastXDistance = this.essentialBndX;
                lastYDistance = this.essentialBndY;
            }
        } else if (lastSpacingType == 3) {
            lastSpacingType = 1;
            lastYDistance = 0.0;
            lastXDistance = 0.0;
        }
        if ((dim = MeasureListener.getLastMeasuredDistance()).getWidth() > 0.0 || dim.getHeight() > 0.0) {
            this.spaceByMeasuredDistance.setEnabled(true);
            this.spacingMeasuredX = dim.getWidth();
            this.spacingMeasuredY = dim.getHeight();
            if (lastSpacingType == 4) {
                lastXDistance = this.spacingMeasuredX;
                lastYDistance = this.spacingMeasuredY;
            }
        } else {
            this.spaceByMeasuredDistance.setEnabled(false);
            if (lastSpacingType == 4) {
                lastSpacingType = 1;
                lastYDistance = 0.0;
                lastXDistance = 0.0;
            }
        }
        this.xSpacing.setText(TextUtils.formatDouble(lastXDistance));
        this.ySpacing.setText(TextUtils.formatDouble(lastYDistance));
        switch (lastSpacingType) {
            case 1: {
                this.spaceByEdgeOverlap.setSelected(true);
                break;
            }
            case 2: {
                this.spaceByCenterlineDistance.setSelected(true);
                break;
            }
            case 3: {
                this.spaceByEssentialBnd.setSelected(true);
                break;
            }
            case 4: {
                this.spaceByMeasuredDistance.setSelected(true);
            }
        }
        if (lastSpacingType == 1) {
            this.xOverlapLabel.setText("X edge overlap:");
            this.yOverlapLabel.setText("Y edge overlap:");
        } else {
            this.xOverlapLabel.setText("X centerline distance:");
            this.yOverlapLabel.setText("Y centerline distance:");
        }
        this.selected = new HashMap();
        for (Geometric eObj3 : highs) {
            if (eObj3 instanceof NodeInst) {
                this.selected.put(eObj3, eObj3);
                continue;
            }
            if (!(eObj3 instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)eObj3;
            NodeInst niHead = ai.getHeadPortInst().getNodeInst();
            this.selected.put(niHead, niHead);
            NodeInst niTail = ai.getTailPortInst().getNodeInst();
            this.selected.put(niTail, niTail);
            this.selected.put(ai, ai);
        }
        boolean first = true;
        this.bounds = new Rectangle2D.Double();
        for (Geometric geom : this.selected.keySet()) {
            if (first) {
                this.bounds.setRect(geom.getBounds());
                first = false;
                continue;
            }
            Rectangle2D.union(this.bounds, geom.getBounds(), this.bounds);
        }
        this.spacingCenterlineX = this.bounds.getWidth();
        this.spacingCenterlineY = this.bounds.getHeight();
        this.spacingOverY = 0.0;
        this.spacingOverX = 0.0;
        this.spaceByEdgeOverlap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByCenterlineDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByEssentialBnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByMeasuredDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.finishInitialization();
        this.pack();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void newSpacingSelected() {
        double x = TextUtils.atof(this.xSpacing.getText());
        double y = TextUtils.atof(this.ySpacing.getText());
        switch (lastSpacingType) {
            case 1: {
                this.spacingOverX = x;
                this.spacingOverY = y;
                break;
            }
            case 2: {
                this.spacingCenterlineX = x;
                this.spacingCenterlineY = y;
            }
        }
        if (this.spaceByEdgeOverlap.isSelected()) {
            lastSpacingType = 1;
        } else if (this.spaceByCenterlineDistance.isSelected()) {
            lastSpacingType = 2;
        } else if (this.spaceByEssentialBnd.isSelected()) {
            lastSpacingType = 3;
        } else if (this.spaceByMeasuredDistance.isSelected()) {
            lastSpacingType = 4;
        }
        if (lastSpacingType == 1) {
            this.xOverlapLabel.setText("X edge overlap:");
            this.yOverlapLabel.setText("Y edge overlap:");
        } else {
            this.xOverlapLabel.setText("X centerline distance:");
            this.yOverlapLabel.setText("Y centerline distance:");
        }
        switch (lastSpacingType) {
            case 1: {
                x = this.spacingOverX;
                y = this.spacingOverY;
                break;
            }
            case 2: {
                x = this.spacingCenterlineX;
                y = this.spacingCenterlineY;
                break;
            }
            case 3: {
                x = this.essentialBndX;
                y = this.essentialBndY;
                break;
            }
            case 4: {
                x = this.spacingMeasuredX;
                y = this.spacingMeasuredY;
            }
        }
        this.xSpacing.setText(TextUtils.formatDouble(x));
        this.ySpacing.setText(TextUtils.formatDouble(y));
    }

    private void rememberFields() {
        lastXRepeat = (int)TextUtils.getValueOfExpression(this.xRepeat.getText());
        lastXFlip = this.flipAlternateColumns.isSelected();
        lastXStagger = this.staggerAlternateColumns.isSelected();
        lastXCenter = this.centerXAboutOriginal.isSelected();
        lastYRepeat = (int)TextUtils.getValueOfExpression(this.yRepeat.getText());
        lastYFlip = this.flipAlternateRows.isSelected();
        lastYStagger = this.staggerAlternateRows.isSelected();
        lastYCenter = this.centerYAboutOriginal.isSelected();
        lastXDistance = TextUtils.getValueOfExpression(this.xSpacing.getText());
        lastYDistance = TextUtils.getValueOfExpression(this.ySpacing.getText());
        lastLinearDiagonal = this.linearDiagonalArray.isSelected();
        lastAddNames = this.generateArrayIndices.isSelected();
        lastDRCGood = this.onlyDRCCorrect.isSelected();
        lastTranspose = this.transposePlacement.isSelected();
    }

    private void makeArray() {
        int xRepeat = Math.abs(lastXRepeat);
        int yRepeat = Math.abs(lastYRepeat);
        if (xRepeat <= 1 && yRepeat <= 1) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "One dimension of the array must be greater than 1");
            return;
        }
        if (lastLinearDiagonal && xRepeat != 1 && yRepeat != 1) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Diagonal arrays need one dimension to be 1");
            return;
        }
        ArrayList<NodeInst> nodeList = new ArrayList<NodeInst>();
        ArrayList<ArcInst> arcList = new ArrayList<ArcInst>();
        ArrayList<Export> exportList = new ArrayList<Export>();
        Cell cell = null;
        for (Geometric geom : this.selected.keySet()) {
            cell = geom.getParent();
            if (geom instanceof NodeInst) {
                nodeList.add((NodeInst)geom);
                if (!User.isDupCopiesExports()) continue;
                NodeInst ni = (NodeInst)geom;
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    exportList.add(eIt.next());
                }
                continue;
            }
            arcList.add((ArcInst)geom);
        }
        Collections.sort(nodeList);
        Collections.sort(arcList);
        Collections.sort(exportList);
        double xOverlap = lastXDistance;
        double yOverlap = lastYDistance;
        if (lastSpacingType == 1) {
            xOverlap = this.bounds.getWidth() - lastXDistance;
            yOverlap = this.bounds.getHeight() - lastYDistance;
        }
        double cX = this.bounds.getCenterX();
        double cY = this.bounds.getCenterY();
        for (NodeInst ni : nodeList) {
            if (CircuitChangeJobs.cantEdit(cell, ni, true, false, false) == 0) continue;
            return;
        }
        new ArrayStuff(nodeList, arcList, exportList, xRepeat, yRepeat, xOverlap, yOverlap, cX, cY, User.isArcsAutoIncremented());
    }

    private void initComponents() {
        this.spacing = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.xRepeat = new JTextField();
        this.flipAlternateColumns = new JCheckBox();
        this.staggerAlternateColumns = new JCheckBox();
        this.centerXAboutOriginal = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.yRepeat = new JTextField();
        this.flipAlternateRows = new JCheckBox();
        this.staggerAlternateRows = new JCheckBox();
        this.centerYAboutOriginal = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.xOverlapLabel = new JLabel();
        this.xSpacing = new JTextField();
        this.spaceByEdgeOverlap = new JRadioButton();
        this.spaceByCenterlineDistance = new JRadioButton();
        this.yOverlapLabel = new JLabel();
        this.ySpacing = new JTextField();
        this.spaceByEssentialBnd = new JRadioButton();
        this.spaceByMeasuredDistance = new JRadioButton();
        this.linearDiagonalArray = new JCheckBox();
        this.generateArrayIndices = new JCheckBox();
        this.onlyDRCCorrect = new JCheckBox();
        this.transposePlacement = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Array");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Array.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("X repeat factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.xRepeat.setColumns(6);
        this.xRepeat.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xRepeat, gridBagConstraints);
        this.flipAlternateColumns.setText("Flip alternate columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.flipAlternateColumns, gridBagConstraints);
        this.staggerAlternateColumns.setText("Stagger alternate columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.staggerAlternateColumns, gridBagConstraints);
        this.centerXAboutOriginal.setText("Center about original");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.centerXAboutOriginal, gridBagConstraints);
        this.jLabel2.setText("Y repeat factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.yRepeat.setColumns(6);
        this.yRepeat.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yRepeat, gridBagConstraints);
        this.flipAlternateRows.setText("Flip alternate rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.flipAlternateRows, gridBagConstraints);
        this.staggerAlternateRows.setText("Stagger alternate rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.staggerAlternateRows, gridBagConstraints);
        this.centerYAboutOriginal.setText("Center about original");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.centerYAboutOriginal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.xOverlapLabel.setText("X edge overlap:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xOverlapLabel, gridBagConstraints);
        this.xSpacing.setColumns(6);
        this.xSpacing.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xSpacing, gridBagConstraints);
        this.spacing.add(this.spaceByEdgeOverlap);
        this.spaceByEdgeOverlap.setText("Space by edge overlap");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByEdgeOverlap, gridBagConstraints);
        this.spacing.add(this.spaceByCenterlineDistance);
        this.spaceByCenterlineDistance.setText("Space by centerline distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByCenterlineDistance, gridBagConstraints);
        this.yOverlapLabel.setText("Y edge overlap:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yOverlapLabel, gridBagConstraints);
        this.ySpacing.setColumns(6);
        this.ySpacing.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ySpacing, gridBagConstraints);
        this.spacing.add(this.spaceByEssentialBnd);
        this.spaceByEssentialBnd.setText("Space by cell essential bound");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByEssentialBnd, gridBagConstraints);
        this.spacing.add(this.spaceByMeasuredDistance);
        this.spaceByMeasuredDistance.setText("Space by last measured distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByMeasuredDistance, gridBagConstraints);
        this.linearDiagonalArray.setText("Linear diagonal array");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.linearDiagonalArray, gridBagConstraints);
        this.generateArrayIndices.setText("Generate array indices");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.generateArrayIndices, gridBagConstraints);
        this.onlyDRCCorrect.setText("Only place entries that are DRC correct");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.onlyDRCCorrect, gridBagConstraints);
        this.transposePlacement.setText("Transpose placement ordering");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.getContentPane().add((Component)this.transposePlacement, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.rememberFields();
        this.makeArray();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.rememberFields();
        this.setVisible(false);
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayStuff
    extends Job {
        private List<NodeInst> nodeList;
        private List<ArcInst> arcList;
        private List<Export> exportList;
        private int xRepeat;
        private int yRepeat;
        private double xOverlap;
        private double yOverlap;
        private double cX;
        private double cY;
        private boolean arcsAutoIncrement;

        protected ArrayStuff(List<NodeInst> nodeList, List<ArcInst> arcList, List<Export> exportList, int xRepeat, int yRepeat, double xOverlap, double yOverlap, double cX, double cY, boolean arcsAutoIncrement) {
            super("Make Array", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.nodeList = nodeList;
            this.arcList = arcList;
            this.exportList = exportList;
            this.xRepeat = xRepeat;
            this.yRepeat = yRepeat;
            this.xOverlap = xOverlap;
            this.yOverlap = yOverlap;
            this.cX = cX;
            this.cY = cY;
            this.arcsAutoIncrement = arcsAutoIncrement;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Cell cell = this.nodeList.get(0).getParent();
            Geometric[] geomsToCheck = null;
            boolean[] validity = null;
            int checkNodeCount = 0;
            if (lastDRCGood) {
                geomsToCheck = new NodeInst[this.xRepeat * this.yRepeat];
                validity = new boolean[this.xRepeat * this.yRepeat];
                if (this.nodeList.size() == 1) {
                    geomsToCheck[checkNodeCount++] = this.nodeList.get(0);
                }
            }
            int originalX = 0;
            int originalY = 0;
            int total = this.yRepeat * this.xRepeat;
            for (int index = 0; index < total; ++index) {
                int x = index % this.xRepeat;
                int y = index / this.xRepeat;
                if (lastTranspose) {
                    y = index % this.yRepeat;
                    x = index / this.yRepeat;
                }
                int xIndex = x;
                int yIndex = y;
                if (lastXCenter) {
                    xIndex = x - (this.xRepeat - 1) / 2;
                }
                if (lastYCenter) {
                    yIndex = y - (this.yRepeat - 1) / 2;
                }
                if (lastXRepeat < 0) {
                    xIndex = -xIndex;
                }
                if (lastYRepeat < 0) {
                    yIndex = -yIndex;
                }
                if (xIndex == 0 && yIndex == 0) {
                    originalX = x;
                    originalY = y;
                    continue;
                }
                boolean firstNode = true;
                HashMap<NodeInst, NodeInst> nodeMap = new HashMap<NodeInst, NodeInst>();
                for (NodeInst ni : this.nodeList) {
                    double xPos = this.cX + this.xOverlap * (double)xIndex;
                    if (lastLinearDiagonal && this.xRepeat == 1) {
                        xPos = this.cX + this.xOverlap * (double)yIndex;
                    }
                    double yPos = this.cY + this.yOverlap * (double)yIndex;
                    if (lastLinearDiagonal && this.yRepeat == 1) {
                        yPos = this.cY + this.yOverlap * (double)xIndex;
                    }
                    double xOff = ni.getAnchorCenterX() - this.cX;
                    double yOff = ni.getAnchorCenterY() - this.cY;
                    if ((xIndex & 1) != 0 && lastXStagger) {
                        yPos += this.yOverlap / 2.0;
                    }
                    if ((yIndex & 1) != 0 && lastYStagger) {
                        xPos += this.xOverlap / 2.0;
                    }
                    boolean flipX = false;
                    boolean flipY = false;
                    if ((xIndex & 1) != 0 && lastXFlip) {
                        flipX = true;
                        xOff = -xOff;
                    }
                    if ((yIndex & 1) != 0 && lastYFlip) {
                        flipY = true;
                        yOff = -yOff;
                    }
                    Orientation orient = Orientation.fromJava(0, flipX, flipY).concatenate(ni.getOrient());
                    NodeInst newNi = NodeInst.makeInstance(ni.getProto(), new Point2D.Double(xPos += xOff, yPos += yOff), ni.getXSize(), ni.getYSize(), cell, orient, null, 0);
                    if (newNi == null) continue;
                    newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_PROTO);
                    newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
                    if (ni.isExpanded()) {
                        newNi.setExpanded();
                    } else {
                        newNi.clearExpanded();
                    }
                    if (ni.isHardSelect()) {
                        newNi.setHardSelect();
                    } else {
                        newNi.clearHardSelect();
                    }
                    newNi.setTechSpecific(ni.getTechSpecific());
                    newNi.copyVarsFrom(ni);
                    if (lastAddNames) {
                        this.setNewName(newNi, x, y);
                    } else {
                        Name nodeNameKey = ni.getNameKey();
                        if (!nodeNameKey.isTempname()) {
                            newNi.setName(ElectricObject.uniqueObjectName(ni.getName(), cell, NodeInst.class, false));
                            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
                        }
                    }
                    nodeMap.put(ni, newNi);
                    if (!lastDRCGood || !firstNode) continue;
                    geomsToCheck[checkNodeCount++] = newNi;
                    firstNode = false;
                }
                for (ArcInst ai : this.arcList) {
                    NodeInst ni1;
                    NodeInst ni0;
                    double cX0 = ai.getHeadPortInst().getNodeInst().getAnchorCenterX();
                    double cY0 = ai.getHeadPortInst().getNodeInst().getAnchorCenterY();
                    double xOff0 = ai.getHeadLocation().getX() - cX0;
                    double yOff0 = ai.getHeadLocation().getY() - cY0;
                    double cX1 = ai.getTailPortInst().getNodeInst().getAnchorCenterX();
                    double cY1 = ai.getTailPortInst().getNodeInst().getAnchorCenterY();
                    double xOff1 = ai.getTailLocation().getX() - cX1;
                    double yOff1 = ai.getTailLocation().getY() - cY1;
                    if ((xIndex & 1) != 0 && lastXFlip) {
                        xOff0 = -xOff0;
                        xOff1 = -xOff1;
                    }
                    if ((yIndex & 1) != 0 && lastYFlip) {
                        yOff0 = -yOff0;
                        yOff1 = -yOff1;
                    }
                    if ((ni0 = (NodeInst)nodeMap.get(ai.getHeadPortInst().getNodeInst())) == null || (ni1 = (NodeInst)nodeMap.get(ai.getTailPortInst().getNodeInst())) == null) continue;
                    cX0 = ni0.getAnchorCenterX();
                    cY0 = ni0.getAnchorCenterY();
                    cX1 = ni1.getAnchorCenterX();
                    cY1 = ni1.getAnchorCenterY();
                    PortInst pi0 = ni0.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
                    PortInst pi1 = ni1.findPortInstFromProto(ai.getTailPortInst().getPortProto());
                    ArcInst newAi = ArcInst.makeInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), pi0, pi1, new Point2D.Double(cX0 + xOff0, cY0 + yOff0), new Point2D.Double(cX1 + xOff1, cY1 + yOff1), null);
                    if (newAi == null) continue;
                    newAi.copyPropertiesFrom(ai);
                    if (lastAddNames) {
                        this.setNewName(newAi, x, y);
                        continue;
                    }
                    Name arcNameKey = ai.getNameKey();
                    if (arcNameKey.isTempname()) continue;
                    String newName = ai.getName();
                    if (this.arcsAutoIncrement) {
                        newName = ElectricObject.uniqueObjectName(newName, cell, ArcInst.class, false);
                    }
                    newAi.setName(newName);
                    newAi.copyTextDescriptorFrom(ai, ArcInst.ARC_NAME);
                }
                ArrayList<PortInst> portInstsToExport = new ArrayList<PortInst>();
                HashMap<PortInst, Export> originalExports = new HashMap<PortInst, Export>();
                for (Export pp : this.exportList) {
                    PortInst oldPI = pp.getOriginalPort();
                    NodeInst newNI = (NodeInst)nodeMap.get(oldPI.getNodeInst());
                    if (newNI == null) continue;
                    PortInst pi = newNI.findPortInstFromProto(oldPI.getPortProto());
                    portInstsToExport.add(pi);
                    originalExports.put(pi, pp);
                }
                ExportChanges.reExportPorts(cell, portInstsToExport, false, true, false, originalExports);
            }
            if (lastAddNames) {
                for (NodeInst ni : this.nodeList) {
                    this.setNewName(ni, originalX, originalY);
                }
                for (ArcInst ai : this.arcList) {
                    this.setNewName(ai, originalX, originalY);
                }
            }
            if (lastDRCGood) {
                Quick.checkDesignRules(null, cell, geomsToCheck, validity, null);
                for (int i = 1; i < checkNodeCount; ++i) {
                    if (validity[i]) continue;
                    ((NodeInst)geomsToCheck[i]).kill();
                }
            }
            return true;
        }

        private void setNewName(Geometric geom, int x, int y) {
            String objName = "";
            Name geomNameKey = geom instanceof NodeInst ? ((NodeInst)geom).getNameKey() : ((ArcInst)geom).getNameKey();
            String geomName = geomNameKey.toString();
            if (geomNameKey.isTempname()) {
                geomName = null;
            }
            if (geomName != null && !geomName.equals("0") && !geomName.equals("0-0")) {
                objName = geomName.toString();
            }
            String totalName = objName + x + "-" + y;
            if (Math.abs(lastXRepeat) <= 1 || Math.abs(lastYRepeat) <= 1) {
                totalName = objName + (x + y);
            }
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                ni.setName(totalName);
                if (ni.isCellInstance()) {
                    ni.setOff(NodeInst.NODE_NAME, 0.0, ni.getYSize() / 4.0);
                }
            } else {
                ((ArcInst)geom).setName(totalName);
            }
        }
    }
}

