/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.VerticalRoute;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class InteractiveRouter
extends Router {
    private List<Highlight> startRouteHighlights = new ArrayList<Highlight>();
    private boolean started;
    private EditWindow wnd;
    private final boolean fatWires;
    private ElectricObject badStartObject;
    private ElectricObject badEndObject;

    public InteractiveRouter(boolean fatWires) {
        this.verbose = true;
        this.started = false;
        this.badEndObject = null;
        this.badStartObject = null;
        this.wnd = null;
        this.tool = Routing.getRoutingTool();
        this.fatWires = fatWires;
    }

    public String toString() {
        return "Interactive Router";
    }

    protected abstract boolean planRoute(Route var1, Cell var2, RouteElementPort var3, Point2D var4, Point2D var5, Point2D var6, PolyMerge var7, VerticalRoute var8, boolean var9, boolean var10, boolean var11, Rectangle2D var12);

    public void startInteractiveRoute(EditWindow wnd) {
        this.wnd = wnd;
        this.startRouteHighlights.clear();
        for (Highlight h : wnd.getHighlighter().getHighlights()) {
            this.startRouteHighlights.add(h);
        }
        wnd.clearHighlighting();
        this.started = true;
    }

    public void cancelInteractiveRoute() {
        Highlighter highlighter = this.wnd.getHighlighter();
        highlighter.clear();
        highlighter.setHighlightList(this.startRouteHighlights);
        highlighter.finished();
        this.wnd = null;
        this.started = false;
    }

    public void makeRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked, null, true, true, null, null);
        wnd.clearHighlighting();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        this.createRoute(route, cell);
        this.started = false;
    }

    public boolean makeVerticalRoute(EditWindow wnd, PortInst startPort, ArcProto arc) {
        if (startPort.getPortProto().connectsTo(arc)) {
            return true;
        }
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Point2D.Double startLoc = new Point2D.Double(startPort.getPoly().getCenterX(), startPort.getPoly().getCenterY());
        Poly poly = InteractiveRouter.getConnectingSite(startPort, startLoc, -1.0);
        RouteElementPort startRE = RouteElementPort.existingPortInst(startPort, poly);
        Route route = new Route();
        route.add(startRE);
        route.setStart(startRE);
        VerticalRoute vroute = VerticalRoute.newRoute(startPort.getPortProto(), arc);
        if (!vroute.isSpecificationSucceeded()) {
            this.cancelInteractiveRoute();
            return false;
        }
        ArcProto startArc = vroute.getStartArc();
        ArcProto endArc = vroute.getEndArc();
        Router.ContactSize sizer = new Router.ContactSize(startPort, null, startLoc, startLoc, startLoc, startArc, endArc, false, this.fatWires);
        Rectangle2D contactArea = sizer.getContactSize();
        Dimension2D.Double contactSize = new Dimension2D.Double(contactArea.getWidth(), contactArea.getHeight());
        int startAngle = sizer.getStartAngle();
        double startArcWidth = sizer.getStartWidth();
        Cell cell = wnd.getCell();
        Route vertRoute = vroute.buildRoute(cell, startLoc, contactSize, startAngle, null);
        for (RouteElement re : vertRoute) {
            if (!route.contains(re)) {
                route.add(re);
            }
            route.setEnd(vertRoute.getEnd());
        }
        if (route.replacePin(startRE, vertRoute.getStart(), null)) {
            route.remove(startRE);
            if (route.getStart() == startRE) {
                route.setStart(vertRoute.getStart());
            }
        } else {
            InteractiveRouter.addConnectingArc(route, cell, startRE, vertRoute.getStart(), startLoc, startLoc, startArc, startArcWidth, startAngle, true, true, null, null);
        }
        wnd.finishedHighlighting();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        new MakeVerticalRouteJob(this, route, cell, true);
        this.started = false;
        return true;
    }

    public void highlightRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked, null, true, true, null, null);
        this.highlightRoute(wnd, route, cell);
    }

    public void highlightRoute(EditWindow wnd, Route route, Cell cell) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        wnd.clearHighlighting();
        for (RouteElement e : route) {
            e.addHighlightArea(wnd.getHighlighter());
        }
        wnd.finishedHighlighting();
    }

    public Route planRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked, PolyMerge stayInside, boolean extendArcHead, boolean extendArcTail, Rectangle2D contactArea, Dimension2D alignment) {
        ArcInst ai;
        PortProto endPort;
        EditingPreferences ep = cell.getEditingPreferences();
        Route route = new Route();
        if (cell == null) {
            return route;
        }
        if (startObj == endObj) {
            return route;
        }
        RouteElementPort startRE = null;
        RouteElementPort endRE = null;
        startObj = InteractiveRouter.filterRouteObject(startObj, clicked);
        endObj = InteractiveRouter.filterRouteObject(endObj, clicked);
        PortProto startPort = InteractiveRouter.getRoutePort(startObj);
        if (startPort == null) {
            return route;
        }
        if (endObj == null) {
            ArcProto useArc = InteractiveRouter.getArcToUse(startPort, null);
            if (useArc == null) {
                return route;
            }
            PrimitiveNode pn = useArc.findOverridablePinProto(ep);
            if (pn == null) {
                System.out.println("No primitive node found for arc '" + useArc.getName() + "'");
                return route;
            }
            endPort = pn.getPort(0);
        } else {
            endPort = InteractiveRouter.getRoutePort(endObj);
        }
        VerticalRoute vroute = VerticalRoute.newRoute(startPort, endPort);
        if (!vroute.isSpecificationSucceeded()) {
            return new Route();
        }
        ArcProto startArc = vroute.getStartArc();
        ArcProto endArc = vroute.getEndArc();
        double startArcWidth = 0.0;
        double endArcWidth = 0.0;
        startArcWidth = InteractiveRouter.getArcWidthToUse(startObj, startArc, 0, true, this.fatWires);
        double d = endArcWidth = endObj == null ? startArcWidth : InteractiveRouter.getArcWidthToUse(endObj, endArc, 0, true, this.fatWires);
        if (startArc == endArc) {
            if (startArcWidth > endArcWidth) {
                endArcWidth = startArcWidth;
            }
            if (endArcWidth > startArcWidth) {
                startArcWidth = endArcWidth;
            }
        }
        if (extendArcHead) {
            boolean bl = extendArcHead = startArc.getDefaultInst(ep).isHeadExtended() || endArc.getDefaultInst(ep).isHeadExtended();
        }
        if (extendArcTail) {
            extendArcTail = startArc.getDefaultInst(ep).isTailExtended() || endArc.getDefaultInst(ep).isTailExtended();
        }
        Poly startPoly = InteractiveRouter.getConnectingSite(startObj, clicked, startArcWidth);
        Poly endPoly = InteractiveRouter.getConnectingSite(endObj, clicked, endArcWidth);
        Poly startPolyFull = InteractiveRouter.getConnectingSite(startObj, clicked, -1.0);
        Poly endPolyFull = InteractiveRouter.getConnectingSite(endObj, clicked, -1.0);
        Point2D.Double startPoint = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPoint = new Point2D.Double(0.0, 0.0);
        InteractiveRouter.getConnectingPoints(startObj, endObj, clicked, startPoint, endPoint, startPoly, endPoly, startArc, endArc, alignment, this.fatWires);
        PortInst existingStartPort = null;
        PortInst existingEndPort = null;
        boolean contactsOnEndObject = true;
        if (startObj instanceof PortInst) {
            existingStartPort = (PortInst)startObj;
            startRE = RouteElementPort.existingPortInst(existingStartPort, startPoly);
        }
        if (startObj instanceof ArcInst) {
            ai = (ArcInst)startObj;
            startRE = this.findArcConnectingPoint(route, ai, startPoint, stayInside, alignment);
            if (startRE.getPortInst() == ai.getHeadPortInst() && extendArcHead) {
                extendArcHead = ai.isHeadExtended();
            }
            if (startRE.getPortInst() == ai.getTailPortInst() && extendArcHead) {
                extendArcHead = ai.isTailExtended();
            }
            if (startRE.isBisectArcPin()) {
                contactsOnEndObject = false;
            }
        }
        if (startRE == null) {
            if (startObj != this.badStartObject) {
                System.out.println("  Can't route from " + startObj + ", no ports");
            }
            this.badStartObject = startObj;
            return route;
        }
        if (endObj != null) {
            if (endObj instanceof PortInst) {
                existingEndPort = (PortInst)endObj;
                endRE = RouteElementPort.existingPortInst(existingEndPort, endPoly);
            }
            if (endObj instanceof ArcInst) {
                ai = (ArcInst)endObj;
                endRE = this.findArcConnectingPoint(route, ai, endPoint, stayInside, alignment);
                if (endRE.getPortInst() == ai.getHeadPortInst() && extendArcTail) {
                    extendArcTail = ai.isHeadExtended();
                }
                if (endRE.getPortInst() == ai.getTailPortInst() && extendArcTail) {
                    extendArcTail = ai.isTailExtended();
                }
                if (endRE.isBisectArcPin()) {
                    contactsOnEndObject = true;
                }
            }
            if (endRE == null) {
                if (endObj != this.badEndObject) {
                    System.out.println("  Can't route to " + endObj + ", no ports");
                }
                this.badEndObject = endObj;
                endObj = null;
            }
        }
        if (endObj == null) {
            ArcProto useArc = null;
            if (startObj instanceof PortInst) {
                PortInst startPi = (PortInst)startObj;
                useArc = InteractiveRouter.getArcToUse(startPi.getPortProto(), null);
            }
            if (startObj instanceof ArcInst) {
                ArcInst startAi = (ArcInst)startObj;
                useArc = startAi.getProto();
            }
            PrimitiveNode pn = useArc.findOverridablePinProto(ep);
            SizeOffset so = pn.getProtoSizeOffset();
            endRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), endPoint, pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset(), pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset());
        }
        if (startRE.isBisectArcPin()) {
            contactsOnEndObject = false;
        }
        if (endRE != null && endRE.isBisectArcPin()) {
            contactsOnEndObject = true;
        }
        if (existingEndPort != null && existingEndPort == existingStartPort) {
            return new Route();
        }
        Point2D cornerLoc = InteractiveRouter.getCornerLocation(startPoint, endPoint, clicked, startArc, endArc, contactsOnEndObject, stayInside, contactArea, startPolyFull, endPolyFull, ep);
        int startAngle = GenMath.figureAngle(startPoint, cornerLoc);
        int endAngle = GenMath.figureAngle(endPoint, cornerLoc);
        Router.ContactSize sizer = new Router.ContactSize(startObj, endObj, startPoint, endPoint, cornerLoc, startArc, endArc, false, this.fatWires);
        contactArea = sizer.getContactSize();
        startAngle = sizer.getStartAngle();
        endAngle = sizer.getEndAngle();
        startArcWidth = sizer.getStartWidth();
        endArcWidth = sizer.getEndWidth();
        route.add(startRE);
        route.setStart(startRE);
        route.add(endRE);
        route.setEnd(endRE);
        if (startArc != endArc) {
            Dimension2D.Double contactSize = new Dimension2D.Double(contactArea.getWidth(), contactArea.getHeight());
            Route vertRoute = vroute.buildRoute(cell, cornerLoc, contactSize, startAngle, stayInside);
            for (RouteElement re : vertRoute) {
                if (route.contains(re)) continue;
                route.add(re);
            }
            if (route.replacePin(startRE, vertRoute.getStart(), stayInside)) {
                route.remove(startRE);
                if (route.getStart() == startRE) {
                    route.setStart(vertRoute.getStart());
                }
            } else {
                InteractiveRouter.addConnectingArc(route, cell, startRE, vertRoute.getStart(), startPoint, cornerLoc, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside, alignment);
            }
            if (route.replacePin(endRE, vertRoute.getEnd(), stayInside)) {
                route.remove(endRE);
                if (route.getEnd() == endRE) {
                    route.setEnd(vertRoute.getEnd());
                }
            } else {
                InteractiveRouter.addConnectingArc(route, cell, endRE, vertRoute.getEnd(), endPoint, cornerLoc, endArc, endArcWidth, endAngle, extendArcHead, extendArcTail, stayInside, alignment);
            }
        } else {
            if (route.replaceBisectPin(startRE, endRE)) {
                route.remove(startRE);
                return route;
            }
            if (route.replaceBisectPin(endRE, startRE)) {
                route.remove(endRE);
                route.setEnd(startRE);
                return route;
            }
            if (startArc.getAngleIncrement(ep) == 0 || DBMath.figureAngle(startPoint, endPoint) % (10 * startArc.getAngleIncrement(ep)) == 0) {
                InteractiveRouter.addConnectingArc(route, cell, startRE, endRE, startPoint, endPoint, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside, alignment);
            } else {
                PrimitiveNode pn = startArc.findOverridablePinProto(ep);
                SizeOffset so = pn.getProtoSizeOffset();
                double defwidth = pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset();
                double defheight = pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset();
                RouteElementPort pinRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), cornerLoc, defwidth, defheight);
                route.add(pinRE);
                InteractiveRouter.addConnectingArc(route, cell, startRE, pinRE, startPoint, cornerLoc, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside, alignment);
                InteractiveRouter.addConnectingArc(route, cell, endRE, pinRE, endPoint, cornerLoc, endArc, endArcWidth, endAngle, extendArcHead, extendArcTail, stayInside, alignment);
            }
        }
        return route;
    }

    protected static ElectricObject filterRouteObject(ElectricObject routeObj, Point2D clicked) {
        if (routeObj instanceof NodeInst) {
            return ((NodeInst)routeObj).findClosestPortInst(clicked);
        }
        if (routeObj instanceof Export) {
            Export exp = (Export)routeObj;
            return exp.getOriginalPort();
        }
        return routeObj;
    }

    protected static PortProto getRoutePort(ElectricObject routeObj) {
        assert (!(routeObj instanceof NodeInst));
        if (routeObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)routeObj;
            EditingPreferences ep = ai.getEditingPreferences();
            PrimitiveNode pn = ai.getProto().findOverridablePinProto(ep);
            return pn.getPort(0);
        }
        if (routeObj instanceof PortInst) {
            PortInst pi = (PortInst)routeObj;
            return pi.getPortProto();
        }
        return null;
    }

    protected static void getConnectingPoints(ElectricObject startObj, ElectricObject endObj, Point2D clicked, Point2D startPoint, Point2D endPoint, Poly startPoly, Poly endPoly, ArcProto startArc, ArcProto endArc, Dimension2D alignment, boolean fatWiringMode) {
        Point2D[] points2;
        Point2D[] points1;
        Point2D intersection2;
        boolean overlapY;
        double upperBoundX;
        double lowerBoundX;
        if (alignment == null) {
            alignment = new Dimension2D.Double(0.0, 0.0);
        }
        if (startPoly.getBox() == null && startPoly.getPoints().length != 2 || endPoly != null && endPoly.getBox() == null && endPoly.getPoints().length != 2) {
            startPoint.setLocation(startPoly.closestPoint(clicked));
            if (endPoly == null) {
                endPoint.setLocation(InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked));
            } else {
                endPoint.setLocation(endPoly.closestPoint(clicked));
            }
            return;
        }
        Rectangle2D.Double startBounds = new Rectangle2D.Double(startPoly.getBounds2D().getX(), startPoly.getBounds2D().getY(), startPoly.getBounds2D().getWidth(), startPoly.getBounds2D().getHeight());
        InteractiveRouter.getAlignedCenter(startBounds, alignment, startPoint);
        if (startObj instanceof ArcInst) {
            double x = InteractiveRouter.getClosestValue(startBounds.getMinX(), startBounds.getMaxX(), clicked.getX(), alignment.getWidth());
            double y = InteractiveRouter.getClosestValue(startBounds.getMinY(), startBounds.getMaxY(), clicked.getY(), alignment.getHeight());
            startPoint.setLocation(x, y);
        }
        if (endPoly == null) {
            EditingPreferences ep = startObj.getEditingPreferences();
            int angleIncrement = endArc.getAngleIncrement(ep);
            endPoint.setLocation(InteractiveRouter.getClosestAngledPoint(startPoint, clicked, angleIncrement));
            if (startArc.getTechnology() == Artwork.tech()) {
                endPoint.setLocation(clicked);
            }
            return;
        }
        Rectangle2D.Double endBounds = new Rectangle2D.Double(endPoly.getBounds2D().getX(), endPoly.getBounds2D().getY(), endPoly.getBounds2D().getWidth(), endPoly.getBounds2D().getHeight());
        InteractiveRouter.getAlignedCenter(endBounds, alignment, endPoint);
        if (endObj instanceof ArcInst) {
            double x = InteractiveRouter.getClosestValue(endBounds.getMinX(), endBounds.getMaxX(), clicked.getX(), alignment.getWidth());
            double y = InteractiveRouter.getClosestValue(endBounds.getMinY(), endBounds.getMaxY(), clicked.getY(), alignment.getHeight());
            endPoint.setLocation(x, y);
        }
        boolean overlapX = (lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX())) <= (upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX()));
        double lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY());
        double upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY());
        boolean bl = overlapY = lowerBoundY <= upperBoundY;
        if (fatWiringMode) {
            Rectangle2D.Double startObjBounds = new Rectangle2D.Double(startPoly.getBounds2D().getX(), startPoly.getBounds2D().getY(), startPoly.getBounds2D().getWidth(), startPoly.getBounds2D().getHeight());
            Rectangle2D.Double endObjBounds = new Rectangle2D.Double(endPoly.getBounds2D().getX(), endPoly.getBounds2D().getY(), endPoly.getBounds2D().getWidth(), endPoly.getBounds2D().getHeight());
            boolean objsOverlap = false;
            if (startObjBounds != null && endObjBounds != null && startArc == endArc && startObjBounds.intersects(endObjBounds)) {
                objsOverlap = true;
            }
            Point2D.Double startCenter = new Point2D.Double(startBounds.getCenterX(), startBounds.getCenterY());
            Point2D.Double endCenter = new Point2D.Double(endBounds.getCenterX(), endBounds.getCenterY());
            InteractiveRouter.gridAlignWithinBounds(startCenter, startBounds, alignment);
            InteractiveRouter.gridAlignWithinBounds(endCenter, endBounds, alignment);
            boolean startObjInEndObjInX = false;
            boolean startObjInEndObjInY = false;
            boolean endObjInStartObjInX = false;
            boolean endObjInStartObjInY = false;
            if (startObjBounds.getMinX() >= endObjBounds.getMinX() && startObjBounds.getMaxX() <= endObjBounds.getMaxX()) {
                startObjInEndObjInX = true;
            }
            if (startObjBounds.getMinY() >= endObjBounds.getMinY() && startObjBounds.getMaxY() <= endObjBounds.getMaxY()) {
                startObjInEndObjInY = true;
            }
            if (endObjBounds.getMinX() >= startObjBounds.getMinX() && endObjBounds.getMaxX() <= startObjBounds.getMaxX()) {
                endObjInStartObjInX = true;
            }
            if (endObjBounds.getMinY() >= startObjBounds.getMinY() && endObjBounds.getMaxY() <= startObjBounds.getMaxY()) {
                endObjInStartObjInY = true;
            }
            if (!objsOverlap || !overlapX) {
                if (startObj instanceof PortInst && !endObjInStartObjInX) {
                    ((Rectangle2D)startBounds).setRect(((Point2D)startCenter).getX(), ((RectangularShape)startBounds).getY(), 0.0, ((RectangularShape)startBounds).getHeight());
                }
                if (endObj instanceof PortInst && !startObjInEndObjInX) {
                    ((Rectangle2D)endBounds).setRect(((Point2D)endCenter).getX(), ((RectangularShape)endBounds).getY(), 0.0, ((RectangularShape)endBounds).getHeight());
                }
            }
            if (!objsOverlap || !overlapY) {
                if (startObj instanceof PortInst && !endObjInStartObjInY) {
                    ((Rectangle2D)startBounds).setRect(((RectangularShape)startBounds).getX(), ((Point2D)startCenter).getY(), ((RectangularShape)startBounds).getWidth(), 0.0);
                }
                if (endObj instanceof PortInst && !startObjInEndObjInY) {
                    ((Rectangle2D)endBounds).setRect(((RectangularShape)endBounds).getX(), ((Point2D)endCenter).getY(), ((RectangularShape)endBounds).getWidth(), 0.0);
                }
            }
            overlapX = (lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX())) <= (upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX()));
            lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY());
            upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY());
            boolean bl2 = overlapY = lowerBoundY <= upperBoundY;
        }
        if (startPoly.getPoints().length == 2 && endPoly.getPoints().length == 2 && (intersection2 = InteractiveRouter.getIntersection(points1 = startPoly.getPoints(), points2 = endPoly.getPoints())) != null) {
            if (Job.getDebug()) {
                System.out.println("===========================================================");
                System.out.println("Start Poly: " + points1[0] + ", " + points1[1]);
                System.out.println("End Poly: " + points2[0] + ", " + points2[1]);
                System.out.println("Intersection Point: " + intersection2);
                System.out.println("===========================================================");
            }
            startPoint.setLocation(intersection2);
            endPoint.setLocation(intersection2);
            return;
        }
        if (lowerBoundX <= upperBoundX) {
            double x = InteractiveRouter.getClosestValue(lowerBoundX, upperBoundX, clicked.getX(), alignment.getWidth());
            startPoint.setLocation(x, startPoint.getY());
            endPoint.setLocation(x, endPoint.getY());
        } else if (startBounds.getMinX() > endBounds.getMaxX()) {
            startPoint.setLocation(startBounds.getMinX(), startPoint.getY());
            endPoint.setLocation(endBounds.getMaxX(), endPoint.getY());
        } else {
            startPoint.setLocation(startBounds.getMaxX(), startPoint.getY());
            endPoint.setLocation(endBounds.getMinX(), endPoint.getY());
        }
        if (lowerBoundY <= upperBoundY) {
            double y = InteractiveRouter.getClosestValue(lowerBoundY, upperBoundY, clicked.getY(), alignment.getHeight());
            startPoint.setLocation(startPoint.getX(), y);
            endPoint.setLocation(endPoint.getX(), y);
        } else if (startBounds.getMinY() > endBounds.getMaxY()) {
            startPoint.setLocation(startPoint.getX(), startBounds.getMinY());
            endPoint.setLocation(endPoint.getX(), endBounds.getMaxY());
        } else {
            startPoint.setLocation(startPoint.getX(), startBounds.getMaxY());
            endPoint.setLocation(endPoint.getX(), endBounds.getMinY());
        }
        if (alignment.getWidth() > 0.0 && alignment.getHeight() > 0.0) {
            long sX = (long)(startPoint.getX() / alignment.getWidth());
            long sY = (long)(startPoint.getY() / alignment.getHeight());
            long eX = (long)(endPoint.getX() / alignment.getWidth());
            long eY = (long)(endPoint.getY() / alignment.getHeight());
            if ((double)sX * alignment.getWidth() != startPoint.getX() || (double)eX * alignment.getWidth() != endPoint.getX() || (double)sY * alignment.getHeight() != startPoint.getY() || (double)eY * alignment.getHeight() != endPoint.getY()) {
                System.out.println("Start point (" + startPoint.getX() + "," + startPoint.getY() + ") and/or end point (" + endPoint.getX() + "," + endPoint.getY() + ") not aligned to alignment: (" + alignment.getWidth() + "," + alignment.getHeight() + ")");
            }
        }
    }

    private static void gridAlignWithinBounds(Point2D pt, Rectangle2D bounds, Dimension2D alignment) {
        if (alignment == null) {
            return;
        }
        double x = pt.getX();
        double y = pt.getY();
        if (alignment.getWidth() > 0.0) {
            double xfloor = Math.floor(x / alignment.getWidth()) * alignment.getWidth();
            double xceil = Math.ceil(x / alignment.getWidth()) * alignment.getWidth();
            if (xfloor >= bounds.getMinX() && xfloor <= bounds.getMaxX()) {
                x = xfloor;
            } else if (xceil >= bounds.getMinX() && xceil <= bounds.getMaxX()) {
                x = xceil;
            }
        }
        if (alignment.getHeight() > 0.0) {
            double yfloor = Math.floor(y / alignment.getHeight()) * alignment.getHeight();
            double yceil = Math.ceil(y / alignment.getHeight()) * alignment.getHeight();
            if (yfloor >= bounds.getMinY() && yfloor <= bounds.getMaxY()) {
                y = yfloor;
            } else if (yceil >= bounds.getMinY() && yceil <= bounds.getMaxY()) {
                y = yceil;
            }
        }
        pt.setLocation(x, y);
    }

    private static void getAlignedCenter(Rectangle2D bounds, Dimension2D alignment, Point2D ctr) {
        double cX = bounds.getCenterX();
        double cY = bounds.getCenterY();
        if (alignment != null) {
            if (alignment.getWidth() > 0.0) {
                double newX;
                long xxL;
                double xx = cX / alignment.getWidth();
                if (xx != (double)(xxL = Math.round(xx)) && (newX = (double)xxL * alignment.getWidth()) >= bounds.getMinX() && newX <= bounds.getMaxX()) {
                    cX = newX;
                }
                double lX = Math.ceil(bounds.getMinX() / alignment.getWidth()) * alignment.getWidth();
                double hX = Math.floor(bounds.getMaxX() / alignment.getWidth()) * alignment.getWidth();
                if (lX <= bounds.getMaxX() && hX >= bounds.getMinX()) {
                    bounds.setRect(lX, bounds.getMinY(), hX - lX, bounds.getHeight());
                }
            }
            if (alignment.getHeight() > 0.0) {
                double newY;
                long yyL;
                double yy = cY / alignment.getHeight();
                if (yy != (double)(yyL = Math.round(yy)) && (newY = (double)yyL * alignment.getHeight()) >= bounds.getMinY() && newY <= bounds.getMaxY()) {
                    cY = newY;
                }
                double lY = Math.ceil(bounds.getMinY() / alignment.getHeight()) * alignment.getHeight();
                double hY = Math.floor(bounds.getMaxY() / alignment.getHeight()) * alignment.getHeight();
                if (lY <= bounds.getMaxY() && hY >= bounds.getMinY()) {
                    bounds.setRect(bounds.getMinX(), lY, bounds.getWidth(), hY - lY);
                }
            }
        }
        ctr.setLocation(cX, cY);
    }

    public static Point2D getIntersection(Point2D[] points1, Point2D[] points2) {
        double[] co2;
        if (DBMath.areEquals(points1[0], points1[1]) || DBMath.areEquals(points2[0], points2[1])) {
            if (Job.getDebug()) {
                System.out.println("Line is a singular point in InteractiveRouter.getIntersection");
            }
            return null;
        }
        Line2D.Double line1 = new Line2D.Double(points1[0], points1[1]);
        Line2D.Double line2 = new Line2D.Double(points2[0], points2[1]);
        if (!line1.intersectsLine(line2)) {
            return null;
        }
        double[] co1 = InteractiveRouter.getLineCoeffs(line1);
        double det = co1[0] * (co2 = InteractiveRouter.getLineCoeffs(line2))[1] - co2[0] * co1[1];
        if (det == 0.0) {
            if (points1[0].getX() == points2[0].getX() && points1[0].getY() == points2[0].getY()) {
                return points1[0];
            }
            if (points1[0].getX() == points2[1].getX() && points1[0].getY() == points2[1].getY()) {
                return points1[0];
            }
            if (points1[1].getX() == points2[0].getX() && points1[1].getY() == points2[0].getY()) {
                return points1[1];
            }
            if (points1[1].getX() == points2[1].getX() && points1[1].getY() == points2[1].getY()) {
                return points1[1];
            }
            return null;
        }
        double x = (co2[1] * co1[2] - co1[1] * co2[2]) / det;
        double y = (co1[0] * co2[2] - co2[0] * co1[2]) / det;
        return new Point2D.Double(x, y);
    }

    private static double[] getLineCoeffs(Line2D line) {
        double A = line.getP2().getY() - line.getP1().getY();
        double B = line.getP1().getX() - line.getP2().getX();
        double C = A * line.getP1().getX() + B * line.getP1().getY();
        return new double[]{A, B, C};
    }

    protected static Rectangle2D getBounds(ElectricObject obj) {
        NodeInst ni;
        NodeProto np;
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            return ai.getBounds();
        }
        if (obj instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            obj = pi.getNodeInst();
        }
        if (obj instanceof NodeInst && (np = (ni = (NodeInst)obj).getProto()) instanceof PrimitiveNode) {
            return ni.getBounds();
        }
        return null;
    }

    protected static Poly getConnectingSite(ElectricObject obj, Point2D clicked, double arcWidth) {
        PortInst pi;
        assert (clicked != null);
        if (obj instanceof NodeInst) {
            pi = ((NodeInst)obj).findClosestPortInst(clicked);
            if (pi == null) {
                return null;
            }
            obj = pi;
        }
        if (obj instanceof PortInst) {
            pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            PortProto pp = pi.getPortProto();
            boolean compressPort = false;
            if (!ni.isCellInstance()) {
                compressPort = true;
            }
            Poly poly = ni.getShapeOfPort(pp, clicked, compressPort, arcWidth);
            return poly;
        }
        if (obj instanceof ArcInst) {
            ArcInst arc = (ArcInst)obj;
            Point2D[] points = new Point2D[]{arc.getHeadLocation(), arc.getTailLocation()};
            Poly poly = new Poly(points);
            return poly;
        }
        return null;
    }

    protected static Rectangle2D getLayerArea(ElectricObject obj, Layer layer) {
        if (obj instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            NodeProto np = ni.getProto();
            if (np instanceof Cell) {
                return null;
            }
            if (np instanceof PrimitiveNode) {
                PrimitiveNode pn = (PrimitiveNode)np;
                if (pn.getFunction().isPin()) {
                    Rectangle2D horiz = null;
                    Rectangle2D vert = null;
                    Iterator<Connection> it = pi.getConnections();
                    while (it.hasNext()) {
                        Connection conn = it.next();
                        ArcInst ai = conn.getArc();
                        if (ai.getProto().getLayerIterator().next() != layer) continue;
                        int angle = ai.getDefinedAngle();
                        if (angle % 1800 == 0) {
                            horiz = horiz == null ? ai.getBounds() : horiz.createUnion(ai.getBounds());
                        }
                        if ((angle + 900) % 1800 != 0) continue;
                        if (vert == null) {
                            vert = ai.getBounds();
                            continue;
                        }
                        vert = vert.createUnion(ai.getBounds());
                    }
                    return horiz.createIntersection(vert);
                }
                if (pn.getFunction().isContact()) {
                    Poly p = ni.getBaseShape();
                    return p.getBounds2D();
                }
            }
        }
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            return ai.getBounds();
        }
        return null;
    }

    protected RouteElementPort findArcConnectingPoint(Route route, ArcInst arc, Point2D connectingPoint, PolyMerge stayInside, Dimension2D alignment) {
        EPoint head2 = arc.getHeadLocation();
        EPoint tail2 = arc.getTailLocation();
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHeadPortInst(), head2);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTailPortInst(), tail2);
        if (head2.equals(connectingPoint)) {
            return headRE;
        }
        if (tail2.equals(connectingPoint)) {
            return tailRE;
        }
        return this.bisectArc(route, arc, connectingPoint, stayInside, alignment);
    }

    protected RouteElementPort bisectArc(Route route, ArcInst arc, Point2D bisectPoint, PolyMerge stayInside, Dimension2D alignment) {
        Cell cell = arc.getParent();
        EPoint head2 = arc.getHeadLocation();
        EPoint tail2 = arc.getTailLocation();
        EditingPreferences ep = cell.getEditingPreferences();
        PrimitiveNode pn = arc.getProto().findOverridablePinProto(ep);
        SizeOffset so = pn.getProtoSizeOffset();
        double width = pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset();
        double height = pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset();
        RouteElementPort newPinRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), bisectPoint, width, height);
        newPinRE.setBisectArcPin(true);
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHeadPortInst(), head2);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTailPortInst(), tail2);
        headRE.setShowHighlight(false);
        tailRE.setShowHighlight(false);
        String name1 = null;
        String name2 = null;
        String nameToUse = arc.getName();
        if (arc.getNameKey().isTempname()) {
            nameToUse = null;
        }
        if (head2.distance(bisectPoint) > tail2.distance(bisectPoint)) {
            name1 = nameToUse;
        } else {
            name2 = nameToUse;
        }
        boolean extendArcFromHeadSide = InteractiveRouter.getExtendArcEnd(newPinRE, bisectPoint, arc.getLambdaBaseWidth(), arc.getProto(), arc.getAngle(), arc.isTailExtended(), alignment);
        boolean extendArcFromTailSide = InteractiveRouter.getExtendArcEnd(newPinRE, bisectPoint, arc.getLambdaBaseWidth(), arc.getProto(), arc.getAngle(), arc.isHeadExtended(), alignment);
        RouteElementArc newHeadArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getLambdaBaseWidth(), headRE, newPinRE, head2, bisectPoint, name1, arc.getTextDescriptor(ArcInst.ARC_NAME), arc, arc.isHeadExtended(), extendArcFromHeadSide, stayInside);
        RouteElementArc newTailArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getLambdaBaseWidth(), newPinRE, tailRE, bisectPoint, tail2, name2, arc.getTextDescriptor(ArcInst.ARC_NAME), arc, extendArcFromTailSide, arc.isTailExtended(), stayInside);
        newHeadArcRE.setShowHighlight(false);
        newTailArcRE.setShowHighlight(false);
        RouteElementArc deleteArcRE = RouteElementArc.deleteArc(arc);
        route.add(deleteArcRE);
        route.add(headRE);
        route.add(tailRE);
        route.add(newHeadArcRE);
        route.add(newTailArcRE);
        return newPinRE;
    }

    protected static Point2D getCornerLocation(Point2D startLoc, Point2D endLoc, Point2D clicked, ArcProto startArc, ArcProto endArc, boolean contactsOnEndObj, PolyMerge stayInside, Rectangle2D contactArea, Poly startPolyFull, Poly endPolyFull, EditingPreferences ep) {
        if (contactArea != null) {
            return new Point2D.Double(contactArea.getCenterX(), contactArea.getCenterY());
        }
        boolean singleArc = false;
        if (startArc == endArc) {
            int inc = 10 * startArc.getAngleIncrement(ep);
            if (inc == 0) {
                singleArc = true;
            } else {
                int ang = GenMath.figureAngle(startLoc, endLoc);
                if (ang % inc == 0) {
                    singleArc = true;
                }
            }
        } else if (DBMath.areEquals(startLoc.getX(), endLoc.getX()) || DBMath.areEquals(startLoc.getY(), endLoc.getY())) {
            singleArc = true;
        }
        if (singleArc) {
            if (contactsOnEndObj) {
                return new Point2D.Double(endLoc.getX(), endLoc.getY());
            }
            return new Point2D.Double(startLoc.getX(), startLoc.getY());
        }
        Point2D.Double cornerLoc = null;
        Point2D.Double pin1 = new Point2D.Double(startLoc.getX(), endLoc.getY());
        Point2D.Double pin2 = new Point2D.Double(endLoc.getX(), startLoc.getY());
        int clickedQuad = InteractiveRouter.findQuadrant(endLoc, clicked);
        int pin1Quad = InteractiveRouter.findQuadrant(endLoc, pin1);
        int pin2Quad = InteractiveRouter.findQuadrant(endLoc, pin2);
        int oppositeQuad = (clickedQuad + 2) % 4;
        cornerLoc = pin1;
        if (pin2Quad == clickedQuad) {
            cornerLoc = pin2;
        } else if (pin1Quad == clickedQuad) {
            cornerLoc = pin1;
        } else if (pin1Quad == oppositeQuad) {
            cornerLoc = pin2;
        }
        if (startPolyFull.intersects(endPolyFull)) {
            boolean usepin1 = false;
            boolean usepin2 = false;
            if (startPolyFull.contains(pin1) && endPolyFull.contains(pin1)) {
                usepin1 = true;
            }
            if (startPolyFull.contains(pin2) && endPolyFull.contains(pin2)) {
                usepin2 = true;
            }
            if (usepin1 && !usepin2) {
                cornerLoc = pin1;
            }
            if (usepin2 && !usepin1) {
                cornerLoc = pin2;
            }
        }
        ArcProto useArc = startArc;
        if (!contactsOnEndObj) {
            useArc = endArc;
        }
        if (stayInside != null && useArc != null) {
            double pinSize = useArc.getDefaultLambdaBaseWidth();
            Layer pinLayer = useArc.getLayerIterator().next();
            Rectangle2D.Double pin1Rect = new Rectangle2D.Double(((Point2D)pin1).getX() - pinSize / 2.0, ((Point2D)pin1).getY() - pinSize / 2.0, pinSize, pinSize);
            Rectangle2D.Double pin2Rect = new Rectangle2D.Double(((Point2D)pin2).getX() - pinSize / 2.0, ((Point2D)pin2).getY() - pinSize / 2.0, pinSize, pinSize);
            if (stayInside.contains(pinLayer, pin1Rect)) {
                cornerLoc = pin1;
            } else if (stayInside.contains(pinLayer, pin2Rect)) {
                cornerLoc = pin2;
            }
        }
        return cornerLoc;
    }

    protected static void updateContactArea(Rectangle2D contactArea, RouteElementPort re, Point2D cornerLoc, double arcWidth, int arcAngle) {
        if (arcAngle % 1800 == 0 && contactArea.getHeight() < arcWidth) {
            contactArea.setRect(contactArea.getX(), contactArea.getCenterY() - arcWidth / 2.0, contactArea.getWidth(), arcWidth);
        }
        if ((arcAngle + 900) % 1800 == 0 && contactArea.getWidth() < arcWidth) {
            contactArea.setRect(contactArea.getCenterX() - arcWidth / 2.0, contactArea.getY(), arcWidth, contactArea.getHeight());
        }
    }

    protected static void addConnectingArc(Route route, Cell cell, RouteElementPort startRE, RouteElementPort endRE, Point2D startPoint, Point2D endPoint, ArcProto arc, double width, int arcAngle, boolean extendArcHead, boolean extendArcTail, PolyMerge stayInside, Dimension2D alignment) {
        if (extendArcHead) {
            extendArcHead = InteractiveRouter.getExtendArcEnd(startRE, startPoint, width, arc, arcAngle, extendArcHead, alignment);
        }
        if (extendArcTail) {
            extendArcTail = InteractiveRouter.getExtendArcEnd(endRE, endPoint, width, arc, arcAngle, extendArcTail, alignment);
        }
        RouteElementArc reArc = RouteElementArc.newArc(cell, arc, width, startRE, endRE, startPoint, endPoint, null, null, null, extendArcHead, extendArcTail, stayInside);
        reArc.setArcAngle(arcAngle);
        route.add(reArc);
    }

    protected static boolean getExtendArcEnd(RouteElementPort re, Point2D point, double arcWidth, ArcProto arc, int arcAngle, boolean defExtends, Dimension2D alignment) {
        PrimitiveNode pn;
        NodeProto np = re.getNodeProto();
        if (np == null) {
            return defExtends;
        }
        if (np instanceof PrimitiveNode && (pn = (PrimitiveNode)np).getFunction().isContact()) {
            Dimension2D.Double size2 = re.getNodeSize();
            if (arcAngle % 1800 == 0 && arcWidth > ((Dimension2D)size2).getWidth()) {
                return false;
            }
            if ((arcAngle + 900) % 1800 == 0 && arcWidth > ((Dimension2D)size2).getHeight()) {
                return false;
            }
        }
        if (alignment != null) {
            if (arcAngle == -1) {
                arcAngle = 0;
            }
            if (arcAngle % 1800 == 0) {
                if (InteractiveRouter.isNumberAligned(point.getX(), alignment.getWidth()) && !InteractiveRouter.isNumberAligned(point.getX() + arcWidth / 2.0, alignment.getWidth())) {
                    return false;
                }
                if (!InteractiveRouter.isNumberAligned(point.getX(), alignment.getWidth()) && InteractiveRouter.isNumberAligned(point.getX() + arcWidth / 2.0, alignment.getWidth())) {
                    return true;
                }
            }
            if ((arcAngle + 900) % 1800 == 0) {
                if (InteractiveRouter.isNumberAligned(point.getY(), alignment.getHeight()) && !InteractiveRouter.isNumberAligned(point.getY() + arcWidth / 2.0, alignment.getHeight())) {
                    return false;
                }
                if (!InteractiveRouter.isNumberAligned(point.getY(), alignment.getHeight()) && InteractiveRouter.isNumberAligned(point.getY() + arcWidth / 2.0, alignment.getHeight())) {
                    return true;
                }
            }
        }
        return defExtends;
    }

    private static boolean isNumberAligned(double number2, double alignment) {
        return number2 % alignment == 0.0;
    }

    protected static double getClosestValue(double min2, double max2, double clicked, double alignment) {
        if (alignment > 0.0) {
            max2 = Math.floor(max2 / alignment) * alignment;
            min2 = Math.ceil(min2 / alignment) * alignment;
            clicked = (double)Math.round(clicked / alignment) * alignment;
        }
        if (clicked >= max2) {
            return max2;
        }
        if (clicked <= min2) {
            return min2;
        }
        return clicked;
    }

    protected static Point2D getClosestOrthogonalPoint(Point2D startPoint, Point2D clicked) {
        Point2D.Double newPoint = Math.abs(startPoint.getX() - clicked.getX()) < Math.abs(startPoint.getY() - clicked.getY()) ? new Point2D.Double(startPoint.getX(), clicked.getY()) : new Point2D.Double(clicked.getX(), startPoint.getY());
        return newPoint;
    }

    public static Point2D getClosestAngledPoint(Point2D startPoint, Point2D clicked, int angleIncrement) {
        double yfinal;
        double xfinal;
        if ((angleIncrement = Math.abs(angleIncrement)) == 0) {
            return clicked;
        }
        if (angleIncrement == 90) {
            return InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked);
        }
        double angleInc = (double)angleIncrement * Math.PI / 180.0;
        double x = clicked.getX() - startPoint.getX();
        double y = clicked.getY() - startPoint.getY();
        double angle = Math.atan2(y, x);
        double nearest1 = (double)((int)(angle / angleInc)) * angleInc;
        double nearest2 = angle < 0.0 ? nearest1 - angleInc : nearest1 + angleInc;
        double tan1 = Math.tan(nearest1);
        if (tan1 == 0.0) {
            tan1 = 1.0E-6;
        }
        Point2D.Double n1_1 = new Point2D.Double(x, x * tan1);
        Point2D.Double n1_2 = new Point2D.Double(y / tan1, y);
        Point2D.Double n1 = n1_1.distance(x, y) < n1_2.distance(x, y) ? n1_1 : n1_2;
        double tan2 = Math.tan(nearest2);
        if (tan2 == 0.0) {
            tan2 = 1.0E-6;
        }
        Point2D.Double n2_1 = new Point2D.Double(x, x * tan2);
        Point2D.Double n2_2 = new Point2D.Double(y / tan2, y);
        Point2D.Double n2 = n2_1.distance(x, y) < n2_2.distance(x, y) ? n2_1 : n2_2;
        if (n2.distance(x, y) < n1.distance(x, y)) {
            xfinal = DBMath.round(((Point2D)n2).getX() + startPoint.getX());
            yfinal = DBMath.round(((Point2D)n2).getY() + startPoint.getY());
        } else {
            xfinal = DBMath.round(((Point2D)n1).getX() + startPoint.getX());
            yfinal = DBMath.round(((Point2D)n1).getY() + startPoint.getY());
        }
        return new Point2D.Double(xfinal, yfinal);
    }

    protected boolean withinBounds(double point, double bound1, double bound2) {
        double max2;
        double min2;
        if (bound1 < bound2) {
            min2 = bound1;
            max2 = bound2;
        } else {
            min2 = bound2;
            max2 = bound1;
        }
        return point >= min2 && point <= max2;
    }

    protected boolean onSegment(Point2D point, Line2D line) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Point2D head2 = line.getP1();
        Point2D tail2 = line.getP2();
        if (head2.getX() < tail2.getX()) {
            minX = head2.getX();
            maxX = tail2.getX();
        } else {
            minX = tail2.getX();
            maxX = head2.getX();
        }
        if (head2.getY() < tail2.getY()) {
            minY = head2.getY();
            maxY = tail2.getY();
        } else {
            minY = tail2.getY();
            maxY = head2.getY();
        }
        return point.getX() >= minX && point.getX() <= maxX && point.getY() >= minY && point.getY() <= maxY;
    }

    protected static int findQuadrant(Point2D refPoint, Point2D pt) {
        double angle = Math.atan((pt.getY() - refPoint.getY()) / (pt.getX() - refPoint.getX()));
        if (pt.getX() < refPoint.getX()) {
            angle += Math.PI;
        }
        if (angle > -0.7853981633974483 && angle <= 0.7853981633974483) {
            return 0;
        }
        if (angle > 0.7853981633974483 && angle <= 2.356194490192345) {
            return 1;
        }
        if (angle > 2.356194490192345 && angle <= 3.9269908169872414) {
            return 2;
        }
        return 3;
    }

    private static class MakeVerticalRouteJob
    extends Router.CreateRouteJob {
        protected MakeVerticalRouteJob(Router router, Route route, Cell cell, boolean verbose) {
            super(router.toString(), route, cell, verbose, Routing.getRoutingTool());
        }

        public boolean doIt() throws JobException {
            PortInst pi;
            NodeInst ni;
            if (!super.doIt()) {
                return false;
            }
            RouteElementPort startRE = this.route.getStart();
            if (startRE.getAction() == RouteElement.RouteElementAction.existingPortInst && (ni = (pi = startRE.getPortInst()).getNodeInst()).getProto().getFunction().isPin()) {
                CircuitChangeJobs.Reconnect re = CircuitChangeJobs.Reconnect.erasePassThru(ni, false, true);
                if (re != null) {
                    re.reconnectArcs();
                }
                if (!ni.hasExports()) {
                    ni.kill();
                }
            }
            return true;
        }
    }
}

