/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class AttributesTable
extends JTable
implements DatabaseChangeListener {
    private static JComboBox codeComboBox = null;
    private static JComboBox dispComboBox = null;
    private static JComboBox unitComboBox = null;
    private static final String displaynone = "None";
    private JPopupMenu popup;
    private Point popupLocation;
    private ElectricObject owner;

    public AttributesTable(ElectricObject owner, boolean showCode, boolean showDispPos, boolean showUnits) {
        TableColumn codeColumn;
        this.setElectricObject(owner);
        this.setGridColor(this.getBackground());
        this.setSelectionMode(0);
        VariableTableModel model = new VariableTableModel(showCode, showDispPos, showUnits);
        this.setModel(model);
        this.initComboBoxes();
        if (showCode && (codeColumn = this.getColumnModel().getColumn(model.getCodeColumn())) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(codeComboBox));
        }
        if (showDispPos && (codeColumn = this.getColumnModel().getColumn(model.getDispColumn())) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(dispComboBox));
        }
        if (showUnits && (codeColumn = this.getColumnModel().getColumn(model.getUnitsColumn())) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(unitComboBox));
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isShiftDown() || e.isControlDown() || e.isAltDown()) {
                    return;
                }
                if (e.isMetaDown()) {
                    AttributesTable.this.initPopupMenu();
                    AttributesTable.this.popupLocation = new Point(e.getX(), e.getY());
                    AttributesTable.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(mouseListener);
        UserInterfaceMain.addDatabaseChangeListener(this);
    }

    private void initComboBoxes() {
        Iterator<Object> it;
        if (codeComboBox == null) {
            codeComboBox = new JComboBox();
            it = CodeExpression.Code.getCodes();
            while (it.hasNext()) {
                codeComboBox.addItem(it.next());
            }
            codeComboBox.setFont(new Font("Dialog", 0, 11));
        }
        if (dispComboBox == null) {
            dispComboBox = new JComboBox();
            dispComboBox.addItem(displaynone);
            it = AbstractTextDescriptor.DispPos.getShowStyles();
            while (it.hasNext()) {
                dispComboBox.addItem(it.next());
            }
            dispComboBox.setFont(new Font("Dialog", 0, 11));
        }
        if (unitComboBox == null) {
            unitComboBox = new JComboBox();
            it = AbstractTextDescriptor.Unit.getUnits();
            while (it.hasNext()) {
                unitComboBox.addItem(it.next());
            }
            unitComboBox.setFont(new Font("Dialog", 0, 11));
        }
    }

    private void initPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem m = new JMenuItem("New Attr");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.newVar();
            }
        });
        this.popup.add(m);
        m = new JMenuItem("Duplicate Attr");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.duplicateVar(AttributesTable.this.popupLocation);
            }
        });
        this.popup.add(m);
        m = new JMenuItem("Delete Attr");
        m.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.deleteVar(AttributesTable.this.popupLocation);
            }
        });
        this.popup.add(m);
        JMenu showMenu = new JMenu("Show...");
        VariableTableModel model = (VariableTableModel)this.getModel();
        JCheckBoxMenuItem cb = new JCheckBoxMenuItem("Code", model.showCode);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.toggleShowCode();
            }
        });
        showMenu.add(cb);
        cb = new JCheckBoxMenuItem("Display", model.showDispPos);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.toggleShowDisp();
            }
        });
        showMenu.add(cb);
        cb = new JCheckBoxMenuItem("Units", model.showUnits);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributesTable.this.toggleShowUnits();
            }
        });
        showMenu.add(cb);
        this.popup.add(showMenu);
    }

    private void newVar() {
        VariableTableModel model = (VariableTableModel)this.getModel();
        model.newVar(this.owner);
    }

    private void duplicateVar(Point location) {
        int row = this.rowAtPoint(location);
        VariableTableModel model = (VariableTableModel)this.getModel();
        model.duplicateVar(row);
    }

    private void deleteVar(Point location) {
        int row = this.rowAtPoint(location);
        VariableTableModel model = (VariableTableModel)this.getModel();
        model.deleteVar(row);
    }

    public void applyChanges() {
        VariableTableModel model = (VariableTableModel)this.getModel();
        if (this.isEditing()) {
            int row = this.getEditingRow();
            int col = this.getEditingColumn();
            TableCellEditor editor = this.getCellEditor(row, col);
            editor.stopCellEditing();
        }
        model.applyChanges();
    }

    public void cancelChanges() {
        if (this.isEditing()) {
            int row = this.getEditingRow();
            int col = this.getEditingColumn();
            TableCellEditor editor = this.getCellEditor(row, col);
            editor.cancelCellEditing();
        }
        this.setElectricObject(this.owner);
    }

    private void toggleShowCode() {
        VariableTableModel model;
        model.setShowCode(!(model = (VariableTableModel)this.getModel()).showCode);
        this.updateEditors();
    }

    private void toggleShowDisp() {
        VariableTableModel model;
        model.setShowDisp(!(model = (VariableTableModel)this.getModel()).showDispPos);
        this.updateEditors();
    }

    private void toggleShowUnits() {
        VariableTableModel model;
        model.setShowUnits(!(model = (VariableTableModel)this.getModel()).showUnits);
        this.updateEditors();
    }

    private void updateEditors() {
        TableColumn codeColumn;
        int unitsCol;
        TableColumn codeColumn2;
        int dispCol;
        TableColumn codeColumn3;
        VariableTableModel model = (VariableTableModel)this.getModel();
        int codeCol = model.getCodeColumn();
        if (codeCol != -1 && (codeColumn3 = this.getColumnModel().getColumn(codeCol)) != null) {
            codeColumn3.setCellEditor(new DefaultCellEditor(codeComboBox));
        }
        if ((dispCol = model.getDispColumn()) != -1 && (codeColumn2 = this.getColumnModel().getColumn(dispCol)) != null) {
            codeColumn2.setCellEditor(new DefaultCellEditor(dispComboBox));
        }
        if ((unitsCol = model.getUnitsColumn()) != -1 && (codeColumn = this.getColumnModel().getColumn(unitsCol)) != null) {
            codeColumn.setCellEditor(new DefaultCellEditor(unitComboBox));
        }
    }

    public void setElectricObject(ElectricObject eobj) {
        if (this.owner == eobj) {
            return;
        }
        this.clearVariables();
        if (eobj != null) {
            ArrayList<Variable> vars = new ArrayList<Variable>();
            if (eobj instanceof NodeInst) {
                Iterator<Variable> it = ((NodeInst)eobj).getParameters();
                while (it.hasNext()) {
                    Variable param2 = it.next();
                    vars.add(param2);
                }
                it = eobj.getVariables();
                while (it.hasNext()) {
                    Variable var = it.next();
                    if (!var.isAttribute() || eobj.isParam(var.getKey())) continue;
                    vars.add(var);
                }
            } else {
                Iterator<Variable> it = eobj.getVariables();
                while (it.hasNext()) {
                    Variable var = it.next();
                    if (!var.isAttribute()) continue;
                    vars.add(var);
                }
            }
            ((VariableTableModel)this.getModel()).setVars(eobj, vars);
        }
        this.owner = eobj;
    }

    private void clearVariables() {
        ((VariableTableModel)this.getModel()).clearVariables();
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        ElectricObject eobj = this.owner;
        this.setElectricObject(null);
        this.setElectricObject(eobj);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VariableTableModel
    extends AbstractTableModel {
        private List<VarEntry> vars = new ArrayList<VarEntry>();
        private static final String[] columnNames = new String[]{"Name", "Value", "Code", "Display", "Units"};
        private boolean showCode = true;
        private boolean showDispPos = false;
        private boolean showUnits = false;
        private List<VarEntry> varsToDelete = new ArrayList<VarEntry>();

        private VariableTableModel(boolean showCode, boolean showDispPos, boolean showUnits) {
            this.showCode = showCode;
            this.showDispPos = showDispPos;
            this.showUnits = showUnits;
        }

        @Override
        public int getColumnCount() {
            int c = 2;
            if (this.showCode) {
                ++c;
            }
            if (this.showDispPos) {
                ++c;
            }
            if (this.showUnits) {
                ++c;
            }
            return c;
        }

        @Override
        public int getRowCount() {
            return this.vars.size();
        }

        private int getCodeColumn() {
            if (!this.showCode) {
                return -1;
            }
            return 2;
        }

        private int getDispColumn() {
            if (!this.showDispPos) {
                return -1;
            }
            int c = 2;
            if (this.showCode) {
                ++c;
            }
            return c;
        }

        private int getUnitsColumn() {
            if (!this.showUnits) {
                return -1;
            }
            int c = 2;
            if (this.showCode) {
                ++c;
            }
            if (this.showDispPos) {
                ++c;
            }
            return c;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VarEntry ve = this.vars.get(rowIndex);
            if (ve == null) {
                return null;
            }
            if (columnIndex == 0) {
                return ve.getName();
            }
            if (columnIndex == 1) {
                return ve.getObject().toString();
            }
            if (columnIndex == this.getCodeColumn()) {
                return ve.getCode();
            }
            if (columnIndex == this.getDispColumn()) {
                if (!ve.isDisplay()) {
                    return AttributesTable.displaynone;
                }
                return ve.getDispPos();
            }
            if (columnIndex == this.getUnitsColumn()) {
                return ve.getUnits();
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            if (col < 2) {
                return columnNames[col];
            }
            if (col == this.getCodeColumn()) {
                return columnNames[2];
            }
            if (col == this.getDispColumn()) {
                return columnNames[3];
            }
            if (col == this.getUnitsColumn()) {
                return columnNames[4];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            VarEntry ve = this.vars.get(row);
            ElectricObject owner = ve.getOwner();
            if (ve == null) {
                return;
            }
            if (owner == null) {
                return;
            }
            if (col == 0) {
                return;
            }
            if (col == 1) {
                if (!aValue.toString().equals(ve.getObject().toString())) {
                    ve.value = aValue;
                    this.fireTableCellUpdated(row, col);
                }
                return;
            }
            if (col == this.getCodeColumn()) {
                CodeExpression.Code newCode = (CodeExpression.Code)((Object)aValue);
                if (newCode != ve.getCode()) {
                    ve.code = newCode;
                    this.fireTableCellUpdated(row, col);
                }
                return;
            }
            if (col == this.getDispColumn()) {
                if (aValue == AttributesTable.displaynone) {
                    if (ve.isDisplay()) {
                        ve.display = false;
                        this.fireTableCellUpdated(row, col);
                    }
                } else {
                    AbstractTextDescriptor.DispPos newDispPos = (AbstractTextDescriptor.DispPos)aValue;
                    if (newDispPos != ve.getDispPos() || !ve.isDisplay()) {
                        ve.dispPos = newDispPos;
                        ve.display = true;
                        this.fireTableCellUpdated(row, col);
                    }
                }
                return;
            }
            if (col == this.getUnitsColumn()) {
                AbstractTextDescriptor.Unit newUnit = (AbstractTextDescriptor.Unit)aValue;
                if (newUnit != ve.getUnits()) {
                    ve.units = newUnit;
                    this.fireTableCellUpdated(row, col);
                }
                return;
            }
        }

        private void setVars(ElectricObject owner, List<Variable> variables) {
            this.vars.clear();
            this.varsToDelete.clear();
            for (Variable var : variables) {
                this.vars.add(new VarEntry(owner, var));
            }
            Collections.sort(this.vars, new VarEntrySort());
            this.fireTableDataChanged();
        }

        private void clearVariables() {
            this.vars.clear();
            this.varsToDelete.clear();
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == this.getCodeColumn()) {
                return CodeExpression.Code.class;
            }
            if (col == this.getDispColumn()) {
                return Object.class;
            }
            if (col == this.getUnitsColumn()) {
                return AbstractTextDescriptor.Unit.class;
            }
            return String.class;
        }

        public void setShowCode(boolean showCode) {
            if (this.showCode == showCode) {
                return;
            }
            this.showCode = showCode;
            this.fireTableStructureChanged();
        }

        public void setShowDisp(boolean showDisp) {
            if (this.showDispPos == showDisp) {
                return;
            }
            this.showDispPos = showDisp;
            this.fireTableStructureChanged();
        }

        public void setShowUnits(boolean showUnits) {
            if (this.showUnits == showUnits) {
                return;
            }
            this.showUnits = showUnits;
            this.fireTableStructureChanged();
        }

        public void newVar(ElectricObject owner) {
            VarEntry ve = new VarEntry(owner, null);
            ve.var = null;
            ve.varKey = null;
            ve.varTrueName = this.getUniqueName("newVar");
            ve.value = "?";
            ve.code = CodeExpression.Code.NONE;
            ve.dispPos = AbstractTextDescriptor.DispPos.NAMEVALUE;
            ve.units = AbstractTextDescriptor.Unit.NONE;
            ve.display = true;
            this.vars.add(ve);
            Collections.sort(this.vars, new VarEntrySort());
            this.fireTableDataChanged();
        }

        public void duplicateVar(int row) {
            if (row >= this.vars.size()) {
                JOptionPane.showMessageDialog(null, "Please select an attribute to duplicate", "Invalid Action", 2);
                return;
            }
            VarEntry srcVe = this.vars.get(row);
            VarEntry ve = new VarEntry(srcVe.getOwner(), null);
            ve.var = null;
            ve.varKey = null;
            ve.varTrueName = this.getUniqueName(srcVe.getName());
            ve.value = srcVe.getObject();
            ve.code = srcVe.getCode();
            ve.dispPos = srcVe.getDispPos();
            ve.units = srcVe.getUnits();
            ve.display = srcVe.isDisplay();
            this.vars.add(ve);
            Collections.sort(this.vars, new VarEntrySort());
            this.fireTableDataChanged();
        }

        public void deleteVar(int row) {
            if (row >= this.vars.size()) {
                JOptionPane.showMessageDialog(null, "Please select an attribute to delete", "Invalid Action", 2);
                return;
            }
            VarEntry ve = this.vars.remove(row);
            this.varsToDelete.add(ve);
            this.fireTableDataChanged();
        }

        public void applyChanges() {
            ArrayList<Variable.Key> deleteTheseVars = new ArrayList<Variable.Key>();
            ElectricObject owner = null;
            for (VarEntry ve : this.varsToDelete) {
                Variable var = ve.var;
                if (var == null) continue;
                owner = ve.getOwner();
                deleteTheseVars.add(var.getKey());
            }
            ArrayList<Variable.Key> createKey = new ArrayList<Variable.Key>();
            ArrayList<Object> createValue = new ArrayList<Object>();
            ArrayList<Boolean> createNew = new ArrayList<Boolean>();
            ArrayList<Boolean> createDisplay = new ArrayList<Boolean>();
            ArrayList<CodeExpression.Code> createCode = new ArrayList<CodeExpression.Code>();
            ArrayList<Integer> createDispPos = new ArrayList<Integer>();
            ArrayList<Integer> createUnits = new ArrayList<Integer>();
            for (VarEntry ve : this.vars) {
                Variable var = ve.var;
                owner = ve.getOwner();
                Variable.Key newKey = null;
                Object newValue = ve.getObject();
                boolean newCreate = false;
                boolean newDisplay = ve.isDisplay();
                CodeExpression.Code newCode = ve.getCode();
                int newDispPos = ve.getDispPos().getIndex();
                int newUnits = ve.getUnits().getIndex();
                if (var == null) {
                    newCreate = true;
                    String name = ve.getName();
                    if (!name.startsWith("ATTR_") && !name.startsWith("ATTRP_")) {
                        name = "ATTR_" + name;
                    }
                    newKey = Variable.newKey(name);
                } else {
                    if (!ve.isChanged()) continue;
                    newKey = ve.getKey();
                }
                createKey.add(newKey);
                createValue.add(newValue);
                createNew.add(newCreate);
                createDisplay.add(newDisplay);
                createCode.add(newCode);
                createDispPos.add(new Integer(newDispPos));
                createUnits.add(new Integer(newUnits));
            }
            new ApplyChanges(owner, createKey, createValue, createNew, createDisplay, createCode, createDispPos, createUnits, deleteTheseVars);
        }

        public void cancelChanges() {
        }

        private String getUniqueName(String name) {
            boolean nameConflict = true;
            String newName = name;
            int i = 0;
            block0: while (nameConflict) {
                nameConflict = false;
                ++i;
                for (VarEntry ve : this.vars) {
                    if (!newName.equals(ve.getName())) continue;
                    nameConflict = true;
                    newName = name + "_" + i;
                    continue block0;
                }
            }
            return newName;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ApplyChanges
        extends Job {
            private ElectricObject owner;
            private List<Variable.Key> createKey;
            private List<Object> createValue;
            private List<Boolean> createNew;
            private List<Boolean> createDisplay;
            private List<CodeExpression.Code> createCode;
            private List<Integer> createDispPos;
            private List<Integer> createUnits;
            private List<Variable.Key> varsToDelete;

            private ApplyChanges(ElectricObject owner, List<Variable.Key> createKey, List<Object> createValue, List<Boolean> createNew, List<Boolean> createDisplay, List<CodeExpression.Code> createCode, List<Integer> createDispPos, List<Integer> createUnits, List<Variable.Key> varsToDelete) {
                super("Apply Attribute Changes", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.owner = owner;
                this.createKey = createKey;
                this.createValue = createValue;
                this.createNew = createNew;
                this.createDisplay = createDisplay;
                this.createCode = createCode;
                this.createDispPos = createDispPos;
                this.createUnits = createUnits;
                this.varsToDelete = varsToDelete;
                this.startJob();
            }

            @Override
            public boolean doIt() throws JobException {
                for (Variable.Key key : this.varsToDelete) {
                    if (this.owner.isParam(key)) {
                        if (this.owner instanceof Cell) {
                            ((Cell)this.owner).getCellGroup().delParam((Variable.AttrKey)key);
                            continue;
                        }
                        if (!(this.owner instanceof NodeInst)) continue;
                        ((NodeInst)this.owner).delParameter(key);
                        continue;
                    }
                    this.owner.delVar(key);
                }
                for (int i = 0; i < this.createKey.size(); ++i) {
                    NodeInst ni;
                    Variable.Key key;
                    key = this.createKey.get(i);
                    Object obj = this.createValue.get(i);
                    boolean makeNew = this.createNew.get(i);
                    boolean display = this.createDisplay.get(i);
                    CodeExpression.Code code = this.createCode.get(i);
                    AbstractTextDescriptor.DispPos dispPos = AbstractTextDescriptor.DispPos.getShowStylesAt(this.createDispPos.get(i));
                    AbstractTextDescriptor.Unit units = AbstractTextDescriptor.Unit.getUnitAt(this.createUnits.get(i));
                    obj = Variable.withCode(obj, code);
                    Variable newVar = null;
                    newVar = makeNew ? this.owner.newVar(key, obj) : this.owner.updateVar(key, obj);
                    if (newVar == null) continue;
                    assert (newVar.getCode() == code);
                    TextDescriptor td = null;
                    if (this.owner instanceof NodeInst && (ni = (NodeInst)this.owner).isCellInstance()) {
                        Cell cell = (Cell)ni.getProto();
                        Iterator<Variable> it = cell.getParameters();
                        while (it.hasNext()) {
                            Variable var = it.next();
                            if (var.getKey() != key) continue;
                            td = var.getTextDescriptor();
                            double xOff = td.getXOff();
                            double yOff = td.getYOff();
                            td = td.withOff(xOff -= cell.getBounds().getCenterX(), yOff -= cell.getBounds().getCenterY());
                        }
                    }
                    if (td == null) {
                        td = newVar.getTextDescriptor();
                    }
                    td = td.withDisplay(display).withDispPart(dispPos).withUnit(units);
                    this.owner.setTextDescriptor(newVar.getKey(), td);
                }
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class VarEntrySort
        implements Comparator<VarEntry> {
            @Override
            public int compare(VarEntry v1, VarEntry v2) {
                String s1 = v1.getName();
                String s2 = v2.getName();
                return s1.compareToIgnoreCase(s2);
            }
        }

        private static class VarEntry {
            private String varTrueName;
            private Variable.Key varKey;
            private Object value;
            private CodeExpression.Code code;
            private AbstractTextDescriptor.DispPos dispPos;
            private AbstractTextDescriptor.Unit units;
            private boolean display;
            private ElectricObject owner;
            private Variable var;
            private String initialVarTrueName;
            private Object initialValue;
            private CodeExpression.Code initialCode;
            private AbstractTextDescriptor.DispPos initialDispPos;
            private AbstractTextDescriptor.Unit initialUnits;
            private boolean initialDisplay;

            private VarEntry(ElectricObject owner, Variable var) {
                this.owner = owner;
                this.var = var;
                if (var == null) {
                    return;
                }
                this.varKey = var.getKey();
                this.varTrueName = this.initialVarTrueName = var.getTrueName();
                this.value = this.initialValue = var.getObject();
                this.code = this.initialCode = var.getCode();
                this.dispPos = this.initialDispPos = var.getDispPart();
                this.units = this.initialUnits = var.getUnit();
                this.display = this.initialDisplay = var.isDisplay();
            }

            private String getName() {
                return this.varTrueName;
            }

            private Object getObject() {
                return this.value;
            }

            private CodeExpression.Code getCode() {
                return this.code;
            }

            private AbstractTextDescriptor.DispPos getDispPos() {
                return this.dispPos;
            }

            private AbstractTextDescriptor.Unit getUnits() {
                return this.units;
            }

            private boolean isDisplay() {
                return this.display;
            }

            private ElectricObject getOwner() {
                return this.owner;
            }

            private Variable.Key getKey() {
                return this.varKey;
            }

            private boolean isChanged() {
                if (!this.varTrueName.equals(this.initialVarTrueName)) {
                    return true;
                }
                if (this.value != this.initialValue) {
                    return true;
                }
                if (this.code != this.initialCode) {
                    return true;
                }
                if (this.display != this.initialDisplay) {
                    return true;
                }
                if (this.dispPos != this.initialDispPos) {
                    return true;
                }
                return this.units != this.initialUnits;
            }
        }
    }

    public static class AttValPair {
        Variable.Key key;
        String trueName;
        String value;
        String eval;
        boolean code;
    }
}

