#! /bin/sh
# -*- mode: scheme; coding: utf-8 -*-
exec guile -e main -s "$0" "$@"
!#


;;;;
;;;; Copyright (C) 2022
;;;; Free Software Foundation, Inc.

;;;; This file is part of GNU G-Golf

;;;; GNU G-Golf is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU Lesser General Public License as
;;;; published by the Free Software Foundation; either version 3 of the
;;;; License, or (at your option) any later version.

;;;; GNU G-Golf is distributed in the hope that it will be useful, but
;;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;; Lesser General Public License for more details.

;;;; You should have received a copy of the GNU Lesser General Public
;;;; License along with GNU G-Golf.  If not, see
;;;; <https://www.gnu.org/licenses/lgpl.html>.
;;;;

;;; Commentary:

;;; Code:


(eval-when (expand load eval)
  (use-modules (oop goops))

  (default-duplicate-binding-handler
    '(merge-generics replace warn-override-core warn last))

  (use-modules (g-golf))

  (g-irepository-require "Gtk" #:version "4.0")
  (for-each (lambda (name)
              (gi-import-by-name "Gtk" name))
      '("Application"
        "ApplicationWindow"
        "HeaderBar"
        "SearchBar"
        "SearchEntry"
        "Box"
        "Label"
        "ToggleButton")))


(define (activate app)
  (let* ((window (make <gtk-application-window>
                   #:title "Search Bar"
                   #:default-width 400
                   #:default-height 400
                   #:application app))
         (header-bar (make <gtk-header-bar>))
         (search-button (make <gtk-toggle-button>
                          #:icon-name "system-search-symbolic"))
         (box (make <gtk-box>
                #:orientation 'vertical
                #:spacing 6))
         (search-bar (make <gtk-search-bar>
                       #:valign 'start
                       #:key-capture-widget window))
         (search-entry (make <gtk-search-entry>
                         #:hexpand #t))
         (label  (make <gtk-label>
                   #:label "Type to start search"
                   #:hexpand #t
                   #:vexpand #t
                   #:halign 'center
                   #:valign 'center
                   #:css-classes '("large-title"))))

    (bind-property search-button "active"
                   search-bar "search-mode-enabled"
                   '(sync-create bidirectional))

    (connect search-entry
             'search-started
             (lambda (widget)
               (set-active search-button #t)))

    (connect search-entry
             'stop-search
             (lambda (widget)
               (set-active search-button #f)))

    (connect search-entry
             'search-changed
             (lambda (widget)
               (set-text label (!text search-entry))))

    (set-titlebar window header-bar)
    (pack-end header-bar search-button)
    (set-child window box)
    (set-child search-bar search-entry)
    (append box search-bar)
    (append box label)
    (show window)))


(define (main args)
  (let ((app (make <gtk-application>
               #:application-id "org.gtk.example")))
    (connect app 'activate activate)
    (let ((status (g-application-run app (length args) args)))
      (exit status))))
