<-- This file is part 17 of the GNU version of
    The Collaborative International Dictionary of English (GCIDE)

    Copyright (C) 1992-2012 Patrick J. Cassidy

    GCIDE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3, or (at your option)
    any later version.

    GCIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this copy of GCIDE.  If not, see <http://www.gnu.org/licenses/>.
-->

<p><-- p. 1171 --></p>

<p><centered><point26>Q.</point26></centered><br/
[<source>1913 Webster</source>]</p>

<p><ent>Q</ent><br/
<hw>Q</hw> <pr>(k<umac/)</pr>, <def>the seventeenth letter of the English alphabet, has but one sound (that of <xex>k</xex>), and is always followed by <xex>u</xex>, the two letters together being sounded like <xex>kw</xex>, except in some words in which the <xex>u</xex> is silent. See <xex>Guide to Pronunciation</xex>, <sect/ 249. Q is not found in Anglo-Saxon, <xex>cw</xex> being used instead of <xex>qu</xex>; as in <xex>cwic</xex>, quick; <xex>cwen</xex>, queen. The name (k<umac/) is from the French <xex>ku</xex>, which is from the Latin name of the same letter; its form is from the Latin, which derived it, through a Greek alphabet, from the Ph<oe/nician, the ultimate origin being Egyptian.</def><br/
[<source>1913 Webster</source>]</p>

<p>    Etymologically, <xex>q</xex> or <xex>qu</xex> is most nearly related to a (<xex>ch</xex>, <xex>tch</xex>), <xex>p</xex>, <xex>q</xex>, and <xex>wh</xex>; as in cud, <xex>quid</xex>, L. <xex>equ</xex>us, e<xex>c</xex>us, horse, Gr. <?/, whence E. <xex>equ</xex>ine, hi<xex>pp</xex>ic; L. <xex>qu</xex>od which, E. <xex>wh</xex>at; L. a<xex>qu</xex>ila, E. ea<xex>q</xex>le; E. ki<xex>tch</xex>en, OE. ki<xex>che</xex>ne, AS. cycene, L. co<xex>qu</xex>ina.<br/
[<source>1913 Webster</source>]</p>

<p><ent>Q.C.</ent><br/
<hw>Q.C.</hw> <pr>(k<umac/`s<emac/")</pr>, <pos>n.</pos> <def>Quality control.</def> <mark>[abbrev.]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>QCD</ent><br/
<hw>QCD</hw> <pr>(k<umac/"s<emac/*d<emac/")</pr>, <pos>n.</pos> <fld>(Physics)</fld> <def>Quantum chromodynamics.</def> <mark>[abbrev.]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>QED.</ent><br/
<hw>QED.</hw> <pr>(k<umac/"<emac/*d<emac/")</pr>, <pos>n.</pos> <def>Quantum electrodynamics.</def> <mark>[abbrev.]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>QED</ent><br/
<ent>Q.E.D</ent><br/
<mhw><hw>Q.E.D</hw>, <hw>QED</hw></mhw> <pr>(k<umac/"<emac/*d<emac/")</pr>, <pos>interj.</pos> <ety>[From Latin, <ets>quod erat demonstrandum</ets>, i.e. <sig>which was demonstrated</sig>.]</ety> <def>Which was demonstrated; -- a phrase used after the conclusion of some line of reasoning, especially in mathematical or logical proofs.</def> <mark>[abbrev.]</mark><br/
[<source>PJC</source>]</p>

<p><ent>Qua</ent><br/
<hw>Qua</hw> <pr>(?)</pr>, <pos>conj.</pos> <ety>[L., abl. of <ets>qui</ets> who.]</ety> <def>In so far as; in the capacity or character of; as.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It is with Shelley's biographers <qex>qua</qex> biographers that we have to deal.</q> <rj><qau>London Spectator.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quab</ent><br/
<hw>Quab</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. D. <ets>kwab</ets> eelpout, Dan. <ets>quabbe</ets>, G. <ets>quabbe</ets>, <ets>quappe</ets>, LG. <ets>quabbe</ets> a fat lump of flesh, and L. <ets>capito</ets> a kind of fish with a large head, fr. <ets>caput</ets> the head, also E. <ets>squab</ets>.]</ety> <def>An unfledged bird; hence, something immature or unfinished.</def>  <rj><au>Ford.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quab</ent><br/
<hw>Quab</hw>, <pos>v. i.</pos> <def>See <er>Quob</er>, <pos>v. i.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qua-bird</ent><br/
<hw>Qua"-bird`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The American night heron. See under <er>Night</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quacha</ent><br/
<hw>Qua"cha</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The quagga.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quack</ent><br/
<hw>Quack</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Qvacked</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quacking</conjf>.]</vmorph> <ety>[Of imitative origin; cf. D. <ets>kwaken</ets>, G. <ets>quacken</ets>, <ets>quaken</ets>, Icel. <ets>kvaka</ets> to twitter.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To utter a sound like the cry of a duck.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make vain and loud pretensions; to boast.</def> <ldquo/ To <xex>quack</xex> of universal cures.<rdquo/  <rj><au>Hudibras.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To act the part of a quack, or pretender.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quack</ent><br/
<hw>Quack</hw>, <pos>n.</pos> <sn>1.</sn> <def>The cry of the duck, or a sound in imitation of it; a hoarse, quacking noise.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[Cf. <er>Quacksalver</er>.]</ety> <def>A boastful pretender to medical skill; an empiric; an ignorant practitioner.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Hence, one who boastfully pretends to skill or knowledge of any kind not possessed; a charlatan.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Quacks</qex> political; <qex>quacks</qex> scientific, academical.</q> <rj><qau>Carlyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quack</ent><br/
<hw>Quack</hw>, <pos>a.</pos> <def>Pertaining to or characterized by, boasting and pretension; used by quacks; pretending to cure diseases; <as>as, a <ex>quack</ex> medicine; a <ex>quack</ex> doctor.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quackery</ent><br/
<hw>Quack"er*y</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quackeries</plw> <pr>(<?/)</pr>.</plu> <def>The acts, arts, or boastful pretensions of a quack; false pretensions to any art; empiricism.</def>  <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quack grass</ent><br/
<hw>Quack" grass`</hw> <pr>(?)</pr>. <fld>(Bot.)</fld> <def>See <er>Quitch grass</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quackish</ent><br/
<hw>Quack"ish</hw>, <pos>a.</pos> <def>Like a quack; boasting; characterized by quackery.</def>  <rj><au>Burke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quackism</ent><br/
<hw>Quack"ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Quackery.</def>  <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quackle</ent><br/
<hw>Quac"kle</hw> <pr>(?)</pr>, <pos>v. i. & t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quackled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quackling</conjf> <pr>(?)</pr>.]</vmorph> <ety>[Cf.<er>Querken</er>.]</ety> <def>To suffocate; to choke.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quacksalver</ent><br/
<hw>Quack"sal*ver</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[D. <ets>kwakzalver</ets>; cf. <ets>kwakzalven</ets> to quack or boast of one's salves. See <er>Quack</er>, <er>Salve</er>, <pos>n.</pos>]</ety> <def>One who boasts of his skill in medicines and salves, or of the efficacy of his prescriptions; a charlatan; a quack; a mountebank.</def> <mark>[Obs.]</mark>  <rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quade</ent><br/
<ent>Quad</ent><br/
<mhw>{ <hw>Quad</hw> <pr>(?)</pr>, <hw>Quade</hw> <pr>(?)</pr> }</mhw>, <pos>a.</pos> <ety>[Akin to AS. <ets>cw<aemac/d</ets>, <ets>cwead</ets>, dung, evil, G. <ets>kot</ets>, dung, OHG. <ets>qu<amac/t</ets>.]</ety> <def>Evil; bad; baffling; <as>as, a <ex>quade</ex> wind</as>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Sooth play, <qex>quad</qex> play, as the Fleming saith.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quad</ent><br/
<hw>Quad</hw>, <pos>n.</pos> <fld>(Print.)</fld> <def>A quadrat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quad</ent><br/
<hw>Quad</hw>, <pos>n.</pos> <fld>(Arch.)</fld> <def>A quadrangle; hence, a prison.</def> <mark>[Cant or Slang]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadra</ent><br/
\'d8<hw>Quad"ra</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quadr<ae/</plw> <pr>(#)</pr>.</plu> <ety>[L., a square, the socle, a platband, a fillet.]</ety> <fld>(Arch.)</fld> <sd>(a)</sd> <def>The plinth, or lowest member, of any pedestal, podium, water table, or the like.</def> <sd>(b)</sd> <def>A fillet, or listel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrable</ent><br/
<hw>Quad"ra*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Quadrate</er>.]</ety> <fld>(Math.)</fld> <def>That may be sqyared, or reduced to an equivalent square; -- said of a surface when the area limited by a curve can be exactly found, and expressed in a finite number of algebraic terms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadragenarious</ent><br/
<hw>Quad`ra*ge*na"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadragenarius</ets>, fr. <ets>qyadrageni</ets> forty each.]</ety> <def>Consisting of forty; forty years old.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadragene</ent><br/
<hw>Quad"ra*gene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL. <ets>quadragena</ets>, fr. L. <ets>quadrageni</ets> forty each, akin to <ets>quadraginta</ets> forty.]</ety> <fld>(R. C. Ch.)</fld> <def>An indulgence of forty days, corresponding to the forty days of ancient canonical penance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadragesima</ent><br/
\'d8<hw>Quad`ra*ges"i*ma</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. <ets>quadragesimus</ets> the fortieth, fr. <ets>quadraginta</ets> forty; akin to <ets>quattuor</ets> four. See <er>Four</er>.]</ety> <fld>(Eccl.)</fld> <def>The forty days of fast preceding Easter; Lent.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadragesima Sunday</b></col>, <cd>the first Sunday in Lent, about forty days before Easter.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadragesimal</ent><br/
<hw>Quad`ra*ges"i*mal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>quadrag<eacute/simal</ets>.]</ety> <def>Belonging to Lent; used in Lent; Lenten.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadragesimals</ent><br/
<hw>Quad`ra*ges"i*mals</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>Offerings formerly made to the mother church of a diocese on Mid-Lent Sunday.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrangle</ent><br/
<hw>Quad"ran`gle</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>quadrangulum</ets>; <ets>quattuor</ets> four + <ets>angulus</ets> an angle. See <er>Four</er>, and <er>Angle</er> a corner.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Geom.)</fld> <def>A plane figure having four angles, and consequently four sides; any figure having four angles.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A square or quadrangular space or inclosure, such a space or court surrounded by buildings, esp. such a court in a college or public school in England.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrangular</ent><br/
<hw>Quad*ran"gu*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>quadrangulaire</ets>.]</ety> <def>Having four angles, and consequently four sides; tetragonal.</def> -- <wordforms><wf>Quad*ran"gu*lar*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrans</ent><br/
\'d8<hw>Quad"rans</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quadrantes</plw> <pr>(#)</pr>.</plu> <ety>[L.]</ety> <sn>1.</sn> <fld>(Rom. Antiq.)</fld> <def>A fourth part of the coin called an as. See 3d As, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The fourth of a penny; a farthing. See <er>Cur</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrant</ent><br/
<hw>Quad"rant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quadrans</ets>, <ets>-antis</ets>, a fourth part, a fourth of a whole, fr. <ets>quattuor</ets> four: cf. F. <ets>quadrant</ets>, <ets>cadran</ets>. See <er>Four</er>, and cf. <er>Cadrans</er>.]</ety> <sn>1.</sn> <def>The fourth part; the quarter.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geom.)</fld> <def>The quarter of a circle, or of the circumference of a circle, an arc of 90<deg/, or one subtending a right angle at the center.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Anal. (Geom.)</fld> <def>One of the four parts into which a plane is divided by the coordinate axes. The upper right-hand part is the <xex>first quadrant</xex>; the upper left-hand part the <xex>second</xex>; the lower left-hand part the <xex>third</xex>; and the lower right-hand part the <xex>fourth quadrant</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An instrument for measuring altitudes, variously constructed and mounted for different specific uses in astronomy, surveying, gunnery, etc., consisting commonly of a graduated arc of 90<deg/, with an index or vernier, and either plain or telescopic sights, and usually having a plumb line or spirit level for fixing the vertical or horizontal direction.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Gunner's quadrant</b></col>, <cd>an instrument consisting of a graduated limb, with a plumb line or spirit level, and an arm by which it is applied to a cannon or mortar in adjusting it to the elevation required for attaining the desired range.</cd> -- <col><b>Gunter's quadrant</b></col>. <cd>See <er>Gunter's quadrant</er>, in the Vocabulary.</cd> -- <col><b>Hadley's quadrant</b></col>, <cd>a hand instrument used chiefly at sea to measure the altitude of the sun or other celestial body in ascertaining the vessel's position. It consists of a frame in the form of an octant having a graduated scale upon its arc, and an index arm, or alidade pivoted at its apex. Mirrors, called the index glass and the horizon glass, are fixed one upon the index arm and the other upon one side of the frame, respectively. When the instrument is held upright, the index arm may be swung so that the index glass will reflect an image of the sun upon the horizon glass, and when the reflected image of the sun coincides, to the observer's eye, with the horizon as seen directly through an opening at the side of the horizon glass, the index shows the sun's altitude upon the scale; -- more properly, but less commonly, called an <xex>octant</xex>.</cd> -- <col><b>Quadrant of altitude</b></col>, <cd>an appendage of the artificial globe, consisting of a slip of brass of the length of a quadrant of one of the great circles of the globe, and graduated. It may be fitted to the meridian, and being movable round to all points of the horizon, serves as a scale in measuring altitudes, azimuths, etc.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrantal</ent><br/
<hw>Quad*ran"tal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadrantalis</ets> containing the fourth fourth part of a measure.]</ety> <fld>(Geom.)</fld> <def>Of or pertaining to a quadrant; also, included in the fourth part of a circle; <as>as, <ex>quadrantal</ex> space</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadrantal triangle</b></col>, <cd>a spherical triangle having one side equal to a quadrant or arc of 90<deg/.</cd> -- <col><b>Quadrantal versor</b></col>, <cd>a versor that expresses rotation through one right angle.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrantal</ent><br/
<hw>Quad*ran"tal</hw>, <pos>n.</pos> <ety>[L.]</ety> <sn>1.</sn> <fld>(Rom. Antiq.)</fld> <def>A cubical vessel containing a Roman cubic foot, each side being a Roman square foot; -- used as a measure.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A cube.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrat</ent><br/
<hw>Quad"rat</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quadrat</ets>, <ets>cadrat</ets>. See <er>Quadrate</er>.]</ety> <sn>1.</sn> <fld>(Print.)</fld> <def>A block of type metal lower than the letters, -- used in spacing and in blank lines.</def> [Abbrev. <abbr>quad.</abbr>]<br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An old instrument used for taking altitudes; -- called also <altname>geometrical square</altname>, and <altname>line of shadows</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrate</ent><br/
<hw>Quad"rate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadratus</ets> squared, p. p. of <ets>quadrare</ets> to make four-cornered, to make square, to square, to fit, suit, from <ets>quadrus</ets> square, <ets>quattuor</ets> four. See <er>Quadrant</er>, and cf. <er>Quadrat</er>, <er>Quarry</er> an arrow, <er>Square</er>.]</ety> <sn>1.</sn> <def>Having four equal sides, the opposite sides parallel, and four right angles; square.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Figures, some round, some triangle, some <qex>quadrate</qex>.</q> <rj><qau>Foxe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Produced by multiplying a number by itself; square.</def> <ldquo/ <xex>Quadrate</xex> and cubical numbers.<rdquo/  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Square; even; balanced; equal; exact.</def> <mark>[Archaic]</mark> <ldquo/ A <xex>quadrate</xex>, solid, wise man.<rdquo/  <rj><au>Howell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Squared; suited; correspondent.</def> <mark>[Archaic]</mark> <ldquo/ A generical description <xex>quadrate</xex> to both.<rdquo/  <rj><au>Harvey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadrate bone</b></col> <fld>(Anat.)</fld>, <cd>a bone between the base of the lower jaw and the skull in most vertebrates below the mammals. In reptiles and birds it articulates the lower jaw with the skull; in mammals it is represented by the malleus or incus.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrate</ent><br/
<hw>Quad"rate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quadratum</ets>. See <er>Quadrate</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <fld>(Geom.)</fld> <def>A plane surface with four equal sides and four right angles; a square; hence, figuratively, anything having the outline of a square.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>At which command, the powers militant<br/
That stood for heaven, in mighty <qex>quadrate</qex> joined.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Astrol.)</fld> <def>An aspect of the heavenly bodies in which they are distant from each other 90<deg/, or the quarter of a circle; quartile. See the <er>Note</er> under <er>Aspect</er>, 6.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Anat.)</fld> <def>The quadrate bone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrate</ent><br/
<hw>Quad"rate</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quadrated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quadrating</conjf>.]</vmorph> <ety>[See <er>Quadrate</er>, <pos>a.</pos>]</ety> <def>To square; to agree; to suit; to correspond; -- followed by <xex>with</xex>.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The objections of these speculatists of its forms do not <qex>quadrate</qex> with their theories.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrate</ent><br/
<hw>Quad"rate</hw>, <pos>v. t.</pos> <def>To adjust (a gun) on its carriage; also, to train (a gun) for horizontal firing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadratic</ent><br/
<hw>Quad*rat"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>quadratique</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Of or pertaining to a square, or to squares; resembling a quadrate, or square; square.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Crystallog.)</fld> <def>Tetragonal.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Alg.)</fld> <def>Pertaining to terms of the second degree; <as>as, a <ex>quadratic</ex> equation, in which the highest power of the unknown quantity is a square</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadratics</ent><br/
<hw>Quad*rat"ics</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Alg.)</fld> <def>That branch of algebra which treats of quadratic equations.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadratojugal</ent><br/
<hw>Quad*ra`to*ju"gal</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Anat.)</fld> <sd>(a)</sd> <def>Of or pertaining to the quadrate and jugal bones.</def> <sd>(b)</sd> <def>Of or pertaining to the quadratojugal bone.</def> -- <def2><pos>n.</pos> <def>The quadratojugal bone.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadratojugal bone</b></col> <fld>(Anat.)</fld>, <cd>a bone at the base of the lower jaw in many animals.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadratrix</ent><br/
<hw>Quad*ra"trix</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>-trixes</plw> <pr>(#)</pr>, <it>or</it> <plw>-trices</plw> <pr>(#)</pr>.</plu> <ety>[NL.]</ety> <fld>(Geom.)</fld> <def>A curve made use of in the quadrature of other curves; <as>as the <ex>quadratrix</ex>, of Dinostratus, or of Tschirnhausen</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrature</ent><br/
<hw>Quad"ra*ture</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quadratura</ets>: cf. F. <ets>quadrature</ets>. See <er>Quadrate</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <fld>(Math.)</fld> <def>The act of squaring; the finding of a square having the same area as some given curvilinear figure; <as>as, the <ex>quadrature</ex> of a circle</as>; the operation of finding an expression for the area of a figure bounded wholly or in part by a curved line, as by a curve, two ordinates, and the axis of abscissas.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A quadrate; a square.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Integral Calculus)</fld> <def>The integral used in obtaining the area bounded by a curve; hence, the definite integral of the product of any function of one variable into the differential of that variable.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Astron.)</fld> <def>The position of one heavenly body in respect to another when distant from it 90<deg/, or a quarter of a circle, as the moon when at an equal distance from the points of conjunction and opposition.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadrature of the moon</b></col> <fld>(Astron.)</fld>, <cd>the position of the moon when one half of the disk is illuminated.</cd> -- <col><b>Quadrature of an orbit</b></col> <fld>(Astron.)</fld>, <cd>a point in an orbit which is at either extremity of the latus rectum drawn through the empty focus of the orbit.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrel</ent><br/
<hw>Quad"rel</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. <ets>quadrello</ets>, LL. <ets>quadrellus</ets>, fr. L. <ets>quadrus</ets> square. See <er>Quadrate</er>, and cf. <er>Quarrel</er> an arrow.]</ety> <sn>1.</sn> <def>A square piece of turf or peat.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A square brick, tile, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrennial</ent><br/
<hw>Quad*ren"ni*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadriennium</ets> a space of four years; <ets>quattuor</ets> four + <ets>annus</ets> year; cf. L. <ets>quadriennis</ets>. See <er>Quadrate</er>, and <er>Annual</er>.]</ety> <sn>1.</sn> <def>Comprising four years; <as>as, a <ex>quadrennial</ex> period</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Occurring once in four years, or at the end of every four years; <as>as, <ex>quadrennial</ex> games</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrennially</ent><br/
<hw>Quad*ren"ni*al*ly</hw>, <pos>adv.</pos> <def>Once in four years.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrennium</ent><br/
\'d8<hw>Quad*ren"ni*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. See <er>Quadrennial</er>.]</ety> <def>A space or period of four years.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadri-</ent><br/
<hw>Quad"ri-</hw> <pr>(?)</pr>. <ety>[L., from <ets>quattuor</ets> four. See <er>Four</er>.]</ety> <def>A combining form meaning <xex>four</xex>, <xex>four times</xex>, <xex>fourfold</xex>; <as>as, <ex>quadri</ex>capsular, having <xex>four</xex> capsules</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadribasic</ent><br/
<hw>Quad`ri*ba"sic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>basic</ets>.]</ety> <fld>(Chem.)</fld> <def>Same as <er>Tetrabasic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrible</ent><br/
<hw>Quad"ri*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Quadrable.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadric</ent><br/
<hw>Quad"ric</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Math.)</fld> <def>Of or pertaining to the second degree.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadric</ent><br/
<hw>Quad"ric</hw>, <pos>n.</pos> <sd>(a)</sd> <fld>(Alg.)</fld> <def>A quantic of the second degree. See <er>Quantic</er>.</def> <sd>(b)</sd> <fld>(Geom.)</fld> <def>A surface whose equation in three variables is of the second degree. Spheres, spheroids, ellipsoids, paraboloids, hyperboloids, also cones and cylinders with circular bases, are quadrics.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadricapsular</ent><br/
<hw>Quad`ri*cap"su*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>capsular</ets>.]</ety> <fld>(Bot.)</fld> <def>Having four capsules.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadriceps</ent><br/
\'d8<hw>Quad"ri*ceps</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL., fr. L. <ets>qyattuor</ets> four + <ets>caput</ets> head.]</ety> <fld>(Anat.)</fld> <def>The great extensor muscle of the knee, divided above into four parts which unite in a single tendon at the knee.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadricipital</ent><br/
<hw>Quad`ri*cip"i*tal</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Anat.)</fld> <def>Of or pertaining to the quadriceps.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadricorn</ent><br/
<hw>Quad"ri*corn</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Quadricornous</er>.]</ety> <fld>(Zool.)</fld> <def>Any quadricornous animal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadricornous</ent><br/
<hw>Quad`ri*cor"nous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + L. <ets>cornu</ets> horn: cf. F. <ets>quadricorne</ets>.]</ety> <fld>(Zool.)</fld> <def>Having four horns, or hornlike organs; <as>as, a <ex>quadricornous</ex> beetle</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadricostate</ent><br/
<hw>Quad`ri*cos"tate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>costate</ets>.]</ety> <def>Having four ribs.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1172 --></p>

<p><ent>Quadridentate</ent><br/
<hw>Quad`ri*den"tate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>dentate</ets>.]</ety> <def>Having four teeth; <as>as, a <ex>quadridentate</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadriennial</ent><br/
<hw>Quad`ri*en"ni*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Same as <er>Quadrennial</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrifarious</ent><br/
<hw>Quad`ri*fa"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadrifarius</ets> fourfold, fr. <ets>quattuor</ets> four: cf. F. <ets>quadrifari<eacute/</ets>.  Cf. <er>Multifarious</er>.]</ety> <def>Arranged in four rows or ranks; <as>as, <ex>quadrifarious</ex> leaves</as>.</def>  <rj><au>Loudon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrifid</ent><br/
<hw>Quad"ri*fid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadrifidus</ets>; <ets>quattuor</ets> four + <ets>findere</ets> to cleave: cf. F. <ets>quadrifide</ets>.]</ety> <def>Divided, or deeply cleft, into four parts; <as>as, a <ex>quadrifid</ex> perianth; a <ex>quadrifid</ex> leaf.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrifoliate</ent><br/
<ent>Quadrifoil</ent><br/
<mhw>{ <hw>Quad"ri*foil</hw> <pr>(?)</pr>, <hw>Quad`ri*fo"li*ate</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Quadri-</ets> + L. <ets>folium</ets> leaf.]</ety> <fld>(Bot.)</fld> <def>Four-leaved; having the leaves in whorls of four.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrifurcated</ent><br/
<hw>Quad`ri*fur"ca*ted</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>furcated</ets>.]</ety> <def>Having four forks, or branches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadriga</ent><br/
\'d8<hw>Quad*ri"ga</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quadrig<ae/</plw> <pr>(#)</pr>.</plu> <ety>[L. See <er>Quadrijugous</er>.]</ety> <fld>(Rom. Antiq.)</fld> <def>A car or chariot drawn by four horses abreast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrigeminous</ent><br/
<ent>Quadrigeminal</ent><br/
<mhw>{ <hw>Quad`ri*gem"i*nal</hw> <pr>(?)</pr>, <hw>Quad`ri*gem"i*nous</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Quadri-</ets> + L. <ets>gemini</ets> twins.]</ety> <def>Fourfold; having four similar parts, or two pairs of similar parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadrigeminal bodies</b></col> <fld>(Anat.)</fld>, <cd>two pairs of lobes, or elevations, on the dorsal side of the midbrain of most mammals; the optic lobes. The anterior pair are called the <xex>nates</xex>, and the posterior the <xex>testes</xex>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrigenarious</ent><br/
<hw>Quad`ri*ge*na"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadrigeni</ets>, <ets>quadringeni</ets>, four hundred each.]</ety> <def>Consisting of four hundred.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrijugate</ent><br/
<hw>Quad*rij"u*gate</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Same as <er>Quadrijugous</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrijugous</ent><br/
<hw>Quad*rij"u*gous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadrijugus</ets> of a team of four; <ets>quattuor</ets> four + <ets>jugum</ets> yoke.]</ety> <fld>(Bot.)</fld> <def>Pinnate, with four pairs of leaflets; <as>as, a <ex>quadrijugous</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrilateral</ent><br/
<hw>Quad`ri*lat"er*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadrilaterus</ets>:  cf. F. <ets>quadrilat<egrave/re</ets>, <ets>quadrilat<eacute/ral</ets>. See <er>Quadri-</er> and <er>Lateral</er>.]</ety> <def>Having four sides, and consequently four angles; quadrangular.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrilateral</ent><br/
<hw>Quad`ri*lat"er*al</hw>, <pos>n.</pos> <sn>1.</sn> <fld>(Geom.)</fld> <def>A plane figure having four sides, and consequently four angles; a quadrangular figure; any figure formed by four lines.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An area defended by four fortresses supporting each other; <as>as, the Venetian <ex>quadrilateral</ex>, comprising Mantua, Peschiera, Verona, and Legnano</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Complete quadrilateral</b></col> <fld>(Geom.)</fld>, <cd>the figure made up of the six straight lines that can be drawn through four points, <it>A</it>, <it>B</it>, <it>C</it>, <it>I</it>, the lines being supposed to be produced indefinitely.</cd></cs>
<-- reference is to a figure of a complete quadrilateral. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrilateralness</ent><br/
<hw>Quad`ri*lat"er*al*ness</hw>, <pos>n.</pos> <def>The property of being quadrilateral.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadriliteral</ent><br/
<hw>Quad`ri*lit"er*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>literal</ets>.]</ety> <def>Consisting of four letters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrille</ent><br/
<hw>Qua`dril`l<eacute/"</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F.]</ety> <fld>(Art)</fld> <def>Marked with squares, generally by thin lines crossing at right angles and at equal intervals; <as>as, <ex>quadrill<eacute/</ex> paper, or plotting paper</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quadrille</ent><br/
<hw>Qua*drille"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quadrille</ets>, n. fem., fr. Sp. <ets>cuadrilla</ets> meeting of four or more persons or It. <ets>quadriglia</ets> a band of soldiers, a sort of dance; dim. fr. L. <ets>quadra</ets> a square, fr. <ets>quattuor</ets> four. See <er>Quadrate</er>.]</ety> <sn>1.</sn> <def>A dance having five figures, in common time, four couples of dancers being in each set.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The appropriate music for a quadrille.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrille</ent><br/
<hw>Qua*drille"</hw>, <pos>n.</pos> <ety>[F. <ets>quadrille</ets>, n. masc., cf. It. <ets>quadriglio</ets>; or perhaps from the Spanish. See <er>Quadrille</er> a dance.]</ety> <def>A game played by four persons with forty cards, being the remainder of an ordinary pack after the tens, nines, and eights are discarded.</def>  <rj><au>Hoyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrillion</ent><br/
<hw>Quad*ril"lion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>quater</ets> four times, akin to <ets>quattuor</ets> four, E. <ets>four</ets>; -- formed like <ets>million</ets>. See <er>Four</er>, <er>Million</er>.]</ety> <def>According to the French notation, which is followed also upon the Continent and in the United States, a unit with fifteen ciphers annexed; according to the English notation, the number produced by involving a million to the fourth power, or the number represented by a unit with twenty-four ciphers annexed. See the Note under <er>Numeration</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrilobed</ent><br/
<ent>Quadrilobate</ent><br/
<mhw>{ <hw>Quad`ri*lo"bate</hw> <pr>(?)</pr>, <hw>Quad`ri*lobed</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>lobe</ets>: cf. F. <ets>quadrilob<eacute/</ets>.]</ety> <def>Having four lobes; <as>as, a <ex>quadrilobate</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrilocular</ent><br/
<hw>Quad`ri*loc"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>locular</ets>: cf. F. <ets>quadriloculaire</ets>.]</ety> <def>Having four cells, or cavities; <as>as, a <ex>quadrilocular</ex> heart</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrin</ent><br/
<hw>Quad"rin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF., fr. L. <ets>quadrini</ets> four each, fr. <ets>quattuor</ets> four.]</ety> <def>A small piece of money, in value about a farthing, or a half cent.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrinodal</ent><br/
<hw>Quad`ri*nod"al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>nodal</ets>.]</ety> <fld>(Math.)</fld> <def>Possessing four nodes; <as>as, <ex>quadrinodal</ex> curves</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrinomial</ent><br/
<hw>Quad`ri*no"mi*al</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quadri-</ets> + <ets>nomial</ets>, as in <ets>binomial</ets>: cf. F. <ets>quadrin<ocir/me</ets>.]</ety> <fld>(Alg.)</fld> <def>A polynomial of four terms connected by the signs plus or minus.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrinomical</ent><br/
<hw>Quad`ri*nom"ic*al</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Quadrinomial.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrinominal</ent><br/
<hw>Quad`ri*nom"i*nal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>nominal</ets>.]</ety> <fld>(Alg.)</fld> <def>Quadrinomial.</def>  <rj><au>Sir W. R. Hamilton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadripartite</ent><br/
<hw>Quad*rip"ar*tite</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadripartitus</ets>, p. p. of <ets>quadripartire</ets> to divide into four parts; <ets>quattuor</ets> four + <ets>partire</ets> to divide: cf. F. <ets>quadripartite</ets>.]</ety> <def>Divided into four parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadripartitely</ent><br/
<hw>Quad*rip"ar*tite*ly</hw>, <pos>adv.</pos> <def>In four parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadripartition</ent><br/
<hw>Quad`ri*par*ti"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quadripartitio</ets>: cf. F. <ets>quadripartition</ets>.]</ety> <def>A division or distribution by four, or into four parts; also, a taking the fourth part of any quantity or number.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadripennate</ent><br/
<hw>Quad`ri*pen"nate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>pennate</ets>.]</ety> <fld>(Zool.)</fld> <def>Having four wings; -- said of insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadriphyllous</ent><br/
<hw>Quad*riph"yl*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri</ets> + Gr. <?/ leaf.]</ety> <fld>(Bot.)</fld> <def>Having four leaves; quadrifoliate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrireme</ent><br/
<hw>Quad"ri*reme</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quadriremis</ets>; <ets>quattuor</ets> four + <ets>remus</ets> an oar: cf. F. <ets>quadrir<egrave/me</ets>.]</ety> <fld>(Antiq.)</fld> <def>A galley with four banks of oars or rowers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrisection</ent><br/
<hw>Quad`ri*sec"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quadri-</ets> + <ets>section</ets>.]</ety> <def>A subdivision into four parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrisulcate</ent><br/
<hw>Quad`ri*sul"cate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri</ets> + <ets>sulcate</ets>.]</ety> <fld>(Zool.)</fld> <def>Having four hoofs; <as>as, a <ex>quadrisulcate</ex> foot; a <ex>quadrisulcate</ex> animal.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadri-syllabical</ent><br/
<ent>Quadrisyllabic</ent><br/
<mhw>{ <hw>Quad`ri*syl*lab"ic</hw> <pr>(?)</pr>, <hw>Quad`ri-syl*lab"ic*al</hw> <pr>(?)</pr>, }</mhw><def>Having four syllables; of or pertaining to quadrisyllables; <as>as, a <ex>quadrisyllabic</ex> word</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrisyllable</ent><br/
<hw>Quad`ri*syl"la*ble</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quadri-</ets> + <ets>syllable</ets>: cf. F. <ets>quadrisyllabe</ets>.]</ety> <def>A word consisting of four syllables.</def>  <rj><au>De Quincey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrivalence</ent><br/
<hw>Quad*riv"a*lence</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>The quality or state of being quadrivalent; tetravalence.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrivalent</ent><br/
<hw>Quad*riv"a*lent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + L. <ets>valens</ets>, <ets>-entis</ets>, p. pr.  See <er>Valence</er>.]</ety> <fld>(Chem.)</fld> <def>Having a valence of four; capable of combining with, being replaced by, or compared with, four monad atoms; tetravalent; -- said of certain atoms and radicals; <as>thus, carbon and silicon are <ex>quadrivalent</ex> elements</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrivalve</ent><br/
<hw>Quad"ri*valve</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quadri-</ets> + <ets>valve</ets>:  cf. F. <ets>quadrivalve</ets>.]</ety> <fld>(Bot.)</fld> <def>Dehiscent into four similar parts; four-valved; <as>as, a <ex>quadrivalve</ex> pericarp</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrivalve</ent><br/
<hw>Quad"ri*valve</hw>, <pos>n.</pos> <fld>(Arch.)</fld> <def>A door, shutter, or the like, having four folds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrivalvular</ent><br/
<hw>Quad`ri*val"vu*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having four valves; quadrivalve.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrivial</ent><br/
<hw>Quad*riv"i*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadrivium</ets> a place where four ways meet; <ets>quattuor</ets> four + <ets>via</ets> way.]</ety> <def>Having four ways meeting in a point.</def>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrivial</ent><br/
<hw>Quad*riv"i*al</hw>, <pos>n.</pos> <def>One of the four <ldquo/liberal arts<rdquo/ making up the quadrivium.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrivium</ent><br/
\'d8<hw>Quad*riv"i*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>The four <ldquo/liberal arts,<rdquo/ arithmetic, music, geometry, and astronomy; -- so called by the schoolmen. See <er>Trivium</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadroon</ent><br/
<hw>Quad*roon"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quarteron</ets>, or Sp. <ets>cuarteron</ets>. See <er>Quarter</er> a fourth part, and cf. <er>Quarteron</er>.]</ety> <def>The offspring of a mulatto and a white person; a person quarter-blooded.</def> <altsp>[Written also <asp>quarteron</asp>, <asp>quarteroon</asp>, and <asp>quateron</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadroxide</ent><br/
<hw>Quad*rox"ide</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quadri-</ets> + <ets>oxide</ets>.]</ety> <fld>(Chem.)</fld> <def>A tetroxide.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrumana</ent><br/
\'d8<hw>Quad*ru"ma*na</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[NL. See <er>Quadrumane</er>.]</ety> <fld>(Zool.)</fld> <def>A division of the Primates comprising the apes and monkeys; -- so called because the hind foot is usually prehensile, and the great toe opposable somewhat like a thumb. Formerly the <xex>Quadrumana</xex> were considered an order distinct from the Bimana, which last included man alone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrumane</ent><br/
<hw>Quad"ru*mane</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quattuor</ets> four + <ets>manus</ets> a hand: cf. F. <ets>quadrumane</ets>.]</ety> <fld>(Zool.)</fld> <def>One of the Quadrumana.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrumanous</ent><br/
<hw>Quad*ru"ma*nous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Having four hands; of or pertaining to the Quadrumana.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruped</ent><br/
<hw>Quad"ru*ped</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadrupes</ets>, <ets>-pedis</ets>; <ets>quattuor</ets> four + <ets>pes</ets>, <ets>pedis</ets>, a foot: cf. F. <ets>quadrup<egrave/de</ets>. See <er>Quadrate</er>, and <er>Foot</er>.]</ety> <def>Having four feet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruped</ent><br/
<hw>Quad"ru*ped</hw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>An animal having four feet, as most mammals and reptiles; -- often restricted to the mammals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadrupedal</ent><br/
<hw>Quad*ru"pe*dal</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Zool.)</fld> <def>Having four feet; of or pertaining to a quadruped.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruplane</ent><br/
<hw>Quad"ru*plane</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quadru-</ets> in comp. + E. <ets>plane</ets>.]</ety> <def>An airplane with four superposed main supporting surfaces. Contrasted with <contr>triplane</contr> <contr>biplane</contr> and <contr>monoplane</contr>.  They are now used only for hobbyist or historical activities.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Quadruple</ent><br/
<hw>Quad"ru*ple</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadruplus</ets>, from <ets>quattuor</ets> four: cf. F.  <ets>quadruple</ets>. See <er>Quadrate</er>, and cf. <er>Double</er>.]</ety> <def>Fourfold; <as>as, to make <ex>quadruple</ex> restitution; a <ex>quadruple</ex> alliance.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadruple time</b></col> <fld>(Mus.)</fld>, <cd>that in which each measure is divided into four equal parts.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruple</ent><br/
<hw>Quad"ru*ple</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>quadruple</ets>, L. <ets>quadruplum</ets>.]</ety> <def>four times the sum or number; a fourfold amount; <as>as, to receive to <ex>quadruple</ex> of the amount in damages</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruple</ent><br/
<hw>Quad"ru*ple</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quadrupled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quadrupling</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>quadruplare</ets>: cf. F. <ets>quadrupler</ets>.]</ety> <def>To multiply by four; to increase fourfold; to double; to double twice.</def>  <rj><au>A. Smith.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruple</ent><br/
<hw>Quad"ru*ple</hw>, <pos>v. i.</pos> <def>To be multiplied by four; to increase fourfold; to become four times as much.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruplet</ent><br/
<hw>Quad"ru*plet</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Quadruple</er>.]</ety> <sn>1.</sn> <def>A collection or combination of four of a kind.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <pluf>pl</pluf>. <def>Four children born in the same labor.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>A cycle for carrying four riders, so arranged that all the riders can assist in the propulsion.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quadruplex</ent><br/
<hw>Quad"ru*plex</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L., from <ets>quattuor</ets> four + <ets>plicare</ets> to fold.]</ety> <def>Fourfold; folded or doubled twice.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quadruplex system</b></col> <fld>(Electric Telegraph)</fld>, <cd>a system by which four messages, two in each direction, may be sent simultaneously over the wire.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruplicate</ent><br/
<hw>Quad*ru"pli*cate</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quadruplicated</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quadruplicating</conjf>.]</vmorph> <ety>[L. <ets>quadruplicatus</ets>, p. p. of <ets>quadruplicare</ets>, fr. <ets>quadruple</ets><?/ fourfold. See <er>Quadruplex</er>.]</ety> <def>To make fourfold; to double twice; to quadruple.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruplicate</ent><br/
<hw>Quad*ru"pli*cate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quadruplicatus</ets>, p. p.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Fourfold; doubled twice; four times repeated; <as>as, a <ex>quadruplicate</ex> ratio, or a <ex>quadruplicate</ex> proportion</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Math.)</fld> <def>Raised to the fourth power.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruplication</ent><br/
<hw>Quad`ru*pli*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quadruplicatio</ets>: cf. F. <ets>quadruplication</ets>.]</ety> <def>The act of making fourfold; a taking four times the simple sum or amount.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quadruply</ent><br/
<hw>Quad"ru*ply</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>To a fourfold quantity; so as to be, or cause to be, quadruple; <as>as, to be <ex>quadruply</ex> recompensed</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaere</ent><br/
\'d8<hw>Qu<ae/"re</hw> <pr>(?)</pr>, <pos>v. imperative.</pos> <ety>[L., imperative of <ets>quaerere</ets> to seek.]</ety> <def>Inquire; question; see; -- used to signify doubt or to suggest investigation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaestor</ent><br/
\'d8<hw>Qu<ae/s"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>Same as <er>Questor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaff</ent><br/
<hw>Quaff</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quaffed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quaffing</conjf>.]</vmorph> <ety>[For <ets>quach</ets>, fr. Gael. & Ir. <ets>cuach</ets> a drinking cup; cf. L. <ets>caucus</ets> a drinking vessel.  Cf. <er>Quaigh</er>.]</ety> <def>To drink with relish; to drink copiously of; to swallow in large draughts.</def> <ldquo/<xex>Quaffed</xex> off the muscadel.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They eat, they drink, and in communion sweet<br/
<qex>Quaff</qex> immortality and joy.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaff</ent><br/
<hw>Quaff</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To drink largely or luxuriously.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Twelve days the gods their solemn revels keep,<br/
And <qex>quaff</qex> with blameless Ethiops in the deep.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaffer</ent><br/
<hw>Quaff"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who quaffs, or drinks largely.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quag</ent><br/
<hw>Quag</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A quagmire.</def> <mark>[R.]</mark> <ldquo/Crooked or straight, through <xex>quags</xex> or thorny dells.<rdquo/  <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quagga</ent><br/
<hw>Quag"ga</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Hottentot.]</ety> <fld>(Zool.)</fld> <def>A South African wild ass (<spn>Equus quagga</spn> syn. <spn>Hippotigris quagga</spn>).  The upper parts are reddish brown, becoming paler behind and behind and beneath, with dark stripes on the face, neck, and fore part of the body.  The species became extinct in the late 1800's, largely due to excessive hunting.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Quaggy</ent><br/
<hw>Quag"gy</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Quag</er>, <er>Quagmire</er>.]</ety> <def>Of the nature of a quagmire; yielding or trembling under the foot, as soft, wet earth; spongy; boggy.</def> <ldquo/O'er the watery strath, or <xex>quaggy</xex> moss.<rdquo/  <rj><au>Collins.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quagmire</ent><br/
<hw>Quag"mire`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quake</ets> + <ets>mire</ets>.]</ety> <def>Soft, wet, miry land, which shakes or yields under the feet.</def> <ldquo/A spot surrounded by <xex>quagmires</xex>, which rendered it difficult of access.<rdquo/  <rj><au>Palfrey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Morass; marsh; bog; swamp; fen; slough.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quahaug</ent><br/
<ent>Quahog</ent><br/
<mhw>{ <hw>Qua"hog</hw>, <hw>Qua"haug</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Abbrev. fr. Narragansett Indian <ets>poqua<ucir/hock</ets>.]</ety> <fld>(Zool.)</fld> <def>An American market clam (<spn>Venus mercenaria</spn>). It is sold in large quantities, and is highly valued as food. Called also <altname>round clam</altname>, and <altname>hard clam</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name is also applied to other allied species, as <spn>Venus Mortoni</spn> of the Gulf of Mexico.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaich</ent><br/
<ent>Quaigh</ent><br/
<mhw>{ <hw>Quaigh</hw>, <hw>Quaich</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gael. <ets>cuach</ets>.  Cf. <er>Quaff</er>.]</ety> <def>A small shallow cup or drinking vessel.</def> <mark>[Scot.]</mark> <altsp>[Written also <asp>quegh</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quail</ent><br/
<hw>Quail</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Qualled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Qualling</conjf>.]</vmorph> <ety>[AS. <ets>cwelan</ets> to die, perish; akin to <ets>cwalu</ets> violent death, D. <ets>kwaal</ets> pain, G. <ets>qual</ets> torment, OHG. <ets>quelan</ets> to suffer torment, Lith. <ets>gelti</ets> to hurt, <ets>gela</ets> pain.  Cf. <er>Quell</er>.]</ety> <sn>1.</sn> <def>To die; to perish; hence, to wither; to fade.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To become quelled; to become cast down; to sink under trial or apprehension of danger; to lose the spirit and power of resistance; to lose heart; to give way; to shrink; to cower.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The atheist power shall <qex>quail</qex>, and confess his fears. <qex>I</qex>. <qex>Taylor</qex>.<br/
Stouter hearts than a woman's have <qex>quailed</qex> in this terrible winter.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- to cower; flinch; shrink; quake; tremble; blench; succumb; yield.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quail</ent><br/
<hw>Quail</hw>, <pos>v. t.</pos> <ety>[Cf. <er>Quell</er>.]</ety> <def>To cause to fail in spirit or power; to quell; to crush; to subdue.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quail</ent><br/
<hw>Quail</hw>, <pos>v. i.</pos> <ety>[OF. <ets>coaillier</ets>, F. <ets>cailler</ets>, from L. <ets>coagulare</ets>. See <er>Coagulate</er>.]</ety> <def>To curdle; to coagulate, as milk.</def> <mark>[Obs.]</mark>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quail</ent><br/
<hw>Quail</hw>, <pos>n.</pos> <ety>[OF. <ets>quaille</ets>, F. <ets>caille</ets>, LL. <ets>quaquila</ets>, <ets>qualia</ets>, <ets>qualea</ets>, of Dutch or German origin; cf. D. <ets>kwakkel</ets>, <ets>kwartel</ets>, OHG. <ets>wahtala</ets>, G. <ets>wachtel</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Zool.)</fld> <def>Any gallinaceous bird belonging to <gen>Coturnix</gen> and several allied genera of the Old World, especially the common European quail (<spn>Coturnix communis</spn>), the rain quail (<spn>Coturnix Coromandelica</spn>) of India, the stubble quail (<spn>Coturnix pectoralis</spn>), and the Australian swamp quail (<spn>Synoicus australis</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>Any one of several American partridges belonging to <gen>Colinus</gen>, <gen>Callipepla</gen>, and allied genera, especially the bobwhite (called <stype>Virginia quail</stype>, and <stype>Maryland quail</stype>), and the California quail (<spn>Calipepla Californica</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>Any one of numerous species of Turnix and allied genera, native of the Old World, as the Australian painted quail (<spn>Turnix varius</spn>). See <er>Turnix</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A prostitute; -- so called because the quail was thought to be a very amorous bird.</def>  <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bustard quail</b></col> <fld>(Zool.)</fld>, <cd>a small Asiatic quail-like bird of the genus <gen>Turnix</gen>, as <spn>Turnix taigoor</spn>, a black-breasted species, and the hill <ex>bustard quail</ex> (<spn>Turnix ocellatus</spn>). See <er>Turnix</er>.</cd> -- <col><b>Button quail</b></col> <fld>(Zool.)</fld>, <cd>one of several small Asiatic species of Turnix, as <spn>Turnix Sykesii</spn>, which is said to be the smallest game bird of India.</cd> -- <col><b>Mountain quail</b></col>. <cd>See under <er>Mountain</er>.</cd> -- <col><b>Quail call</b></col>, <cd>a call or pipe for alluring quails into a net or within range.</cd> -- <col><b>Quail dove</b></col> <fld>(Zool.)</fld>, <cd>any one of several American ground pigeons belonging to <gen>Geotrygon</gen> and allied genera.</cd> -- <col><b>Quail hawk</b></col> <fld>(Zool.)</fld>, <cd>the New Zealand sparrow hawk (<spn>Hieracidea Nov<ae/-Hollandi<ae/</spn>).</cd> -- <col><b>Quail pipe</b></col>. <cd>See <cref>Quail call</cref>, above.</cd> -- <col><b>Quail snipe</b></col> <fld>(Zool.)</fld>, <cd>the dowitcher, or red-breasted snipe; -- called also <altname>robin snipe</altname>, and <altname>brown snipe</altname>.</cd> -- <col><b>Sea quail</b></col> <fld>(Zool.)</fld>, <cd>the turnstone.</cd> <mark>[Local, U. S.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1173 --></p>

<p><ent>Quaily</ent><br/
<hw>Quail"y</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Quail</er> the bird.]</ety> <fld>(Zool.)</fld> <def>The upland plover.</def> <mark>[Canadian]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaint</ent><br/
<hw>Quaint</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OE. <ets>queint</ets>, <ets>queynte</ets>, <ets>coint</ets>, prudent, wise, cunning, pretty, odd, OF. <ets>cointe</ets> cultivated, amiable, agreeable, neat, fr. L. <ets>cognitus</ets> known, p. p. of <ets>cognoscere</ets> to know; <ets>con + noscere</ets> (for <ets>gnoscere</ets>) to know. See <er>Know</er>, and cf. <er>Acquaint</er>, <er>Cognition</er>.]</ety> <sn>1.</sn> <def>Prudent; wise; hence, crafty; artful; wily.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Clerks be full subtle and full <qex>quaint</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Characterized by ingenuity or art; finely fashioned; skillfully wrought; elegant; graceful; nice; neat.</def> <mark>[Archaic]</mark> <ldquo/ The <xex>queynte</xex> ring.<rdquo/ <ldquo/ His <xex>queynte</xex> spear.<rdquo/ <au>Chaucer.</au> <ldquo/ A shepherd young <xex>quaint</xex>.<rdquo/  <rj><au>Chapman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Every look was coy and wondrous <qex>quaint</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To show bow <qex>quaint</qex> an orator you are.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Curious and fanciful; affected; odd; whimsical; antique; archaic; singular; unusual; <as>as, <ex>quaint</ex> architecture; a <ex>quaint</ex> expression.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some stroke of <qex>quaint</qex> yet simple pleasantry.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>An old, long-faced, long-bodied servant in <qex>quaint</qex> livery.</q> <rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- <er>Quaint</er>, <er>Odd</er>, <er>Antique</er>.</syn> <usage> <xex>Antique</xex> is applied to that which has come down from the ancients, or which is made to imitate some ancient work of art. <xex>Odd</xex> implies disharmony, incongruity, or unevenness. An <xex>odd</xex> thing or person is an exception to general rules of calculation and procedure, or expectation and common experience. In the current use of <xex>quaint</xex>, the two ideas of <xex>odd</xex> and <xex>antique</xex> are combined, and the word is commonly applied to that which is pleasing by reason of both these qualities.  Thus, we speak of the <xex>quaint</xex> architecture of many old buildings in London; or a <xex>quaint</xex> expression, uniting at once the antique and the fanciful.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaintise</ent><br/
<hw>Quain"tise</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>cointise</ets>.]</ety> <sn>1.</sn> <def>Craft; subtlety; cunning.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer. R. of Glouces.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Elegance; beauty.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaintly</ent><br/
<hw>Quaint"ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a quaint manner.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaintness</ent><br/
<hw>Quaint"ness</hw>, <pos>n.</pos> <def>The quality of being quaint.</def>  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quair</ent><br/
<hw>Quair</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See 3d <er>Quire</er>.]</ety> <def>A quire; a book.</def> <mark>[Obs.]</mark> <ldquo/The king's <xex>quhair</xex>.<rdquo/  <rj><au>James I. (of Scotland).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quake</ent><br/
<hw>Quake</hw> <pr>(kw<amac/k)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quaked</conjf> <pr>(kw<amac/kt)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quaking</conjf>.]</vmorph> <ety>[AS. <ets>cwacian</ets>; cf. G. <ets>quackeln</ets>.  Cf. <er>Quagmire</er>.]</ety> <sn>1.</sn> <def>To be agitated with quick, short motions continually repeated; to shake with fear, cold, etc.; to shudder; to tremble.</def> <ldquo/<xex>Quaking</xex> for dread.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She stood <qex>quaking</qex> like the partridge on which the hawk is ready to seize.</q> <rj><qau>Sir P. Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To shake, vibrate, or quiver, either from not being solid, as soft, wet land, or from violent convulsion of any kind; <as>as, the earth <ex>quakes</ex>; the mountains <ex>quake</ex>.</as></def> <ldquo/ Over <xex>quaking</xex> bogs.<rdquo/  <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quake</ent><br/
<hw>Quake</hw>, <pos>v. t.</pos> <ety>[Cf. AS. <ets>cweccan</ets> to move, shake. See <er>Quake</er>, <pos>v. t.</pos>]</ety> <def>To cause to quake.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quake</ent><br/
<hw>Quake</hw> <pr>(kw<amac/k)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A tremulous agitation; a quick vibratory movement; a shudder; a quivering.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An earthquake.</def><br/
<syn><b>Syn. --</b> earthquake; tremor; temblor.</syn><br/
[<source>PJC</source>]</p>

<p><ent>Quaker</ent><br/
<hw>Quak"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who quakes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of a religious sect founded by George <er>Fox</er>, of Leicestershire, England, about 1650, -- the members of which call themselves <xex>Friends</xex>. They were called Quakers, originally, in derision. See <er>Friend</er>, <pos>n.</pos>, 4.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Fox's teaching was primarily a preaching of repentance . . . The trembling among the listening crowd caused or confirmed the name of <qex>Quakers</qex> given to the body; men and women sometimes fell down and lay struggling as if for life.</q> <rj><qau>Encyc. Brit.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The nankeen bird.</def> <sd>(b)</sd> <def>The sooty albatross.</def> <sd>(c)</sd> <def>Any grasshopper or locust of the genus <gen>Edipoda</gen>; -- so called from the quaking noise made during flight.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quaker buttons</b></col>. <fld>(Bot.)</fld> <cd>See <er>Nux vomica</er>.</cd> -- <col><b>Quaker gun</b></col>, <cd>a dummy cannon made of wood or other material; -- so called because the sect of Friends, or Quakers, hold to the doctrine, of nonresistance.</cd> -- <col><b>Quaker ladies</b></col> <fld>(Bot.)</fld>, <cd>a low American biennial plant (<spn>Houstonia c<ae/rulea</spn>), with pretty four-lobed corollas which are pale blue with a yellowish center; -- also called <altname>bluets</altname>, and <altname>little innocents</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quakeress</ent><br/
<hw>Quak"er*ess</hw>, <pos>n.</pos> <def>A woman who is a member of the Society of Friends.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quakerish</ent><br/
<hw>Quak"er*ish</hw>, <pos>a.</pos> <def>Like or pertaining to a Quaker; Quakerlike.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quakerism</ent><br/
<hw>Quak"er*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The peculiar character, manners, tenets, etc., of the Quakers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quakerlike</ent><br/
<hw>Quak"er*like</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Like a Quaker.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quakerly</ent><br/
<hw>Quak"er*ly</hw>, <pos>a.</pos> <def>Resembling Quakers; Quakerlike; Quakerish.</def>  <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quakery</ent><br/
<hw>Quak"er*y</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Quakerism.</def> <mark>[Obs.]</mark>  <rj><au>Hallywell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaketail</ent><br/
<hw>Quake"tail`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A wagtail.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quakiness</ent><br/
<hw>Quak"i*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state of being quaky; liability to quake.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaking</ent><br/
<hw>Quak"ing</hw>, <def><pos>a. & n.</pos> from <er>Quake</er>, <pos>v.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quaking aspen</b></col> <fld>(Bot.)</fld>, <cd>an American species of poplar (<spn>Populus tremuloides</spn>), the leaves of which tremble in the lightest breeze. It much resembles the European aspen. See <er>Aspen</er>.</cd><-- #err in original written "Quaking asp"! --> -- <col><b>Quaking bog</b></col>, <cd>a bog of forming peat so saturated with water that it shakes when trodden upon.</cd> -- <col><b>Quaking grass</b></col>. <fld>(Bot.)</fld> <sd>(a)</sd> <cd>One of several grasses of the genus <gen>Briza</gen>, having slender-stalked and pendulous ovate spikelets, which quake and rattle in the wind.  <spn>Briza maxima</spn> is the large quaking grass; <spn>Briza media</spn> and <spn>Briza minor</spn> are the smaller kinds.</cd> <sd>(b)</sd> <cd>Rattlesnake grass (<spn>Glyceria Canadensis</spn>).</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quakingly</ent><br/
<hw>Quak"ing*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a quaking manner; fearfully.</def>  <rj><au>Sir P. Sidney.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaky</ent><br/
<hw>Quak"y</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Shaky, or tremulous; quaking.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualifiable</ent><br/
<hw>Qual"i*fi`a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being qualified; abatable; modifiable.</def>  <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualification</ent><br/
<hw>Qual`i*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>qualification</ets>. See <er>Qualify</er>.]</ety> <sn>1.</sn> <def>The act of qualifying, or the condition of being qualified.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which qualifies; any natural endowment, or any acquirement, which fits a person for a place, office, or employment, or which enables him to sustian any character with success; an enabling quality or circumstance; requisite capacity or possession.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There is no <qex>qualification</qex> for government but virtue and wisdom, actual or presumptive.</q> <rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The act of limiting, or the state of being limited; that which qualifies by limiting; modification; restriction; hence, abatement; diminution; <as>as, to use words without any <ex>qualification</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualificative</ent><br/
<hw>Qual"i*fi*ca*tive</hw> <pr>(?)</pr>, <pos>n.</pos> <def>That which qualifies, modifies, or restricts; a qualifying term or statement.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How many <qex>qualificatives</qex>, correctives, and restrictives he inserteth in this relation.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualificator</ent><br/
<hw>Qual"i*fi*ca`tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL.]</ety> <fld>(R. C. Ch.)</fld> <def>An officer whose business it is to examine and prepare causes for trial in the ecclesiastical courts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualified</ent><br/
<hw>Qual"i*fied</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Fitted by accomplishments or endowments.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Modified; limited; <as>as, a <ex>qualified</ex> statement</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Qualified fee</b></col> <fld>(Law)</fld>, <cd>a base fee, or an estate which has a qualification annexed to it, the fee ceasing with the qualification, as a grant to A and his heirs, <xex>tenants of the manor of Dale</xex>.</cd> -- <col><b>Qualified indorsement</b></col> <fld>(Law)</fld>, <cd>an indorsement which modifies the liability of the indorser that would result from the general principles of law, but does not affect the negotiability of the instrument.</cd> <au>Story.</au> -- <col><b>Qualified negative</b></col> <fld>(Legislation)</fld>, <cd>a limited veto power, by which the chief executive in a constitutional government may refuse assent to bills passed by the legislative body, which bills therefore fail to become laws unless upon a reconsideration the legislature again passes them by a certain majority specified in the constitution, when they become laws without the approval of the executive.</cd> -- <col><b>Qualified property</b></col> <fld>(Law)</fld>, <cd>that which depends on temporary possession, as that in wild animals reclaimed, or as in the case of a bailment.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Competent; fit; adapted.</syn> <usage> -- <er>Qualified</er>, <er>Competent</er>. <xex>Competent</xex> is most commonly used with respect to native endowments and general ability suited to the performance of a task or duty; <xex>qualified</xex> with respect to specific acquirements and training.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualifiedly</ent><br/
<hw>Qual"i*fied`ly</hw>, <pos>adv.</pos> <def>In the way of qualification; with modification or qualification.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualifiedness</ent><br/
<hw>Qual"i*fied`ness</hw>, <pos>n.</pos> <def>The state of being qualified.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualifier</ent><br/
<hw>Qual"i*fi`er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that which, qualifies; that which modifies, reduces, tempers or restrains.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualify</ent><br/
<hw>Qual"i*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Qualified</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Qualifying</conjf> <pr>(?)</pr>.]</vmorph> <ety>[F. <ets>qualifier</ets>, LL. <ets>qualificare</ets>, fr. L. <ets>qualis</ets> how constituted, as + <ets>-ficare</ets> (in comp.) to make. See <er>Quality</er>, and <er>-Fy</er>.]</ety> <sn>1.</sn> <def>To make such as is required; to give added or requisite qualities to; to fit, as for a place, office, occupation, or character; to furnish with the knowledge, skill, or other accomplishment necessary for a purpose; to make capable, as of an employment or privilege; to supply with legal power or capacity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He had <qex>qualified</qex> himself for municipal office by taking the oaths to the sovereigns in possession.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To give individual quality to; to modulate; to vary; to regulate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It hath no larynx . . . to <qex>qualify</qex> the sound. </q> <rj><qau>Sir T. Browne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To reduce from a general, undefined, or comprehensive form, to particular or restricted form; to modify; to limit; to restrict; to restrain; <as>as, to <ex>qualify</ex> a statement, claim, or proposition</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Hence, to soften; to abate; to diminish; to assuage; to reduce the strength of, as liquors.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I do not seek to quench your love's hot fire,<br/
But <qex>qualify</qex> the fire's extreme rage.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To soothe; to cure; -- said of persons.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In short space he has them <qex>qualified</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To fit; equip; prepare; adapt; capacitate; enable; modify; soften; restrict; restrain; temper.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualify</ent><br/
<hw>Qual"i*fy</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To be or become qualified; to be fit, as for an office or employment.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To obtain legal power or capacity by taking the oath, or complying with the forms required, on assuming an office.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualitative</ent><br/
<hw>Qual"i*ta*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. LL. <ets>gualitativus</ets>, F. <ets>qualitatif</ets>.]</ety> <def>Relating to quality; having the character of quality.</def> -- <wordforms><wf>Qual"i*ta*tive*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Qualitative analysis</b></col> <fld>(Chem.)</fld>, <cd>analysis which merely determines the constituents of a substance without any regard to the quantity of each ingredient; -- contrasted with <xex>quantitative analysis</xex>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualitied</ent><br/
<hw>Qual"i*tied</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Furnished with qualities; endowed.</def> <mark>[Obs.]</mark> <ldquo/He was well <xex>qualitied</xex>.<rdquo/  <rj><au>Chapman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quality</ent><br/
<hw>Qual"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Qualities</plw> <pr>(#)</pr>.</plu> <ety>[F. <ets>qualit<eacute/</ets>, L. <ets>qualitas</ets>, fr. <ets>qualis</ets> how constituted, as; akin to E. <ets>which</ets>. See <er>Which</er>.]</ety> <sn>1.</sn> <def>The condition of being of such and such a sort as distinguished from others; nature or character relatively considered, as of goods; character; sort; rank.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We lived most joyful, obtaining acquaintance with many of the city not of the meanest <qex>quality</qex>.</q> <rj><qau>Bacon</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Special or temporary character; profession; occupation; assumed or asserted rank, part, or position.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I made that inquiry in <qex>quality</qex> of an antiquary.</q> <rj><qau>Gray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which makes, or helps to make, anything such as it is; anything belonging to a subject, or predicable of it; distinguishing property, characteristic, or attribute; peculiar power, capacity, or virtue; distinctive trait; <as>as, the tones of a flute differ from those of a violin in <ex>quality</ex>; the great <ex>quality</ex> of a statesman.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Qualities</xex>, in metaphysics, are <xex>primary</xex> or <xex>secondary</xex>. <xex>Primary</xex> are those essential to the existence, and even the conception, of the thing, as of matter or spirit <xex>Secondary</xex> are those not essential to such a conception.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An acquired trait; accomplishment; acquisition.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He had those <qex>qualities</qex> of horsemanship, dancing, and fencing which accompany a good breeding.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Superior birth or station; high rank; elevated character.</def> <ldquo/Persons of <xex>quality</xex>.<rdquo/  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quality binding</b></col>, <cd>a kind of worsted tape used in Scotland for binding carpets, and the like.</cd> -- <col><b>The quality</b></col>, <cd>those of high rank or station, as distinguished from <contr>the masses</contr>, or common people; the nobility; the gentry.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>I shall appear at the masquerade dressed up in my feathers, that <qex>the quality</qex> may see how pretty they will look in their traveling habits.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Property; attribute; nature; peculiarity; character; sort; rank; disposition; temper.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualm</ent><br/
<hw>Qualm</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>cwealm</ets> death, slaughter, pestilence, akin to OS. & OHG. <ets>qualm</ets>. See <er>Quail</er> to cower.]</ety> <sn>1.</sn> <def>Sickness; disease; pestilence; death.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q> thousand slain and not of <qex>qualm</qex> ystorve [dead].</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A sudden attack of illness, faintness, or pain; an agony.</def> <ldquo/ <xex>Qualms</xex> of heartsick agony.<rdquo/  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Especially, a sudden sensation of nausea.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For who, without a <qex>qualm</qex>, hath ever looked<br/
On holy garbage, though by Homer cooked?</q> <rj><qau>Roscommon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A prick or scruple of conscience; uneasiness of conscience; compunction.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qualmish</ent><br/
<hw>Qualm"ish</hw>, <pos>a.</pos> <def>Sick at the stomach; affected with nausea or sickly languor; inclined to vomit.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Qualm"ish*ly</wf>, <pos>adv.</pos> -- <wf>Qualm"ish*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quamash</ent><br/
<hw>Quam"ash</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>See <er>Camass</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quamoclit</ent><br/
<hw>Quam"o*clit</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ a bean + <?/ to bend, to slope.]</ety> <fld>(Bot.)</fld> <def>Formerly, a genus of plants including the cypress vine (<spn>Quamoclit vulgaris</spn>, now called <spn>Ipom<oe/a Quamoclit</spn>). The genus is now merged in Ipom<oe/a.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quandary</ent><br/
<hw>Quan"da*ry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quandaries</plw> <pr>(#)</pr>.</plu> <ety>[Prob. fr. OE. <ets>wandreth</ets> adversity, perplexity, Icel. <ets>wandr<ae/<edh/i</ets> difficulty, trouble, fr. <ets>vandr</ets> difficult.]</ety> <def>A state of difficulty or perplexity; doubt; uncertainty.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quandary</ent><br/
<hw>Quan"da*ry</hw>, <pos>v. t.</pos> <def>To bring into a state of uncertainty, perplexity, or difficulty.</def> <mark>[Obs.]</mark>  <rj><au>Otway.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quandong</ent><br/
<hw>Quan"dong</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The edible drupaceous fruit of an Australian tree (<spn>Fusanus acuminatus</spn>) of the Sandalwood family; -- called also <altname>quandang</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quandy</ent><br/
<hw>Quan"dy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety> <fld>(Zool.)</fld> <def>The old squaw.</def> <mark>[Local, U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quannet</ent><br/
<hw>Quan"net</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A flat file having the handle at one side, so as to be used like a plane.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quant</ent><br/
<hw>Quant</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A punting pole with a broad flange near the end to prevent it from sinking into the mud; a setting pole.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quantic</ent><br/
<hw>Quan"tic</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quantus</ets> how much. See <er>Quantity</er>.]</ety> <fld>(Math.)</fld> <def>A homogeneous algebraic function of two or more variables, in general containing only positive integral powers of the variables, and called <xex>quadric</xex>, <xex>cubic</xex>, <xex>quartic</xex>, etc., according as it is of the second, third, fourth, fifth, or a higher degree. These are further called <xex>binary</xex>, <xex>ternary</xex>, <xex>quaternary</xex>, etc., according as they contain two, three, four, or more variables; thus, the <xex>quantic <?/</xex> is a <xex>binary cubic</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quantification</ent><br/
<hw>Quan`ti*fi*ca"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Quantity</er>.]</ety> <def>Modification by a reference to quantity; the introduction of the element of quantity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>quantification</qex> of the predicate belongs in part to Sir William Hamilton; viz., in its extension to negative propositions.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quantify</ent><br/
<hw>Quan"ti*fy</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[L. <ets>quantus</ets> now much + <ets>-fy</ets>.]</ety> <sn>1.</sn> <def>To modify or qualify with respect to quantity; to determine, fix or express the quantity of; to rate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Logic)</fld> <def>To make explicit the quantity of; <as>as, to <ex>quantify</ex> a variable</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Quantitative</ent><br/
<hw>Quan"ti*ta*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>quantitatif</ets>.]</ety> <def>Relating to quantity.</def> -- <wordforms><wf>Quan"ti*ta*tive*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quantitative analysis</b></col> <fld>(Chem.)</fld>, <cd>analysis which determines the amount or quantity of each ingredient of a substance, by weight or by volume; -- contrasted with <contr>qualitative analysis</contr>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quantitive</ent><br/
<hw>Quan"ti*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Quantity</er>.]</ety> <def>Estimable according to quantity; quantitative.</def>  <rj><au>Sir K. Digby.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quantitively</ent><br/
<hw>Quan"ti*tive*ly</hw>, <pos>adv.</pos> <def>So as to be measurable by quantity; quantitatively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quantity</ent><br/
<hw>Quan"ti*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quantities</plw> <pr>(#)</pr>.</plu> <ety>[F. <ets>quantite</ets>, L. <ets>quantitas</ets>, fr. <ets>quantus</ets> bow great, how much, akin to <ets>quam</ets> bow, E. <ets>how</ets>, <ets>who</ets>. See <er>Who</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The attribute of being so much, and not more or less; the property of being measurable, or capable of increase and decrease, multiplication and division; greatness; and more concretely, that which answers the question <ldquo/How much?<rdquo/; measure in regard to bulk or amount; determinate or comparative dimensions; measure; amount; bulk; extent; size.</def> Hence, in specific uses: <sd>(a)</sd> <fld>(Logic)</fld> <def>The extent or extension of a general conception, that is, the number of species or individuals to which it may be applied; also, its content or comprehension, that is, the number of its constituent qualities, attributes, or relations.</def> <sd>(b)</sd> <fld>(Gram.)</fld> <def>The measure of a syllable; that which determines the time in which it is pronounced; <as>as, the long or short <ex>quantity</ex> of a vowel or syllable</as>.</def> <sd>(c)</sd> <fld>(Mus.)</fld> <def>The relative duration of a tone.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which can be increased, diminished, or measured; especially <fld>(Math.)</fld>, anything to which mathematical processes are applicable.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Quantity is <xex>discrete</xex> when it is applied to separate objects, as in number; <xex>continuous</xex>, when the parts are connected, either in succession, as in time, motion, etc., or in extension, as by the dimensions of space, viz., length, breadth, and thickness.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A determinate or estimated amount; a sum or bulk; a certain portion or part; sometimes, a considerable amount; a large portion, bulk, or sum; <as>as, a medicine taken in <ex>quantities</ex>, that is, in large quantities</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>quantity</qex> of extensive and curious information which he had picked up during many months of desultory, but not unprofitable, study.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quantity of estate</b></col> <fld>(Law)</fld>, <cd>its time of continuance, or degree of interest, as in fee, for life, or for years.</cd> <au>Wharton (Law Dict. )</au> -- <col><b>Quantity of matter</b></col>, <cd>in a body, its mass, as determined by its weight, or by its momentum under a given velocity.</cd> -- <col><b>Quantity of motion</b></col> <fld>(Mech.)</fld>, <cd>in a body, the relative amount of its motion, as measured by its momentum, varying as the product of mass and velocity.</cd> -- <col><b>Known quantities</b></col> <fld>(Math.)</fld>, <cd>quantities whose values are given.</cd> -- <col><b>Unknown quantities</b></col> <fld>(Math.)</fld>, <cd>quantities whose values are sought.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1174 --></p>

<p><ent>Quantivalence</ent><br/
<hw>Quan*tiv"a*lence</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quant</ets>us how much + E. <ets>valence</ets>.]</ety> <fld>(Chem.)</fld> <def>Valence.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quantivalent</ent><br/
<hw>Quan*tiv"a*lent</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of or pertaining to quantivalence.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quantum</ent><br/
<hw>Quan"tum</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quanta</plw> <pr>(#)</pr>.</plu> <ety>[L., neuter of <ets>quantus</ets> how great, how much. See <er>Quantity</er>,]</ety> <sn>1.</sn> <def>Quantity; amount.</def> <ldquo/Without authenticating . . . the <xex>quantum</xex> of the charges.<rdquo/  <rj><au>Burke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Math.)</fld> <def>A definite portion of a manifoldness, limited by a mark or by a boundary.</def>  <rj><au>W. K. Clifford.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>\'d8Quantum meruit</b></col> <pr>(<?/)</pr> <ety>[L., as much as he merited]</ety> <fld>(Law)</fld>, <cd>a count in an action grounded on a promise that the defendant would pay to the plaintiff for his service as much as he should deserve.</cd> -- <mcol><col><b>\'d8Quantum sufficit</b></col> <pr>(<?/)</pr>, <it>or</it> <col><b>Quantum suff.</b></col></mcol>  <ety>[L., as much suffices]</ety> <fld>(Med.)</fld>, <cd>a sufficient quantity; -- abbreviated  <altname>q. s.</altname> in pharmacy.</cd> -- <col><b>\'d8Quantum valebat</b></col> <pr>(<?/)</pr> <ety>[L., as much at it was worth]</ety> <fld>(Law)</fld>, <cd>a count in an action to recover of the defendant, for goods sold, as much as they were worth.</cd>  <rj><au>Blackstone.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quap</ent><br/
<hw>Quap</hw> <pr>(?)</pr>, <pos>v. i.</pos> <def>To quaver.</def> <mark>[Obs.]</mark> <see>See <er>Quob</er>.</see><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaquaversal</ent><br/
<hw>Qua`qua*ver"sal</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quaqua</ets> wheresoever, whithersoever + <ets>versus</ets>, p. p. of <ets>vertere</ets> to turn.]</ety> <sn>1.</sn> <def>Turning or dipping in any or every direction.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>Dipping toward all points of the compass round a center, as beds of lava round a crater.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quar</ent><br/
<hw>Quar</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A quarry.</def> <mark>[Prov. Eng.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarantine</ent><br/
<hw>Quar"an*tine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quarantaine</ets>, OF. <ets>quaranteine</ets>, fr. F. <ets>quarante</ets> forty, L. <ets>quadraginta</ets>, akin to <ets>quattuor</ets> four, and E. <ets>four</ets>: cf. It. <ets>quarantina</ets>, <ets>quarentine</ets>. See <er>Four</er>, and cf. <er>Quadragesima</er>.]</ety> <sn>1.</sn> <def>A space of forty days; -- used of Lent.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Specifically, the term, originally of forty days, during which a ship arriving in port, and suspected of being infected a malignant contagious disease, is obliged to forbear all intercourse with the shore; hence, such restraint or inhibition of intercourse; also, the place where infected or prohibited vessels are stationed.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Quarantine</xex> is now applied also to any forced stoppage of travel or communication on account of malignant contagious disease, on land as well as by sea.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Eng. Law)</fld> <def>The period of forty days during which the widow had the privilege of remaining in the mansion house of which her husband died seized.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quarantine flag</b></col>, <cd>a yellow flag hoisted at the fore of a vessel or hung from a building, to give warning of an infectious disease; -- called also the <altname>yellow jack</altname>, and <altname>yellow flag</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarantine</ent><br/
<hw>Quar`an*tine"</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quarantined</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quarantining</conjf>.]</vmorph> <def>To compel to remain at a distance, or in a given place, without intercourse, when suspected of having contagious disease; to put under, or in, quarantine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarl</ent><br/
<hw>Quarl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. G. <ets>qualle</ets>.]</ety> <fld>(Zool.)</fld> <def>A medusa, or jellyfish.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The jellied <qex>quarl</qex> that flings<br/
At once a thousand streaming stings.</q> <rj><qau>J. R. Drake.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrel</ent><br/
<hw>Quar"rel</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>quarel</ets>, OF. <ets>quarrel</ets>, F. <ets>carreau</ets>, LL. <ets>quadrellus</ets>, from L. <ets>quadrus</ets> square. See <er>Quadrate</er>, and cf. <er>Quadrel</er>, <er>Quarry</er> an arrow, <er>Carrel</er>.]</ety> <sn>1.</sn> <def>An arrow for a crossbow; -- so named because it commonly had a square head.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>To shoot with arrows and <qex>quarrel</qex>.</q> <rj><qau>Sir J. Mandeville.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Two arblasts, . . . with windlaces and <qex>quarrels</qex>.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <def>Any small square or quadrangular member</def>; as: <sd>(a)</sd> <def>A square of glass, esp. when set diagonally.</def> <sd>(b)</sd> <def>A small opening in window tracery, of which the cusps, etc., make the form nearly square.</def> <sd>(c)</sd> <def>A square or lozenge-shaped paving tile.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A glazier's diamond.</def>  <rj><au>Simmonds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A four-sided cutting tool or chisel having a diamond-shaped end.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrel</ent><br/
<hw>Quar"rel</hw>, <pos>n.</pos> <ety>[OE. <ets>querele</ets>, OF. <ets>querele</ets>, F. <ets>querelle</ets>, fr. L. <ets>querela</ets>, <ets>querella</ets>, a complaint, fr. <ets>queri</ets> to complain. See <er>Querulous</er>.]</ety> <sn>1.</sn> <def>A breach of concord, amity, or obligation; a falling out; a difference; a disagreement; an antagonism in opinion, feeling, or conduct; esp., an angry dispute, contest, or strife; a brawl; an altercation; <as>as, he had a <ex>quarrel</ex> with his father about expenses</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will bring a sword upon you that shall avenge the <qex>quarrel</qex> of my covenant.</q> <rj><qau>Lev. xxvi. 25.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>On open seas their <qex>quarrels</qex> they debate.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Ground of objection, dislike, difference, or hostility; cause of dispute or contest; occasion of altercation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Herodias had a <qex>quarrel</qex> against him, and would have killed him.</q> <rj><qau>Mark vi. 19.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>No man hath any <qex>quarrel</qex> to me.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He thought he had a good <qex>quarrel</qex> to attack him.</q> <rj><qau>Holinshed.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Earnest desire or longing.</def> <mark>[Obs.]</mark>  <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To pick a quarrel</b></col>. <cd>See under <er>Pick</er>, <pos>v. t.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Brawl; broil; squabble; affray; feud; tumult; contest; dispute; altercation; contention; wrangle.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrel</ent><br/
<hw>Quar"rel</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quarreled</conjf> <pr>(?)</pr> or <conjf>Quarrelled</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Quarreling</conjf> or <conjf>Quarrelling</conjf>.]</vmorph> <sn>1.</sn> <def>To violate concord or agreement; to have a difference; to fall out; to be or become antagonistic.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our people <qex>quarrel</qex> with obedience.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>But some defect in her<br/
Did <qex>quarrel</qex> with the noblest grace she owed.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To dispute angrily, or violently; to wrangle; to scold; to altercate; to contend; to fight.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Beasts called sociable <qex>quarrel</qex> in hunger and lust.</q> <rj><qau>Sir W. Temple.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To find fault; to cavil; <as>as, to <ex>quarrel</ex> with one's lot</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will not <qex>quarrel</qex> with a slight mistake.</q> <rj><qau>Roscommon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrel</ent><br/
<hw>Quar"rel</hw> <pr>(?)</pr>, <pos>v. t.</pos> <sn>1.</sn> <def>To quarrel with.</def> <mark>[R.]</mark> <ldquo/I had <xex>quarelled</xex> my brother purposely.<rdquo/  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To compel by a quarrel; <as>as, to <ex>quarrel</ex> a man out of his estate or rights</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrel</ent><br/
<hw>Quar"rel</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Written also <ets>quarreller</ets>.]</ety> <def>One who quarrels or wrangles; one who is quarrelsome.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrelet</ent><br/
<hw>Quar"rel*et</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A little quarrel. See 1st <er>Quarrel</er>, 2.</def> <mark>[Obs.]</mark> <ldquo/<xex>Quarrelets</xex> of pearl [teeth].<rdquo/  <rj><au>Herrick.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarreling</ent><br/
<hw>Quar"rel*ing</hw>, <pos>a.</pos> <def>Engaged in a quarrel; apt or disposed to quarrel; <as>as, <ex>quarreling</ex> factions; a <ex>quarreling</ex> mood.</as></def> -- <wordforms><wf>Quar"rel*ing*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrellous</ent><br/
<hw>Quar"rel*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[OF. <ets>querelous</ets>, F. <ets>querelleux</ets>, L. <ets>querulosus</ets> and <ets>querulus</ets>, fr. <ets>queri</ets> to complain. See 2d <er>Quarrel</er>.]</ety> <def>Quarrelsome.</def> <mark>[Obs.]</mark> <altsp>[Written also <asp>quarrellous</asp>.]</altsp>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrelsome</ent><br/
<hw>Quar"rel*some</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Apt or disposed to quarrel; given to brawls and contention; easily irritated or provoked to contest; irascible; choleric.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Pugnacious; irritable; irascible; brawling; choleric; fiery; petulant.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Quar"rel*some*ly</wf>, <pos>adv.</pos> -- <wf>Quar"rel*some*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarried</ent><br/
<hw>Quar"ried</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Provided with prey.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Now I am bravely <qex>quarried</qex>.</q> <rj><qau>Beau. & Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarrier</ent><br/
<hw>Quar"ri*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A worker in a stone quarry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarry</ent><br/
<hw>Quar"ry</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>quarre</ets>, OF. <ets>quarr<eacute/</ets> square, F. <ets>carr<eacute/</ets>, from L. <ets>quadratus</ets> square, quadrate, <ets>quadratum</ets> a square. See <er>Quadrate</er>, and cf. <er>Quarrel</er> an arrow.]</ety> <def>Same as 1st <er>Quarrel</er>.</def> <mark>[Obs.]</mark>  <rj><au>Fairfax.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarry</ent><br/
<hw>Quar"ry</hw>, <pos>a.</pos> <ety>[OF. <ets>quarr<eacute/</ets>.]</ety> <def>Quadrate; square.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarry</ent><br/
<hw>Quar"ry</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quarries</plw> <pr>(#)</pr>.</plu> <ety>[OE. <ets>querre</ets>, OF. <ets>cuiri<eacute/e</ets>, F. <ets>cur<eacute/e</ets>, fr. <ets>cuir</ets> hide, leather, fr. L. <ets>corium</ets>; the <ets>quarry</ets> given to the dogs being wrapped in the akin of the beast. See <er>Cuirass</er>.]</ety> <sn>1.</sn> <sd>(a)</sd> <def>A part of the entrails of the beast taken, given to the hounds.</def> <sd>(b)</sd> <def>A heap of game killed.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The object of the chase; the animal hunted for; game; especially, the game hunted with hawks.</def> <ldquo/The stone-dead <xex>quarry</xex>.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The wily <qex>quarry</qex> shunned the shock.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarry</ent><br/
<hw>Quar"ry</hw>, <pos>v. i.</pos> <def>To secure prey; to prey, as a vulture or harpy.</def>  <rj><au>L'Estrange.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarry</ent><br/
<hw>Quar"ry</hw>, <pos>n.</pos> <ety>[OE. <ets>quarrere</ets>, OF. <ets>quariere</ets>, F. <ets>carri<egrave/re</ets>, LL. <ets>quadraria</ets> a quarry, whence squared (<ets>quadrati</ets>) stones are dug, fr. <ets>quadratus</ets> square. See <er>Quadrate</er>.]</ety> <def>A place, cavern, or pit where stone is taken from the rock or ledge, or dug from the earth, for building or other purposes; a stone pit. See 5th <er>Mine</er> <sd>(a)</sd>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarry</ent><br/
<hw>Quar"ry</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quarried</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quarrying</conjf>.]</vmorph> <def>To dig or take from a quarry; <as>as, to <ex>quarry</ex> marble</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarry-faced</ent><br/
<hw>Quar"ry-faced`</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Stone Masonry)</fld> <def>Having a face left as it comes from the quarry and not smoothed with the chisel or point; -- said of stones.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarry-man</ent><br/
<hw>Quar"ry-man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quarrymen</plw> <pr>(<?/)</pr>.</plu> <def>A man who is engaged in quarrying stones; a quarrier.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quart</ent><br/
<hw>Quart</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quart</ets>, n. masc., fr. L. <ets>quartus</ets> the fourth, akin to <ets>quattuor</ets> four. See <er>Four</er>, and cf. 2d <er>Carte</er>, <er>Quarto</er>.]</ety> <def>The fourth part; a quarter; hence, a region of the earth.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Camber did possess the western <qex>quart</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quart</ent><br/
<hw>Quart</hw>, <pos>n.</pos> <ety>[F. <ets>quarte</ets>, n. fem., fr. <ets>quart</ets> fourth. See <er>Quart</er> a quarter.]</ety> <sn>1.</sn> <def>A measure of capacity, both in dry and in liquid measure; the fourth part of a gallon; the eighth part of a peck; two pints.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In imperial measure, a quart is forty English fluid ounces; in wine measure, it is thirty-two American fluid ounces. The United States dry quart contains 67.20 cubic inches, the fluid quart 57.75. The English quart contains 69.32 cubic inches.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A vessel or measure containing a quart.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quart</ent><br/
<hw>Quart</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Quart</er> a quarter.]</ety> <def>In cards, four successive cards of the same suit.  Cf. <er>Tierce</er>, 4.</def>  <rj><au>Hoyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartan</ent><br/
<hw>Quar"tan</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[F. <ets>quartain</ets>, in <ets>fi<egrave/vre quartaine</ets>, L. <ets>quartanus</ets>, fr. <ets>quartus</ets> the fourth. See <er>Quart</er>.]</ety> <def>Of or pertaining to the fourth; occurring every fourth day, reckoning inclusively; <as>as, a <ex>quartan</ex> ague, or fever</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartan</ent><br/
<hw>Quar"tan</hw>, <pos>n.</pos> <sn>1.</sn> <fld>(Med.)</fld> <def>An intermittent fever which returns every fourth day, reckoning inclusively, that is, one in which the interval between paroxysms is two days.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A measure, the fourth part of some other measure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartane</ent><br/
<hw>Quar"tane</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quartus</ets> the fourth.]</ety> <fld>(Chem.)</fld> <def>Butane, each molecule of which has four carbon atoms.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartation</ent><br/
<hw>Quar*ta"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quartus</ets> the fourth: cf. F. <ets>quartation</ets>. So called because usually enough silver is added to make the amount of gold in the alloyed button about one <ets>fourth</ets>.]</ety> <fld>(Chem. & Assaying)</fld> <def>The act, process, or result (in the <xex>process</xex> of parting) of alloying a button of nearly pure gold with enough silver to reduce the fineness so as to allow acids to attack and remove all metals except the gold; -- called also <altname>inquartation</altname>. Compare <er>Parting</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarte</ent><br/
\'d8<hw>Quarte</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>Same as 2d <er>Carte</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartene</ent><br/
<hw>Quar"tene</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Ouart</ets>ane + ethyl<ets>ene</ets>.]</ety> <fld>(Chem.)</fld> <def>Same as <er>Butylene</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartenylic</ent><br/
<hw>Quar"ten*yl"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quartene</ets> + <ets>-yl</ets> + <ets>-ic</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an acid of the acrylic acid series, metameric with crotonic acid, and obtained as a colorless liquid; -- so called from having four carbon atoms in the molecule. Called also <xex>isocrotonic acid</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarter</ent><br/
<hw>Quar"ter</hw> <pr>(kw<aum/r"t<etil/r)</pr>, <pos>n.</pos> <ety>[F. <ets>quartier</ets>, L. <ets>quartarius</ets> a fourth part, fr. <ets>quartus</ets> the fourth. See <er>Quart</er>.]</ety> <sn>1.</sn> <def>One of four equal parts into which anything is divided, or is regarded as divided; a fourth part or portion; <as>as, a <ex>quarter</ex> of a dollar, of a pound, of a yard, of an hour, etc.</as></def> Hence, specifically: <sd>(a)</sd> <def>The fourth of a hundred-weight, being 25 or 28 pounds, according as the hundredweight is reckoned at 100 or 112 pounds.</def> <sd>(b)</sd> <def>The fourth of a ton in weight, or eight bushels of grain; <as>as, a <ex>quarter</ex> of wheat</as>; also, the fourth part of a chaldron of coal.</def> <au>Hutton.</au> <sd>(c)</sd> <fld>(Astron.)</fld> <def>The fourth part of the moon's period, or monthly revolution; <as>as, the first <ex>quarter</ex> after the change or full</as>.</def> <sd>(d)</sd> <def>One limb of a quadruped with the adjacent parts; one fourth part of the carcass of a slaughtered animal, including a leg; <as>as, the fore <ex>quarters</ex>; the hind <ex>quarters</ex></as>.</def> <sd>(e)</sd> <def>That part of a boot or shoe which forms the side, from the heel to the vamp.</def> <sd>(f)</sd> <fld>(Far.)</fld> <def>That part on either side of a horse's hoof between the toe and heel, being the side of the coffin.</def> <sd>(g)</sd> <def>A term of study in a seminary, college, etc, etc.; properly, a fourth part of the year, but often longer or shorter.</def> <sd>(h)</sd> <pluf>pl.</pluf> <fld>(Mil.)</fld> <def>The encampment on one of the principal passages round a place besieged, to prevent relief and intercept convoys.</def> <sd>(i)</sd> <fld>(Naut.)</fld> <def>The after-part of a vessel's side, generally corresponding in extent with the quarter-deck; also, the part of the yardarm outside of the slings.</def> <sd>(j)</sd> <fld>(Her.)</fld> <def>One of the divisions of an escutcheon when it is divided into four portions by a horizontal and a perpendicular line meeting in the fess point.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ When two coats of arms are united upon one escutcheon, as in case of marriage, the first and fourth quarters display one shield, the second and third the other. See <er>Quarter</er>, <pos>v. t.</pos>, 5.</note><br/
[<source>1913 Webster</source>]</p>

<p><sd>(k)</sd> One of the four parts into which the horizon is regarded as divided; a cardinal point; a direction' principal division; a region; a territory.<br/
[<source>1913 Webster</source>]</p>

<p><q>Scouts each coast light-armed scour,<br/
Each <qex>quarter</qex>, to descry the distant foe.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(l)</sd> <def>A division of a town, city, or county; a particular district; a locality; <as>as, the Latin <ex>quarter</ex> in Paris</as>.</def> <sd>(m)</sd> <fld>(Arch.)</fld> <def>A small upright timber post, used in partitions; -- in the United States more commonly called <altname>stud</altname>.</def> <sd>(n)</sd> <fld>(Naut.)</fld> <def>The fourth part of the distance from one point of the compass to another, being the fourth part of 11<deg/ 15<prime/, that is, about 2<deg/ 49<prime/; -- called also <altname>quarter point</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- (o) One fourth of a dollar, i. e. twenty five cents.  Also, the twenty-five cent piece.  Also called a quarter dollar, and two bits --><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Proper station; specific place; assigned position; special location.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Swift to their several <qex>quarters</qex> hasted then<br/
The cumbrous elements.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p>Hence, specifically: <sd>(a)</sd> <fld>(Naut.)</fld> <def>A station at which officers and men are posted in battle; -- usually in the plural.</def> <sd>(b)</sd> <def>Place of lodging or temporary residence; shelter; entertainment; -- usually in the plural.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The banter turned as to what <qex>quarters</qex> each would find.</q> <rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(c)</sd> <pluf>pl.</pluf> <fld>(Mil.)</fld> <def>A station or encampment occupied by troops; a place of lodging for soldiers or officers; <as>as, winter <ex>quarters</ex></as>.</def> <sd>(d)</sd> <def>Treatment shown by an enemy; mercy; especially, the act of sparing the life a conquered enemy; a refraining from pushing one's advantage to extremes.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He magnified his own clemency, now they were at his mercy, to offer them <qex>quarter</qex> for their lives.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Cocks and lambs . . . at the mercy of cats and wolves . . . must never expect better <qex>quarter</qex>.</q> <rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Friendship; amity; concord.</def> <mark>[Obs.]</mark> <xex>To keep quarter</xex>, to keep one's proper place, and so be on good terms with another. <mark>[Obs.]</mark>
<-- ## abnormal format. Shold be a collocataion. --><br/
[<source>1913 Webster</source>]</p>

<p><q>In <qex>quarter</qex>, and in terms like bride and groom.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I knew two that were competitors for the secretary's place, . . . and yet <qex>kept</qex> good <qex>quarter</qex> between themselves.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>False quarter</b></col>, <cd>a cleft in the quarter of a horse's foot.</cd> -- <col><b>Fifth quarter</b></col>, <cd>the hide and fat; -- a butcher's term.</cd> -- <col><b>On the quarter</b></col> <fld>(Naut.)</fld>, <cd>in a direction between abeam and astern; opposite, or nearly opposite, a vessel's quarter.</cd> -- <col><b>Quarter aspect</b></col>. <fld>(Astrol.)</fld> <cd>Same as <er>Quadrate</er>.</cd> -- <col><b>Quarter back</b></col> <fld>(Football)</fld>, <cd>the player who has position next behind center rush, and receives the ball on the snap back.</cd> -- <col><b>Quarter badge</b></col> <fld>(Naut.)</fld>, <cd>an ornament on the side of a vessel near, the stern.</cd> <au>Mar. Dict.</au> -- <col><b>Quarter bill</b></col> <fld>(Naut.)</fld>, <cd>a list specifying the different stations to be taken by the officers and crew in time of action, and the names of the men assigned to each.</cd> -- <col><b>Quarter block</b></col> <fld>(Naut.)</fld>, <cd>a block fitted under the quarters of a yard on each side of the slings, through which the clew lines and sheets are reeved.</cd> <au>R. H. Dana, Jr.</au> -- <col><b>Quarter boat</b></col> <fld>(Naut.)</fld>, <cd>a boat hung at a vessel's quarter.</cd> -- <col><b>Quarter cloths</b></col> <fld>(Naut.)</fld>, <cd>long pieces of painted canvas, used to cover the quarter netting.</cd> -- <col><b>Quarter day</b></col>, <cd>a day regarded as terminating a quarter of the year; hence, one on which any payment, especially rent, becomes due. In matters influenced by United States statutes, quarter days are the first days of January, April, July, and October. In New York and many other places, as between landlord and tenant, they are the first days of May, August, November, and February. The quarter days usually recognized in England are 25th of March (Lady Day), the 24th of June (Midsummer Day), the 29th of September (Michaelmas Day), and the 25th of December (Christmas Day).</cd> -- <col><b>Quarter face</b></col>, <cd>in fine arts, portrait painting, etc., a face turned away so that but one quarter is visible.</cd> -- <col><b>Quarter gallery</b></col> <fld>(Naut.)</fld>, <cd>a balcony on the quarter of a ship. See <er>Gallery</er>, 4.</cd> -- <col><b>Quarter gunner</b></col> <fld>(Naut.)</fld>, <cd>a petty officer who assists the gunner.</cd> -- <col><b>Quarter look</b></col>, <cd>a side glance.</cd> <mark>[Obs.]</mark> <au>B. Jonson.</au> -- <col><b>Quarter nettings</b></col> <fld>(Naut.)</fld>, <cd>hammock nettings along the quarter rails.</cd> -- <col><b>Quarter note</b></col> <fld>(Mus.)</fld>, <cd>a note equal in duration to half a minim or a fourth of semibreve; a crochet.</cd> -- <col><b>Quarter pieces</b></col> <fld>(Naut.)</fld>, <cd>several pieces of timber at the after-part of the quarter gallery, near the taffrail.</cd> <au>Totten.</au> -- <col><b>Quarter point</b></col>. <fld>(Naut.)</fld> <cd>See <er>Quarter</er>, <pos>n.</pos>, 1 <sd>(n)</sd>.</cd> -- <mcol><col><b>Quarter railing</b></col>, <it>or</it> <col><b>Quarter rails</b></col></mcol> <fld>(Naut.)</fld>, <cd>narrow molded planks reaching from the top of the stern to the gangway, serving as a fence to the quarter-deck.</cd> -- <col><b>Quarter sessions</b></col> <fld>(Eng. Law)</fld>, <cd>a general court of criminal jurisdiction held quarterly by the justices of peace in counties and by the recorders in boroughs.</cd> -- <col><b>Quarter square</b></col> <fld>(Math.)</fld>, <cd>the fourth part of the square of a number. Tables of quarter squares have been devised to save labor in multiplying numbers.</cd> -- <mcol><col><b>Quarter turn</b></col>, <col><b>Quarter turn belt</b></col></mcol> <fld>(Mach.)</fld>, <cd>an arrangement in which a belt transmits motion between two shafts which are at right angles with each other.</cd> -- <col><b>Quarter watch</b></col> <fld>(Naut.)</fld>, <cd>a subdivision of the full watch (one fourth of the crew) on a man-of- war.</cd> -- <mcol><col><b>To give quarter</b></col>, <it>or</it> <col><b>To show quarter</b></col></mcol> <fld>(Mil.)</fld>, <cd>to accept as prisoner, on submission in battle; to forbear to kill, as a vanquished enemy.</cd> -- <col><b>To keep quarter</b></col>. <cd>See <er>Quarter</er>, <pos>n.</pos>, 3.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarter</ent><br/
<hw>Quar"ter</hw> <pr>(kw<aum/r"t<etil/r)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quartered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quartering</conjf>.]</vmorph> <sn>1.</sn> <def>To divide into four equal parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1175 --></p>

<p><sn>2.</sn> <def>To divide; to separate into parts or regions.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Then sailors <qex>quartered</qex> heaven.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To furnish with shelter or entertainment; to supply with the means of living for a time; especially, to furnish shelter to; <as>as, to <ex>quarter</ex> soldiers</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They mean this night in Sardis to be <qex>quartered</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To furnish as a portion; to allot.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>This isle . . . <br/
He <qex>quarters</qex> to his blue-haired deities.</q> <rj><qau> Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Her.)</fld> <def>To arrange (different coats of arms) upon one escutcheon, as when a man inherits from both father and mother the right to bear arms.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ When only two coats of arms are so combined they are arranged in four compartments. See <er>Quarter</er>, <pos>n.</pos>, 1 <sd>(f)</sd>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarter</ent><br/
<hw>Quar"ter</hw> <pr>(kw<aum/r"t<etil/r)</pr>, <pos>v. i.</pos> <def>To lodge; to have a temporary residence.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarter</ent><br/
<hw>Quar"ter</hw>, <pos>v. i.</pos> <ety>[F. <ets>cartayer</ets>.]</ety> <def>To drive a carriage so as to prevent the wheels from going into the ruts, or so that a rut shall be between the wheels.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Every creature that met us would rely on us for <qex>quartering</qex>.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarterage</ent><br/
<hw>Quar"ter*age</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A quarterly allowance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>quarterback</ent><br/
<hw>quarterback</hw> <pos>n.</pos> <fld>(Football)</fld>  <def>The player on a football tream who chooses the offensive play and receives the ball from the center at the start of each down.  Compare <contr>halfback</contr> and <contr>fullback</contr>.</def><br/
[<source>PJC</source>]</p>

<p><ent>quarterback</ent><br/
<hw>quarterback</hw> <pos>v. i.</pos> <fld>(Football)</fld>  <def>To play the position of quarterback, in a football game.</def><br/
<syn><b>Syn. --</b> play the quarterback, be the quarterback.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>quarterback sneak</ent><br/
<hw>quarterback sneak</hw> <pos>n.</pos> <fld>(Football)</fld>  <def>A play in football in which the quarterback carries the ball directly ahead, immediately or shortly after receiving the snap, sometimes after faking a handoff.</def><br/
[<source>PJC</source>]</p>

<p><ent>Quarter-deck</ent><br/
<hw>Quar"ter-deck`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> <def>That part of the upper deck abaft the mainmast, including the poop deck when there is one.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The quarter-deck is reserved as a promenade for the officers and (in passenger vessels) for the cabin passengers.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartered</ent><br/
<hw>Quar"tered</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Divided into four equal parts or quarters; separated into four parts or regions.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>Furnished with quarters; provided with shelter or entertainment.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>Quarter-sawed; -- said of timber, commonly oak.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quarterfoil</ent><br/
<hw>Quar"ter*foil`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quarier</ets> + <ets>foil</ets>: cf. F. <ets>quatre</ets>.]</ety> <fld>(Arch.)</fld> <def>An ornamental foliation having four lobes, or foils.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarterhung</ent><br/
<hw>Quar"ter*hung`</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Ordnance)</fld> <def>Having trunnions the axes of which lie below the bore; -- said of a cannon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartering</ent><br/
<hw>Quar"ter*ing</hw>, <pos>a.</pos> <sn>1.</sn> <fld>(Naut.)</fld> <def>Coming from a point well abaft the beam, but not directly astern; -- said of waves or any moving object.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mach.)</fld> <def>At right angles, as the cranks of a locomotive, which are in planes forming a right angle with each other.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartering</ent><br/
<hw>Quar"ter*ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>A station.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Montagu.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Assignment of quarters for soldiers; quarters.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Her.)</fld> <sd>(a)</sd> <def>The division of a shield containing different coats of arms into four or more compartments.</def> <sd>(b)</sd> <def>One of the different coats of arms arranged upon an escutcheon, denoting the descent of the bearer.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Arch.)</fld> <def>A series of quarters, or small upright posts. See <er>Quarter</er>, <pos>n.</pos>, 1 <sd>(m)</sd> <fld>(Arch.)</fld></def>  <rj><au>Gwilt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quartering block</b></col>, <cd>a block on which the body of a condemned criminal was quartered.</cd>  <rj><au>Macaulay.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarterly</ent><br/
<hw>Quar"ter*ly</hw>, <pos>a.</pos> <sn>1.</sn> <def>Containing, or consisting of, a fourth part; <as>as, <ex>quarterly</ex> seasons</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Recurring during, or at the end of, each quarter; <as>as, <ex>quarterly</ex> payments of rent; a <ex>quarterly</ex> meeting.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarterly</ent><br/
<hw>Quar"ter*ly</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quarterlies</plw> <pr>(<?/)</pr>.</plu> <def>A periodical work published once a quarter, or four times in a year.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarterly</ent><br/
<hw>Quar"ter*ly</hw>, <pos>adv.</pos> <sn>1.</sn> <def>By quarters; once in a quarter of a year; <as>as, the returns are made <ex>quarterly</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Her.)</fld> <def>In quarters, or quarterings; <as>as, to bear arms <ex>quarterly</ex></as>; in four or more parts; -- said of a shield thus divided by lines drawn through it at right angles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartermaster</ent><br/
<hw>Quar"ter*mas`ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quarter</ets> + <ets>master</ets>: cf. F. <ets>quartier-ma<icir/tre</ets>.]</ety> <sn>1.</sn> <fld>(Mil.)</fld> <def>An officer whose duty is to provide quarters, provisions, storage, clothing, fuel, stationery, and transportation for a regiment or other body of troops, and superintend the supplies.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>A petty officer who attends to the helm, binnacle, signals, and the like, under the direction of the master.</def>  <rj><au>Totten.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quartermaster general</b></col> <fld>(Mil.)</fld>, <cd>in the United States a staff officer, who has the rank of brigadier general and is the chief officer in the quartermaster's department; in England, an officer of high rank stationed at the War Office having similar duties; also, a staff officer, usually a general officer, accompanying each complete army in the field.</cd> -- <col><b>Quartermaster sergeant</b></col>. <cd>See <er>Sergeant</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartern</ent><br/
<hw>Quar"tern</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>quarteroun</ets>, <ets>quartron</ets>, F. <ets>quarteron</ets>, the fourth part of a pound, or of a hundred; cf. L. <ets>quartarius</ets> a fourth part, quarter of any measure, quartern, gill. See <er>Quarter</er>, and cf. <er>Quarteron</er>, <er>Quadroon</er>.]</ety> <sn>1.</sn> <def>A quarter. Specifically: <sd>(a)</sd> The fourth part of a pint; a gill. <sd>(b)</sd> The fourth part of a peck, or of a stone (14 ibs.).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A loaf of bread weighing about four pounds; -- called also <altname>quartern loaf</altname>.</def>  <rj><au>Simmonds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarteron</ent><br/
<hw>Quar"ter*on</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Quartern</er>.]</ety> <def>A quarter; esp., a quarter of a pound, or a quarter of a hundred.</def>  <rj><au>Piers Plowman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarteroon</ent><br/
<ent>Quarteron</ent><br/
<mhw>{ <hw>Quar"ter*on</hw> <pr>(?)</pr>, <hw>Quar"ter*oon</hw> <pr>(?)</pr> }</mhw>, <pos>n.</pos> <def>A quadroon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarterpace</ent><br/
<hw>Quar"ter*pace`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Arch.)</fld> <def>A platform of a staircase where the stair turns at a right angle only. See <er>Halfpace</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarter round</ent><br/
<hw>Quar"ter round`</hw> <pr>(?)</pr>. <fld>(Arch.)</fld> <def>An ovolo.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarter-saw</ent><br/
<hw>Quar"ter-saw`</hw> <pr>(?)</pr>, <pos>v. t.</pos>  <ety>[<pos>imp. & p. p.</pos> <er>Quarter-sawed</er>  <er>-sawn</er>; <pos>p. pr. & vb. n.</pos> <er>Quarter-sawing</er>.]</ety> <def>To saw (a log) into quarters; specif., to saw into quarters and then into boards, as by cutting alternately from each face of a quarter, to secure lumber that will warp relatively little or show the grain advantageously.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quarterstaff</ent><br/
<hw>Quar"ter*staff`</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quarterstaves</plw> <pr>(<?/)</pr>.</plu> <def>A long and stout staff formerly used as a weapon of defense and offense; -- so called because in holding it one hand was placed in the middle, and the other between the middle and the end.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartette</ent><br/
<ent>Quartet</ent><br/
<mhw>{ <hw>Quar*tet"</hw>, <hw>Quar*tette"</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. <ets>quartetto</ets>, dim. of quarto the fourth, a fourth part, fr. L. <ets>quartus</ets> the fourth. See <er>Quart</er>.]</ety> <sn>1.</sn> <fld>(Mus.)</fld> <sd>(a)</sd> <def>A composition in four parts, each performed by a single voice or instrument.</def> <sd>(b)</sd> <def>The set of four person who perform a piece of music in four parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Poet.)</fld> <def>A stanza of four lines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartic</ent><br/
<hw>Quar"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quartus</ets> fourth.]</ety> <fld>(Mach.)</fld> <def>Of the fourth degree.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartic</ent><br/
<hw>Quar"tic</hw> <pr>(?)</pr>, <pos>n.</pos> <sd>(a)</sd> <fld>(Alg.)</fld> <def>A quantic of the fourth degree. See <er>Quantic</er>.</def> <sd>(b)</sd> <fld>(Geom.)</fld> <def>A curve or surface whose equation is of the fourth degree in the variables.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartile</ent><br/
<hw>Quar"tile</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quartile aspect</ets>, fr. L. <ets>quartus</ets> the fourth. See <er>Quart</er>.]</ety> <fld>(Astrol.)</fld> <def>Same as <er>Quadrate</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartine</ent><br/
<hw>Quar"tine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>quartus</ets> the fourth.]</ety> <fld>(Bot.)</fld> <def>A supposed fourth integument of an ovule, counting from the outside.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarto</ent><br/
<hw>Quar"to</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>in quarto</ets> in fourth, from <ets>quartus</ets> the fourth: cf. F. (<ets>in</ets>) <ets>quarto</ets>. See <er>Quart</er>.]</ety> <def>Having four leaves to the sheet; of the form or size of a quarto.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quarto</ent><br/
<hw>Quar"to</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quartos</plw> <pr>(<?/)</pr>.</plu> <def>Originally, a book of the size of the fourth of sheet of printing paper; a size leaves; in present usage, a book of a square or nearly square form, and usually of large size.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartridge</ent><br/
<hw>Quar"tridge</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Quarterage.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartz</ent><br/
<hw>Quartz</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G. <ets>quarz</ets>.]</ety> <fld>(Min.)</fld> <def>A form of silica, or silicon dioxide (<chform>SiO2</chform>), occurring in hexagonal crystals, which are commonly colorless and transparent, but sometimes also yellow, brown, purple, green, and of other colors; also in cryptocrystalline massive forms varying in color and degree of transparency, being sometimes opaque.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The crystalline varieties include: <xex>amethyst</xex>, <xex>violet</xex>; <xex>citrine</xex> and <xex>false topaz</xex>, pale yellow; <xex>rock crystal</xex>, transparent and colorless or nearly so; <xex>rose quartz</xex>, rosecolored; <xex>smoky quartz</xex>, smoky brown. The chief crypto-crystalline varieties are: <xex>agate</xex>, a chalcedony in layers or clouded with different colors, including the <xex>onyx</xex> and <xex>sardonyx</xex>; <xex>carnelian</xex> and <xex>sard</xex>, red or flesh-colored chalcedony; <xex>chalcedony</xex>, nearly white, and waxy in luster; <xex>chrysoprase</xex>, an apple-green chalcedony; <xex>flint</xex>, <xex>hornstone</xex>, <xex>basanite</xex>, or <xex>touchstone</xex>, brown to black in color and compact in texture; <xex>heliotrope</xex>, green dotted with red; <xex>jasper</xex>, opaque, red yellow, or brown, colored by iron or ferruginous clay; <xex>prase</xex>, translucent and dull leek-green. Quartz is an essential constituent of granite, and abounds in rocks of all ages. It forms the rocks quartzite (<xex>quartz rock</xex>) and sandstone, and makes most of the sand of the seashore.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartziferous</ent><br/
<hw>Quartz*if"er*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quartz</ets> + <ets>-ferous</ets>.]</ety> <fld>(Min.)</fld> <def>Consisting chiefly of quartz; containing quartz.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartzite</ent><br/
<hw>Quartz"ite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>quartzite</ets>.]</ety> <fld>(Min.)</fld> <def>Massive quartz occurring as a rock; a metamorphosed sandstone; -- called also <altname>quartz rock</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartzoid</ent><br/
<hw>Quartz"oid</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quartz</ets> + <ets>-oid</ets>.]</ety> <fld>(Crystallog.)</fld> <def>A form of crystal common with quartz, consisting of two six-sided pyramids, base to base.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartzose</ent><br/
<hw>Quartz"ose`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Cf. F. <ets>quartzeux</ets>, G. <ets>quarzig</ets>.]</ety> <fld>(Min.)</fld> <def>Containing, or resembling, quartz; partaking of the nature or qualities of quartz.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>quartzous</ent><br/
<hw>quartz"ous</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Min.)</fld> <def>Quarzose.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quartzy</ent><br/
<hw>Quartz"y</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Min.)</fld> <def>Quartzose.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quas</ent><br/
<hw>Quas</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A kind of beer. Same as <er>Quass</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quasje</ent><br/
<ent>Quaschi</ent><br/
<mhw>{ <hw>Quas"chi</hw> <pr>(?)</pr>, <hw>Quas"je</hw> <pr>(?)</pr> }</mhw>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The brown coati. See <er>Coati</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quash</ent><br/
<hw>Quash</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Squash</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quash</ent><br/
<hw>Quash</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quashed</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quashing</conjf>.]</vmorph> <ety>[OF. <ets>quasser</ets>, F. <ets>casser</ets>, fr. L. <ets>cassare</ets> to annihilate, annul, fr. <ets>cassus</ets> empty, vain, of uncertain origin. The word has been confused with L. <ets>quassare</ets> to shake, F. <ets>casser</ets> to break, which is probably of different origin.  Cf. <er>Cashier</er>, <pos>v. t.</pos>]</ety> <fld>(Law)</fld> <def>To abate, annul, overthrow, or make void; <as>as, to <ex>quash</ex> an indictment</as>.</def>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quash</ent><br/
<hw>Quash</hw>, <pos>v. t.</pos> <ety>[OF. <ets>quasser</ets>, F. <ets>casser</ets>, fr. L. <ets>quassare</ets> to shake, shatter, shiver, v. intens. fr. <ets>quatere</ets>, <ets>quassum</ets>, to shake, shatter.  Cf. <er>Concussion</er>, <er>Discuss</er>, <er>Rescue</er>, and also <er>Quash</er> to annul.]</ety> <sn>1.</sn> <def>To beat down, or beat in pieces; to dash forcibly; to crush.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The whales<br/
Against sharp rocks, like reeling vessels, <qex>quashed</qex>,<br/
Though huge as mountains, are in pieces dashed.</q> <rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To crush; to subdue; to suppress or extinguish summarily and completely; <as>as, to <ex>quash</ex> a rebellion</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Contrition is apt to <qex>quash</qex> or allay all worldly grief.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quash</ent><br/
<hw>Quash</hw>, <pos>v. i.</pos> <def>To be shaken, or dashed about, with noise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quashee</ent><br/
<hw>Quash"ee</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A negro of the West Indies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quasi</ent><br/
<hw>Qua"si</hw> <pr>(?)</pr>. <ety>[L.]</ety> <def>As if; as though; as it were; in a manner sense or degree; having some resemblance to; qualified; -- used as an adjective, or a prefix with a noun or an adjective; <as>as, a <ex>quasi</ex> contract, an implied contract, an obligation which has arisen from some act, as if from a contract; a <ex>quasi</ex> corporation, a body that has some, but not all, of the peculiar attributes of a corporation; a <ex>quasi</ex> argument, that which resembles, or is used as, an argument; <ex>quasi</ex> historical, apparently historical, seeming to be historical</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quasi corporation</ent><br/
<hw>Qua"si cor`po*ra"tion</hw>. <def>A corporation consisting of a person or body of persons invested with some of the qualities of an artificial person, though not expressly incorporated, esp. the official of certain municipal divisions such as counties, schools districts, and the towns of some States of the United States, certain church officials, as a churchwarden, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quasimodo</ent><br/
<hw>Quas`i*mo"do</hw> <pr>(kw<acr/s`<icr/*m<omac/"d<osl/)</pr>, <pos>n.</pos> <ety>[So called from the first words of the Latin introit, <ets>quasi modo geniti infantes</ets> as newborn babes, <au>1 Pet. ii. 2.</au>]</ety> <fld>(R. C. Ch.)</fld> <def>The first Sunday after Easter; Low Sunday.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quasimodo</ent><br/
<hw>Quas`i*mo"do</hw> <pr>(kw<adot/z`<esl/*m<omac/"d<osl/)</pr>, <pos>prop. n.</pos>  <fld>(Fiction)</fld> <def>The main character in Victor Hugo's novel <ldquo/The Hunchback of Notre Dame<rdquo/.   The novel was first published in French under the title <ldqo/Notre Dame de Paris<rdquo/.  Quasimodo is a deformed and ugly hunchback who is bellringer at the cathedral of Notre Dame during the reign of Louis XI.  He rescues a gypsy girl Esmeralda, falsely convicted of a crime and about to be excuted, and carries her to sanctuary in the cathedral.  Near the end of the book he dies while again rescuing her from an abductor.  In a movie made in 1923 Quasimodo was portrayed by the actor Lon Chaney, whose impressive makeup and superb acting drew many plaudits.  His shout of <ldquo/Sanctuary!  Sanctuary!<rdquo/ when rescuing Esmeralda is still sometimes imitated for humorous or dramatic effect.</def><br/
[<source>PJC</source>]</p>

<p><ent>Quass</ent><br/
<hw>Quass</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Russ. <ets>kvas'</ets>.]</ety> <def>A thin, sour beer, made by pouring warm water on rye or barley meal and letting it ferment, -- much used by the Russians.  Called also <altname>kvass</altname>.</def> <altsp>[written also <asp>kvass</asp> and <asp>quas</asp>.]</altsp><br/
[<source>1913 Webster</source> + <source>PJC</source>]</p>

<p><ent>Quassation</ent><br/
<hw>Quas*sa"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quassatio</ets>, from <ets>quassare</ets> to shake. See <er>Quash</er> to crush.]</ety> <def>The act of shaking, or the state of being shaken.</def>  <rj><au>Gayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quassia</ent><br/
<hw>Quas"si*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. From the name of a negro, <ets>Quassy</ets>, or <ets>Quash</ets>, who prescribed this article as a specific.]</ety> <def>The wood of several tropical American trees of the order <ord>Simarube<ae/</ord>, as <spn>Quassia amara</spn>, <spn>Picr<ae/na excelsa</spn>, and <spn>Simaruba amara</spn>. It is intensely bitter, and is used in medicine and sometimes as a substitute for hops in making beer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quassin</ent><br/
<hw>Quas"sin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>quassine</ets>. See <er>Quassia</er>.]</ety> <fld>(Chem.)</fld> <def>The bitter principle of quassia, extracted as a white crystalline substance; -- formerly called <altname>quassite</altname>.</def> <altsp>[Written also <asp>quass<imac/in</asp>, and <asp>quassine</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quat</ent><br/
<hw>Quat</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety> <sd>(a)</sd> <def>A pustule.</def> <mark>[Obs.]</mark> <sd>(b)</sd> <def>An annoying, worthless person.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quat</ent><br/
<hw>Quat</hw>, <pos>v. t.</pos> <def>To satiate; to satisfy.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quata</ent><br/
<hw>Qua"ta</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The coaita.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quatch</ent><br/
<hw>Quatch</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Squat; flat.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quater-cousin</ent><br/
<hw>Qua"ter-cous`in</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quatre</ets> four + <ets>cousin</ets>, E. <ets>cousin</ets>.]</ety> <def>A cousin within the first four degrees of kindred.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaternary</ent><br/
<hw>Qua*ter"na*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quaternarius</ets> consisting of four each, containing four, fr. <ets>quaterni</ets> four each, fr. <ets>quattuor</ets> four: cf. F. <ets>quaternaire</ets>. See <er>Four</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Consisting of four; by fours, or in sets of four.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>Later than, or subsequent to, the Tertiary; Post-tertiary; <as>as, the <ex>Quaternary</ex> age, or Age of man</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaternary</ent><br/
<hw>Qua*ter"na*ry</hw>, <pos>n.</pos> <ety>[L. numerus <ets>quaternarius</ets>: cf. F. <ets>quaternaire</ets>.]</ety> <sn>1.</sn> <def>The number four.</def>  <rj><au>Boyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>The Quaternary age, era, or formation. See the <xex>Chart</xex> of <er>Geology</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaternate</ent><br/
<hw>Qua*ter"nate</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Composed of, or arranged in, sets of four; quaternary; <as>as, <ex>quaternate</ex> leaves</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaternion</ent><br/
<hw>Qua*ter"ni*on</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quaternio</ets>, fr. <ets>quaterni</ets> four each. See <er>Quaternary</er>.]</ety> <sn>1.</sn> <def>The number four.</def> <mark>[Poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A set of four parts, things, or person; four things taken collectively; a group of four words, phrases, circumstances, facts, or the like.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Delivered him to four <qex>quaternions</qex> of soldiers.</q> <rj><qau>Acts xii. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Ye elements, the eldest birth<br/
 Of Nature's womb, that in <qex>quaternion</qex> run.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The triads and <qex>quaternions</qex> with which he loaded his sentences.</q> <rj><qau> Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A word of four syllables; a quadrisyllable.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Math.)</fld> <def>The quotient of two vectors, or of two directed right lines in space, considered as depending on four geometrical elements, and as expressible by an algebraic symbol of quadrinomial form.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The science or calculus of <xex>quaternions</xex> is a new mathematical method, in which the conception of a <xex>quaternion</xex> is unfolded and symbolically expressed, and is applied to various classes of algebraical, geometrical, and physical questions, so as to discover theorems, and to arrive at the solution of problems.</note>  <rj><au>Sir W. R. Hamilton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaternion</ent><br/
<hw>Qua*ter"ni*on</hw>, <pos>v. t.</pos> <def>To divide into quaternions, files, or companies.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaternity</ent><br/
<hw>Qua*ter"ni*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL. <ets>quaternitas</ets>, fr. L. <ets>quaterni</ets> four each: cf. F. <ets>quaternit<eacute/</ets>.]</ety> <sn>1.</sn> <def>The number four.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The union of four in one, as of four persons; -- analogous to the theological term <xex>trinity</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quateron</ent><br/
<hw>Qua"ter*on</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See 2d <er>Quarteron</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quatorzain</ent><br/
<hw>Qua*torz"ain</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Quatorze</er>.]</ety> <def>A poem of fourteen lines; a sonnet.</def>  <rj><au>R. H. Stoddard.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quatorze</ent><br/
<hw>Qua*torze"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quatorze</ets> fourteen, L. <ets>quattuordecim</ets>. See <er>Fourteen</er>.]</ety> <def>The four aces, kings, queens, knaves, or tens, in the game of piquet; -- so called because <xex>quatorze</xex> counts as fourteen points.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quatrain</ent><br/
<hw>Quat"rain</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. <ets>quatre</ets> four, L. <ets>quattuor</ets>, <ets>quatuor</ets>. See <er>Four</er>.]</ety> <fld>(Pros.)</fld> <def>A stanza of four lines rhyming alternately.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quatre</ent><br/
<hw>Qua"tre</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A card, die. or domino, having four spots, or pips</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quatrefoil</ent><br/
<ent>Quatrefeuille</ent><br/
<mhw>{ <hw>Qua"tre*feuille</hw> <pr>(?)</pr>, <hw>Qua"tre*foil</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[F. <ets>quatre feuilles</ets>.]</ety> <def>Same as <er>Quarterfoil</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quattrocento</ent><br/
\'d8<hw>Quat`tro*cen"to</hw> <pr>(?)</pr>, <pos>n. & a.</pos> <ety>[It., four hundred, used as an abbreviated expression for the dates beginning with fourteen hundred.]</ety> <def>The fifteenth century, when applied to Italian art or literature; <as>as, the sculpture of the <ex>quattrocento</ex>; <ex>quattrocento</ex> style</as>.</def> -- <wordforms><wf>Quat`tro*cen"tist</wf> <pr>(#)</pr>, <pos>n.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quatuor</ent><br/
<hw>Quat"u*or</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>quattuor</ets>, <ets>quatuor</ets>, four. See <er>Quartet</er>.]</ety> <fld>(Mus.)</fld> <def>A quartet; -- applied chiefly to instrumental compositions.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quave</ent><br/
<hw>Quave</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Quaver</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quave</ent><br/
<hw>Quave</hw>, <pos>v. i.</pos> <def>To quaver.</def> <mark>[Obs. or Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quavemire</ent><br/
<hw>Quave"mire`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Quagmire</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaver</ent><br/
<hw>Qua"ver</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quavered</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quavering</conjf>.]</vmorph> <ety>[OE. <ets>quaven</ets> to shake, to tremble; cf. LG. <ets>quabbeln</ets> to shake, to be soft, of fat substances, <ets>quabbe</ets> a fat lump of flesh, a dewlap, D. <ets>kwabbe</ets>, and E. <ets>quiver</ets>, v.]</ety> <sn>1.</sn> <def>To tremble; to vibrate; to shake.</def>  <rj><au>Sir I. Newton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Especially, to shake the voice; to utter or form sound with rapid or tremulous vibrations, as in singing; also, to trill on a musical instrument</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaver</ent><br/
<hw>Qua"ver</hw>, <pos>v. t.</pos> <def>To utter with quavers.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We shall hear her <qex>quavering</qex> them . . . to some sprightly airs of the opera.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaver</ent><br/
<hw>Qua"ver</hw>, <pos>n.</pos> <sn>1.</sn> <def>A shake, or rapid and tremulous vibration, of the voice, or of an instrument of music.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>An eighth note. See <er>Eighth</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quaverer</ent><br/
<hw>Qua"ver*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who quavers; a warbler.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quay</ent><br/
<hw>Quay</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quai</ets>. See <er>Key</er> quay.]</ety> <def>A mole, bank, or wharf, formed toward the sea, or at the side of a harbor, river, or other navigable water, for convenience in loading and unloading vessels.</def> <altsp>[Written also <asp>key</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quay</ent><br/
<hw>Quay</hw> <pr>(?)</pr>, <pos>v. t.</pos> <def>To furnish with quays.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quayage</ent><br/
<hw>Quay"age</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>Wharfage.</def> <altsp>[Also <asp>keyage</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quayd</ent><br/
<hw>Quayd</hw> <pr>(?)</pr>, <def><pos>p. p.</pos> of <er>Quail</er>.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>qubit</ent><br/
<hw>qu"bit</hw> <pr>(k<umac/"b<icr/t)</pr>, <fld>(Information theory)</fld>  <ety>[Shortened from <ets>qu</ets>antum <ets>bit</ets>.]</ety>  <def>A measure of information, being the information that can be stored in one object that can take a quantum state of 0 or 1.  It differs from the classical <er>bit</er> of information theory in that quantum states may assume many intermediate states that are superpositions of the individual discrete states; the quantum states of multiple quantum systems may also be correlated by a phenomenon called <i>entanglement</i>, increasing the complexity of the information storage and retrieval process.  See 4th <er>bit</er>, <pos>n.</pos></def> <au>Michael A. Nielsen, <ldqo/Rules for a Complex Quantum World</rdquo/, Scientific American,  Nov. 2002, pp. 67-75.</au><br/
[<source>PJC</source>]</p>

<p><ent>Que</ent><br/
<hw>Que</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. 3d <er>Cue</er>.]</ety> <def>A half farthing.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queach</ent><br/
<hw>Queach</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Quick</er>.]</ety> <def>A thick, bushy plot; a thicket.</def> <mark>[Obs.]</mark>  <rj><au>Chapman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queach</ent><br/
<hw>Queach</hw>, <pos>v. i.</pos> <ety>[Cf. E. <ets>quich</ets>, v. i., <ets>quick</ets>, v. i.; or AS. <ets>cweccan</ets> to shake.]</ety> <def>To stir; to move. See <er>Quick</er>, <pos>v. i.</pos></def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queachy</ent><br/
<hw>Queach"y</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Yielding or trembling under the feet, as moist or boggy ground; shaking; moving.</def> <ldquo/The <xex>queachy</xex> fens.<rdquo/ <ldquo/Godwin's <xex>queachy</xex> sands.<rdquo/  <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p>
<sn>2.</sn> <def>Like a queach; thick; bushy.</def> <mark>[Obs.]</mark>  <rj><au>Cockeram.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quean</ent><br/
<hw>Quean</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Originally, a woman, AS. <ets>cwene</ets>; akin to OS. <ets>quena</ets>, OHG. <ets>quena</ets>, Icel. <ets>kona</ets>, Goth <ets>qin<?/</ets>, and AS. <ets>cw<eacute/n</ets>, also to Gr. <?/ woman, wife, Skr. <ets>gn<amac/</ets> goddess.  Cf. <er>Queen</er>.]</ety> <sn>1.</sn> <def>A woman; a young or unmarried woman; a girl.</def> <mark>[Obs. or Scot.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A low woman; a wench; a slut.</def> <ldquo/The dread of every scolding <xex>quean</xex>.<rdquo/  <rj><au>Gay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queasily</ent><br/
<hw>Quea"si*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a queasy manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queasiness</ent><br/
<hw>Quea"si*ness</hw>, <pos>n.</pos> <def>The state of being queasy; nausea; qualmishness; squeamishness.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1176 --></p>

<p><ent>Queasy</ent><br/
<hw>Quea"sy</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Icel. <ets>kweisa</ets> pain; cf. Norw. <ets>kveis</ets> sickness after a debauch.]</ety> <sn>1.</sn> <def>Sick at the stomach; affected with nausea; inclined to vomit; qualmish.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fastidious; squeamish; delicate; easily disturbed; unsettled; ticklish.</def> <ldquo/ A <xex>queasy</xex> question.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Some seek, when <qex>queasy</qex> conscience has its qualms.</q> <rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quebec group</ent><br/
<hw>Que*bec" group`</hw> <pr>(?)</pr>. <fld>(Geol.)</fld> <def>The middle of the three groups into which the rocks of the Canadian period have been divided in the American Lower Silurian system. See the <xex>Chart</xex> of <er>Geology</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quebracho</ent><br/
\'d8<hw>Que*bra"cho</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp.]</ety> <fld>(Bot.)</fld> <def>A Chilian apocynaceous tree (<spn>Aspidosperma Quebracho</spn>); also, its bark, which is used as a febrifuge, and for dyspn<oe/a of the lung, or bronchial diseases; -- called also <altname>white quebracho</altname>, to distinguish it from the <xex>red quebracho</xex>, a Mexican anacardiaceous tree (<spn>Loxopterygium Lorentzii</spn>) whose bark is said to have similar properties.</def>  <rj><au>J. Smith (Dict. Econ. Plants).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quebrith</ent><br/
<hw>Queb"rith</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>quebrit</ets>, <ets>quibrith</ets>, Ar. <ets>kibr<imac/t</ets>.]</ety> <fld>(Alchemy)</fld> <def>Sulphur.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queck</ent><br/
<ent>Quech</ent><br/
<mhw>{ <hw>Quech</hw> <pr>(?)</pr>, <hw>Queck</hw> <pr>(?)</pr>, }</mhw> <pos>v. i.</pos> <ety>[Cf. <er>Quick</er>, <er>Queach</er>.]</ety> <def>A word occurring in a corrupt passage of Bacon's Essays, and probably meaning, to stir, to move.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queen</ent><br/
<hw>Queen</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>quen</ets>, <ets>quene</ets>, queen, quean, AS. <ets>cw<emac/n</ets> wife, queen, woman; akin to OS. <ets>qu<amac/n</ets> wife, woman, Icel. <ets>kv<amac/n</ets> wife, queen, Goth. <ets>q<emac/ns</ets>. <root/221. See <er>Quean</er>.]</ety> <sn>1.</sn> <def>The wife of a king.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A woman who is the sovereign of a kingdom; a female monarch; <as>as, Elizabeth, <ex>queen</ex> of England; Mary, <ex>queen</ex> of Scots.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>In faith, and by the heaven's <qex>quene</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A woman eminent in power or attractions; the highest of her kind; <as>as, a <ex>queen</ex> in society; -- also used figuratively of cities, countries, etc.</as></def> <ldquo/ This <xex>queen</xex> of cities.<rdquo/  <ldquo/ Albion, <xex>queen</xex> of isles.<rdquo/  <rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The fertile, or fully developed, female of social bees, ants, and termites.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Chess)</fld> <def>The most powerful, and except the king the most important, piece in a set of chessmen.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A playing card bearing the picture of a queen; <as>as, the <ex>queen</ex> of spades</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- 7. <def>A male homosexual, esp. one who is effeminate or dresses in women's clothing.</def> <mark>Sometimes pejorative.</mark> --><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Queen apple</b></col>. <ety>[Cf. OE. <ets>quyne aple</ets> quince apple.]</ety> <cd>A kind of apple; a queening.</cd> <ldquo/<xex>Queen apples</xex> and red cherries.<rdquo/ <au>Spenser.</au> -- <col><b>Queen bee</b></col> <fld>(Zool.)</fld>, <cd>a female bee, especially the female of the honeybee. See <er>Honeybee</er>.</cd><-- the fully developed female in a colony of bees, ants, or termites which lays eggs.  Usually there is only one in a colony; the queen is often somewhat larger than other bees, and is specially fed to develop her egg-laying capacity. (b) (Fig.) A woman who feels and acts as though she is of special importance.  Usu. pejorative. --> -- <col><b>Queen conch</b></col> <fld>(Zool.)</fld>, <cd>a very large West Indian cameo conch (<spn>Cassis cameo</spn>). It is much used for making cameos.</cd> -- <col><b>Queen consort</b></col>, <cd>the wife of a reigning king.</cd> <au>Blackstone.</au> -- <col><b>Queen dowager</b></col>, <cd>the widow of a king.</cd> -- <col><b>Queen gold</b></col>, <cd>formerly a revenue of the queen consort of England, arising from gifts, fines, etc.</cd> -- <col><b>Queen mother</b></col>, <cd>a queen dowager who is also mother of the reigning king or queen.</cd> -- <col><b>Queen of May</b></col>. <cd>See <cref>May queen</cref>, under <er>May</er>.</cd> -- <col><b>Queen of the meadow</b></col> <fld>(Bot.)</fld>, <cd>a European herbaceous plant (<spn>Spir<ae/a Ulmaria</spn>). See <er>Meadowsweet</er>.</cd> -- <col><b>Queen of the prairie</b></col> <fld>(Bot.)</fld>, <cd>an American herb (<spn>Spir<ae/a lobata</spn>) with ample clusters of pale pink flowers.</cd> -- <col><b>Queen pigeon</b></col> <fld>(Zool.)</fld>, <cd>any one of several species of very large and handsome crested ground pigeons of the genus <gen>Goura</gen>, native of New Guinea and the adjacent islands. They are mostly pale blue, or ash-blue, marked with white, and have a large occipital crest of spatulate feathers. Called also <altname>crowned pigeon</altname>, <altname>goura</altname>, and <altname>Victoria pigeon</altname>.</cd> -- <mcol><col><b>Queen regent</b></col>, <it>or</it> <col><b>Queen regnant</b></col></mcol>, <cd>a queen reigning in her own right.</cd> -- <col><b>Queen's Bench</b></col>. <cd>See <er>King's Bench</er>.</cd> -- <mcol><col><b>Queen's counsel</b></col>, <col><b>Queen's evidence</b></col></mcol>. <cd>See <cref>King's counsel</cref>, <cref>King's evidence</cref>, under <er>King</er>.</cd> -- <col><b>Queen's delight</b></col> <fld>(Bot.)</fld>, <cd>an American plant (<spn>Stillinqia sylvatica</spn>) of the Spurge family, having an herbaceous stem and a perennial woody root.</cd> -- <col><b>Queen's metal</b></col> <fld>(Metal.)</fld>, <cd>an alloy somewhat resembling pewter or britannia, and consisting essentially of tin with a slight admixture of antimony, bismuth, and lead or copper.</cd> -- <col><b>Queen's pigeon</b></col>. <fld>(Zool.)</fld> <cd>Same as <cref>Queen pigeon</cref>, above.</cd> -- <col><b>Queen's ware</b></col>, <cd>glazed English earthenware of a cream color.</cd> -- <col><b>Queen's yellow</b></col> <fld>(Old Chem.)</fld>, <cd>a heavy yellow powder consisting of a basic mercuric sulphate; -- formerly called <altname>turpetum minerale</altname>, or <altname>Turbith's mineral</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queen</ent><br/
<hw>Queen</hw>, <pos>v. i.</pos> <def>To act the part of a queen.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queen</ent><br/
<hw>Queen</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Queened</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Queening</conjf>.]</vmorph> <fld>(Chess.)</fld> <def>To make a queen (or other piece, at the player's discretion) of by moving it to the eighth row; <as>as, to <ex>queen</ex> a pawn</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queencraft</ent><br/
<hw>Queen"craft`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Craft or skill in policy on the part of a queen.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Elizabeth showed much <qex>queencraft</qex> in procuring the votes of the nobility.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queendom</ent><br/
<hw>Queen"dom</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The dominion, condition, or character of a queen.</def> <rj><au>Mrs. Browning.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queenfish</ent><br/
<hw>Queen"fish`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A California sci<ae/noid food fish (<spn>Seriphys politus</spn>). The back is bluish, and the sides and belly bright silvery. Called also <altname>kingfish</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queenhood</ent><br/
<hw>Queen"hood</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state, personality, or character of a queen; queenliness.</def>  <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queening</ent><br/
<hw>Queen"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Queen apple</er>.]</ety> <fld>(Bot.)</fld> <def>Any one of several kinds of apples, as <stype>summer queening</stype>, <stype>scarlet queening</stype>, and <stype>early queening</stype>. An apple called the <ex>queening</ex> was cultivated in England two hundred years ago.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queenliness</ent><br/
<hw>Queen"li*ness</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The quality of being queenly; the; characteristic of a queen; stateliness; eminence among women in attractions or power.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queenly</ent><br/
<hw>Queen"ly</hw>, <pos>a.</pos> <ety>[AS. <ets>cw<emac/nlic</ets> feminine.]</ety> <def>Like, becoming, or suitable to, a queen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queen olive</ent><br/
<hw>Queen olive</hw>. <ety>[Cf. Sp. <ets>aceituna de la Reina</ets> olive of the Queen.]</ety> <fld>(Olive Trade)</fld> <def>Properly, a kind of superior olive grown in the region of Seville, Spain. It is large size and oblong shape with a small but long pit; it is cured when green, keeps well, and has a delicate flavor. Loosely, any olive of similar character.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Queen-post</ent><br/
<hw>Queen"-post`</hw> <pr>(?)</pr>, <pos>n.</pos> <mark>[Arch.]</mark> <def>One of two suspending posts in a roof truss, or other framed truss of similar form. See <er>King-post</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queenship</ent><br/
<hw>Queen"ship</hw>, <pos>n.</pos> <def>The state, rank, or dignity of a queen.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queensland nut</ent><br/
<hw>Queens"land nut`</hw> <pr>(?)</pr>. <fld>(Bot.)</fld> <def>The nut of an Australian tree (<spn>Macadamia ternifolia</spn>). It is about an inch in diameter, and contains a single round edible seed, or sometimes two hemispherical seeds. So called from <xex>Queensland</xex> in Australia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queen truss</ent><br/
<hw>Queen" truss</hw> <pr>(?)</pr>. <fld>(Arch.)</fld> <def>A truss framed with queen-posts; a queen-post truss.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queer</ent><br/
<hw>Queer</hw> <pr>(kw<emac/r)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Queerer</adjf> <pr>(kw<emac/r"<etil/r)</pr>; <pos>superl.</pos> <adjf>Queerest</adjf>.]</amorph> <ety>[G. <ets>quer</ets> cross, oblique, athwart (cf. <ets>querkopf</ets> a queer fellow), <er>OHG</er>. <ets>twer</ets>, <ets>twerh</ets>, <ets>dwerah</ets>; akin to D. <ets>dvars</ets>, AS, <ets><thorn/weorh</ets> thwart, bent, twisted, Icel. <ets><thorn/verr</ets> thwart, transverse, Goth. <ets><thorn/wa<igrave/rhs</ets> angry, and perh. to L. <ets>torqyere</ets> to twist, and E. <ets>through</ets>.  Cf. <er>Torture</er>, <er>Through</er>, <er>Thwart</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>At variance with what is usual or normal; differing in some odd way from what is ordinary; odd; singular; strange; whimsical; <as>as, a <ex>queer</ex> story or act</as>.</def> <ldquo/ A <xex>queer</xex> look.<rdquo/  <rj><au>W. Irving.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Mysterious; suspicious; questionable; <as>as, a <ex>queer</ex> transaction</as>.</def>
<mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>homosexual.</def> <mark>[disparaging and offensive]</mark><br/
[<source>PJC</source>]</p>

<p><ent>Queer</ent><br/
<hw>Queer</hw>, <pos>n.</pos> <sn>1.</sn> <def>Counterfeit money.</def> <mark>[Slang]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>a homosexual.</def> <mark>[disparaging and offensive]</mark><br/
[<source>PJC</source>]</p>

<p><cs><col><b>To shove the queer</b></col>, <cd>to put counterfeit money in circulation.</cd> <mark>[Slang]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queer</ent><br/
<hw>Queer</hw> <pr>(kw<emac/r)</pr>, <pos>v. t.</pos> <ety>[From <er>Queer</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>To puzzle.</def> <mark>[Prov. Eng. or Slang]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <def>To ridicule; to banter; to rally.</def> <mark>[Slang]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <def>To spoil the effect or success of, as by ridicule; to throw a wet blanket on; to spoil.</def> <mark>[Slang]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Queerish</ent><br/
<hw>Queer"ish</hw>, <pos>a.</pos> <def>Rather queer; somewhat singular.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queerly</ent><br/
<hw>Queer"ly</hw>, <pos>adv.</pos> <def>In a queer or odd manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queerness</ent><br/
<hw>Queer"ness</hw>, <pos>n.</pos> <def>The quality or state of being queer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queest</ent><br/
<hw>Queest</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Icel. <ets>kvisa</ets> a kind of bird, <ets>kvistr</ets> a branch of a tree, and E. <ets>cushat</ets>.]</ety> <fld>(Zool.)</fld> <def>The European ringdove (<spn>Columba palumbus</spn>); the cushat.</def> <altsp>[Written also <asp>quist</asp>, <asp>queeze</asp>, <asp>quice</asp>, <asp>queece</asp>.]</altsp> See <er>Ringdove</er>.<br/
[<source>1913 Webster</source>]</p>

<p><ent>Quegh</ent><br/
<hw>Quegh</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A drinking vessel. See <er>Quaich</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queint</ent><br/
<hw>Queint</hw> <pr>(?)</pr>, <pos>a.</pos> <def>See <er>Quaint</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queint</ent><br/
<hw>Queint</hw>, <mark>obs.</mark> <def><pos>imp. & p. p.</pos> of <er>Quench</er>.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queintise</ent><br/
<hw>Queint"ise</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Quaintise</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quell</ent><br/
<hw>Quell</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quelled</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quelling</conjf>.]</vmorph> <ety>[See <er>Quail</er> to cower.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To die.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Yet he did quake and quaver, like to <qex>quell</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be subdued or abated; to yield; to abate.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Winter's wrath begins to <qex>quell</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quell</ent><br/
<hw>Quell</hw>, <pos>v. t.</pos> <ety>[OE. <ets>quellen</ets> to kill, AS. <ets>cwellan</ets>, causative of <ets>cwelan</ets> to die; akin to OHG. <ets>quellen</ets> to torment, Icel. <ets>kvelja</ets>. See <er>Quail</er> to cower.]</ety> <sn>1.</sn> <def>To take the life of; to kill.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The ducks cried as [if] men would them <qex>quelle</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To overpower; to subdue; to put down.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The nation obeyed the call, rallied round the sovereign, and enabled him to <qex>quell</qex> the disaffected minority.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Northward marching to <qex>quell</qex> the sudden revolt.</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To quiet; to allay; to pacify; to cause to yield or cease; <as>as, to <ex>quell</ex> grief; to <ex>quell</ex> the tumult of the soul.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Much did his words the gentle lady <qex>quell</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- to subdue; crush; overpower; reduce; put down; repress; suppress; quiet; allay; calm; pacify.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quell</ent><br/
<hw>Quell</hw>, <pos>n.</pos> <def>Murder.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queller</ent><br/
<hw>Quell"er</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A killer; <as>as, Jack the Giant <ex>Queller</ex></as>.</def> <mark>[Obs.]</mark>  <rj><au>Wyclif (Mark vi. 27).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who quells; one who overpowers or subdues.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quellio</ent><br/
<hw>Quel"li*o</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>cuello</ets>, L. <ets>collum</ets> neck.]</ety> <def>A ruff for the neck.</def> <mark>[Obs.]</mark>  <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quelquechose</ent><br/
\'d8<hw>Quelque"chose`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quelque chose</ets> something.]</ety> <def>A trifle; a kickshaw.</def>  <rj><au>Donne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queme</ent><br/
<hw>Queme</hw> <pr>(?)</pr>, <pos>v. t. & i.</pos> <ety>[AS. <ets>cw<emac/man</ets>, akin to <ets>cuman</ets> to come. <root/23.]</ety> <def>To please.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quemeful</ent><br/
<hw>Queme"ful</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Kindly; merciful.</def> <mark>[Obs.]</mark>  <rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quench</ent><br/
<hw>Quench</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quenched</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quenching</conjf>.]</vmorph> <ety>[OE. <ets>quenchen</ets>, AS. <ets>cwencan</ets> in <ets><amac/cwencan</ets>, to extinguish utterly, causative of <ets>cwincan</ets>, <ets><amac/cwincan</ets>, to decrease, disappear; cf. AS. <ets>cw<imac/nan</ets>, <ets><amac/cw<imac/nan</ets>, to waste or dwindle away.]</ety> <sn>1.</sn> <def>To extinguish; to overwhelm; to make an end of; -- said of flame and fire, of things burning, and figuratively of sensations and emotions; <as>as, to <ex>quench</ex> flame; to <ex>quench</ex> a candle; to <ex>quench</ex> thirst, love, hate, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ere our blood shall <qex>quench</qex> that fire.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The supposition of the lady's death<br/
Will <qex>quench</qex> the wonder of her infamy.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cool suddenly, as heated steel, in tempering.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To extinguish; still; stifle; allay; cool; check.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quench</ent><br/
<hw>Quench</hw>, <pos>v. i.</pos> <def>To become extinguished; to go out; to become calm or cool.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Dost thou think in time<br/
She will not <qex>quench</qex>!</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quenchable</ent><br/
<hw>Quench"a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Capable of being quenched.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quencher</ent><br/
<hw>Quench"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that which, quenches.</def>  <rj><au>Hammond.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quenchless</ent><br/
<hw>Quench"less</hw>, <pos>a.</pos> <def>Incapable of being quenched; inextinguishable; <as>as, <ex>quenchless</ex> fire or fury</as>.</def> <ldquo/Once kindled, <xex>quenchless</xex> evermore.<rdquo/  <rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Inextinguishable; unquenchable.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Quench"less*ly</wf>, <pos>adv.</pos> -- <wf>Quench"less*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quenelle</ent><br/
<hw>Que*nelle"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <fld>(Cookery)</fld> <def>A kind of delicate forcemeat, commonly poached and used as a dish by itself or for garnishing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quenouille training</ent><br/
<hw>Que*nouille train"ing</hw> <pr>(?)</pr>. <ety>[F. <ets>quenouille</ets> distaff.]</ety> <fld>(Hort.)</fld> <def>A method of training trees or shrubs in the shape of a cone or distaff by tying down the branches and pruning.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quercitannic</ent><br/
<hw>Quer`ci*tan"nic</hw> <pr>(kw<etil/r`s<icr/*t<acr/n"n<icr/k)</pr>, <pos>a.</pos> <ety>[L. <ets>quercus</ets> an oak + E. <ets>tannic</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, a tannic acid found in oak bark and extracted as a yellowish brown amorphous substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quercite</ent><br/
<hw>Quer"cite</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A white crystalline substance, <chform>C6H7(OH)5</chform>, found in acorns, the fruit of the oak (<gen>Quercus</gen>).  It has a sweet taste, and is regarded as a pentacid alcohol.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quercitin</ent><br/
<hw>Quer"ci*tin</hw> <pr>(kw<etil/r"s<icr/*t<icr/n)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A yellow crystalline substance, occurring quite widely distributed in the vegetable kingdom, as in apple-tree bark, horse-chestnut leaves, etc., but originally obtained by the decomposition of quercitrin. Called also <altname>meletin</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quercitrin</ent><br/
<hw>Quer"cit*rin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>quercitrin</ets>. See <er>Quercitron</er>.]</ety> <fld>(Chem.)</fld> <def>A glucoside extracted from the bark of the oak (<gen>Quercus</gen>) as a bitter citron-yellow crystalline substance, used as a pigment and called <altname>quercitron</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quercitron</ent><br/
<hw>Quer"cit*ron</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quercitron</ets>, the name of the name of tree; L. <ets>quercus</ets> an oak + <ets>citrus</ets> the citron <ets>tree</ets>.]</ety> <sn>1.</sn> <def>The yellow inner bark of the <spn>Quercus tinctoria</spn>, the American black oak, yellow oak, dyer's oak, or quercitron oak, a large forest tree growing from Maine to eastern Texas.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Quercitrin, used as a pigment. See <er>Quercitrin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quercus</ent><br/
\'d8<hw>Quer"cus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., an oak.]</ety> <fld>(Bot.)</fld> <def>A genus of trees constituted by the oak. See <er>Oak</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querele</ent><br/
<hw>Quer"ele</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See 2d <er>Quarrel</er>.]</ety> <fld>(O. Eng. Law)</fld> <def>A complaint to a court. See <er>Audita Querela</er>.</def> <mark>[Obs.]</mark>  <rj><au>Ayliffe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querent</ent><br/
<hw>Que"rent</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>querens</ets>, p. pr. of <ets>queri</ets> to complain.]</ety> <fld>(O. Eng. Law)</fld> <def>A complainant; a plaintiff.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querent</ent><br/
<hw>Que"rent</hw>, <pos>n.</pos> <ety>[L. <ets>quaerens</ets>, p. pr. of <ets>quaerere</ets> to search for, to inquire.]</ety> <def>An inquirer.</def> <mark>[Obs.]</mark>  <rj><au>Aubrey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querimonious</ent><br/
<hw>Quer`i*mo"ni*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>querimonia</ets> a complaint, fr. <ets>queri</ets> to complain. See <er>Querulous</er>.]</ety> <def>Complaining; querulous; apt to complain.</def> -- <wordforms><wf>Quer`i*mo"ni*ous*ly</wf>, <pos>adv.</pos> -- <wf>Quer`i*mo"ni*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querimony</ent><br/
<hw>Quer"i*mo*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>querimonia</ets>.]</ety> <def>A complaint or complaining.</def> <mark>[Obs.]</mark>  <rj><au>E. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querist</ent><br/
<hw>Que"rist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Query</er>.]</ety> <def>One who inquires, or asks questions.</def>  <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querken</ent><br/
<hw>Querk"en</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[Icel. <ets>kverk</ets> throat. <?/.]</ety> <def>To stifle or choke.</def> <mark>[Prov. Eng.]</mark>  <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querl</ent><br/
<hw>Querl</hw> <pr>(?)</pr>, <pos>v. t.</pos> <ety>[G. <ets>querlen</ets>, <ets>quirlen</ets>, to twirl, to turn round, fr. <ets>querl</ets>, <ets>querl</ets>, a twirling stick.  Cf. <er>Twirl</er>.]</ety> <def>To twirl; to turn or wind round; to coil; <as>as, to <ex>querl</ex> a cord, thread, or rope</as>.</def> <mark>[Local, U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querl</ent><br/
<hw>Querl</hw>, <pos>n.</pos> <def>A coil; a twirl; <as>as, the <ex>qwerl</ex> of hair on the fore leg of a blooded horse</as>.</def> <mark>[Local, U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quern</ent><br/
<hw>Quern</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[AS. <ets>cweorn</ets>, <ets>cwyrn</ets>; akin to D. <ets>kweern</ets>, OHG. <ets>quirn</ets>, Icel. <ets>kvern</ets>, Sw. <ets>qvarn</ets>, Dan. <ets>qu<ae/rn</ets>, Goth. <ets>qairnus</ets> (in <ets>asiluqa<iacute/rnus</ets>), Lith. <ets>q<igrave/rnos</ets>, and perh. E. <ets>corn</ets>.]</ety> <def>A mill for grinding grain, the upper stone of which was turned by hand; -- used before the invention of windmills and watermills.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They made him at the <qex>querne</qex> grind.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querpo</ent><br/
<hw>Quer"po</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The inner or body garments taken together. See <er>Cuerpo</er>.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querquedule</ent><br/
<hw>Quer"que*dule</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>querquedula</ets>.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd> <def>A teal.</def> <sd>(b)</sd> <def>The pintail duck.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querry</ent><br/
<hw>Quer"ry</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A groom; an equerry.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querulential</ent><br/
<hw>Quer`u*len"tial</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Querulous.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Querulous</ent><br/
<hw>Quer"u*lous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>querulus</ets> and <ets>querulosus</ets>, fr. <ets>queri</ets> to complain.  Cf. <er>Cry</er>, <pos>v.</pos>, <er>Quarrel</er> a brawl, <er>Quarrelous</er>.]</ety> <sn>1.</sn> <def>Given to quarreling; quarrelsome.</def> <mark>[Obs.]</mark>  <rj><au>land.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Apt to find fault; habitually complaining; disposed to murmur; <as>as, a <ex>querulous</ex> man or people</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Enmity can hardly be more annoying that <qex>querulous</qex>, jealous, exacting fondness.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Expressing complaint; fretful; whining; <as>as, a <ex>querulous</ex> tone of voice</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Complaining; bewailing; lamenting; whining; mourning; murmuring; discontented; dissatisfied.</syn><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Quer"u*lous*ly</wf>, <pos>adv.</pos> -- <wf>Quer"u*lous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Query</ent><br/
<hw>Que"ry</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Queries</plw> <pr>(#)</pr>.</plu> <ety>[L. <ets>quaere</ets>, imperative sing. of <ets>quaerere</ets>, <ets>quaesitum</ets> to seek or search for, to ask, inquire.  Cf. <er>Acquire</er>, <er>Conquer</er>, <er>Exquisite</er>, <er>Quest</er>, <er>Require</er>.]</ety> <sn>1.</sn> <def>A question; an inquiry to be answered or solved.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I shall conclude with proposing only some <qex>queries</qex>, in order to a . . . search to be made by others.</q> <rj><qau>Sir I. Newton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A question in the mind; a doubt; <as>as, I have a <ex>query</ex> about his sincerity</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An interrogation point [?] as the sign of a question or a doubt.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Query</ent><br/
<hw>Que"ry</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To ask questions; to make inquiry.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Each prompt to <qex>query</qex>, answer, and debate.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To have a doubt; <as>as, I <ex>query</ex> if he is right</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Query</ent><br/
<hw>Que"ry</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Queried</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Querying</conjf>.]</vmorph> <sn>1.</sn> <def>To put questions about; to elicit by questioning; to inquire into; <as>as, to <ex>query</ex> the items or the amount; to <ex>query</ex> the motive or the fact.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To address questions to; to examine by questions.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To doubt of; to regard with incredulity.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To write <ldquo/ query<rdquo/ (qu., qy., or ?) against, as a doubtful spelling, or sense, in a proof. See <er>Qu<ae/re</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quesal</ent><br/
<hw>Que*sal"</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The long-tailed, or resplendent, trogon (<spn>Pharomachus mocinno</spn>, formerly <spn>Trogon resplendens</spn>), native of Southern Mexico and Central America. Called also <altname>quetzal</altname>, and <altname>golden trogon</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The male is remarkable for the brilliant metallic green and gold colors of his plumage, and for his extremely long plumes, which often exceed three feet in length.</note><-- The feathers were valued as part of the dress of Inca kings. Now usu. called quetzal. --><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1177 --></p>

<p><ent>Quest</ent><br/
<hw>Quest</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>queste</ets>, F. <ets>qu<ecir/te</ets>, fr. L. <ets>quaerere</ets>, <ets>quaesitum</ets>, to seek for, to ask.  Cf. <er>Query</er>, <er>Question</er>.]</ety> <sn>1.</sn> <def>The act of seeking, or looking after anything; attempt to find or obtain; search; pursuit; <as>as, to rove in <ex>quest</ex> of game, of a lost child, of property, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Upon an hard adventure yet in <qex>quest</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Cease your <qex>quest</qex> of love.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>There ended was his <qex>quest</qex>, there ceased his care.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Request; desire; solicitation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Gad not abroad at every <qex>quest</qex> and call<br/
Of an untrained hope or passion.</q> <rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Those who make search or inquiry, taken collectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The senate hath sent about three several <qex>quests</qex> to search you out.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Inquest; jury of inquest.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What lawful <qex>quest</qex> have given their verdict ?</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quest</ent><br/
<hw>Quest</hw>, <pos>v. t.</pos> <ety>[Cf. OF. <ets>quester</ets>, F. <ets>qu<ecir/ter</ets>. See <er>Quest</er>, <pos>n.</pos>]</ety> <def>To search for; to examine.</def> <mark>[R.]</mark>  <rj><au>Sir T. Herbert.  </au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quest</ent><br/
<hw>Quest</hw>, <pos>v. i.</pos> <def>To go on a quest; to make a search; to go in pursuit; to beg.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>If his <qex>questing</qex> had been unsuccessful, he appeased the rage of hunger with some scraps of broken meat.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questant</ent><br/
<hw>Quest"ant</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF. <ets>questant</ets>, F. <ets>qu<ecir/tant</ets>, p. pr.]</ety> <def>One who undertakes a quest; a seeker.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quester</ent><br/
<hw>Quest"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who seeks; a seeker.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Question</ent><br/
<hw>Ques"tion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>quaestio</ets>, fr. <ets>quaerere</ets>, <ets>quaesitum</ets>, to seek for, ask, inquire. See <er>Quest</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>The act of asking; interrogation; inquiry; <as>as, to examine by <ex>question</ex> and answer</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Discussion; debate; hence, objection; dispute; doubt; <as>as, the story is true beyond <ex>question</ex>; he obeyed without <ex>question</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>There arose a <qex>question</qex> between some of John's disciples and the Jews about purifying.</q> <rj><qau> John iii. 25.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It is to be to <qex>question</qex>, whether it be lawful for Christian princes to make an invasive war simply for the propagation of the faith.</q> <rj><qau> Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Examination with reference to a decisive result; investigation; specifically, a judicial or official investigation; also, examination under torture.</def>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He that was in <qex>question</qex> for the robbery. <qex>Shak</qex>.<br/
The Scottish privy council had power to put state prisoners to the <qex>question</qex>.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>That which is asked; inquiry; interrogatory; query.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But this <qex>question</qex> asked<br/
Puts me in doubt. Lives there who loves his pain ?</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Hence, a subject of investigation, examination, or debate; theme of inquiry; matter to be inquired into; <as>as, a delicate or doubtful <ex>question</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Talk; conversation; speech; speech.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>In question</b></col>, <cd>in debate; in the course of examination or discussion; as, the matter or point <xex>in question</xex>.</cd> -- <col><b>Leading question</b></col>. <cd>See under <er>Leading</er>.</cd> -- <col><b>Out of question</b></col>, <cd>unquestionably.</cd> <ldquo/<xex>Out of question</xex>, 't is Maria's hand.<rdquo/ <au>Shak.</au> -- <col><b>Out of the question</b></col>. <cd>See under <er>Out</er>.</cd> -- <col><b>Past question</b></col>, <cd>beyond question; certainly; undoubtedly; unquestionably.</cd> -- <col><b>Previous question</b></col>, <cd>a question put to a parliamentary assembly upon the motion of a member, in order to ascertain whether it is the will of the body to vote at once, without further debate, on the subject under consideration.</cd> <note>The form of the question is: <ldquo/Shall the main question be now put?<rdquo/ If the vote is in the affirmative, the matter before the body must be voted upon as it then stands, without further general debate or the submission of new amendments. In the House of Representatives of the United States, and generally in America, a negative decision operates to keep the business before the body as if the motion had not been made; but in the English Parliament, it operates to postpone consideration for the day, and until the subject may be again introduced. In American practice, the object of the motion is to hasten action, and it is made by a friend of the measure. In English practice, the object is to get rid of the subject for the time being, and the motion is made with a purpose of voting against it. <au>Cushing.</au></note> -- <col><b>To beg the question</b></col>. <cd>See under <er>Beg</er>.</cd> -- <col><b>To the question</b></col>, <cd>to the point in dispute; to the real matter under debate.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Point; topic; subject.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Question</ent><br/
<hw>Ques"tion</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Questioned</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Questioning</conjf>.]</vmorph> <ety>[Cf. F. <ets>questionner</ets>. See <er>Question</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To ask questions; to inquire.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He that <qex>questioneth</qex> much shall learn much.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To argue; to converse; to dispute.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I pray you, think you <qex>question</qex> with the Jew.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Question</ent><br/
<hw>Ques"tion</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To inquire of by asking questions; to examine by interrogatories; <as>as, to <ex>question</ex> a witness</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To doubt of; to be uncertain of; to query.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And most we <qex>question</qex> what we most desire.</q> <rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To raise a question about; to call in question; to make objection to.</def> <ldquo/But have power and right to <xex>question</xex> thy bold entrance on this place.<rdquo/  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To talk to; to converse with.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>With many holiday and lady terms he <qex>questioned</qex> me.</q> <rj><qau> Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To ask; interrogate; catechise; doubt; controvert; dispute.</syn> <usage> -- Question, Inquire, Interrogate. To <xex>inquire</xex> is merely to ask for information, and implies no authority in the one who asks. To <xex>interrogate</xex> is to put repeated questions in a formal or systematic fashion to elicit some particular fact or facts. To <xex>question</xex> has a wider sense than to <xex>interrogate</xex>, and often implies an attitude of distrust or opposition on the part of the questioner.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questionability</ent><br/
<hw>Ques`tion*a*bil"i*ty</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The state or condition of being questionable.</def>  <rj><au>Stallo.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questionable</ent><br/
<hw>Ques"tion*a*ble</hw> <pr>(?)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Admitting of being questioned; inviting, or seeming to invite, inquiry.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou com'st in such a <qex>questionable</qex> shape<br/
That I will speak to thee.</q> <rj><qau> Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Liable to question; subject to be doubted or called in question; problematical; doubtful; suspicious.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It is <qex>questionable</qex> whether Galen ever saw the dissection of a human body.<qex>T</qex>.</q> <rj><qau> Baker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Disputable; debatable; uncertain; doubtful; problematical; suspicious.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questionableness</ent><br/
<hw>Ques"tion*a*ble*ness</hw>, <pos>n.</pos> <def>The quality or state of being questionable, doubtful, or suspicious.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questionably</ent><br/
<hw>Ques"tion*a*bly</hw>, <pos>adv.</pos> <def>In a questionable manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questionary</ent><br/
<hw>Ques"tion*a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Inquiring; asking questions; testing.</def> <ldquo/<xex>Questionary</xex> epistles.<rdquo/  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questionary</ent><br/
<hw>Ques"tion*a*ry</hw>, <pos>n.</pos> <sn>1.</sn> <def>One who makes it his business to seek after relics and carry them about for sale.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A set of questions for submission to a group of persons for the purpose of bringing out their resemblances and differences in the matter considered. The <xex>questionary method</xex> is a recognized form of psychological investigation.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Questioner</ent><br/
<hw>Ques"tion*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who asks questions; an inquirer.</def> <ldquo/Little time for idle <xex>questioners</xex>.<rdquo/  <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questionist</ent><br/
<hw>Ques"tion*ist</hw>, <pos>n.</pos> <sn>1.</sn> <def>A questioner; an inquirer.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eng. Univ.)</fld> <def>A candidate for honors or degrees who is near the time of his examination.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questionless</ent><br/
<hw>Ques"tion*less</hw>, <pos>a.</pos> <def>Unquestioning; incurious.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>questionless</ent><br/
<hw>ques"tion*less</hw>, <pos>adv.</pos> <def>Beyond a question or doubt; doubtless; certainly.</def> <mark>[R.]</mark>  <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>What it was in the apostles' time, that, <qex>questionless</qex>, it must be still.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>questionnaire</ent><br/
<hw>ques`tion`naire"</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl. <plw>-naires</plw> <pr>(F. <?/)</pr>.</plu> <ety>[F.]</ety> <sn>1.</sn> <def>same as <er>Questionary</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>A list of questions, usually on a printed form, to be answered by an individual.  The forms often have blank spaces in which the answers can be written.  Sets of such forms are distributed to groups and the answers used for various purposes, such as to obtain statistical information for social science, political, or marketing research, or to obtain information about a patient for the use of medical practitioners.</def><br/
[<source>PJC</source>]</p>

<p><ent>Questman</ent><br/
<hw>Quest"man</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Questmen</plw> <pr>(<?/)</pr>.</plu> <def>One legally empowered to make quest of certain matters, esp. of abuses of weights and measures.</def> Specifically: <sd>(a)</sd> <def>A churchwarden's assistant; a sidesman.</def> <au>Blount.</au> <mark>[Obs.]</mark> <sd>(b)</sd> <def>A collector of parish rents.</def> <au>Blount.</au> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questmonger</ent><br/
<hw>Quest"mon`ger</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who lays informations, and encourages petty lawsuits.</def> <mark>[Obs.]</mark>  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questor</ent><br/
<hw>Ques"tor</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quaestor</ets>, contr. fr. <ets>quaesitor</ets>, fr. <ets>quaerere</ets>, <ets>quaesitum</ets>, to seek for, ask: cf. F. <ets>questeur</ets>.]</ety> <fld>(Rom. Antiq.)</fld> <def>An officer who had the management of the public treasure; a receiver of taxes, tribute, etc.; treasurer of state.</def> <altsp>[Written also <asp>qu<ae/stor</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ At an early period there were also public accusers styled <xex>questors</xex>, but the office was soon abolished.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questorship</ent><br/
<hw>Ques"tor*ship</hw>, <pos>n.</pos> <def>The office, or the term of office, of a questor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questrist</ent><br/
<hw>Quest"rist</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Quest</er>.]</ety> <def>A seeker; a pursuer.</def> <mark>[Obs.]</mark> <ldquo/Hot <xex>questrists</xex> after him.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questuary</ent><br/
<hw>Ques"tu*a*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quaestuarius</ets>, from <ets>quaestus</ets> gain, profit, <ets>quaerere</ets>, <ets>quaesitum</ets>, to seek for, earn.]</ety> <def>Studious of profit.</def> <mark>[Obs.]</mark>  <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Questuary</ent><br/
<hw>Ques"tu*a*ry</hw>, <pos>n.</pos> <def>One employed to collect profits.</def> <mark>[R.]</mark> <ldquo/The pope's <xex>questuaries</xex>.<rdquo/  <rj><au>Jer. Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quet</ent><br/
<hw>Quet</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>The common guillemot.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queue</ent><br/
<hw>Queue</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. See <er>Cue</er>.]</ety> <sd>(a)</sd> <def>A tail-like appendage of hair; a pigtail.</def> <sd>(b)</sd> <def>A line of persons waiting anywhere.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Queue</ent><br/
<hw>Queue</hw>, <pos>v. t.</pos> <def>To fasten, as hair, in a queue.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quey</ent><br/
<hw>Quey</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. Dan. <ets>qvie</ets>.]</ety> <def>A heifer.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quib</ent><br/
<hw>Quib</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Quip</er>.]</ety> <def>A quip; a gibe.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quibble</ent><br/
<hw>Quib"ble</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Probably fr. <ets>quib</ets>, <ets>quip</ets>, but influenced by <ets>quillet</ets>, or <ets>quiddity</ets>.]</ety> <sn>1.</sn> <def>A shift or turn from the point in question; a trifling or evasive distinction; an evasion; a cavil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Quibbles have no place in the search after truth.</q> <rj><qau> I. Watts.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A pun; a low conceit.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quibble</ent><br/
<hw>Quib"ble</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quibbled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quibbling</conjf> <pr>(?)</pr>.]</vmorph> <sn>1.</sn> <def>To evade the point in question by artifice, play upon words, caviling, or by raising any insignificant or impertinent question or point; to trifle in argument or discourse; to equivocate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To pun; to practice punning.</def>  <rj><au>Cudworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To cavil; shuffle; equivocate; trifle.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quibbler</ent><br/
<hw>Quib"bler</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who quibbles; a caviler; also, a punster.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quibblingly</ent><br/
<hw>Quib"bling*ly</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>Triflingly; evasively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quica</ent><br/
<hw>Qui"ca</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native Brazilian name.]</ety> <fld>(Zool.)</fld> <def>A small South American opossum (<spn>Didelphys quica</spn>), native of Guiana and Brazil. It feeds upon insects, small birds, and fruit.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quice</ent><br/
<hw>Quice</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See <er>Queest</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quich</ent><br/
<hw>Quich</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[Cf. <er>Quinch</er>.]</ety> <def>To stir.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He could not move nor <qex>quich</qex> at all.</q> <rj><qau> Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quichuan</ent><br/
<hw>Qui"chuan</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Designating, or pertaining to, a linguistic stock of South American Indians, including the majority of the civilized tribes of the ancient Peruvian Empire with some wild tribes never subjugated by the Incas. Most of these Indians are short, but heavy and strong. They are brachycephalic and of remarkably low cranial capacity. Nevertheless, they represent one of the highest of native American civilizations, characterized by agricultural, military, and administrative skill rather than by science or literature, although they were adept potters, weavers, and goldsmiths, and preserved by the aid of the mnemonic quipu a body of legendary lore in part written down since the introduction of writing.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quick</ent><br/
<hw>Quick</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Quicker</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Quickest</adjf>.]</amorph> <ety>[As. <ets>cwic</ets>, <ets>cwicu</ets>, <ets>cwucu</ets>, <ets>cucu</ets>, living; akin to OS. <ets>quik</ets>, D. <ets>kwik</ets>, OHG. <ets>quec</ets>, <ets>chec</ets>, G. <ets>keck</ets> bold, lively, Icel. <ets>kvikr</ets> living, Goth. <ets>qius</ets>, Lith. <ets>q<ymac/vas</ets>, Russ. <ets>zhivoi</ets>, L. <ets>vivus</ets> living, <ets>vivere</ets> to live, Gr. <grk>bi`os</grk> life, Skr. <ets>j<imac/va</ets> living, <ets>j<imac/v</ets> to live.  Cf. <er>Biography</er>, <er>Vivid</er>, <er>Quitch grass</er>, <er>Whitlow</er>.]</ety> <sn>1.</sn> <def>Alive; living; animate; -- opposed to <ant>dead</ant> or <ant>inanimate</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Not fully <qex>quyke</qex>, ne fully dead they were.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The Lord Jesus Christ, who shall judge the <qex>quick</qex> and the dead at his appearing and his kingdom.</q> <rj><qau>2 Tim. iv. 1.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Man is no star, but a <qex>quick</qex> coal<br/
Of mortal fire.</q> <rj><qau> Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In this sense the word is nearly obsolete, except in some compounds, or in particular phrases.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Characterized by life or liveliness; animated; sprightly; agile; brisk; ready.</def> <ldquo/ A <xex>quick</xex> wit.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Speedy; hasty; swift; not slow; <as>as, be <ex>quick</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Oft he to her his charge of <qex>quick</qex> return<br/
Repeated.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Impatient; passionate; hasty; eager; eager; sharp; unceremonious; <as>as, a <ex>quick</ex> temper</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The bishop was somewhat <qex>quick</qex> with them, and signified that he was much offended.</q> <rj><qau> Latimer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Fresh; bracing; sharp; keen.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The air is <qex>quick</qex> there,<br/
And it pierces and sharpens the stomach.</q> <rj><qau> Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Sensitive; perceptive in a high degree; ready; <as>as, a <ex>quick</ex> ear</as>.</def> <ldquo/To have an open ear, a <xex>quick</xex> eye.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They say that women are so <qex>quick</qex>.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Pregnant; with child.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quick grass</b></col>. <fld>(Bot.)</fld> <cd>See <er>Quitch grass</er>.</cd> -- <col><b>Quick match</b></col>. <cd>See under <er>Match</er>.</cd> -- <col><b>Quick vein</b></col> <fld>(Mining)</fld>, <cd>a vein of ore which is productive, not barren.</cd> -- <col><b>Quick vinegar</b></col>, <cd>vinegar made by allowing a weak solution of alcohol to trickle slowly over shavings or other porous material.</cd> -- <col><b>Quick water</b></col>, <cd>quicksilver water.</cd> -- <col><b>Quick with child</b></col>, <cd>pregnant with a living child.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Speedy; expeditious; swift; rapid; hasty; prompt; ready; active; brisk; nimble; fleet; alert; agile; lively; sprightly.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quick</ent><br/
<hw>Quick</hw> <pr>(?)</pr>, <pos>adv.</pos> <def>In a quick manner; quickly; promptly; rapidly; with haste; speedily; without delay; <as>as, run <ex>quick</ex>; get back <ex>quick</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>If we consider how very <qex>quick</qex> the actions of the mind are performed.</q> <rj><qau> Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quick</ent><br/
<hw>Quick</hw>, <pos>n.</pos> <sn>1.</sn> <def>That which is quick, or alive; a living animal or plant; especially, the hawthorn, or other plants used in making a living hedge.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The works . . . are curiously hedged with <qex>quick</qex>.</q> <rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The life; the mortal point; a vital part; a part susceptible of serious injury or keen feeling; the sensitive living flesh; the part of a finger or toe to which the nail is attached; the tender emotions; <as>as, to cut a finger nail to the <ex>quick</ex>; to thrust a sword to the <ex>quick</ex>, to taunt one to the <ex>quick</ex>; -- used figuratively.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>This test nippeth, . . . this toucheth the <qex>quick</qex>.</q> <rj><qau>Latimer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>How feebly and unlike themselves they reason when they come to the <qex>quick</qex> of the difference !</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>Quitch grass.</def>  <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quick</ent><br/
<hw>Quick</hw>, <pos>v. t. & i.</pos> <ety>[See <er>Quicken</er>.]</ety> <def>To revive; to quicken; to be or become alive.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickbeam</ent><br/
<hw>Quick"beam`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[A.S. <ets>cwicbe<aacute/m</ets>.]</ety> <def>See <er>Quicken tree</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quicken</ent><br/
<hw>Quick"en</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>quickened</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quickening</conjf>.]</vmorph> <ety>[AS. <ets>cwician</ets>. See <er>Quick</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>To make alive; to vivify; to revive or resuscitate, as from death or an inanimate state; hence, to excite; to, stimulate; to incite.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The mistress which I serve <qex>quickens</qex> what's dead.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Like a fruitful garden without an hedge, that <qex>quickens</qex> the appetite to enjoy so tempting a prize.</q> <rj><qau> South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make lively, active, or sprightly; to impart additional energy to; to stimulate; to make quick or rapid; to hasten; to accelerate; <as>as, to <ex>quicken</ex> one's steps or thoughts; to <ex>quicken</ex> one's departure or speed.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Shipbuilding)</fld> <def>To shorten the radius of (a curve); to make (a curve) sharper; <as>as, to <ex>quicken</ex> the sheer, that is, to make its curve more pronounced</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To revive; resuscitate; animate; reinvigorate; vivify; refresh; stimulate; sharpen; incite; hasten; accelerate; expedite; dispatch; speed.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quicken</ent><br/
<hw>Quick"en</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To come to life; to become alive; to become vivified or enlivened; hence, to exhibit signs of life; to move, as the fetus in the womb.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The heart is the first part that <qex>quickens</qex>, and the last that dies.</q> <rj><qau> Ray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And keener lightnings <qex>quicken</qex> in her eye.</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When the pale and bloodless east began<br/
To <qex>quicken</qex> to the sun.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To move with rapidity or activity; to become accelerated; <as>as, his pulse <ex>quickened</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickener</ent><br/
<hw>Quick"en*er</hw>, <pos>n.</pos> <def>One who, or that which, quickens.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickening</ent><br/
<hw>Quick"en*ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act or process of making or of becoming quick.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Physiol.)</fld> <def>The first motion of the fetus in the womb felt by the mother, occurring usually about the middle of the term of pregnancy. It has been popularly supposed to be due to the fetus becoming possessed of independent life.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickens</ent><br/
<hw>Quick"ens</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>Quitch grass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quicken tree</ent><br/
<hw>Quick"en tree`</hw> <pr>(?)</pr>. <ety>[Probably from <ets>quick</ets>, and first applied to the aspen or some tree with quivering leaves; cf. G. <ets>quickenbaum</ets>, <ets>quizenbaum</ets>, <ets>quitschenbaum</ets>.  Cf. <er>Quitch grass</er>.]</ety> <fld>(Bot.)</fld> <def>The European rowan tree; -- called also <altname>quickbeam</altname>, and <altname>quickenbeam</altname>. See <er>Rowan tree</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>quick-freeze</ent><br/
<hw>quick-freeze</hw> <pos>v. t.</pos>  <def>To freeze rapidly so as to preserve the natural juices and flavors; -- usually used of food or other biologicql matter.</def><br/
<syn><b>Syn. --</b> flash-freeze.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Quickhatch</ent><br/
<hw>Quick"hatch`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the American Indian name.]</ety> <fld>(Zool.)</fld> <def>The wolverine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quicklime</ent><br/
<hw>Quick"lime</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Quick</er>, <pos>a.</pos>]</ety> <fld>(Chem.)</fld> <def>Calcium oxide; unslacked lime; -- so called because when wet it develops great heat. See 4th <er>Lime</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickly</ent><br/
<hw>Quick"ly</hw>, <pos>adv.</pos> <def>Speedily; with haste or celerity; soon; without delay; quick.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickness</ent><br/
<hw>Quick"ness</hw>, <pos>n.</pos> <sn>1.</sn> <def>The condition or quality of being quick or living; life.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Touch it with thy celestial <qex>quickness</qex>.</q> <rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Activity; briskness; especially, rapidity of motion; speed; celerity; <as>as, <ex>quickness</ex> of wit</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This deed . . . must send thee hence<br/
With fiery <qex>quickness</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>His mind had, indeed, great <qex>quickness</qex> and vigor.</q> <rj><qau> Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Acuteness of perception; keen sensibility.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Would not <qex>quickness</qex> of sensation be an inconvenience to an animal that must lie still ?</q> <rj><qau>Locke</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Sharpness; pungency of taste.</def>  <rj><au>Mortimer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Velocity; celerity; rapidity; speed; haste; expedition; promptness; dispatch; swiftness; nimbleness; fleetness; agility; briskness; liveliness; readiness; sagacity; shrewdness; shrewdness; sharpness; keenness.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quicksand</ent><br/
<hw>Quick"sand`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Sand easily moved or readily yielding to pressure; especially, a deep mass of loose or moving sand mixed with water, sometimes found at the mouth of a river or along some coasts, and very dangerous, from the difficulty of extricating a person who begins sinking into it.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Life hath <qex>quicksands</qex>, -- Life hath snares!</q> <rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1178 --></p>

<p><ent>Quick-scented</ent><br/
<hw>Quick"-scent`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Acute of smell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickset</ent><br/
<hw>Quick"set`</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A living plant set to grow, esp. when set for a hedge; specifically, the hawthorn.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickset</ent><br/
<hw>Quick"set`</hw>, <pos>a.</pos> <def>Made of quickset.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Dates and pomegranates on the <qex>quickset</qex> hedges.</q> <rj><qau>Walpole.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickset</ent><br/
<hw>Quick"set`</hw>, <pos>v. t.</pos> <def>To plant with living shrubs or trees for a hedge; <as>as, to <ex>quickset</ex> a ditch</as>.</def>  <rj><au>Mortimer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quick-sighted</ent><br/
<hw>Quick"-sight`ed</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having quick sight or acute discernment; quick to see or to discern.</def>  <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p>--<wordforms><wf>Quick"-sight`ed*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quicksilver</ent><br/
<hw>Quick"sil`ver</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quick</ets> living + <ets>silver</ets>; -- so called from its fluidity; cf. G. <ets>quecksilber</ets>, L. <ets>argentum vivum</ets>. See <er>Quick</er>, <pos>a.</pos>]</ety> <fld>(Chem.)</fld> <def>The metal mercury; -- so called from its resemblance to liquid silver.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quicksilver horizon</b></col>, <cd>a mercurial artificial horizon. See under <er>Horizon</er>.</cd> -- <col><b>Quicksilver water</b></col>, <cd>a solution of mercury nitrate used in artificial silvering; quick water.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quicksilvered</ent><br/
<hw>Quick"sil`vered</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Overlaid with quicksilver, or with an amalgam of quicksilver and tinfoil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quicksilvering</ent><br/
<hw>Quick"sil`ver*ing</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The mercury and foil on the back of a looking-glass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickstep</ent><br/
<hw>Quick"step`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Mus.)</fld> <def>A lively, spirited march; also, a lively style of dancing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quick-witted</ent><br/
<hw>Quick"-wit`ted</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Having ready wit</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quick-wittedness</ent><br/
<hw>Quick"-wit`ted*ness</hw>, <pos>n.</pos> <def>Readiness of wit.</def> <ldquo/Celtic <xex>quick-wittedness</xex>.<rdquo/  <rj><au>M. Arnold.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quickwork</ent><br/
<hw>Quick"work`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Naut.)</fld> A term somewhat loosely used to denote: <sd>(a)</sd> <def>All the submerged section of a vessel's planking.</def> <sd>(b)</sd> <def>The planking between the spirketing and the clamps.</def> <sd>(c)</sd> <def>The short planks between the portholes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quid</ent><br/
<hw>Quid</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See <er>Cud</er>.]</ety> <def>A portion suitable to be chewed; a cud; <as>as, a <ex>quid</ex> of tobacco</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quid</ent><br/
<hw>Quid</hw> <pr>(kw<icr/d)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>quid</plw>.</plu> <ety>[Etym. uncertain.]</ety> <def>An English coin, a sovereign.</def> <mark>[Slang, Eng.]</mark><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><q>They invited him to come to-morrow, . . . and bring half a <qex>quid</qex> with him.</q>  <rj><qau>Charles Reade.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quid</ent><br/
<hw>Quid</hw>, <pos>v. t.</pos> <fld>(Man.)</fld> <def>To drop from the mouth, as food when partially chewed; -- said of horses.</def>  <rj><au>Youatt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quidam</ent><br/
\'d8<hw>Qui"dam</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>Somebody; one unknown.</def>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiddany</ent><br/
<hw>Quid"da*ny</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>cydoneum</ets> quince juice, quince wine. See <er>Quince</er>.]</ety> <def>A confection of quinces, in consistency between a sirup and marmalade.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiddative</ent><br/
<hw>Quid"da*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Quiddity</er>.]</ety> <def>Constituting, or containing, the essence of a thing; quidditative.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiddit</ent><br/
<hw>Quid"dit</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. <er>Quiddity</er>, <er>Quillet</er>, and <er>Quibble</er>.]</ety> <def>A subtilty; an equivocation.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>By some strange <qex>quiddit</qex> or some wrested clause.</q> <rj><qau>Drayton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quidditative</ent><br/
<hw>Quid"di*ta*tive</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Quiddative.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiddity</ent><br/
<hw>Quid"di*ty</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quiddities</plw> <pr>(#)</pr>.</plu> <ety>[LL. <ets>quidditas</ets>, fr. L. <ets>quid</ets> what, neut. of <ets>quis</ets> who, akin to E. <ets>who</ets>: cf. F. <ets>quiddit<eacute/</ets>.]</ety> <sn>1.</sn> <def>The essence, nature, or distinctive peculiarity, of a thing; that which answers the question, <xex>Quid est</xex>? or, What is it?</def> <ldquo/ The degree of nullity and <xex>quiddity</xex>.<rdquo/  <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>quiddity</qex> or characteristic difference of poetry as distinguished from prose.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A trifling nicety; a cavil; a quibble.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We laugh at the <qex>quiddities</qex> of those writers now.</q> <rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiddle</ent><br/
<hw>Quid"dle</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quiddled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quiddling</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>quid</ets> what.]</ety> <def>To spend time in trifling employments, or to attend to useful subjects in an indifferent or superficial manner; to dawdle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiddler</ent><br/
<ent>Quiddle</ent><br/
<mhw>{ <hw>Quid"dle</hw> <pr>(?)</pr>, <hw>Quid"dler</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <def>One who wastes his energy about trifles.</def>  <rj><au>Emerson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quidnunc</ent><br/
<hw>Quid"nunc</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., what now?]</ety> <def>One who is curious to know everything that passes; one who knows, or pretends to know, all that is going on.</def> <ldquo/The idle stories of <xex>quidnuncs</xex>.<rdquo/  <rj><au>Motley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiesce</ent><br/
<hw>Qui*esce"</hw> <pr>(?)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quiesced</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quiescing</conjf> <pr>(?)</pr>.]</vmorph> <ety>[L. <ets>quiescere</ets>, akin to <ets>quies</ets> rest, quiet. See <er>Quiet</er>, <pos>a. & n.</pos>]</ety> <def>To be silent, as a letter; to have no sound.</def>  <rj><au>M. Stuart.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiescency</ent><br/
<ent>Quiescence</ent><br/
<mhw>{ <hw>Qui*es"cence</hw> <pr>(?)</pr>, <hw>Qui*es"cen*cy</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <ety>[L. <ets>quiescentia</ets>, fr. <ets>quiescens</ets>, p. pr.; cf. F. <ets>quiestence</ets>. See <er>Quiesce</er>.]</ety> <def>The state or quality of being quiescent.</def> <ldquo/<xex>Quiescence</xex>, bodily and mental.<rdquo/  <rj><au>H. Spencer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Deeds will be done; -- while be boasts his <qex>quiescence</qex>.</q> <rj><qau>R. Browning.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiescent</ent><br/
<hw>Qui*es"cent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quiescens</ets>, <ets>-entis</ets>, p. pr. of <ets>quiescere</ets>: cf. F. <ets>quiescent</ets>. See <er>Quiesce</er>.]</ety> <sn>1.</sn> <def>Being in a state of repose; at rest; still; not moving; <as>as, a <ex>quiescent</ex> body or fluid</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not ruffed with passion; unagitated; not in action; not excited; quiet; dormant; resting.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In times of national security, the feeling of patriotism . . . is so <qex>quiescent</qex> that it seems hardly to exist.</q> <rj><qau>Prof. Wilson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Gram.)</fld> <def>Not sounded; silent; <as>as, y is <ex>quiescent</ex> in <ldquo/<ex>day</ex><rdquo/ and <ldquo/<ex>say</ex></as>.<rdquo/</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiescent</ent><br/
<hw>Qui*es"cent</hw>, <pos>n.</pos> <fld>(Gram.)</fld> <def>A silent letter.</def>  <rj><au>M. Stuart.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiescently</ent><br/
<hw>Qui*es"cent*ly</hw>, <pos>adv.</pos> <def>In a quiescent manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiet</ent><br/
<hw>Qui"et</hw> <pr>(?)</pr>, <pos>a.</pos> <amorph>[<pos>Compar.</pos> <adjf>Quieter</adjf> <pr>(?)</pr>; <pos>superl.</pos> <adjf>Quietest</adjf>.]</amorph> <ety>[L. <ets>quietus</ets>, p. p. pf <ets>quiescere</ets> to rest, keep quiet; akin to <ets>quies</ets> rest, and prob. to E. <ets>while</ets>, n. See <er>While</er>, and cf. <er>Coy</er>, <pos>a.</pos>, <er>Quiesce</er>, <er>Quietus</er>, <er>Quit</er>, <pos>a.</pos>, <er>Quite</er>, <er>Requiem</er>.]</ety> <sn>1.</sn> <def>In a state of rest or calm; without stir, motion, or agitation; still; <as>as, a <ex>quiet</ex> sea; <ex>quiet</ex> air.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>They . . . were <qex>quiet</qex> all the night, saying, In the morning, when it is day, we shall kill him.</q> <rj><qau>Judg. xvi. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Free from noise or disturbance; hushed; still.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Not excited or anxious; calm; peaceful; placid; settled; <as>as, a <ex>quiet</ex> life; a <ex>quiet</ex> conscience.</as></def> <ldquo/ So <xex>quiet</xex> and so sweet a style.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>That son, who on the <qex>quiet</qex> state of man<br/
Such trouble brought.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Not giving offense; not exciting disorder or trouble; not turbulent; gentle; mild; meek; contented.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The ornament of a meek and <qex>quiet</qex> spirit.</q> <rj><qau>1 Pet. iii. 4.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I will sit as <qex>quiet</qex> as a lamb.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Not showy; not such as to attract attention; undemonstrative; <as>as, a <ex>quiet</ex> dress; <ex>quiet</ex> colors; a <ex>quiet</ex> movement.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Still; tranquil; calm; unruffled; smooth; unmolested; undisturbed; placid; peaceful; mild; peaceable; meek; contented.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiet</ent><br/
<hw>Qui"et</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quies</ets>, <ets>-etis</ets>. See <er>Quiet</er>, <pos>a.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quality or state of being quiet, or in repose; as an hour or a time of <xex>quiet</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Freedom from disturbance, noise, or alarm; stillness; tranquillity; peace; security.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And join with thee, calm Peace and <qex>Quiet</qex>.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>At quiet</b></col>, <cd>still; peaceful.</cd> -- <col><b>In quiet</b></col>, <cd>quietly.</cd> <ldquo/ I will depart <xex>in quiet</xex>.<rdquo/ <au>Shak.</au> -- <col><b>Out of quiet</b></col>, <cd>disturbed; restless.</cd> <mark>[Obs.]</mark> <ldquo/She is much <xex>out of quiet</xex>.<rdquo/  <rj><au>Shak.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiet</ent><br/
<hw>Qui"et</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quieted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Quieting</conjf>.]</vmorph> <sn>1.</sn> <def>To stop motion in; to still; to reduce to a state of rest, or of silence.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To calm; to appease; to pacify; to lull; to allay; to tranquillize; <as>as, to <ex>quiet</ex> the passions; to <ex>quiet</ex> clamors or disorders; to <ex>quiet</ex> pain or grief.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Quiet</qex> yourselves, I pray, and be at peace.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiet</ent><br/
<hw>Qui"et</hw>, <pos>v. i.</pos> <def>To become still, silent, or calm; -- often with <xex>down</xex>; <as>as, be soon <ex>quieted</ex> down</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietage</ent><br/
<hw>Qui"et*age</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Quietness.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quieter</ent><br/
<hw>Qui"et*er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that which, quiets.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietism</ent><br/
<hw>Qui"et*ism</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Cf. F. <ets>qui<eacute/tisme</ets>.]</ety> <sn>1.</sn> <def>Peace or tranquillity of mind; calmness; indifference; apathy; dispassion; indisturbance; inaction.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eccl. Hist.)</fld> <def>The system of the Quietists, who maintained that religion consists in the withdrawal of the mind from worldly interests and anxieties and its constant employment in the passive contemplation of God and his attributes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietist</ent><br/
<hw>Qui"et*ist</hw>, <pos>n.</pos> <ety>[Cf. F. <ets>qui<eacute/tiste</ets>.]</ety> <fld>(Eccl. Hist.)</fld> <def>One of a sect of mystics originated in the seventeenth century by Molinos, a Spanish priest living in Rome. See <er>Quietism</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietistic</ent><br/
<hw>Qui`et*is"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of or pertaining to the Quietists, or to Quietism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietly</ent><br/
<hw>Qui"et*ly</hw>, <pos>adv.</pos> <sn>1.</sn> <def>In a quiet state or manner; without motion; in a state of rest; <as>as, to lie or sit <ex>quietly</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Without tumult, alarm, dispute, or disturbance; peaceably; <as>as, to live <ex>quietly</ex>; to sleep <ex>quietly</ex>.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Calmly, without agitation or violent emotion; patiently; <as>as, to submit <ex>quietly</ex> to unavoidable evils</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Noiselessly; silently; without remark or violent movement; in a manner to attract little or no observation; <as>as, he <ex>quietly</ex> left the room</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietness</ent><br/
<hw>Qui"et*ness</hw>, <pos>n.</pos> <def>The quality or state of being quiet; freedom from noise, agitation, disturbance, or excitement; stillness; tranquillity; calmness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I would have peace and <qex>quietness</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietsome</ent><br/
<hw>Qui"et*some</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Calm; still.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietude</ent><br/
<hw>Qui"e*tude</hw>, <pos>n.</pos> <ety>[L. <ets>quietudo</ets>: cf. F. <ets>qui<eacute/tude</ets>.]</ety> <def>Rest; repose; quiet; tranquillity.</def>  <rj><au>Shelley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quietus</ent><br/
<hw>Qui*e"tus</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[LL. <ets>quietus</ets> quit, discharged, L., at rest, quiet, dead. See <er>Quiet</er>, <pos>a.</pos>, and cf. <er>Quit</er>, <pos>a.</pos>]</ety> <def>Final discharge or acquittance, as from debt or obligation; that which silences claims; (<mark>Fig.</mark>) rest; death.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When he himself might his <qex>quietus</qex> make<br/
With a bare bodkin.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quill</ent><br/
<hw>Quill</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Perhaps fr. F. <ets>quille</ets> ninepin (see <er>Kayless</er>); but cf. also G. <ets>kiel</ets> a quill. MHG. <ets>kil</ets>, and Ir. <ets>cuille</ets> a quill.]</ety> <sn>1.</sn> <def>One of the large feathers of a bird's wing, or one of the rectrices of the tail; also, the stock of such a feather.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A pen for writing made by sharpening and splitting the point or nib of the stock of a feather; <as>as, history is the proper subject of his <ex>quill</ex></as>.</def>  <rj><au>Sir H. Wotton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>A spine of the hedgehog or porcupine.</def> <sd>(b)</sd> <def>The pen of a squid. See <er>Pen</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Mus.)</fld> <sd>(a)</sd> <def>The plectrum with which musicians strike the strings of certain instruments.</def> <sd>(b)</sd> <def>The tube of a musical instrument.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He touched the tender stops of various <qex>quills</qex>.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Something having the form of a quill</def>; as: <sd>(a)</sd> <def>The fold or plain of a ruff.</def> <sd>(b)</sd> <fld>(Weaving)</fld> <def>A spindle, or spool, as of reed or wood, upon which the thread for the woof is wound in a shuttle.</def> <sd>(c)</sd> <fld>(Mach.)</fld> <def>A hollow spindle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Pharm.)</fld> <def>A roll of dried bark; <as>as, a <ex>quill</ex> of cinnamon or of cinchona</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Quill bit</b></col>, <cd>a bit for boring resembling the half of a reed split lengthways and having its end sharpened like a gouge.</cd> -- <col><b>Quill driver</b></col>, <cd>one who works with a pen; a writer; a clerk.</cd> <mark>[Jocose]</mark> -- <col><b>Quill nib</b></col>, <cd>a small quill pen made to be used with a holder.</cd>  <rj><au>Simmonds.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quill</ent><br/
<hw>Quill</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quilled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quilling</conjf>.]</vmorph> <sn>1.</sn> <def>To plaint in small cylindrical ridges, called quillings; <as>as, to <ex>quill</ex> a ruffle</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His cravat seemed <qex>quilled</qex> into a ruff.</q> <rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To wind on a quill, as thread or yarn.</def>  <rj><au>Judd.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quillaia bark</ent><br/
<hw>Quil*la"ia bark`</hw> <pr>(?)</pr>. <fld>(Bot.)</fld> <def>The bark of a rosaceous tree (<spn>Quillaja Saponaria</spn>), native of Chile.  The bark is finely laminated, and very heavy with alkaline substances, and is used commonly by the Chileans instead of soap.  Also called <altname>soap bark</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quillback</ent><br/
<hw>Quill"back`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>An American fresh-water fish (<spn>Ictiobus cyprinus</spn> syn. <spn>Carpiodes cyprinus</spn>); -- called also <altname>carp sucker</altname>, <altname>sailfish</altname>, <altname>spearfish</altname>, and <altname>skimback</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quilled</ent><br/
<hw>Quilled</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Furnished with quills; also, shaped like quills.</def> <ldquo/A sharp-<xex>quilled</xex> porcupine.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quilled suture</b></col> <fld>(Surg.)</fld>, <cd>a variety of stitch in which the threads after being passed deeply through the edges of a wound are secured about two quills or bodies of similar shape, in order to produce a suitable degree of pressure.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quillet</ent><br/
<hw>Quil"let</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quidlibet</ets> what you please.  Cf. <er>Quiddit</er>, and <er>Quibble</er>.]</ety> <def>Subtilty; nicety; quibble.</def> <ldquo/Nice, sharp <xex>quillets</xex> of the law.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quilling</ent><br/
<hw>Quill"ing</hw> <pr>(?)</pr>, <pos>n.</pos> <sd>(a)</sd> <def>A band of linen, muslin, or the like, fluted, folded, or plaited so as somewhat to resemble a row of quills.</def> <sd>(b)</sd> <def>One of the rounded plaits or flutings of such a band.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quillwort</ent><br/
<hw>Quill"wort`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>Any plant or species of the genus <gen>Isoetes</gen>, cryptogamous plants with a cluster of elongated four-tubed rushlike leaves, rising from a corm, and containing spores in their enlarged and excavated bases. There are about seventeen American species, usually growing in the mud under still, shallow water. So called from the shape of the shape of the leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quilt</ent><br/
<hw>Quilt</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>quilte</ets>, OF. <ets>cuilte</ets>, L. <ets>culcita <?/</ets> bed, cushion, mattress.  Cf. 2d <er>Counterpoint</er>, <er>Cushion</er>.]</ety> <def>Anything that is quilted; esp., a quilted bed cover, or a skirt worn by women; any cover or garment made by putting wool, cotton, etc., between two cloths and stitching them together; also, any outer bed cover.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The beds were covered with magnificent <qex>quilts</qex>.</q> <rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quilt</ent><br/
<hw>Quilt</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quilted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Quilting</conjf>.]</vmorph> <sn>1.</sn> <def>To stitch or sew together at frequent intervals, in order to confine in place the several layers of cloth and wadding of which a garment, comforter, etc., may be made; <as>as, to <ex>quilt</ex> a coat</as>.</def>  <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To wad, as a garment, with warm soft material.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To stitch or sew in lines or patterns.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quilter</ent><br/
<hw>Quilt"er</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who, or that which, quilts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quilting</ent><br/
<hw>Quilt"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of stitching or running in patterns, as in making a quilt.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A quilting bee. See <er>Bee</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The material used for making quilts.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Naut.)</fld> <def>A coating of strands of rope for a water vessel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quin</ent><br/
<hw>Quin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A European scallop (<spn>Pecten opercularis</spn>), used as food.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinaldine</ent><br/
<hw>Quin*al"dine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>oline + <ets>alde</ets>hyde + anil<ets>ine</ets>.]</ety> <fld>(Chem.)</fld> <def>A colorless liquid of a slightly pungent odor, <chform>C9H6N.CH3</chform>, first obtained as a condensation product of aldehyde and aniline, and regarded as a derivative of quinoline; -- called also <altname>methyl quinoline</altname>.</def> <altsp>[Written also <asp>chinaldine</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinary</ent><br/
<hw>Qui"na*ry</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quinarius</ets>, from <ets>quini</ets> five each, akin to <ets>quinque</ets> five: cf. F. <ets>quinaire</ets>. See <er>Five</er>.]</ety> <def>Consisting of five; arranged by fives.</def>  <rj><au>Boyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quinary system</b></col> <fld>(Zool.)</fld>, <cd>a fanciful classification based on the hypothesis that each group contains five types.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinate</ent><br/
<hw>Qui"nate</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quini</ets> five each.]</ety> <fld>(Bot.)</fld> <def>Growing in sets of five; -- said especially of leaves composed of five leaflets set at the end of a common petiole.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinate</ent><br/
<hw>Qui"nate</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>A salt of quinic acid.</def> <altsp>[Written also <asp>kinate</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinazol</ent><br/
<hw>Quin"a*zol</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>oline + <ets>az</ets>ote.]</ety> <fld>(Chem.)</fld> <def>A complex nitrogenous base related to cinnoline.</def> <altsp>[Written also <asp>chinazol</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quince</ent><br/
<hw>Quince</hw> <pr>(kw<icr/ns)</pr>, <pos>n.</pos> <ety>[Prob. a pl. from OE. <ets>quyne</ets>, <ets>coin</ets>, OF. <ets>coin</ets>, <ets>cooin</ets>, F. <ets>coing</ets>, from L. <ets>Cydonius</ets> a quince tree, as adj., Cydonian, Gr. <?/ Cydonian, <?/ <?/ a quince, fr. <?/ Cydonia, a city in Crete, <?/ the Cydonians.  Cf. <er>Quiddany</er>.]</ety> <sn>1.</sn> <def>The fruit of a shrub (<spn>Cydonia vulgaris</spn>) belonging to the same tribe as the apple. It somewhat resembles an apple, but differs in having many seeds in each carpel. It has hard flesh of high flavor, but very acid, and is largely used for marmalade, jelly, and preserves.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>a quince tree or shrub.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Japan quince</b></col> <fld>(Bot.)</fld>, <cd>an Eastern Asiatic shrub (<spn>Cydonia Japonica</spn>, formerly <spn>Pyrus Japonica</spn>) and its very fragrant but inedible fruit.  The shrub has very showy flowers, usually red, but sometimes pink or white, and is much grown for ornament.</cd> -- <col><b>Quince curculio</b></col> <fld>(Zool.)</fld>, <cd>a small gray and yellow curculio (<spn>Conotrachelus crat<ae/gi</spn>) whose larva lives in quinces.</cd> -- <col><b>Quince tree</b></col> <fld>(Bot.)</fld>, <cd>the small tree (<spn>Cydonia vulgaris</spn>) which produces the quince.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quincewort</ent><br/
<hw>Quince"wort`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>The squinancy.  Called also <altname>quinsywort</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinch</ent><br/
<hw>Quinch</hw> <pr>(?)</pr>, <pos>v. i.</pos> <ety>[Cf. OD. <ets>quincken</ets> to quiver, shake, Fries. <ets>quink</ets> hovering.  Cf. <er>Quich</er>.]</ety> <def>To stir; to wince.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quincuncial</ent><br/
<hw>Quin*cun"cial</hw> <pr>(?)</pr>, <ety>[L. <ets>quincuncialis</ets>, from <ets>quincunx</ets>. See <er>Quincunx</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Having the form of a quincunx.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Having the leaves of a pentamerous calyx or corolla so imbricated that two are exterior, two are interior, and the other has one edge exterior and one interior; <as>as, <ex>quincuncial</ex> <ae/stivation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quincuncial phyllotaxy</b></col> <fld>(Bot.)</fld>, <cd>an arrangement of five leaves in a spiral, each leaf two fifths of a circle from the next.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quincuncially</ent><br/
<hw>Quin*cun"cial*ly</hw>, <pos>adv.</pos> <def>In the manner or order of a quincunx.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quincunx</ent><br/
<hw>Quin"cunx</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L., fr. <ets>quinque</ets> five + <ets>uncia</ets> an ounce. The quincunx was marked by five small spots or balls. See <er>Five</er>, and <er>Ounce</er> the weight.]</ety> <sn>1.</sn> <def>An arrangement of things by fives in a square or a rectangle, one being placed at each corner and one in the middle; especially, such an arrangement of trees repeated indefinitely, so as to form a regular group with rows running in various directions.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Astrol.)</fld> <def>The position of planets when distant from each other five signs, or 150<deg/.</def>  <rj><au>Hutton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>A quincuncial arrangement, as of the parts of a flower in <ae/stivation. See <er>Quincuncial</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quindecagon</ent><br/
<hw>Quin*dec"a*gon</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quindec</ets>im fifteen + Gr. <?/ angle.]</ety> <fld>(Geom.)</fld> <def>A plane figure with fifteen angles, and consequently fifteen sides.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quindecemvir</ent><br/
\'d8<hw>Quin`de*cem"vir</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E. <plw>Quindecemvirs</plw> <pr>(#)</pr>, L. <plw>Quindecemviri</plw> <pr>(#)</pr>.</plu> <ety>[L., from <ets>quindecim</ets> fifteen + <ets>vir</ets> a man.]</ety> <fld>(Rom. Antiq.)</fld> <def>One of a sacerdotal college of fifteen men whose chief duty was to take care of the Sibylline books.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quindecemvirate</ent><br/
<hw>Quin`de*cem"vi*rate</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quindecimviratus</ets>.]</ety> <def>The body or office of the quindecemviri.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quindecone</ent><br/
<hw>Quin*dec"one</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quindecim</ets> fifteen.]</ety> <fld>(Chem.)</fld> <def>An unsaturated hydrocarbon, <chform>C15H26</chform>, of the valylene series, produced artificially as an oily liquid.</def> <altsp>[Written also <asp>quindekone</asp>.]</altsp><-- now quindecene??--><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1179 --></p>

<p><ent>Quindecylic</ent><br/
<hw>Quin`de*cyl"ic</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quindecim</ets> fifteen + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, or designating, an acid of the fatty acid series, containing fifteen atoms of carbon; called also <altname>pentadecylic</altname> acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quindem</ent><br/
<hw>Quin"dem</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A fifteenth part.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quindism</ent><br/
<hw>Quin"dism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A fifteenth.</def> <mark>[Obs.]</mark>  <rj><au>Prynne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinhydrone</ent><br/
<hw>Quin*hy"drone</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>one + <ets>hydro</ets>quinone.]</ety> <fld>(Chem.)</fld> <def>A green crystalline substance formed by the union of quinone with hydroquinone, or as an intermediate product in the oxidation of hydroquinone or the reduction of quinone.</def> <altsp>[Written also <asp>chinhydrone</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinia</ent><br/
\'d8<hw>Quin"i*a</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.]</ety> <fld>(Chem.)</fld> <def>Quinine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinible</ent><br/
<hw>Quin"i*ble</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quini</ets> five each.]</ety> <fld>(Mus.)</fld> <def>An interval of a fifth; also, a part sung with such intervals.</def> <mark>[Obs.]</mark> <ldquo/He sang . . . a loud <xex>quynyble</xex>.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinic</ent><br/
<hw>Quin"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[See <er>Quinine</er>, and cf. <er>Kinic</er>.]</ety> <fld>(Chem.)</fld> <def>Pertaining to, derived from, or connected with, quinine and related compounds; specifically, designating a nonnitrogenous acid obtained from cinchona bark, coffee, beans, etc., as a white crystalline substance.</def> <altsp>[Written also <asp>chinic</asp>, <asp>kinic</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinicine</ent><br/
<hw>Quin"i*cine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>An uncrystallizable alkaloid obtained by the action of heat from quinine, with which it is isomeric.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinidine</ent><br/
<hw>Quin"i*dine</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Chem.)</fld> <def>An alkaloid isomeric with, and resembling, quinine, found in certain species of cinchona, from which it is extracted as a bitter white crystalline substance; conchinine. It is used somewhat as a febrifuge.</def> <altsp>[Written also <asp>chinidine</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinine</ent><br/
<hw>Qui"nine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. (cf. Sp. <ets>quinina</ets>), fr. Sp. <ets>quina</ets>, or <ets>quinaquina</ets>, Peruvian bark, fr. Peruv. <ets>kina</ets>, <ets>quina</ets>, bark.  Cf. <er>Kinic</er>.]</ety> <fld>(Chem.)</fld> <def>An alkaloid extracted from the bark of several species of cinchona (esp. <spn>Cinchona Calisaya</spn>) as a bitter white crystalline substance, <chform>C20H24N2O2</chform>. Hence, by extension <fld>(Med.)</fld>, any of the salts of this alkaloid, as the acetate, chloride, sulphate, etc., employed as a febrifuge or antiperiodic. Called also <altname>quinia</altname>, <altname>quinina</altname>, etc.</def> <altsp>[Written also <asp>chinine</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quininic</ent><br/
<hw>Qui*nin"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or designating, a nitrogenous acid obtained as a yellow crystalline substance by the oxidation of quinine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinism</ent><br/
<ent>Quininism</ent><br/
<mhw>{ <hw>Qui"nin*ism</hw> <pr>(?)</pr>, <hw>Qui"nism</hw> <pr>(?)</pr>, }</mhw> <pos>n.</pos> <fld>(Med.)</fld> <def>See <er>Cinchonism</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinizarin</ent><br/
<hw>Qui*niz"a*rin</hw> <pr>(?)</pr>, <ety>[Hydro<ets>quin</ets>one + <ets>alizarin</ets>.]</ety> <fld>(Chem.)</fld> <def>A yellow crystalline substance produced artificially. It is isomeric with alizarin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinizine</ent><br/
<hw>Quin"i*zine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>oline + hydra<ets>zine</ets>.]</ety> <fld>(Chem.)</fld> <def>any one of a series of nitrogenous bases, certain of which are used as antipyretics.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinnat</ent><br/
<hw>Quin"nat</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From the native name.]</ety> <fld>(Zool.)</fld> <def>The California salmon (<spn>Oncorhynchus choicha</spn>); -- called also <altname>chouicha</altname>, <altname>king salmon</altname>, <altname>chinnook salmon</altname>, and <altname>Sacramento salmon</altname>. It is of great commercial importance.</def> <altsp>[Written also <asp>quinnet</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinoa</ent><br/
\'d8<hw>Qui*no"a</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The seeds of a kind of goosewort (<spn>Chenopodium Quinoa</spn>), used in Chili and Peru for making porridge or cakes; also, food thus made.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinogen</ent><br/
<hw>Quin"o*gen</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>ine + <ets>-gen</ets>.]</ety> <fld>(Chem.)</fld> <def>A hypothetical radical of quinine and related alkaloids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinoidine</ent><br/
<hw>Qui*noid"ine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>ine + <ets>-oid</ets>.]</ety> <fld>(Med. Chem.)</fld> <def>A brownish resinous substance obtained as a by-product in the treatment of cinchona bark.  It consists of a mixture of several alkaloids.</def> <altsp>[Written also <asp>chinoidine</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinoline</ent><br/
<hw>Quin"o*line</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>ine + L. <ets>ol</ets>eum oil + <ets>-ine</ets>.]</ety> <fld>(Chem.)</fld> <def>A nitrogenous base, <chform>C9H7N</chform> obtained as a pungent colorless liquid by the distillation of alkaloids, bones, coal tar, etc. It the nucleus of many organic bodies, especially of certain alkaloids and related substances; hence, by extension, any one of the series of alkaloidal bases of which quinoline proper is the type.</def> <altsp>[Written also <asp>chinoline</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinologist</ent><br/
<hw>Qui*nol"o*gist</hw> <pr>(?)</pr>, <pos>n.</pos> <def>One who is versed in quinology.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinology</ent><br/
<hw>Qui*nol"o*gy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>ine + <ets>-logy</ets>.]</ety> <def>The science which treats of the cultivation of the cinchona, and of its use in medicine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinone</ent><br/
<hw>Qui"none</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>ine + ket<ets>one</ets>.]</ety> <fld>(Chem.)</fld> <def>A crystalline substance, <chform>C6H4O2</chform> (called also <altname>benzoketone</altname>), first obtained by the oxidation of quinic acid and regarded as a double ketone; also, by extension, any one of the series of which quinone proper is the type.</def> <altsp>[Written also <asp>chinone</asp>, <asp>kinone</asp>.]</altsp>
<-- and benzoquinone. --><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinovic</ent><br/
<hw>Qui*no"vic</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Pertaining to, or designating, a crystalline acid obtained from some varieties of cinchona bark.</def> <altsp>[Written also <asp>chinovic</asp>, and <asp>kinovic</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinovin</ent><br/
<hw>Qui*no"vin</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. <ets>quina nova</ets> the tree <ets>Cosmibuena magnifolia</ets>, whose bark yields quinovin.]</ety> <fld>(Chem.)</fld> <def>An amorphous bitter glucoside derived from cinchona and other barks. Called also <altname>quinova bitter</altname>, and <altname>quinova</altname>.</def> <altsp>[Written also <asp>chinovin</asp>, and <asp>kinovin</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinoxaline</ent><br/
<hw>Quin*ox"a*line</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>oline + gly<ets>oxal</ets>.]</ety> <fld>(Chem.)</fld> <def>Any one of a series of complex nitrogenous bases obtained by the union of certain aniline derivatives with glyoxal or with certain ketones.</def> <altsp>[Written also <asp>chinoxaline</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinoxyl</ent><br/
<hw>Quin*ox"yl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>one + <ets>oxy</ets>gen + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>The hypothetical radical of certain quinone derivatives related to rhodizonic acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinoyl</ent><br/
<hw>Qui"noyl</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quin</ets>one + <ets>-yl</ets>.]</ety> <fld>(Chem.)</fld> <def>A radical of which quinone is the hydride, analogous to phenyl.</def> <altsp>[Written also <asp>kinoyl</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquagesima</ent><br/
<hw>Quin`qua*ges"i*ma</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L., fr. <ets>quinquagesimus</ets> the fiftieth, akin to <ets>quinquaginta</ets> fifty, <ets>quinque</ets> five. See <er>Five</er>.]</ety> <def>Fiftieth.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quinquagesima Sunday</b></col>, <cd>the Sunday which is the fiftieth day before Easter, both days being included in the reckoning; -- called also <altname>Shrove Sunday</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquangular</ent><br/
<hw>Quin*quan"gu*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quinquanqulus</ets>; <ets>quinque</ets> five + <ets>angulus</ets> ad angle: cf. F. <ets>quinquangulaire</ets>.]</ety> <def>Having five angles or corners.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquarticular</ent><br/
<hw>Quin`quar*tic"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quin</ets>que- + <ets>article</ets>.]</ety> <fld>(Theol.)</fld> <def>Relating to the five articles or points; <as>as, the <ex>quinquarticular</ex> controversy between Arminians and Calvinists</as>.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Sanderson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinque-</ent><br/
<hw>Quin"que-</hw> <pr>(?)</pr>. <ety>[L. <ets>quinque</ets> five. See <er>Five</er>.]</ety> <def>A combining form meaning <xex>five</xex>, <xex>five times</xex>, <xex>fivefold</xex>; <as>as, <ex>quinque</ex>fid, five-cleft; <ex>quinque</ex>dentate, five-toothed.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinqueangled</ent><br/
<hw>Quin"que*an`gled</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>angle</ets>.]</ety> <def>Having five angles; quinquangular.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquedentated</ent><br/
<ent>Quinquedentate</ent><br/
<mhw>{ <hw>Quin`que*den"tate</hw> <pr>(?)</pr>, <hw>Quin`que*den"ta*ted</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>dentate</ets>, <ets>-tated</ets>: cf. F. <ets>quinqu<eacute/dent<eacute/</ets>.]</ety> <def>Five-toothed; <as>as, a <ex>quinquedentate</ex> leaf</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquefarious</ent><br/
<hw>Quin`que*fa"ri*ous</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[From L. <ets>quinque</ets> five: cf. F. <ets>quinqu<eacute/fari<eacute/</ets>.  Cf. <er>Bifarious</er>.]</ety> <fld>(Bot.)</fld> <def>Arranged in five vertical rows; pentastichous.</def>  <rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquefid</ent><br/
<hw>Quin"que*fid</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quique-</ets> + the root of L. <ets>findere</ets> to cleave: cf. F. <ets>quinqu<eacute/fide</ets>.]</ety> <fld>(Bot.)</fld> <def>Sharply cut about halfway to the middle or base into five segments; <as>as, a <ex>quinquefid</ex> leaf or corolla</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquefoliated</ent><br/
<ent>Quinquefoliate</ent><br/
<mhw>{ <hw>Quin`que*fo"li*ate</hw> <pr>(?)</pr>, <hw>Quin`que*fo"li*a`ted</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>foliate</ets>, <ets>-ated</ets>: cf. F. <ets>quinqu<eacute/foli<eacute/</ets>, L. <ets>quinquefolius</ets>.]</ety> <fld>(Bot.)</fld> <def>Having five leaves or leaflets.</def>  <rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinque foliolate</ent><br/
<hw>Quin`que fo"li*o*late</hw> <pr>(?)</pr>, <pos>a.</pos> <fld>(Bot.)</fld> <def>Having five leaflets.</def>  <rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinqueliteral</ent><br/
<hw>Quin`que*lit"er*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>literal</ets>.]</ety> <def>Consisting of five letters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquelobared</ent><br/
<ent>Quinquelobate</ent><br/
<mhw>{ <hw>Quin`que*lo"bate</hw> <pr>(?)</pr>, <hw>Quin`que*lo"ba*red</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>lobate</ets>, <ets>-ated</ets>: cf. F. <ets>quinqu<eacute/lob<eacute/</ets>.]</ety> <def>Cut less than halfway into portions, usually somewhat rounded; five-lobed; <as>as, a <ex>quinquelobate</ex> leaf or corolla</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquelobed</ent><br/
<hw>Quin"que*lobed`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>lobe</ets>.]</ety> <def>Same as <er>Quinquelobate</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquelocular</ent><br/
<hw>Quin`que*loc"u*lar</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>locular</ets>: cf. F. <ets>quinqu<eacute/loculaire</ets>.]</ety> <def>Having five cells or loculi; five-celled; <as>as, a <ex>quinquelocular</ex> pericarp</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquenerved</ent><br/
<hw>Quin"que*nerved`</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>nerve</ets>.]</ety> <fld>(Bot.)</fld> <def>Having five nerves; -- said of a leaf with five nearly equal nerves or ribs rising from the end of the petiole.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquennalia</ent><br/
\'d8<hw>Quin`quen*na"li*a</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <ety>[L., fr. <ets>quinquennalis</ets>. See <er>Ouinquennial</er>.]</ety> <fld>(Rom. Antiq.)</fld> <def>Public games celebrated every five years.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquennial</ent><br/
<hw>Quin*quen"ni*al</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quinquennalis</ets> and <ets>quinquennis</ets>; <ets>quinque</ets> five + <ets>annus</ets> year. See <er>Five</er>, <ets>and cf</ets>. <er>Biennial</er>.]</ety> <def>Occurring once in five years, or at the end of every five years; also, lasting five years. A quinquennial event.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquennium</ent><br/
<hw>Quin*quen"ni*um</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L.]</ety> <def>Space of five years.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquepartite</ent><br/
<hw>Quin*quep"ar*tite</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quinquepartitus</ets>; <ets>quinque</ets> five + <ets>partitus</ets>, p. p. of <ets>partire</ets> to divide: cf. F. <ets>quinqu<eacute/partite</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Consisting of five parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>Divided into five parts almost to the base.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquereme</ent><br/
<hw>Quin"que*reme</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quinqueremis</ets>; <ets>quinque</ets> five + <ets>remus</ets> an oar: cf. F. <ets>quinqu<eacute/r<egrave/me</ets>]</ety> <def>A galley having five benches or banks of oars; <as>as, an Athenian <ex>quinquereme</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquesyllable</ent><br/
<hw>Quin"que*syl`la*ble</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Quinque-</ets> + <ets>syllable</ets>.]</ety> <def>A word of five syllables.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquevalvular</ent><br/
<ent>Quinquevalve</ent><br/
<mhw>{ <hw>Quin"que*valve</hw> <pr>(?)</pr>, <hw>Quin`que*val"vu*lar</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Quinque-</ets> + <ets>valve</ets>, <ets>valvular</ets>: cf. F. <ets>quinqu<eacute/valve</ets>.]</ety> <fld>(Bot.)</fld> <def>Having five valves, as a pericarp.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquevir</ent><br/
\'d8<hw>Quin"que*vir</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl; E. <plw>Quinquevirs</plw> <pr>(#)</pr>, L. <plw>Quinqueviri</plw> <pr>(#)</pr>.</plu> <ety>[L., fr. <ets>quinque</ets> Five + <ets>vir</ets> man.]</ety> <fld>(Bot. Antiq.)</fld> <def>One of five commissioners appointed for some special object.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquina</ent><br/
\'d8<hw>Quin*qui"na</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL. & F. See <er>Quinine</er>.]</ety> <def>Peruvian bark.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinquivalent</ent><br/
<hw>Quin*quiv"a*lent</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[<ets>Quinque-</ets> + L. <ets>valens</ets>, <ets>-entis</ets>, p. pr.  See <er>Valence</er>.]</ety> <fld>(Chem.)</fld> <def>Same as <er>Pentavalent</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinsy</ent><br/
<hw>Quin"sy</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Contr. fr. <ets>squinancy</ets>, F. <ets>esquinancie</ets>, L. <ets>cynanche</ets> a sort of sore throat, Gr. <?/ sore throat, dog quinsy, fr. <?/ dog + <?/ to choke; cf. also L. <ets>synanche</ets> sore throat, Gr. <?/.  Cf. <er>Hound</er>, <er>Anger</er>, and <er>Cynanche</er>.]</ety> <fld>(Med.)</fld> <def>An inflammation of the throat, or parts adjacent, especially of the fauces or tonsils, attended by considerable swelling, painful and impeded deglutition, and accompanied by inflammatory fever. It sometimes creates danger of suffocation; -- called also <altname>squinancy</altname>, and <altname>squinzey</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quint</ent><br/
<hw>Quint</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quinte</ets>, fr. L. <ets>quintus</ets>, <ets>quinta</ets>, the fifth, <ets>quinque</ets> five. See <er>Five</er>.]</ety> <sn>1.</sn> <def>A set or sequence of five, as in piquet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>The interval of a fifth.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>one of a set of <er>quintuplets</er>.</def> <mark>[informal]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Quintain</ent><br/
<hw>Quin"tain</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quintaine</ets>, LL. <ets>quintana</ets>; cf. W. <ets>chwintan</ets> a kind of hymeneal game.]</ety> <def>An object to be tilted at; -- called also <altname>quintel</altname>.</def> <altsp>[Written also <asp>quintin</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A common form in the Middle Ages was an upright post, on the top of which turned a crosspiece, having on one end a broad board, and on the other a sand bag. The endeavor was to strike the board with the lance while riding under, and get away without being hit by the sand bag. <ldquo/But a <xex>quintain</xex>, a mere lifeless block.<rdquo/</note>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintal</ent><br/
<hw>Quin"tal</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. Sp. <ets>quintal</ets>, fr. Ar. <ets>qintar</ets> a weight of 100 lbs., prob. fr. L. <ets>centenarius</ets> consisting of a hundred, fr. <ets>centeni</ets> a hundred each, fr. <ets>centum</ets> a hundred. See <er>Hundred</er>, and cf. <er>Kentle</er>.]</ety> <sn>1.</sn> <def>A hundredweight, either 112 or 100 pounds, according to the scale used.  Cf. <er>Cental</er>.</def> <altsp>[Sometimes written and pronounced <asp>kentle</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A metric measure of weight, being 100,000 grams, or 100 kilograms, equal to 220.46 pounds avoirdupois.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintan</ent><br/
<hw>Quin"tan</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quintanus</ets>, fr. <ets>quintus</ets> fifth, <ets>quinque</ets> five. See <er>Five</er>.]</ety> <def>Occurring as the fifth, after four others also, occurring every fifth day, reckoning inclusively; <as>as, a <ex>quintan</ex> fever</as>.</def> -- <def2><pos>n.</pos> <fld>(Med.)</fld> <def>An intermittent fever which returns every fifth day, reckoning inclusively, or in which the intermission lasts three days.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintel</ent><br/
<hw>Quin"tel</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Quintain</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintessence</ent><br/
<hw>Quin*tes"sence</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>quinta essentia</ets> fifth essence. See <er>Quint</er>, and <er>Essence</er>.]</ety> <sn>1.</sn> <def>The fifth or last and highest essence or power in a natural body. See <cref>Ferment oils</cref>, under <er>Ferment</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The ancient Greeks recognized four elements, fire, air, water, and earth. The Pythagoreans added a fifth and called it nether, the fifth essence, which they said flew upward at creation and out of it the stars were made. The alchemists sometimes considered alcohol, or the ferment oils, as the fifth essence.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence: An extract from anything, containing its rarest virtue, or most subtle and essential constituent in a small quantity; pure or concentrated essence.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let there be light, said God; and forthwith light<br/
Ethereal, first of things, <qex>quintessence</qex> pure,<br/
Sprung from the deep.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The most characteristic form or most perfect example of some type of object.</def><br/
[<source>PJC</source>]</p>

<p><ent>Quintessence</ent><br/
<hw>Quin*tes"sence</hw>, <pos>v. t.</pos> <def>To distil or extract as a quintessence; to reduce to a quintessence.</def> <mark>[R.]</mark> <au>Stirling.</au> <ldquo/Truth <xex>quintessenced</xex> and raised to the highest power.<rdquo/  <rj><au>J. A. Symonds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintessential</ent><br/
<hw>Quin`tes*sen"tial</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Of the nature of a quintessence; purest; most characteristic.</def> <ldquo/<xex>Quintessential</xex> extract of mediocrity.<rdquo/  <rj><au>G. Eliot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintette</ent><br/
<ent>Quintet</ent><br/
<mhw>{ <hw>Quin*tet"</hw>, <hw>Quin*tette"</hw>  }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. <ets>quintetto</ets>, dim. of <ets>quinto</ets> the fifth, a fifth part, from L. <ets>quintus</ets> the fifth: cf. F. <ets>quintette</ets>. See <er>Quint</er>.]</ety> <fld>(Mus.)</fld> <def>A composition for five voices or instruments; also, the set of five persons who sing or play five-part music.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintic</ent><br/
<hw>Quin"tic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quintus</ets> fifth, fr. <ets>quinque</ets> five.]</ety> <fld>(Alg.)</fld> <def>Of the fifth degree or order.</def> -- <def2><pos>n.</pos> <fld>(Alg.)</fld> <def>A quantic of the fifth degree. See <er>Quantic</er>.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintile</ent><br/
<hw>Quin"tile</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F. <ets>quintil aspect</ets>, fr. L. <ets>quintus</ets> the fifth.]</ety> <fld>(Astron.)</fld> <def>The aspect of planets when separated the fifth part of the zodiac, or 72<deg/.</def>
<-- sic.  not separated "by" -->  <rj><au>Hutton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintilllion</ent><br/
<hw>Quin*till"lion</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Formed fr. L. <ets>quintus</ets> the fifth, after the analogy of <ets>million</ets>: cf. F. <ets>quintillion</ets>. See <er>Quint</er>.]</ety> <def>According to the French notation, which is used on the Continent and in America, the cube of a million, or a unit with eighteen ciphers annexed; according to the English notation, a number produced by involving a million to the fifth power, or a unit with thirty ciphers annexed. See the Note under <er>Numeration</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintin</ent><br/
<hw>Quin"tin</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Quintain</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintine</ent><br/
<hw>Quin"tine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[L. <ets>quintus</ets> the fifth: cf. F. <ets>quintine</ets>.]</ety> <fld>(Bot.)</fld> <def>The embryonic sac of an ovule, sometimes regarded as an innermost fifth integument.  Cf. <er>Quartine</er>, and <er>Tercine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintole</ent><br/
<hw>Quin"tole</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[It. <ets>quinto</ets> fifth.]</ety> <fld>(Mus.)</fld> <def>A group of five notes to be played or sung in the time of four of the same species.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintroon</ent><br/
<hw>Quin*troon"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp. <ets>quinteron</ets> the off-spring of a quadroon and a white.]</ety> <fld>(Ethnol.)</fld> <def>The off-spring of an octoroon and a white person.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quintuple</ent><br/
<hw>Quin"tu*ple</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[L. <ets>quintus</ets> fifth: cf. F. <ets>quintuple</ets>, L. <ets>quintuplex</ets>.  Cf. <er>Quadruple</er>.]</ety> <def>Multiplied by five; increased to five times the amount; fivefold.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quintuple time</b></col> <fld>(Mus.)</fld>, <cd>a time having five beats in a measure. It is seldom used.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintuple</ent><br/
<hw>Quin"tu*ple</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quintupled</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quintupling</conjf>.]</vmorph> <ety>[Cf. F. <ets>quintupler</ets>.]</ety> <def>To make fivefold, or five times as much or many.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quintuplet</ent><br/
<hw>Quin"tu*plet</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[From <er>Quintuple</er>.]</ety> <sn>1.</sn> <def>A collection or combination of five of a kind.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn>  <pluf>pl.</pluf> <def>Five children born in the same labor.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn>  <fld>(Mus.)</fld> <def>A group of five connected notes; a turn of five notes.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>4.</sn>  <def>A cycle having five crank shafts and adapted for five riders, all of whom can assist in the propulsion.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quintuplets</ent><br/
<hw>Quin*tup"lets</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>five children born from one mother in a single pregnancy.</def><br/
[<source>PJC</source>]</p>

<p><ent>Quintuple-ribbed</ent><br/
<ent>Quintuple-nerved</ent><br/
<mhw>{ <hw>Quin"tu*ple-nerved`</hw> <pr>(?)</pr>, <hw>Quin"tu*ple-ribbed`</hw> <pr>(?)</pr>, }</mhw> <pos>a.</pos> <fld>(Bot.)</fld> <def>The same as <er>Quinquenerved</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinzaine</ent><br/
<hw>Quin"zaine</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., from <ets>quinze</ets> fifteen, L. <ets>quindecim</ets>. See <er>Fifteen</er>.]</ety> <def>The fifteenth day after a feast day, including both in the reckoning.</def> <altsp>[Written also <asp>quinzain</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quinze</ent><br/
<hw>Quinze</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A game at cards in which the object is to make fifteen points.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quip</ent><br/
<hw>Quip</hw> <pr>(kw<icr/p)</pr>, <pos>n.</pos> <ety>[Cf. W. <ets>chwip</ets> a quick flirt or turn, <ets>chwipio</ets> to whip, to move briskly, and E. <ets>whip</ets>.  Cf. <er>Quib</er>, <er>Quibble</er>.]</ety> <sn>1.</sn> <def>A smart, sarcastic turn or jest; a taunt; a severe retort; a gibe.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Quips</qex>, and cranks, and wanton wiles.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He was full of joke and jest,<br/
But all his merry <qex>quips</qex> are o'er.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A short humorous or witty comment or observation, usually spontaneously formed in response to a prior comment.</def><br/
[<source>PJC</source>]</p>

<p><ent>Quip</ent><br/
<hw>Quip</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quipped</conjf> <pr>(?)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quipping</conjf> <pr>(?)</pr>.]</vmorph> <def>To taunt; to treat with quips.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The more he laughs, and does her closely <qex>quip</qex>.</q> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quip</ent><br/
<hw>Quip</hw>, <pos>v. i.</pos> <def>To scoff; to use taunts.</def>  <rj><au>Sir H. Sidney.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quipo</ent><br/
<hw>Qui"po</hw> <pr>(?)</pr>, <pos>n.</pos> <def>Same as <er>Quipu</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>quipster</ent><br/
<hw>quip"ster</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A person who frequently makes quips.</def><br/
[<source>PJC</source>]</p>

<p><ent>Quipu</ent><br/
\'d8<hw>Qui"pu</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Quipus</plw> <pr>(#)</pr>.</plu> <ety>[Peruv. <ets>quipu</ets> a knot.]</ety> <def>A contrivance employed by the ancient Peruvians, Mexicans, etc., as a substitute for writing and figures, consisting of a main cord, from which hung at certain distances smaller cords of various colors, each having a special meaning, as silver, gold, corn, soldiers. etc. Single, double, and triple knots were tied in the smaller cords, representing definite numbers. It was chiefly used for arithmetical purposes, and to register important facts and events.</def> <altsp>[Written also <asp>quipo</asp>.]</altsp> <au>Tylor.</au><br/
[<source>1913 Webster</source>]</p>

<p><q>The mysterious science of the <qex>quipus</qex> . . . supplied the Peruvians with the means of communicating their ideas to one another, and of transmitting them to future generations.</q> <rj><qau>Prescott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirboilly</ent><br/
<hw>Quir"boil*ly`</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OE. <ets>cuir bouilli</ets>.]</ety> <def>Leather softened by boiling so as to take any required shape. Upon drying, it becomes exceedingly hard, and hence was formerly used for armor.</def> <mark>[Obs.]</mark> <ldquo/His jambeux were of <xex>quyrboilly</xex>.<rdquo/  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quire</ent><br/
<hw>Quire</hw> <pr>(?)</pr>, <pos>n.</pos> <def>See <er>Choir</er>.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>quire</qex> of such enticing birds.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quire</ent><br/
<hw>Quire</hw>, <pos>v. i.</pos> <def>To sing in concert.</def> <mark>[R.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1180 --></p>

<p><ent>Quire</ent><br/
<hw>Quire</hw> <pr>(kw<imac/r)</pr>, <pos>n.</pos> <ety>[OE. <ets>quaer</ets>, <ets>quair</ets>, OF. <ets>quayer</ets>, <ets>cayer</ets>, <ets>ca<ium/er</ets>, F. <ets>cahier</ets>, a book of loose sheets, a quarter of a quire, LL. <ets>quaternus</ets>, <ets>quaternum</ets>, sheets of paper packed together, properly, four together, fr. L. <ets>quaterni</ets> four each, by fours, <ets>quattuor</ets> four.  See <er>Four</er> and cf. <er>Cahier</er>.]</ety> <def>A collection of twenty-four sheets of paper of the same size and quality, unfolded or having a single fold; one twentieth of a ream.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirinal</ent><br/
<hw>Quir"i*nal</hw> <pr>(kw<icr/r"<icr/*n<ait/l <it>or</it> kw<icr/`r<imac/"n<ait/l)</pr>, <pos>a.</pos> <ety>[L. <ets>Quirinalis</ets>, fr. <ets>Quirinus</ets>, a name of Romulus.]</ety> <def>Of, pertaining to, or designating, the hill <xex>Collis Quirinalis</xex>, now <xex>Monte Quirinale</xex> (one of the seven hills of Rome), or a modern royal place situated upon it. Also used substantively.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Quirister</ent><br/
<hw>Quir"is*ter</hw> <pr>(kw<icr/r"<icr/s*t<etil/r)</pr>, <pos>n.</pos> <ety>[See <er>Quire</er>, <er>Chorister</er>.]</ety> <def>A chorister. See <er>Chorister</er>.</def> <mark>[R.]</mark>  <rj><au>Thomson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiritation</ent><br/
<hw>Quir`i*ta"tion</hw> <pr>(kw<icr/r`<icr/*t<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[L. <ets>quiritatio</ets>, fr. <ets>quiritare</ets> to raise a plaintive cry, v. freq. fr. <ets>queri</ets> to complain.]</ety> <def>A crying for help.</def> <mark>[Obs.]</mark>  <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirite</ent><br/
<hw>Qui"rite</hw> <pr>(kw<imac/"r<imac/t)</pr>, <pos>n.</pos> <def>One of the Quirites.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirites</ent><br/
\'d8<hw>Qui*ri"tes</hw> <pr>(kw<icr/*r<imac/"t<emac/z)</pr>, <pos>n. pl.</pos> <ety>[L., fr. <ets>Cures</ets>, a Sabine town.]</ety> <fld>(Rom. Antiq.)</fld> <def>Roman citizens.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ After the Sabines and Romans had united themselves into one community, under Romulus, the name of <xex>Quirites</xex> was taken in addition to that of <xex>Romani</xex>, the Romans calling themselves in a civil capacity <xex>Quirites</xex>, while in a political and military capacity they retained the name of <xex>Romani</xex>.</note>  <rj><au>Andrews.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirk</ent><br/
<hw>Quirk</hw> <pr>(kw<etil/rk)</pr>, <pos>n.</pos> <altsp>[Written also <asp>querk</asp>.]</altsp> <ety>[Cf. W. <ets>chwiori</ets> to turn briskly, or E. <ets>queer</ets>.]</ety> <sn>1.</sn> <def>A sudden turn; a starting from the point or line; hence, an artful evasion or subterfuge; a shift; a quibble; <as>as, the <ex>quirks</ex> of a pettifogger</as>.</def> <ldquo/Some <xex>quirk</xex> or . . . evasion.<rdquo/  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We ground the justification of our nonconformity on dark subtilties and intricate <qex>quirks</qex>.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A fit or turn; a short paroxysm; a caprice.</def> <mark>[Obs.]</mark> <ldquo/<xex>Quirks</xex> of joy and grief.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A smart retort; a quibble; a shallow conceit.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some odd <qex>quirks</qex> and remnants of wit.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An irregular air; <as>as, light <ex>quirks</ex> of music</as>.</def>  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Building)</fld> <def>A piece of ground taken out of any regular ground plot or floor, so as to make a court, yard, etc.; -- sometimes written <xex>quink</xex>.</def>  <rj><au>Gwilt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Arch.)</fld> <def>A small channel, deeply recessed in proportion to its width, used to insulate and give relief to a convex rounded molding.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quirk molding</b></col>, <cd>a bead between two quirks.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirked</ent><br/
<hw>Quirked</hw> <pr>(kw<etil/rkt)</pr>, <pos>a.</pos> <def>Having, or formed with, a quirk or quirks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirkish</ent><br/
<hw>Quirk"ish</hw> <pr>(kw<etil/rk"<icr/sh)</pr>, <pos>a.</pos> <def>Consisting of quirks; resembling a quirk.</def>  <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirky</ent><br/
<hw>Quirk"y</hw> <pr>(kw<etil/rk"<ycr/)</pr>, <pos>a.</pos> <def>Full of quirks; tricky; <as>as, a <ex>quirky</ex> lawyer</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirl</ent><br/
<hw>Quirl</hw> <pr>(kw<etil/rl)</pr>, <pos>n. & v.</pos> <def>See <er>Querl</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirpele</ent><br/
<hw>Quir"pele</hw> <pr>(kw<etil/r"p<emac/l)</pr>, <pos>n.</pos> <ety>[Tamil <ets>k<imac/rippi<lsdot/<lsdot/ai</ets>.]</ety> <fld>(Zool.)</fld> <def>The Indian ferret.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quirt</ent><br/
<hw>Quirt</hw> <pr>(kw<etil/rt)</pr>, <pos>n.</pos> <def>A rawhide whip plaited with two thongs of buffalo hide.</def>  <rj><au>T. Roosevelt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quish</ent><br/
<hw>Quish</hw> <pr>(kw<icr/sh)</pr>, <pos>n.</pos> <def>See <er>Cuish</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quit</ent><br/
<hw>Quit</hw> <pr>(kw<icr/t)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>Any one of numerous species of small passerine birds native of tropical America. See <cref>Banana quit</cref>, under <er>Banana</er>, and <er>Guitguit</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quit</ent><br/
<hw>Quit</hw> <pr>(kw<icr/t)</pr>, <pos>a.</pos> <ety>[OE. <ets>quite</ets>, OF. <ets>quite</ets>, F. <ets>quitte</ets>. See <er>Quit</er>, <pos>v.</pos>, <er>Quiet</er>.]</ety> <def>Released from obligation, charge, penalty, etc.; free; clear; absolved; acquitted.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The owner of the ox shall be <qex>quit</qex>.</q> <rj><qau>Ex. xxi. 28.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This word is sometimes used in the form <xex>quits</xex>, colloquially; as, to be <xex>quits</xex> with one, that is, to have made mutual satisfaction of demands with him; to be even with him; hence, as an exclamation: <xex>Quits</xex>! we are even, or on equal terms. <ldquo/To cry <xex>quits</xex> with the commons in their complaints.<rdquo/</note>  <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quit</ent><br/
<hw>Quit</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quit</conjf> or <conjf>Quitted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Quitting</conjf>.]</vmorph> <ety>[OE. <ets>quiten</ets>, OF. <ets>quiter</ets>, <ets>quitier</ets>, <ets>cuitier</ets>, F. <ets>quitter</ets>, to acquit, quit, LL. <ets>quietare</ets>, fr. L. <ets>quietare</ets> to calm, to quiet, fr. <ets>quietus</ets> quiet. See <er>Quiet</er>, <pos>a.</pos>, and cf. <er>Quit</er>, <pos>a.</pos>, <er>Quite</er>, <er>Acquit</er>, <er>Requite</er>.]</ety> <sn>1.</sn> <def>To set at rest; to free, as from anything harmful or oppressive; to relieve; to clear; to liberate.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>quit</qex> you of this fear, you have already looked Death in the face; what have you found so terrible in it?</q> <rj><qau>Wake.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To release from obligation, accusation, penalty, or the like; to absolve; to acquit.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There may no gold them <qex>quyte</qex>.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>God will relent, and <qex>quit</qex> thee all his debt.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To discharge, as an obligation or duty; to meet and satisfy, as a claim or debt; to make payment for or of; to requite; to repay.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The blissful martyr <qex>quyte</qex> you your meed.</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Enkindle all the sparks of nature<br/
To <qex>quit</qex> this horrid act.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Before that judge that <qex>quits</qex> each soul his hire.</q> <rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To meet the claims upon, or expectations entertained of; to conduct; to acquit; -- used reflexively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Be strong, and <qex>quit</qex> yourselves like men.</q> <rj><qau>1 Sam. iv. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Samson hath <qex>quit</qex> himself<br/
Like Samson.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To carry through; to go through to the end.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Never worthy prince a day did <qex>quit</qex><br/
With greater hazard and with more renown.</q> <rj><qau>Daniel.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To have done with; to cease from; to stop; hence, to depart from; to leave; to forsake; <as>as, to <ex>quit</ex> work; to <ex>quit</ex> the place; to <ex>quit</ex> jesting.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Such a superficial way of examining is to <qex>quit</qex> truth for appearance.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To quit cost</b></col>, <cd>to pay; to reimburse.</cd> -- <col><b>To quit scores</b></col>, <cd>to make even; to clear mutually from demands.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>Does not the earth <qex>quit scores</qex> with all the elements in the noble fruits that issue from it?</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To leave; relinquish; resign; abandon; forsake; surrender; discharge; requite.</syn> <usage> -- <er>Quit</er>, <er>Leave</er>. <xex>Leave</xex> is a general term, signifying merely an act of departure; <xex>quit</xex> implies a going without intention of return, a final and absolute abandonment.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quit</ent><br/
<hw>Quit</hw>, <pos>v. i.</pos> <def>To go away; to depart; to stop doing a thing; to cease.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quitch</ent><br/
<hw>Quitch</hw> <pr>(kw<icr/ch)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Bot.)</fld> <def>Same as <er>Quitch grass</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Figuratively: A vice; a taint; an evil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To pick the vicious <qex>quitch</qex><br/
Of blood and custom wholly out of him.</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quitch grass</ent><br/
<hw>Quitch" grass`</hw> <pr>(kw<icr/ch" gr<adot/s`)</pr>. <ety>[Properly <ets>quick grass</ets>, being probably so called from its vigorous growth, or from its tenacity of life. See <er>Quick</er>, and cf. <er>Couch grass</er>.]</ety> <fld>(Bot.)</fld> <def>A perennial grass (<spn>Agropyrum repens</spn>) having long running rootstalks, by which it spreads rapidly and pertinaciously, and so becomes a troublesome weed. Also called <altname>couch grass</altname>, <altname>quack grass</altname>, <altname>quick grass</altname>, <altname>twitch grass</altname>. See <xex>Illustration</xex> in Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quitclaim</ent><br/
<hw>Quit"claim`</hw> <pr>(kw<icr/t"kl<amac/m`)</pr>, <pos>n.</pos> <ety>[<ets>Quit</ets>, a. + <ets>claim</ets>.]</ety> <fld>(Law)</fld> <def>A release or relinquishment of a claim; a deed of release; an instrument by which some right, title, interest, or claim, which one person has, or is supposed to have, in or to an estate held by himself or another, is released or relinquished, the grantor generally covenanting only against persons who claim under himself.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quitclaim</ent><br/
<hw>Quit"claim`</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quitclaimed</conjf> <pr>(kw<icr/t"kl<amac/md`)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quitclaiming</conjf>.]</vmorph> <fld>(Law)</fld> <def>To release or relinquish a claim to; to release a claim to by deed, without covenants of warranty against adverse and paramount titles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quite</ent><br/
<hw>Quite</hw> <pr>(kw<imac/t)</pr>, <pos>v. t. & i.</pos> <def>See <er>Quit</er>.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quite</ent><br/
<hw>Quite</hw> <pr>(kw<imac/t)</pr>, <pos>adv.</pos> <ety>[F. <ets>quitte</ets> discharged, free, clear; cf. OF. <ets>quitement</ets> freely, frankly, entirely. See <er>Quit</er>, <pos>a.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Completely; wholly; entirely; totally; perfectly; <as>as, the work is not <ex>quite</ex> done; the object is <ex>quite</ex> accomplished; to be <ex>quite</ex> mistaken.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><q>Man shall not <qex>quite</qex> be lost, but saved who will.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The same actions may be aimed at different ends, and arise from <qex>quite</qex> contrary principles.</q> <rj><qau>Spectator.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To a great extent or degree; very; very much; considerably.</def> <ldquo/<xex>Quite</xex> amusing.<rdquo/  <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>He really looks <qex>quite</qex> concerned.</q> <rj><qau>Landor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The island stretches along the land and is <qex>quite</qex> close to it.</q> <rj><qau>Jowett (Thucyd. ).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quitly</ent><br/
<hw>Quit"ly</hw> <pr>(kw<icr/t"l<ycr/)</pr>, <pos>adv.</pos> <def>Quite.</def> <mark>[Obs.]</mark>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quitrent</ent><br/
<hw>Quit"rent`</hw> <pr>(kw<icr/t"r<ecr/nt`)</pr>, <pos>n.</pos> <ety>[<ets>Quit</ets>, a. + <ets>rent</ets>.]</ety> <fld>(Law)</fld> <def>A rent reserved in grants of land, by the payment of which the tenant is quit from other service.</def>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In some of the United States a fee-farm rent is so termed.</note>  <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quits</ent><br/
<hw>Quits</hw> <pr>(kw<icr/ts)</pr>, <pos>interj.</pos> <def>See the Note under <er>Quit</er>, <pos>a.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quittable</ent><br/
<hw>Quit"ta*ble</hw> <pr>(kw<icr/t"t<adot/*b'l)</pr>, <pos>a.</pos> <def>Capable of being quitted.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quittal</ent><br/
<hw>Quit"tal</hw> <pr>(kw<icr/t"t<ait/l)</pr>, <pos>n.</pos> <def>Return; requital; quittance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quittance</ent><br/
<hw>Quit"tance</hw> <pr>(kw<icr/t"t<ait/ns)</pr>, <pos>n.</pos> <ety>[OE. <ets>quitaunce</ets>, OF. <ets>quitance</ets>, F. <ets>quittance</ets>. See <er>Quit</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>Discharge from a debt or an obligation; acquittance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Omittance is no <qex>quittance</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Recompense; return; repayment.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quittance</ent><br/
<hw>Quit"tance</hw>, <pos>v. t.</pos> <def>To repay; to requite.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quitter</ent><br/
<hw>Quit"ter</hw> <pr>(kw<icr/t"t<etil/r)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One who quits.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A deliverer.</def> <mark>[Obs.]</mark>  <rj><au>Ainsworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quittor</ent><br/
<hw>Quit"tor</hw> <pr>(kw<icr/t"t<etil/r)</pr>, <pos>n.</pos> <ety>[Perhaps for <ets>quitture</ets>.]</ety> <fld>(Far.)</fld> <def>A chronic abscess, or fistula of the coronet, in a horse's foot, resulting from inflammation of the tissues investing the coffin bone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quitture</ent><br/
<hw>Quit"ture</hw> <pr>(kw<icr/t"t<usl/r; 135)</pr>, <pos>n.</pos> <def>A discharge; an issue.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>To cleanse the <qex>quitture</qex> from thy wound.</q> <rj><qau>Chapman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiver</ent><br/
<hw>Quiv"er</hw> <pr>(kw<icr/v"<etil/r)</pr>, <pos>a.</pos> <ety>[Akin to AS. <ets>cwiferlice</ets> anxiously; cf. OD. <ets>kuiven</ets>, <ets>kuiveren</ets>.  Cf. <er>Quaver</er>.]</ety> <def>Nimble; active.</def> <mark>[Obs.]</mark> <ldquo/ A little <xex>quiver</xex> fellow.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiver</ent><br/
<hw>Quiv"er</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quivered</conjf> <pr>(kw<icr/v"<etil/rd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quivering</conjf>.]</vmorph> <ety>[Cf. <er>Quaver</er>.]</ety> <def>To shake or move with slight and tremulous motion; to tremble; to quake; to shudder; to shiver.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The green leaves <qex>quiver</qex> with the cooling wind.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>And left the limbs still <qex>quivering</qex> on the ground.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiver</ent><br/
<hw>Quiv"er</hw>, <pos>n.</pos> <def>The act or state of quivering; a tremor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiver</ent><br/
<hw>Quiv"er</hw>, <pos>n.</pos> <ety>[OF. <ets>cuivre</ets>, <ets>cuevre</ets>, <ets>coivre</ets>, LL. <ets>cucurum</ets>, fr. OHG. <ets>chohh<amac/ri</ets> quiver, receptacle, G. <ets>k<oum/cher</ets> quiver; akin to AS. <ets>cocor</ets>, <ets>cocur</ets>, <ets>cocer</ets>, D. <ets>koker</ets>.  Cf. <er>Cocker</er> a high shoe.]</ety> <def>A case or sheath for arrows to be carried on the person.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Beside him hung his bow<br/
And <qex>quiver</qex>, with three-bolted thunder stored.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quivered</ent><br/
<hw>Quiv"ered</hw> <pr>(kw<icr/v"<etil/rd)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Furnished with, or carrying, a quiver.</def> <ldquo/Like a <xex>quivered</xex> nymph with arrows keen.<rdquo/  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Sheathed, as in a quiver.</def> <ldquo/Whose quills stand <xex>quivered</xex> at his ear.<rdquo/  <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiveringly</ent><br/
<hw>Quiv"er*ing*ly</hw> <pr>(kw<icr/v"<etil/r*<icr/ng*l<ycr/)</pr>, <pos>adv.</pos> <def>With quivering motion.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Qui vive</ent><br/
\'d8<hw>Qui` vive"</hw> <pr>(k<esl/` v<esl/v")</pr>. <ety>[F., fr. <ets>qui</ets> who + <ets>vive</ets>, pres. subj. of <ets>vivre</ets> to live.]</ety> <def>The challenge of a French sentinel, or patrol; -- used like the English challenge: <ldquo/Who comes there?<rdquo/</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To be on the qui vive</b></col>, <cd>to be on guard; to be watchful and alert, like a sentinel.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quixotic</ent><br/
<hw>Quix*ot"ic</hw> <pr>(kw<icr/ks*<ocr/t"<icr/k)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Like <person>Don Quixote</person>; romantic to extravagance; prone to pursue unrealizable goals; absurdly chivalric; apt to be deluded.   See also <er>quixotism</er>.</def> <ldquo/Feats of <xex>quixotic</xex> gallantry.<rdquo/  <rj><au>Prescott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Like the deeds of <person>Don Quixote</person>; ridiculously impractical; unachievable; extravagantly romantic; doomed to failure; <as>as, a <ex>quixotic</ex> quest</as>.</def><br/
[<source>PJC</source>]</p>

<p><q>The word <ldquo/<qex>quixotic</qex><rdquo/ . . . has entered the common language, with the meaning <ldquo/hopelessly naive and idealistic,<rdquo/ <ldquo/ridiculously impractical,<rdquo/ <ldquo/doomed to fail.<rdquo/   That this epithet can be used now in an exclusively pejorative sense not only shows that we have ceased to read <persfn>Cervantes</persfn> and to understand his character, but more fundamentally it reveals that our culture has drifted away from its spiritual roots.</q>  <rj><qau>Simon Leys (N. Y. Review of Books, June 11, 1998, p. 35)</qau></rj><br/
[<source>PJC</source>]</p>

<p><ent>Quixotically</ent><br/
<hw>Quix*ot"ic*al*ly</hw> <pr>(kw<icr/ks*<ocr/t"<icr/*k<ait/l*l<ycr/)</pr>, <pos>adv.</pos> <def>In a quixotic way.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quixotism</ent><br/
<hw>Quix"ot*ism</hw> <pr>(kw<icr/ks"<ocr/t*<icr/z'm)</pr>, <pos>n.</pos> <def>That form of delusion which leads to extravagant and absurd undertakings or sacrifices in obedience to a morbidly romantic ideal of duty or honor, as illustrated by the exploits of <person>Don Quixote</person> in knight-errantry.  See <er>quixotic</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quixotry</ent><br/
<hw>Quix"ot*ry</hw> <pr>(kw<icr/ks"<ocr/t*r<ycr/)</pr>, <pos>n.</pos> <def>Quixotism; visionary schemes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiz</ent><br/
<hw>Quiz</hw> <pr>(kw<icr/z)</pr>, <pos>n.</pos> <ety>[It is said that Daly, the manager of a Dublin playhouse, laid a wager that a new word of no meaning should be the common talk and puzzle of the city in twenty-four hours. In consequence of this the letters <ets>q u i z</ets> were chalked by him on all the walls of Dublin, with an effect that won the wager. Perhaps, however, originally a variant of <ets>whiz</ets>, and formerly the name of a popular game.]</ety> <sn>1.</sn> <def>A riddle or obscure question; an enigma; a ridiculous hoax.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who quizzes others; <as>as, he is a great <ex>quiz</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An odd or absurd fellow.</def>  <rj><au>Smart. Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An exercise, or a course of exercises, conducted as a coaching or as an examination.</def> <mark>[Cant, U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiz</ent><br/
<hw>Quiz</hw> <pr>(kw<icr/z)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quizzed</conjf> <pr>(kw<icr/zd)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Quizzing</conjf> <pr>(kw<icr/z"z<icr/ng)</pr>.]</vmorph> <sn>1.</sn> <def>To puzzle; to banter; to chaff or mock with pretended seriousness of discourse; to make sport of, as by obscure questions.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>quizzed</qex> unmercifully all the men in the room.</q> <rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To peer at; to eye suspiciously or mockingly.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To instruct in or by a quiz. See <er>Quiz</er>, <pos>n.</pos>, 4.</def> <mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quizzing glass</b></col>, <cd>a small eyeglass.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quiz</ent><br/
<hw>Quiz</hw> <pr>(kw<icr/z)</pr>, <pos>v. i.</pos> <def>To conduct a quiz. See <er>Quiz</er>, <pos>n.</pos>, 4.</def> <mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quizzer</ent><br/
<hw>Quiz"zer</hw> <pr>(kw<icr/z"z<etil/r)</pr>, <pos>n.</pos> <def>One who quizzes; a quiz.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quizzical</ent><br/
<hw>Quiz"zic*al</hw> <pr>(kw<icr/z"z<icr/*k<ait/l)</pr>, <pos>a.</pos> <def>Relating to quizzing; given to quizzing; of the nature of a quiz; farcical; sportive.</def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Quiz"zic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quizzism</ent><br/
<hw>Quiz"zism</hw> <pr>(kw<icr/z"z<icr/z'm)</pr>, <pos>n.</pos> <def>The act or habit of quizzing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quob</ent><br/
<hw>Quob</hw> <pr>(kw<ocr/b)</pr>, <pos>v. i.</pos> <ety>[Cf. <er>Quaver</er>.]</ety> <altsp>[Written also <asp>quop</asp> and <asp>quab</asp>.]</altsp> <def>To throb; to quiver.</def> <mark>[Local & Vulgar]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quod</ent><br/
<hw>Quod</hw> <pr>(kw<ocr/d)</pr>, <pos>n.</pos> <ety>[For <ets>quad</ets>, abbrev. of <ets>quadrangle</ets>.]</ety> <def>A quadrangle or court, as of a prison; hence, a prison.</def> <mark>[Slang]</mark>  <ldquo/Flogged or whipped in <xex>quod</xex>.<rdquo/  <rj><au>T. Hughes.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quod</ent><br/
<hw>Quod</hw>, <pos>v.</pos> <def>Quoth; said. See <er>Quoth</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><ldquo/Let be,<rdquo/ <qex>quod</qex> he, <ldquo/it shall not be.<rdquo/</q> <rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quod</ent><br/
<hw>Quod</hw> <pr>(kw<ocr/d)</pr>, <pos>v. t.</pos> <def>To put in quod, or prison; to lock up; to jug.</def> <mark>[Slang]</mark>  <rj><au>Kipling.</au></rj></p>

<p><ent>Quoddies</ent><br/
<hw>Quod"dies</hw> <pr>(kw<ocr/d"d<icr/z)</pr>, <pos>n. pl.</pos> <def>Herring taken and cured or smoked near Quoddy Head, Maine, or near the entrance of Passamaquoddy Bay.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quodlibet</ent><br/
\'d8<hw>Quod"li*bet</hw> <pr>(kw<ocr/d"l<icr/*b<ecr/t)</pr>, <pos>n.</pos> <ety>[L., what you please.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A nice point; a subtilty; a debatable point.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These are your <qex>quodlibets</qex>, but no learning.</q> <rj><qau>P. Fletcher.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <def>A medley improvised by several performers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quodlibetarian</ent><br/
<hw>Quod`lib*e*ta"ri*an</hw> <pr>(kw<ocr/d"l<icr/b*<esl/*t<amac/"r<icr/*<ait/n)</pr>, <pos>n.</pos> <def>One who discusses any subject at pleasure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quodlibetical</ent><br/
<hw>Quod`li*bet"ic*al</hw> <pr>(kw<ocr/d"l<icr/*b<ecr/t"<icr/*k<ait/l)</pr>, <pos>a.</pos> <def>Not restricted to a particular subject; discussed for curiosity or entertainment.</def> -- <wordforms><wf>Quod`li*bet"ic*al*ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoif</ent><br/
<hw>Quoif</hw> <pr>(kwoif <or/ koif)</pr>, <pos>n. & v. t.</pos> <def>See <er>Coif</er>.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoiffure</ent><br/
<hw>Quoif"fure</hw> <pr>(kwoif"f<usl/r <or/ koif"f<usl/r)</pr>, <pos>n.</pos> <def>See <er>Coiffure</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoil</ent><br/
<hw>Quoil</hw> <pr>(kwoil <or/ koil)</pr>, <pos>n.</pos> <def>See <er>Coil</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoin</ent><br/
<hw>Quoin</hw> <pr>(kwoin <or/ koin; 277)</pr>, <pos>n.</pos> <ety>[See <er>Coin</er>, and cf. <er>Coigne</er>.]</ety> <sn>1.</sn> <fld>(Arch.)</fld> <def>Originally, a solid exterior angle, as of a building; now, commonly, one of the selected pieces of material by which the corner is marked.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In stone, the quoins consist of blocks larger than those used in the rest of the building, and cut to dimension. In brickwork, quoins consist of groups or masses of brick laid together, and in a certain imitation of quoins of stone.</note><br/
[<source>1913 Webster</source>]</p>

<p><-- ### the various "subdefs" here require the introductory part definition to be complete -->
<sn>2.</sn> <def>A wedgelike piece of stone, wood, metal, or other material, used for various purposes;</def> <specif>as:</specif> <sd>(a)</sd> <fld>(Masonry)</fld> <def>To support and steady a stone.</def> <sd>(b)</sd> <fld>(Gun.)</fld> <def>To support the breech of a cannon.</def> <sd>(c)</sd> <fld>(Print.)</fld> <def>To wedge or lock up a form within a chase.</def> <sd>(d)</sd> <fld>(Naut.)</fld> <def>To prevent casks from rolling.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Hollow quoin</b></col>. <cd>See under <er>Hollow</er>.</cd> -- <col><b>Quoin post</b></col> <fld>(Canals)</fld>, <cd>the post of a lock gate which abuts against the wall.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoit</ent><br/
<hw>Quoit</hw> <pr>(kwoit <or/ koit)</pr>, <pos>n.</pos> <ety>[OE. <ets>coite</ets>; cf. OF. <ets>coitier</ets> to spur, press, (assumed) LL. <ets>coctare</ets>, fr. L. <ets>coquere</ets>, <ets>coctum</ets>, to cook, burn, vex, harass, E. <ets>cook</ets>, also W. <ets>coete<?/</ets> a quoit.]</ety> <sn>1.</sn> <sd>(a)</sd> <def>A flattened ring-shaped piece of iron, to be pitched at a fixed object in play; hence, any heavy flat missile used for the same purpose, as a stone, piece of iron, etc.</def> <sd>(b)</sd> <pluf>pl.</pluf> <def>A game played with quoits.</def>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The discus of the ancients. See <er>Discus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A cromlech.</def> <mark>[Prov. Eng.]</mark>  <rj><au>J. Morley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoit</ent><br/
<hw>Quoit</hw>, <pos>v. i.</pos> <def>To throw quoits; to play at quoits.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>quoit</qex>, to run, and steeds and chariots drive.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoit</ent><br/
<hw>Quoit</hw>, <pos>v. t.</pos> <def>To throw; to pitch.</def> <mark>[Obs. or R.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoke</ent><br/
<hw>Quoke</hw> <pr>(kw<omac/k)</pr>, <mark>obs.</mark> <def><pos>imp.</pos> of <er>Quake</er>.</def>  <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoll</ent><br/
<hw>Quoll</hw> <pr>(kw<ocr/l)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A marsupial of <country>Australia</country> (<spn>Dasyurus macrurus</spn>), about the size of a cat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quondam</ent><br/
<hw>Quon"dam</hw> <pr>(kw<ocr/n"d<acr/m)</pr>, <pos>a.</pos> <ety>[L., formerly.]</ety> <def>Having been formerly; former; sometime.</def> <ldquo/This is the <xex>quondam</xex> king.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quondam</ent><br/
<hw>Quon"dam</hw>, <pos>n.</pos> <def>A person dismissed or ejected from a position.</def> <mark>[R.]</mark> <ldquo/Make them <xex>quondams</xex>; . . . cast them out of their office.<rdquo/  <rj><au>Latimer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quook</ent><br/
<hw>Quook</hw> <pr>(kw<oocr/k)</pr>, <def><pos>imp.</pos> of <er>Quake</er>.</def> <mark>[Obs.]</mark>  <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quop</ent><br/
<hw>Quop</hw> <pr>(kw<ocr/p)</pr>, <pos>v. i.</pos> <def>See <er>Quob</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quorum</ent><br/
<hw>Quo"rum</hw> <pr>(kw<omac/"r<ucr/m)</pr>, <pos>n.</pos> <ety>[L., of whom, gen. pl. of <ets>qui</ets> who, akin to E. <ets>who</ets>. See the Note below.]</ety> <def>Such a number of the officers or members of any body as is competent by law or constitution to transact business; <as>as, a <ex>quorum</ex> of the House of Representatives; a constitutional <ex>quorum</ex> was not present.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The term arose from the Latin words, <xex>Quorum aliquem vestrum</xex> . . . <xex>unum esse volumus</xex> (of whom we wish some one of you to be one), which were used in the commission formerly issued to justices of the peace in England, by which commission it was directed that no business of certain kinds should be done without the presence of one or more of certain justices specially designated. <xex>Justice of the peace and of the quorum</xex> designates a class of justices of the peace in some of the United States.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quota</ent><br/
<hw>Quo"ta</hw> <pr>(kw<omac/"t<adot/)</pr>, <pos>n.</pos> <ety>[LL., fr. L. <ets>quota</ets> (sc. <ets>pars</ets>), fr. <ets>quotus</ets> which or what in number, of what number, how many, fr. <ets>quot</ets> how many, akin to <ets>quis</ets>, <ets>qui</ets>, who: cf. It. <ets>quota</ets> a share. See <er>Who</er>.]</ety> <sn>1.</sn> <def>A proportional part or share; the share or proportion assigned to each in a division.</def> <ldquo/<xex>Quota</xex> of troops and money.<rdquo/ <rj><au>Motley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>a share of effort required to be performed, or a share of resources required to be contributed to some common purpose.</def><br/
[<source>PJC</source>]</p>

<p><ent>Quotable</ent><br/
<hw>Quot"a*ble</hw> <pr>(kw<omac/t"<adot/*b'l)</pr>, <pos>a.</pos> <def>Capable or worthy of being quoted; <as>as, a <ex>quotable</ex> writer; a <ex>quotable</ex> sentence.</as></def><br/
[<source>1913 Webster</source>]</p>

<p>-- <wordforms><wf>Quot`a*bil"i*ty</wf> <pr>(kw<omac/t"<adot/*b<icr/l"<icr/*t<ycr/)</pr>, <pos>n.</pos> <au>Poe.</au></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quotation</ent><br/
<hw>Quo*ta"tion</hw> <pr>(kw<osl/*t<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <ety>[From <er>Quote</er>.]</ety> <sn>1.</sn> <def>The act of quoting or citing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is quoted or cited; a part of a book or writing named, repeated, or adduced as evidence or illustration.</def>  <rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 1181 --></p>

<p><sn>3.</sn> <fld>(Com.)</fld> <def>The naming or publishing of the current price of stocks, bonds, or any commodity; also, the price named.</def></p>

<p><sn>4.</sn> <def>Quota; share.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Print.)</fld> <def>A piece of hollow type metal, lower than type, and measuring two or more pica ems in length and breadth, used in the blank spaces at the beginning and end of chapters, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Quotation marks</b></col> <fld>(Print.)</fld>, <cd>two inverted commas placed at the beginning, and two apostrophes at the end, of a passage quoted from an author in his own words.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quotationist</ent><br/
<hw>Quo*ta"tion*ist</hw> <pr>(kw<osl/*t<amac/"sh<ucr/n*<icr/st)</pr>, <pos>n.</pos> <def>One who makes, or is given to making, quotations.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The narrow intellectuals of <qex>quotationists</qex>.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quote</ent><br/
<hw>Quote</hw> <pr>(kw<omac/t)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Quoted</conjf>; <pos>p. pr. & vb. n.</pos> <conjf>Quoting</conjf>.]</vmorph> <ety>[OF. <ets>quoter</ets>, F. <ets>coter</ets> to letter, number, to quote, LL. <ets>quotare</ets> to divide into chapters and verses, fr. L. <ets>quotus</ets>. See <er>Quota</er>.]</ety> <altsp>[Formerly written also <asp>cote</asp>.]</altsp> <sn>1.</sn> <def>To cite, as a passage from some author; to name, repeat, or adduce, as a passage from an author or speaker, by way of authority or illustration; <as>as, to <ex>quote</ex> a passage from Homer</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cite a passage from; to name as the authority for a statement or an opinion; <as>as, to <ex>quote</ex> Shakespeare</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Com.)</fld> <def>To name the current price of.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To notice; to observe; to examine.</def> <mark>[Obs.]</mark>  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To set down, as in writing.</def> <mark>[Obs.]</mark> <ldquo/He's <xex>quoted</xex> for a most perfidious slave.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To cite; name; adduce; repeat.</syn> -- <usage> <er>Quote</er>, <er>Cite</er>. To <xex>cite</xex> was originally to call into court as a witness, etc., and hence denotes bringing forward any thing or person as evidence. <xex>Quote</xex> usually signifies to reproduce another's words; it is also used to indicate an appeal to some one as an authority, without adducing his exact words.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quote</ent><br/
<hw>Quote</hw> <pr>(kw<omac/t)</pr>, <pos>n.</pos> <def>A note upon an author.</def> <mark>[Obs.]</mark>  <rj><au>Cotgrave.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoter</ent><br/
<hw>Quot"er</hw> <pr>(kw<omac/t"<etil/r)</pr>, <pos>n.</pos> <def>One who quotes the words of another.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quoth</ent><br/
<hw>Quoth</hw> <pr>(kw<omac/th <or/ kw<ucr/th)</pr>, <pos>v. t.</pos> <ety>[AS. <ets>cwe<edh/an</ets>, imp <ets>cw<ae/<edh/</ets>, pl. <ets>cw<aemac/don</ets>; akin to OS. <ets>que<edh/an</ets>, OHG. <ets>quethan</ets>, <ets>quedan</ets>, Icel. <ets>kve<edh/a</ets>, Goth. <ets>qi<thorn/an</ets>. <root/22.  Cf. <er>Bequeath</er>.]</ety> <def>Said; spoke; uttered; -- used only in the first and third persons in the past tenses, and always followed by its nominative, the word or words said being the object; <as>as, <ex>quoth I</ex>, <ex>quoth he</ex></as>.</def> <ldquo/Let me not live, <xex>quoth</xex> he.<rdquo/  <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quotha</ent><br/
<hw>Quoth"a</hw> <pr>(kw<omac/th"<adot/)</pr>, <pos>interj.</pos> <ety>[For <ets>quoth 'a</ets>, said he, <ets>'a</ets> being corrupted from <ets>he</ets>.]</ety> <def>Indeed; forsooth.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To affront the blessed hillside drabs and thieves<br/
With mended morals, <qex>quotha</qex>, -- fine new lives !</q> <rj><qau>Mrs. Browning.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quotidian</ent><br/
<hw>Quo*tid"i*an</hw> <pr>(kw<osl/*t<icr/d"<icr/*<ait/n)</pr>, <pos>a.</pos> <ety>[OE. <ets>cotidian</ets>, L. <ets>quotidianus</ets>, fr. <ets>quotidie</ets> daily; <ets>quotus</ets> how many + <ets>dies</ets> day: cf. OF. <ets>cotidien</ets>, F. <ets>quotidien</ets>. See <er>Quota</er>, <er>Deity</er>.]</ety> <def>Occurring or returning daily; <as>as, a <ex>quotidian</ex> fever</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quotidian</ent><br/
<hw>Quo*tid"i*an</hw> <pr>(kw<osl/*t<icr/d"<icr/*<ait/n)</pr>, <pos>n.</pos> <def>Anything returning daily; especially <fld>(Med.)</fld>, an intermittent fever or ague which returns every day.</def>  <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quotient</ent><br/
<hw>Quo"tient</hw> <pr>(kw<omac/"sh<eit/nt)</pr>, <pos>n.</pos> <ety>[F., fr. L. <ets>quoties</ets> how often, how many times, fr. <ets>quot</ets> how many. See <er>Quota</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Arith.)</fld> <def>The number resulting from the division of one number by another, and showing how often a less number is contained in a greater; <as>thus, the <ex>quotient</ex> of twelve divided by four is three</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Higher Alg.)</fld> <def>The result of any process inverse to multiplication. See the Note under <er>Multiplication</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quotiety</ent><br/
<hw>Quo*ti"e*ty</hw> <pr>(kw<osl/*t<imac/"<esl/*t<ycr/)</pr>, <pos>n.</pos> <ety>[L. <ets>quotus</ets> of what number, <ets>quot</ets> how many.]</ety> <fld>(Scholastic Philos.)</fld> <def>The relation of an object to number.</def>  <rj><au>Krauth-Fleming.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quotum</ent><br/
<hw>Quo"tum</hw> <pr>(kw<omac/"t<ucr/m)</pr>, <pos>n.</pos> <ety>[NL., fr. L. <ets>quotus</ets> of what number. See <er>Quota</er>.]</ety> <def>Part or proportion; quota.</def> <mark>[R.]</mark> <ldquo/A very small <xex>quotum</xex>.<rdquo/  <rj><au>Max M<uum/ller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quo warranto</ent><br/
\'d8<hw>Quo` war*ran"to</hw> <pr>(kw<omac/` w<ocr/r*r<acr/n"t<osl/)</pr>. <ety>[So called from the Law L. words <ets>quo warranto</ets> (by what authority), in the original Latin form of the writ. See <er>Which</er>, and <er>Warrant</er>.]</ety> <fld>(Law)</fld> <def>A writ brought before a proper tribunal, to inquire by what warrant a person or a corporation acts, or exercises certain powers.</def>  <rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ An information in the nature of a <xex>quo warranto</xex> is now common as a substitute for the writ.
<au>Wharton.</au>
</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Quran</ent><br/
<hw>Qu*ran"</hw> <pr>(k<usdot/*r<aum/n")</pr>, <pos>n.</pos> <def>See <er>Koran</er>.</def><br/
[<source>1913 Webster</source>]</p>

<-- Q ends and R begins in the middle of page 1181 -->
