/*
 * This file is part of the coreboot project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef ARCH_EARLY_VARIABLES_H
#define ARCH_EARLY_VARIABLES_H

#define CAR_GLOBAL

static inline void *car_get_var_ptr(void *var) { return var; }
#define car_get_var(var) (var)
#define car_set_var(var, val) do { (var) = (val); } while (0)

#define car_get_ptr car_get_var
#define car_set_ptr car_set_var

#endif
