#ifndef __DEVICE_PCI_IDS_H__
#define __DEVICE_PCI_IDS_H__

/*
 *	PCI Class, Vendor and Device IDs
 *
 *	Please keep sorted.
 */

/* Device classes and subclasses */

#define PCI_CLASS_NOT_DEFINED		0x0000
#define PCI_CLASS_NOT_DEFINED_VGA	0x0001

#define PCI_BASE_CLASS_STORAGE		0x01
#define PCI_CLASS_STORAGE_SCSI		0x0100
#define PCI_CLASS_STORAGE_IDE		0x0101
#define PCI_CLASS_STORAGE_FLOPPY	0x0102
#define PCI_CLASS_STORAGE_IPI		0x0103
#define PCI_CLASS_STORAGE_RAID		0x0104
#define PCI_CLASS_STORAGE_ATA		0x0105
#define PCI_CLASS_STORAGE_SATA		0x0106
#define PCI_CLASS_STORAGE_SAS		0x0107
#define PCI_CLASS_STORAGE_OTHER		0x0180

#define PCI_BASE_CLASS_NETWORK		0x02
#define PCI_CLASS_NETWORK_ETHERNET	0x0200
#define PCI_CLASS_NETWORK_TOKEN_RING	0x0201
#define PCI_CLASS_NETWORK_FDDI		0x0202
#define PCI_CLASS_NETWORK_ATM		0x0203
#define PCI_CLASS_NETWORK_OTHER		0x0280

#define PCI_BASE_CLASS_DISPLAY		0x03
#define PCI_CLASS_DISPLAY_VGA		0x0300
#define PCI_CLASS_DISPLAY_XGA		0x0301
#define PCI_CLASS_DISPLAY_3D		0x0302
#define PCI_CLASS_DISPLAY_OTHER		0x0380

#define PCI_BASE_CLASS_MULTIMEDIA	0x04
#define PCI_CLASS_MULTIMEDIA_VIDEO	0x0400
#define PCI_CLASS_MULTIMEDIA_AUDIO	0x0401
#define PCI_CLASS_MULTIMEDIA_PHONE	0x0402
#define PCI_CLASS_MULTIMEDIA_OTHER	0x0480

#define PCI_BASE_CLASS_MEMORY		0x05
#define PCI_CLASS_MEMORY_RAM		0x0500
#define PCI_CLASS_MEMORY_FLASH		0x0501
#define PCI_CLASS_MEMORY_OTHER		0x0580

#define PCI_BASE_CLASS_BRIDGE		0x06
#define PCI_CLASS_BRIDGE_HOST		0x0600
#define PCI_CLASS_BRIDGE_ISA		0x0601
#define PCI_CLASS_BRIDGE_EISA		0x0602
#define PCI_CLASS_BRIDGE_MC		0x0603
#define PCI_CLASS_BRIDGE_PCI		0x0604
#define PCI_CLASS_BRIDGE_PCMCIA		0x0605
#define PCI_CLASS_BRIDGE_NUBUS		0x0606
#define PCI_CLASS_BRIDGE_CARDBUS	0x0607
#define PCI_CLASS_BRIDGE_RACEWAY	0x0608
#define PCI_CLASS_BRIDGE_OTHER		0x0680

#define PCI_BASE_CLASS_COMMUNICATION	0x07
#define PCI_CLASS_COMMUNICATION_SERIAL	0x0700
#define PCI_CLASS_COMMUNICATION_PARALLEL 0x0701
#define PCI_CLASS_COMMUNICATION_MULTISERIAL 0x0702
#define PCI_CLASS_COMMUNICATION_MODEM	0x0703
#define PCI_CLASS_COMMUNICATION_OTHER	0x0780

#define PCI_BASE_CLASS_SYSTEM		0x08
#define PCI_CLASS_SYSTEM_PIC		0x0800
#define PCI_CLASS_SYSTEM_DMA		0x0801
#define PCI_CLASS_SYSTEM_TIMER		0x0802
#define PCI_CLASS_SYSTEM_RTC		0x0803
#define PCI_CLASS_SYSTEM_PCI_HOTPLUG	0x0804
#define PCI_CLASS_SYSTEM_OTHER		0x0880

#define PCI_BASE_CLASS_INPUT		0x09
#define PCI_CLASS_INPUT_KEYBOARD	0x0900
#define PCI_CLASS_INPUT_PEN		0x0901
#define PCI_CLASS_INPUT_MOUSE		0x0902
#define PCI_CLASS_INPUT_SCANNER		0x0903
#define PCI_CLASS_INPUT_GAMEPORT	0x0904
#define PCI_CLASS_INPUT_OTHER		0x0980

#define PCI_BASE_CLASS_DOCKING		0x0a
#define PCI_CLASS_DOCKING_GENERIC	0x0a00
#define PCI_CLASS_DOCKING_OTHER		0x0a80

#define PCI_BASE_CLASS_PROCESSOR	0x0b
#define PCI_CLASS_PROCESSOR_386		0x0b00
#define PCI_CLASS_PROCESSOR_486		0x0b01
#define PCI_CLASS_PROCESSOR_PENTIUM	0x0b02
#define PCI_CLASS_PROCESSOR_ALPHA	0x0b10
#define PCI_CLASS_PROCESSOR_POWERPC	0x0b20
#define PCI_CLASS_PROCESSOR_MIPS	0x0b30
#define PCI_CLASS_PROCESSOR_CO		0x0b40

#define PCI_BASE_CLASS_SERIAL		0x0c
#define PCI_CLASS_SERIAL_FIREWIRE	0x0c00
#define PCI_CLASS_SERIAL_ACCESS		0x0c01
#define PCI_CLASS_SERIAL_SSA		0x0c02
#define PCI_CLASS_SERIAL_USB		0x0c03
#define PCI_CLASS_SERIAL_FIBER		0x0c04
#define PCI_CLASS_SERIAL_SMBUS		0x0c05

#define PCI_BASE_CLASS_INTELLIGENT	0x0e
#define PCI_CLASS_INTELLIGENT_I2O	0x0e00

#define PCI_BASE_CLASS_SATELLITE	0x0f
#define PCI_CLASS_SATELLITE_TV		0x0f00
#define PCI_CLASS_SATELLITE_AUDIO	0x0f01
#define PCI_CLASS_SATELLITE_VOICE	0x0f03
#define PCI_CLASS_SATELLITE_DATA	0x0f04

#define PCI_BASE_CLASS_CRYPT		0x10
#define PCI_CLASS_CRYPT_NETWORK		0x1000
#define PCI_CLASS_CRYPT_ENTERTAINMENT	0x1010
#define PCI_CLASS_CRYPT_OTHER		0x1080

#define PCI_BASE_CLASS_SIGNAL_PROCESSING 0x11
#define PCI_CLASS_SP_DPIO		0x1100
#define PCI_CLASS_SP_OTHER		0x1180

#define PCI_CLASS_OTHERS		0xff

/* Vendors and devices.  Sort key: vendor first, device next. */

#define PCI_VENDOR_ID_DYNALINK		0x0675
#define PCI_DEVICE_ID_DYNALINK_IS64PH	0x1702

#define PCI_VENDOR_ID_BERKOM			0x0871
#define PCI_DEVICE_ID_BERKOM_A1T		0xffa1
#define PCI_DEVICE_ID_BERKOM_T_CONCEPT		0xffa2
#define PCI_DEVICE_ID_BERKOM_A4T		0xffa4
#define PCI_DEVICE_ID_BERKOM_SCITEL_QUADRO	0xffa8

#define PCI_VENDOR_CAVIUM			0x177d
#define PCI_DEVICE_ID_CAVIUM_THUNDERX_UART	0xa00f

#define PCI_VENDOR_ID_COMPAQ		0x0e11
#define PCI_DEVICE_ID_COMPAQ_TOKENRING	0x0508
#define PCI_DEVICE_ID_COMPAQ_1280	0x3033
#define PCI_DEVICE_ID_COMPAQ_TRIFLEX	0x4000
#define PCI_DEVICE_ID_COMPAQ_6010	0x6010
#define PCI_DEVICE_ID_COMPAQ_TACHYON	0xa0fc
#define PCI_DEVICE_ID_COMPAQ_SMART2P	0xae10
#define PCI_DEVICE_ID_COMPAQ_NETEL100	0xae32
#define PCI_DEVICE_ID_COMPAQ_NETEL10	0xae34
#define PCI_DEVICE_ID_COMPAQ_TRIFLEX_IDE 0xae33
#define PCI_DEVICE_ID_COMPAQ_NETFLEX3I	0xae35
#define PCI_DEVICE_ID_COMPAQ_NETEL100D	0xae40
#define PCI_DEVICE_ID_COMPAQ_NETEL100PI	0xae43
#define PCI_DEVICE_ID_COMPAQ_NETEL100I	0xb011
#define PCI_DEVICE_ID_COMPAQ_CISS	0xb060
#define PCI_DEVICE_ID_COMPAQ_CISSB	0xb178
#define PCI_DEVICE_ID_COMPAQ_CISSC	0x46
#define PCI_DEVICE_ID_COMPAQ_THUNDER	0xf130
#define PCI_DEVICE_ID_COMPAQ_NETFLEX3B	0xf150

#define PCI_VENDOR_ID_NCR		0x1000
#define PCI_VENDOR_ID_LSI_LOGIC		0x1000
#define PCI_DEVICE_ID_NCR_53C810	0x0001
#define PCI_DEVICE_ID_NCR_53C820	0x0002
#define PCI_DEVICE_ID_NCR_53C825	0x0003
#define PCI_DEVICE_ID_NCR_53C815	0x0004
#define PCI_DEVICE_ID_LSI_53C810AP	0x0005
#define PCI_DEVICE_ID_NCR_53C860	0x0006
#define PCI_DEVICE_ID_LSI_53C1510	0x000a
#define PCI_DEVICE_ID_NCR_53C896	0x000b
#define PCI_DEVICE_ID_NCR_53C895	0x000c
#define PCI_DEVICE_ID_NCR_53C885	0x000d
#define PCI_DEVICE_ID_NCR_53C875	0x000f
#define PCI_DEVICE_ID_NCR_53C1510	0x0010
#define PCI_DEVICE_ID_LSI_53C895A	0x0012
#define PCI_DEVICE_ID_LSI_53C875A	0x0013
#define PCI_DEVICE_ID_LSI_53C1010_33	0x0020
#define PCI_DEVICE_ID_LSI_53C1010_66	0x0021
#define PCI_DEVICE_ID_LSI_53C1030	0x0030
#define PCI_DEVICE_ID_LSI_1030_53C1035	0x0032
#define PCI_DEVICE_ID_LSI_53C1035	0x0040
#define PCI_DEVICE_ID_NCR_53C875J	0x008f
#define PCI_DEVICE_ID_LSI_FC909		0x0621
#define PCI_DEVICE_ID_LSI_FC929		0x0622
#define PCI_DEVICE_ID_LSI_FC929_LAN	0x0623
#define PCI_DEVICE_ID_LSI_FC919		0x0624
#define PCI_DEVICE_ID_LSI_FC919_LAN	0x0625
#define PCI_DEVICE_ID_LSI_FC929X	0x0626
#define PCI_DEVICE_ID_LSI_FC939X	0x0642
#define PCI_DEVICE_ID_LSI_FC949X	0x0640
#define PCI_DEVICE_ID_LSI_FC919X	0x0628
#define PCI_DEVICE_ID_NCR_YELLOWFIN	0x0701
#define PCI_DEVICE_ID_LSI_61C102	0x0901
#define PCI_DEVICE_ID_LSI_63C815	0x1000
#define PCI_DEVICE_ID_LSI_SAS1064	0x0050
#define PCI_DEVICE_ID_LSI_SAS1066	0x005E
#define PCI_DEVICE_ID_LSI_SAS1068	0x0054
#define PCI_DEVICE_ID_LSI_SAS1064A	0x005C
#define PCI_DEVICE_ID_LSI_SAS1064E	0x0056
#define PCI_DEVICE_ID_LSI_SAS1066E	0x005A
#define PCI_DEVICE_ID_LSI_SAS1068E	0x0058
#define PCI_DEVICE_ID_LSI_SAS1078	0x0060

#define PCI_VENDOR_ID_ATI		0x1002
/* Mach64 */
#define PCI_DEVICE_ID_ATI_68800		0x4158
#define PCI_DEVICE_ID_ATI_215CT222	0x4354
#define PCI_DEVICE_ID_ATI_210888CX	0x4358
#define PCI_DEVICE_ID_ATI_215ET222	0x4554
/* Mach64 / Rage */
#define PCI_DEVICE_ID_ATI_215GB		0x4742
#define PCI_DEVICE_ID_ATI_215GD		0x4744
#define PCI_DEVICE_ID_ATI_215GI		0x4749
#define PCI_DEVICE_ID_ATI_215GP		0x4750
#define PCI_DEVICE_ID_ATI_215GQ		0x4751
#define PCI_DEVICE_ID_ATI_215XL		0x4752
#define PCI_DEVICE_ID_ATI_215GT		0x4754
#define PCI_DEVICE_ID_ATI_215GTB	0x4755
#define PCI_DEVICE_ID_ATI_215_IV	0x4756
#define PCI_DEVICE_ID_ATI_215_IW	0x4757
#define PCI_DEVICE_ID_ATI_215_IZ	0x475A
#define PCI_DEVICE_ID_ATI_210888GX	0x4758
#define PCI_DEVICE_ID_ATI_215_LB	0x4c42
#define PCI_DEVICE_ID_ATI_215_LD	0x4c44
#define PCI_DEVICE_ID_ATI_215_LG	0x4c47
#define PCI_DEVICE_ID_ATI_215_LI	0x4c49
#define PCI_DEVICE_ID_ATI_215_LM	0x4c4D
#define PCI_DEVICE_ID_ATI_215_LN	0x4c4E
#define PCI_DEVICE_ID_ATI_215_LR	0x4c52
#define PCI_DEVICE_ID_ATI_215_LS	0x4c53
#define PCI_DEVICE_ID_ATI_264_LT	0x4c54
#define PCI_DEVICE_ID_ATI_215LG         0x4c47
#define PCI_DEVICE_ID_ATI_264LT         0x4c54
/* Mach64 VT */
#define PCI_DEVICE_ID_ATI_264VT		0x5654
#define PCI_DEVICE_ID_ATI_264VU		0x5655
#define PCI_DEVICE_ID_ATI_264VV		0x5656
/* Rage128 Pro GL */
#define PCI_DEVICE_ID_ATI_Rage128_PA	0x5041
#define PCI_DEVICE_ID_ATI_Rage128_PB	0x5042
#define PCI_DEVICE_ID_ATI_Rage128_PC	0x5043
#define PCI_DEVICE_ID_ATI_Rage128_PD	0x5044
#define PCI_DEVICE_ID_ATI_Rage128_PE	0x5045
#define PCI_DEVICE_ID_ATI_RAGE128_PF	0x5046
/* Rage128 Pro VR */
#define PCI_DEVICE_ID_ATI_RAGE128_PG	0x5047
#define PCI_DEVICE_ID_ATI_RAGE128_PH	0x5048
#define PCI_DEVICE_ID_ATI_RAGE128_PI	0x5049
#define PCI_DEVICE_ID_ATI_RAGE128_PJ	0x504A
#define PCI_DEVICE_ID_ATI_RAGE128_PK	0x504B
#define PCI_DEVICE_ID_ATI_RAGE128_PL	0x504C
#define PCI_DEVICE_ID_ATI_RAGE128_PM	0x504D
#define PCI_DEVICE_ID_ATI_RAGE128_PN	0x504E
#define PCI_DEVICE_ID_ATI_RAGE128_PO	0x504F
#define PCI_DEVICE_ID_ATI_RAGE128_PP	0x5050
#define PCI_DEVICE_ID_ATI_RAGE128_PQ	0x5051
#define PCI_DEVICE_ID_ATI_RAGE128_PR	0x5052
#define PCI_DEVICE_ID_ATI_RAGE128_TR	0x5452
#define PCI_DEVICE_ID_ATI_RAGE128_PS	0x5053
#define PCI_DEVICE_ID_ATI_RAGE128_PT	0x5054
#define PCI_DEVICE_ID_ATI_RAGE128_PU	0x5055
#define PCI_DEVICE_ID_ATI_RAGE128_PV	0x5056
#define PCI_DEVICE_ID_ATI_RAGE128_PW	0x5057
#define PCI_DEVICE_ID_ATI_RAGE128_PX	0x5058
/* Rage128 GL */
#define PCI_DEVICE_ID_ATI_RAGE128_RE	0x5245
#define PCI_DEVICE_ID_ATI_RAGE128_RF	0x5246
#define PCI_DEVICE_ID_ATI_RAGE128_RG	0x534b
#define PCI_DEVICE_ID_ATI_RAGE128_RH	0x534c
#define PCI_DEVICE_ID_ATI_RAGE128_RI	0x534d
/* Rage128 VR */
#define PCI_DEVICE_ID_ATI_RAGE128_RK	0x524b
#define PCI_DEVICE_ID_ATI_RAGE128_RL	0x524c
#define PCI_DEVICE_ID_ATI_RAGE128_RM	0x5345
#define PCI_DEVICE_ID_ATI_RAGE128_RN	0x5346
#define PCI_DEVICE_ID_ATI_RAGE128_RO	0x5347
/* Rage128 M3 */
#define PCI_DEVICE_ID_ATI_RAGE128_LE	0x4c45
#define PCI_DEVICE_ID_ATI_RAGE128_LF	0x4c46
/* Rage128 Pro Ultra */
#define PCI_DEVICE_ID_ATI_RAGE128_U1	0x5446
#define PCI_DEVICE_ID_ATI_RAGE128_U2	0x544C
#define PCI_DEVICE_ID_ATI_RAGE128_U3	0x5452
/* Radeon M4 */
#define PCI_DEVICE_ID_ATI_RADEON_LE	0x4d45
#define PCI_DEVICE_ID_ATI_RADEON_LF	0x4d46
/* Radeon NV-100 */
#define PCI_DEVICE_ID_ATI_RADEON_N1	0x5159
#define PCI_DEVICE_ID_ATI_RADEON_N2	0x515a
/* Radeon */
#define PCI_DEVICE_ID_ATI_RADEON_RA	0x5144
#define PCI_DEVICE_ID_ATI_RADEON_RB	0x5145
#define PCI_DEVICE_ID_ATI_RADEON_RC	0x5146
#define PCI_DEVICE_ID_ATI_RADEON_RD	0x5147

#define PCI_DEVICE_ID_AMD_10H_NB_HT		0x1200
#define PCI_DEVICE_ID_AMD_15H_MODEL_000F_NB_HT	0x1600
#define PCI_DEVICE_ID_AMD_15H_MODEL_101F_NB_HT	0x1400
#define PCI_DEVICE_ID_AMD_15H_MODEL_303F_NB_HT	0x141A
#define PCI_DEVICE_ID_AMD_15H_MODEL_606F_NB_HT	0x1570
#define PCI_DEVICE_ID_AMD_15H_MODEL_707F_NB_HT	0x15B0
#define PCI_DEVICE_ID_AMD_16H_MODEL_000F_NB_HT	0x1536
#define PCI_DEVICE_ID_AMD_16H_MODEL_303F_NB_HT  0x1566
#define PCI_DEVICE_ID_AMD_17H_MODEL_101F_NB	0x15d0
#define PCI_DEVICE_ID_AMD_15H_MODEL_101F_NB_IOMMU	0x1419
#define PCI_DEVICE_ID_AMD_15H_MODEL_303F_NB_IOMMU	0x1423
#define PCI_DEVICE_ID_AMD_15H_MODEL_707F_NB_IOMMU	0x1577
#define PCI_DEVICE_ID_AMD_16H_MODEL_303F_NB_IOMMU	0x1567
#define PCI_DEVICE_ID_AMD_17H_MODEL_101F_NB_IOMMU	0x15d1

#define PCI_DEVICE_ID_ATI_SB600_LPC		0x438D
#define PCI_DEVICE_ID_ATI_SB600_SATA		0x4380
#define PCI_DEVICE_ID_ATI_SB600_IDE		0x438C
#define PCI_DEVICE_ID_ATI_SB600_HDA		0x4383
#define PCI_DEVICE_ID_ATI_SB600_ACI		0x4382
#define PCI_DEVICE_ID_ATI_SB600_MCI		0x438E
#define PCI_DEVICE_ID_ATI_SB600_USB2		0x4386
#define PCI_DEVICE_ID_ATI_SB600_PCI		0x4384
#define PCI_DEVICE_ID_ATI_SB600_SM		0x4385
#define PCI_DEVICE_ID_ATI_SB600_USB_0		0x4387
#define PCI_DEVICE_ID_ATI_SB600_USB_1		0x4388
#define PCI_DEVICE_ID_ATI_SB600_USB_2		0x4389
#define PCI_DEVICE_ID_ATI_SB600_USB_3		0x438A
#define PCI_DEVICE_ID_ATI_SB600_USB_4		0x438B

#define PCI_DEVICE_ID_ATI_SB700_LPC		0x439D
#define PCI_DEVICE_ID_ATI_SB700_SATA		0x4390
#define PCI_DEVICE_ID_ATI_SB700_SATA_AHCI	0x4391
#define PCI_DEVICE_ID_ATI_SB700_SATA_AHCI_AMD	0x4394
#define PCI_DEVICE_ID_ATI_SB700_IDE		0x439C
#define PCI_DEVICE_ID_ATI_SB700_HDA		0x4383
#define PCI_DEVICE_ID_ATI_SB700_PCI		0x4384
#define PCI_DEVICE_ID_ATI_SB700_SM		0x4385
#define PCI_DEVICE_ID_ATI_SB700_USB_18_0		0x4397
#define PCI_DEVICE_ID_ATI_SB700_USB_18_1		0x4398
#define PCI_DEVICE_ID_ATI_SB700_USB_18_2		0x4396
#define PCI_DEVICE_ID_ATI_SB700_USB_19_0		0x4397
#define PCI_DEVICE_ID_ATI_SB700_USB_19_1		0x4398
#define PCI_DEVICE_ID_ATI_SB700_USB_19_2		0x4396
#define PCI_DEVICE_ID_ATI_SB700_USB_20_5		0x4399

#define PCI_DEVICE_ID_ATI_SB800_LPC             0x439D
#define PCI_DEVICE_ID_ATI_SB800_SATA            0x4390
#define PCI_DEVICE_ID_ATI_SB800_SATA_AHCI       0x4391
#define PCI_DEVICE_ID_ATI_SB800_SATA_RAID       0x4392
#define PCI_DEVICE_ID_ATI_SB800_SATA_RAID5      0x4393
#define PCI_DEVICE_ID_ATI_SB800_IDE             0x439C
#define PCI_DEVICE_ID_ATI_SB800_HDA             0x4383
#define PCI_DEVICE_ID_ATI_SB800_PCI             0x4384
#define PCI_DEVICE_ID_ATI_SB800_PCIEA           0x43A0
#define PCI_DEVICE_ID_ATI_SB800_PCIEB           0x43A1
#define PCI_DEVICE_ID_ATI_SB800_PCIEC           0x43A2
#define PCI_DEVICE_ID_ATI_SB800_PCIED           0x43A3
#define PCI_DEVICE_ID_ATI_SB800_SM              0x4385
#define PCI_DEVICE_ID_ATI_SB800_USB_18_0        0x4397
#define PCI_DEVICE_ID_ATI_SB800_USB_18_2        0x4396
#define PCI_DEVICE_ID_ATI_SB800_USB_19_0        0x4397
#define PCI_DEVICE_ID_ATI_SB800_USB_19_2        0x4396
#define PCI_DEVICE_ID_ATI_SB800_USB_20_5        0x4399
#define PCI_DEVICE_ID_ATI_SB800_USB_22_0        0x4397
#define PCI_DEVICE_ID_ATI_SB800_USB_22_2        0x4396
#define PCI_DEVICE_ID_ATI_SB800_GEC             0x1699

#define PCI_DEVICE_ID_AMD_SB900_LPC             0x780E
#define PCI_DEVICE_ID_AMD_SB900_SATA            0x7800
#define PCI_DEVICE_ID_AMD_SB900_SATA_AHCI       0x7801
#define PCI_DEVICE_ID_AMD_SB900_SATA_RAID       0x7802
#define PCI_DEVICE_ID_AMD_SB900_SATA_RAID5      0x7803
#define PCI_DEVICE_ID_AMD_SB900_SATA_AMDAHCI    0x7804
#define PCI_DEVICE_ID_AMD_SB900_IDE             0x780C
#define PCI_DEVICE_ID_AMD_SB900_HDA             0x780D
#define PCI_DEVICE_ID_AMD_SB900_PCI             0x780F
#define PCI_DEVICE_ID_AMD_SB900_PCIEA           0x43A0
#define PCI_DEVICE_ID_AMD_SB900_PCIEB           0x43A1
#define PCI_DEVICE_ID_AMD_SB900_PCIEC           0x43A2
#define PCI_DEVICE_ID_AMD_SB900_PCIED           0x43A3
#define PCI_DEVICE_ID_AMD_SB900_SM              0x780B
#define PCI_DEVICE_ID_AMD_SB900_USB_16_0        0x7812
#define PCI_DEVICE_ID_AMD_SB900_USB_16_1        0x7812
#define PCI_DEVICE_ID_AMD_SB900_USB_18_0        0x7807
#define PCI_DEVICE_ID_AMD_SB900_USB_18_2        0x7808
#define PCI_DEVICE_ID_AMD_SB900_USB_19_0        0x7807
#define PCI_DEVICE_ID_AMD_SB900_USB_19_2        0x7808
#define PCI_DEVICE_ID_AMD_SB900_USB_20_5        0x7809
#define PCI_DEVICE_ID_AMD_SB900_GEC             0x7806
#define PCI_DEVICE_ID_AMD_HUDSON_SD             0x7806
#define PCI_DEVICE_ID_AMD_YANGTZE_SD            0x7813

#define PCI_DEVICE_ID_ATI_RS690_HT		0x7910
#define PCI_DEVICE_ID_ATI_RS740_HT		0x7911
#define PCI_DEVICE_ID_ATI_RS690_PCIE		0x7912
#define PCI_DEVICE_ID_ATI_RS690_PCIE_DEV2	0x7913
#define PCI_DEVICE_ID_ATI_RS690_PCIE_DEV3	0x791B
#define PCI_DEVICE_ID_ATI_RS690_PCIE_DEV4	0x7914
#define PCI_DEVICE_ID_ATI_RS690_PCIE_DEV5	0x7915
#define PCI_DEVICE_ID_ATI_RS690_PCIE_DEV6	0x7916
#define PCI_DEVICE_ID_ATI_RS690_PCIE_DEV7	0x7917
#define PCI_DEVICE_ID_ATI_RS690_PCIE_DEV8	0x7918
#define PCI_DEVICE_ID_ATI_RS690_INT_GFX		0x791e
#define PCI_DEVICE_ID_ATI_RS690MT_INT_GFX	0x791f
#define PCI_DEVICE_ID_ATI_RS740_INT_GFX		0x796e

#define PCI_DEVICE_ID_AMD_RS780_HT		0x9600
#define PCI_DEVICE_ID_AMD_RS780_PCIE		0x9602
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV2	0x9603
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV3	0x960B
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV4	0x9604
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV5	0x9605
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV6	0x9606
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV7	0x9607
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV9	0x9608
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV10	0x9609
#define PCI_DEVICE_ID_AMD_RS780_PCIE_DEV8	0x960A
#define PCI_DEVICE_ID_ATI_RS780_INT_GFX		0x9610
#define PCI_DEVICE_ID_ATI_RS780C_INT_GFX	0x9611
#define PCI_DEVICE_ID_ATI_RS780M_INT_GFX	0x9612
#define PCI_DEVICE_ID_ATI_RS780MC_INT_GFX	0x9613
#define PCI_DEVICE_ID_ATI_RS780E_INT_GFX	0x9615
#define PCI_DEVICE_ID_ATI_RS785G_INT_GFX	0x9710
#define PCI_DEVICE_ID_ATI_RS785C_INT_GFX	0x9711
#define PCI_DEVICE_ID_ATI_RS785M_INT_GFX	0x9712
#define PCI_DEVICE_ID_ATI_RS785MC_INT_GFX	0x9713
#define PCI_DEVICE_ID_ATI_RS785D_INT_GFX	0x9714

#define PCI_DEVICE_ID_AMD_RD890TV_HT		0x5956
#define PCI_DEVICE_ID_AMD_RX780_HT		0x5957
#define PCI_DEVICE_ID_AMD_RD780_HT		0x5958
#define PCI_DEVICE_ID_AMD_SR5690_HT		0x5A10
#define PCI_DEVICE_ID_AMD_RD890_HT		0x5A11
#define PCI_DEVICE_ID_AMD_SR5670_HT		0x5A12
#define PCI_DEVICE_ID_AMD_SR5650_HT		0x5A13
#define PCI_DEVICE_ID_AMD_990FX_HT		0x5A14
#define PCI_DEVICE_ID_AMD_SR5650_PCIE          0x5A12
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV2     0x5A16
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV3     0x5A17
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV4     0x5A18
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV5     0x5A19
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV6     0x5A1A
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV7     0x5A1B
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV9     0x5A1C
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV10    0x5A1D
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV11    0x5A1F
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV12    0x5A20
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV13    0x5A1E
#define PCI_DEVICE_ID_AMD_SR5650_PCIE_DEV8     0x5A21
#define PCI_DEVICE_ID_AMD_SR5650_IOMMU		0x5A23

#define PCI_DEVICE_ID_AMD_CZ_HDA        0x157A
#define PCI_DEVICE_ID_AMD_CZ_LPC        0x790E
#define PCI_DEVICE_ID_AMD_CZ_SATA       0x7900
#define PCI_DEVICE_ID_AMD_CZ_SATA_AHCI  0x7901
#define PCI_DEVICE_ID_AMD_CZ_USB_0      0x7907
#define PCI_DEVICE_ID_AMD_CZ_USB_1      0x7908
#define PCI_DEVICE_ID_AMD_CZ_USB3_0     0x7914
#define PCI_DEVICE_ID_AMD_CZ_SMBUS      0x790B

#define PCI_DEVICE_ID_AMD_PCO_LPC	0x790e
#define PCI_DEVICE_ID_AMD_PCO_HDA0	0x15de
#define PCI_DEVICE_ID_AMD_PCO_HDA1	0x15e3
#define PCI_DEVICD_ID_AMD_PCO_ACP	0x15e2
#define PCI_DEVICE_ID_AMD_PCO_XHCI0	0x15e0
#define PCI_DEVICE_ID_AMD_PCO_XHCI1	0x15e1

#define PCI_VENDOR_ID_VLSI		0x1004
#define PCI_DEVICE_ID_VLSI_82C592	0x0005
#define PCI_DEVICE_ID_VLSI_82C593	0x0006
#define PCI_DEVICE_ID_VLSI_82C594	0x0007
#define PCI_DEVICE_ID_VLSI_82C597	0x0009
#define PCI_DEVICE_ID_VLSI_82C541	0x000c
#define PCI_DEVICE_ID_VLSI_82C543	0x000d
#define PCI_DEVICE_ID_VLSI_82C532	0x0101
#define PCI_DEVICE_ID_VLSI_82C534	0x0102
#define PCI_DEVICE_ID_VLSI_82C535	0x0104
#define PCI_DEVICE_ID_VLSI_82C147	0x0105
#define PCI_DEVICE_ID_VLSI_VAS96011	0x0702

#define PCI_VENDOR_ID_ADL		0x1005
#define PCI_DEVICE_ID_ADL_2301		0x2301

#define PCI_VENDOR_ID_NS		0x100b
#define PCI_DEVICE_ID_NS_87415		0x0002
#define PCI_DEVICE_ID_NS_87560_LIO	0x000e
#define PCI_DEVICE_ID_NS_87560_USB	0x0012
#define PCI_DEVICE_ID_NS_83815		0x0020
#define PCI_DEVICE_ID_NS_83820		0x0022
#define PCI_DEVICE_ID_NS_GX2		0x0028
#define PCI_DEVICE_ID_NS_CS5535		0x002a
#define PCI_DEVICE_ID_NS_CS5535_ISA	0x002b
#define PCI_DEVICE_ID_NS_CS5535_IDE	0x002d
#define PCI_DEVICE_ID_NS_CS5535_AUDIO	0x002e
#define PCI_DEVICE_ID_NS_CS5535_USB	0x002f
#define PCI_DEVICE_ID_NS_CS5535_GX2VGA	0x0030
#define PCI_DEVICE_ID_NS_SCx200_BRIDGE  0x0500
#define PCI_DEVICE_ID_NS_SCx200_SMI     0x0501
#define PCI_DEVICE_ID_NS_SCx200_IDE     0x0502
#define PCI_DEVICE_ID_NS_SCx200_AUDIO   0x0503
#define PCI_DEVICE_ID_NS_SCx200_VIDEO   0x0504
#define PCI_DEVICE_ID_NS_SCx200_XBUS    0x0505
#define PCI_DEVICE_ID_NS_87410		0xd001


#define PCI_VENDOR_ID_TSENG		0x100c
#define PCI_DEVICE_ID_TSENG_W32P_2	0x3202
#define PCI_DEVICE_ID_TSENG_W32P_b	0x3205
#define PCI_DEVICE_ID_TSENG_W32P_c	0x3206
#define PCI_DEVICE_ID_TSENG_W32P_d	0x3207
#define PCI_DEVICE_ID_TSENG_ET6000	0x3208

#define PCI_VENDOR_ID_WEITEK		0x100e
#define PCI_DEVICE_ID_WEITEK_P9000	0x9001
#define PCI_DEVICE_ID_WEITEK_P9100	0x9100

#define PCI_VENDOR_ID_DEC		0x1011
#define PCI_DEVICE_ID_DEC_BRD		0x0001
#define PCI_DEVICE_ID_DEC_TULIP		0x0002
#define PCI_DEVICE_ID_DEC_TGA		0x0004
#define PCI_DEVICE_ID_DEC_TULIP_FAST	0x0009
#define PCI_DEVICE_ID_DEC_TGA2		0x000D
#define PCI_DEVICE_ID_DEC_FDDI		0x000F
#define PCI_DEVICE_ID_DEC_TULIP_PLUS	0x0014
#define PCI_DEVICE_ID_DEC_21142		0x0019
#define PCI_DEVICE_ID_DEC_21052		0x0021
#define PCI_DEVICE_ID_DEC_21150		0x0022
#define PCI_DEVICE_ID_DEC_21152		0x0024
#define PCI_DEVICE_ID_DEC_21153		0x0025
#define PCI_DEVICE_ID_DEC_21154		0x0026
#define PCI_DEVICE_ID_DEC_21285		0x1065
#define PCI_DEVICE_ID_COMPAQ_42XX	0x0046

#define PCI_VENDOR_ID_CIRRUS		0x1013
#define PCI_DEVICE_ID_CIRRUS_7548	0x0038
#define PCI_DEVICE_ID_CIRRUS_5430	0x00a0
#define PCI_DEVICE_ID_CIRRUS_5434_4	0x00a4
#define PCI_DEVICE_ID_CIRRUS_5434_8	0x00a8
#define PCI_DEVICE_ID_CIRRUS_5436	0x00ac
#define PCI_DEVICE_ID_CIRRUS_5446	0x00b8
#define PCI_DEVICE_ID_CIRRUS_5480	0x00bc
#define PCI_DEVICE_ID_CIRRUS_5462	0x00d0
#define PCI_DEVICE_ID_CIRRUS_5464	0x00d4
#define PCI_DEVICE_ID_CIRRUS_5465	0x00d6
#define PCI_DEVICE_ID_CIRRUS_6729	0x1100
#define PCI_DEVICE_ID_CIRRUS_6832	0x1110
#define PCI_DEVICE_ID_CIRRUS_7542	0x1200
#define PCI_DEVICE_ID_CIRRUS_7543	0x1202
#define PCI_DEVICE_ID_CIRRUS_7541	0x1204

#define PCI_VENDOR_ID_IBM		0x1014
#define PCI_DEVICE_ID_IBM_FIRE_CORAL	0x000a
#define PCI_DEVICE_ID_IBM_TR		0x0018
#define PCI_DEVICE_ID_IBM_82G2675	0x001d
#define PCI_DEVICE_ID_IBM_MCA		0x0020
#define PCI_DEVICE_ID_IBM_82351		0x0022
#define PCI_DEVICE_ID_IBM_PYTHON	0x002d
#define PCI_DEVICE_ID_IBM_SERVERAID	0x002e
#define PCI_DEVICE_ID_IBM_TR_WAKE	0x003e
#define PCI_DEVICE_ID_IBM_MPIC		0x0046
#define PCI_DEVICE_ID_IBM_3780IDSP	0x007d
#define PCI_DEVICE_ID_IBM_CHUKAR	0x0096
#define PCI_DEVICE_ID_IBM_CPC710_PCI64	0x00fc
#define PCI_DEVICE_ID_IBM_CPC710_PCI32	0x0105
#define	PCI_DEVICE_ID_IBM_405GP		0x0156
#define PCI_DEVICE_ID_IBM_SERVERAIDI960	0x01bd
#define PCI_DEVICE_ID_IBM_MPIC_2	0xffff

#define PCI_VENDOR_ID_COMPEX2		0x101a // pci.ids says "AT&T GIS (NCR)"
#define PCI_DEVICE_ID_COMPEX2_100VG	0x0005

#define PCI_VENDOR_ID_WD		0x101c
#define PCI_DEVICE_ID_WD_7197		0x3296
#define PCI_DEVICE_ID_WD_90C		0xc24a

#define PCI_VENDOR_ID_AMI		0x101e
#define PCI_DEVICE_ID_AMI_MEGARAID3	0x1960
#define PCI_DEVICE_ID_AMI_MEGARAID	0x9010
#define PCI_DEVICE_ID_AMI_MEGARAID2	0x9060

#define PCI_VENDOR_ID_AMD		0x1022
#define PCI_DEVICE_ID_AMD_LANCE		0x2000
#define PCI_DEVICE_ID_AMD_LANCE_HOME	0x2001
#define PCI_DEVICE_ID_AMD_LX		0x1054
#define PCI_DEVICE_ID_AMD_LXBRIDGE	0x2080
#define PCI_DEVICE_ID_AMD_SCSI		0x2020
#define PCI_DEVICE_ID_AMD_FE_GATE_7006	0x7006
#define PCI_DEVICE_ID_AMD_FE_GATE_7007	0x7007
#define PCI_DEVICE_ID_AMD_FE_GATE_700C	0x700C
#define PCI_DEVIDE_ID_AMD_FE_GATE_700D	0x700D
#define PCI_DEVICE_ID_AMD_FE_GATE_700E	0x700E
#define PCI_DEVICE_ID_AMD_FE_GATE_700F	0x700F
#define PCI_DEVICE_ID_AMD_COBRA_7400	0x7400
#define PCI_DEVICE_ID_AMD_COBRA_7401	0x7401
#define PCI_DEVICE_ID_AMD_COBRA_7403	0x7403
#define PCI_DEVICE_ID_AMD_COBRA_7404	0x7404
#define PCI_DEVICE_ID_AMD_VIPER_7408	0x7408
#define PCI_DEVICE_ID_AMD_VIPER_7409	0x7409
#define PCI_DEVICE_ID_AMD_VIPER_740B	0x740B
#define PCI_DEVICE_ID_AMD_VIPER_740C	0x740C
#define PCI_DEVICE_ID_AMD_VIPER_7410	0x7410
#define PCI_DEVICE_ID_AMD_VIPER_7411	0x7411

#define PCI_DEVICE_ID_AMD_SB768_7440  0x7440
#define PCI_DEVICE_ID_AMD_SB768_7441  0x7441
#define PCI_DEVICE_ID_AMD_SB768_7443  0x7443
#define PCI_DEVICE_ID_AMD_SB768_7448  0x7448
#define PCI_DEVICE_ID_AMD_SB768_7449  0x7449

#define PCI_DEVICE_ID_AMD_VIPER_7413	0x7413
#define PCI_DEVICE_ID_AMD_VIPER_7414	0x7414
#define PCI_DEVICE_ID_AMD_VIPER_7440	0x7440
#define PCI_DEVICE_ID_AMD_VIPER_7441	0x7441
#define PCI_DEVICE_ID_AMD_VIPER_7443	0x7443
#define PCI_DEVICE_ID_AMD_VIPER_7448	0x7448
#define PCI_DEVICE_ID_AMD_VIPER_7449	0x7449

#define PCI_DEVICE_ID_AMD_8151_SYSCTRL  0x7454
#define PCI_DEVICE_ID_AMD_8151_AGP      0x7455
#define PCI_DEVICE_ID_AMD_8111_PCI      0x7460
#define PCI_DEVICE_ID_AMD_8111_USB      0x7464
#define PCI_DEVICE_ID_AMD_8111_ISA      0x7468
#define PCI_DEVICE_ID_AMD_8111_IDE      0x7469
#define PCI_DEVICE_ID_AMD_8111_SMB      0x746a
#define PCI_DEVICE_ID_AMD_8111_ACPI     0x746b
#define PCI_DEVICE_ID_AMD_8111_NIC      0x7462

#define PCI_DEVICE_ID_AMD_8111_USB2     0x7463
#define PCI_DEVICE_ID_AMD_8131_PCIX	0x7450
#define PCI_DEVICE_ID_AMD_8131_IOAPIC   0x7451

#define PCI_DEVICE_ID_AMD_8132_PCIX     0x7458
#define PCI_DEVICE_ID_AMD_8132_IOAPIC   0x7459
#define PCI_DEVICE_ID_AMD_AES		0x2082
#define PCI_DEVICE_ID_AMD_CS5536_ISA	0x2090
#define PCI_DEVICE_ID_AMD_CS5536_FLASH	0x2091
#define PCI_DEVICE_ID_AMD_CS5536_A0_IDE	0x2092
#define PCI_DEVICE_ID_AMD_CS5536_AUDIO	0x2093
#define PCI_DEVICE_ID_AMD_CS5536_OHCI	0x2094
#define PCI_DEVICE_ID_AMD_CS5536_EHCI	0x2095
#define PCI_DEVICE_ID_AMD_CS5536_UDC	0x2096
#define PCI_DEVICE_ID_AMD_CS5536_OTG	0x2097
#define PCI_DEVICE_ID_AMD_CS5536_B0_IDE	0x209A

#define PCI_VENDOR_ID_TRIDENT		0x1023
#define PCI_DEVICE_ID_TRIDENT_4DWAVE_DX	0x2000
#define PCI_DEVICE_ID_TRIDENT_4DWAVE_NX	0x2001
#define PCI_DEVICE_ID_TRIDENT_9320	0x9320
#define PCI_DEVICE_ID_TRIDENT_9388	0x9388
#define PCI_DEVICE_ID_TRIDENT_9397	0x9397
#define PCI_DEVICE_ID_TRIDENT_939A	0x939A
#define PCI_DEVICE_ID_TRIDENT_9520	0x9520
#define PCI_DEVICE_ID_TRIDENT_9525	0x9525
#define PCI_DEVICE_ID_TRIDENT_9420	0x9420
#define PCI_DEVICE_ID_TRIDENT_9440	0x9440
#define PCI_DEVICE_ID_TRIDENT_9660	0x9660
#define PCI_DEVICE_ID_TRIDENT_9750	0x9750
#define PCI_DEVICE_ID_TRIDENT_9850	0x9850
#define PCI_DEVICE_ID_TRIDENT_9880	0x9880
#define PCI_DEVICE_ID_TRIDENT_8400	0x8400
#define PCI_DEVICE_ID_TRIDENT_8420	0x8420
#define PCI_DEVICE_ID_TRIDENT_8500	0x8500

#define PCI_VENDOR_ID_AI		0x1025
#define PCI_DEVICE_ID_AI_M1435		0x1435

#define PCI_VENDOR_ID_DELL              0x1028

#define PCI_VENDOR_ID_MATROX		0x102B
#define PCI_DEVICE_ID_MATROX_MGA_2	0x0518
#define PCI_DEVICE_ID_MATROX_MIL	0x0519
#define PCI_DEVICE_ID_MATROX_MYS	0x051A
#define PCI_DEVICE_ID_MATROX_MIL_2	0x051b
#define PCI_DEVICE_ID_MATROX_MIL_2_AGP	0x051f
#define PCI_DEVICE_ID_MATROX_MGA_IMP	0x0d10
#define PCI_DEVICE_ID_MATROX_G100_MM	0x1000
#define PCI_DEVICE_ID_MATROX_G100_AGP	0x1001
#define PCI_DEVICE_ID_MATROX_G200_PCI	0x0520
#define PCI_DEVICE_ID_MATROX_G200_AGP	0x0521
#define	PCI_DEVICE_ID_MATROX_G400	0x0525
#define PCI_DEVICE_ID_MATROX_G550	0x2527
#define PCI_DEVICE_ID_MATROX_VIA	0x4536

#define PCI_VENDOR_ID_CT		0x102c
#define PCI_DEVICE_ID_CT_65545		0x00d8
#define PCI_DEVICE_ID_CT_65548		0x00dc
#define PCI_DEVICE_ID_CT_65550		0x00e0
#define PCI_DEVICE_ID_CT_65554		0x00e4
#define PCI_DEVICE_ID_CT_65555		0x00e5

#define PCI_VENDOR_ID_MIRO		0x1031
#define PCI_DEVICE_ID_MIRO_36050	0x5601

#define PCI_VENDOR_ID_NEC		0x1033
#define PCI_DEVICE_ID_NEC_PCX2		0x0046
#define PCI_DEVICE_ID_NEC_NILE4		0x005a
#define PCI_DEVICE_ID_NEC_VRC5476       0x009b
#define PCI_DEVICE_ID_NEC_VRC5477_AC97  0x00a6

#define PCI_VENDOR_ID_FD		0x1036
#define PCI_DEVICE_ID_FD_36C70		0x0000

#define PCI_VENDOR_ID_SI		0x1039
#define PCI_DEVICE_ID_SI_5591_AGP	0x0001
#define PCI_DEVICE_ID_SI_6202		0x0002
#define PCI_DEVICE_ID_SI_503		0x0008
#define PCI_DEVICE_ID_SI_ACPI		0x0009
#define PCI_DEVICE_ID_SI_5597_VGA	0x0200
#define PCI_DEVICE_ID_SI_6205		0x0205
#define PCI_DEVICE_ID_SI_501		0x0406
#define PCI_DEVICE_ID_SI_496		0x0496
#define PCI_DEVICE_ID_SI_300		0x0300
#define PCI_DEVICE_ID_SI_315H		0x0310
#define PCI_DEVICE_ID_SI_315		0x0315
#define PCI_DEVICE_ID_SI_315PRO		0x0325
#define PCI_DEVICE_ID_SI_530		0x0530
#define PCI_DEVICE_ID_SI_540		0x0540
#define PCI_DEVICE_ID_SI_550		0x0550
#define PCI_DEVICE_ID_SI_540_VGA	0x5300
#define PCI_DEVICE_ID_SI_550_VGA	0x5315
#define PCI_DEVICE_ID_SI_601		0x0601
#define PCI_DEVICE_ID_SI_620		0x0620
#define PCI_DEVICE_ID_SI_630		0x0630
#define PCI_DEVICE_ID_SI_635		0x0635
#define PCI_DEVICE_ID_SI_640		0x0640
#define PCI_DEVICE_ID_SI_645		0x0645
#define PCI_DEVICE_ID_SI_650		0x0650
#define PCI_DEVICE_ID_SI_730		0x0730
#define PCI_DEVICE_ID_SI_630_VGA	0x6300
#define PCI_DEVICE_ID_SI_730_VGA	0x7300
#define PCI_DEVICE_ID_SI_735		0x0735
#define PCI_DEVICE_ID_SI_740		0x0740
#define PCI_DEVICE_ID_SI_745		0x0745
#define PCI_DEVICE_ID_SI_750		0x0750
#define PCI_DEVICE_ID_SI_900		0x0900
#define PCI_DEVICE_ID_SI_5107		0x5107
#define PCI_DEVICE_ID_SI_5300		0x5300
#define PCI_DEVICE_ID_SI_5511		0x5511
#define PCI_DEVICE_ID_SI_5513		0x5513
#define PCI_DEVICE_ID_SI_5571		0x5571
#define PCI_DEVICE_ID_SI_5591		0x5591
#define PCI_DEVICE_ID_SI_5597		0x5597
#define PCI_DEVICE_ID_SI_5598		0x5598
#define PCI_DEVICE_ID_SI_5600		0x5600
#define PCI_DEVICE_ID_SI_6300		0x6300
#define PCI_DEVICE_ID_SI_6306		0x6306
#define PCI_DEVICE_ID_SI_6326		0x6326
#define PCI_DEVICE_ID_SI_7001		0x7001
#define PCI_DEVICE_ID_SI_7016		0x7016

#define PCI_VENDOR_ID_HP		0x103c
#define PCI_DEVICE_ID_HP_DONNER_GFX	0x1008
#define PCI_DEVICE_ID_HP_TACHYON	0x1028
#define PCI_DEVICE_ID_HP_TACHLITE	0x1029
#define PCI_DEVICE_ID_HP_J2585A		0x1030
#define PCI_DEVICE_ID_HP_J2585B		0x1031
#define PCI_DEVICE_ID_HP_SAS		0x1048
#define PCI_DEVICE_ID_HP_DIVA1		0x1049
#define PCI_DEVICE_ID_HP_DIVA2		0x104A
#define PCI_DEVICE_ID_HP_SP2_0		0x104B
#define PCI_DEVICE_ID_HP_ZX1_SBA	0x1229
#define PCI_DEVICE_ID_HP_ZX1_IOC	0x122a
#define PCI_DEVICE_ID_HP_ZX1_LBA	0x122e

#define PCI_VENDOR_ID_PCTECH		0x1042
#define PCI_DEVICE_ID_PCTECH_RZ1000	0x1000
#define PCI_DEVICE_ID_PCTECH_RZ1001	0x1001
#define PCI_DEVICE_ID_PCTECH_SAMURAI_0	0x3000
#define PCI_DEVICE_ID_PCTECH_SAMURAI_1	0x3010
#define PCI_DEVICE_ID_PCTECH_SAMURAI_IDE 0x3020

#define PCI_VENDOR_ID_ASUSTEK		0x1043
#define PCI_DEVICE_ID_ASUSTEK_0675	0x0675

#define PCI_VENDOR_ID_DPT		0x1044
#define PCI_DEVICE_ID_DPT		0xa400

#define PCI_VENDOR_ID_OPTI		0x1045
#define PCI_DEVICE_ID_OPTI_92C178	0xc178
#define PCI_DEVICE_ID_OPTI_82C557	0xc557
#define PCI_DEVICE_ID_OPTI_82C558	0xc558
#define PCI_DEVICE_ID_OPTI_82C621	0xc621
#define PCI_DEVICE_ID_OPTI_82C700	0xc700
#define PCI_DEVICE_ID_OPTI_82C701	0xc701
#define PCI_DEVICE_ID_OPTI_82C814	0xc814
#define PCI_DEVICE_ID_OPTI_82C822	0xc822
#define PCI_DEVICE_ID_OPTI_82C861	0xc861
#define PCI_DEVICE_ID_OPTI_82C825	0xd568

#define PCI_VENDOR_ID_ELSA		0x1048
#define PCI_DEVICE_ID_ELSA_MICROLINK	0x1000
#define PCI_DEVICE_ID_ELSA_QS3000	0x3000

#define PCI_VENDOR_ID_SGS		0x104a
#define PCI_DEVICE_ID_SGS_2000		0x0008
#define PCI_DEVICE_ID_SGS_1764		0x0009

#define PCI_VENDOR_ID_BUSLOGIC		      0x104B
#define PCI_DEVICE_ID_BUSLOGIC_MULTIMASTER_NC 0x0140
#define PCI_DEVICE_ID_BUSLOGIC_MULTIMASTER    0x1040
#define PCI_DEVICE_ID_BUSLOGIC_FLASHPOINT     0x8130

#define PCI_VENDOR_ID_TI		0x104c
#define PCI_DEVICE_ID_TI_TVP4010	0x3d04
#define PCI_DEVICE_ID_TI_TVP4020	0x3d07
#define PCI_DEVICE_ID_TI_XIO2001	0x8240
#define PCI_DEVICE_ID_TI_1130		0xac12
#define PCI_DEVICE_ID_TI_1031		0xac13
#define PCI_DEVICE_ID_TI_1131		0xac15
#define PCI_DEVICE_ID_TI_1250		0xac16
#define PCI_DEVICE_ID_TI_1220		0xac17
#define PCI_DEVICE_ID_TI_1221		0xac19
#define PCI_DEVICE_ID_TI_1210		0xac1a
#define PCI_DEVICE_ID_TI_1410		0xac50
#define PCI_DEVICE_ID_TI_1450		0xac1b
#define PCI_DEVICE_ID_TI_1225		0xac1c
#define PCI_DEVICE_ID_TI_1251A		0xac1d
#define PCI_DEVICE_ID_TI_1211		0xac1e
#define PCI_DEVICE_ID_TI_1251B		0xac1f
#define PCI_DEVICE_ID_TI_4410		0xac41
#define PCI_DEVICE_ID_TI_4451		0xac42
#define PCI_DEVICE_ID_TI_1420		0xac51
#define PCI_DEVICE_ID_TI_1520		0xac55
#define PCI_DEVICE_ID_TI_1510		0xac56

#define PCI_VENDOR_ID_SONY		0x104d
#define PCI_DEVICE_ID_SONY_CXD3222	0x8039

#define PCI_VENDOR_ID_OAK		0x104e
#define PCI_DEVICE_ID_OAK_OTI107	0x0107

/* Winbond have two vendor IDs! See 0x10ad as well */
#define PCI_VENDOR_ID_WINBOND2		0x1050
#define PCI_DEVICE_ID_WINBOND2_89C940	0x0940
#define PCI_DEVICE_ID_WINBOND2_89C940F	0x5a5a
#define PCI_DEVICE_ID_WINBOND2_6692	0x6692

#define PCI_VENDOR_ID_ANIGMA		0x1051
#define PCI_DEVICE_ID_ANIGMA_MC145575	0x0100

#define PCI_VENDOR_ID_EFAR		0x1055
#define PCI_DEVICE_ID_EFAR_SLC90E66_1	0x9130
#define PCI_DEVICE_ID_EFAR_SLC90E66_0	0x9460
#define PCI_DEVICE_ID_EFAR_SLC90E66_2	0x9462
#define PCI_DEVICE_ID_EFAR_SLC90E66_3	0x9463

#define PCI_VENDOR_ID_MOTOROLA		0x1057
#define PCI_VENDOR_ID_MOTOROLA_OOPS	0x1507
#define PCI_DEVICE_ID_MOTOROLA_MPC105	0x0001
#define PCI_DEVICE_ID_MOTOROLA_MPC106	0x0002
#define PCI_DEVICE_ID_MOTOROLA_RAVEN	0x4801
#define PCI_DEVICE_ID_MOTOROLA_FALCON	0x4802
#define PCI_DEVICE_ID_MOTOROLA_HAWK	0x4803
#define PCI_DEVICE_ID_MOTOROLA_CPX8216	0x4806

#define PCI_VENDOR_ID_PROMISE		0x105a
#define PCI_DEVICE_ID_PROMISE_20265	0x0d30
#define PCI_DEVICE_ID_PROMISE_20267	0x4d30
#define PCI_DEVICE_ID_PROMISE_20246	0x4d33
#define PCI_DEVICE_ID_PROMISE_20262	0x4d38
#define PCI_DEVICE_ID_PROMISE_20263	0x0D38
#define PCI_DEVICE_ID_PROMISE_20268	0x4d68
#define PCI_DEVICE_ID_PROMISE_20270	0x6268
#define PCI_DEVICE_ID_PROMISE_20269	0x4d69
#define PCI_DEVICE_ID_PROMISE_20271	0x6269
#define PCI_DEVICE_ID_PROMISE_20275	0x1275
#define PCI_DEVICE_ID_PROMISE_20276	0x5275
#define PCI_DEVICE_ID_PROMISE_20277	0x7275
#define PCI_DEVICE_ID_PROMISE_5300	0x5300
#define PCI_DEVICE_ID_PROMISE_20378	0x3373

#define PCI_VENDOR_ID_N9		0x105d
#define PCI_DEVICE_ID_N9_I128		0x2309
#define PCI_DEVICE_ID_N9_I128_2		0x2339
#define PCI_DEVICE_ID_N9_I128_T2R	0x493d

#define PCI_VENDOR_ID_UMC		0x1060
#define PCI_DEVICE_ID_UMC_UM8673F	0x0101
#define PCI_DEVICE_ID_UMC_UM8891A	0x0891
#define PCI_DEVICE_ID_UMC_UM8886BF	0x673a
#define PCI_DEVICE_ID_UMC_UM8886A	0x886a
#define PCI_DEVICE_ID_UMC_UM8881F	0x8881
#define PCI_DEVICE_ID_UMC_UM8886F	0x8886
#define PCI_DEVICE_ID_UMC_UM9017F	0x9017
#define PCI_DEVICE_ID_UMC_UM8886N	0xe886
#define PCI_DEVICE_ID_UMC_UM8891N	0xe891

#define PCI_VENDOR_ID_X			0x1061
#define PCI_DEVICE_ID_X_AGX016		0x0001

#define PCI_VENDOR_ID_MYLEX		0x1069
#define PCI_DEVICE_ID_MYLEX_DAC960P_V2        0x0001
#define PCI_DEVICE_ID_MYLEX_DAC960P_V3        0x0002
#define PCI_DEVICE_ID_MYLEX_DAC960P_V4        0x0010
#define PCI_DEVICE_ID_MYLEX_DAC960P_V5        0x0020
#define PCI_DEVICE_ID_MYLEX_DAC960_P	0x0001
#define PCI_DEVICE_ID_MYLEX_DAC960_PD	0x0002
#define PCI_DEVICE_ID_MYLEX_DAC960_PG	0x0010
#define PCI_DEVICE_ID_MYLEX_DAC960_LA	0x0020
#define PCI_DEVICE_ID_MYLEX_DAC960_LP	0x0050
#define PCI_DEVICE_ID_MYLEX_DAC960_BA	0xBA56

#define PCI_VENDOR_ID_PICOP		0x1066
#define PCI_DEVICE_ID_PICOP_PT86C52X	0x0001
#define PCI_DEVICE_ID_PICOP_PT80C524	0x8002

#define PCI_VENDOR_ID_APPLE		0x106b
#define PCI_DEVICE_ID_APPLE_BANDIT	0x0001
#define PCI_DEVICE_ID_APPLE_GC		0x0002
#define PCI_DEVICE_ID_APPLE_HYDRA	0x000e
#define PCI_DEVICE_ID_APPLE_UNI_N_FW	0x0018
#define PCI_DEVICE_ID_APPLE_KL_USB	0x0019
#define PCI_DEVICE_ID_APPLE_UNI_N_AGP	0x0020
#define PCI_DEVICE_ID_APPLE_UNI_N_GMAC	0x0021
#define PCI_DEVICE_ID_APPLE_KEYLARGO	0x0022
#define PCI_DEVICE_ID_APPLE_UNI_N_GMACP	0x0024
#define PCI_DEVICE_ID_APPLE_KEYLARGO_P	0x0025
#define PCI_DEVICE_ID_APPLE_KL_USB_P	0x0026
#define PCI_DEVICE_ID_APPLE_UNI_N_AGP_P	0x0027
#define PCI_DEVICE_ID_APPLE_UNI_N_AGP15	0x002d
#define PCI_DEVICE_ID_APPLE_UNI_N_FW2	0x0030

#define PCI_VENDOR_ID_YAMAHA		0x1073
#define PCI_DEVICE_ID_YAMAHA_724	0x0004
#define PCI_DEVICE_ID_YAMAHA_724F	0x000d
#define PCI_DEVICE_ID_YAMAHA_740	0x000a
#define PCI_DEVICE_ID_YAMAHA_740C	0x000c
#define PCI_DEVICE_ID_YAMAHA_744	0x0010
#define PCI_DEVICE_ID_YAMAHA_754	0x0012

#define PCI_VENDOR_ID_NEXGEN		0x1074
#define PCI_DEVICE_ID_NEXGEN_82C501	0x4e78

#define PCI_VENDOR_ID_QLOGIC		0x1077
#define PCI_DEVICE_ID_QLOGIC_ISP1020	0x1020
#define PCI_DEVICE_ID_QLOGIC_ISP1022	0x1022
#define PCI_DEVICE_ID_QLOGIC_ISP2100	0x2100
#define PCI_DEVICE_ID_QLOGIC_ISP2200	0x2200

#define PCI_VENDOR_ID_CYRIX		0x1078
#define PCI_DEVICE_ID_CYRIX_5510	0x0000
#define PCI_DEVICE_ID_CYRIX_PCI_MASTER	0x0001
#define PCI_DEVICE_ID_CYRIX_5520	0x0002
#define PCI_DEVICE_ID_CYRIX_5530_LEGACY	0x0100
#define PCI_DEVICE_ID_CYRIX_5530_SMI	0x0101
#define PCI_DEVICE_ID_CYRIX_5530_IDE	0x0102
#define PCI_DEVICE_ID_CYRIX_5530_AUDIO	0x0103
#define PCI_DEVICE_ID_CYRIX_5530_VIDEO	0x0104

#define PCI_VENDOR_ID_LEADTEK		0x107d
#define PCI_DEVICE_ID_LEADTEK_805	0x0000

#define PCI_VENDOR_ID_INTERPHASE	0x107e
#define PCI_DEVICE_ID_INTERPHASE_5526	0x0004
#define PCI_DEVICE_ID_INTERPHASE_55x6	0x0005
#define PCI_DEVICE_ID_INTERPHASE_5575	0x0008

#define PCI_VENDOR_ID_CONTAQ		0x1080
#define PCI_DEVICE_ID_CONTAQ_82C599	0x0600
#define PCI_DEVICE_ID_CONTAQ_82C693	0xc693

#define PCI_VENDOR_ID_FOREX		0x1083

#define PCI_VENDOR_ID_OLICOM		0x108d
#define PCI_DEVICE_ID_OLICOM_OC3136	0x0001
#define PCI_DEVICE_ID_OLICOM_OC2315	0x0011
#define PCI_DEVICE_ID_OLICOM_OC2325	0x0012
#define PCI_DEVICE_ID_OLICOM_OC2183	0x0013
#define PCI_DEVICE_ID_OLICOM_OC2326	0x0014
#define PCI_DEVICE_ID_OLICOM_OC6151	0x0021

#define PCI_VENDOR_ID_SUN		0x108e
#define PCI_DEVICE_ID_SUN_EBUS		0x1000
#define PCI_DEVICE_ID_SUN_HAPPYMEAL	0x1001
#define PCI_DEVICE_ID_SUN_RIO_EBUS	0x1100
#define PCI_DEVICE_ID_SUN_RIO_GEM	0x1101
#define PCI_DEVICE_ID_SUN_RIO_1394	0x1102
#define PCI_DEVICE_ID_SUN_RIO_USB	0x1103
#define PCI_DEVICE_ID_SUN_GEM		0x2bad
#define PCI_DEVICE_ID_SUN_SIMBA		0x5000
#define PCI_DEVICE_ID_SUN_PBM		0x8000
#define PCI_DEVICE_ID_SUN_SCHIZO	0x8001
#define PCI_DEVICE_ID_SUN_SABRE		0xa000
#define PCI_DEVICE_ID_SUN_HUMMINGBIRD	0xa001

#define PCI_VENDOR_ID_CMD		0x1095
#define PCI_DEVICE_ID_CMD_640		0x0640
#define PCI_DEVICE_ID_CMD_643		0x0643
#define PCI_DEVICE_ID_CMD_646		0x0646
#define PCI_DEVICE_ID_CMD_647		0x0647
#define PCI_DEVICE_ID_CMD_648		0x0648
#define PCI_DEVICE_ID_CMD_649		0x0649
#define PCI_DEVICE_ID_CMD_670		0x0670
#define PCI_DEVICE_ID_CMD_680		0x0680

#define PCI_VENDOR_ID_VISION		0x1098
#define PCI_DEVICE_ID_VISION_QD8500	0x0001
#define PCI_DEVICE_ID_VISION_QD8580	0x0002

#define PCI_VENDOR_ID_BROOKTREE		0x109e
#define PCI_DEVICE_ID_BROOKTREE_848	0x0350
#define PCI_DEVICE_ID_BROOKTREE_849A	0x0351
#define PCI_DEVICE_ID_BROOKTREE_878_1	0x036e
#define PCI_DEVICE_ID_BROOKTREE_878	0x0878
#define PCI_DEVICE_ID_BROOKTREE_8474	0x8474

#define PCI_VENDOR_ID_SIERRA		0x10a8
#define PCI_DEVICE_ID_SIERRA_STB	0x0000

#define PCI_VENDOR_ID_SGI		0x10a9
#define PCI_DEVICE_ID_SGI_IOC3		0x0003

#define PCI_VENDOR_ID_ACC		0x10aa
#define PCI_DEVICE_ID_ACC_2056		0x0000

#define PCI_VENDOR_ID_WINBOND		0x10ad
#define PCI_DEVICE_ID_WINBOND_83769	0x0001
#define PCI_DEVICE_ID_WINBOND_82C105	0x0105
#define PCI_DEVICE_ID_WINBOND_83C553	0x0565

#define PCI_VENDOR_ID_DATABOOK		0x10b3
#define PCI_DEVICE_ID_DATABOOK_87144	0xb106

#define PCI_VENDOR_ID_PLX		0x10b5
#define PCI_VENDOR_ID_PLX_ROMULUS       0x106a
#define PCI_DEVICE_ID_PLX_R685		0x1030
#define PCI_DEVICE_ID_PLX_ROMULUS	0x106a
#define PCI_DEVICE_ID_PLX_SPCOM800	0x1076
#define PCI_DEVICE_ID_PLX_1077		0x1077
#define PCI_DEVICE_ID_PLX_SPCOM200	0x1103
#define PCI_DEVICE_ID_PLX_DJINN_ITOO	0x1151
#define PCI_DEVICE_ID_PLX_R753		0x1152
#define PCI_DEVICE_ID_PLX_9050		0x9050
#define PCI_DEVICE_ID_PLX_9060		0x9060
#define PCI_DEVICE_ID_PLX_9060ES	0x906E
#define PCI_DEVICE_ID_PLX_9060SD	0x906D
#define PCI_DEVICE_ID_PLX_9080		0x9080
#define PCI_DEVICE_ID_PLX_GTEK_SERIAL2	0xa001

#define PCI_VENDOR_ID_MADGE		0x10b6
#define PCI_DEVICE_ID_MADGE_MK2		0x0002
#define PCI_DEVICE_ID_MADGE_C155S	0x1001

#define PCI_VENDOR_ID_3COM		0x10b7
#define PCI_DEVICE_ID_3COM_3C985	0x0001
#define PCI_DEVICE_ID_3COM_3C339	0x3390
#define PCI_DEVICE_ID_3COM_3C590	0x5900
#define PCI_DEVICE_ID_3COM_3C595TX	0x5950
#define PCI_DEVICE_ID_3COM_3C595T4	0x5951
#define PCI_DEVICE_ID_3COM_3C595MII	0x5952
#define PCI_DEVICE_ID_3COM_3C900TPO	0x9000
#define PCI_DEVICE_ID_3COM_3C900COMBO	0x9001
#define PCI_DEVICE_ID_3COM_3C905TX	0x9050
#define PCI_DEVICE_ID_3COM_3C905T4	0x9051
#define PCI_DEVICE_ID_3COM_3C905B_TX	0x9055

#define PCI_VENDOR_ID_SMC		0x10b8
#define PCI_DEVICE_ID_SMC_EPIC100	0x0005

#define PCI_VENDOR_ID_AL		0x10b9
#define PCI_DEVICE_ID_AL_M1445		0x1445
#define PCI_DEVICE_ID_AL_M1449		0x1449
#define PCI_DEVICE_ID_AL_M1451		0x1451
#define PCI_DEVICE_ID_AL_M1461		0x1461
#define PCI_DEVICE_ID_AL_M1489		0x1489
#define PCI_DEVICE_ID_AL_M1511		0x1511
#define PCI_DEVICE_ID_AL_M1513		0x1513
#define PCI_DEVICE_ID_AL_M1521		0x1521
#define PCI_DEVICE_ID_AL_M1523		0x1523
#define PCI_DEVICE_ID_AL_M1531		0x1531
#define PCI_DEVICE_ID_AL_M1533		0x1533
#define PCI_DEVICE_ID_AL_M1541		0x1541
#define PCI_DEVICE_ID_AL_M1621          0x1621
#define PCI_DEVICE_ID_AL_M1631          0x1631
#define PCI_DEVICE_ID_AL_M1641          0x1641
#define PCI_DEVICE_ID_AL_M1644          0x1644
#define PCI_DEVICE_ID_AL_M1647          0x1647
#define PCI_DEVICE_ID_AL_M1651          0x1651
#define PCI_DEVICE_ID_AL_M1543		0x1543
#define PCI_DEVICE_ID_AL_M3307		0x3307
#define PCI_DEVICE_ID_AL_M4803		0x5215
#define PCI_DEVICE_ID_AL_M5219		0x5219
#define PCI_DEVICE_ID_AL_M5229		0x5229
#define PCI_DEVICE_ID_AL_M5237		0x5237
#define PCI_DEVICE_ID_AL_M5243		0x5243
#define PCI_DEVICE_ID_AL_M5451		0x5451
#define PCI_DEVICE_ID_AL_M7101		0x7101

#define PCI_VENDOR_ID_MITSUBISHI	0x10ba

#define PCI_VENDOR_ID_SURECOM		0x10bd
#define PCI_DEVICE_ID_SURECOM_NE34	0x0e34

#define PCI_VENDOR_ID_NEOMAGIC		0x10c8
#define PCI_DEVICE_ID_NEOMAGIC_MAGICGRAPH_NM2070 0x0001
#define PCI_DEVICE_ID_NEOMAGIC_MAGICGRAPH_128V 0x0002
#define PCI_DEVICE_ID_NEOMAGIC_MAGICGRAPH_128ZV 0x0003
#define PCI_DEVICE_ID_NEOMAGIC_MAGICGRAPH_NM2160 0x0004
#define PCI_DEVICE_ID_NEOMAGIC_MAGICMEDIA_256AV       0x0005
#define PCI_DEVICE_ID_NEOMAGIC_MAGICGRAPH_128ZVPLUS   0x0083

#define PCI_VENDOR_ID_ASP		0x10cd
#define PCI_DEVICE_ID_ASP_ABP940	0x1200
#define PCI_DEVICE_ID_ASP_ABP940U	0x1300
#define PCI_DEVICE_ID_ASP_ABP940UW	0x2300

#define PCI_VENDOR_ID_MACRONIX		0x10d9
#define PCI_DEVICE_ID_MACRONIX_MX98713	0x0512
#define PCI_DEVICE_ID_MACRONIX_MX987x5	0x0531

#define PCI_VENDOR_ID_TCONRAD		0x10da
#define PCI_DEVICE_ID_TCONRAD_TOKENRING	0x0508

#define PCI_VENDOR_ID_CERN		0x10dc
#define PCI_DEVICE_ID_CERN_SPSB_PMC	0x0001
#define PCI_DEVICE_ID_CERN_SPSB_PCI	0x0002
#define PCI_DEVICE_ID_CERN_HIPPI_DST	0x0021
#define PCI_DEVICE_ID_CERN_HIPPI_SRC	0x0022

#define PCI_DEVICE_ID_NVIDIA_CK8S_HT           0x00e1
#define PCI_DEVICE_ID_NVIDIA_CK8S_LPC          0x00e0
#define PCI_DEVICE_ID_NVIDIA_CK8S_SM           0x00e4
#define PCI_DEVICE_ID_NVIDIA_CK8S_USB          0x00e7
#define PCI_DEVICE_ID_NVIDIA_CK8S_USB2         0x00e8
#define PCI_DEVICE_ID_NVIDIA_CK8S_NIC          0x00e6
#define PCI_DEVICE_ID_NVIDIA_CK8S_ACI          0x00ea
#define PCI_DEVICE_ID_NVIDIA_CK8S_MCI          0x00e9
#define PCI_DEVICE_ID_NVIDIA_CK8S_IDE          0x00e5
#define PCI_DEVICE_ID_NVIDIA_CK8S_SATA0        0x00ee
#define PCI_DEVICE_ID_NVIDIA_CK8S_SATA1        0x00e3
#define PCI_DEVICE_ID_NVIDIA_CK8S_PCI          0x00ed
#define PCI_DEVICE_ID_NVIDIA_CK8S_PCI_AGP      0x00e2

#define PCI_DEVICE_ID_NVIDIA_MCP55_LPC          0x0360
#define PCI_DEVICE_ID_NVIDIA_MCP55_SLAVE        0x0361
#define PCI_DEVICE_ID_NVIDIA_MCP55_LPC_2        0x0362
#define PCI_DEVICE_ID_NVIDIA_MCP55_LPC_3        0x0363
#define PCI_DEVICE_ID_NVIDIA_MCP55_LPC_4        0x0364
#define PCI_DEVICE_ID_NVIDIA_MCP55_LPC_5        0x0365
#define PCI_DEVICE_ID_NVIDIA_MCP55_LPC_6        0x0366
#define PCI_DEVICE_ID_NVIDIA_MCP55_PRO          0x0367
#define PCI_DEVICE_ID_NVIDIA_MCP55_SM2          0x0368
#define PCI_DEVICE_ID_NVIDIA_MCP55_IDE          0x036E
#define PCI_DEVICE_ID_NVIDIA_MCP55_SATA0        0x037E
#define PCI_DEVICE_ID_NVIDIA_MCP55_SATA1        0x037F
#define PCI_DEVICE_ID_NVIDIA_MCP55_NIC          0x0372
#define PCI_DEVICE_ID_NVIDIA_MCP55_NIC_BRIDGE   0x0373
#define PCI_DEVICE_ID_NVIDIA_MCP55_AZA          0x0371
#define PCI_DEVICE_ID_NVIDIA_MCP55_USB          0x036C
#define PCI_DEVICE_ID_NVIDIA_MCP55_USB2         0x036D
#define PCI_DEVICE_ID_NVIDIA_MCP55_PCI          0x0370
#define PCI_DEVICE_ID_NVIDIA_MCP55_PCIE_B_C     0x0374
#define PCI_DEVICE_ID_NVIDIA_MCP55_PCIE_E       0x0375
#define PCI_DEVICE_ID_NVIDIA_MCP55_PCIE_A       0x0376
#define PCI_DEVICE_ID_NVIDIA_MCP55_PCIE_F       0x0377
#define PCI_DEVICE_ID_NVIDIA_MCP55_PCIE_D       0x0378
#define PCI_DEVICE_ID_NVIDIA_MCP55_HT           0x0369
#define PCI_DEVICE_ID_NVIDIA_MCP55_TRIM         0x036A
#define PCI_DEVICE_ID_NVIDIA_MCP55_PMU          0x036B

#define PCI_VENDOR_ID_NVIDIA			0x10de
#define PCI_DEVICE_ID_NVIDIA_TNT		0x0020
#define PCI_DEVICE_ID_NVIDIA_TNT2		0x0028
#define PCI_DEVICE_ID_NVIDIA_UTNT2		0x0029
#define PCI_DEVICE_ID_NVIDIA_VTNT2		0x002C
#define PCI_DEVICE_ID_NVIDIA_UVTNT2		0x002D
#define PCI_DEVICE_ID_NVIDIA_CK804_LPC          0x0050
#define PCI_DEVICE_ID_NVIDIA_CK804_PRO          0x0051
#define PCI_DEVICE_ID_NVIDIA_CK804_ISA          0x0051
#define PCI_DEVICE_ID_NVIDIA_CK804_SMB          0x0052
#define PCI_DEVICE_ID_NVIDIA_CK804_SM           0x0052
#define PCI_DEVICE_ID_NVIDIA_CK804_ACPI         0x0052
#define PCI_DEVICE_ID_NVIDIA_CK804_IDE          0x0053
#define PCI_DEVICE_ID_NVIDIA_CK804_SATA0        0x0054
#define PCI_DEVICE_ID_NVIDIA_CK804_SATA1        0x0055
#define PCI_DEVICE_ID_NVIDIA_CK804_ENET         0x0056
#define PCI_DEVICE_ID_NVIDIA_CK804_NIC          0x0056
#define PCI_DEVICE_ID_NVIDIA_CK804_ENET2        0x0057
#define PCI_DEVICE_ID_NVIDIA_CK804_NIC_BRIDGE   0x0057
#define PCI_DEVICE_ID_NVIDIA_CK804_MODEM        0x0058
#define PCI_DEVICE_ID_NVIDIA_CK804_MCI          0x0058
#define PCI_DEVICE_ID_NVIDIA_CK804_AUDIO        0x0059
#define PCI_DEVICE_ID_NVIDIA_CK804_ACI          0x0059
#define PCI_DEVICE_ID_NVIDIA_CK804_USB          0x005A
#define PCI_DEVICE_ID_NVIDIA_CK804_USB2         0x005B
#define PCI_DEVICE_ID_NVIDIA_CK804_PCI          0x005C
#define PCI_DEVICE_ID_NVIDIA_CK804_PCIE         0x005D
#define PCI_DEVICE_ID_NVIDIA_CK804_PCI_E        0x005D
#define PCI_DEVICE_ID_NVIDIA_CK804_MEM          0x005E
#define PCI_DEVICE_ID_NVIDIA_CK804_HT           0x005E
#define PCI_DEVICE_ID_NVIDIA_CK804_TRIM         0x005f
#define PCI_DEVICE_ID_NVIDIA_CK804_SLAVE        0x00d3
#define PCI_DEVICE_ID_NVIDIA_ITNT2		0x00A0
#define PCI_DEVICE_ID_NVIDIA_GEFORCE_SDR	0x0100
#define PCI_DEVICE_ID_NVIDIA_GEFORCE_DDR	0x0101
#define PCI_DEVICE_ID_NVIDIA_QUADRO		0x0103
#define PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX	0x0110
#define PCI_DEVICE_ID_NVIDIA_GEFORCE2_MX2	0x0111
#define PCI_DEVICE_ID_NVIDIA_GEFORCE2_GO	0x0112
#define PCI_DEVICE_ID_NVIDIA_QUADRO2_MXR	0x0113
#define PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS	0x0150
#define PCI_DEVICE_ID_NVIDIA_GEFORCE2_GTS2	0x0151
#define PCI_DEVICE_ID_NVIDIA_GEFORCE2_ULTRA	0x0152
#define PCI_DEVICE_ID_NVIDIA_QUADRO2_PRO	0x0153
#define PCI_DEVICE_ID_NVIDIA_IGEFORCE2		0x01a0
#define PCI_DEVICE_ID_NVIDIA_GEFORCE3		0x0200
#define PCI_DEVICE_ID_NVIDIA_GEFORCE3_1		0x0201
#define PCI_DEVICE_ID_NVIDIA_GEFORCE3_2		0x0202
#define PCI_DEVICE_ID_NVIDIA_QUADRO_DDC		0x0203


#define PCI_VENDOR_ID_IMS		0x10e0
#define PCI_DEVICE_ID_IMS_8849		0x8849
#define PCI_DEVICE_ID_IMS_TT128		0x9128
#define PCI_DEVICE_ID_IMS_TT3D		0x9135

#define PCI_VENDOR_ID_TEKRAM2		0x10e1
#define PCI_DEVICE_ID_TEKRAM2_690c	0x690c

#define PCI_VENDOR_ID_TUNDRA		0x10e3
#define PCI_DEVICE_ID_TUNDRA_CA91C042	0x0000

#define PCI_VENDOR_ID_AMCC		0x10e8
#define PCI_DEVICE_ID_AMCC_MYRINET	0x8043
#define PCI_DEVICE_ID_AMCC_PARASTATION	0x8062
#define PCI_DEVICE_ID_AMCC_S5933	0x807d
#define PCI_DEVICE_ID_AMCC_S5933_HEPC3	0x809c

#define PCI_VENDOR_ID_INTERG		0x10ea
#define PCI_DEVICE_ID_INTERG_1680	0x1680
#define PCI_DEVICE_ID_INTERG_1682	0x1682
#define PCI_DEVICE_ID_INTERG_2000	0x2000
#define PCI_DEVICE_ID_INTERG_2010	0x2010
#define PCI_DEVICE_ID_INTERG_5000	0x5000
#define PCI_DEVICE_ID_INTERG_5050	0x5050

#define PCI_VENDOR_ID_REALTEK		0x10ec
#define PCI_DEVICE_ID_REALTEK_8029	0x8029
#define PCI_DEVICE_ID_REALTEK_8129	0x8129
#define PCI_DEVICE_ID_REALTEK_8139	0x8139

#define PCI_VENDOR_ID_TYAN              0x10f1
#define PCI_VENDOR_ID_XILINX		0x10ee
#define PCI_DEVICE_ID_TURBOPAM		0x4020

#define PCI_VENDOR_ID_TRUEVISION	0x10fa
#define PCI_DEVICE_ID_TRUEVISION_T1000	0x000c

#define PCI_VENDOR_ID_INIT		0x1101
#define PCI_DEVICE_ID_INIT_320P		0x9100
#define PCI_DEVICE_ID_INIT_360P		0x9500

#define PCI_VENDOR_ID_CREATIVE		0x1102 // duplicate: ECTIVA
#define PCI_DEVICE_ID_CREATIVE_EMU10K1	0x0002

#define PCI_VENDOR_ID_ECTIVA		0x1102 // duplicate: CREATIVE
#define PCI_DEVICE_ID_ECTIVA_EV1938	0x8938

#define PCI_VENDOR_ID_TTI		0x1103
#define PCI_DEVICE_ID_TTI_HPT343	0x0003
#define PCI_DEVICE_ID_TTI_HPT366	0x0004
#define PCI_DEVICE_ID_TTI_HPT372	0x0005
#define PCI_DEVICE_ID_TTI_HPT302	0x0006
#define PCI_DEVICE_ID_TTI_HPT371	0x0007
#define PCI_DEVICE_ID_TTI_HPT374	0x0008

#define PCI_VENDOR_ID_VIA		0x1106
#define PCI_DEVICE_ID_VIA_8363_0	0x0305
#define PCI_DEVICE_ID_VIA_8371_0	0x0391
#define PCI_DEVICE_ID_VIA_8501_0	0x0501

#define PCI_DEVICE_ID_VIA_82C505	0x0505
#define PCI_DEVICE_ID_VIA_82C561	0x0561
#define PCI_DEVICE_ID_VIA_82C586_1	0x0571
#define PCI_DEVICE_ID_VIA_82C576	0x0576
#define PCI_DEVICE_ID_VIA_82C585	0x0585
#define PCI_DEVICE_ID_VIA_82C586_0	0x0586
#define PCI_DEVICE_ID_VIA_82C595	0x0595
#define PCI_DEVICE_ID_VIA_82C596	0x0596
#define PCI_DEVICE_ID_VIA_82C597_0	0x0597
#define PCI_DEVICE_ID_VIA_82C598_0	0x0598
#define PCI_DEVICE_ID_VIA_8601_0	0x0601
#define PCI_DEVICE_ID_VIA_8605_0	0x0605
#define PCI_DEVICE_ID_VIA_82C680	0x0680
#define PCI_DEVICE_ID_VIA_82C686	0x0686
#define PCI_DEVICE_ID_VIA_82C691	0x0691
#define PCI_DEVICE_ID_VIA_82C693	0x0693
#define PCI_DEVICE_ID_VIA_82C693_1	0x0698
#define PCI_DEVICE_ID_VIA_82C926	0x0926
#define PCI_DEVICE_ID_VIA_82C576_1	0x1571
#define PCI_DEVICE_ID_VIA_82C416        0x1571
#define PCI_DEVICE_ID_VIA_82C595_97	0x1595
#define PCI_DEVICE_ID_VIA_82C586_2	0x3038
#define PCI_DEVICE_ID_VIA_82C586_3	0x3040
#define PCI_DEVICE_ID_VIA_6305		0x3044
#define PCI_DEVICE_ID_VIA_82C596_3	0x3050
#define PCI_DEVICE_ID_VIA_82C596B_3	0x3051
#define PCI_DEVICE_ID_VIA_82C686_4	0x3057
#define PCI_DEVICE_ID_VIA_82C686_5	0x3058
#define PCI_DEVICE_ID_VIA_8233_5	0x3059
#define PCI_DEVICE_ID_VIA_8233_7	0x3065
#define PCI_DEVICE_ID_VIA_82C686_6	0x3068
#define PCI_DEVICE_ID_VIA_8233_0	0x3074
#define PCI_DEVICE_ID_VIA_8633_0	0x3091
#define PCI_DEVICE_ID_VIA_8367_0	0x3099
#define PCI_DEVICE_ID_VIA_8622		0x3102
#define PCI_DEVICE_ID_VIA_8233C_0	0x3109
#define PCI_DEVICE_ID_VIA_8361		0x3112
#define PCI_DEVICE_ID_VIA_8233A		0x3147
#define PCI_DEVICE_ID_VIA_CLE266_VGA	0x3122
#define PCI_DEVICE_ID_VIA_8623		0x3123
#define PCI_DEVICE_ID_VIA_86C100A	0x6100
#define PCI_DEVICE_ID_VIA_8231		0x8231
#define PCI_DEVICE_ID_VIA_8231_4	0x8235
#define PCI_DEVICE_ID_VIA_8235		0x3177
#define PCI_DEVICE_ID_VIA_8365_1	0x8305
#define PCI_DEVICE_ID_VIA_8371_1	0x8391
#define PCI_DEVICE_ID_VIA_8501_1	0x8501
#define PCI_DEVICE_ID_VIA_82C597_1	0x8597
#define PCI_DEVICE_ID_VIA_82C598_1	0x8598
#define PCI_DEVICE_ID_VIA_8601_1	0x8601
#define PCI_DEVICE_ID_VIA_8505_1	0x8605
#define PCI_DEVICE_ID_VIA_8633_1	0xB091
#define PCI_DEVICE_ID_VIA_8367_1	0xB099
#define PCI_DEVICE_ID_VIA_K8T800_HT_AGP_CTR	0x0282
#define PCI_DEVICE_ID_VIA_K8T800_ERR		0x1282
#define PCI_DEVICE_ID_VIA_K8T800_HOST_CTR	0x2282
#define PCI_DEVICE_ID_VIA_K8T800_DRAM		0x3282
#define PCI_DEVICE_ID_VIA_K8T800_PWR		0x4282
#define PCI_DEVICE_ID_VIA_K8T800_5		0x5282
#define PCI_DEVICE_ID_VIA_K8T800_6		0x6282
#define PCI_DEVICE_ID_VIA_K8T800_NB_SB_CTR	0x7282
#define PCI_DEVICE_ID_VIA_K8M800_HT_AGP_CTR	0x0204
#define PCI_DEVICE_ID_VIA_K8M800_ERR		0x1204
#define PCI_DEVICE_ID_VIA_K8M800_HOST_CTR	0x2204
#define PCI_DEVICE_ID_VIA_K8M800_DRAM		0x3204
#define PCI_DEVICE_ID_VIA_K8M800_PWR		0x4204
#define PCI_DEVICE_ID_VIA_K8M800_5		0x5204
#define PCI_DEVICE_ID_VIA_K8M800_6		0x6204
#define PCI_DEVICE_ID_VIA_K8M800_NB_SB_CTR	0x7204
#define PCI_DEVICE_ID_VIA_K8M800_CHROME		0x3108
#define PCI_DEVICE_ID_VIA_K8T800_AGP		0x3188
#define PCI_DEVICE_ID_VIA_K8T800_BR		0xb188
#define PCI_DEVICE_ID_VIA_K8T890CE_0	0x0238
#define PCI_DEVICE_ID_VIA_K8T890CE_1	0x1238
#define PCI_DEVICE_ID_VIA_K8T890CE_2	0x2238
#define PCI_DEVICE_ID_VIA_K8T890CE_3	0x3238
#define PCI_DEVICE_ID_VIA_K8T890CE_4	0x4238
#define PCI_DEVICE_ID_VIA_K8T890CE_5	0x5238
#define PCI_DEVICE_ID_VIA_K8T890CE_7	0x7238
#define PCI_DEVICE_ID_VIA_K8T890CF_0	0x0351
#define PCI_DEVICE_ID_VIA_K8T890CF_1	0x1351
#define PCI_DEVICE_ID_VIA_K8T890CF_2	0x2351
#define PCI_DEVICE_ID_VIA_K8T890CF_3	0x3351
#define PCI_DEVICE_ID_VIA_K8T890CF_4	0x4351
#define PCI_DEVICE_ID_VIA_K8T890CF_5	0x5351
#define PCI_DEVICE_ID_VIA_K8T890CF_7	0x7351
#define PCI_DEVICE_ID_VIA_K8M890CE_0	0x0336
#define PCI_DEVICE_ID_VIA_K8M890CE_1	0x1336
#define PCI_DEVICE_ID_VIA_K8M890CE_2	0x2336
#define PCI_DEVICE_ID_VIA_K8M890CE_3	0x3336
#define PCI_DEVICE_ID_VIA_K8M890CE_4	0x4336
#define PCI_DEVICE_ID_VIA_K8M890CE_5	0x5336
#define PCI_DEVICE_ID_VIA_K8M890CE_7	0x7336
#define PCI_DEVICE_ID_VIA_K8M890_CHROME	0x3230
#define PCI_DEVICE_ID_VIA_K8T890CE_PEG	0xa238
#define PCI_DEVICE_ID_VIA_K8T890CE_PEX0	0xc238
#define PCI_DEVICE_ID_VIA_K8T890CE_PEX1	0xd238
#define PCI_DEVICE_ID_VIA_K8T890CE_PEX2	0xe238
#define PCI_DEVICE_ID_VIA_K8T890CE_PEX3	0xf238
#define PCI_DEVICE_ID_VIA_K8T890CE_BR	0xb188
#define PCI_DEVICE_ID_VIA_VT6420_SATA	0x3149
#define PCI_DEVICE_ID_VIA_VT8237R_LPC	0x3227
#define PCI_DEVICE_ID_VIA_VT8237A_LPC	0x3337
#define PCI_DEVICE_ID_VIA_VT8237S_LPC	0x3372
#define PCI_DEVICE_ID_VIA_VT8237_SATA	0x5372
#define PCI_DEVICE_ID_VIA_VT8237A_SATA	0x0591
#define PCI_DEVICE_ID_VIA_VT8237_VLINK	0x287e
#define PCI_DEVICE_ID_VIA_VT8237R_UHCI	0x3038
#define PCI_DEVICE_ID_VIA_VT8237R_EHCI	0x3104
#define PCI_DEVICE_ID_VIA_VX855_LPC	0x8353
#define PCI_DEVICE_ID_VIA_VX855_IDE	0x5324
#define PCI_DEVICE_ID_VIA_VX855_VGA	0x5122
#define PCI_DEVICE_ID_VIA_VX855_VLINK	0x7409
#define PCI_DEVICE_ID_VIA_VX855_MEMCTRL	0x3409
/* VIA VX900 PCI IDs */
#define PCI_DEVICE_ID_VIA_VX900_HOST_BR	0x0410
#define PCI_DEVICE_ID_VIA_VX900_ERR	0x1410
#define PCI_DEVICE_ID_VIA_VX900_CPU_CTR	0x2410
#define PCI_DEVICE_ID_VIA_VX900_MEMCTRL	0x3410
#define PCI_DEVICE_ID_VIA_VX900_PM	0x4410
#define PCI_DEVICE_ID_VIA_VX900_TRAF	0x5410
#define PCI_DEVICE_ID_VIA_VX900_SCRATCH	0x6410
#define PCI_DEVICE_ID_VIA_VX900_NBRIDGE	0x7410
#define PCI_DEVICE_ID_VIA_VX900_LPC	0x8410
#define PCI_DEVICE_ID_VIA_VX900_PEX1	0xa410
#define PCI_DEVICE_ID_VIA_VX900_PEX2	0xb410
#define PCI_DEVICE_ID_VIA_VX900_PEX3	0xc410
#define PCI_DEVICE_ID_VIA_VX900_PEX4	0xd410
#define PCI_DEVICE_ID_VIA_VX900_PEX_CTR	0xe410
#define PCI_DEVICE_ID_VIA_VX900_SNMIC	0xa353
#define PCI_DEVICE_ID_VIA_VX900_PCI_BR	0xb353
#define PCI_DEVICE_ID_VIA_VX900_VGA	0x7122
#define PCI_DEVICE_ID_VIA_VX900_VID_DEC	0x9170
#define PCI_DEVICE_ID_VIA_VX900_HDAC	0x3288
#define PCI_DEVICE_ID_VIA_VX900_ETH	0x3119
#define PCI_DEVICE_ID_VIA_VX900_SATA	0x9001
/* VIA CN700 */
#define PCI_DEVICE_ID_VIA_CN700_AGP	0x0314
#define PCI_DEVICE_ID_VIA_CN700_ERR	0x1314
#define PCI_DEVICE_ID_VIA_CN700_HOST	0x2314
#define PCI_DEVICE_ID_VIA_CN700_MEMCTRL	0x3208
#define PCI_DEVICE_ID_VIA_CN700_PM	0x4314
#define PCI_DEVICE_ID_VIA_CN700_VLINK	0x7314
#define PCI_DEVICE_ID_VIA_CN700_BRIDGE	0xB198
#define PCI_DEVICE_ID_VIA_CN700_VGA	0x3344
#define PCI_DEVICE_ID_VIA_CN400_AGP	0x0259
#define PCI_DEVICE_ID_VIA_CN400_ERR	0x1259
#define PCI_DEVICE_ID_VIA_CN400_HOST	0x2259
#define PCI_DEVICE_ID_VIA_CN400_MEMCTRL	0x3259
#define PCI_DEVICE_ID_VIA_CN400_PM	0x4259
#define PCI_DEVICE_ID_VIA_CN400_VLINK	0x7259
#define PCI_DEVICE_ID_VIA_CN400_BRIDGE	0xB198
#define PCI_DEVICE_ID_VIA_CN400_VGA	0x3118

#define PCI_VENDOR_ID_SIEMENS           0x110A
#define PCI_DEVICE_ID_SIEMENS_DSCC4     0x2102

#define PCI_VENDOR_ID_SMC2		0x1113
#define PCI_DEVICE_ID_SMC2_1211TX	0x1211

#define PCI_VENDOR_ID_VORTEX		0x1119
#define PCI_DEVICE_ID_VORTEX_GDT60x0	0x0000
#define PCI_DEVICE_ID_VORTEX_GDT6000B	0x0001
#define PCI_DEVICE_ID_VORTEX_GDT6x10	0x0002
#define PCI_DEVICE_ID_VORTEX_GDT6x20	0x0003
#define PCI_DEVICE_ID_VORTEX_GDT6530	0x0004
#define PCI_DEVICE_ID_VORTEX_GDT6550	0x0005
#define PCI_DEVICE_ID_VORTEX_GDT6x17	0x0006
#define PCI_DEVICE_ID_VORTEX_GDT6x27	0x0007
#define PCI_DEVICE_ID_VORTEX_GDT6537	0x0008
#define PCI_DEVICE_ID_VORTEX_GDT6557	0x0009
#define PCI_DEVICE_ID_VORTEX_GDT6x15	0x000a
#define PCI_DEVICE_ID_VORTEX_GDT6x25	0x000b
#define PCI_DEVICE_ID_VORTEX_GDT6535	0x000c
#define PCI_DEVICE_ID_VORTEX_GDT6555	0x000d
#define PCI_DEVICE_ID_VORTEX_GDT6x17RP	0x0100
#define PCI_DEVICE_ID_VORTEX_GDT6x27RP	0x0101
#define PCI_DEVICE_ID_VORTEX_GDT6537RP	0x0102
#define PCI_DEVICE_ID_VORTEX_GDT6557RP	0x0103
#define PCI_DEVICE_ID_VORTEX_GDT6x11RP	0x0104
#define PCI_DEVICE_ID_VORTEX_GDT6x21RP	0x0105
#define PCI_DEVICE_ID_VORTEX_GDT6x17RP1	0x0110
#define PCI_DEVICE_ID_VORTEX_GDT6x27RP1	0x0111
#define PCI_DEVICE_ID_VORTEX_GDT6537RP1	0x0112
#define PCI_DEVICE_ID_VORTEX_GDT6557RP1	0x0113
#define PCI_DEVICE_ID_VORTEX_GDT6x11RP1	0x0114
#define PCI_DEVICE_ID_VORTEX_GDT6x21RP1	0x0115
#define PCI_DEVICE_ID_VORTEX_GDT6x17RP2	0x0120
#define PCI_DEVICE_ID_VORTEX_GDT6x27RP2	0x0121
#define PCI_DEVICE_ID_VORTEX_GDT6537RP2	0x0122
#define PCI_DEVICE_ID_VORTEX_GDT6557RP2	0x0123
#define PCI_DEVICE_ID_VORTEX_GDT6x11RP2	0x0124
#define PCI_DEVICE_ID_VORTEX_GDT6x21RP2	0x0125

#define PCI_VENDOR_ID_EF		0x111a
#define PCI_DEVICE_ID_EF_ATM_FPGA	0x0000
#define PCI_DEVICE_ID_EF_ATM_ASIC	0x0002

#define PCI_VENDOR_ID_IDT		0x111d
#define PCI_DEVICE_ID_IDT_IDT77201	0x0001

#define PCI_VENDOR_ID_FORE		0x1127
#define PCI_DEVICE_ID_FORE_PCA200PC	0x0210
#define PCI_DEVICE_ID_FORE_PCA200E	0x0300

#define PCI_VENDOR_ID_IMAGINGTECH	0x112f
#define PCI_DEVICE_ID_IMAGINGTECH_ICPCI	0x0000

#define PCI_VENDOR_ID_PHILIPS		0x1131
#define PCI_DEVICE_ID_PHILIPS_SAA7145	0x7145
#define PCI_DEVICE_ID_PHILIPS_SAA7146	0x7146
#define PCI_DEVICE_ID_PHILIPS_SAA9730	0x9730

#define PCI_VENDOR_ID_EICON		0x1133
#define PCI_DEVICE_ID_EICON_DIVA20PRO	0xe001
#define PCI_DEVICE_ID_EICON_DIVA20	0xe002
#define PCI_DEVICE_ID_EICON_DIVA20PRO_U	0xe003
#define PCI_DEVICE_ID_EICON_DIVA20_U	0xe004
#define PCI_DEVICE_ID_EICON_DIVA201	0xe005
#define PCI_DEVICE_ID_EICON_MAESTRA	0xe010
#define PCI_DEVICE_ID_EICON_MAESTRAQ	0xe012
#define PCI_DEVICE_ID_EICON_MAESTRAQ_U	0xe013
#define PCI_DEVICE_ID_EICON_MAESTRAP	0xe014

#define PCI_VENDOR_ID_CYCLONE		0x113c
#define PCI_DEVICE_ID_CYCLONE_SDK	0x0001

#define PCI_VENDOR_ID_ALLIANCE		0x1142
#define PCI_DEVICE_ID_ALLIANCE_PROMOTIO	0x3210
#define PCI_DEVICE_ID_ALLIANCE_PROVIDEO	0x6422
#define PCI_DEVICE_ID_ALLIANCE_AT24	0x6424
#define PCI_DEVICE_ID_ALLIANCE_AT3D	0x643d

#define PCI_VENDOR_ID_SYSKONNECT	0x1148
#define PCI_DEVICE_ID_SYSKONNECT_FP	0x4000
#define PCI_DEVICE_ID_SYSKONNECT_TR	0x4200
#define PCI_DEVICE_ID_SYSKONNECT_GE	0x4300

#define PCI_VENDOR_ID_VMIC		0x114a
#define PCI_DEVICE_ID_VMIC_VME		0x7587

#define PCI_VENDOR_ID_DIGI		0x114f
#define PCI_DEVICE_ID_DIGI_EPC		0x0002
#define PCI_DEVICE_ID_DIGI_RIGHTSWITCH	0x0003
#define PCI_DEVICE_ID_DIGI_XEM		0x0004
#define PCI_DEVICE_ID_DIGI_XR		0x0005
#define PCI_DEVICE_ID_DIGI_CX		0x0006
#define PCI_DEVICE_ID_DIGI_XRJ		0x0009
#define PCI_DEVICE_ID_DIGI_EPCJ		0x000a
#define PCI_DEVICE_ID_DIGI_XR_920	0x0027
#define PCI_DEVICE_ID_DIGI_DF_M_IOM2_E	0x0070
#define PCI_DEVICE_ID_DIGI_DF_M_E	0x0071
#define PCI_DEVICE_ID_DIGI_DF_M_IOM2_A	0x0072
#define PCI_DEVICE_ID_DIGI_DF_M_A	0x0073

#define PCI_VENDOR_ID_MUTECH		0x1159
#define PCI_DEVICE_ID_MUTECH_MV1000	0x0001

#define PCI_VENDOR_ID_XIRCOM		0x115d
#define PCI_DEVICE_ID_XIRCOM_X3201_ETH	0x0003
#define PCI_DEVICE_ID_XIRCOM_X3201_MDM	0x0103

#define PCI_VENDOR_ID_RENDITION		0x1163
#define PCI_DEVICE_ID_RENDITION_VERITE	0x0001
#define PCI_DEVICE_ID_RENDITION_VERITE2100 0x2000

#define PCI_VENDOR_ID_SERVERWORKS	  0x1166
#define PCI_DEVICE_ID_SERVERWORKS_HE	  0x0008
#define PCI_DEVICE_ID_SERVERWORKS_LE	  0x0009
#define PCI_DEVICE_ID_SERVERWORKS_CIOB30  0x0010
#define PCI_DEVICE_ID_SERVERWORKS_CMIC_HE 0x0011
#define PCI_DEVICE_ID_SERVERWORKS_GCNB_LE 0x0017
#define PCI_DEVICE_ID_SERVERWORKS_OSB4	  0x0200
#define PCI_DEVICE_ID_SERVERWORKS_CSB5	  0x0201
#define PCI_DEVICE_ID_SERVERWORKS_CSB6    0x0203
#define PCI_DEVICE_ID_SERVERWORKS_OSB4IDE 0x0211
#define PCI_DEVICE_ID_SERVERWORKS_CSB5IDE 0x0212
#define PCI_DEVICE_ID_SERVERWORKS_CSB6IDE 0x0213
#define PCI_DEVICE_ID_SERVERWORKS_OSB4USB 0x0220
#define PCI_DEVICE_ID_SERVERWORKS_CSB5USB PCI_DEVICE_ID_SERVERWORKS_OSB4USB
#define PCI_DEVICE_ID_SERVERWORKS_CSB6USB 0x0221
#define PCI_DEVICE_ID_SERVERWORKS_GCLE    0x0225
#define PCI_DEVICE_ID_SERVERWORKS_GCLE2   0x0227
#define PCI_DEVICE_ID_SERVERWORKS_CSB5ISA 0x0230

#define PCI_DEVICE_ID_SERVERWORKS_BCM5780_PXB  0x0130
#define PCI_DEVICE_ID_SERVERWORKS_BCM5780_PCIE 0x0132
#define PCI_DEVICE_ID_BROADCOM_BCM5780_NIC 0x1668
#define PCI_DEVICE_ID_BROADCOM_BCM5780_NIC1 0x1669

#define PCI_DEVICE_ID_SERVERWORKS_BCM21000_EXB0 0x140
#define PCI_DEVICE_ID_SERVERWORKS_BCM21000_EXB1 0x142
#define PCI_DEVICE_ID_SERVERWORKS_BCM21000_EXB2 0x144

#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_HT_PXB 0x0036
#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_PXBX   0x0104
#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_SATA         0x024a
#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_SB_PCI_MAIN 0x0205
#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_IDE 0x0214
#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_LPC 0x0234
#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_WDT 0x0238
#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_XIOAPIC 0x0235
#define PCI_DEVICE_ID_SERVERWORKS_BCM5785_USB 0x0223

#define PCI_VENDOR_ID_SBE		0x1176
#define PCI_DEVICE_ID_SBE_WANXL100	0x0301
#define PCI_DEVICE_ID_SBE_WANXL200	0x0302
#define PCI_DEVICE_ID_SBE_WANXL400	0x0104

#define PCI_VENDOR_ID_TOSHIBA		0x1179
#define PCI_DEVICE_ID_TOSHIBA_601	0x0601
#define PCI_DEVICE_ID_TOSHIBA_TOPIC95	0x060a
#define PCI_DEVICE_ID_TOSHIBA_TOPIC97	0x060f

#define PCI_VENDOR_ID_TOSHIBA_2		0x102f
#define PCI_DEVICE_ID_TOSHIBA_TX3927	0x000a
#define PCI_DEVICE_ID_TOSHIBA_TC35815CF	0x0030
#define PCI_DEVICE_ID_TOSHIBA_TX4927	0x0180

#define PCI_VENDOR_ID_RICOH		0x1180
#define PCI_DEVICE_ID_RICOH_RL5C465	0x0465
#define PCI_DEVICE_ID_RICOH_RL5C466	0x0466
#define PCI_DEVICE_ID_RICOH_RL5C475	0x0475
#define PCI_DEVICE_ID_RICOH_RL5C476	0x0476
#define PCI_DEVICE_ID_RICOH_RL5C478	0x0478
#define PCI_DEVICE_ID_RICOH_R5C822	0x0822

#define PCI_VENDOR_ID_ARTOP		0x1191
#define PCI_DEVICE_ID_ARTOP_ATP8400	0x0004
#define PCI_DEVICE_ID_ARTOP_ATP850UF	0x0005
#define PCI_DEVICE_ID_ARTOP_ATP860	0x0006
#define PCI_DEVICE_ID_ARTOP_ATP860R	0x0007
#define PCI_DEVICE_ID_ARTOP_ATP865	0x0008
#define PCI_DEVICE_ID_ARTOP_ATP865R	0x0009
#define PCI_DEVICE_ID_ARTOP_AEC7610	0x8002
#define PCI_DEVICE_ID_ARTOP_AEC7612UW	0x8010
#define PCI_DEVICE_ID_ARTOP_AEC7612U	0x8020
#define PCI_DEVICE_ID_ARTOP_AEC7612S	0x8030
#define PCI_DEVICE_ID_ARTOP_AEC7612D	0x8040
#define PCI_DEVICE_ID_ARTOP_AEC7612SUW	0x8050
#define PCI_DEVICE_ID_ARTOP_8060	0x8060

#define PCI_VENDOR_ID_ZEITNET		0x1193
#define PCI_DEVICE_ID_ZEITNET_1221	0x0001
#define PCI_DEVICE_ID_ZEITNET_1225	0x0002

#define PCI_VENDOR_ID_OMEGA		0x119b
#define PCI_DEVICE_ID_OMEGA_82C092G	0x1221

#define PCI_VENDOR_ID_FUJITSU_ME	0x119e
#define PCI_DEVICE_ID_FUJITSU_FS155	0x0001
#define PCI_DEVICE_ID_FUJITSU_FS50	0x0003

#define PCI_SUBVENDOR_ID_KEYSPAN	0x11a9
#define PCI_SUBDEVICE_ID_KEYSPAN_SX2	0x5334

#define PCI_VENDOR_ID_GALILEO		0x11ab
#define PCI_DEVICE_ID_GALILEO_GT64011	0x4146
#define PCI_DEVICE_ID_GALILEO_GT64111	0x4146
#define PCI_DEVICE_ID_GALILEO_GT96100	0x9652
#define PCI_DEVICE_ID_GALILEO_GT96100A	0x9653

#define PCI_VENDOR_ID_LITEON		0x11ad
#define PCI_DEVICE_ID_LITEON_LNE100TX	0x0002

#define PCI_VENDOR_ID_V3		0x11b0
#define PCI_DEVICE_ID_V3_V960		0x0001
#define PCI_DEVICE_ID_V3_V350		0x0001
#define PCI_DEVICE_ID_V3_V960V2         0x0002
#define PCI_DEVICE_ID_V3_V350V2         0x0002
#define PCI_DEVICE_ID_V3_V961		0x0002
#define PCI_DEVICE_ID_V3_V351		0x0002

#define PCI_VENDOR_ID_NP		0x11bc
#define PCI_DEVICE_ID_NP_PCI_FDDI	0x0001

#define PCI_VENDOR_ID_ATT		0x11c1
#define PCI_DEVICE_ID_ATT_L56XMF	0x0440
#define PCI_DEVICE_ID_ATT_VENUS_MODEM	0x480


#define PCI_VENDOR_ID_SPECIALIX		0x11cb
#define PCI_DEVICE_ID_SPECIALIX_IO8	0x2000
#define PCI_DEVICE_ID_SPECIALIX_XIO	0x4000
#define PCI_DEVICE_ID_SPECIALIX_RIO	0x8000
#define PCI_SUBDEVICE_ID_SPECIALIX_SPEED4 0xa004

#define PCI_VENDOR_ID_AURAVISION	0x11d1
#define PCI_DEVICE_ID_AURAVISION_VXP524	0x01f7

#define PCI_VENDOR_ID_ANALOG_DEVICES	0x11d4
#define PCI_DEVICE_ID_AD1889JS		0x1889

#define PCI_VENDOR_ID_IKON		0x11d5
#define PCI_DEVICE_ID_IKON_10115	0x0115
#define PCI_DEVICE_ID_IKON_10117	0x0117

#define PCI_VENDOR_ID_ZORAN		0x11de
#define PCI_DEVICE_ID_ZORAN_36057	0x6057
#define PCI_DEVICE_ID_ZORAN_36120	0x6120

#define PCI_VENDOR_ID_KINETIC		0x11f4
#define PCI_DEVICE_ID_KINETIC_2915	0x2915

#define PCI_VENDOR_ID_COMPEX		0x11f6
#define PCI_DEVICE_ID_COMPEX_ENET100VG4	0x0112
#define PCI_DEVICE_ID_COMPEX_RL2000	0x1401

#define PCI_VENDOR_ID_RP		0x11fe
#define PCI_DEVICE_ID_RP32INTF		0x0001
#define PCI_DEVICE_ID_RP8INTF		0x0002
#define PCI_DEVICE_ID_RP16INTF		0x0003
#define PCI_DEVICE_ID_RP4QUAD		0x0004
#define PCI_DEVICE_ID_RP8OCTA		0x0005
#define PCI_DEVICE_ID_RP8J		0x0006
#define PCI_DEVICE_ID_RPP4		0x000A
#define PCI_DEVICE_ID_RPP8		0x000B
#define PCI_DEVICE_ID_RP8M		0x000C

#define PCI_VENDOR_ID_CYCLADES		0x120e
#define PCI_DEVICE_ID_CYCLOM_Y_Lo	0x0100
#define PCI_DEVICE_ID_CYCLOM_Y_Hi	0x0101
#define PCI_DEVICE_ID_CYCLOM_4Y_Lo	0x0102
#define PCI_DEVICE_ID_CYCLOM_4Y_Hi	0x0103
#define PCI_DEVICE_ID_CYCLOM_8Y_Lo	0x0104
#define PCI_DEVICE_ID_CYCLOM_8Y_Hi	0x0105
#define PCI_DEVICE_ID_CYCLOM_Z_Lo	0x0200
#define PCI_DEVICE_ID_CYCLOM_Z_Hi	0x0201
#define PCI_DEVICE_ID_PC300_RX_2	0x0300
#define PCI_DEVICE_ID_PC300_RX_1	0x0301
#define PCI_DEVICE_ID_PC300_TE_2	0x0310
#define PCI_DEVICE_ID_PC300_TE_1	0x0311

#define PCI_VENDOR_ID_ESSENTIAL		0x120f
#define PCI_DEVICE_ID_ESSENTIAL_ROADRUNNER	0x0001

#define PCI_VENDOR_ID_O2		0x1217
#define PCI_DEVICE_ID_O2_6729		0x6729
#define PCI_DEVICE_ID_O2_6730		0x673a
#define PCI_DEVICE_ID_O2_6832		0x6832
#define PCI_DEVICE_ID_O2_6836		0x6836
#define PCI_DEVICE_ID_O2_BH720		0x8620

#define PCI_VENDOR_ID_3DFX		0x121a
#define PCI_DEVICE_ID_3DFX_VOODOO	0x0001
#define PCI_DEVICE_ID_3DFX_VOODOO2	0x0002
#define PCI_DEVICE_ID_3DFX_BANSHEE	0x0003
#define PCI_DEVICE_ID_3DFX_VOODOO3	0x0005

#define PCI_VENDOR_ID_SIGMADES		0x1236
#define PCI_DEVICE_ID_SIGMADES_6425	0x6401

#define PCI_VENDOR_ID_CCUBE		0x123f

#define PCI_VENDOR_ID_AVM		0x1244
#define PCI_DEVICE_ID_AVM_B1		0x0700
#define PCI_DEVICE_ID_AVM_C4		0x0800
#define PCI_DEVICE_ID_AVM_A1		0x0a00
#define PCI_DEVICE_ID_AVM_A1_V2		0x0e00
#define PCI_DEVICE_ID_AVM_C2		0x1100
#define PCI_DEVICE_ID_AVM_T1		0x1200

#define PCI_VENDOR_ID_DIPIX		0x1246

#define PCI_VENDOR_ID_STALLION		0x124d
#define PCI_DEVICE_ID_STALLION_ECHPCI832 0x0000
#define PCI_DEVICE_ID_STALLION_ECHPCI864 0x0002
#define PCI_DEVICE_ID_STALLION_EIOPCI	0x0003

#define PCI_VENDOR_ID_OPTIBASE		0x1255
#define PCI_DEVICE_ID_OPTIBASE_FORGE	0x1110
#define PCI_DEVICE_ID_OPTIBASE_FUSION	0x1210
#define PCI_DEVICE_ID_OPTIBASE_VPLEX	0x2110
#define PCI_DEVICE_ID_OPTIBASE_VPLEXCC	0x2120
#define PCI_DEVICE_ID_OPTIBASE_VQUEST	0x2130

#define PCI_VENDOR_ID_ESS		0x125d
#define PCI_DEVICE_ID_ESS_ESS1968	0x1968
#define PCI_DEVICE_ID_ESS_AUDIOPCI	0x1969
#define PCI_DEVICE_ID_ESS_ESS1978	0x1978

#define PCI_VENDOR_ID_SATSAGEM		0x1267
#define PCI_DEVICE_ID_SATSAGEM_NICCY	0x1016
#define PCI_DEVICE_ID_SATSAGEM_PCR2101	0x5352
#define PCI_DEVICE_ID_SATSAGEM_TELSATTURBO 0x5a4b

#define PCI_VENDOR_ID_HUGHES		0x1273
#define PCI_DEVICE_ID_HUGHES_DIRECPC	0x0002

#define PCI_VENDOR_ID_ENSONIQ		0x1274
#define PCI_DEVICE_ID_ENSONIQ_CT5880	0x5880
#define PCI_DEVICE_ID_ENSONIQ_AUDIOPCI  0x5000
#define PCI_DEVICE_ID_ENSONIQ_ES1370	0x5000
#define PCI_DEVICE_ID_ENSONIQ_ES1371	0x1371

#define PCI_VENDOR_ID_ROCKWELL		0x127A

#define PCI_VENDOR_ID_ITE		0x1283
#define PCI_DEVICE_ID_ITE_IT8172G	0x8172
#define PCI_DEVICE_ID_ITE_IT8172G_AUDIO 0x0801
#define PCI_DEVICE_ID_ITE_8872		0x8872

#define PCI_DEVICE_ID_ITE_IT8330G_0    0xe886

/* formerly Platform Tech */
#define PCI_VENDOR_ID_ESS_OLD		0x1285
#define PCI_DEVICE_ID_ESS_ESS0100	0x0100

#define PCI_VENDOR_ID_ALTEON		0x12ae
#define PCI_DEVICE_ID_ALTEON_ACENIC	0x0001

#define PCI_VENDOR_ID_USR		0x12B9

#define PCI_SUBVENDOR_ID_CONNECT_TECH			0x12c4
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH8_232		0x0001
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH4_232		0x0002
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH2_232		0x0003
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH8_485		0x0004
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH8_485_4_4	0x0005
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH4_485		0x0006
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH4_485_2_2	0x0007
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH2_485		0x0008
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH8_485_2_6	0x0009
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH081101V1	0x000A
#define PCI_SUBDEVICE_ID_CONNECT_TECH_BH041101V1	0x000B

#define PCI_VENDOR_ID_PICTUREL		0x12c5
#define PCI_DEVICE_ID_PICTUREL_PCIVST	0x0081

#define PCI_VENDOR_ID_NVIDIA_SGS	0x12d2
#define PCI_DEVICE_ID_NVIDIA_SGS_RIVA128 0x0018

#define PCI_SUBVENDOR_ID_CHASE_PCIFAST		0x12E0
#define PCI_SUBDEVICE_ID_CHASE_PCIFAST4		0x0031
#define PCI_SUBDEVICE_ID_CHASE_PCIFAST8		0x0021
#define PCI_SUBDEVICE_ID_CHASE_PCIFAST16	0x0011
#define PCI_SUBDEVICE_ID_CHASE_PCIFAST16FMC	0x0041
#define PCI_SUBVENDOR_ID_CHASE_PCIRAS		0x124D
#define PCI_SUBDEVICE_ID_CHASE_PCIRAS4		0xF001
#define PCI_SUBDEVICE_ID_CHASE_PCIRAS8		0xF010

#define PCI_VENDOR_ID_AUREAL		0x12eb
#define PCI_DEVICE_ID_AUREAL_VORTEX_1	0x0001
#define PCI_DEVICE_ID_AUREAL_VORTEX_2	0x0002

#define PCI_VENDOR_ID_CBOARDS		0x1307
#define PCI_DEVICE_ID_CBOARDS_DAS1602_16 0x0001

#define PCI_VENDOR_ID_SIIG		0x131f
#define PCI_DEVICE_ID_SIIG_1S_10x_550	0x1000
#define PCI_DEVICE_ID_SIIG_1S_10x_650	0x1001
#define PCI_DEVICE_ID_SIIG_1S_10x_850	0x1002
#define PCI_DEVICE_ID_SIIG_1S1P_10x_550	0x1010
#define PCI_DEVICE_ID_SIIG_1S1P_10x_650	0x1011
#define PCI_DEVICE_ID_SIIG_1S1P_10x_850	0x1012
#define PCI_DEVICE_ID_SIIG_1P_10x	0x1020
#define PCI_DEVICE_ID_SIIG_2P_10x	0x1021
#define PCI_DEVICE_ID_SIIG_2S_10x_550	0x1030
#define PCI_DEVICE_ID_SIIG_2S_10x_650	0x1031
#define PCI_DEVICE_ID_SIIG_2S_10x_850	0x1032
#define PCI_DEVICE_ID_SIIG_2S1P_10x_550	0x1034
#define PCI_DEVICE_ID_SIIG_2S1P_10x_650	0x1035
#define PCI_DEVICE_ID_SIIG_2S1P_10x_850	0x1036
#define PCI_DEVICE_ID_SIIG_4S_10x_550	0x1050
#define PCI_DEVICE_ID_SIIG_4S_10x_650	0x1051
#define PCI_DEVICE_ID_SIIG_4S_10x_850	0x1052
#define PCI_DEVICE_ID_SIIG_1S_20x_550	0x2000
#define PCI_DEVICE_ID_SIIG_1S_20x_650	0x2001
#define PCI_DEVICE_ID_SIIG_1S_20x_850	0x2002
#define PCI_DEVICE_ID_SIIG_1P_20x	0x2020
#define PCI_DEVICE_ID_SIIG_2P_20x	0x2021
#define PCI_DEVICE_ID_SIIG_2S_20x_550	0x2030
#define PCI_DEVICE_ID_SIIG_2S_20x_650	0x2031
#define PCI_DEVICE_ID_SIIG_2S_20x_850	0x2032
#define PCI_DEVICE_ID_SIIG_2P1S_20x_550	0x2040
#define PCI_DEVICE_ID_SIIG_2P1S_20x_650	0x2041
#define PCI_DEVICE_ID_SIIG_2P1S_20x_850	0x2042
#define PCI_DEVICE_ID_SIIG_1S1P_20x_550	0x2010
#define PCI_DEVICE_ID_SIIG_1S1P_20x_650	0x2011
#define PCI_DEVICE_ID_SIIG_1S1P_20x_850	0x2012
#define PCI_DEVICE_ID_SIIG_4S_20x_550	0x2050
#define PCI_DEVICE_ID_SIIG_4S_20x_650	0x2051
#define PCI_DEVICE_ID_SIIG_4S_20x_850	0x2052
#define PCI_DEVICE_ID_SIIG_2S1P_20x_550	0x2060
#define PCI_DEVICE_ID_SIIG_2S1P_20x_650	0x2061
#define PCI_DEVICE_ID_SIIG_2S1P_20x_850	0x2062

#define PCI_VENDOR_ID_DOMEX		0x134a
#define PCI_DEVICE_ID_DOMEX_DMX3191D	0x0001

#define PCI_VENDOR_ID_QUATECH		0x135C
#define PCI_DEVICE_ID_QUATECH_QSC100	0x0010
#define PCI_DEVICE_ID_QUATECH_DSC100	0x0020
#define PCI_DEVICE_ID_QUATECH_DSC200	0x0030
#define PCI_DEVICE_ID_QUATECH_QSC200	0x0040
#define PCI_DEVICE_ID_QUATECH_ESC100D	0x0050
#define PCI_DEVICE_ID_QUATECH_ESC100M	0x0060

#define PCI_VENDOR_ID_SEALEVEL		0x135e
#define PCI_DEVICE_ID_SEALEVEL_U530	0x7101
#define PCI_DEVICE_ID_SEALEVEL_UCOMM2	0x7201
#define PCI_DEVICE_ID_SEALEVEL_UCOMM422	0x7402
#define PCI_DEVICE_ID_SEALEVEL_UCOMM232	0x7202
#define PCI_DEVICE_ID_SEALEVEL_COMM4	0x7401
#define PCI_DEVICE_ID_SEALEVEL_COMM8	0x7801

#define PCI_VENDOR_ID_HYPERCOPE		0x1365
#define PCI_DEVICE_ID_HYPERCOPE_PLX	0x9050
#define PCI_SUBDEVICE_ID_HYPERCOPE_OLD_ERGO	0x0104
#define PCI_SUBDEVICE_ID_HYPERCOPE_ERGO		0x0106
#define PCI_SUBDEVICE_ID_HYPERCOPE_METRO	0x0107
#define PCI_SUBDEVICE_ID_HYPERCOPE_CHAMP2	0x0108
#define PCI_SUBDEVICE_ID_HYPERCOPE_PLEXUS	0x0109

#define PCI_VENDOR_ID_KAWASAKI		0x136b
#define PCI_DEVICE_ID_MCHIP_KL5A72002	0xff01

#define PCI_VENDOR_ID_LMC		0x1376
#define PCI_DEVICE_ID_LMC_HSSI		0x0003
#define PCI_DEVICE_ID_LMC_DS3		0x0004
#define PCI_DEVICE_ID_LMC_SSI		0x0005
#define PCI_DEVICE_ID_LMC_T1		0x0006

#define PCI_VENDOR_ID_NETGEAR		0x1385
#define PCI_DEVICE_ID_NETGEAR_GA620	0x620a
#define PCI_DEVICE_ID_NETGEAR_GA622	0x622a

#define PCI_VENDOR_ID_APPLICOM		0x1389
#define PCI_DEVICE_ID_APPLICOM_PCIGENERIC 0x0001
#define PCI_DEVICE_ID_APPLICOM_PCI2000IBS_CAN 0x0002
#define PCI_DEVICE_ID_APPLICOM_PCI2000PFB 0x0003

#define PCI_VENDOR_ID_MOXA		0x1393
#define PCI_DEVICE_ID_MOXA_C104		0x1040
#define PCI_DEVICE_ID_MOXA_C168		0x1680
#define PCI_DEVICE_ID_MOXA_CP204J	0x2040
#define PCI_DEVICE_ID_MOXA_C218		0x2180
#define PCI_DEVICE_ID_MOXA_C320		0x3200

#define PCI_VENDOR_ID_CCD		0x1397
#define PCI_DEVICE_ID_CCD_2BD0		0x2bd0
#define PCI_DEVICE_ID_CCD_B000		0xb000
#define PCI_DEVICE_ID_CCD_B006		0xb006
#define PCI_DEVICE_ID_CCD_B007		0xb007
#define PCI_DEVICE_ID_CCD_B008		0xb008
#define PCI_DEVICE_ID_CCD_B009		0xb009
#define PCI_DEVICE_ID_CCD_B00A		0xb00a
#define PCI_DEVICE_ID_CCD_B00B		0xb00b
#define PCI_DEVICE_ID_CCD_B00C		0xb00c
#define PCI_DEVICE_ID_CCD_B100		0xb100

#define PCI_VENDOR_ID_NOKIA		0x13B8
#define PCI_VENDOR_ID_NOKIA_WIRELESS	0x1603
#define PCI_VENDOR_ID_NOKIA_HOME	0x1622

#define PCI_VENDOR_ID_3WARE		0x13C1
#define PCI_DEVICE_ID_3WARE_1000	0x1000

#define PCI_VENDOR_ID_ABOCOM		0x13D1
#define PCI_DEVICE_ID_ABOCOM_2BD1       0x2BD1

#define PCI_VENDOR_ID_CMEDIA		0x13f6
#define PCI_DEVICE_ID_CMEDIA_CM8338A	0x0100
#define PCI_DEVICE_ID_CMEDIA_CM8338B	0x0101
#define PCI_DEVICE_ID_CMEDIA_CM8738	0x0111
#define PCI_DEVICE_ID_CMEDIA_CM8738B	0x0112

#define PCI_VENDOR_ID_LAVA		0x1407
#define PCI_DEVICE_ID_LAVA_DSERIAL	0x0100 /* 2x 16550 */
#define PCI_DEVICE_ID_LAVA_QUATRO_A	0x0101 /* 2x 16550, half of 4 port */
#define PCI_DEVICE_ID_LAVA_QUATRO_B	0x0102 /* 2x 16550, half of 4 port */
#define PCI_DEVICE_ID_LAVA_OCTO_A	0x0180 /* 4x 16550A, half of 8 port */
#define PCI_DEVICE_ID_LAVA_OCTO_B	0x0181 /* 4x 16550A, half of 8 port */
#define PCI_DEVICE_ID_LAVA_PORT_PLUS	0x0200 /* 2x 16650 */
#define PCI_DEVICE_ID_LAVA_QUAD_A	0x0201 /* 2x 16650, half of 4 port */
#define PCI_DEVICE_ID_LAVA_QUAD_B	0x0202 /* 2x 16650, half of 4 port */
#define PCI_DEVICE_ID_LAVA_SSERIAL	0x0500 /* 1x 16550 */
#define PCI_DEVICE_ID_LAVA_PORT_650	0x0600 /* 1x 16650 */
#define PCI_DEVICE_ID_LAVA_PARALLEL	0x8000
#define PCI_DEVICE_ID_LAVA_DUAL_PAR_A	0x8002 /* The Lava Dual Parallel is */
#define PCI_DEVICE_ID_LAVA_DUAL_PAR_B	0x8003 /* two PCI devices on a card */
#define PCI_DEVICE_ID_LAVA_BOCA_IOPPAR	0x8800

#define PCI_VENDOR_ID_TIMEDIA		0x1409
#define PCI_DEVICE_ID_TIMEDIA_1889	0x7168

#define PCI_VENDOR_ID_OXSEMI		0x1415
#define PCI_DEVICE_ID_OXSEMI_12PCI840	0x8403
#define PCI_DEVICE_ID_OXSEMI_16PCI954	0x9501
#define PCI_DEVICE_ID_OXSEMI_16PCI95N	0x9511
#define PCI_DEVICE_ID_OXSEMI_16PCI954PP	0x9513
#define PCI_DEVICE_ID_OXSEMI_16PCI952	0x9521

#define PCI_VENDOR_ID_AIRONET		0x14b9
#define PCI_DEVICE_ID_AIRONET_4800_1	0x0001
#define PCI_DEVICE_ID_AIRONET_4800	0x4500 // values switched?  see
#define PCI_DEVICE_ID_AIRONET_4500	0x4800 // drivers/net/aironet4500_card.c

#define PCI_VENDOR_ID_TITAN		0x14D2
#define PCI_DEVICE_ID_TITAN_010L	0x8001
#define PCI_DEVICE_ID_TITAN_100L	0x8010
#define PCI_DEVICE_ID_TITAN_110L	0x8011
#define PCI_DEVICE_ID_TITAN_200L	0x8020
#define PCI_DEVICE_ID_TITAN_210L	0x8021
#define PCI_DEVICE_ID_TITAN_400L	0x8040
#define PCI_DEVICE_ID_TITAN_800L	0x8080
#define PCI_DEVICE_ID_TITAN_100		0xA001
#define PCI_DEVICE_ID_TITAN_200		0xA005
#define PCI_DEVICE_ID_TITAN_400		0xA003
#define PCI_DEVICE_ID_TITAN_800B	0xA004

#define PCI_VENDOR_ID_PANACOM		0x14d4
#define PCI_DEVICE_ID_PANACOM_QUADMODEM	0x0400
#define PCI_DEVICE_ID_PANACOM_DUALMODEM	0x0402

#define PCI_VENDOR_ID_AFAVLAB		0x14db
#define PCI_DEVICE_ID_AFAVLAB_TK9902  0x2120
#define PCI_DEVICE_ID_AFAVLAB_P028	0x2180

#define PCI_VENDOR_ID_BROADCOM		0x14e4
#define PCI_DEVICE_ID_TIGON3_5700	0x1644
#define PCI_DEVICE_ID_TIGON3_5701	0x1645
#define PCI_DEVICE_ID_TIGON3_5702	0x1646
#define PCI_DEVICE_ID_TIGON3_5703	0x1647
#define PCI_DEVICE_ID_TIGON3_5702FE	0x164d
#define PCI_DEVICE_ID_TIGON3_5702X	0x16a6
#define PCI_DEVICE_ID_TIGON3_5703X	0x16a7

#define PCI_VENDOR_ID_SYBA		0x1592
#define PCI_DEVICE_ID_SYBA_2P_EPP	0x0782
#define PCI_DEVICE_ID_SYBA_1P_ECP	0x0783

#define PCI_VENDOR_ID_MORETON		0x15aa
#define PCI_DEVICE_ID_RASTEL_2PORT	0x2000

#define PCI_VENDOR_ID_ZOLTRIX		0x15b0
#define PCI_DEVICE_ID_ZOLTRIX_2BD0	0x2bd0

#define PCI_VENDOR_ID_PDC		0x15e9
#define PCI_DEVICE_ID_PDC_1841		0x1841

#define PCI_VENDOR_ID_RDC		0x17f3
#define PCI_DEVICE_ID_RDC_R8610_NB	0x6020
#define PCI_DEVICE_ID_RDC_R8610_SB	0x6030

#define PCI_VENDOR_ID_ALTIMA		0x173b
#define PCI_DEVICE_ID_ALTIMA_AC1000	0x03e8
#define PCI_DEVICE_ID_ALTIMA_AC9100	0x03ea

#define PCI_VENDOR_ID_XGI		0x18ca
#define PCI_DEVICE_ID_XGI_20		0x0020
#define PCI_DEVICE_ID_XGI_40		0x0040

#define PCI_VENDOR_ID_ASPEED		0x1a03
#define PCI_DEVICE_ID_ASPEED_AST2050_VGA	0x2000

#define PCI_VENDOR_ID_SYMPHONY		0x1c1c
#define PCI_DEVICE_ID_SYMPHONY_101	0x0001

#define PCI_VENDOR_ID_TEKRAM		0x1de1
#define PCI_DEVICE_ID_TEKRAM_DC290	0xdc29

#define PCI_VENDOR_ID_3DLABS		0x3d3d
#define PCI_DEVICE_ID_3DLABS_300SX	0x0001
#define PCI_DEVICE_ID_3DLABS_500TX	0x0002
#define PCI_DEVICE_ID_3DLABS_DELTA	0x0003
#define PCI_DEVICE_ID_3DLABS_PERMEDIA	0x0004
#define PCI_DEVICE_ID_3DLABS_MX		0x0006
#define PCI_DEVICE_ID_3DLABS_PERMEDIA2	0x0007
#define PCI_DEVICE_ID_3DLABS_GAMMA	0x0008
#define PCI_DEVICE_ID_3DLABS_PERMEDIA2V	0x0009

#define PCI_VENDOR_ID_AVANCE		0x4005
#define PCI_DEVICE_ID_AVANCE_ALG2064	0x2064
#define PCI_DEVICE_ID_AVANCE_2302	0x2302

#define PCI_VENDOR_ID_AKS		0x416c
#define PCI_DEVICE_ID_AKS_ALADDINCARD	0x0100
#define PCI_DEVICE_ID_AKS_CPC		0x0200

#define PCI_VENDOR_ID_NETVIN		0x4a14
#define PCI_DEVICE_ID_NETVIN_NV5000SC	0x5000

#define PCI_VENDOR_ID_S3		0x5333
#define PCI_DEVICE_ID_S3_PLATO_PXS	0x0551
#define PCI_DEVICE_ID_S3_ViRGE		0x5631
#define PCI_DEVICE_ID_S3_TRIO		0x8811
#define PCI_DEVICE_ID_S3_AURORA64VP	0x8812
#define PCI_DEVICE_ID_S3_TRIO64UVP	0x8814
#define PCI_DEVICE_ID_S3_ViRGE_VX	0x883d
#define PCI_DEVICE_ID_S3_868		0x8880
#define PCI_DEVICE_ID_S3_928		0x88b0
#define PCI_DEVICE_ID_S3_864_1		0x88c0
#define PCI_DEVICE_ID_S3_864_2		0x88c1
#define PCI_DEVICE_ID_S3_964_1		0x88d0
#define PCI_DEVICE_ID_S3_964_2		0x88d1
#define PCI_DEVICE_ID_S3_968		0x88f0
#define PCI_DEVICE_ID_S3_TRIO64V2	0x8901
#define PCI_DEVICE_ID_S3_PLATO_PXG	0x8902
#define PCI_DEVICE_ID_S3_ViRGE_DXGX	0x8a01
#define PCI_DEVICE_ID_S3_ViRGE_GX2	0x8a10
#define PCI_DEVICE_ID_S3_ViRGE_MX	0x8c01
#define PCI_DEVICE_ID_S3_ViRGE_MXP	0x8c02
#define PCI_DEVICE_ID_S3_ViRGE_MXPMV	0x8c03
#define PCI_DEVICE_ID_S3_SONICVIBES	0xca00

#define PCI_VENDOR_ID_DUNORD		0x5544
#define PCI_DEVICE_ID_DUNORD_I3000	0x0001
#define PCI_VENDOR_ID_GENROCO		0x5555
#define PCI_DEVICE_ID_GENROCO_HFP832	0x0003

#define PCI_VENDOR_ID_DCI		0x6666
#define PCI_DEVICE_ID_DCI_PCCOM4	0x0001
#define PCI_DEVICE_ID_DCI_PCCOM8	0x0002

#define PCI_VENDOR_ID_INTEL		0x8086
#define PCI_DEVICE_ID_INTEL_21145	0x0039
#define PCI_DEVICE_ID_INTEL_82375	0x0482
#define PCI_DEVICE_ID_INTEL_82424	0x0483
#define PCI_DEVICE_ID_INTEL_82378	0x0484
#define PCI_DEVICE_ID_INTEL_82430	0x0486
#define PCI_DEVICE_ID_INTEL_82434	0x04a3
#define PCI_DEVICE_ID_INTEL_I960	0x0960
#define PCI_DEVICE_ID_INTEL_82562ET	0x1031
#define PCI_DEVICE_ID_INTEL_82559ER	0x1209
#define PCI_DEVICE_ID_INTEL_82092AA_0	0x1221
#define PCI_DEVICE_ID_INTEL_82092AA_1	0x1222
#define PCI_DEVICE_ID_INTEL_7116	0x1223
#define PCI_DEVICE_ID_INTEL_82596	0x1226
#define PCI_DEVICE_ID_INTEL_82865	0x1227
#define PCI_DEVICE_ID_INTEL_82557	0x1229
#define PCI_DEVICE_ID_INTEL_82437	0x122d
#define PCI_DEVICE_ID_INTEL_82441	0x1237
#define PCI_DEVICE_ID_INTEL_82380FB	0x124b
#define PCI_DEVICE_ID_INTEL_82439	0x1250
#define PCI_DEVICE_ID_INTEL_80960_RP	0x1960
#define PCI_DEVICE_ID_INTEL_82437VX	0x7030
#define PCI_DEVICE_ID_INTEL_82439TX	0x7100
#define PCI_DEVICE_ID_INTEL_CNL_ISHB	0x9dfc
#define PCI_DEVICE_ID_INTEL_CML_ISHB	0x02fc

/* Intel 82371FB (PIIX) */
#define PCI_DEVICE_ID_INTEL_82371FB_ISA		0x122e
#define PCI_DEVICE_ID_INTEL_82371FB_IDE		0x1230

/* Intel 82371SB (PIIX3) */
#define PCI_DEVICE_ID_INTEL_82371SB_ISA		0x7000
#define PCI_DEVICE_ID_INTEL_82371SB_IDE		0x7010
#define PCI_DEVICE_ID_INTEL_82371SB_USB		0x7020

/* Intel 82371MX (MPIIX) */
#define PCI_DEVICE_ID_INTEL_82371MX_ISA_IDE	0x1234

/* Intel 82437MX (part of the 430MX chipset) */
#define PCI_DEVICE_ID_INTEL_82437MX_ISA_IDE	0x1235

/* Intel 82371AB/EB/MB (PIIX4/PIIX4E/PIIX4M) */
/* The 440MX (82443MX) consists of 82443BX + 82371EB (uses same PCI IDs). */
#define PCI_DEVICE_ID_INTEL_82371AB_ISA		0x7110
#define PCI_DEVICE_ID_INTEL_82371AB_IDE		0x7111
#define PCI_DEVICE_ID_INTEL_82371AB_USB		0x7112
#define PCI_DEVICE_ID_INTEL_82371AB_SMB_ACPI	0x7113

/* Intel 82801AA (ICH) */
#define PCI_DEVICE_ID_INTEL_82801AA_LPC		0x2410
#define PCI_DEVICE_ID_INTEL_82801AA_IDE		0x2411
#define PCI_DEVICE_ID_INTEL_82801AA_USB		0x2412
#define PCI_DEVICE_ID_INTEL_82801AA_SMB		0x2413
#define PCI_DEVICE_ID_INTEL_82801AA_AC97_AUDIO	0x2415
#define PCI_DEVICE_ID_INTEL_82801AA_AC97_MODEM	0x2416
#define PCI_DEVICE_ID_INTEL_82801AA_PCI		0x2418

/* Intel 82801AB (ICH0) */
#define PCI_DEVICE_ID_INTEL_82801AB_LPC		0x2420
#define PCI_DEVICE_ID_INTEL_82801AB_IDE		0x2421
#define PCI_DEVICE_ID_INTEL_82801AB_USB		0x2422
#define PCI_DEVICE_ID_INTEL_82801AB_SMB		0x2423
#define PCI_DEVICE_ID_INTEL_82801AB_AC97_AUDIO	0x2425
#define PCI_DEVICE_ID_INTEL_82801AB_AC97_MODEM	0x2426
#define PCI_DEVICE_ID_INTEL_82801AB_PCI		0x2428

/* Intel 82801BA (ICH2) */
#define PCI_DEVICE_ID_INTEL_82801BA_LPC		0x2440
#define PCI_DEVICE_ID_INTEL_82801BA_USB1	0x2442
#define PCI_DEVICE_ID_INTEL_82801BA_SMB		0x2443
#define PCI_DEVICE_ID_INTEL_82801BA_USB2	0x2444
#define PCI_DEVICE_ID_INTEL_82801BA_AC97_AUDIO	0x2445
#define PCI_DEVICE_ID_INTEL_82801BA_AC97_MODEM	0x2446
#define PCI_DEVICE_ID_INTEL_82801BA_LAN		0x2449
#define PCI_DEVICE_ID_INTEL_82801BA_IDE		0x244b
#define PCI_DEVICE_ID_INTEL_82801BA_PCI		0x244e

/* Intel 82801BAM (ICH2-M) */
#define PCI_DEVICE_ID_INTEL_82801BAM_USB1	0x2442
#define PCI_DEVICE_ID_INTEL_82801BAM_SMB	0x2443
#define PCI_DEVICE_ID_INTEL_82801BAM_USB2	0x2444
#define PCI_DEVICE_ID_INTEL_82801BAM_AC97_AUDIO	0x2445
#define PCI_DEVICE_ID_INTEL_82801BAM_AC97_MODEM	0x2446
#define PCI_DEVICE_ID_INTEL_82801BAM_PCI	0x2448
#define PCI_DEVICE_ID_INTEL_82801BAM_LAN	0x2449
#define PCI_DEVICE_ID_INTEL_82801BAM_IDE	0x244a
#define PCI_DEVICE_ID_INTEL_82801BAM_LPC	0x244c

/* Intel 82801CA (ICH3-S) */
#define PCI_DEVICE_ID_INTEL_82801CA_LAN		0x2449
#define PCI_DEVICE_ID_INTEL_82801CA_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801CA_LPC		0x2480
#define PCI_DEVICE_ID_INTEL_82801CA_USB1	0x2482
#define PCI_DEVICE_ID_INTEL_82801CA_SMB		0x2483
#define PCI_DEVICE_ID_INTEL_82801CA_USB2	0x2484
#define PCI_DEVICE_ID_INTEL_82801CA_AC97_AUDIO	0x2485
#define PCI_DEVICE_ID_INTEL_82801CA_AC97_MODEM	0x2486
#define PCI_DEVICE_ID_INTEL_82801CA_USB3	0x2487
#define PCI_DEVICE_ID_INTEL_82801CA_IDE		0x248b

/* Intel 82801CAM (ICH3-M) */
#define PCI_DEVICE_ID_INTEL_82801CAM_PCI	0x2448
#define PCI_DEVICE_ID_INTEL_82801CAM_LAN	0x2449
#define PCI_DEVICE_ID_INTEL_82801CAM_USB1	0x2482
#define PCI_DEVICE_ID_INTEL_82801CAM_SMB	0x2483
#define PCI_DEVICE_ID_INTEL_82801CAM_USB2	0x2484
#define PCI_DEVICE_ID_INTEL_82801CAM_AC97_AUDIO	0x2485
#define PCI_DEVICE_ID_INTEL_82801CAM_AC97_MODEM	0x2486
#define PCI_DEVICE_ID_INTEL_82801CAM_USB3	0x2487
#define PCI_DEVICE_ID_INTEL_82801CAM_IDE	0x248a
#define PCI_DEVICE_ID_INTEL_82801CAM_LPC	0x248c

/* Intel 82801DB (ICH4) */
#define PCI_DEVICE_ID_INTEL_82801DB_LAN		0x103a
#define PCI_DEVICE_ID_INTEL_82801DB_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801DB_LPC		0x24c0
#define PCI_DEVICE_ID_INTEL_82801DB_USB1	0x24c2
#define PCI_DEVICE_ID_INTEL_82801DB_SMB		0x24c3
#define PCI_DEVICE_ID_INTEL_82801DB_USB2	0x24c4
#define PCI_DEVICE_ID_INTEL_82801DB_AC97_AUDIO	0x24c5
#define PCI_DEVICE_ID_INTEL_82801DB_AC97_MODEM	0x24c6
#define PCI_DEVICE_ID_INTEL_82801DB_USB3	0x24c7
#define PCI_DEVICE_ID_INTEL_82801DB_IDE		0x24cb
#define PCI_DEVICE_ID_INTEL_82801DB_EHCI	0x24cd

/* Intel 82801DBL (ICH4-L) */
#define PCI_DEVICE_ID_INTEL_82801DBL_LAN	0x103a
#define PCI_DEVICE_ID_INTEL_82801DBL_PCI	0x2448
#define PCI_DEVICE_ID_INTEL_82801DBL_LPC	0x24c0
#define PCI_DEVICE_ID_INTEL_82801DBL_IDE	0x24c1
#define PCI_DEVICE_ID_INTEL_82801DBL_USB1	0x24c2
#define PCI_DEVICE_ID_INTEL_82801DBL_SMB	0x24c3
#define PCI_DEVICE_ID_INTEL_82801DBL_USB2	0x24c4
#define PCI_DEVICE_ID_INTEL_82801DBL_AC97_AUDIO	0x24c5
#define PCI_DEVICE_ID_INTEL_82801DBL_AC97_MODEM	0x24c6
#define PCI_DEVICE_ID_INTEL_82801DBL_USB3	0x24c7

/* Intel 82801DBM (ICH4-M) */
#define PCI_DEVICE_ID_INTEL_82801DBM_LAN	0x103a
#define PCI_DEVICE_ID_INTEL_82801DBM_PCI	0x2448
#define PCI_DEVICE_ID_INTEL_82801DBM_USB1	0x24c2
#define PCI_DEVICE_ID_INTEL_82801DBM_SMB	0x24c3
#define PCI_DEVICE_ID_INTEL_82801DBM_USB2	0x24c4
#define PCI_DEVICE_ID_INTEL_82801DBM_AC97_AUDIO	0x24c5
#define PCI_DEVICE_ID_INTEL_82801DBM_AC97_MODEM	0x24c6
#define PCI_DEVICE_ID_INTEL_82801DBM_USB3	0x24c7
#define PCI_DEVICE_ID_INTEL_82801DBM_IDE	0x24ca
#define PCI_DEVICE_ID_INTEL_82801DBM_LPC	0x24cc
#define PCI_DEVICE_ID_INTEL_82801DBM_EHCI	0x24cd

/* Intel 82801EB (ICH5) */
#define PCI_DEVICE_ID_INTEL_82801EB_LAN		0x1051
#define PCI_DEVICE_ID_INTEL_82801EB_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801EB_LPC		0x24d0
#define PCI_DEVICE_ID_INTEL_82801EB_SATA	0x24d1
#define PCI_DEVICE_ID_INTEL_82801EB_USB1	0x24d2
#define PCI_DEVICE_ID_INTEL_82801EB_SMB		0x24d3
#define PCI_DEVICE_ID_INTEL_82801EB_USB2	0x24d4
#define PCI_DEVICE_ID_INTEL_82801EB_AC97_AUDIO	0x24d5
#define PCI_DEVICE_ID_INTEL_82801EB_AC97_MODEM	0x24d6
#define PCI_DEVICE_ID_INTEL_82801EB_USB3	0x24d7
#define PCI_DEVICE_ID_INTEL_82801EB_IDE		0x24db
#define PCI_DEVICE_ID_INTEL_82801EB_EHCI	0x24dd
#define PCI_DEVICE_ID_INTEL_82801EB_USB4	0x24de

/* Intel 82801ER (ICH5R) */
#define PCI_DEVICE_ID_INTEL_82801ER_LAN		0x1051
#define PCI_DEVICE_ID_INTEL_82801ER_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801ER_LPC		0x24d0
#define PCI_DEVICE_ID_INTEL_82801ER_USB1	0x24d2
#define PCI_DEVICE_ID_INTEL_82801ER_SMB		0x24d3
#define PCI_DEVICE_ID_INTEL_82801ER_USB2	0x24d4
#define PCI_DEVICE_ID_INTEL_82801ER_AC97_AUDIO	0x24d5
#define PCI_DEVICE_ID_INTEL_82801ER_AC97_MODEM	0x24d6
#define PCI_DEVICE_ID_INTEL_82801ER_USB3	0x24d7
#define PCI_DEVICE_ID_INTEL_82801ER_IDE		0x24db
#define PCI_DEVICE_ID_INTEL_82801ER_EHCI	0x24dd
#define PCI_DEVICE_ID_INTEL_82801ER_USB4	0x24de
#define PCI_DEVICE_ID_INTEL_82801ER_SATA	0x24df

/* Intel 82801FB (ICH6) */
#define PCI_DEVICE_ID_INTEL_82801FB_LAN		0x1065
#define PCI_DEVICE_ID_INTEL_82801FB_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801FB_LPC		0x2640
#define PCI_DEVICE_ID_INTEL_82801FB_SATA	0x2651
#define PCI_DEVICE_ID_INTEL_82801FB_USB1	0x2658
#define PCI_DEVICE_ID_INTEL_82801FB_USB2	0x2659
#define PCI_DEVICE_ID_INTEL_82801FB_USB3	0x265a
#define PCI_DEVICE_ID_INTEL_82801FB_USB4	0x265b
#define PCI_DEVICE_ID_INTEL_82801FB_EHCI	0x265c
#define PCI_DEVICE_ID_INTEL_82801FB_PCIE1	0x2660
#define PCI_DEVICE_ID_INTEL_82801FB_PCIE2	0x2662
#define PCI_DEVICE_ID_INTEL_82801FB_PCIE3	0x2664
#define PCI_DEVICE_ID_INTEL_82801FB_PCIE4	0x2666
#define PCI_DEVICE_ID_INTEL_82801FB_HD_AUDIO	0x2668
#define PCI_DEVICE_ID_INTEL_82801FB_SMB		0x266a
#define PCI_DEVICE_ID_INTEL_82801FB_AC97_MODEM	0x266d
#define PCI_DEVICE_ID_INTEL_82801FB_AC97_AUDIO	0x266e
#define PCI_DEVICE_ID_INTEL_82801FB_IDE		0x266f

/* Intel 82801FR (ICH6R) */
#define PCI_DEVICE_ID_INTEL_82801FR_LAN		0x1065
#define PCI_DEVICE_ID_INTEL_82801FR_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801FR_LPC		0x2640
#define PCI_DEVICE_ID_INTEL_82801FR_SATA	0x2652
#define PCI_DEVICE_ID_INTEL_82801FR_USB1	0x2658
#define PCI_DEVICE_ID_INTEL_82801FR_USB2	0x2659
#define PCI_DEVICE_ID_INTEL_82801FR_USB3	0x265a
#define PCI_DEVICE_ID_INTEL_82801FR_USB4	0x265b
#define PCI_DEVICE_ID_INTEL_82801FR_EHCI	0x265c
#define PCI_DEVICE_ID_INTEL_82801FR_PCIE1	0x2660
#define PCI_DEVICE_ID_INTEL_82801FR_PCIE2	0x2662
#define PCI_DEVICE_ID_INTEL_82801FR_PCIE3	0x2664
#define PCI_DEVICE_ID_INTEL_82801FR_PCIE4	0x2666
#define PCI_DEVICE_ID_INTEL_82801FR_HD_AUDIO	0x2668
#define PCI_DEVICE_ID_INTEL_82801FR_SMB		0x266a
#define PCI_DEVICE_ID_INTEL_82801FR_AC97_MODEM	0x266d
#define PCI_DEVICE_ID_INTEL_82801FR_AC97_AUDIO	0x266e
#define PCI_DEVICE_ID_INTEL_82801FR_IDE		0x266f

/* Intel 82801FW (ICH6W) */
#define PCI_DEVICE_ID_INTEL_82801FW_LAN		0x1065
#define PCI_DEVICE_ID_INTEL_82801FW_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801FW_LPC		0x2642
#define PCI_DEVICE_ID_INTEL_82801FW_SATA	0x2651
#define PCI_DEVICE_ID_INTEL_82801FW_USB1	0x2658
#define PCI_DEVICE_ID_INTEL_82801FW_USB2	0x2659
#define PCI_DEVICE_ID_INTEL_82801FW_USB3	0x265a
#define PCI_DEVICE_ID_INTEL_82801FW_USB4	0x265b
#define PCI_DEVICE_ID_INTEL_82801FW_EHCI	0x265c
#define PCI_DEVICE_ID_INTEL_82801FW_PCIE1	0x2660
#define PCI_DEVICE_ID_INTEL_82801FW_PCIE2	0x2662
#define PCI_DEVICE_ID_INTEL_82801FW_PCIE3	0x2664
#define PCI_DEVICE_ID_INTEL_82801FW_PCIE4	0x2666
#define PCI_DEVICE_ID_INTEL_82801FW_HD_AUDIO	0x2668
#define PCI_DEVICE_ID_INTEL_82801FW_SMB		0x266a
#define PCI_DEVICE_ID_INTEL_82801FW_AC97_MODEM	0x266d
#define PCI_DEVICE_ID_INTEL_82801FW_AC97_AUDIO	0x266e
#define PCI_DEVICE_ID_INTEL_82801FW_IDE		0x266f

/* Intel 82801FRW (ICH6RW) */
#define PCI_DEVICE_ID_INTEL_82801FRW_LAN	0x1065
#define PCI_DEVICE_ID_INTEL_82801FRW_PCI	0x244e
#define PCI_DEVICE_ID_INTEL_82801FRW_LPC	0x2642
#define PCI_DEVICE_ID_INTEL_82801FRW_SATA	0x2652
#define PCI_DEVICE_ID_INTEL_82801FRW_USB1	0x2658
#define PCI_DEVICE_ID_INTEL_82801FRW_USB2	0x2659
#define PCI_DEVICE_ID_INTEL_82801FRW_USB3	0x265a
#define PCI_DEVICE_ID_INTEL_82801FRW_USB4	0x265b
#define PCI_DEVICE_ID_INTEL_82801FRW_EHCI	0x265c
#define PCI_DEVICE_ID_INTEL_82801FRW_PCIE1	0x2660
#define PCI_DEVICE_ID_INTEL_82801FRW_PCIE2	0x2662
#define PCI_DEVICE_ID_INTEL_82801FRW_PCIE3	0x2664
#define PCI_DEVICE_ID_INTEL_82801FRW_PCIE4	0x2666
#define PCI_DEVICE_ID_INTEL_82801FRW_HD_AUDIO	0x2668
#define PCI_DEVICE_ID_INTEL_82801FRW_SMB	0x266a
#define PCI_DEVICE_ID_INTEL_82801FRW_AC97_MODEM	0x266d
#define PCI_DEVICE_ID_INTEL_82801FRW_AC97_AUDIO	0x266e
#define PCI_DEVICE_ID_INTEL_82801FRW_IDE	0x266f

/* Intel 82801FBM (ICH6-M) */
#define PCI_DEVICE_ID_INTEL_82801FBM_LAN	0x1065
#define PCI_DEVICE_ID_INTEL_82801FBM_PCI	0x2448
#define PCI_DEVICE_ID_INTEL_82801FBM_LPC	0x2641
#define PCI_DEVICE_ID_INTEL_82801FBM_SATA	0x2653
#define PCI_DEVICE_ID_INTEL_82801FBM_USB1	0x2658
#define PCI_DEVICE_ID_INTEL_82801FBM_USB2	0x2659
#define PCI_DEVICE_ID_INTEL_82801FBM_USB3	0x265a
#define PCI_DEVICE_ID_INTEL_82801FBM_USB4	0x265b
#define PCI_DEVICE_ID_INTEL_82801FBM_EHCI	0x265c
#define PCI_DEVICE_ID_INTEL_82801FBM_PCIE1	0x2660
#define PCI_DEVICE_ID_INTEL_82801FBM_PCIE2	0x2662
#define PCI_DEVICE_ID_INTEL_82801FBM_PCIE3	0x2664
#define PCI_DEVICE_ID_INTEL_82801FBM_PCIE4	0x2666
#define PCI_DEVICE_ID_INTEL_82801FBM_HD_AUDIO	0x2668
#define PCI_DEVICE_ID_INTEL_82801FBM_SMB	0x266a
#define PCI_DEVICE_ID_INTEL_82801FBM_AC97_MODEM	0x266d
#define PCI_DEVICE_ID_INTEL_82801FBM_AC97_AUDIO	0x266e
#define PCI_DEVICE_ID_INTEL_82801FBM_IDE	0x266f

/* Intel 82801GB (ICH7) */
#define PCI_DEVICE_ID_INTEL_82801GB_LAN		0x27dc
#define PCI_DEVICE_ID_INTEL_82801GB_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801GB_LPC		0x27b8
#define PCI_DEVICE_ID_INTEL_82801GB_SATA	0x27c0
#define PCI_DEVICE_ID_INTEL_82801GB_SATA_AHCI	0x27c1
#define PCI_DEVICE_ID_INTEL_82801GB_SATA_RAID	0x27c3
#define PCI_DEVICE_ID_INTEL_82801GB_USB1	0x27c8
#define PCI_DEVICE_ID_INTEL_82801GB_USB2	0x27c9
#define PCI_DEVICE_ID_INTEL_82801GB_USB3	0x27ca
#define PCI_DEVICE_ID_INTEL_82801GB_USB4	0x27cb
#define PCI_DEVICE_ID_INTEL_82801GB_EHCI	0x27cc
#define PCI_DEVICE_ID_INTEL_82801GB_PCIE1	0x27d0
#define PCI_DEVICE_ID_INTEL_82801GB_PCIE2	0x27d2
#define PCI_DEVICE_ID_INTEL_82801GB_PCIE3	0x27d4
#define PCI_DEVICE_ID_INTEL_82801GB_PCIE4	0x27d6
#define PCI_DEVICE_ID_INTEL_82801GB_HD_AUDIO	0x27d8
#define PCI_DEVICE_ID_INTEL_82801GB_SMB		0x27da
#define PCI_DEVICE_ID_INTEL_82801GB_AC97_MODEM	0x27de
#define PCI_DEVICE_ID_INTEL_82801GB_AC97_AUDIO	0x27dd
#define PCI_DEVICE_ID_INTEL_82801GB_IDE		0x27df

/* Intel 82801GR (ICH7R) */
#define PCI_DEVICE_ID_INTEL_82801GR_LAN		0x27dc
#define PCI_DEVICE_ID_INTEL_82801GR_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801GR_LPC		0x27b8
#define PCI_DEVICE_ID_INTEL_82801GR_SATA	0x27c0
#define PCI_DEVICE_ID_INTEL_82801GR_SATA_AHCI	0x27c1
#define PCI_DEVICE_ID_INTEL_82801GR_SATA_RAID	0x27c3
#define PCI_DEVICE_ID_INTEL_82801GR_USB1	0x27c8
#define PCI_DEVICE_ID_INTEL_82801GR_USB2	0x27c9
#define PCI_DEVICE_ID_INTEL_82801GR_USB3	0x27ca
#define PCI_DEVICE_ID_INTEL_82801GR_USB4	0x27cb
#define PCI_DEVICE_ID_INTEL_82801GR_EHCI	0x27cc
#define PCI_DEVICE_ID_INTEL_82801GR_PCIE1	0x27d0
#define PCI_DEVICE_ID_INTEL_82801GR_PCIE2	0x27d2
#define PCI_DEVICE_ID_INTEL_82801GR_PCIE3	0x27d4
#define PCI_DEVICE_ID_INTEL_82801GR_PCIE4	0x27d6
#define PCI_DEVICE_ID_INTEL_82801GR_PCIE5	0x27e0
#define PCI_DEVICE_ID_INTEL_82801GR_PCIE6	0x27e2
#define PCI_DEVICE_ID_INTEL_82801GR_HD_AUDIO	0x27d8
#define PCI_DEVICE_ID_INTEL_82801GR_SMB		0x27da
#define PCI_DEVICE_ID_INTEL_82801GR_AC97_MODEM	0x27de
#define PCI_DEVICE_ID_INTEL_82801GR_AC97_AUDIO	0x27dd
#define PCI_DEVICE_ID_INTEL_82801GR_IDE		0x27df

/* Intel 82801GDH (ICH7DH) */
#define PCI_DEVICE_ID_INTEL_82801GDH_LAN	0x27dc
#define PCI_DEVICE_ID_INTEL_82801GDH_PCI	0x244e
#define PCI_DEVICE_ID_INTEL_82801GDH_LPC	0x27b8
#define PCI_DEVICE_ID_INTEL_82801GDH_SATA	0x27c0
#define PCI_DEVICE_ID_INTEL_82801GDH_SATA_AHCI	0x27c1
#define PCI_DEVICE_ID_INTEL_82801GDH_SATA_RAID	0x27c3
#define PCI_DEVICE_ID_INTEL_82801GDH_USB1	0x27c8
#define PCI_DEVICE_ID_INTEL_82801GDH_USB2	0x27c9
#define PCI_DEVICE_ID_INTEL_82801GDH_USB3	0x27ca
#define PCI_DEVICE_ID_INTEL_82801GDH_USB4	0x27cb
#define PCI_DEVICE_ID_INTEL_82801GDH_EHCI	0x27cc
#define PCI_DEVICE_ID_INTEL_82801GDH_PCIE1	0x27d0
#define PCI_DEVICE_ID_INTEL_82801GDH_PCIE2	0x27d2
#define PCI_DEVICE_ID_INTEL_82801GDH_PCIE3	0x27d4
#define PCI_DEVICE_ID_INTEL_82801GDH_PCIE4	0x27d6
#define PCI_DEVICE_ID_INTEL_82801GDH_PCIE5	0x27e0
#define PCI_DEVICE_ID_INTEL_82801GDH_PCIE6	0x27e2
#define PCI_DEVICE_ID_INTEL_82801GDH_HD_AUDIO	0x27d8
#define PCI_DEVICE_ID_INTEL_82801GDH_SMB	0x27da
#define PCI_DEVICE_ID_INTEL_82801GDH_AC97_MODEM	0x27de
#define PCI_DEVICE_ID_INTEL_82801GDH_AC97_AUDIO	0x27dd
#define PCI_DEVICE_ID_INTEL_82801GDH_IDE	0x27df

/* Intel 82801GBM (ICH7-M) */
#define PCI_DEVICE_ID_INTEL_82801GBM_LAN	0x27dc
#define PCI_DEVICE_ID_INTEL_82801GBM_PCI	0x2448
#define PCI_DEVICE_ID_INTEL_82801GBM_LPC	0x27b9
#define PCI_DEVICE_ID_INTEL_82801GBM_SATA	0x27c4
#define PCI_DEVICE_ID_INTEL_82801GBM_SATA_AHCI	0x27c5
#define PCI_DEVICE_ID_INTEL_82801GBM_USB1	0x27c8
#define PCI_DEVICE_ID_INTEL_82801GBM_USB2	0x27c9
#define PCI_DEVICE_ID_INTEL_82801GBM_USB3	0x27ca
#define PCI_DEVICE_ID_INTEL_82801GBM_USB4	0x27cb
#define PCI_DEVICE_ID_INTEL_82801GBM_EHCI	0x27cc
#define PCI_DEVICE_ID_INTEL_82801GBM_PCIE1	0x27d0
#define PCI_DEVICE_ID_INTEL_82801GBM_PCIE2	0x27d2
#define PCI_DEVICE_ID_INTEL_82801GBM_PCIE3	0x27d4
#define PCI_DEVICE_ID_INTEL_82801GBM_PCIE4	0x27d6
#define PCI_DEVICE_ID_INTEL_82801GBM_HD_AUDIO	0x27d8
#define PCI_DEVICE_ID_INTEL_82801GBM_SMB	0x27da
#define PCI_DEVICE_ID_INTEL_82801GBM_AC97_MODEM	0x27de
#define PCI_DEVICE_ID_INTEL_82801GBM_AC97_AUDIO	0x27dd
#define PCI_DEVICE_ID_INTEL_82801GBM_IDE	0x27df

/* Intel 82801GHM (ICH7-M DH) */
#define PCI_DEVICE_ID_INTEL_82801GHM_LAN	0x27dc
#define PCI_DEVICE_ID_INTEL_82801GHM_PCI	0x2448
#define PCI_DEVICE_ID_INTEL_82801GHM_LPC	0x27bd
#define PCI_DEVICE_ID_INTEL_82801GHM_SATA	0x27c4
#define PCI_DEVICE_ID_INTEL_82801GHM_SATA_AHCI	0x27c5
#define PCI_DEVICE_ID_INTEL_82801GHM_SATA_RAID	0x27c6
#define PCI_DEVICE_ID_INTEL_82801GHM_USB1	0x27c8
#define PCI_DEVICE_ID_INTEL_82801GHM_USB2	0x27c9
#define PCI_DEVICE_ID_INTEL_82801GHM_USB3	0x27ca
#define PCI_DEVICE_ID_INTEL_82801GHM_USB4	0x27cb
#define PCI_DEVICE_ID_INTEL_82801GHM_EHCI	0x27cc
#define PCI_DEVICE_ID_INTEL_82801GHM_PCIE1	0x27d0
#define PCI_DEVICE_ID_INTEL_82801GHM_PCIE2	0x27d2
#define PCI_DEVICE_ID_INTEL_82801GHM_PCIE3	0x27d4
#define PCI_DEVICE_ID_INTEL_82801GHM_PCIE4	0x27d6
#define PCI_DEVICE_ID_INTEL_82801GHM_PCIE5	0x27e0
#define PCI_DEVICE_ID_INTEL_82801GHM_PCIE6	0x27e2
#define PCI_DEVICE_ID_INTEL_82801GHM_HD_AUDIO	0x27d8
#define PCI_DEVICE_ID_INTEL_82801GHM_SMB	0x27da
#define PCI_DEVICE_ID_INTEL_82801GHM_AC97_MODEM	0x27de
#define PCI_DEVICE_ID_INTEL_82801GHM_AC97_AUDIO	0x27dd
#define PCI_DEVICE_ID_INTEL_82801GHM_IDE	0x27df

/* Intel 82801GU (ICH7-U) */
#define PCI_DEVICE_ID_INTEL_82801GU_PCI		0x2448
#define PCI_DEVICE_ID_INTEL_82801GU_LPC		0x27b9
#define PCI_DEVICE_ID_INTEL_82801GU_USB1	0x27c8
#define PCI_DEVICE_ID_INTEL_82801GU_USB2	0x27c9
#define PCI_DEVICE_ID_INTEL_82801GU_USB3	0x27ca
#define PCI_DEVICE_ID_INTEL_82801GU_USB4	0x27cb
#define PCI_DEVICE_ID_INTEL_82801GU_EHCI	0x27cc
#define PCI_DEVICE_ID_INTEL_82801GU_HD_AUDIO	0x27d8
#define PCI_DEVICE_ID_INTEL_82801GU_SMB		0x27da
#define PCI_DEVICE_ID_INTEL_82801GU_IDE		0x27df

/* Intel 82801HB (ICH8) */
#define PCI_DEVICE_ID_INTEL_82801HB_LAN		0x104b
#define PCI_DEVICE_ID_INTEL_82801HB_LPC		0x2810
#define PCI_DEVICE_ID_INTEL_82801HB_SATA1	0x2820
#define PCI_DEVICE_ID_INTEL_82801HB_SATA_AHCI_6	0x2821 /* 6 ports */
#define PCI_DEVICE_ID_INTEL_82801HB_SATA_RAID	0x2822
#define PCI_DEVICE_ID_INTEL_82801HB_SATA_AHCI_4	0x2824 /* 4 ports */
#define PCI_DEVICE_ID_INTEL_82801HB_SATA2	0x2825
#define PCI_DEVICE_ID_INTEL_82801HB_SMB		0x283e
#define PCI_DEVICE_ID_INTEL_82801HB_THERMAL	0x284f
#define PCI_DEVICE_ID_INTEL_82801HB_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_82801HB_USB1	0x2830
#define PCI_DEVICE_ID_INTEL_82801HB_USB2	0x2831
#define PCI_DEVICE_ID_INTEL_82801HB_USB3	0x2832
#define PCI_DEVICE_ID_INTEL_82801HB_EHCI1	0x2836
#define PCI_DEVICE_ID_INTEL_82801HB_USB4	0x2834
#define PCI_DEVICE_ID_INTEL_82801HB_USB5	0x2835
#define PCI_DEVICE_ID_INTEL_82801HB_EHCI2	0x283a
#define PCI_DEVICE_ID_INTEL_82801HB_PCIE1	0x283f
#define PCI_DEVICE_ID_INTEL_82801HB_PCIE2	0x2841
#define PCI_DEVICE_ID_INTEL_82801HB_PCIE3	0x2843
#define PCI_DEVICE_ID_INTEL_82801HB_PCIE4	0x2845
#define PCI_DEVICE_ID_INTEL_82801HB_PCIE5	0x2847
#define PCI_DEVICE_ID_INTEL_82801HB_PCIE6	0x2849
#define PCI_DEVICE_ID_INTEL_82801HB_HD_AUDIO	0x284b

/* Intel 82801HR/HH/HO (ICH8R/ICH8DH/ICH8DO), only difference to ICH8: LPC */
#define PCI_DEVICE_ID_INTEL_82801HR_LPC		0x2810
#define PCI_DEVICE_ID_INTEL_82801HH_LPC		0x2812
#define PCI_DEVICE_ID_INTEL_82801HO_LPC		0x2814

/* Intel 82801HBM/HEM (ICH8M/ICH8M-E) */
#define PCI_DEVICE_ID_INTEL_82801HBM_LAN	0x104b
#define PCI_DEVICE_ID_INTEL_82801HBM_LPC	0x2815
#define PCI_DEVICE_ID_INTEL_82801HBM_SATA	0x2828
#define PCI_DEVICE_ID_INTEL_82801HBM_SATA_AHCI	0x2829
#define PCI_DEVICE_ID_INTEL_82801HBM_SATA_RAID	0x282a
#define PCI_DEVICE_ID_INTEL_82801HBM_SMB	0x283e
#define PCI_DEVICE_ID_INTEL_82801HBM_THERMAL	0x284f
#define PCI_DEVICE_ID_INTEL_82801HBM_PCI	0x2448
#define PCI_DEVICE_ID_INTEL_82801HBM_IDE	0x2850 /* TODO: Also ICH8M-E? */
#define PCI_DEVICE_ID_INTEL_82801HBM_USB1	0x2830
#define PCI_DEVICE_ID_INTEL_82801HBM_USB2	0x2831
#define PCI_DEVICE_ID_INTEL_82801HBM_USB3	0x2832
#define PCI_DEVICE_ID_INTEL_82801HBM_EHCI1	0x2836
#define PCI_DEVICE_ID_INTEL_82801HBM_USB4	0x2834
#define PCI_DEVICE_ID_INTEL_82801HBM_USB5	0x2835
#define PCI_DEVICE_ID_INTEL_82801HBM_EHCI2	0x283a
#define PCI_DEVICE_ID_INTEL_82801HBM_PCIE1	0x283f
#define PCI_DEVICE_ID_INTEL_82801HBM_PCIE2	0x2841
#define PCI_DEVICE_ID_INTEL_82801HBM_PCIE3	0x2843
#define PCI_DEVICE_ID_INTEL_82801HBM_PCIE4	0x2845
#define PCI_DEVICE_ID_INTEL_82801HBM_PCIE5	0x2847
#define PCI_DEVICE_ID_INTEL_82801HBM_PCIE6	0x2849
#define PCI_DEVICE_ID_INTEL_82801HBM_HD_AUDIO	0x284b

/* Intel 82801HEM (ICH8M-E), only difference to ICH8M: LPC */
#define PCI_DEVICE_ID_INTEL_82801HEM_LPC	0x2811

/* Intel 82801IB (ICH9) */
#define PCI_DEVICE_ID_INTEL_82801IB_LPC		0x2918
#define PCI_DEVICE_ID_INTEL_82801IB_SATA_P0123	0x2920 /* Ports 0 - 3 */
#define PCI_DEVICE_ID_INTEL_82801IB_SATA_P01	0x2921 /* Ports 0 - 1 */
#define PCI_DEVICE_ID_INTEL_82801IB_SATA_AHCI1	0x2922 /* Ports 0 - 5 */
#define PCI_DEVICE_ID_INTEL_82801IB_SATA_AHCI2	0x2923 /* Ports 0, 1, 4, 5 */
#define PCI_DEVICE_ID_INTEL_82801IB_SATA_RAID	0x2822 /* RAID */
#define PCI_DEVICE_ID_INTEL_82801IB_SATA_P45	0x2926 /* Ports 4 - 5 */
#define PCI_DEVICE_ID_INTEL_82801IB_SMB		0x2930
#define PCI_DEVICE_ID_INTEL_82801IB_THERMAL	0x2932
#define PCI_DEVICE_ID_INTEL_82801IB_PCI		0x244e /* DMI to PCI bridge */
#define PCI_DEVICE_ID_INTEL_82801IB_USB1	0x2934
#define PCI_DEVICE_ID_INTEL_82801IB_USB2	0x2935
#define PCI_DEVICE_ID_INTEL_82801IB_USB3	0x2936
#define PCI_DEVICE_ID_INTEL_82801IB_EHCI1	0x293a
#define PCI_DEVICE_ID_INTEL_82801IB_USB4	0x2937
#define PCI_DEVICE_ID_INTEL_82801IB_USB5	0x2938
#define PCI_DEVICE_ID_INTEL_82801IB_USB6	0x2939
#define PCI_DEVICE_ID_INTEL_82801IB_EHCI2	0x293c
#define PCI_DEVICE_ID_INTEL_82801IB_HD_AUDIO	0x293e
#define PCI_DEVICE_ID_INTEL_82801IB_PCIE1	0x2940
#define PCI_DEVICE_ID_INTEL_82801IB_PCIE2	0x2942
#define PCI_DEVICE_ID_INTEL_82801IB_PCIE3	0x2944
#define PCI_DEVICE_ID_INTEL_82801IB_PCIE4	0x2946
#define PCI_DEVICE_ID_INTEL_82801IB_PCIE5	0x2948
#define PCI_DEVICE_ID_INTEL_82801IB_PCIE6	0x294a
#define PCI_DEVICE_ID_INTEL_82801IB_LAN		0x29c4

/* Intel 82801IR/IH/IO (ICH9R/ICH9DH/ICH9DO), only difference to ICH9: LPC */
#define PCI_DEVICE_ID_INTEL_82801IR_LPC		0x2916
#define PCI_DEVICE_ID_INTEL_82801IO_LPC		0x2914
#define PCI_DEVICE_ID_INTEL_82801IH_LPC		0x2912

#define PCI_DEVICE_ID_INTEL_CAVECREEK_LPC 0x2310
#define PCI_DEVICE_ID_INTEL_COUGARPOINT_LPC_MIN	0x1c41
#define PCI_DEVICE_ID_INTEL_COUGARPOINT_LPC_MAX	0x1c5f
#define PCI_DEVICE_ID_INTEL_PANTHERPOINT_LPC_MIN 0x1e41
#define PCI_DEVICE_ID_INTEL_PANTHERPOINT_LPC_MAX 0x1e5f
#define PCI_DEVICE_ID_INTEL_RANGELEY_LPC_MIN 0x1f38
#define PCI_DEVICE_ID_INTEL_RANGELEY_LPC_MAX 0x1f3b
#define PCI_DEVICE_ID_INTEL_TGP_LPC	0x27bc

/* Intel 82801E (C-ICH) */
#define PCI_DEVICE_ID_INTEL_82801E_LPC		0x2450
#define PCI_DEVICE_ID_INTEL_82801E_USB		0x2452
#define PCI_DEVICE_ID_INTEL_82801E_SMB		0x2453
#define PCI_DEVICE_ID_INTEL_82801E_LAN1		0x2459
#define PCI_DEVICE_ID_INTEL_82801E_IDE		0x245b
#define PCI_DEVICE_ID_INTEL_82801E_LAN2		0x245d
#define PCI_DEVICE_ID_INTEL_82801E_PCI		0x245e

#define PCI_DEVICE_ID_INTEL_82870_1E0 0x1461
#define PCI_DEVICE_ID_INTEL_82870_1F0 0x1460
#define PCI_DEVICE_ID_INTEL_82820FW_0 0x2440
#define PCI_DEVICE_ID_INTEL_82820FW_1 0x2442
#define PCI_DEVICE_ID_INTEL_82820FW_2 0x2443
#define PCI_DEVICE_ID_INTEL_82820FW_3 0x2444
#define PCI_DEVICE_ID_INTEL_82820FW_4 0x2449
#define PCI_DEVICE_ID_INTEL_82820FW_5 0x244b
#define PCI_DEVICE_ID_INTEL_82820FW_6 0x244e

/* Intel 6300ESB */
#define PCI_DEVICE_ID_INTEL_6300ESB_LPC		0x25a1
#define PCI_DEVICE_ID_INTEL_6300ESB_AC97_AUDIO	0x25a6
#define PCI_DEVICE_ID_INTEL_6300ESB_AC97_MODEM	0x25a7
#define PCI_DEVICE_ID_INTEL_6300ESB_EHCI	0x25ad
#define PCI_DEVICE_ID_INTEL_6300ESB_IDE		0x25a2
#define PCI_DEVICE_ID_INTEL_6300ESB_PCI		0x244e
#define PCI_DEVICE_ID_INTEL_6300ESB_USB1	0x25a9
#define PCI_DEVICE_ID_INTEL_6300ESB_SMB		0x25a4
#define PCI_DEVICE_ID_INTEL_6300ESB_USB2	0x25aa
#define PCI_DEVICE_ID_INTEL_6300ESB_SATA	0x25a3
#define PCI_DEVICE_ID_INTEL_6300ESB_SATA_RAID	0x25b0
#define PCI_DEVICE_ID_INTEL_6300ESB_APIC1	0x25ac
#define PCI_DEVICE_ID_INTEL_6300ESB_PCI_X	0x25ae
#define PCI_DEVICE_ID_INTEL_6300ESB_WDT		0x25ab

/* Intel 3100 */
#define PCI_DEVICE_ID_INTEL_3100_LPC    0x2670
#define PCI_DEVICE_ID_INTEL_3100_EHCI   0x268c
#define PCI_DEVICE_ID_INTEL_3100_PCI    0x244e
#define PCI_DEVICE_ID_INTEL_3100_IDE    0x2680
#define PCI_DEVICE_ID_INTEL_3100_AHCI   0x2681
#define PCI_DEVICE_ID_INTEL_3100_UHCI   0x2688
#define PCI_DEVICE_ID_INTEL_3100_UHCI2  0x2689
#define PCI_DEVICE_ID_INTEL_3100_SMB    0x269b
#define PCI_DEVICE_ID_INTEL_3100_MC     0x35b0
#define PCI_DEVICE_ID_INTEL_3100_PCIE_PA0 0x35b6
#define PCI_DEVICE_ID_INTEL_3100_PCIE_PA1 0x35b7
#define PCI_DEVICE_ID_INTEL_3100_PCIE_PB0 0x2690
#define PCI_DEVICE_ID_INTEL_3100_PCIE_PB1 0x2692
#define PCI_DEVICE_ID_INTEL_3100_PCIE_PB2 0x2694
#define PCI_DEVICE_ID_INTEL_3100_PCIE_PB3 0x2696

/* Intel EP80579 */
#define PCI_DEVICE_ID_INTEL_EP80579_LPC    0x5031
#define PCI_DEVICE_ID_INTEL_EP80579_EHCI   0x5035
#define PCI_DEVICE_ID_INTEL_EP80579_IDE    0x5028
#define PCI_DEVICE_ID_INTEL_EP80579_AHCI   0x5029
#define PCI_DEVICE_ID_INTEL_EP80579_UHCI   0x5033
#define PCI_DEVICE_ID_INTEL_EP80579_SMB    0x5032
#define PCI_DEVICE_ID_INTEL_EP80579_MC     0x5020
#define PCI_DEVICE_ID_INTEL_EP80579_PCIE_PA0 0x5024
#define PCI_DEVICE_ID_INTEL_EP80579_PCIE_PA1 0x5025

#define PCI_DEVICE_ID_INTEL_80310	0x530d
#define PCI_DEVICE_ID_INTEL_82810_MC1	0x7120
#define PCI_DEVICE_ID_INTEL_82810_IG1	0x7121
#define PCI_DEVICE_ID_INTEL_82810_MC3	0x7122
#define PCI_DEVICE_ID_INTEL_82810_IG3	0x7123
#define PCI_DEVICE_ID_INTEL_82443LX_0	0x7180
#define PCI_DEVICE_ID_INTEL_82443LX_1	0x7181
#define PCI_DEVICE_ID_INTEL_82443BX_0	0x7190
#define PCI_DEVICE_ID_INTEL_82443BX_1	0x7191
#define PCI_DEVICE_ID_INTEL_82443BX_2	0x7192
#define PCI_DEVICE_ID_INTEL_82443MX_0	0x7198
#define PCI_DEVICE_ID_INTEL_82443MX_1	0x7199
#define PCI_DEVICE_ID_INTEL_82443MX_2	0x719a
#define PCI_DEVICE_ID_INTEL_82443MX_3	0x719b
#define PCI_DEVICE_ID_INTEL_82372FB_0	0x7600
#define PCI_DEVICE_ID_INTEL_82372FB_1	0x7601
#define PCI_DEVICE_ID_INTEL_82372FB_2	0x7602
#define PCI_DEVICE_ID_INTEL_82372FB_3	0x7603
#define PCI_DEVICE_ID_INTEL_82454GX	0x84c4
#define PCI_DEVICE_ID_INTEL_82450GX	0x84c5
#define PCI_DEVICE_ID_INTEL_82451NX	0x84ca
#define PCI_DEVICE_ID_INTEL_82454NX     0x84cb
#define PCI_DEVICE_ID_INTEL_PCIE_PA	0x3595
#define PCI_DEVICE_ID_INTEL_PCIE_PA1	0x3596
#define PCI_DEVICE_ID_INTEL_PCIE_PB	0x3597
#define PCI_DEVICE_ID_INTEL_PCIE_PC	0x3599

/* Intel LPC device ids  */
#define PCI_DEVICE_ID_INTEL_LPT_MOBILE_SAMPLE		0x8c41
#define PCI_DEVICE_ID_INTEL_LPT_DESKTOP_SAMPLE		0x8c42
#define PCI_DEVICE_ID_INTEL_LPT_Z87			0x8c44
#define PCI_DEVICE_ID_INTEL_LPT_Z85			0x8c46
#define PCI_DEVICE_ID_INTEL_LPT_HM86			0x8c49
#define PCI_DEVICE_ID_INTEL_LPT_H87			0x8c4a
#define PCI_DEVICE_ID_INTEL_LPT_HM87			0x8c4b
#define PCI_DEVICE_ID_INTEL_LPT_Q85			0x8c4c
#define PCI_DEVICE_ID_INTEL_LPT_Q87			0x8c4e
#define PCI_DEVICE_ID_INTEL_LPT_QM87			0x8c4f
#define PCI_DEVICE_ID_INTEL_LPT_B85			0x8c50
#define PCI_DEVICE_ID_INTEL_LPT_C222			0x8c52
#define PCI_DEVICE_ID_INTEL_LPT_C224			0x8c54
#define PCI_DEVICE_ID_INTEL_LPT_C226			0x8c56
#define PCI_DEVICE_ID_INTEL_LPT_H81			0x8c5c
#define PCI_DEVICE_ID_INTEL_LPT_LP_SAMPLE		0x9c41
#define PCI_DEVICE_ID_INTEL_LPT_LP_PREMIUM		0x9c43
#define PCI_DEVICE_ID_INTEL_LPT_LP_MAINSTREAM		0x9c45
#define PCI_DEVICE_ID_INTEL_LPT_LP_VALUE		0x9c47
#define PCI_DEVICE_ID_INTEL_SPT_LP_SAMPLE		0x9d41
#define PCI_DEVICE_ID_INTEL_SPT_LP_U_BASE		0x9d43
#define PCI_DEVICE_ID_INTEL_SPT_LP_U_PREMIUM		0x9d48
#define PCI_DEVICE_ID_INTEL_SPT_LP_Y_PREMIUM		0x9d46
#define PCI_DEVICE_ID_INTEL_SPT_H_H110			0xa143
#define PCI_DEVICE_ID_INTEL_SPT_H_H170			0xa144
#define PCI_DEVICE_ID_INTEL_SPT_H_Z170			0xa145
#define PCI_DEVICE_ID_INTEL_SPT_H_Q170			0xa146
#define PCI_DEVICE_ID_INTEL_SPT_H_Q150			0xa147
#define PCI_DEVICE_ID_INTEL_SPT_H_B150			0xa148
#define PCI_DEVICE_ID_INTEL_SPT_H_C236			0xa149
#define PCI_DEVICE_ID_INTEL_SPT_H_C232			0xa14a
#define PCI_DEVICE_ID_INTEL_SPT_H_QM170			0xa14d
#define PCI_DEVICE_ID_INTEL_SPT_H_HM170			0xa14e
#define PCI_DEVICE_ID_INTEL_SPT_H_CM236			0xa150
#define PCI_DEVICE_ID_INTEL_SPT_H_HM175			0xa152
#define PCI_DEVICE_ID_INTEL_SPT_H_QM175			0xa153
#define PCI_DEVICE_ID_INTEL_SPT_H_CM238			0xa154
#define PCI_DEVICE_ID_INTEL_LWB_C621			0xa1c1
#define PCI_DEVICE_ID_INTEL_LWB_C622			0xa1c2
#define PCI_DEVICE_ID_INTEL_LWB_C624			0xa1c3
#define PCI_DEVICE_ID_INTEL_LWB_C625			0xa1c4
#define PCI_DEVICE_ID_INTEL_LWB_C626			0xa1c5
#define PCI_DEVICE_ID_INTEL_LWB_C627			0xa1c6
#define PCI_DEVICE_ID_INTEL_LWB_C628			0xa1c7
#define PCI_DEVICE_ID_INTEL_LWB_C629			0xa1ca
#define PCI_DEVICE_ID_INTEL_LWB_C624_SUPER		0xa242
#define PCI_DEVICE_ID_INTEL_LWB_C627_SUPER_1		0xa243
#define PCI_DEVICE_ID_INTEL_LWB_C621_SUPER		0xa244
#define PCI_DEVICE_ID_INTEL_LWB_C627_SUPER_2		0xa245
#define PCI_DEVICE_ID_INTEL_LWB_C628_SUPER		0xa246
#define PCI_DEVICE_ID_INTEL_KBP_H_H270			0xa2c4
#define PCI_DEVICE_ID_INTEL_KBP_H_Z270			0xa2c5
#define PCI_DEVICE_ID_INTEL_KBP_H_Q270			0xa2c6
#define PCI_DEVICE_ID_INTEL_KBP_H_Q250			0xa2c7
#define PCI_DEVICE_ID_INTEL_KBP_H_B250			0xa2c8
#define PCI_DEVICE_ID_INTEL_SPT_LP_Y_PREMIUM_HDCP22		0x9d4b
#define PCI_DEVICE_ID_INTEL_SPT_LP_U_PREMIUM_HDCP22		0x9d4e
#define PCI_DEVICE_ID_INTEL_SPT_LP_U_BASE_HDCP22		0x9d50
#define PCI_DEVICE_ID_INTEL_KBP_LP_SUPER_SKU		0x9d51
#define PCI_DEVICE_ID_INTEL_KBP_LP_U_PREMIUM		0x9d58
#define PCI_DEVICE_ID_INTEL_KBP_LP_Y_PREMIUM		0x9d56
#define PCI_DEVICE_ID_INTEL_APL_LPC		0x5ae8
#define PCI_DEVICE_ID_INTEL_GLK_LPC		0x31e8
#define PCI_DEVICE_ID_INTEL_GLK_ESPI		0x3197
#define PCI_DEVICE_ID_INTEL_CNL_BASE_U_LPC	0x9d85
#define PCI_DEVICE_ID_INTEL_CNL_U_PREMIUM_LPC	0x9d84
#define PCI_DEVICE_ID_INTEL_CNL_Y_PREMIUM_LPC	0x9d83
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_H310	0xa303
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_H370	0xa304
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_Z390	0xa305
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_Q370	0xa306
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_B360	0xa308
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_C246	0xa309
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_C242	0xa30a
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_QM370	0xa30c
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_HM370	0xa30d
#define PCI_DEVICE_ID_INTEL_CNP_H_LPC_CM246	0xa30e
#define PCI_DEVICE_ID_INTEL_ICL_U_SUPER_U_ESPI	0x3480
#define PCI_DEVICE_ID_INTEL_ICL_U_SUPER_U_ESPI_REV0	0x3481
#define PCI_DEVICE_ID_INTEL_ICL_U_PREMIUM_ESPI	0x3482
#define PCI_DEVICE_ID_INTEL_ICL_BASE_Y_ESPI	0x3483
#define PCI_DEVICE_ID_INTEL_ICL_BASE_U_ESPI	0x3484
#define PCI_DEVICE_ID_INTEL_ICL_Y_PREMIUM_ESPI	0x3487
#define PCI_DEVICE_ID_INTEL_ICL_SUPER_Y_ESPI	0x3486
#define PCI_DEVICE_ID_INTEL_CMP_SUPER_U_LPC	0x0281
#define PCI_DEVICE_ID_INTEL_CMP_PREMIUM_Y_LPC	0x0283
#define PCI_DEVICE_ID_INTEL_CMP_PREMIUM_U_LPC	0x0284
#define PCI_DEVICE_ID_INTEL_CMP_BASE_U_LPC	0x0285
#define PCI_DEVICE_ID_INTEL_CMP_SUPER_Y_LPC	0x0286
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_0	0xA080
#define PCI_DEVICE_ID_INTEL_TGP_SUPER_U_ESPI	0xA081
#define PCI_DEVICE_ID_INTEL_TGP_PREMIUM_U_ESPI	0xA082
#define PCI_DEVICE_ID_INTEL_TGP_BASE_U_ESPI	0xA083
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_1	0xA084
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_2	0xA085
#define PCI_DEVICE_ID_INTEL_TGP_SUPER_Y_ESPI	0xA086
#define PCI_DEVICE_ID_INTEL_TGP_PREMIUM_Y_ESPI	0xA087
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_3	0xA088
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_4	0xA089
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_5	0xA08A
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_6	0xA08B
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_7	0xA08C
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_8	0xA08D
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_9	0xA08E
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_10	0xA08F
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_11	0xA090
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_12	0xA091
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_13	0xA092
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_14	0xA093
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_15	0xA094
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_16	0xA095
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_17	0xA096
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_18	0xA097
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_19	0xA098
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_20	0xA099
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_21	0xA09A
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_22	0xA09B
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_23	0xA09C
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_24	0xA09D
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_25	0xA09E
#define PCI_DEVICE_ID_INTEL_TGP_ESPI_26	0xA09F

/* Intel PCIE device ids  */
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP1		0x9d10
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP2		0x9d11
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP3		0x9d12
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP4		0x9d13
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP5		0x9d14
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP6		0x9d15
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP7		0x9d16
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP8		0x9d17
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP9		0x9d18
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP10		0x9d19
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP11		0x9d1a
#define PCI_DEVICE_ID_INTEL_SPT_LP_PCIE_RP12		0x9d1b

#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP1		0xa110
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP2		0xa111
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP3		0xa112
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP4		0xa113
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP5		0xa114
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP6		0xa115
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP7		0xa116
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP8		0xa117
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP9		0xa118
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP10		0xa119
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP11		0xa11a
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP12		0xa11b
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP13		0xa11c
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP14		0xa11d
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP15		0xa11e
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP16		0xa11f
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP17		0xa167
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP18		0xa168
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP19		0xa169
#define PCI_DEVICE_ID_INTEL_SPT_H_PCIE_RP20		0xa16a

#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP1		0xa190
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP2		0xa191
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP3		0xa192
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP4		0xa193
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP5		0xa194
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP6		0xa195
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP7		0xa196
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP8		0xa197
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP9		0xa198
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP10		0xa199
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP11		0xa19a
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP12		0xa19b
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP13		0xa19c
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP14		0xa19d
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP15		0xa19e
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP16		0xa19f
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP17		0xa1e7
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP18		0xa1e8
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP19		0xa1e9
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP20		0xa1ea

#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP1_SUPER		0xa210
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP2_SUPER		0xa211
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP3_SUPER		0xa212
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP4_SUPER		0xa213
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP5_SUPER		0xa214
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP6_SUPER		0xa215
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP7_SUPER		0xa216
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP8_SUPER		0xa217
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP9_SUPER		0xa218
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP10_SUPER		0xa219
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP11_SUPER		0xa21a
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP12_SUPER		0xa21b
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP13_SUPER		0xa21c
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP14_SUPER		0xa21d
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP15_SUPER		0xa21e
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP16_SUPER		0xa21f
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP17_SUPER		0xa267
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP18_SUPER		0xa268
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP19_SUPER		0xa269
#define PCI_DEVICE_ID_INTEL_LWB_PCIE_RP20_SUPER		0xa26a

#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP1		0xa290
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP2		0xa291
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP3		0xa292
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP4		0xa293
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP5		0xa294
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP6		0xa295
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP7		0xa296
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP8		0xa297
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP9		0xa298
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP10		0xa299
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP11		0xa29a
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP12		0xa29b
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP13		0xa29c
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP14		0xa29d
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP15		0xa29e
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP16		0xa29f
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP17		0xa2e7
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP18		0xa2e8
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP19		0xa2e9
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP20		0xa2ea
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP21		0xa2eb
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP22		0xa2ec
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP23		0xa2ed
#define PCI_DEVICE_ID_INTEL_KBP_H_PCIE_RP24		0xa2ee

#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP1		0x9db8
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP2		0x9db9
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP3		0x9dba
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP4		0x9dbb
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP5		0x9dbc
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP6		0x9dbd
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP7		0x9dbe
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP8		0x9dbf
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP9		0x9db0
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP10		0x9db1
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP11		0x9db2
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP12		0x9db3
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP13		0x9db4
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP14		0x9db5
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP15		0x9db6
#define PCI_DEVICE_ID_INTEL_CNL_LP_PCIE_RP16		0x9db7
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP1		0x34b8
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP2		0x34b9
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP3		0x34ba
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP4		0x34bb
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP5		0x34bc
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP6		0x34bd
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP7		0x34be
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP8		0x34bf
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP9		0x34b0
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP10		0x34b1
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP11		0x34b2
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP12		0x34b3
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP13		0x34b4
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP14		0x34b5
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP15		0x34b6
#define PCI_DEVICE_ID_INTEL_ICP_LP_PCIE_RP16		0x34b7

#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP1		0xa0b8
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP2		0xa0b9
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP3		0xa0ba
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP4		0xa0bb
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP5		0xa0bc
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP6		0xa0bd
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP7		0xa0be
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP8		0xa0bf
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP9		0xa0b0
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP10		0xa0b1
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP11		0xa0b2
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP12		0xa0b3
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP13		0xa0b4
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP14		0xa0b5
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP15		0xa0b6
#define PCI_DEVICE_ID_INTEL_TGP_LP_PCIE_RP16		0xa0b7

#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP1		0xa338
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP2		0xa339
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP3		0xa33a
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP4		0xa33b
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP5		0xa33c
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP6		0xa33d
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP7		0xa33e
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP8		0xa33f
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP9		0xa330
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP10		0xa331
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP11		0xa332
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP12		0xa333
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP13		0xa334
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP14		0xa335
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP15		0xa336
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP16		0xa337
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP17		0xa340
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP18		0xa341
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP19		0xa342
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP20		0xa343
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP21		0xa32c
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP22		0xa32d
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP23		0xa32e
#define PCI_DEVICE_ID_INTEL_CNP_H_PCIE_RP24		0xa32f

#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP1		0x02b8
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP2		0x02b9
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP3		0x02ba
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP4		0x02bb
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP5		0x02bc
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP6		0x02bd
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP7		0x02be
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP8		0x02bf
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP9		0x02b0
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP10		0x02b1
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP11		0x02b2
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP12		0x02b3
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP13		0x02b4
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP14		0x02b5
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP15		0x02b6
#define PCI_DEVICE_ID_INTEL_CMP_LP_PCIE_RP16		0x02b7

/* Intel SATA device Ids */
#define PCI_DEVICE_ID_INTEL_SPT_U_SATA		0x9d03
#define PCI_DEVICE_ID_INTEL_SPT_U_Y_PREMIUM_SATA		0x9d07
#define PCI_DEVICE_ID_INTEL_SPT_KBL_SATA		0x282a
#define PCI_DEVICE_ID_INTEL_LWB_SATA_AHCI		0xa182
#define PCI_DEVICE_ID_INTEL_LWB_SATA_RAID		0xa186
#define PCI_DEVICE_ID_INTEL_LWB_SSATA_AHCI		0xa1d2
#define PCI_DEVICE_ID_INTEL_LWB_SSATA_RAID		0xa1d6
#define PCI_DEVICE_ID_INTEL_LWB_SATA_ALT		0x2822
#define PCI_DEVICE_ID_INTEL_LWB_SATA_ALT_RST		0x2826
#define PCI_DEVICE_ID_INTEL_LWB_SATA_AHCI_SUPER		0xa202
#define PCI_DEVICE_ID_INTEL_LWB_SATA_RAID_SUPER		0xa206
#define PCI_DEVICE_ID_INTEL_LWB_SSATA_AHCI_SUPER	0xa252
#define PCI_DEVICE_ID_INTEL_LWB_SSATA_RAID_SUPER	0xa256
#define PCI_DEVICE_ID_INTEL_LWB_SSATA_ALT		0x2823
#define PCI_DEVICE_ID_INTEL_LWB_SSATA_ALT_RST		0x2827
#define PCI_DEVICE_ID_INTEL_APL_SATA		0x5ae0
#define PCI_DEVICE_ID_INTEL_GLK_SATA		0x31e3
#define PCI_DEVICE_ID_INTEL_CNL_SATA		0x9dd5
#define PCI_DEVICE_ID_INTEL_CNL_PREMIUM_SATA	0x9dd7
#define PCI_DEVICE_ID_INTEL_CNP_CMP_COMPAT_SATA	0x282a
#define PCI_DEVICE_ID_INTEL_CNP_H_SATA		0xa352
#define PCI_DEVICE_ID_INTEL_CNP_LP_SATA		0x9dd3
#define PCI_DEVICE_ID_INTEL_ICP_U_SATA		0x34d3
#define PCI_DEVICE_ID_INTEL_CMP_SATA		0x02d5
#define PCI_DEVICE_ID_INTEL_CMP_PREMIUM_SATA	0x02d7
#define PCI_DEVICE_ID_INTEL_CMP_LP_SATA		0x02d3
#define PCI_DEVICE_ID_INTEL_TGP_LP_SATA		0xa0d3
#define PCI_DEVICE_ID_INTEL_TGP_SATA		0xa0d5
#define PCI_DEVICE_ID_INTEL_TGP_PREMIUM_SATA	0xa0d7
#define PCI_DEVICE_ID_INTEL_TGP_COMPAT_SATA	0x282a

/* Intel PMC device Ids */
#define PCI_DEVICE_ID_INTEL_SPT_LP_PMC		0x9d21
#define PCI_DEVICE_ID_INTEL_SPT_H_PMC		0xa121
#define PCI_DEVICE_ID_INTEL_LWB_PMC		0xa1a1
#define PCI_DEVICE_ID_INTEL_LWB_PMC_SUPER	0xa221
#define PCI_DEVICE_ID_INTEL_KBP_H_PMC		0xa2a1
#define PCI_DEVICE_ID_INTEL_APL_PMC		0x5a94
#define PCI_DEVICE_ID_INTEL_GLK_PMC		0x3194
#define PCI_DEVICE_ID_INTEL_CNL_PMC		0x9da1
#define PCI_DEVICE_ID_INTEL_CNP_H_PMC		0xa321
#define PCI_DEVICE_ID_INTEL_ICP_PMC		0x34a1
#define PCI_DEVICE_ID_INTEL_CMP_PMC		0x02a1
#define PCI_DEVICE_ID_INTEL_TGP_PMC		0xa0a1

/* Intel I2C device Ids */
#define PCI_DEVICE_ID_INTEL_SPT_I2C0		0x9d60
#define PCI_DEVICE_ID_INTEL_SPT_I2C1		0x9d61
#define PCI_DEVICE_ID_INTEL_SPT_I2C2		0x9d62
#define PCI_DEVICE_ID_INTEL_SPT_I2C3		0x9d63
#define PCI_DEVICE_ID_INTEL_SPT_I2C4		0x9d64
#define PCI_DEVICE_ID_INTEL_SPT_I2C5		0x9d65
#define PCI_DEVICE_ID_INTEL_KBP_H_I2C0          0xa2e0
#define PCI_DEVICE_ID_INTEL_KBP_H_I2C1          0xa2e1
#define PCI_DEVICE_ID_INTEL_KBP_H_I2C2          0xa2e2
#define PCI_DEVICE_ID_INTEL_KBP_H_I2C3          0xa2e3
#define PCI_DEVICE_ID_INTEL_APL_I2C0		0x5aac
#define PCI_DEVICE_ID_INTEL_APL_I2C1		0x5aae
#define PCI_DEVICE_ID_INTEL_APL_I2C2		0x5ab0
#define PCI_DEVICE_ID_INTEL_APL_I2C3		0x5ab2
#define PCI_DEVICE_ID_INTEL_APL_I2C4		0x5ab4
#define PCI_DEVICE_ID_INTEL_APL_I2C5		0x5ab6
#define PCI_DEVICE_ID_INTEL_APL_I2C6		0x5ab8
#define PCI_DEVICE_ID_INTEL_APL_I2C7		0x5aba
#define PCI_DEVICE_ID_INTEL_GLK_I2C0		0x31ac
#define PCI_DEVICE_ID_INTEL_GLK_I2C1		0x31ae
#define PCI_DEVICE_ID_INTEL_GLK_I2C2		0x31b0
#define PCI_DEVICE_ID_INTEL_GLK_I2C3		0x31b2
#define PCI_DEVICE_ID_INTEL_GLK_I2C4		0x31b4
#define PCI_DEVICE_ID_INTEL_GLK_I2C5		0x31b6
#define PCI_DEVICE_ID_INTEL_GLK_I2C6		0x31b8
#define PCI_DEVICE_ID_INTEL_GLK_I2C7		0x31ba
#define PCI_DEVICE_ID_INTEL_CNL_I2C0		0x9de8
#define PCI_DEVICE_ID_INTEL_CNL_I2C1		0x9de9
#define PCI_DEVICE_ID_INTEL_CNL_I2C2		0x9dea
#define PCI_DEVICE_ID_INTEL_CNL_I2C3		0x9deb
#define PCI_DEVICE_ID_INTEL_CNL_I2C4		0x9dc5
#define PCI_DEVICE_ID_INTEL_CNL_I2C5		0x9dc6
#define PCI_DEVICE_ID_INTEL_CNP_H_I2C0		0xa368
#define PCI_DEVICE_ID_INTEL_CNP_H_I2C1		0xa369
#define PCI_DEVICE_ID_INTEL_CNP_H_I2C2		0xa36a
#define PCI_DEVICE_ID_INTEL_CNP_H_I2C3		0xa36b
#define PCI_DEVICE_ID_INTEL_ICP_I2C0		0x34e8
#define PCI_DEVICE_ID_INTEL_ICP_I2C1		0x34e9
#define PCI_DEVICE_ID_INTEL_ICP_I2C2		0x34ea
#define PCI_DEVICE_ID_INTEL_ICP_I2C3		0x34eb
#define PCI_DEVICE_ID_INTEL_ICP_I2C4		0x34c5
#define PCI_DEVICE_ID_INTEL_ICP_I2C5		0x34c6
#define PCI_DEVICE_ID_INTEL_CMP_I2C0		0x02e8
#define PCI_DEVICE_ID_INTEL_CMP_I2C1		0x02e9
#define PCI_DEVICE_ID_INTEL_CMP_I2C2		0x02ea
#define PCI_DEVICE_ID_INTEL_CMP_I2C3		0x02eb
#define PCI_DEVICE_ID_INTEL_CMP_I2C4		0x02c5
#define PCI_DEVICE_ID_INTEL_CMP_I2C5		0x02c6
#define PCI_DEVICE_ID_INTEL_TGP_I2C0		0xa0e8
#define PCI_DEVICE_ID_INTEL_TGP_I2C1		0xa0e9
#define PCI_DEVICE_ID_INTEL_TGP_I2C2		0xa0ea
#define PCI_DEVICE_ID_INTEL_TGP_I2C3		0xa0eb
#define PCI_DEVICE_ID_INTEL_TGP_I2C4		0xa0c5
#define PCI_DEVICE_ID_INTEL_TGP_I2C5		0xa0c6
#define PCI_DEVICE_ID_INTEL_TGP_I2C6		0xa0d8
#define PCI_DEVICE_ID_INTEL_TGP_I2C7		0xa0d9

/* Intel UART device Ids */
#define PCI_DEVICE_ID_INTEL_SPT_UART0		0x9d27
#define PCI_DEVICE_ID_INTEL_SPT_UART1		0x9d28
#define PCI_DEVICE_ID_INTEL_SPT_UART2		0x9d66
#define PCI_DEVICE_ID_INTEL_SPT_H_UART0		0xa127
#define PCI_DEVICE_ID_INTEL_SPT_H_UART1		0xa128
#define PCI_DEVICE_ID_INTEL_SPT_H_UART2		0xa166
#define PCI_DEVICE_ID_INTEL_KBP_H_UART0		0xa2a7
#define PCI_DEVICE_ID_INTEL_KBP_H_UART1		0xa2a8
#define PCI_DEVICE_ID_INTEL_KBP_H_UART2		0xa2e6
#define PCI_DEVICE_ID_INTEL_APL_UART0		0x5abc
#define PCI_DEVICE_ID_INTEL_APL_UART1		0x5abe
#define PCI_DEVICE_ID_INTEL_APL_UART2		0x5ac0
#define PCI_DEVICE_ID_INTEL_APL_UART3		0x5aee
#define PCI_DEVICE_ID_INTEL_GLK_UART0		0x31bc
#define PCI_DEVICE_ID_INTEL_GLK_UART1		0x31be
#define PCI_DEVICE_ID_INTEL_GLK_UART2		0x31c0
#define PCI_DEVICE_ID_INTEL_GLK_UART3		0x31ee
#define PCI_DEVICE_ID_INTEL_CNL_UART0		0x9da8
#define PCI_DEVICE_ID_INTEL_CNL_UART1		0x9da9
#define PCI_DEVICE_ID_INTEL_CNL_UART2		0x9dc7
#define PCI_DEVICE_ID_INTEL_CNP_H_UART0		0xa328
#define PCI_DEVICE_ID_INTEL_CNP_H_UART1		0xa329
#define PCI_DEVICE_ID_INTEL_CNP_H_UART2		0xa347
#define PCI_DEVICE_ID_INTEL_ICP_UART0		0x34a8
#define PCI_DEVICE_ID_INTEL_ICP_UART1		0x34a9
#define PCI_DEVICE_ID_INTEL_ICP_UART2		0x34c7
#define PCI_DEVICE_ID_INTEL_CMP_UART0		0x02a8
#define PCI_DEVICE_ID_INTEL_CMP_UART1		0x02a9
#define PCI_DEVICE_ID_INTEL_CMP_UART2		0x02c7
#define PCI_DEVICE_ID_INTEL_TGP_UART0		0xa0a8
#define PCI_DEVICE_ID_INTEL_TGP_UART1		0xa0a9
#define PCI_DEVICE_ID_INTEL_TGP_UART2		0xa0c7

/* Intel SPI device Ids */
#define PCI_DEVICE_ID_INTEL_SPT_SPI1		0x9d24
#define PCI_DEVICE_ID_INTEL_SPT_SPI2		0x9d29
#define PCI_DEVICE_ID_INTEL_SPT_SPI3		0x9d2a
#define PCI_DEVICE_ID_INTEL_APL_SPI0		0x5ac2
#define PCI_DEVICE_ID_INTEL_APL_SPI1		0x5ac4
#define PCI_DEVICE_ID_INTEL_APL_SPI2		0x5ac6
#define PCI_DEVICE_ID_INTEL_APL_HWSEQ_SPI		0x5a96
#define PCI_DEVICE_ID_INTEL_GLK_SPI0		0x31c2
#define PCI_DEVICE_ID_INTEL_GLK_SPI1		0x31c4
#define PCI_DEVICE_ID_INTEL_GLK_SPI2		0x31c6
#define PCI_DEVICE_ID_INTEL_CNL_SPI0		0x9daa
#define PCI_DEVICE_ID_INTEL_CNL_SPI1		0x9dab
#define PCI_DEVICE_ID_INTEL_CNL_SPI2		0x9dfb
#define PCI_DEVICE_ID_INTEL_CNL_HWSEQ_SPI	0x9da4
#define PCI_DEVICE_ID_INTEL_LWB_SPI		0xa1a4
#define PCI_DEVICE_ID_INTEL_LWB_SPI_SUPER	0xa224
#define PCI_DEVICE_ID_INTEL_CNP_H_SPI0		0xa32a
#define PCI_DEVICE_ID_INTEL_CNP_H_SPI1		0xa32b
#define PCI_DEVICE_ID_INTEL_CNP_H_SPI2		0xa37b
#define PCI_DEVICE_ID_INTEL_CNP_H_HWSEQ_SPI	0xa324
#define PCI_DEVICE_ID_INTEL_ICP_SPI0		0x34aa
#define PCI_DEVICE_ID_INTEL_ICP_SPI1		0x34ab
#define PCI_DEVICE_ID_INTEL_ICP_SPI2		0x34fb
#define PCI_DEVICE_ID_INTEL_ICP_HWSEQ_SPI	0x34a4
#define PCI_DEVICE_ID_INTEL_CMP_SPI0		0x02aa
#define PCI_DEVICE_ID_INTEL_CMP_SPI1		0x02ab
#define PCI_DEVICE_ID_INTEL_CMP_SPI2		0x02fb
#define PCI_DEVICE_ID_INTEL_CMP_HWSEQ_SPI	0x02a4
#define PCI_DEVICE_ID_INTEL_TGP_SPI0		0xa0a4
#define PCI_DEVICE_ID_INTEL_TGP_GSPI0		0xa0aa
#define PCI_DEVICE_ID_INTEL_TGP_GSPI1		0xa0ab
#define PCI_DEVICE_ID_INTEL_TGP_GSPI2		0x34fb
#define PCI_DEVICE_ID_INTEL_TGP_GSPI3		0xa0fd
#define PCI_DEVICE_ID_INTEL_TGP_GSPI4		0xa0fe
#define PCI_DEVICE_ID_INTEL_TGP_GSPI5		0xa0de
#define PCI_DEVICE_ID_INTEL_TGP_GSPI6		0xa0df

/* Intel IGD device Ids */
#define PCI_DEVICE_ID_INTEL_SKL_GT1F_DT2		0x1902
#define PCI_DEVICE_ID_INTEL_SKL_GT1_SULTM		0x1906
#define PCI_DEVICE_ID_INTEL_SKL_GT1F_SHALM		0x190B
#define PCI_DEVICE_ID_INTEL_SKL_GT2_DT2P1		0x1912
#define PCI_DEVICE_ID_INTEL_SKL_GT2_SULTM		0x1916
#define PCI_DEVICE_ID_INTEL_SKL_GT2_SHALM		0x191B
#define PCI_DEVICE_ID_INTEL_SKL_GT2_SWKSM		0x191D
#define PCI_DEVICE_ID_INTEL_SKL_GT2_SULXM		0x191E
#define PCI_DEVICE_ID_INTEL_SKL_GT3_SULTM		0x1923
#define PCI_DEVICE_ID_INTEL_SKL_GT3E_SULTM_1		0x1926
#define PCI_DEVICE_ID_INTEL_SKL_GT3E_SULTM_2		0x1927
#define PCI_DEVICE_ID_INTEL_SKL_GT3FE_SSRVM		0x192D
#define PCI_DEVICE_ID_INTEL_SKL_GT4_SHALM		0x193B
#define PCI_DEVICE_ID_INTEL_SKL_GT4E_SWSTM		0x193D
#define PCI_DEVICE_ID_INTEL_KBL_GT1F_DT2		0x5902
#define PCI_DEVICE_ID_INTEL_KBL_GT1_SULTM		0x5906
#define PCI_DEVICE_ID_INTEL_KBL_GT1_SHALM_1		0x5908
#define PCI_DEVICE_ID_INTEL_KBL_GT1_SSRVM		0x590A
#define PCI_DEVICE_ID_INTEL_KBL_GT1_SHALM_2		0x590B
#define PCI_DEVICE_ID_INTEL_KBL_GT2_DT2P2		0x5912
#define PCI_DEVICE_ID_INTEL_KBL_GT2_SULTM		0x5916
#define PCI_DEVICE_ID_INTEL_KBL_GT2_SULTMR		0x5917
#define PCI_DEVICE_ID_INTEL_KBL_GT2F_SULTM		0x5921
#define PCI_DEVICE_ID_INTEL_KBL_GT2_SSRVM		0x591A
#define PCI_DEVICE_ID_INTEL_KBL_GT2_SHALM		0x591B
#define PCI_DEVICE_ID_INTEL_KBL_GT2_SWSTM		0x591D
#define PCI_DEVICE_ID_INTEL_KBL_GT2_SULXM		0x591E
#define PCI_DEVICE_ID_INTEL_KBL_GT3E_SULTM_1		0x5926
#define PCI_DEVICE_ID_INTEL_KBL_GT3E_SULTM_2		0x5927
#define PCI_DEVICE_ID_INTEL_KBL_GT4_SHALM		0x593B

#define PCI_DEVICE_ID_INTEL_AML_GT2_ULX			0x591C
#define PCI_DEVICE_ID_INTEL_APL_IGD_HD_505		0x5a84
#define PCI_DEVICE_ID_INTEL_APL_IGD_HD_500		0x5a85
#define PCI_DEVICE_ID_INTEL_GLK_IGD			0x3184
#define PCI_DEVICE_ID_INTEL_GLK_IGD_EU12		0x3185
#define PCI_DEVICE_ID_INTEL_WHL_GT1_ULT_1		0x3EA1
#define PCI_DEVICE_ID_INTEL_WHL_GT2_ULT_1		0x3EA0
#define PCI_DEVICE_ID_INTEL_CNL_GT2_ULX_1		0x5A51
#define PCI_DEVICE_ID_INTEL_CNL_GT2_ULX_2		0x5A59
#define PCI_DEVICE_ID_INTEL_CNL_GT2_ULX_3		0x5A41
#define PCI_DEVICE_ID_INTEL_CNL_GT2_ULX_4		0x5A49
#define PCI_DEVICE_ID_INTEL_CNL_GT2_ULT_1		0x5A52
#define PCI_DEVICE_ID_INTEL_CNL_GT2_ULT_2		0x5A5A
#define PCI_DEVICE_ID_INTEL_CNL_GT2_ULT_3		0x5A42
#define PCI_DEVICE_ID_INTEL_CNL_GT2_ULT_4		0x5A4A
#define PCI_DEVICE_ID_INTEL_CFL_GT2_ULT			0x3EA5
#define PCI_DEVICE_ID_INTEL_CFL_H_GT2			0x3e9b
#define PCI_DEVICE_ID_INTEL_CFL_H_XEON_GT2		0x3e94
#define PCI_DEVICE_ID_INTEL_CFL_S_GT2_1			0x3e92
#define PCI_DEVICE_ID_INTEL_CFL_S_GT2_2			0x3e98
#define PCI_DEVICE_ID_INTEL_CFL_S_GT2_3			0x3e9a
#define PCI_DEVICE_ID_INTEL_CFL_S_GT2_4			0x3e91
#define PCI_DEVICE_ID_INTEL_ICL_GT0_ULT			0x8A70
#define PCI_DEVICE_ID_INTEL_ICL_GT0_5_ULT		0x8A71
#define PCI_DEVICE_ID_INTEL_ICL_GT1_ULT			0x8A40
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULX_0		0x8A50
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULX_1		0x8A5D
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULT_1		0x8A5B
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULX_2		0x8A5C
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULT_2		0x8A5A
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULX_3		0x8A51
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULT_3		0x8A52
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULX_4		0x8A53
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULT_4		0x8A54
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULX_5		0x8A55
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULT_5		0x8A56
#define PCI_DEVICE_ID_INTEL_ICL_GT2_ULX_6		0x8A57
#define PCI_DEVICE_ID_INTEL_ICL_GT3_ULT			0x8A62
#define PCI_DEVICE_ID_INTEL_CML_GT1_ULT_1		0x9B21
#define PCI_DEVICE_ID_INTEL_CML_GT1_ULT_2		0x9B2A
#define PCI_DEVICE_ID_INTEL_CML_GT2_ULT_1		0x9B41
#define PCI_DEVICE_ID_INTEL_CML_GT2_ULT_2		0x9B4A
#define PCI_DEVICE_ID_INTEL_CML_GT1_ULT_3		0x9B2B
#define PCI_DEVICE_ID_INTEL_CML_GT1_ULT_4		0x9B2C
#define PCI_DEVICE_ID_INTEL_CML_GT2_ULT_5		0x9BAA
#define PCI_DEVICE_ID_INTEL_CML_GT2_ULT_6		0x9BCA
#define PCI_DEVICE_ID_INTEL_CML_GT2_ULT_3		0x9B4B
#define PCI_DEVICE_ID_INTEL_CML_GT2_ULT_4		0x9B4C
#define PCI_DEVICE_ID_INTEL_CML_GT1_ULX_1		0x9B20
#define PCI_DEVICE_ID_INTEL_CML_GT2_ULX_1		0x9B40
#define PCI_DEVICE_ID_INTEL_CML_GT1_S_1			0x9B25
#define PCI_DEVICE_ID_INTEL_CML_GT1_S_2			0x9B28
#define PCI_DEVICE_ID_INTEL_CML_GT2_S_1			0x9B45
#define PCI_DEVICE_ID_INTEL_CML_GT2_S_2			0x9B48
#define PCI_DEVICE_ID_INTEL_CML_GT1_H_1			0x9B24
#define PCI_DEVICE_ID_INTEL_CML_GT1_H_2			0x9B22
#define PCI_DEVICE_ID_INTEL_CML_GT2_H_1			0x9B44
#define PCI_DEVICE_ID_INTEL_CML_GT2_H_2			0x9B42
#define PCI_DEVICE_ID_INTEL_TGL_GT0			0x9A7F
#define PCI_DEVICE_ID_INTEL_TGL_GT2_ULT			0x9A49
#define PCI_DEVICE_ID_INTEL_TGL_GT3_ULT			0x9A52
#define PCI_DEVICE_ID_INTEL_TGL_GT2_ULX			0x9A40

/* Intel Northbridge Ids */
#define PCI_DEVICE_ID_INTEL_APL_NB		0x5af0
#define PCI_DEVICE_ID_INTEL_GLK_NB		0x31f0
#define PCI_DEVICE_ID_INTEL_SKL_ID_U		0x1904
#define PCI_DEVICE_ID_INTEL_SKL_ID_Y		0x190c
#define PCI_DEVICE_ID_INTEL_SKL_ID_ULX		0x1924
#define PCI_DEVICE_ID_INTEL_SKL_ID_H_2		0x1900
#define PCI_DEVICE_ID_INTEL_SKL_ID_H_4		0x1910
#define PCI_DEVICE_ID_INTEL_SKL_ID_S_2		0x190f
#define PCI_DEVICE_ID_INTEL_SKL_ID_S_4		0x191f
#define PCI_DEVICE_ID_INTEL_KBL_ID_S		0x590f
#define PCI_DEVICE_ID_INTEL_SKL_ID_H_EM		0x1918
#define PCI_DEVICE_ID_INTEL_KBL_ID_U		0x5904
#define PCI_DEVICE_ID_INTEL_KBL_ID_Y		0x590c
#define PCI_DEVICE_ID_INTEL_KBL_ID_H		0x5910
#define PCI_DEVICE_ID_INTEL_KBL_U_R		0x5914
#define PCI_DEVICE_ID_INTEL_KBL_ID_DT_2		0x5918
#define PCI_DEVICE_ID_INTEL_KBL_ID_DT		0x591f
#define PCI_DEVICE_ID_INTEL_CNL_ID_U		0x5A04
#define PCI_DEVICE_ID_INTEL_CNL_ID_Y		0x5A02
#define PCI_DEVICE_ID_INTEL_WHL_ID_W_4		0x3E34
#define PCI_DEVICE_ID_INTEL_WHL_ID_W_2		0x3E35
#define PCI_DEVICE_ID_INTEL_CFL_ID_U		0x3ED0
#define PCI_DEVICE_ID_INTEL_CFL_ID_U_2		0x3ECC
#define PCI_DEVICE_ID_INTEL_CFL_ID_H		0x3ec4
#define PCI_DEVICE_ID_INTEL_CFL_ID_H_4		0x3e10
#define PCI_DEVICE_ID_INTEL_CFL_ID_H_8		0x3e20
#define PCI_DEVICE_ID_INTEL_CFL_ID_S		0x3ec2
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_DT_2	0x3e0f
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_DT_4	0x3e1f
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_DT_8	0x3e30
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_WS_4	0x3e18
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_WS_6	0x3ec6
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_WS_8	0x3e31
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_S_4	0x3e33
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_S_6	0x3eca
#define PCI_DEVICE_ID_INTEL_CFL_ID_S_S_8	0x3e32
#define PCI_DEVICE_ID_INTEL_ICL_ID_U		0x8A12
#define PCI_DEVICE_ID_INTEL_ICL_ID_U_2_2	0x8A02
#define PCI_DEVICE_ID_INTEL_ICL_ID_Y		0x8A10
#define PCI_DEVICE_ID_INTEL_ICL_ID_Y_2		0x8A00
#define PCI_DEVICE_ID_INTEL_CML_ULT		0x9B61
#define PCI_DEVICE_ID_INTEL_CML_ULT_2_2		0x9B71
#define PCI_DEVICE_ID_INTEL_CML_ULT_6_2		0x9B51
#define PCI_DEVICE_ID_INTEL_CML_ULX		0x9B60
#define PCI_DEVICE_ID_INTEL_CML_S		0x9B55
#define PCI_DEVICE_ID_INTEL_CML_S_10_2		0x9B35
#define PCI_DEVICE_ID_INTEL_CML_H		0x9B54
#define PCI_DEVICE_ID_INTEL_CML_H_8_2		0x9B44
#define PCI_DEVICE_ID_INTEL_TGL_ID_U		0x9A14
#define PCI_DEVICE_ID_INTEL_TGL_ID_U_1		0x9A12
#define PCI_DEVICE_ID_INTEL_TGL_ID_Y		0x9A10

/* Intel SMBUS device Ids */
#define PCI_DEVICE_ID_INTEL_SPT_LP_SMBUS		0x9d23
#define PCI_DEVICE_ID_INTEL_SPT_H_SMBUS			0xa123
#define PCI_DEVICE_ID_INTEL_KBP_H_LWB_SMBUS		0xa1a3
#define PCI_DEVICE_ID_INTEL_LWB_SMBUS_SUPER		0xa223
#define PCI_DEVICE_ID_INTEL_CNL_SMBUS			0x9da3
#define PCI_DEVICE_ID_INTEL_CNP_H_SMBUS			0xa323
#define PCI_DEVICE_ID_INTEL_ICP_LP_SMBUS		0x34a3
#define PCI_DEVICE_ID_INTEL_CMP_SMBUS			0x02a3
#define PCI_DEVICE_ID_INTEL_TGP_LP_SMBUS		0xa0a3

/* Intel XHCI device Ids */
#define PCI_DEVICE_ID_INTEL_APL_XHCI		0x5aa8
#define PCI_DEVICE_ID_INTEL_GLK_XHCI		0x31a8
#define PCI_DEVICE_ID_INTEL_SPT_LP_XHCI		0x9d2f
#define PCI_DEVICE_ID_INTEL_SPT_H_XHCI		0xa12f
#define PCI_DEVICE_ID_INTEL_LWB_XHCI		0xa1af
#define PCI_DEVICE_ID_INTEL_LWB_XHCI_SUPER	0xa22f
#define PCI_DEVICE_ID_INTEL_KBP_H_XHCI		0xa2af
#define PCI_DEVICE_ID_INTEL_CNL_LP_XHCI		0x9ded
#define PCI_DEVICE_ID_INTEL_CNP_H_XHCI		0xa36d
#define PCI_DEVICE_ID_INTEL_ICP_LP_XHCI		0x34ed
#define PCI_DEVICE_ID_INTEL_CMP_LP_XHCI		0x02ed
#define PCI_DEVICE_ID_INTEL_TGP_LP_XHCI		0xa0ed

/* Intel P2SB device Ids */
#define PCI_DEVICE_ID_INTEL_APL_P2SB		0x5a92
#define PCI_DEVICE_ID_INTEL_GLK_P2SB		0x3192
#define PCI_DEVICE_ID_INTEL_LWB_P2SB		0xa1a0
#define PCI_DEVICE_ID_INTEL_LWB_P2SB_SUPER	0xa220
#define PCI_DEVICE_ID_INTEL_SKL_LP_P2SB		0x9d20
#define PCI_DEVICE_ID_INTEL_SKL_P2SB		0xa120
#define PCI_DEVICE_ID_INTEL_KBL_P2SB		0xa2a0
#define PCI_DEVICE_ID_INTEL_CNL_P2SB		0x9da0
#define PCI_DEVICE_ID_INTEL_CNP_H_P2SB		0xa320
#define PCI_DEVICE_ID_INTEL_ICL_P2SB		0x34a0
#define PCI_DEVICE_ID_INTEL_CMP_P2SB		0x02a0
#define PCI_DEVICE_ID_INTEL_TGL_P2SB		0xa0a0

/* Intel SRAM device Ids */
#define PCI_DEVICE_ID_INTEL_APL_SRAM		0x5aec
#define PCI_DEVICE_ID_INTEL_GLK_SRAM		0x31ec
#define PCI_DEVICE_ID_INTEL_CNL_SRAM		0x9def
#define PCI_DEVICE_ID_INTEL_CNP_H_SRAM		0xa36f
#define PCI_DEVICE_ID_INTEL_ICL_SRAM		0x34ef
#define PCI_DEVICE_ID_INTEL_CMP_SRAM		0x02ef
#define PCI_DEVICE_ID_INTEL_TGL_SRAM		0xa0ef

/* Intel AUDIO device Ids */
#define PCI_DEVICE_ID_INTEL_APL_AUDIO		0x5a98
#define PCI_DEVICE_ID_INTEL_GLK_AUDIO		0x3198
#define PCI_DEVICE_ID_INTEL_CNL_AUDIO		0x9dc8
#define PCI_DEVICE_ID_INTEL_SKL_AUDIO		0x9d70
#define PCI_DEVICE_ID_INTEL_SKL_H_AUDIO		0xa171
#define PCI_DEVICE_ID_INTEL_LWB_AUDIO		0xa1f0
#define PCI_DEVICE_ID_INTEL_LWB_AUDIO_SUPER	0xa270
#define PCI_DEVICE_ID_INTEL_KBL_AUDIO		0x9d71
#define PCI_DEVICE_ID_INTEL_CNP_H_AUDIO		0xa348
#define PCI_DEVICE_ID_INTEL_ICL_AUDIO		0x34c8
#define PCI_DEVICE_ID_INTEL_CMP_AUDIO		0x02c8
#define PCI_DEVICE_ID_INTEL_BSW_AUDIO		0x2284
#define PCI_DEVICE_ID_INTEL_TGL_AUDIO		0xa0c8

/* Intel HECI/ME device Ids */
#define PCI_DEVICE_ID_INTEL_APL_CSE0		0x5a9a
#define PCI_DEVICE_ID_INTEL_GLK_CSE0		0x319a
#define PCI_DEVICE_ID_INTEL_CNL_CSE0		0x9de0
#define PCI_DEVICE_ID_INTEL_SKL_CSE0		0x9d3a
#define PCI_DEVICE_ID_INTEL_LWB_CSE0		0xa1ba
#define PCI_DEVICE_ID_INTEL_LWB_CSE1		0xa1bb
#define PCI_DEVICE_ID_INTEL_LWB_CSE2		0xa1be
#define PCI_DEVICE_ID_INTEL_LWB_CSE0_SUPER	0xa23a
#define PCI_DEVICE_ID_INTEL_LWB_CSE1_SUPER	0xa23b
#define PCI_DEVICE_ID_INTEL_LWB_CSE2_SUPER	0xa23e
#define PCI_DEVICE_ID_INTEL_CNP_H_CSE0		0xa360
#define PCI_DEVICE_ID_INTEL_ICL_CSE0		0x34e0
#define PCI_DEVICE_ID_INTEL_CMP_CSE0		0x02e0
#define PCI_DEVICE_ID_INTEL_TGL_CSE0		0xa0e0

/* Intel XDCI device Ids */
#define PCI_DEVICE_ID_INTEL_APL_XDCI		0x5aaa
#define PCI_DEVICE_ID_INTEL_GLK_XDCI		0x31aa
#define PCI_DEVICE_ID_INTEL_SPT_LP_XDCI		0x9d30
#define PCI_DEVICE_ID_INTEL_CNL_LP_XDCI		0x9dee
#define PCI_DEVICE_ID_INTEL_CNP_H_XDCI		0xa36e
#define PCI_DEVICE_ID_INTEL_ICP_LP_XDCI		0x34ee
#define PCI_DEVICE_ID_INTEL_CMP_LP_XDCI		0x02ee
#define PCI_DEVICE_ID_INTEL_TGP_LP_XDCI		0xa0ee

/* Intel SD device Ids */
#define PCI_DEVICE_ID_INTEL_APL_SD		0x5aca
#define PCI_DEVICE_ID_INTEL_GLK_SD		0x31ca
#define PCI_DEVICE_ID_INTEL_SKL_SD		0x9d2d
#define PCI_DEVICE_ID_INTEL_CNL_SD		0x9df5
#define PCI_DEVICE_ID_INTEL_CNP_H_SD		0xa375
#define PCI_DEVICE_ID_INTEL_ICL_SD		0x34f8
#define PCI_DEVICE_ID_INTEL_CMP_SD		0x02f5

/* Intel EMMC device Ids */
#define PCI_DEVICE_ID_INTEL_SKL_EMMC		0x9d2b
#define PCI_DEVICE_ID_INTEL_CMP_EMMC		0x02c4

/* Intel WIFI Ids */
#define PCI_DEVICE_ID_1000_SERIES_WIFI		0x0084
#define PCI_DEVICE_ID_6005_SERIES_WIFI		0x0085
#define PCI_DEVICE_ID_6005_I_SERIES_WIFI	0x0089
#define PCI_DEVICE_ID_1030_SERIES_WIFI		0x008b
#define PCI_DEVICE_ID_6030_I_SERIES_WIFI	0x008e
#define PCI_DEVICE_ID_6030_SERIES_WIFI		0x0090
#define PCI_DEVICE_ID_6150_SERIES_WIFI		0x0886
#define PCI_DEVICE_ID_2030_SERIES_WIFI		0x0888
#define PCI_DEVICE_ID_2000_SERIES_WIFI		0x0891
#define PCI_DEVICE_ID_0135_SERIES_WIFI		0x0893
#define PCI_DEVICE_ID_0105_SERIES_WIFI		0x0895
#define PCI_DEVICE_ID_6035_SERIES_WIFI		0x088f
#define PCI_DEVICE_ID_5300_SERIES_WIFI		0x4236
#define PCI_DEVICE_ID_5100_SERIES_WIFI		0x4237
#define PCI_DEVICE_ID_6000_SERIES_WIFI		0x4238
#define PCI_DEVICE_ID_6000_I_SERIES_WIFI	0x4239
#define PCI_DEVICE_ID_5350_SERIES_WIFI		0x423b
#define PCI_DEVICE_ID_5150_SERIES_WIFI		0x423d
#define PCI_DEVICE_ID_WP_7260_SERIES_1_WIFI	0x08b1
#define PCI_DEVICE_ID_WP_7260_SERIES_2_WIFI	0x08b2
#define PCI_DEVICE_ID_SP_7265_SERIES_1_WIFI	0x095a
#define PCI_DEVICE_ID_SP_7265_SERIES_2_WIFI	0x095b
#define PCI_DEVICE_ID_JP_9000_SERIES_1_WIFI	0x9df0
#define PCI_DEVICE_ID_JP_9000_SERIES_2_WIFI	0x31dc
#define PCI_DEVICE_ID_JP_9000_SERIES_3_WIFI	0xa370
#define PCI_DEVICE_ID_SFP_8260_SERIES_1_WIFI	0x24f3
#define PCI_DEVICE_ID_SFP_8260_SERIES_2_WIFI	0x24f4
#define PCI_DEVICE_ID_WSP_8275_SERIES_1_WIFI	0x24fd
#define PCI_DEVICE_ID_TP_9260_SERIES_WIFI	0x2526
#define PCI_DEVICE_ID_HrP_9560_SERIES_1_WIFI	0x34f0
#define PCI_DEVICE_ID_HrP_9560_SERIES_2_WIFI	0xa0f0
#define PCI_DEVICE_ID_HrP_9560_SERIES_3_WIFI	0x02f0
#define PCI_DEVICE_ID_HrP_9560_SERIES_4_WIFI	0x06f0

#define PCI_VENDOR_ID_COMPUTONE		0x8e0e
#define PCI_DEVICE_ID_COMPUTONE_IP2EX	0x0291
#define PCI_DEVICE_ID_COMPUTONE_PG	0x0302
#define PCI_SUBVENDOR_ID_COMPUTONE	0x8e0e
#define PCI_SUBDEVICE_ID_COMPUTONE_PG4	0x0001
#define PCI_SUBDEVICE_ID_COMPUTONE_PG8	0x0002
#define PCI_SUBDEVICE_ID_COMPUTONE_PG6	0x0003

#define PCI_VENDOR_ID_KTI		0x8e2e
#define PCI_DEVICE_ID_KTI_ET32P2	0x3000

#define PCI_VENDOR_ID_ADAPTEC		0x9004
#define PCI_DEVICE_ID_ADAPTEC_7810	0x1078
#define PCI_DEVICE_ID_ADAPTEC_7821	0x2178
#define PCI_DEVICE_ID_ADAPTEC_38602	0x3860
#define PCI_DEVICE_ID_ADAPTEC_7850	0x5078
#define PCI_DEVICE_ID_ADAPTEC_7855	0x5578
#define PCI_DEVICE_ID_ADAPTEC_5800	0x5800
#define PCI_DEVICE_ID_ADAPTEC_3860	0x6038
#define PCI_DEVICE_ID_ADAPTEC_1480A	0x6075
#define PCI_DEVICE_ID_ADAPTEC_7860	0x6078
#define PCI_DEVICE_ID_ADAPTEC_7861	0x6178
#define PCI_DEVICE_ID_ADAPTEC_7870	0x7078
#define PCI_DEVICE_ID_ADAPTEC_7871	0x7178
#define PCI_DEVICE_ID_ADAPTEC_7872	0x7278
#define PCI_DEVICE_ID_ADAPTEC_7873	0x7378
#define PCI_DEVICE_ID_ADAPTEC_7874	0x7478
#define PCI_DEVICE_ID_ADAPTEC_7895	0x7895
#define PCI_DEVICE_ID_ADAPTEC_7880	0x8078
#define PCI_DEVICE_ID_ADAPTEC_7881	0x8178
#define PCI_DEVICE_ID_ADAPTEC_7882	0x8278
#define PCI_DEVICE_ID_ADAPTEC_7883	0x8378
#define PCI_DEVICE_ID_ADAPTEC_7884	0x8478
#define PCI_DEVICE_ID_ADAPTEC_7885	0x8578
#define PCI_DEVICE_ID_ADAPTEC_7886	0x8678
#define PCI_DEVICE_ID_ADAPTEC_7887	0x8778
#define PCI_DEVICE_ID_ADAPTEC_7888	0x8878
#define PCI_DEVICE_ID_ADAPTEC_1030	0x8b78

#define PCI_VENDOR_ID_ADAPTEC2		0x9005
#define PCI_DEVICE_ID_ADAPTEC2_2940U2	0x0010
#define PCI_DEVICE_ID_ADAPTEC2_2930U2	0x0011
#define PCI_DEVICE_ID_ADAPTEC2_7890B	0x0013
#define PCI_DEVICE_ID_ADAPTEC2_7890	0x001f
#define PCI_DEVICE_ID_ADAPTEC2_3940U2	0x0050
#define PCI_DEVICE_ID_ADAPTEC2_3950U2D	0x0051
#define PCI_DEVICE_ID_ADAPTEC2_7896	0x005f
#define PCI_DEVICE_ID_ADAPTEC2_7892A	0x0080
#define PCI_DEVICE_ID_ADAPTEC2_7892B	0x0081
#define PCI_DEVICE_ID_ADAPTEC2_7892D	0x0083
#define PCI_DEVICE_ID_ADAPTEC2_7892P	0x008f
#define PCI_DEVICE_ID_ADAPTEC2_7899A	0x00c0
#define PCI_DEVICE_ID_ADAPTEC2_7899B	0x00c1
#define PCI_DEVICE_ID_ADAPTEC2_7899D	0x00c3
#define PCI_DEVICE_ID_ADAPTEC2_7899P	0x00cf
#define PCI_DEVICE_ID_ADAPTEC2_7902	0x8012

#define PCI_VENDOR_ID_ATRONICS		0x907f
#define PCI_DEVICE_ID_ATRONICS_2015	0x2015

#define PCI_VENDOR_ID_HOLTEK		0x9412
#define PCI_DEVICE_ID_HOLTEK_6565	0x6565

#define PCI_VENDOR_ID_NETMOS		0x9710
#define PCI_DEVICE_ID_NETMOS_9735	0x9735
#define PCI_DEVICE_ID_NETMOS_9835	0x9835

#define PCI_SUBVENDOR_ID_EXSYS		0xd84d
#define PCI_SUBDEVICE_ID_EXSYS_4014	0x4014

#define PCI_VENDOR_ID_TIGERJET		0xe159
#define PCI_DEVICE_ID_TIGERJET_300	0x0001
#define PCI_DEVICE_ID_TIGERJET_100	0x0002

#define PCI_VENDOR_ID_ARK		0xedd8
#define PCI_DEVICE_ID_ARK_STING		0xa091
#define PCI_DEVICE_ID_ARK_STINGARK	0xa099
#define PCI_DEVICE_ID_ARK_2000MT	0xa0a1

#define PCI_VENDOR_ID_MICROGATE		0x13c0
#define PCI_DEVICE_ID_MICROGATE_USC	0x0010
#define PCI_DEVICE_ID_MICROGATE_SCC	0x0020
#define PCI_DEVICE_ID_MICROGATE_SCA	0x0030

#define PCI_VENDOR_ID_SIS		0x1039
#define PCI_DEVICE_ID_SIS_AGP		0x0002

/* SiS 761GX NORTH BRIDGE */
#define PCI_DEVICE_ID_SIS_SIS761	0x0761
#define PCI_DEVICE_ID_SIS_SIS761_PCIE	0x0004

/* SiS 964(L) SOUTH BRIDGE */
#define PCI_DEVICE_ID_SIS_SIS964_LPC	0x0964	/* D2F0 */
#define PCI_DEVICE_ID_SIS_SIS964_IDE	0x5513	/* D2F5 */
#define PCI_DEVICE_ID_SIS_SIS964_AC97_MODEM 0x7013	/* D2F6 */
#define PCI_DEVICE_ID_SIS_SIS964_AC97_AUDIO 0x7012	/* D2F7 */
#define PCI_DEVICE_ID_SIS_SIS964_USB	0x7001	/* D3F0,D3F1 */
#define PCI_DEVICE_ID_SIS_SIS964_USB2	0x7002	/* D3F3 */
#define PCI_DEVICE_ID_SIS_SIS964_NIC	0x0900	/* D4F0 */
#define PCI_DEVICE_ID_SIS_SIS964_SATA	0x0181	/* D5F0 */
#define PCI_DEVICE_ID_SIS_SIS964_SATA_RAID	0x0180	/* D5F0 */

/* SiS 965(L) SOUTH BRIDGE */
#define PCI_DEVICE_ID_SIS_SIS965_LPC	0x0965	/* D2F0 */
#define PCI_DEVICE_ID_SIS_SIS965_IDE	0x5513	/* D2F5 */
#define PCI_DEVICE_ID_SIS_SIS965_AC97_MODEM 0x7013	/* D2F6 */
#define PCI_DEVICE_ID_SIS_SIS965_AC97_AUDIO 0x7012	/* D2F7 */
#define PCI_DEVICE_ID_SIS_SIS965_USB	0x7001	/* D3F0,D3F1 */
#define PCI_DEVICE_ID_SIS_SIS965_USB2	0x7002	/* D3F3 */
#define PCI_DEVICE_ID_SIS_SIS965L_NIC	0x0190	/* D4F0 */
#define PCI_DEVICE_ID_SIS_SIS965_NIC	0x0191	/* D4F0 */
#define PCI_DEVICE_ID_SIS_SIS965_SATA	0x0183	/* D5F0 */
#define PCI_DEVICE_ID_SIS_SIS965_SATA_RAID	0x0182	/* D5F0 */
#define PCI_DEVICE_ID_SIS_SIS965_PCIE	0x000a  /* D6F0,D7F0 */

/* SiS 966(L) SOUTH BRIDGE */
#define PCI_DEVICE_ID_SIS_SIS966_LPC	0x0966	/* D2F0 */
#define PCI_DEVICE_ID_SIS_SIS966_IDE	0x5513	/* D2F5 */
#define PCI_DEVICE_ID_SIS_SIS966_AC97_MODEM 0x7013	/* D2F6 */
#define PCI_DEVICE_ID_SIS_SIS966_AC97_AUDIO 0x7012	/* D2F7 */
#define PCI_DEVICE_ID_SIS_SIS966_USB	0x7001	/* D3F0,D3F1 */
#define PCI_DEVICE_ID_SIS_SIS966_USB2	0x7002	/* D3F3 */
#define PCI_DEVICE_ID_SIS_SIS966L_NIC	0x0190	/* D4F0 */
#define PCI_DEVICE_ID_SIS_SIS966_NIC	0x0191	/* D4F0 */
#define PCI_DEVICE_ID_SIS_SIS966_SATA	0x1183	/* D5F0 */
#define PCI_DEVICE_ID_SIS_SIS966_SATA_RAID	0x1182	/* D5F0 */
#define PCI_DEVICE_ID_SIS_SIS966_PCIE	0x000a  /* D6F0,D7F0 */
#define PCI_DEVICE_ID_SIS_SIS966_HD_AUDIO	0x7502	/* DfF0 */

/* SiS 968 SOUTH BRIDGE */
#define PCI_DEVICE_ID_SIS_SIS968_LPC	0x0968	/* D2F0 */
#define PCI_DEVICE_ID_SIS_SIS968_IDE	0x5513	/* D2F5 */
#define PCI_DEVICE_ID_SIS_SIS968_USB	0x7001	/* D3F0,D3F1 */
#define PCI_DEVICE_ID_SIS_SIS968_USB2	0x7002	/* D3F3 */
#define PCI_DEVICE_ID_SIS_SIS968_NIC	0x0191	/* D4F0 */
#define PCI_DEVICE_ID_SIS_SIS968_SATA	0x1183	/* D5F0 */
#define PCI_DEVICE_ID_SIS_SIS968_SATA_RAID	0x1184	/* D5F0 */
#define PCI_DEVICE_ID_SIS_SIS968_SATA_AHCI	0x1185	/* D5F0 */
#define PCI_DEVICE_ID_SIS_SIS968_PCIE	0x000a  /* D6F0,D7F0 */
#define PCI_DEVICE_ID_SIS_SIS968_HD_AUDIO	0x7502	/* DfF0 */

/* OLD USAGE FOR COREBOOT */
#define PCI_VENDOR_ID_ACER              0x10b9
#define PCI_DEVICE_ID_ACER_M1535D         0x1533

#define PCI_DEVICE_ID_AMD_761_0         0x700E
#define PCI_DEVICE_ID_AMD_761_1         0x700F
#define PCI_DEVICE_ID_AMD_VIPER_7412    0x7412

/* END OLDER USAGE */

#endif /* __DEVICE_PCI_IDS_H__ */
