---
title: ThinkPad T500 
x-unreviewed: true
...

Introduction
============

It is believed that all or most T500 laptops are compatible. See notes
about [CPU
compatibility](../install/t500_external.html#cpu_compatibility) for
potential incompatibilities.

W500 is also compatible, and mostly the same design as T500.

There are two possible flash chip sizes for the T500: 4MiB (32Mbit) or
8MiB (64Mbit). This can be identified by the type of flash chip below
the palmrest: 4MiB is SOIC-8, 8MiB is SOIC-16.

*The T500 laptops come with the ME (and sometimes AMT in addition)
before flashing libreboot. Libreboot disables and removes it by using a
modified descriptor: see [../install/ich9utils.md](../install/ich9utils.md)*
(contains notes, plus instructions)

Flashing instructions can be found at
[../install/\#flashrom](../install/#flashrom)

EC update {#ecupdate}
=========

It is recommended that you update to the latest EC firmware version. The
[EC firmware](../../faq.md#ec-embedded-controller-firmware) is separate from
libreboot, so we don't actually provide that, but if you still have
Lenovo BIOS then you can just run the Lenovo BIOS update utility, which
will update both the BIOS and EC version. See:

-   [../install/#flashrom](../install/#flashrom)
-   <http://www.thinkwiki.org/wiki/BIOS_update_without_optical_disk>

NOTE: this can only be done when you are using Lenovo BIOS. How to
update the EC firmware while running libreboot is unknown. Libreboot
only replaces the BIOS firmware, not EC.

Updated EC firmware has several advantages e.g. bettery battery
handling.

Compatibility (without blobs) {#compatibility_noblobs}
-----------------------------

### Hardware virtualization (vt-x) {#hwvirt}

The T500, when run without CPU microcode updates in coreboot, currently
kernel panics if running QEMU with vt-x enabled on 2 cores for the
guest. With a single core enabled for the guest, the guest panics (but
the host is fine). Working around this in QEMU might be possible; if
not, software virtualization should work fine (it's just slower).

On GM45 hardware (with libreboot), make sure that the *kvm* and
*kvm\_intel* kernel modules are not loaded, when using QEMU.

The following errata datasheet from Intel might help with investigation:
<http://download.intel.com/design/mobile/specupdt/320121.pdf>

The T500 is almost identical to the X200, code-wise. See
[x200.md](x200.md).
