/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018 (c)
 * 
 *    file: module_cpp.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_cpp[] = { "C", "CPP", "cpp", "cc", "c++", "cxx", "hpp", "cp" };
char *keyword_cpp[] = {
      //basic C++ language keywords
      "alignas",
      "alignof",
      "and",
      "and_eq",
      "asm",
      "auto",
      "bitand",
      "bitor",
      "bool",
      "break",
      "case",
      "catch",
      "char",
      "char16_t",
      "char32_t",
      "class",
      "compl",
      "const",
      "constexpr",
      "const_cast",
      "continue",
      "decltype",
      "default",
      "delete",
      "do",
      "double",
      "dynamic_cast",
      "else",
      "enum",
      "explicit",
      "extern",
      "export",
      "false",
      "float",
      "for",
      "friend",
      "goto",
      "if",
      "inline",
      "int",
      "long",
      "mutable",
      "namespace",
      "new",
      "noexcept",
      "not",
      "not_eq",
      "nullptr",
      "operator",
      "or",
      "or_eq",
      "private",
      "protected",
      "public",
      "register",
      "reinterpret_cast",
      "return",
      "short",
      "signed",
      "sizeof",
      "static",
      "static_assert",
      "static_cast",
      "struct",
      "switch",
      "template",
      "this",
      "thread_local",
      "throw",
      "true",
      "try",
      "typedef",
      "typeid",
      "typename",
      "union",
      "unsigned",
      "using",
      "virtual",
      "void",
      "volatile",
      "wchar_t",
      "while",
      "xor",
      "xor_eq",
      "overried",
      "final",
      //strings library
      "string",
      "wstring",
      "u16string",
      "u32string",
      //containers library
      "array",
      "vector",
      "deque",
      "forward_list",
      "list",
      "set",
      "map",
      "qsort",
      "bsearch",
      //I/O functions
      "srand",
      "rand",
      "std",
      "fopen",
      "freopen",
      "fclose",
      "fflush",
      "fwide",
      "setbuf",
      "setvbuf",
      "fread",
      "fwrite",
      "fgetc",
      "getc",
      "fgets",
      "fputc",
      "putc",
      "fputs",
      "getchar",
      "gets",
      "putchar",
      "puts",
      "ungetc",
      "fgetwc",
      "getwc",
      "fgetws",
      "fputwc",
      "putwc",
      "fputws",
      "getwchar",
      "putwchar",
      "ungetwc",
      "scanf",
      "fscanf",
      "sscanf",
      "vscanf",
      "vfscanf",
      "vsscanf",
      "printf",
      "fprintf",
      "sprintf",
      "snprintf",
      "vprintf",
      "vfprintf",
      "vsprintf",
      "vsnprintf",
      "wscanf",
      "fwscanf",
      "swscanf",
      "vwscanf",
      "vfwscanf",
      "vswscanf",
      "wprintf",
      "fwprintf",
      "swprintf",
      "vwprintf",
      "vfwprintf",
      "vswprintf",
      "ftell",
      "fgetpos",
      "fseek",
      "fsetpos",
      "rewind",
      "clearerr",
      "feof",
      "ferror",
      "perror",
      "remove",
      "rename",
      "tmpfile",
      "tmpnam",
      "stdin",
      "stdout",
      "stderr",
};

struct modulestruct module_cpp =
{
    .extsCount      = 8,
    .exts           = ext_cpp,
    .keywordCount   = 173,
    .keywords       = keyword_cpp,
    .mlCommentStart = "/*",
    .mlCommentEnd   = "*/",
    .slCommentStart = "//",
    .caseSensitive  = 1,
};
