/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import com.google.common.primitives.Bytes;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DsaPrng {
    private Mac mac;
    private byte[] V = new byte[64];
    private byte[] K = new byte[64];
    private static final int qlen = 32;

    private byte[] hmacK(byte[] ... args) {
        try {
            this.mac.init(new SecretKeySpec(this.K, "HmacSHA1"));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("invalid key: " + e.getMessage());
        }
        for (byte[] bytes : args) {
            this.mac.update(bytes);
        }
        return this.mac.doFinal();
    }

    public DsaPrng(byte[] key, byte[] message) {
        MessageDigest digest;
        try {
            this.mac = Mac.getInstance("HmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm 'HmacSHA1' required but not provided");
        }
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("crypto algorithm 'SHA-512' required but not provided");
        }
        byte[] h1 = digest.digest(message);
        Arrays.fill(this.V, (byte)1);
        this.K = this.hmacK(this.V, {0}, key, h1);
        this.V = this.hmacK(new byte[][]{this.V});
        this.K = this.hmacK(this.V, {1}, key, h1);
        this.V = this.hmacK(new byte[][]{this.V});
    }

    public BigInteger nextK() {
        byte[] T = new byte[]{};
        while (T.length < 32) {
            this.V = this.hmacK(new byte[][]{this.V});
            T = Bytes.concat((byte[][])new byte[][]{T, this.V});
        }
        this.K = this.hmacK(this.V, {0});
        this.V = this.hmacK(new byte[][]{this.V});
        return new BigInteger(1, T);
    }
}

