/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <cstdio>
#include <stdlib.h>

static const int mpeg_size   = 188;
static const int padded_size = 256;

int 
main (int argc, char **argv)
{
  unsigned char buf[padded_size];

  while (fread (buf, sizeof (buf), 1, stdin) == 1){
    if (buf[0] != 0x47){
      fprintf (stderr, "unpad_mpeg: missing 0x47 sync byte\n");
      exit (1);
    }
    if (fwrite (buf, mpeg_size, 1, stdout) != 1){
      perror ("unpad_mpeg");
      exit (1);
    }
  }
  exit (0);
}
