/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _GrFastChannelizer_H_
#define _GrFastChannelizer_H_

#include <VrDecimatingSigProc.h>

template<class iType> 
class GrFastChannelizer : public VrDecimatingSigProc<iType,VrComplex> {
private:
  int numTaps;
  int freq;
  float gain;
public: 
  virtual const char *name() { return "GrFastChannelizer"; }
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);

  virtual void initialize();
  GrFastChannelizer(int d, int t, float g);
  GrFastChannelizer(int f, int d, int t, float g);
};

template<class iType> int
GrFastChannelizer<iType>::work(VrSampleRange output, void *ao[],
				VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  VrComplex **o = (VrComplex **)ao;
  unsigned int size = output.size;

  iType a = 0;
  iType b = 0;

if(freq) {
  for(unsigned int j=0;j<history/4;j++)
  {
	a += (i[0][4*j]);
	b += (i[0][4*j+1]);
	a -= (i[0][4*j+2]);
	b -= (i[0][4*j+3]);
  }
  if(history % 4 > 0)
	a += (i[0][((int)(history/4))*4]);
  if(history % 4 > 1)
	b += (i[0][((int)(history/4))*4+1]);
  if(history % 4 > 2)
	a -= (i[0][((int)(history/4))*4+2]);

  for(unsigned int j = 0;j<size/4;j+=1)
  {
	a += i[0][j*4 + history] - i[0][j*4];
	if(j*4 % decimation == 0)
	{
		o[0][0].real(a);
		o[0][0].imag(b);
		o[0]++;
	}
	b += i[0][j*4 + history + 1] - i[0][j*4 + 1];
	if(j*4 % decimation == 1)
	{
		o[0]->real(b);
		o[0]->imag(-a);
		o[0]++;
	}
	a -= i[0][j*4 + history + 2] - i[0][j*4 + 2];
	if(j*4 % decimation == 2)
	{
		o[0]->real(-a);
		o[0]->imag(-b);
		o[0]++;
	}
	b -= i[0][j*4 + history + 3] - i[0][j*4 + 3];
	if(j*4 % decimation == 3)
	{
		o[0]->real(-b);
		o[0]->imag(a);
		o[0]++;
	}
  }
}
else
{
  for(unsigned int j=0;j<history;j++)
            a += (int)(i[0][j]);
  for(unsigned int j=0;j<size;j++)
  {
	  a += i[0][j+history] - i[0][j];
	  if(j % decimation == 0)
	  {
			  o[0][0].real(a);
			  o[0][0].imag(0);
			  o[0]++;
	  } 
  }
			  


}
  return output.size;
}

template<class iType> 
GrFastChannelizer<iType>::GrFastChannelizer(int f, int dec,int t,float g)
  :VrDecimatingSigProc<iType,VrComplex>(1,dec), numTaps(t), freq(0), gain(g)
{
}

template<class iType> 
GrFastChannelizer<iType>::GrFastChannelizer(int dec,int t,float g)
  :VrDecimatingSigProc<iType,VrComplex>(1,dec), numTaps(t), freq(5), gain(g)
{
}

template<class iType> 
void GrFastChannelizer<iType>::initialize()
{
  history=numTaps;
}
#endif
