/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _GRKEEPONEINN_H_
#define _GRKEEPONEINN_H_

#include <VrSigProc.h>


class GrKeepOneInN : public VrSigProc {
  int	d_item_size;
  int	d_N;

public:
  GrKeepOneInN (int item_size, int N);
  ~GrKeepOneInN ();

  virtual const char *name () { return "GrKeepOneInN"; }

  virtual void pre_initialize ();
  virtual int forecast (VrSampleRange output, VrSampleRange inputs[]); 
  virtual int work (VrSampleRange output, void *o[], VrSampleRange inputs[], void *i[]);

};

#endif /* _GRKEEPONEINN_H_ */
