/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GR_FIR_SCC_X86_H_
#define _GR_FIR_SCC_X86_H_

#include <gr_fir_SCC_simd.h>

/*!
 * \brief 3DNow! version of gr_fir_SCC
 */
class gr_fir_SCC_3dnow : public gr_fir_SCC_simd
{
public:
  gr_fir_SCC_3dnow ();
  gr_fir_SCC_3dnow (const std::vector<VrComplex> &taps);
};

/*!
 * \brief 3DNow! Ext version of gr_fir_SCC
 */
class gr_fir_SCC_3dnowext : public gr_fir_SCC_simd
{
public:
  gr_fir_SCC_3dnowext ();
  gr_fir_SCC_3dnowext (const std::vector<VrComplex> &taps);
};

/*!
 * \brief SSE version of gr_fir_SCC
 */
class gr_fir_SCC_sse : public gr_fir_SCC_simd
{
public:
  gr_fir_SCC_sse ();
  gr_fir_SCC_sse (const std::vector<VrComplex> &taps);
};

#endif /* _GR_FIR_SCC_X86_H_ */
