/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _GR_FIR_SYSCONFIG_X86_H_
#define _GR_FIR_SYSCONFIG_X86_H_

#include <gr_fir_sysconfig_generic.h>

class gr_fir_sysconfig_x86 : public gr_fir_sysconfig_generic {
public:
//virtual gr_fir_CCF *create_gr_fir_CCF (const std::vector<float> &taps);
//virtual gr_fir_FCC *create_gr_fir_FCC (const std::vector<VrComplex> &taps);
  virtual gr_fir_FFF *create_gr_fir_FFF (const std::vector<float> &taps);
  virtual gr_fir_FSF *create_gr_fir_FSF (const std::vector<float> &taps);
  virtual gr_fir_SCC *create_gr_fir_SCC (const std::vector<VrComplex> &taps);
//virtual gr_fir_SSS *create_gr_fir_SSS (const std::vector<short> &taps);

  virtual void get_gr_fir_CCF_info (std::vector<gr_fir_CCF_info> *info);
  virtual void get_gr_fir_FCC_info (std::vector<gr_fir_FCC_info> *info);
  virtual void get_gr_fir_FFF_info (std::vector<gr_fir_FFF_info> *info);
  virtual void get_gr_fir_FSF_info (std::vector<gr_fir_FSF_info> *info);
  virtual void get_gr_fir_SCC_info (std::vector<gr_fir_SCC_info> *info);
//virtual void get_gr_fir_SSS_info (std::vector<gr_fir_SSS_info> *info);
};


#endif /* _GR_FIR_SYSCONFIG_X86_H_ */
