#!/usr/bin/python

import sys

#sys.path.append ('.')
#sys.path.append ('/usr/local/gnuradio/python')

try:
    import wx
except ImportError:
    print "Could not find wxPython library.  Try installing a recent version"
    sys.exit(1)

try:
    from rig import *
    from hfgui import *
except ImportError:
    print "Could not import rig.py or hfgui.py.  Make sure they are in this directory"
    sys.exit(1)

try:
    from powermate import *
    from pm_thread import *
except ImportError:
    print "Couldn't Import Powermate modules.  Will go on without them"
    use_powermate = 0
else:
    try:
        pmate = PowerMateThread()
        use_powermate = 1
        print "wxPowermate started"
    except RuntimeError:
        print "wxPowermate not there"
        use_powermate = 0

myrig = rig()
myrig.start()
app = wx.PySimpleApp()
frame = hfgui(None, -1, "Field Day")
frame.myflowgraph = myrig
if(use_powermate):
    pmate.freqcontrol = frame.freq_control
app.MainLoop()
myrig.stop()

if(use_powermate):
    pmate.keep_running = False

