# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

from marionette_test import MarionetteTestCase


class TestStateChrome(MarionetteTestCase):
    def setUp(self):
        MarionetteTestCase.setUp(self)
        self.marionette.set_context("chrome")
        self.win = self.marionette.current_window_handle
        self.marionette.execute_script("window.open('chrome://marionette/content/test.xul', 'foo', 'chrome,centerscreen');")
        self.marionette.switch_to_window('foo')
        self.assertNotEqual(self.win, self.marionette.current_window_handle)

    def tearDown(self):
        self.assertNotEqual(self.win, self.marionette.current_window_handle)
        self.marionette.execute_script("window.close();")
        self.marionette.switch_to_window(self.win)
        MarionetteTestCase.tearDown(self)

    def test_isEnabled(self):
        l = self.marionette.find_element("id", "textInput")
        self.assertTrue(l.is_enabled())
        self.marionette.execute_script("arguments[0].disabled = true;", [l])
        self.assertFalse(l.is_enabled())
        self.marionette.execute_script("arguments[0].disabled = false;", [l])

    def test_can_get_element_rect(self):
        l = self.marionette.find_element("id", "textInput")
        rect = l.rect
        self.assertTrue(rect['x'] > 0)
        self.assertTrue(rect['y'] > 0)

    ''' Switched on in Bug 896043 to be turned on in Bug 896046
    def test_isDisplayed(self):
        l = self.marionette.find_element("id", "textInput")
        self.assertTrue(l.is_displayed())
        self.marionette.execute_script("arguments[0].hidden = true;", [l])
        self.assertFalse(l.is_displayed())
        self.marionette.execute_script("arguments[0].hidden = false;", [l])
    '''