'\" st                        -*- nroff -*-
.ig
groff.7

This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2000, 2001 Free Software Foundation, Inc.
written by Bernd Warken <bwarken@mayn.de>

Last update: 17 May 2000

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHOR, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.
.\" --------------------------------------------------------------------
.\" Setup
.\" --------------------------------------------------------------------
.
.if n \{\
.  mso tty-char.tmac
.  ftr CR R
.  ftr CI I
.  ftr CB B
.\}
.
.if '\*[.T]'dvi' \{\
.  ftr CB CW
.\}
.
.\" a comment macro which does nothing
.de c
..
.
.\" a tab string
.ds t "\t
.
.eo
.
.c text lines in macro definitions or bracketed sections \{...\}
.de text
.  if 1 \&\$*\&
..
.
.de option
.  ds @tmp@ \f(CB\$1\fP
.  shift 1
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.als shellcommand option
.
.c --------- characters ---------
.
.de character
.  ds @tmp@ \f(CB\$1\fP
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de 'char
.  ds @tmp@ \(oq\f(CB\$1\fP\(cq
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de ''char
.  ds @tmp@ \(lq\f(CB\$1\fP\(rq
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.c --------- requests ---------
.
.c request synopsis
.de REQ
.  ds @tmp@ \&\$1
.  shift 1
.  IP "\f(CB\&\*[@tmp@] \fP\f(CI\&\$*\fP" 10n
.  rm @tmp@
..
.
.de request
.  ds @tmp@ \f(CB\$1\fP
.  shift 1
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.c --------- macro or function arguments ---------
.
.de argument
.  ds @tmp@ \f(CI\$1\fP
.  shift 1
.  while (\n[.$] >= 2) \{\
.    as @tmp@ \/\f(CR\$1\fP\f(CI\,\$2\fP
.    shift 2
.  \}
.  if \n[.$] .as @tmp@ \/\f(CR\$1\fP
.  text \*[@tmp@]
.  rm @tmp@
..
.
.c argument followed by a numerical expression
.de argterm
.  ds @tmp@ \f(CI\$1\fP\|\f(CR\$2\fP
.  shift 2
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.c --------- numerical elements ---------
.
.de number
.  ds @tmp@ \f(CR\$1\fP
.  shift 1
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de prefixednumber
.  ds @tmp@ \&\$1\ \f(CR\$2\fP
.  shift 2
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.als scaleindicator request
.
.de scalednumber
.  ds @tmp@ \f(CR\$1\fP\f(CB\$2\fP
.  shift 2
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de operator
.  ds @tmp@ \(oq\f(CB\$1\fP\(cq
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.c --------- escape sequences ---------
.
.de esc[arg]
.  ds @tmp@ \f(CB\(rs\$1[\fP\f(CI\$2\fP\f(CB]\fP
.  shift 2
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de esc(arg
.  ds @tmp@ \f(CB\(rs\$1(\fP\f(CI\$2\fP
.  shift 2
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de escarg
.  ds @tmp@ \f(CB\(rs\$1\fP\f(CI\$2\fP
.  shift 2
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de esc[]
.  ds @tmp@ \f(CB\(rs[\fP\f(CI\$1\fP\f(CB]\fP
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de esc(
.  ds @tmp@ \f(CB\(rs(\fP\f(CI\$1\fP
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de esc
.  ds @tmp@ \f(CB\(rs\$1\fP
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de (esc
.  ds @tmp@ \f(CB\(rs(\$1\fP
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.de [esc]
.  ds @tmp@ \f(CB\(rs[\$1]\fP
.  shift
.  text \*[@tmp@]\$*
.  rm @tmp@
..
.
.c escape sequence synopsis
.de ESC
.  ds @tmp@ \&\$1
.  shift 1
.  IP "\f(CB\(rs\&\*[@tmp@]\fP\f(CI\&\$*\fP"
.  rm @tmp@
..
.
.c synopsis for escape sequences with a long name
.de ESC[]
.  ds @arg1@ \&\$1
.  ds @arg2@ \&\$2
.  shift 2
.  IP "\f(CB\(rs\&\*[@arg1@][\fP\f(CI\&\*[@arg2@]\fP\f(CB]\&\$*\fP"
.  rm @arg1@
.  rm @arg2@
..
.
.c synopsis escape sequence with quoted argument
.  de ESCq
.  ds @tmp@ \&\$1
.  shift 1
.  IP "\f(CB\(rs\&\*[@tmp@]\(cq\fP\f(CI\h'-0.2m'\$*\/\fP\f(CB\(cq\fP"
.  rm @tmp@
..
.
.c synopsis for 2-escapes (special characters)
.de ESc
.  ds @tmp@ \$1
.  TP 14n
.  text \f(CB\(rs(\&\*[@tmp@]\ \ \ \fP\fR\(\*[@tmp@]\fP
.  shift 1
.  text \$*.
.  rm @tmp@
..
.
.c --------- registers ---------
.
.c synopsis for registers
.de REG
.  TP 10n
.  text \&\f(CR\(rsn[\fP\f(CB\$1\fP\f(CR]\fP
.  shift 1
.if \n[.$] \&\$*
..
.
.als register request
.
.c --------- warnings ---------
.
.als warning request
.
.c description of warnings
.de Warning
.  ne (2v + 1)
.  TP 12n
.  text \f(CB\$1\fP
.  text \f(CI\$2\fP
.  br
..
.
.ec
.
.\" --------------------------------------------------------------------
.\" Title
.\" --------------------------------------------------------------------
.
.TH GROFF @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
groff \- a short reference for the GNU roff language
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.I groff
stands for
.I GNU roff
and is the free implementation of the roff type-setting system.
See
.BR roff (@MAN7EXT@)
for a survey and the background of the groff system.
.LP
This document gives only short descriptions of the predefined roff
language elements as used in groff.
Both the classical features and the groff extensions are provided.
.LP
Historically, the
.I roff language
was called
.IR troff .
.I groff
is compatible with the classical system and provides proper extensions.
So in GNU, the terms
.IR roff ,
.IR troff ,
and
.I groff language
could be used as synonyms.
However
.I troff
slightly tends to refer more to the classical aspects, whereas
.I groff
emphasizes the GNU extensions, and
.I roff
is the general term for the language.
.LP
This file is only a short version of the complete documentation that is
found in the
.I groff
.BR info (1)
file, which contains more detailed, actual, and concise information.
.LP
The general syntax for writing groff documents is relatively easy, but
writing extensions to the roff language can be a bit harder.
.LP
The roff language is line-oriented.
There are only two kinds of lines, control lines and text lines.
The control lines start with a control character, by default a period
.''char .
or a single quote
.''char ' ;
all other lines are text lines.
.LP
.B Control lines
represent commands, optionally with arguments.
They have the following syntax.
The leading control character can be followed by a command name;
arguments, if any, are separated by blanks from the command name and
among themselves, for example,
.RS
.LP
\&\.command_name arg1 arg2
.RE
.LP
For indentation, any number of space or tab characters can be inserted
between the leading control character and the command name, but the control
character must be on the first position of the line.
.LP
.B Text lines
represent the parts that will be printed.
They can be modified by escape sequences, which are recognized by a
leading backslash
.'char \(rs .
These are in-line or even in-word formatting elements or functions.
Some of these take arguments separated by single quotes
.''char ' ,
others are regulated by a length encoding introduced by an open
parenthesis
.'char (
or enclosed in brackets
.'char [
and
.'char ] .
.LP
The roff language provides flexible instruments for writing language
extension, such as macros.
When interpreting macro definitions, the roff system enters a special
operating mode, called the
.BR "copy mode" .
.LP
The copy mode behavior can be quite tricky, but there are some rules
that ensure a safe usage.
.IP 1.
Printable backslashes must be denoted as
.esc e .
To be more precise,
.esc e
represents the current escape character.
To get a backslash glyph, use
.esc (rs .
.IP 2.
Double all backslashes.
.IP 3.
Begin all text lines with the special non-spacing character
.esc & .
.LP
This does not produce the most efficient code, but it should work as a
first measure.
For better strategies, see the groff info file and
.BR groff_tmac (@MAN5EXT@).
.LP
Reading roff source files is easier, just reduce all double backslashes
to a single one in all macro definitions.
.
.\" --------------------------------------------------------------------
.SH "GROFF ELEMENTS"
.\" --------------------------------------------------------------------
The roff language elements add formatting information to a text file.
The fundamental elements are predefined commands and variables that make
roff a full-blown programming language.
.LP
There are two kinds of roff commands, possibly with arguments.
.B Requests
are written on a line of their own starting with a dot
.'char .
or a
.''char ' ,
whereas
.B Escape sequences
are in-line functions and in-word formatting elements starting with a
backslash
.'char \(rs .
.LP
The user can define her own formatting commands using the
.request .de
request.  These commands are called
.BR macros ,
but they are used exactly like requests.  Macro packages are pre-defined 
sets of macros written in the groff language.
A user's possibilities to create escape sequences herself is very
limited, only special characters can be mapped.
.LP
The groff language provides several kinds of variables with
different interfaces.
There are pre-defined variables, but the user can define her own
variables as well.
.LP
.B String
variables store character sequences.
They are set with the
.request .ds
request and retrieved by the
.esc *
escape sequences.
.LP
.B Register
variables can store numerical values, numbers with a scale unit, and
occasionally string-like objects.
They are set with the
.request .nr
request and retrieved by the
.esc n
escape sequences.
.LP
.B Environments
allow the user to temporarily store global formatting parameters like
line length, font size, etc. for later reuse.
This is done by the
.request .ev
request.
.LP
.B Fonts
are identified either by a name or by an internal number.
The current font is chosen by the
.request .ft
request or by the
.esc f
escape sequences.
Each device has special fonts, but the following fonts are available for 
all devices.
.B R
is the standard font Roman.
.B B
is its
.B bold
counterpart.
The
.I italic
font is called
.B I
is everywhere available, but on text devices, it is displayed as an
underlined Roman font.
For the graphical output devices, there exist constant-width pendants of
these font,
.BR CR ,
.BR CI ,
and
.BR CB .
On text devices, all characters have a constant width anyway.
.LP
Moreover, there are some advanced roff elements.
A
.B diversion
stores information into a macro for later usage.
A
.B trap
is a positional condition like a certain number of lines from page top
or in a diversion or in the input.
Some action can be prescribed to be run automatically when the condition
is met.
.LP
More detailed information can be found in the groff info file.
.
.\" --------------------------------------------------------------------
.SH "CONTROL CHARACTERS"
.\" --------------------------------------------------------------------
There is a small set of characters that have a special controlling task
in certain conditions.
.TP
.character .
A dot is only special at the beginning of a line or after the
condition in the requests
.request .if ,
.request .ie ,
.request .el ,
and
.request .while .
There it is the control character that introduces a request (or macro).
The special behavior can be delayed by using the
.esc .
escape.
By using the 
.request .cc
request, the control character can be set to a different character,
making the dot
.'char .
a non-special character.
.IP ""
In all other positions, it just means a dot character.
In text paragraphs, it is advantageous to start each sentence at a line
of its own.
.TP
.character '
The single quote has two controlling tasks.  At the beginning of a line
and in the conditional requests it is the non-breaking control
character.
That means that it introduces a request like the dot, but with the
additional property that this request doesn't cause a linebreak.
By using the 
.request .c2
request, the non-break control character can be set to a different
character.
.IP ""
As a second task, it is the most commonly used argument separator in
some functional escape sequences (but any pair of characters not part
of the argument will work).
In all other positions, it denotes the single quote or apostrophe
character.
Groff provides a printable representation with the
.esc (cq
escape sequence.
.TP
.character \(dq
The double quote is used to enclose arguments in requests and macros.  In
the
.request .ds
and
.request .as
requests, a leading double quote in the argument will be stripped off,
making everything else afterwards the string to be defined (enabling leading
whitespace).
The escaped double quote
.esc \(dq
introduces a comment.
Otherwise, it is not special.
Groff provides a printable representation with the
.esc (dq
escape sequence.
.TP
.character \(rs
The backslash usually introduces an escape sequence (this can be
changed with the
.request ec
request).
A printed version of the escape character is the
.esc e
escape; a backslash glyph can be obtained by
.esc (rs .
.TP
.character (
The open parenthesis is only special in escape sequences when
introducing an escape name or argument consisting of exactly two
characters.
In groff, this behavior can be replaced by the \f(CB[]\fP construct.
.TP
.character [
The opening bracket is only special in groff escape sequences; there it
is used to introduce a long escape name or long escape argument.
Otherwise, it is non-special, e.g. in macro calls.
.TP
.character ]
The closing bracket is only special in groff escape sequences; there it
terminates a long escape name or long escape argument.
Otherwise, it is non-special.
.TP
\f(CIspace\fP
Space characters are only functional characters.  They separate the
arguments in requests or macros, and the words in text lines.
They are subject to groff's horizontal spacing calculations.
To get a defined space width, escape sequences like
.'char "\(rs\ "
(this is the escape character followed by a space),
.esc | ,
.esc ^ ,
or
.esc h
should be used.
.IP \f(CInewline\fP
In text paragraphs, newlines mostly behave like space characters.
Continuation lines can be specified by an escaped newline, i.e., by
specifying a backslash
.'char \(rs
as the last character of a line.
.IP \f(CItab\fP
If a tab character occurs during text the interpreter makes a horizontal 
jump to the next pre-defined tab position.
There is a sophisticated interface for handling tab positions.
.
.\" --------------------------------------------------------------------
.SH "NUMERICAL EXPRESSIONS"
.\" --------------------------------------------------------------------
A
.B numerical value
is a signed or unsigned integer or float with or without an appended
scale indicator.
A
.B scale indicator
is a one-character abbreviation for a unit of measurement.
A number followed by a scale indicator signifies a size value.
By default, numerical values do not have a scale indicator, i.e., they are
normal numbers.
.LP
The roff language defines the following scale indicators.
.LP
.na
.nh
.TS
center, tab(@);
LfCB Lw(4i).
c@Centimeter
i@Inch
P@Pica\ \(eq\ 1/6\ inch
p@Point\ \(eq\ 1/72\ inch
m@T{
Em\ \(eq\ \fRthe font size in points (width of letter `\f(CRm\fR')
T}
M@100th \fRof an \f(CREm
n@En\ \(eq\ Em/2
u@\fRBasic unit for actual output device
v@\fRVertical line space in basic units
z@T{
scaled point\ \(eq\ 1/\f(CIsizescale\fR of a point (defined in
font \fIDESC\fP file)
T}
.TE
.LP
.ad
.hy
.B Numerical expressions
are combinations of the numerical values defined above with
the arithmetical operators
.operator + ,
.operator \- ,
.operator * ,
.operator / ,
.operator %
.RI ( modulo ),
the comparative operators
.operator ==
(this is the same as
.operator = ),
.operator <= ,
.operator >= ,
.operator < ,
.operator > ,
the logical operators
.operator &
.RI ( and ),
.operator :
.RI ( or ),
.operator !
.RI ( not ),
and the parentheses
.operator (
and
.operator ) .
.LP
Moreover,
.I groff
added the following operators for numerical expressions:
.LP
.na
.nh
.TS
center, tab(@);
LfCB Lw(4i).
e1\f(CB>?\fPe2@The maximum of \f(CIe1\fP and \f(CIe2\fP.
e1\f(CB<?\fPe2@The minimum of \f(CIe1\fP and \f(CIe2\fP.
\f(CB(\fPc\f(CB;\fPe\f(CB)@T{
Evaluate \f(CIe\fP using \f(CIc\fP as the default scaling
indicator.
T}
.TE
.LP
.ad
.hy
For details see the groff info file.
.
.\" --------------------------------------------------------------------
.SH CONDITIONS
.\" --------------------------------------------------------------------
.B Conditions
occur in tests raised by the
.request .if ,
.request .ie ,
and the
.request .while
requests.
The following table characterizes the different types of conditions.
.LP
.na
.nh
.TS
center, tab(@);
LfCB Lw(4i).
\f(CIN\fP@T{
A numerical expression \f(CIN\fP yields true if its value
is\ \f(CR>0\fP.
T}
!\f(CIN\fP@T{
True if the value of \f(CIN\fP is\ \f(CR\(<=0\fP.
T}
\&'\f(CIs1\fP'\f(CIs2\fP'@T{
True if string\ \f(CIs1\fP is identical to string\ \f(CIs2\fP.
T}
!'\f(CIs1\fP'\f(CIs2\fP'@T{
True if string\ \f(CIs1\fP is not identical to string\ \f(CIs2\fP.
T}
c\f(CIch@T{
True if there is a character\ \f(CIch\fP available.
T}
d\f(CIname@T{
True if there is a string, macro, diversion, or request
called \f(CIname\fP.
T}
e@Current page number is even.
o@Current page number is odd.
n@Formatter is \fBnroff\fP.
r\f(CIreg@T{
True if there is a register named \f(CIreg\fP.
T}
t@Formatter is \fBtroff\fR.
.TE
.LP
.ad
.hy
.
.\" --------------------------------------------------------------------
.SH REQUESTS
.\" --------------------------------------------------------------------
This section provides a short reference for the predefined requests.
In groff, request and macro names can be arbitrarily long.
No bracketing or marking of long names is needed.
.LP
Most requests take one or more arguments.
The arguments are separated by space characters (no tabs!); there is no
inherent limit for their length or number.
An argument can be enclosed by a pair of double quotes: This is very handy
if an argument contains space characters, e.g.,
.argument "\(dqarg\ with\ space\(dq"
denotes a single argument.
.LP
Some requests have optional arguments with a different behaviour.
Not all of these details are outlined here.
Refer to the groff info file for all details.
.LP
In the following request specifications, most argument names were chosen
to be descriptive.
Only the following denotations need clarification.
.LP
.na
.nh
.TS
center, tab(@);
LfCI Lw(4i).
c@denotes a single character.
font@T{
a font either specified as a font name or a font number.
T}
anything@T{
all characters up to the end of the line or within \f(CB\(rs{\fP
and \f(CB\(rs}\fP.
T}
n@T{
is a numerical expression that evaluates to an integer value.
T}
N@T{
is an arbitrary numerical expression, signed or unsigned.
T}
\(+-N@T{
has three meanings depending on its sign, described below.
T}
.TE
.LP
.ad
.hy
If an expression defined as
.argument \(+-N
starts with a
.operator +
sign the resulting value of the expression will be added to an already
existing value inherent to the related request, e.g. adding to a number
register.
If the expression starts with a
.operator -
the value of the expression will be subtracted from the request value.
.LP
Without a sign,
.argument N
replaces the existing value directly.
To assign a negative number either prepend\ \c
.number 0
or enclose the negative number in parentheses.
.
.\" --------------------------------------------------------------------
.SS "REQUEST SHORT REFERENCE"
.\" --------------------------------------------------------------------
.PD 0
.
.REQ .
Empty line, ignored.  Useful for structuring documents.
.
.REQ .\(rs\(dq anything
Complete line is a comment.
.
.REQ .ab string
Print
.argument string
on standard error, exit program.
.
.REQ .ad
Begin line adjustment for output lines in current adjust mode.
.
.REQ .ad c
Start line adjustment in mode
.argument c
(\f(CIc\fP\f(CR\|\^\(eq\|l,r,b,n\fP).
.
.REQ .af register c
Assign format
.argument c
to
.argument register
(\f(CIc\fP\f(CR\|\^\(eq\|l,i,I,a,A\fP).
.
.REQ .aln alias register
Create alias name for
.argument register .
.
.REQ .als alias object
Create alias name for request, string, macro, or diversion
.argument object .
.
.REQ .am macro
Append to
.argument macro
until
.request ..
is called.
.
.REQ .am macro end
Append to
.argument macro
until
.request .end
is called.
.
.REQ .am1 macro
Same as
.request .am
but with compatibility mode switched off during macro expansion.
.
.REQ .am1 macro end
Same as
.request .am
but with compatibility mode switched off during macro expansion.
.
.REQ .as stringvar anything
Append
.argument anything
to
.argument stringvar .
.
.REQ .asciify diversion
Unformat ASCII characters, spaces, and some escape sequences in
.argument diversion .
.
.REQ .backtrace
Print a backtrace of the input on stderr.
.
.REQ .bd font N
Embolden
.argument font
by
.argterm N -1
units.
.
.REQ .bd S font N
Embolden Special Font
.argument S
when current font is
.argument font .
.
.REQ .blm
Unset the blank line macro.
.
.REQ .blm macro
Set the blank line macro to
.argument macro .
.
.REQ .box
End current diversion.
.
.REQ .box macro
Divert to
.argument macro ,
omitting a partially filled line.
.
.REQ .boxa
End current diversion.
.
.REQ .boxa macro
Divert and append to
.argument macro ,
omitting a partially filled line.
.
.REQ .bp
Eject current page and begin new page.
.
.REQ .bp \(+-N
Eject current page; next page number
.argument \(+-N .
.
.REQ .br
Line break.
.
.REQ .brp
Break and spread output line.
Same as
.esc p .
.
.REQ .break
Break out of a while loop.
.
.REQ .c2
Reset no-break control character to
.''char ' .
.
.REQ .c2 c
Set no-break control character to
.argument c .
.
.REQ .cc
Reset control character to
.'char . .
.
.REQ .cc c
Set control character to
.argument c .
.
.REQ .ce
Center the next input line.
.
.REQ .ce N
Center following
.argument N
input lines.
.
.REQ .cf filename
Copy contents of file
.argument filename
unprocessed to stdout or to the diversion.
.
.REQ .cflags mode c1 c2 ...
Treat characters
.argument c1 ,
.argument c2 ,
.argument ...
according to
.argument mode
number.
.
.REQ .ch trap N
Change
.argument trap
location
to
.argument N .
.
.REQ .char c anything
Define character
.argument c
to string
.argument anything .
.
.REQ .chop object
Chop the last character off macro, string, or diversion
.argument object .
.
.REQ .close stream
Close the
.argument stream .
.
.REQ .continue
Finish the current iteration of a while loop.
.
.REQ .cp
Enable compatibility mode.
.
.REQ .cp N
If
.I N
is zero disable compatibility mode, otherwise enable it.
.
.REQ .cs font N M
Set constant character width mode for
.argument font
to
.argterm N /36
ems with em
.argument M .
.
.REQ .cu N
Continuous underline in nroff, like
.request .ul
in troff.
.
.REQ .da
End current diversion.
.
.REQ .da macro
Divert and append to
.argument macro .
.
.REQ .de macro
Define or redefine
.argument macro
until
.request ..
is called.
.
.REQ .de macro end
Define or redefine
.argument macro
until
.request .end
is called.
.
.REQ .de1 macro
Same as
.request .de
but with compatibility mode switched off during macro expansion.
.
.REQ .de1 macro end
Same as
.request .de
but with compatibility mode switched off during macro expansion.
.
.REQ .dei macro
Define or redefine a macro whose name is contained in the string register
.argument macro
until
.request ..
is called.
.
.REQ .dei macro end
Define or redefine a macro indirectly.
.argument macro
and
.argument end
are string registers whose contents are interpolated for the macro name
and the end macro, respectively.
.
.REQ .di
End current diversion.
.
.REQ .di macro
Divert to
.argument macro .
.
.REQ .do name
Interpret
.request .name
with compatibility mode disabled.
.
.REQ .ds stringvar anything
Set
.argument stringvar
to
.argument anything .
.
.REQ .dt N trap
Set diversion trap to position
.argument N
(default scale indicator\ \c
.scaleindicator v ).
.
.REQ .ec
Reset escape character to
.'char \(rs .
.
.REQ .ec c
Set escape character to
.argument c .
.
.REQ .ecr
Restore escape character saved with
.request .ecs .
.
.REQ .ecs
Save current escape character.
.
.REQ .el anything
Else part for if-else (\c
.argument .ie )
request.
.
.REQ .em macro
The
.argument macro
will be run after the end of input.
.
.REQ .eo
Turn off escape character mechanism.
.
.REQ .ev
Switch to previous environment.
.
.REQ .ev env
Push down environment number or name
.argument env
and switch to it.
.
.REQ .evc env
Copy the contents of environment
.argument env
to the current environment.
No pushing or popping.
.
.REQ .ex
Exit from roff processing.
.
.REQ .fam
Return to previous font family.
.
.REQ .fam name
Set the current font family to
.argument name .
.
.REQ .fc
Disable field mechanism.
.
.REQ .fc a
Set field delimiter to
.argument a
and pad character to space.
.REQ .fc a b
Set field delimiter to
.argument a
and pad character to
.argument b .
.
.REQ .fi
Fill output lines.
.
.REQ .fl
Flush output buffer.
.
.REQ .fp n font
Mount
.argument font
on position
.argument n .
.
.REQ .fp n internal external
Mount font with long
.argument external
name to short
.argument internal
name on position
.argument n .
.
.REQ .fspecial font s1 s2...
When the current font is
.argument font ,
then the fonts
.argument s1 ,
.argument s2 ,
.argument ...
will be special.
.
.REQ .ft
Return to previous font.
Same as
.request \(rsfP .
.REQ .ft font
Change to font name or number
.argument font ;
same as
.esc[arg] f font
escape sequence.
.
.REQ .ftr font1 font2
Translate
.argument font1
to
.argument font2 .
.
.REQ .hc
Remove additional hyphenation indicator character.
.
.REQ .hc c
Set up additional hyphenation indicator character\ \c
.argument c .
.
.REQ .hcode c1 code1 c2 code2 ...
Set the hyphenation code of character
.argument c1
to
.argument code1 ,
that of
.argument c2
to
.argument code2 ,
etc.
.
.REQ .hla lang
Set the current hyphenation language to
.argument lang .
.
.REQ .hlm n
Set the maximum number of consecutive hyphenated lines to
.argument n .
.
.REQ .hpf file
Read hyphenation patterns from
.argument file .
.
.REQ .hw words
List of
.argument words
with exceptional hyphenation.
.
.REQ .hy N
Switch to hyphenation mode
.argument N .
.
.REQ .hym n
Set the hyphenation margin to
.argument n
(default scale indicator\ \c
.scaleindicator m ).
.
.REQ .hys n
Set the hyphenation space to
.argument n .
.
.REQ .ie cond anything
If
.argument cond
then
.argument anything
else goto
.request .el .
.
.REQ .if cond anything
If
.argument cond
then
.argument anything ;
otherwise do nothing.
.
.REQ .ig
Ignore text until
.request ..
is called.
.
.REQ .ig end
Ignore text until
.request .end .
.
.REQ .in
Change to previous indent value.
.
.REQ .in \(+-N
Change indent according to
.argument \(+-N
(default scale indicator\ \c
.scaleindicator m ).
.
.REQ .it N trap
Set an input-line count trap at position
.argument N .
.
.REQ .kern
Enable pairwise kerning.
.
.REQ .kern n
If
.argument n
is zero, disable pairwise kerning, otherwise enable it.
.
.REQ .lc
Remove leader repetition character.
.
.REQ .lc c
Set leader repetition character to\ \c
.argument c .
.
.REQ .length register anything
Write the length of the string
.argument anything
in
.argument register .
.
.REQ .linetabs
Enable line-tabs mode (i.e., calculate tab positions relative to output
line).
.
.REQ .linetabs n
If
.argument n
is zero, disable line-tabs mode, otherwise enable it.
.
.REQ .lf N file
Set input line number to
.argument N
and filename to
.argument file .
.
.REQ .lg N
Ligature mode on if
.argterm N >0 .
.
.REQ .ll
Change to previous line length.
.
.REQ .ll \(+-N
Set line length according to
.argument \(+-N
(default size
.scalednumber 6.5 i ,
default scale indicator\ \c
.scaleindicator m ).
.
.REQ .ls
Change to the previous value of additional intra-line skip.
.
.REQ .ls N
Set additional intra-line skip value to
.argument N ,
i.e.,
.argterm N -1
blank lines are inserted after each text output line.
.
.REQ .lt \(+-N
Length of title (default scale indicator\ \c
.scaleindicator m ).
.
.REQ .mc
Margin character off.
.
.REQ .mc c
Print character
.argument c
after each text line at actual distance from right margin.
.
.REQ .mc c N
Set margin character to
.argument c
and distance to
.argument N
from right margin (default scale indicator\ \c
.scaleindicator m ).
.
.REQ .mk register
Mark current vertical position in
.argument register .
.
.REQ .mso file
The same as the .so request except that
.I file
is searched in the tmac directories.
.
.REQ .na
No output-line adjusting.
.
.REQ .ne
Need a one-line vertical space.
.
.REQ .ne N
Need
.argument N
vertical space (default scale indicator\ \c
.scaleindicator v ).
.
.REQ .nf
No filling or adjusting of output-lines.
.
.REQ .nh
No hyphenation.
.
.REQ .nm
Number mode off.
.
.REQ .nm \(+-N M S I
In line number mode, set number, multiple, spacing, and indent.
.
.REQ .nn
Do not number next line.
.
.REQ .nn N
Do not number next
.argument N
lines.
.
.REQ .nop anything
Always execute
.argument anything .
.
.REQ .nr register \(+-N M
Define or modify
.argument register
using
.argument \(+-N
with auto-increment
.argument M .
.
.REQ .nroff
Make the built-in condition
.B n
true and
.B t
false.
.
.REQ .ns
Turn no-space mode on.
.
.REQ .nx filename
Next file.
.
.REQ .open stream filename
Open
.register filename
for writing and associate the stream named
.register stream
with it.
.
.REQ .opena stream filename
Like
.request .open
but append to it.
.
.REQ .os
Output vertical distance that was saved by the
.request .sv
request.
.
.REQ .pc
Reset page number character to\ \c
.'char % .
.
.REQ .pc c
Page number character.
.
.REQ .pi program
Pipe output to
.argument program
(nroff only).
.
.REQ .pl
Set page length to default
.scalednumber 11 i .
The current page length is stored in
.register .p .
.
.REQ .pl \(+-N
Change page length to
.argument \(+-N
(default scale indicator\ \c
.scaleindicator v ).
.
.REQ .pm
Print macro names and sizes (number of blocks of 128 bytes).
.
.REQ ".pm t"
Print only total of sizes of macros (number of 128 bytes blocks).
.
.REQ .pn \(+-N
Next page number
.argument N .
.
.REQ .pnr
Print the names and contents of all currently defined number registers
on stderr.
.
.REQ .po
Change to previous page offset.  The current page offset is available in
.register .o .
.
.REQ .po \(+-N
Page offset
.argument N .
.
.REQ .ps
Return to previous point-size.
.REQ .ps \(+-N
Point size; same as
.esc[arg] s \(+-N .
.
.REQ .psbb filename
Get the bounding box of a PostScript image
.argument filename .
.
.REQ .pso command
This behaves like the
.request .so
request except that input comes from the standard output of
.argument command .
.
.REQ .ptr
Print the names and positions of all traps (not including input line
traps and diversion traps) on stderr.
.
.REQ .rchar c1 c2...
Remove the definitions of characters
.argument c1 ,
.argument c2 ,
.argument ...
.
.REQ .rd prompt
Read insertion.
.
.REQ .return
Return from a macro.
.
.REQ .rj n
Right justify the next
.argument n
input lines.
.
.REQ .rm name
Remove request, macro, or string
.argument name .
.
.REQ .rn old new
Rename request, macro, or string
.argument old
to
.argument new .
.
.REQ .rnn reg1 reg2
Rename register
.argument reg1
to
.argument reg2 .
.
.REQ .rr register
Remove
.argument register .
.
.REQ .rs
Restore spacing; turn no-space mode off.
.
.REQ .rt \(+-N
Return
.I (upward only)
to marked vertical place (default scale indicator\ \c
.scaleindicator v ).
.
.REQ .shc
Reset soft hyphen character to
.esc (hy .
.
.REQ .shc c
Set the soft hyphen character to
.argument c .
.
.REQ .shift n
In a macro, shift the arguments by
.argument n \ \c
positions.
.
.REQ .so filename
Include source file.
.
.REQ .sp
Skip one line vertically.
.
.REQ .sp N
Space vertical distance
.argument N
up or down according to sign of
.argument N
(default scaling indicator\ \c
.scaleindicator v ).
.
.REQ .special s1 s2 ...
Fonts
.argument s1 ,
.argument s2 ,
etc. are special and will be searched for characters not in the current font.
.
.REQ .ss N
Space-character size set to
.argument N /12
of the spacewidth in the current font.
.
.REQ .ss N M
Space-character size set to
.argterm N /12
and sentence space size set to
.argterm M /12
of the spacewidth in the current font (\f(CR\(eq1/3 em\fP).
.
.REQ .sty n style
Associate
.argument style
with font position
.argument n .
.
.REQ .substring register n1 n2
Replace the string in
.argument register
with the substring defined by the indices
.argument n1
and
.argument n2 .
.
.REQ .sv
Save
.scalednumber 1 v
of vertical space.
.
.REQ .sv N
Save the vertical distance
.argument N
for later output with
.request .os
request.
.
.REQ .sy command-line
Execute program
.argument command-line .
.
.REQ ".ta T" N
Set tabs after every position that is a multiple of
.argument N
(default scaling indicator\ \c
.scaleindicator m ).
.REQ .ta n1 n2 ... nn \f(CBT\fP r1 r2 ... rn
Set tabs at positions
.argument n1 ,
.argument n2 ,
\&...,
.argument nn ,
then set tabs at
.argument nn + r1 ,
.argument nn + r2 ,
\&...,
.argument nn + rn ,
then at
.argument nn + rn + r1 ,
.argument nn + rn + r2 ,
\&...,
.argument nn + rn + rn ,
and so on.
.
.\".REQ .tar
.\"Restore internally saved tab positions.
.\".
.\".REQ .tas
.\"Save tab positions internally.
.
.REQ .tc
Remove tab repition character.
.REQ .tc c
Set tab repetition character to\ \c
.argument c .
.
.REQ .ti \(+-N
Temporary indent next line (default scaling indicator\ \c
.scaleindicator m ).
.
.REQ .tkf font s1 n1 s2 n2
Enable track kerning for
.argument font .
.
.REQ .tl \f(CB\(cq\fPleft\f(CB\(cq\fPcenter\f(CB\(cq\fPright\f(CB\(cq\fP
Three-part title.
.
.REQ .tm anything
Print
.argument anything
on terminal (UNIX standard message output).
.
.REQ .tm1 anything
Print
.argument anything
on terminal (UNIX standard message output), allowing leading whitespace if
.argument anything
starts with
.character \(dq
(which will be stripped off).
.
.REQ .tmc anything
Similar to
.request .tm1
without emitting a final newline.
.
.REQ .tr abcd....
Translate
.argument a
to
.argument b ,
.argument c
to
.argument d ,
etc. on output.
.
.REQ .trf filename
Transparently output the contents of file
.argument filename .
.
.REQ .trnt abcd....
This is the same as the
.request .tr
request except that the translations do not apply to text that is
transparently throughput into a diversion with
.esc ! .
.
.REQ .troff
Make the built-in condition
.B t
true and
.B n
false.
.
.REQ .uf font
Underline font set to
.argument font
(to be switched to by
.request .ul ).
.
.REQ .ul N
Underline (italicize in troff)
.argument N
input lines.
.
.REQ .unformat diversion
Unformat space characters and tabs, preserving font information in
.argument diversion .
.REQ .vpt n
Enable vertical position traps if
.argument n
is non-zero, disable them otherwise.
.
.REQ .vs
Change to previous vertical base line spacing.
.
.REQ .vs N
Set vertical base line spacing to
.argument N .
Default value is
.scalednumber 12 p .
.
.REQ .warn n
Set warnings code to
.argument n .
.
.REQ .wh N trap
Set location trap; negative means from page bottom.
.
.REQ .while cond anything
While condition
.argument cond
is true, accept
.argument anything
as input.
.
.REQ .write stream anything
Write
.argument anything
to the stream named
.argument stream .
.
.PD
.LP
Besides these standard groff requests, there might be further macro
calls.
They can originate from a macro package (see
.BR roff (@MAN7EXT@)
for an overview) or from a preprocessor.
.LP
Preprocessor macros are easy to be recognized.  They enclose their code
into a pair of characteristic macros.
.LP
.TS
box, center, tab (@);
c | c | c
CfCB | CfCB | CfCB.
preprocessor@start macro@ end macro
=
eqn@.PS@.PE
grap@.G1@.G2
grn@.GS@.GE
pic@.PS@.PE
refer@.R1@.R2
soelim@\fInone@\fInone
tbl@.TS@.TE
.TE
.LP
.
.\" --------------------------------------------------------------------
.SH "ESCAPE SEQUENCES"
.\" --------------------------------------------------------------------
.
Escape sequences are in-line language elements usually introduced by
a backslash
.'char \(rs
and followed by an escape name and sometimes by a required argument.
Input processing is continued directly after the escaped character or
the argument resp. without an intervening separation character.
So there must be a way to determine the end of the escape name and the end
of the argument.
.LP
This is done by enclosing names (escape name and arguments consisting of
a variable name) by a pair of brackets
.esc[] name
and constant arguments (number expressions and characters) by apostrophes
(ASCII 0x27) like
.IR \(cqconstant\(cq .
.LP
There are abbreviations for short names.
Two character escape names can be specified by an opening parenthesis like
.esc( xy
without a closing counterpart.
And all one-character names different from the special characters
.'char [
and
.'char (
can even be specified without a marker in the form
.esc \fP\f(CIc .
.LP
Constant arguments of length
.number 1
can omit the marker apostrophes, too, but there is no two-character
analogue.
.LP
While 1-character escape sequences are mainly used for in-line functions
and system related tasks, the 2-letter names following the
.esc( ""
construct are used for special characters predefined by the roff system.
Names with more than two characters
.esc[] name
mostly denote user defined named characters (see the
.request .char
request).
.
.\" --------------------------------------------------------------------
.SS "SINGLE CHARACTER ESCAPES"
.\" --------------------------------------------------------------------
.
.PD 0
.
.\" --------- comments ---------
.
.ESC \(dq
Beginning of a comment.
Everything up to the end of the line is ignored.
.
.ESC #
Everything up to and including the next newline is ignored.
This is interpreted in copy mode.
This is like
.esc \(dq
except the ignoring of the terminating newline.
.
.\" --------- strings ---------
.
.ESC * s
The string stored in the string variable with 1-character name
.argument s .
.
.ESC *( st
The string stored in the string variable with 2-character name
.argument st .
.
.ESC[] * stringvar
The string stored in the string variable with arbitrary length name
.argument stringvar .
.
.\" --------- macro arguments ---------
.
.ESC $0
The name by which the current macro was invoked.  The
.request .als
request can make a macro have more than one name.
.
.ESC $ x
Macro argument with 1-place number
.argument x ,
where
.argument x
is a digit between 1 and 9.
.
.ESC $( xy
Macro argument with 2-digit number
.argument xy .
.
.ESC[] $ nexp
Macro argument with number
.argument nexp ,
where
.argument nexp
is a numerical expression evaluating to an integer \(>=1.
.
.ESC $*
In a macro, the concatenation of all the arguments separated by spaces.
.
.ESC $@
In a macro, the concatenation of all the arguments with each surrounded
by double quotes, and separated by spaces.
.
.\" --------- escaped characters ---------
.
.ESC \(rs
reduces to a single backslash; useful to delay its interpretation as
escape character in copy mode.
For a printable backslash, use
.esc e .
.
.ESC \(cq
The acute accent \(aa; same as
.esc( aa .
Unescaped: apostrophe, right quotation mark, single quote (ASCII 0x27).
.
.ESC `
The grave accent \(ga; same as
.esc( ga .
Unescaped: left quote, backquote (ASCII 0x60).
.
.ESC \-
The \- sign in the current font.
.
.ESC .
An uninterpreted dot (period), even at start of line.
.
.ESC %
Default optional hyphenation character.
.
.ESC !
Transparent line indicator.
.
.ESC ? anything\fB?\fP
In a diversion, this will transparently embed
.argument anything
in the diversion.
.argument anything
is read in copy mode.
See also the escape sequences
.esc !
and
.esc ? .
.
.
.\" --------- spacing ---------
.
.ESC \& space
Unpaddable space-size space character (no line break).
.
.ESC 0
Digit width.
.
.ESC |
1/6\ em narrow space character; zero width in nroff.
.
.ESC ^
1/12\ em half-narrow space character; zero width in nroff.
.
.ESC &
Non-printable, zero width character.
.
.ESC )
Like
.esc &
except that it behaves like a character declared with the cflags
request to be transparent for the purposes of end of sentence
recognition.
.
.ESC /
Increases the width of the preceding character so that the spacing
between that character and the following character will be correct if
the following character is a roman character.
.
.ESC ,
Modifies the spacing of the following character so that the spacing
between that character and the preceding character will correct if the
preceding character is a roman character.
.
.ESC ~
Unbreakable space that stretches like a normal inter-word space when a
line is adjusted.
.
.ESC :
Inserts a zero-width break point (similar to
.esc %
but without a soft hyphen character).
.
.ESC \& newline
Ignored newline, for continuation lines.
.
.\" --------- structuring ---------
.
.ESC {
Begin conditional input.
.
.ESC }
End conditional input.
.
.\" --------- longer escape names ---------
.
.ESC ( st
The special character with 2-character name
.argument st ,
see section
.BR "SPECIAL CHARACTERS" .
.
.ESC[] \& name
The named character with arbitrary length name
.argument name .
.
.\" --------- alphabetical escapes ---------
.
.ESC a
Non-interpreted leader character.
.
.ESCq A anything
If
.argument anything
is acceptable as a name of a string, macro, diversion, register,
environment or font it expands to
.number 1 ,
and
.number 0
otherwise.
.
.ESCq b abc...
Bracket building function.
.
.ESCq B anything
If
.argument anything
is acceptable as a valid numeric expression it expands to
.number 1 ,
and
.number 0
otherwise.
.
.ESC c
Interrupt text processing.
.
.ESCq C char
The character called
.argument char ;
same as
.esc[] char ,
but compatible to other roff versions.
.
.ESC d
Forward (down) 1/2 em vertical unit (1/2 line in nroff).
.
.ESCq D charseq
Draw a graphical element defined by the characters in
.argument charseq ;
see groff info file for details.
.
.ESC e
Printable version of the current escape character.
.
.ESC E
Equivalent to an escape character, but is not interpreted in copy-mode.
.
.ESC f F
Change to font with 1-character name or 1-digit number
.argument F .
.
.ESC f( fo
Change to font with 2-characer name or 2-digit number
.argument fo .
.
.ESC[] f font
Change to font with arbitrary length name or number expression
.argument font .
.
.ESC[] g reg
Return format of register with name
.argument reg
suitable for
.request .af .
Alternative forms
.esc(arg g xy
and
.escarg g x .
.
.ESCq h N
Local horizontal motion; move right
.argument N
(left if negative).
.
.ESCq H N
Set height of current font to
.argument N .
.
.ESC[] k reg
Mark horizontal input place in register with arbitrary length name
.argument reg .
Alternative forms
.esc(arg k xy
and
.escarg k x .
.
.ESCq l Nc
Horizontal line drawing function (optionally using character
.argument c ).
.
.ESCq L Nc
Vertical line drawing function (optionally using character
.argument c ).
.
.ESC n r
The numerical value stored in the register variable with the 1-character
name
.argument r .
.
.ESC n( re
The numerical value stored in the register variable with the 2-character
name
.argument re .
.
.ESC[] n reg
The numerical value stored in the register variable with arbitrary
lenght name
.argument reg .
.
.ESCq N n
Typeset the character with code
.argument n
in the current font, no special fonts are searched.  Useful for adding
characters to a font using the
.request .char
request.
.
.ESCq o abc...
Overstrike characters
.argument a ,
.argument b ,
.argument c ,
etc.
.
.ESC p
Break and spread output line.
.
.ESC r
Reverse 1\ em vertical motion (reverse line in nroff).
.
.ESCq R name \(+-n
The same as
.request .nr
.argument name
.argument \(+-n .
.
.ESC[] s \(+-N
Set the point size to
.I N
scaled points.  Note the alternative forms
.BI \(rss \(+- [ N ]\c
,
.BI \(rss' \(+-N '\c
,
.BI \(rss \(+- ' N '\c
,
.esc(arg s \(+-xy ,
.BI \(rss \(+- ( xy\c
,
.escarg s \(+-x .
Same as
.request .ps
request.
.
.ESCq S N
Slant output
.argument N
degrees.
.
.ESC t
Non-interpreted horizontal tab.
.
.ESC u
Reverse (up) 1/2 em vertical motion (1/2 line in nroff).
.
.ESCq v N
Local vertical motion; move down
.argument N
(up if negative).
.
.ESC[] V env
The contents of the environment variable
.argument env .
Alternative forms
.esc(arg V xy
and
.escarg V x .
.
.ESCq w string
The width of the character sequence
.argument string .
.
.ESCq x N
Extra line-space function (negative before, positive after).
.
.ESCq X string
Output
.argument string
as device control function.
.
.ESC[] Y name
Output string variable or macro
.argument name
uninterpreted as device control function.
Alternative forms
.esc(arg Y xy
and
.escarg Y x .
.
.ESC z c
Print
.argument c
with zero width (without spacing).
.
.ESCq Z anything
Print
.argument anything
and then restore the horizontal and vertical position;
.argument anything
may not contain tabs or leaders.
.PD
.LP
The escape sequences
.esc e ,
.esc . ,
.esc \(dq ,
.esc $ ,
.esc * ,
.esc a ,
.esc n ,
.esc t ,
.esc g ,
and
.escarg \& newline
are interpreted in copy mode.
.LP
Escape sequences starting with
.esc (
or
.esc [
do not represent single character escape sequences, but introduce escape
names with two or more characters.
.LP
If a backslash is followed by a character that does not constitute a
defined escape sequence the backslash is silently ignored and the
character maps to itself.
.
.\" --------------------------------------------------------------------
.SS "SPECIAL CHARACTERS"
.\" --------------------------------------------------------------------
Common special characters are predefined by escape sequences of the form
.(esc \fP\f(CIxy
with characters
.argument x
and
.argument y .
Some of these exist in the usual font while most of them are only
available in the special font.  Below you'll find a selection of the most
important glyphs; a complete list can be found in
.BR groff_char (@MAN7EXT@).
.RS
.LP
.PD 0
.
.ESc bu Bullet sign
.ESc co Copyright
.ESc ct Cent
.ESc dd Double dagger
.ESc de Degree
.ESc dg Dagger
.ESc em Em-dash
.ESc hy Hyphen
.ESc rg Registered sign
.ESc sc Section sign
.ESc ul Underline character
.ESc == Identical
.ESc >= Larger or equal
.ESc <= Less or equal
.ESc != Not equal
.ESc -> Right arrow
.ESc <- Left arrow
.ESc +- Plus-minus sign
.PD
.RE
.
.\" --------------------------------------------------------------------
.SH REGISTERS
.\" --------------------------------------------------------------------
Registers are variables that store a value.
In groff, most registers store numerical values (see section
.B NUMERICAL EXPRESSIONS
above), but some can also hold a string value.
.LP
Each register is given a name.
Arbitrary registers can be defined and set with the request
.request .nr
.argument register .
.LP
The value stored in a register can be retrieved by the escape sequences
introduced by
.esc n .
.LP
Most useful are predefined registers.
In the following the notation
.argument name
is used to refer to a register called
.register name
to make clear that we speak about registers.
Please keep in mind that the
.esc en[]
decoration is not part of the register name.
.
.\" --------------------------------------------------------------------
.SS "READ-ONLY REGISTERS"
.\" --------------------------------------------------------------------
The following registers have predefined values that should not be
modified by the user (usually, registers starting with a dot a read-only).
Mostly, they provide information on the current settings or store results
from request calls.
.LP
.PD 0
.REG .$ Number of arguments in the current macro.
.REG .a
Post-line extra line-space most recently utilized using
.escarg x 'N' .
.REG .A
Set to
.number 1
in
.B troff
if option
.B \-A
is used; always
.number 1
in
.BR nroff .
.REG .c Current input line number.
.REG .C 1 if compatibility mode is in effect, 0 otherwise.
.REG .cdp
The depth of the last character added to the current environment.
It is positive if the character extends below the baseline.
.REG .ce
The number of lines remaining to be centered, as set by the
.request .ce
request.
.REG .cht
The height of the last character added to the current environment.
It is positive if the character extends above the baseline.
.REG .csk
The skew of the last character added to the current environment.
The skew of a character is how far to the right of the center of a character
the center of an accent over that character should be placed.
.REG .d
Current vertical place in current diversion; equal to register
.register nl .
.REG .ev The name or number of the current environment (string-valued).
.REG .f Current font number.
.REG .fam  The current font family (string-valued).
.REG .fp The number of the next free font position.
.REG .g
Always 1 in GNU troff.
Macros should use it to test if running under groff.
.REG .h Text base-line high-water mark on current page or diversion.
.REG .H Available horizontal resolution in basic units.
.REG .hla
The current hyphenation language as set by the
.B .hla
request.
.REG .hlc
The number of immediately preceding consecutive hyphenated lines.
.REG .hlm
The maximum allowed number of consecutive hyphenated lines, as set by
the
.request .hlm
request.
.REG .hy
The current hyphenation flags (as set by the
.request .hy
request).
.REG .hym
The current hyphenation margin (as set by the
.request .hym
request).
.REG .hys
The current hyphenation space (as set by the
.request .hys
request).
.REG .i Current ident.
.REG .in The indent that applies to the current output line.
.REG .int
Positive if last output line contains
.esc c .
.REG .kern
.number 1
if pairwise kerning is enabled,
.number 0
otherwise.
.REG .l Current line length.
.REG .lg
The current ligature mode (as set by the
.request .lg
request).
.REG .linetabs
The current line-tabs mode (as set by the
.request .linetabs
request).
.REG .ll The line length that applies to the current output line.
.REG .lt
The title length (as set by the
.request .lt
request).
.REG .n Length of text portion on previous output line.
.REG .ne
The amount of space that was needed in the last
.request .ne
request that caused a trap to be sprung.
Useful in conjunction with
.register .trunc .
.REG .ns
.number 1
if in no-space mode,
.number 0
otherwise.
.REG .o Current page offset.
.REG .p Current page length.
.REG .pn
The number of the next page: either the value set by a
.request .pn
request, or the number of the current page plus\ 1.
.REG .ps The current pointsize in scaled points.
.REG .psr The last-requested pointsize in scaled points.
.REG .rj
The number of lines to be right-justified as set by the rj request.
.REG .s Current point size as a decimal fraction.
.REG .sr
The last requested pointsize in points as a decimal fraction
(string-valued).
.REG .t Distance to the next trap.
.REG .T
Set to
.number 1
if option
.B \-T
is used.
.REG .tabs
A string representation of the current tab settings suitable for use as
an argument to the
.request .ta
request.
.REG .trunc
The amount of vertical space truncated by the most recently sprung
vertical position trap, or, if the trap was sprung by a
.request .ne
request, minus the amount of vertical motion produced by
.request .ne .
request.
In other words, at the point a trap is sprung, it represents the difference
of what the vertical position would have been but for the trap, and what the
vertical position actually is.
Useful in conjunction with the
.register .ne
register.
.REG .ss
The value of the parameters set by the first argument of the
.request .ss
request.
.REG .sss
The value of the parameters set by the second argument of the
.request .ss
request.
.REG .u Equal to 1 bin fill mode and 0 in nofill mode.
.REG .v Current vertical line spacing.
.REG .V Available vertical resolution in basic units.
.REG .vpt
.number 1
if vertical position traps are enabled,
.number 0
otherwise.
.REG .w Width of previous character.
.REG .warn
The sum of the number codes of the currently enabled warnings.
.REG .x The major version number.
.REG .y The minor version number.
.REG .Y The revision number of groff.
.REG .z Name of current diversion.
.PD
.
.\" --------------------------------------------------------------------
.SS "WRITABLE REGISTERS"
.\" --------------------------------------------------------------------
The following registers can be read and written by the user.
They have predefined default values, but these can be modified for
customizing a document.
.LP
.PD 0
.REG % Current page number.
.REG c. Current input line number.
.REG ct Character type (set by width function
.esc w ).
.REG dl Maximal width of last completed diversion.
.REG dn Height of last completed diversion.
.REG dw Current day of week (1-7).
.REG dy Current day of month (1-31).
.REG hp Current horizontal position at input line.
.REG llx
Lower left x-coordinate (in PostScript units) of a given PostScript
image (set by
.request .psbb ).
.REG lly
Lower left y-coordinate (in PostScript units) of a given PostScript
image (set by
.request .psbb ).
.REG ln Output line number.
.REG mo Current month (1-12).
.REG nl Vertical position of last printed text base-line.
.REG rsb Like
.register sb ,
but takes account of the heights and depths of characters.
.REG rst
Like
.register st ,
but takes account of the heights and depths of characters.
.REG sb
Depth of string below base line (generated by width function
.esc w ).
.REG skw
Right skip width from the center of the last character in the
.esc w
argument.
.REG slimit
If greater than 0, the maximum number of objects on the input stack.
If \(<=0 there is no limit, i.e., recursion can continue until virtual
memory is exhausted.
.REG ssc
The amount of horizontal space (possibly negative) that should be added
to the last character before a subscript (generated by width function
.esc w ).
.REG st
Height of string above base line (generated by width function
.esc w ).
.REG systat
The return value of the
.I system()
function executed by the last
.request .sy
request.
.REG urx
Upper right x-coordinate (in PostScript units) of a given PostScript
image (set by
.request .psbb ).
.REG ury
Upper right y-coordinate (in PostScript units) of a given PostScript
image (set by
.request .psbb ).
.REG year The current year (year 2000 compliant).
.REG yr
Current year minus 1900.  For Y2K compliance use register
.register year
instead.
.PD
.
.\" --------------------------------------------------------------------
.SH WARNINGS
.\" --------------------------------------------------------------------
Each warning generated by groff is identified by a name and a code
number.  The codes are powers of 2 to allow bit-encoding with a single
integer.  There are also names that can be used to refer to groups of
warnings.
.LP
The name associated with a warning is used by the
.option \-w
and
.option \-W
options;
the number code is used by the
.request .warn
request and by the
.esc[arg] n warn
register.
.LP
.PD 0
.Warning all group
All warnings except
.warning di ,
.warning mac
and
.warning reg .
Intended to cover all warnings with traditional macro packages.
.Warning break 4
In fill mode, lines which could not be broken so that their length was
less than the line length.  This is enabled by default.
.Warning char 1
Non-existent characters.  This is enabled by default.
.Warning delim 8
Missing or mismatched closing delimiters.
.Warning di 256
Use of
.request .di
or
.request .da
without an argument when there is no current diversion.
.Warning el 16
Use of the
.request .el
request with no matching
.request .ie
request.
.Warning escape 32768
Unrecognized escape sequence.  Then the escape character is ignored.
.Warning font 131072
Non-existent fonts.  This is enabled by default.
.Warning ig 262144
Illegal escapes in text ignored with the
.request \.ig
request.  These are conditions that are errors when they occur outside
of ignored text.
.Warning mac 512
Use of undefined strings, macros, and diversions.  Automatically handled
as empty.  Usually, only one warning per name.
.Warning missing 8192
Request that is missing non-optional arguments.
.Warning input 16384
Illegal input character.
.Warning number 2
Invalid numeric expressions.  This is enabled by default.
.Warning range 64
Out of range arguments.
.Warning reg 1024
Use of undefined number register.  Automatically defined as having
value 0.  Usually, only one warning per name.
.Warning right-brace 4096
Use of
.esc }
where a number was expected.
.Warning scale 32
Meaningless scaling indicators.
.Warning space 65536
Missing space between a request or macro and its argument.  Then no
macro is automatically defined.  This is enabled by default.  This
warning will never occur in compatibility mode.
.Warning syntax 128
Dubious syntax in numeric expressions.
.Warning tab 2048
Inappropriate use of a tab character (either in an unquoted macro
argument or where a number was expected).
.Warning w group
All warnings.
.PD
.LP
.TS
tab(@), box, expand;
c c c | c  c  c | c  c  c
R RI CB | R RI CB | R RI CB.
Bit@Code@Warning@Bit@Code@Warning@Bit@Code@Warning
_
0@1@char@8@256@di@16@65536@space
1@2@number@9@512@mac@17@131072@font
2@4@break@10@1024@reg@18@262144@ig
3@8@delim@11@2048@tab
4@16@el@12@4096@right-brace
5@32@scale@13@8192@missing
6@64@range@14@16384@input
7@128@syntax@15@32768@escape
.TE
.LP
.
.\" --------------------------------------------------------------------
.SH COMPATIBILITY
.\" --------------------------------------------------------------------
.I groff
provides a
.B compatibility mode
that allows to process roff code written for classical
.troff
or for other implementations of roff in a consistent way.
.LP
Compatibility mode can be turned on with the
.option \-C
command line option, and turned on or off with the
.request .cp
request.  The number register
.esc(arg n .C
is
.number 1
if compatibility mode is on,
.number 0
otherwise.
.LP
This became necessary because the GNU concept for long names causes some
incompatibilities.
.I Classical troff
will interpret
.IP
.B
\&.dsabcd
.LP
as defining a string
.B ab
with contents
.BR cd .
Normally,
.I groff
will interpret this as a call of a macro named
.request dsabcd .
.LP
Also
.I classical troff
will interpret
.esc *[
or
.esc n[
as references to a string or number register called
.register [ .
In
.I GNU native
.IR mode ,
however, this will normally be interpreted as the start of a long name.
.LP
In
.I compatibility
.IR mode ,
groff will interpret these things in the traditional way, but long names
are not recognized.
.LP
On the other hand, groff in
.I GNU native mode
does not allow to use the escape sequences
.esc e ,
.esc | ,
.esc ^ ,
.esc & ,
.esc } ,
.esc { ,
.esc "\ " (space),
.esc ' ,
.esc ` ,
.esc - ,
.esc _ ,
.esc ! ,
.esc % ,
and
.esc c
in names of strings, macros, diversions, number registers, fonts or
environments, whereas
.I classical troff
does.  The
.esc A
escape sequence can be helpful in avoiding these escape sequences in
names.
.LP
Fractional pointsizes cause one noteworthy incompatibility.
In
.I classical
.IR troff ,
the
.request .ps
request ignores scale indicators and so
.RS
.LP
.B .ps\ 10u
.RE
.LP
will set the pointsize to 10 points, whereas in groff native mode the
pointsize will be set to 10 scaled points.
.LP
In
.I groff
mode, there is a fundamental difference between unformatted input
characters, and formatted output characters.
Everything that affects how an output character will be output is stored
with the character; once an output character has been constructed it is
unaffected by any subsequent requests that are executed, including the
.request .bd ,
.request .cs ,
.request .tkf ,
.request .tr ,
or
.request .fp
requests.
.LP
Normally output characters are constructed from input characters at the
moment immediately before the character is added to the current output
line.
Macros, diversions and strings are all, in fact, the same type of object;
they contain lists of input characters and output characters in any
combination.
.LP
An output character does not behave like an input character for the
purposes of macro processing; it does not inherit any of the special
properties that the input character from which it was constructed might
have had.
The following example will make things clearer.
.LP
.RS
.nf
.ft B
\&.di x
\(rs\(rs\(rs\(rs
\&.br
\&.di
\&.x
.ft
.fi
.RE
.LP
In
.I GNU mode
this will be printed as
.esc \(rs .
So each pair of input backslashes
.'char \(rs\(rs
is turned into a single output backslash
.'char \(rs
and the resulting output backslashes are not interpreted as escape
characters when they are reread.
.LP
.I Classical troff
would interpret them as escape characters when they were reread and
would end up printing a single backslash
.'char \(rs .
.LP
The correct way to get a printable
.'char \(rs
is to use the
.esc e
escape sequence.  This will always print a single instance of the
current escape character, regardless of whether or not it is used in a
diversion.  It will also work in both GNU mode and compatibility mode.
.LP
To store an escape sequence in a diversion that will be interpreted when
the diversion is reread, either the traditional
.esc !
transparent output facility or the
new
.esc ?
escape sequence can be used.
.
.\" --------------------------------------------------------------------
.SH BUGS
.\" --------------------------------------------------------------------
At the moment, the documentation of the groff system is in a state of
change and evolution.  It is possible that there are small
inconsistencies between different documents temporarily.
.LP
The
.B WARNINGS
section belongs to
.BR troff (@MAN1EXT@).
.
.\" --------------------------------------------------------------------
.SH AUTHOR
.\" --------------------------------------------------------------------
This document is part of groff, the GNU roff distribution.  It was
written by Bernd Warken <bwarken@mayn.de>.
.LP
It is distributed under the terms of the FDL (GNU Free Documentation
License) version 1.1 or later.  You should have received a copy of the
FDL on your system, it is also available on-line under
.RS
.LP
.IR http://www.gnu.org/copyleft/fdl.html .
.RE
.LP
Formerly, the extensions of the groff language were kept in the manual
page
.BR troff (@MAN1EXT@).
This document contains the essential parts of that documentation, but
the gory details are found in the groff info file.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
The main source of information for the groff language is the
.B groff
.BR info (1)
file.
.LP
For a survey of roff and the groff system and further documentation
pointers see
.BR roff (@MAN7EXT@).
.LP
The formatter programs are described in
.BR groff (@MAN1EXT@)
and
.BR troff (@MAN1EXT@);
a complete of all predefined glyph names can be found in
.BR groff_char (@MAN7EXT@).
.LP
The classical
.I troff
documentation is available on-line at
.RS
.LP
.I http://cm.bell-labs.com/cm/cs/cstr.html
.RE
and
.RS
.IR http://www.kohala.com/start/troff/ .
