/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_telephony_callevent_h
#define mozilla_dom_telephony_callevent_h

#include "mozilla/dom/Event.h"
#include "mozilla/dom/telephony/TelephonyCommon.h"

namespace mozilla {
namespace dom {

struct CallEventInit;

class CallEvent MOZ_FINAL : public Event
{
  nsRefPtr<TelephonyCall> mCall;

public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(CallEvent, Event)
  NS_FORWARD_TO_EVENT

  virtual JSObject*
  WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  // WebIDL
  static already_AddRefed<CallEvent>
  Constructor(const GlobalObject& aGlobal, const nsAString& aType,
              const CallEventInit& aOptions, ErrorResult& aRv);

  already_AddRefed<TelephonyCall>
  GetCall() const;

  static already_AddRefed<CallEvent>
  Create(EventTarget* aOwner, const nsAString& aType, TelephonyCall* aCall,
         bool aCanBubble, bool aCancelable);

private:
  CallEvent(EventTarget* aOwner,
            nsPresContext* aPresContext,
            WidgetEvent* aEvent)
    : Event(aOwner, aPresContext, aEvent)
  {
    SetIsDOMBinding();
  }

  virtual ~CallEvent()
  { }
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_telephony_callevent_h
