/**
 * This file defines all virtual keycodes for synthesizeNativeKey() of
 * EventUtils.js and nsIDOMWindowUtils.sendNativeKeyEvent().
 * These values are defined in each platform's SDK or documents.
 */

// Windows

const WIN_VK_LBUTTON                    = 0x01;
const WIN_VK_RBUTTON                    = 0x02;
const WIN_VK_CANCEL                     = 0x03;
const WIN_VK_MBUTTON                    = 0x04;
const WIN_VK_XBUTTON1                   = 0x05;
const WIN_VK_XBUTTON2                   = 0x06;
const WIN_VK_BACK                       = 0x08;
const WIN_VK_TAB                        = 0x09;
const WIN_VK_CLEAR                      = 0x0C;
const WIN_VK_RETURN                     = 0x0D;
const WIN_VK_SHIFT                      = 0x10;
const WIN_VK_CONTROL                    = 0x11;
const WIN_VK_MENU                       = 0x12;
const WIN_VK_PAUSE                      = 0x13;
const WIN_VK_CAPITAL                    = 0x14;
const WIN_VK_KANA                       = 0x15;
const WIN_VK_HANGUEL                    = 0x15;
const WIN_VK_HANGUL                     = 0x15;
const WIN_VK_JUNJA                      = 0x17;
const WIN_VK_FINAL                      = 0x18;
const WIN_VK_HANJA                      = 0x19;
const WIN_VK_KANJI                      = 0x19;
const WIN_VK_ESCAPE                     = 0x1B;
const WIN_VK_CONVERT                    = 0x1C;
const WIN_VK_NONCONVERT                 = 0x1D;
const WIN_VK_ACCEPT                     = 0x1E;
const WIN_VK_MODECHANGE                 = 0x1F;
const WIN_VK_SPACE                      = 0x20;
const WIN_VK_PRIOR                      = 0x21;
const WIN_VK_NEXT                       = 0x22;
const WIN_VK_END                        = 0x23;
const WIN_VK_HOME                       = 0x24;
const WIN_VK_LEFT                       = 0x25;
const WIN_VK_UP                         = 0x26;
const WIN_VK_RIGHT                      = 0x27;
const WIN_VK_DOWN                       = 0x28;
const WIN_VK_SELECT                     = 0x29;
const WIN_VK_PRINT                      = 0x2A;
const WIN_VK_EXECUTE                    = 0x2B;
const WIN_VK_SNAPSHOT                   = 0x2C;
const WIN_VK_INSERT                     = 0x2D;
const WIN_VK_DELETE                     = 0x2E;
const WIN_VK_HELP                       = 0x2F;
const WIN_VK_0                          = 0x30;
const WIN_VK_1                          = 0x31;
const WIN_VK_2                          = 0x32;
const WIN_VK_3                          = 0x33;
const WIN_VK_4                          = 0x34;
const WIN_VK_5                          = 0x35;
const WIN_VK_6                          = 0x36;
const WIN_VK_7                          = 0x37;
const WIN_VK_8                          = 0x38;
const WIN_VK_9                          = 0x39;
const WIN_VK_A                          = 0x41;
const WIN_VK_B                          = 0x42;
const WIN_VK_C                          = 0x43;
const WIN_VK_D                          = 0x44;
const WIN_VK_E                          = 0x45;
const WIN_VK_F                          = 0x46;
const WIN_VK_G                          = 0x47;
const WIN_VK_H                          = 0x48;
const WIN_VK_I                          = 0x49;
const WIN_VK_J                          = 0x4A;
const WIN_VK_K                          = 0x4B;
const WIN_VK_L                          = 0x4C;
const WIN_VK_M                          = 0x4D;
const WIN_VK_N                          = 0x4E;
const WIN_VK_O                          = 0x4F;
const WIN_VK_P                          = 0x50;
const WIN_VK_Q                          = 0x51;
const WIN_VK_R                          = 0x52;
const WIN_VK_S                          = 0x53;
const WIN_VK_T                          = 0x54;
const WIN_VK_U                          = 0x55;
const WIN_VK_V                          = 0x56;
const WIN_VK_W                          = 0x57;
const WIN_VK_X                          = 0x58;
const WIN_VK_Y                          = 0x59;
const WIN_VK_Z                          = 0x5A;
const WIN_VK_LWIN                       = 0x5B;
const WIN_VK_RWIN                       = 0x5C;
const WIN_VK_APPS                       = 0x5D;
const WIN_VK_SLEEP                      = 0x5F;
const WIN_VK_NUMPAD0                    = 0x60;
const WIN_VK_NUMPAD1                    = 0x61;
const WIN_VK_NUMPAD2                    = 0x62;
const WIN_VK_NUMPAD3                    = 0x63;
const WIN_VK_NUMPAD4                    = 0x64;
const WIN_VK_NUMPAD5                    = 0x65;
const WIN_VK_NUMPAD6                    = 0x66;
const WIN_VK_NUMPAD7                    = 0x67;
const WIN_VK_NUMPAD8                    = 0x68;
const WIN_VK_NUMPAD9                    = 0x69;
const WIN_VK_MULTIPLY                   = 0x6A;
const WIN_VK_ADD                        = 0x6B;
const WIN_VK_SEPARATOR                  = 0x6C;
const WIN_VK_OEM_NEC_SEPARATE           = 0x6C;
const WIN_VK_SUBTRACT                   = 0x6D;
const WIN_VK_DECIMAL                    = 0x6E;
const WIN_VK_DIVIDE                     = 0x6F;
const WIN_VK_F1                         = 0x70;
const WIN_VK_F2                         = 0x71;
const WIN_VK_F3                         = 0x72;
const WIN_VK_F4                         = 0x73;
const WIN_VK_F5                         = 0x74;
const WIN_VK_F6                         = 0x75;
const WIN_VK_F7                         = 0x76;
const WIN_VK_F8                         = 0x77;
const WIN_VK_F9                         = 0x78;
const WIN_VK_F10                        = 0x79;
const WIN_VK_F11                        = 0x7A;
const WIN_VK_F12                        = 0x7B;
const WIN_VK_F13                        = 0x7C;
const WIN_VK_F14                        = 0x7D;
const WIN_VK_F15                        = 0x7E;
const WIN_VK_F16                        = 0x7F;
const WIN_VK_F17                        = 0x80;
const WIN_VK_F18                        = 0x81;
const WIN_VK_F19                        = 0x82;
const WIN_VK_F20                        = 0x83;
const WIN_VK_F21                        = 0x84;
const WIN_VK_F22                        = 0x85;
const WIN_VK_F23                        = 0x86;
const WIN_VK_F24                        = 0x87;
const WIN_VK_NUMLOCK                    = 0x90;
const WIN_VK_SCROLL                     = 0x91;
const WIN_VK_OEM_FJ_JISHO               = 0x92;
const WIN_VK_OEM_NEC_EQUAL              = 0x92;
const WIN_VK_OEM_FJ_MASSHOU             = 0x93;
const WIN_VK_OEM_FJ_TOUROKU             = 0x94;
const WIN_VK_OEM_FJ_LOYA                = 0x95;
const WIN_VK_OEM_FJ_ROYA                = 0x96;
const WIN_VK_LSHIFT                     = 0xA0;
const WIN_VK_RSHIFT                     = 0xA1;
const WIN_VK_LCONTROL                   = 0xA2;
const WIN_VK_RCONTROL                   = 0xA3;
const WIN_VK_LMENU                      = 0xA4;
const WIN_VK_RMENU                      = 0xA5;
const WIN_VK_BROWSER_BACK               = 0xA6;
const WIN_VK_BROWSER_FORWARD            = 0xA7;
const WIN_VK_BROWSER_REFRESH            = 0xA8;
const WIN_VK_BROWSER_STOP               = 0xA9;
const WIN_VK_BROWSER_SEARCH             = 0xAA;
const WIN_VK_BROWSER_FAVORITES          = 0xAB;
const WIN_VK_BROWSER_HOME               = 0xAC;
const WIN_VK_VOLUME_MUTE                = 0xAD;
const WIN_VK_VOLUME_DOWN                = 0xAE;
const WIN_VK_VOLUME_UP                  = 0xAF;
const WIN_VK_MEDIA_NEXT_TRACK           = 0xB0;
const WIN_VK_OEM_FJ_000                 = 0xB0;
const WIN_VK_MEDIA_PREV_TRACK           = 0xB1;
const WIN_VK_OEM_FJ_EUQAL               = 0xB1;
const WIN_VK_MEDIA_STOP                 = 0xB2;
const WIN_VK_MEDIA_PLAY_PAUSE           = 0xB3;
const WIN_VK_OEM_FJ_00                  = 0xB3;
const WIN_VK_LAUNCH_MAIL                = 0xB4;
const WIN_VK_LAUNCH_MEDIA_SELECT        = 0xB5;
const WIN_VK_LAUNCH_APP1                = 0xB6;
const WIN_VK_LAUNCH_APP2                = 0xB7;
const WIN_VK_OEM_1                      = 0xBA;
const WIN_VK_OEM_PLUS                   = 0xBB;
const WIN_VK_OEM_COMMA                  = 0xBC;
const WIN_VK_OEM_MINUS                  = 0xBD;
const WIN_VK_OEM_PERIOD                 = 0xBE;
const WIN_VK_OEM_2                      = 0xBF;
const WIN_VK_OEM_3                      = 0xC0;
const WIN_VK_ABNT_C1                    = 0xC1;
const WIN_VK_ABNT_C2                    = 0xC2;
const WIN_VK_OEM_4                      = 0xDB;
const WIN_VK_OEM_5                      = 0xDC;
const WIN_VK_OEM_6                      = 0xDD;
const WIN_VK_OEM_7                      = 0xDE;
const WIN_VK_OEM_8                      = 0xDF;
const WIN_VK_OEM_NEC_DP1                = 0xE0;
const WIN_VK_OEM_AX                     = 0xE1;
const WIN_VK_OEM_NEC_DP2                = 0xE1;
const WIN_VK_OEM_102                    = 0xE2;
const WIN_VK_OEM_NEC_DP3                = 0xE2;
const WIN_VK_ICO_HELP                   = 0xE3;
const WIN_VK_OEM_NEC_DP4                = 0xE3;
const WIN_VK_ICO_00                     = 0xE4;
const WIN_VK_PROCESSKEY                 = 0xE5;
const WIN_VK_ICO_CLEAR                  = 0xE6;
const WIN_VK_PACKET                     = 0xE7;
const WIN_VK_ERICSSON_BASE              = 0xE8;
const WIN_VK_OEM_RESET                  = 0xE9;
const WIN_VK_OEM_JUMP                   = 0xEA;
const WIN_VK_OEM_PA1                    = 0xEB;
const WIN_VK_OEM_PA2                    = 0xEC;
const WIN_VK_OEM_PA3                    = 0xED;
const WIN_VK_OEM_WSCTRL                 = 0xEE;
const WIN_VK_OEM_CUSEL                  = 0xEF;
const WIN_VK_OEM_ATTN                   = 0xF0;
const WIN_VK_OEM_FINISH                 = 0xF1;
const WIN_VK_OEM_COPY                   = 0xF2;
const WIN_VK_OEM_AUTO                   = 0xF3;
const WIN_VK_OEM_ENLW                   = 0xF4;
const WIN_VK_OEM_BACKTAB                = 0xF5;
const WIN_VK_ATTN                       = 0xF6;
const WIN_VK_CRSEL                      = 0xF7;
const WIN_VK_EXSEL                      = 0xF8;
const WIN_VK_EREOF                      = 0xF9;
const WIN_VK_PLAY                       = 0xFA;
const WIN_VK_ZOOM                       = 0xFB;
const WIN_VK_NONAME                     = 0xFC;
const WIN_VK_PA1                        = 0xFD;
const WIN_VK_OEM_CLEAR                  = 0xFE;

// Mac

const MAC_VK_ANSI_A                     = 0x00;
const MAC_VK_ANSI_S                     = 0x01;
const MAC_VK_ANSI_D                     = 0x02;
const MAC_VK_ANSI_F                     = 0x03;
const MAC_VK_ANSI_H                     = 0x04;
const MAC_VK_ANSI_G                     = 0x05;
const MAC_VK_ANSI_Z                     = 0x06;
const MAC_VK_ANSI_X                     = 0x07;
const MAC_VK_ANSI_C                     = 0x08;
const MAC_VK_ANSI_V                     = 0x09;
const MAC_VK_ISO_Section                = 0x0A;
const MAC_VK_ANSI_B                     = 0x0B;
const MAC_VK_ANSI_Q                     = 0x0C;
const MAC_VK_ANSI_W                     = 0x0D;
const MAC_VK_ANSI_E                     = 0x0E;
const MAC_VK_ANSI_R                     = 0x0F;
const MAC_VK_ANSI_Y                     = 0x10;
const MAC_VK_ANSI_T                     = 0x11;
const MAC_VK_ANSI_1                     = 0x12;
const MAC_VK_ANSI_2                     = 0x13;
const MAC_VK_ANSI_3                     = 0x14;
const MAC_VK_ANSI_4                     = 0x15;
const MAC_VK_ANSI_6                     = 0x16;
const MAC_VK_ANSI_5                     = 0x17;
const MAC_VK_ANSI_Equal                 = 0x18;
const MAC_VK_ANSI_9                     = 0x19;
const MAC_VK_ANSI_7                     = 0x1A;
const MAC_VK_ANSI_Minus                 = 0x1B;
const MAC_VK_ANSI_8                     = 0x1C;
const MAC_VK_ANSI_0                     = 0x1D;
const MAC_VK_ANSI_RightBracket          = 0x1E;
const MAC_VK_ANSI_O                     = 0x1F;
const MAC_VK_ANSI_U                     = 0x20;
const MAC_VK_ANSI_LeftBracket           = 0x21;
const MAC_VK_ANSI_I                     = 0x22;
const MAC_VK_ANSI_P                     = 0x23;
const MAC_VK_Return                     = 0x24;
const MAC_VK_ANSI_L                     = 0x25;
const MAC_VK_ANSI_J                     = 0x26;
const MAC_VK_ANSI_Quote                 = 0x27;
const MAC_VK_ANSI_K                     = 0x28;
const MAC_VK_ANSI_Semicolon             = 0x29;
const MAC_VK_ANSI_Backslash             = 0x2A;
const MAC_VK_ANSI_Comma                 = 0x2B;
const MAC_VK_ANSI_Slash                 = 0x2C;
const MAC_VK_ANSI_N                     = 0x2D;
const MAC_VK_ANSI_M                     = 0x2E;
const MAC_VK_ANSI_Period                = 0x2F;
const MAC_VK_Tab                        = 0x30;
const MAC_VK_Space                      = 0x31;
const MAC_VK_ANSI_Grave                 = 0x32;
const MAC_VK_Delete                     = 0x33;
const MAC_VK_PC_Backspace               = 0x33;
const MAC_VK_Powerbook_KeypadEnter      = 0x34;
const MAC_VK_Escape                     = 0x35;
const MAC_VK_RightCommand               = 0x36;
const MAC_VK_Command                    = 0x37;
const MAC_VK_Shift                      = 0x38;
const MAC_VK_CapsLock                   = 0x39;
const MAC_VK_Option                     = 0x3A;
const MAC_VK_Control                    = 0x3B;
const MAC_VK_RightShift                 = 0x3C;
const MAC_VK_RightOption                = 0x3D;
const MAC_VK_RightControl               = 0x3E;
const MAC_VK_Function                   = 0x3F;
const MAC_VK_F17                        = 0x40;
const MAC_VK_ANSI_KeypadDecimal         = 0x41;
const MAC_VK_ANSI_KeypadMultiply        = 0x43;
const MAC_VK_ANSI_KeypadPlus            = 0x45;
const MAC_VK_ANSI_KeypadClear           = 0x47;
const MAC_VK_VolumeUp                   = 0x48;
const MAC_VK_VolumeDown                 = 0x49;
const MAC_VK_Mute                       = 0x4A;
const MAC_VK_ANSI_KeypadDivide          = 0x4B;
const MAC_VK_ANSI_KeypadEnter           = 0x4C;
const MAC_VK_ANSI_KeypadMinus           = 0x4E;
const MAC_VK_F18                        = 0x4F;
const MAC_VK_F19                        = 0x50;
const MAC_VK_ANSI_KeypadEquals          = 0x51;
const MAC_VK_ANSI_Keypad0               = 0x52;
const MAC_VK_ANSI_Keypad1               = 0x53;
const MAC_VK_ANSI_Keypad2               = 0x54;
const MAC_VK_ANSI_Keypad3               = 0x55;
const MAC_VK_ANSI_Keypad4               = 0x56;
const MAC_VK_ANSI_Keypad5               = 0x57;
const MAC_VK_ANSI_Keypad6               = 0x58;
const MAC_VK_ANSI_Keypad7               = 0x59;
const MAC_VK_F20                        = 0x5A;
const MAC_VK_ANSI_Keypad8               = 0x5B;
const MAC_VK_ANSI_Keypad9               = 0x5C;
const MAC_VK_JIS_Yen                    = 0x5D;
const MAC_VK_JIS_Underscore             = 0x5E;
const MAC_VK_JIS_KeypadComma            = 0x5F;
const MAC_VK_F5                         = 0x60;
const MAC_VK_F6                         = 0x61;
const MAC_VK_F7                         = 0x62;
const MAC_VK_F3                         = 0x63;
const MAC_VK_F8                         = 0x64;
const MAC_VK_F9                         = 0x65;
const MAC_VK_JIS_Eisu                   = 0x66;
const MAC_VK_F11                        = 0x67;
const MAC_VK_JIS_Kana                   = 0x68;
const MAC_VK_F13                        = 0x69;
const MAC_VK_PC_PrintScreen             = 0x69;
const MAC_VK_F16                        = 0x6A;
const MAC_VK_PC_ScrollLock              = 0x6A;
const MAC_VK_F14                        = 0x6B;
const MAC_VK_PC_Pause                   = 0x6B;
const MAC_VK_F10                        = 0x6D;
const MAC_VK_PC_ContextMenu             = 0x6E;
const MAC_VK_F12                        = 0x6F;
const MAC_VK_F15                        = 0x71;
const MAC_VK_Help                       = 0x72;
const MAC_VK_PC_Insert                  = 0x72;
const MAC_VK_Home                       = 0x73;
const MAC_VK_PageUp                     = 0x74;
const MAC_VK_ForwardDelete              = 0x75;
const MAC_VK_PC_Delete                  = 0x75;
const MAC_VK_F4                         = 0x76;
const MAC_VK_End                        = 0x77;
const MAC_VK_F2                         = 0x78;
const MAC_VK_PageDown                   = 0x79;
const MAC_VK_F1                         = 0x7A;
const MAC_VK_LeftArrow                  = 0x7B;
const MAC_VK_RightArrow                 = 0x7C;
const MAC_VK_DownArrow                  = 0x7D;
const MAC_VK_UpArrow                    = 0x7E;

