/* ignuit - Educational software for the GNOME, following the Leitner
 * flash-card system.
 *
 * Copyright (C) 2008, 2009 Timothy Richard Musson
 *
 * Email: <trmusson@gmail.com>
 * WWW:   http://homepages.ihug.co.nz/~trmusson/programs.html#ignuit
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include <config.h>
#include <gnome.h>
#include <glib/gi18n.h>
#include <glade/glade.h>

#include "main.h"
#include "file.h"
#include "app-window.h"
#include "dialog-editor.h"
#include "dialog-properties.h"


typedef struct {

    Ignuit              *ig;
    GtkWidget           *window;
    GtkWidget           *entry_title;
    GtkWidget           *entry_author;
    GtkWidget           *entry_comment;
    GtkWidget           *entry_url;
    GtkWidget           *entry_license;
    CardStyle           style;

} Dialog;


static Dialog *dialog = NULL;


static void
cb_style (GtkWidget *widget, Dialog *d)
{
    d->style = gtk_combo_box_get_active (GTK_COMBO_BOX(widget)) + 1;

    /* XXX: Update card editor textviews */
}


static void
cb_destroy (GtkWidget *widget, Dialog *d)
{
    g_free (d);
    dialog = NULL;
}


static gboolean
properties_changed (Dialog *d)
{
    return
        strcmp (file_get_title (d->ig->file),
            gtk_entry_get_text (GTK_ENTRY(d->entry_title))) ||
        strcmp (file_get_author (d->ig->file),
            gtk_entry_get_text (GTK_ENTRY(d->entry_author))) ||
        strcmp (file_get_comment (d->ig->file),
            gtk_entry_get_text (GTK_ENTRY(d->entry_comment))) ||
        strcmp (file_get_url (d->ig->file),
            gtk_entry_get_text (GTK_ENTRY(d->entry_url))) ||
        strcmp (file_get_license (d->ig->file),
            gtk_entry_get_text (GTK_ENTRY(d->entry_license))) ||
        file_get_card_style (d->ig->file) != d->style;
}


static void
cb_close (GtkWidget *widget, Dialog *d)
{
    if (properties_changed (d)) {

        file_set_title (d->ig->file,
            gtk_entry_get_text (GTK_ENTRY(d->entry_title)));
        file_set_author (d->ig->file,
            gtk_entry_get_text (GTK_ENTRY(d->entry_author)));
        file_set_comment (d->ig->file,
            gtk_entry_get_text (GTK_ENTRY(d->entry_comment)));
        file_set_url (d->ig->file,
            gtk_entry_get_text (GTK_ENTRY(d->entry_url)));
        file_set_license (d->ig->file,
            gtk_entry_get_text (GTK_ENTRY(d->entry_license)));

        file_set_card_style (d->ig->file, d->style);

        file_set_changed (d->ig->file, TRUE);
        app_window_update_title (d->ig);
    }

    gtk_widget_destroy (d->window);
}


void
dialog_properties (Ignuit *ig)
{
    Dialog    *d;
    GtkWidget *combo_style;
    GtkWidget *btn_close;
    GladeXML  *glade_xml;
    gchar     *glade_file;


    if (dialog != NULL) {
        gtk_window_present (GTK_WINDOW(dialog->window));
        return;
    }

    glade_file = gnome_program_locate_file (ig->program,
        GNOME_FILE_DOMAIN_APP_DATADIR, F_GLADE_PROPERTIES, TRUE, NULL);

    if (glade_file == NULL) {
        g_warning ("Can't find file: %s\n", F_GLADE_PROPERTIES);
        return;
    }

    dialog = d = g_new0 (Dialog, 1);

    glade_xml = glade_xml_new (glade_file, NULL, NULL);
    g_free (glade_file);

    d->ig = ig;

    d->window = glade_xml_get_widget (glade_xml, "dialog");
    d->entry_title = glade_xml_get_widget (glade_xml, "entry_title");
    d->entry_author = glade_xml_get_widget (glade_xml, "entry_author");
    d->entry_comment = glade_xml_get_widget (glade_xml, "entry_comment");
    d->entry_url = glade_xml_get_widget (glade_xml, "entry_url");
    d->entry_license = glade_xml_get_widget (glade_xml, "entry_license");
    combo_style = glade_xml_get_widget (glade_xml, "combo_style");
    btn_close = glade_xml_get_widget (glade_xml, "btn_close");


    gtk_entry_set_text (GTK_ENTRY(d->entry_title),
        file_get_title (d->ig->file));
    gtk_entry_set_text (GTK_ENTRY(d->entry_author),
        file_get_author (d->ig->file));
    gtk_entry_set_text (GTK_ENTRY(d->entry_comment),
        file_get_comment (d->ig->file));
    gtk_entry_set_text (GTK_ENTRY(d->entry_url),
        file_get_url (d->ig->file));
    gtk_entry_set_text (GTK_ENTRY(d->entry_license),
        file_get_license (d->ig->file));

    gtk_combo_box_append_text (GTK_COMBO_BOX(combo_style),
        _("Centered keywords and text"));
    gtk_combo_box_append_text (GTK_COMBO_BOX(combo_style),
        _("Non-centered keywords and text"));
    gtk_combo_box_append_text (GTK_COMBO_BOX(combo_style),
        _("Non-centered text only"));

    d->style = file_get_card_style (d->ig->file);
    gtk_combo_box_set_active (GTK_COMBO_BOX(combo_style), d->style - 1);

    g_signal_connect (G_OBJECT(d->window), "destroy",
        G_CALLBACK(cb_destroy), d);

    g_signal_connect (G_OBJECT(combo_style), "changed",
        G_CALLBACK(cb_style), d);

    g_signal_connect (G_OBJECT(btn_close), "clicked",
        G_CALLBACK(cb_close), d);


    gtk_window_set_transient_for (GTK_WINDOW(d->window),
        GTK_WINDOW(ig->app));
    gtk_window_set_modal (GTK_WINDOW(d->window), FALSE);

    gtk_widget_show_all (d->window);

    g_object_unref (G_OBJECT(glade_xml));
}

