/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_unary_primitive;
import gnu.jel.debug.Debug;

class OP_unary
extends OP_unary_primitive {
    int opc;

    OP_unary(int opc) {
        this.opc = opc;
    }

    void compile(ExpressionImage ei) {
        ei.asm_unary(this.opc);
    }

    void doOperation(OP_load c) throws Throwable {
        Debug.assert(c.type != null && c.type.isPrimitive(), "Wrong types for binary OP");
        int id = ExpressionImage.primitiveID(c.type);
        Class resClass = ExpressionImage.getUnaryPromoted(c.type);
        Debug.assert(resClass != null, "Wrong type of operand for unary operation (" + this.opc + ") can't perform unary numeric " + "promotion.");
        int resid = ExpressionImage.primitiveID(resClass);
        Number val = OP_function.widen(c.what, id);
        switch (this.opc) {
            case 0: {
                if (OP_function.isFloat(id)) {
                    val = new Double(-val.doubleValue());
                    break;
                }
                val = new Long(-val.longValue());
                break;
            }
            case 1: {
                val = new Long(val.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                break;
            }
            default: {
                Debug.println("Wrong unary opcode.");
            }
        }
        c.what = OP_function.narrow(val, resid);
        c.type = resClass;
    }

    public String toString() {
        return ExpressionImage.unarySymbols[this.opc];
    }
}

