/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.debug.Debug;

class IntegerStack {
    private int[] data;
    private int count;

    public IntegerStack(int initCapacity) {
        this.data = new int[initCapacity];
    }

    public IntegerStack() {
        this(30);
    }

    public final void push(int what) {
        if (this.count >= this.data.length) {
            this.increaseCapacity(this.count + 1);
        }
        this.data[this.count++] = what;
    }

    public final int peek() {
        return this.data[this.count - 1];
    }

    public final int pop() {
        return this.data[--this.count];
    }

    public final int size() {
        return this.count;
    }

    public final void pop_throw() {
        --this.count;
        Debug.assert(this.count >= 0, "Stack is empty when removing top.");
    }

    public static void swap(IntegerStack one, int oneLim, IntegerStack other, int otherLim) {
        boolean cf_other;
        int copyFromOne = one.count - oneLim;
        int copyFromOther = other.count - otherLim;
        boolean cf_one = copyFromOne > 0;
        boolean bl = cf_other = copyFromOther > 0;
        if (cf_one || cf_other) {
            int nSizeOne = oneLim + copyFromOther;
            int nSizeOther = otherLim + copyFromOne;
            if (nSizeOne > one.data.length) {
                one.increaseCapacity(nSizeOne);
            }
            if (nSizeOther > other.data.length) {
                other.increaseCapacity(nSizeOther);
            }
            int[] temp = null;
            if (cf_one) {
                temp = new int[copyFromOne];
                System.arraycopy(one.data, oneLim, temp, 0, copyFromOne);
            }
            if (cf_other) {
                System.arraycopy(other.data, otherLim, one.data, oneLim, copyFromOther);
            }
            if (cf_one) {
                System.arraycopy(temp, 0, other.data, otherLim, copyFromOne);
            }
            one.count = nSizeOne;
            other.count = nSizeOther;
        }
    }

    private synchronized void increaseCapacity(int minCapacity) {
        int[] old_data = this.data;
        int oldSize = this.data.length;
        int newSize = oldSize * 2;
        if (newSize < minCapacity) {
            newSize = minCapacity;
        }
        this.data = new int[newSize];
        System.arraycopy(old_data, 0, this.data, 0, this.count);
    }
}

