/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.debug.Debug;
import java.io.ByteArrayOutputStream;

class PatchableByteArrayOutputStream
extends ByteArrayOutputStream {
    PatchableByteArrayOutputStream() {
    }

    public void patchAddress(int pos, byte address) {
        this.buf[pos] = address;
    }

    public void patchAddress(int pos, int address) {
        Debug.assert(address <= 65535, "Jump destination is too far.");
        this.buf[pos] = (byte)(address >>> 8 & 0xFF);
        this.buf[pos + 1] = (byte)(address & 0xFF);
    }

    public void patchAddressInt(int pos, int address) {
        this.buf[pos] = (byte)(address >>> 24 & 0xFF);
        this.buf[pos + 1] = (byte)(address >>> 16 & 0xFF);
        this.buf[pos + 2] = (byte)(address >>> 8 & 0xFF);
        this.buf[pos + 3] = (byte)(address & 0xFF);
    }
}

