/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.lists.Sequence;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.InPort;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.HashMap;
import kawa.lang.Syntax;
import kawa.lang.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LispLanguage
extends Language {
    public static final String quote_sym = "quote";
    public static final String unquote_sym = "unquote";
    public static final String unquotesplicing_sym = "unquote-splicing";
    public static final String quasiquote_sym = "quasiquote";
    public static final Symbol lookup_sym = Namespace.EmptyNamespace.getSymbol("$lookup$");
    public static final Symbol bracket_list_sym = Namespace.EmptyNamespace.getSymbol("$bracket-list$");
    public static final Symbol bracket_apply_sym = Namespace.EmptyNamespace.getSymbol("$bracket-apply$");
    public static StaticFieldLocation getNamedPartLocation = new StaticFieldLocation("gnu.kawa.functions.GetNamedPart", "getNamedPart");
    protected ReadTable defaultReadTable;
    private HashMap<String, Type> types;
    private HashMap<Type, String> typeToStringMap;

    public abstract ReadTable createReadTable();

    @Override
    public LispReader getLexer(InPort inp, SourceMessages messages) {
        return new LispReader(inp, messages);
    }

    @Override
    public String getCompilationClass() {
        return "kawa.lang.Translator";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parse(Compilation comp, int options) throws IOException, SyntaxException {
        Translator tr = (Translator)comp;
        Lexer lexer = tr.lexer;
        ModuleExp mexp = tr.mainLambda;
        Values forms = new Values();
        LispReader reader = (LispReader)lexer;
        Compilation saveComp = Compilation.setSaveCurrent(tr);
        try {
            if (tr.pendingForm != null) {
                tr.scanForm(tr.pendingForm, mexp);
                tr.pendingForm = null;
            }
            while (true) {
                Object sexp;
                if ((sexp = reader.readCommand()) == Sequence.eofValue) {
                    if ((options & 4) == 0) break;
                    boolean bl = false;
                    return bl;
                }
                if (lexer.peek() == 41) {
                    lexer.skip();
                    lexer.fatal("An unexpected close paren was read.");
                }
                tr.scanForm(sexp, mexp);
                if ((options & 4) != 0) {
                    int ch;
                    if (!tr.getMessages().seenErrors()) break;
                    while ((ch = reader.peek()) >= 0 && ch != 13 && ch != 10) {
                        reader.skip();
                    }
                    break;
                }
                if ((options & 8) == 0 || tr.getState() < 2) continue;
                boolean bl = true;
                return bl;
            }
            tr.finishModule(mexp);
            if ((options & 8) == 0) {
                tr.firstForm = 0;
            }
            tr.setState(4);
        }
        finally {
            Compilation.restoreCurrent(saveComp);
        }
        return true;
    }

    @Override
    public void resolve(Compilation comp) {
        Translator tr = (Translator)comp;
        tr.resolveModule(tr.getModule());
    }

    @Override
    public Declaration declFromField(ModuleExp mod, Object fvalue, Field fld) {
        boolean isFinal;
        Declaration fdecl = super.declFromField(mod, fvalue, fld);
        boolean bl = isFinal = (fld.getModifiers() & 0x10) != 0;
        if (isFinal && fvalue instanceof Syntax) {
            fdecl.setSyntax();
        }
        return fdecl;
    }

    protected void defSntxStFld(String name, String cname, String fname) {
        Object property = this.hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null;
        StaticFieldLocation loc = StaticFieldLocation.define(this.environ, this.environ.getSymbol(name), property, cname, fname);
        loc.setSyntax();
    }

    protected void defSntxStFld(String name, String cname) {
        this.defSntxStFld(name, cname, LispLanguage.mangleNameIfNeeded(name));
    }

    public boolean selfEvaluatingSymbol(Object obj) {
        return obj instanceof Keyword;
    }

    public static Symbol langSymbolToSymbol(Object sym) {
        return ((LispLanguage)Language.getDefaultLanguage()).fromLangSymbol(sym);
    }

    protected Symbol fromLangSymbol(Object sym) {
        if (sym instanceof String) {
            return this.getSymbol((String)sym);
        }
        return (Symbol)sym;
    }

    protected synchronized HashMap<String, Type> getTypeMap() {
        if (this.types == null) {
            this.types = new HashMap(64);
            this.types.put("void", LangPrimType.voidType);
            this.types.put("int", LangPrimType.intType);
            this.types.put("char", LangPrimType.charType);
            this.types.put("byte", LangPrimType.byteType);
            this.types.put("short", LangPrimType.shortType);
            this.types.put("long", LangPrimType.longType);
            this.types.put("float", LangPrimType.floatType);
            this.types.put("double", LangPrimType.doubleType);
            this.types.put("never-returns", Type.neverReturnsType);
            this.types.put("Object", Type.objectType);
            this.types.put("String", Type.toStringType);
            this.types.put("object", Type.objectType);
            this.types.put("number", LangObjType.numericType);
            this.types.put("quantity", ClassType.make("gnu.math.Quantity"));
            this.types.put("complex", ClassType.make("gnu.math.Complex"));
            this.types.put("real", LangObjType.realType);
            this.types.put("rational", LangObjType.rationalType);
            this.types.put("integer", LangObjType.integerType);
            this.types.put("symbol", ClassType.make("gnu.mapping.Symbol"));
            this.types.put("namespace", ClassType.make("gnu.mapping.Namespace"));
            this.types.put("keyword", ClassType.make("gnu.expr.Keyword"));
            this.types.put("pair", ClassType.make("gnu.lists.Pair"));
            this.types.put("pair-with-position", ClassType.make("gnu.lists.PairWithPosition"));
            this.types.put("constant-string", ClassType.make("java.lang.String"));
            this.types.put("abstract-string", ClassType.make("gnu.lists.CharSeq"));
            this.types.put("character", ClassType.make("gnu.text.Char"));
            this.types.put("vector", LangObjType.vectorType);
            this.types.put("string", LangObjType.stringType);
            this.types.put("empty-list", ClassType.make("gnu.lists.EmptyList"));
            this.types.put("list", LangObjType.listType);
            this.types.put("function", ClassType.make("gnu.mapping.Procedure"));
            this.types.put("procedure", LangObjType.procedureType);
            this.types.put("input-port", ClassType.make("gnu.mapping.InPort"));
            this.types.put("output-port", ClassType.make("gnu.mapping.OutPort"));
            this.types.put("string-output-port", ClassType.make("gnu.mapping.CharArrayOutPort"));
            this.types.put("string-input-port", ClassType.make("gnu.mapping.CharArrayInPort"));
            this.types.put("record", ClassType.make("kawa.lang.Record"));
            this.types.put("type", LangObjType.typeType);
            this.types.put("class-type", LangObjType.typeClassType);
            this.types.put("class", LangObjType.typeClass);
            this.types.put("promise", LangObjType.promiseType);
            this.types.put("document", ClassType.make("gnu.kawa.xml.KDocument"));
            this.types.put("readtable", ClassType.make("gnu.kawa.lispexpr.ReadTable"));
        }
        return this.types;
    }

    public Type getPackageStyleType(String name) {
        int colon = name.indexOf(58);
        if (colon > 0) {
            String lang = name.substring(0, colon);
            Language interp = Language.getInstance(lang);
            if (interp == null) {
                throw new RuntimeException("unknown type '" + name + "' - unknown language '" + lang + '\'');
            }
            Type type = interp.getNamedType(name.substring(colon + 1));
            if (type != null) {
                this.types.put(name, type);
            }
            return type;
        }
        return null;
    }

    @Override
    public Type getNamedType(String name) {
        Type type = this.getTypeMap().get(name);
        return type != null ? type : this.getPackageStyleType(name);
    }

    @Override
    public Type getTypeFor(Class clas) {
        String name = clas.getName();
        if (clas.isPrimitive()) {
            return this.getNamedType(name);
        }
        if ("java.lang.String".equals(name)) {
            return Type.toStringType;
        }
        if ("gnu.math.IntNum".equals(name)) {
            return LangObjType.integerType;
        }
        if ("gnu.math.DFloNum".equals(name)) {
            return LangObjType.dflonumType;
        }
        if ("gnu.math.RatNum".equals(name)) {
            return LangObjType.rationalType;
        }
        if ("gnu.math.RealNum".equals(name)) {
            return LangObjType.realType;
        }
        if ("gnu.math.Numeric".equals(name)) {
            return LangObjType.numericType;
        }
        if ("gnu.lists.FVector".equals(name)) {
            return LangObjType.vectorType;
        }
        if ("gnu.lists.LList".equals(name)) {
            return LangObjType.listType;
        }
        if ("gnu.text.Path".equals(name)) {
            return LangObjType.pathType;
        }
        if ("gnu.text.URIPath".equals(name)) {
            return LangObjType.URIType;
        }
        if ("gnu.text.FilePath".equals(name)) {
            return LangObjType.filepathType;
        }
        if ("java.lang.Class".equals(name)) {
            return LangObjType.typeClass;
        }
        if ("gnu.bytecode.Type".equals(name)) {
            return LangObjType.typeType;
        }
        if ("gnu.bytecode.ClassType".equals(name)) {
            return LangObjType.typeClassType;
        }
        return super.getTypeFor(clas);
    }

    static {
        getNamedPartLocation.setProcedure();
    }
}

