/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.mapping.Environment;
import gnu.mapping.IndirectableLocation;
import gnu.mapping.Location;
import gnu.mapping.Symbol;

public class BufferLocal
extends IndirectableLocation {
    boolean all;
    Buffer cachedBuffer;
    final Symbol name;
    int cachedIndex;

    BufferLocal(Symbol symbol, boolean bl) {
        this.name = symbol;
        this.all = bl;
    }

    public final Symbol getKeySymbol() {
        return this.name;
    }

    public static void make(Symbol symbol, boolean bl) {
        Environment environment = Environment.getCurrent();
        Location location2 = environment.getLocation(symbol, null).getBase();
        if (location2 instanceof BufferLocal) {
            if (bl) {
                ((BufferLocal)location2).all = true;
            }
            return;
        }
        BufferLocal bufferLocal = new BufferLocal(symbol, bl);
        bufferLocal.base = location2;
        environment.addLocation(symbol, null, bufferLocal);
    }

    public Object get(Object object2) {
        Buffer buffer = Buffer.getCurrent();
        return buffer == null ? this.base.get(object2) : this.get(buffer, object2);
    }

    public Object get(Buffer buffer, Object object2) {
        Object[] objectArray = buffer.localBindings;
        if (buffer == this.cachedBuffer) {
            int n = this.cachedIndex;
            if (n > 0) {
                return objectArray[n];
            }
        } else if (objectArray != null) {
            Symbol symbol = this.getKeySymbol();
            int n = objectArray.length;
            this.cachedBuffer = buffer;
            for (int i = 0; i < n; i += 2) {
                if (objectArray[i] != symbol) continue;
                this.cachedIndex = ++i;
                return objectArray[i];
            }
            this.cachedIndex = 0;
        }
        return this.base != null ? this.base.get(object2) : (this.value == Location.UNBOUND ? object2 : this.value);
    }

    public boolean isBound() {
        Buffer buffer = Buffer.getCurrent();
        return buffer == null ? this.base.isBound() : this.isBound(buffer);
    }

    public boolean isBound(Buffer buffer) {
        Object[] objectArray = buffer.localBindings;
        String string = Location.UNBOUND;
        if (buffer == this.cachedBuffer) {
            int n = this.cachedIndex;
            if (n >= 0) {
                return objectArray[n] != string;
            }
        } else if (objectArray != null) {
            Symbol symbol = this.getKeySymbol();
            int n = objectArray.length;
            this.cachedBuffer = buffer;
            for (int i = 0; i < n; i += 2) {
                if (objectArray[i] != symbol) continue;
                this.cachedIndex = ++i;
                return objectArray[i] != string;
            }
            this.cachedIndex = 0;
        }
        return super.isBound();
    }

    public final synchronized void set(Object object2) {
        Buffer buffer = Buffer.getCurrent();
        if (buffer == null) {
            this.base.set(object2);
        } else {
            this.set(buffer, object2);
        }
    }

    public final synchronized void set(Buffer buffer, Object object2) {
        int n;
        Object[] objectArray = buffer.localBindings;
        int n2 = -1;
        Symbol symbol = this.getKeySymbol();
        if (buffer == this.cachedBuffer) {
            n = this.cachedIndex;
            if (n >= 0) {
                objectArray[n] = object2;
                return;
            }
        } else if (objectArray != null) {
            n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                Object object3 = objectArray[i];
                if (object3 == symbol) {
                    this.cachedBuffer = buffer;
                    this.cachedIndex = ++i;
                    objectArray[i] = object2;
                    return;
                }
                if (object3 != null) continue;
                n2 = i;
            }
            this.cachedIndex = 0;
        }
        if (this.all) {
            if (n2 < 0) {
                if (objectArray == null) {
                    buffer.localBindings = objectArray = new Object[20];
                    n2 = 0;
                } else {
                    n2 = objectArray.length;
                    Object[] objectArray2 = new Object[2 * n2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                    objectArray = objectArray2;
                    buffer.localBindings = objectArray2;
                }
            }
            objectArray[n2] = symbol;
            this.cachedBuffer = buffer;
            this.cachedIndex = ++n2;
            objectArray[n2 + 1] = object2;
        } else if (this.base == null) {
            this.value = object2;
        } else {
            this.base.set(object2);
        }
    }
}

