/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl.history.history;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Objects;
import org.jline.reader.History;
import org.jline.reader.impl.history.history.MemoryHistory;
import org.jline.utils.Log;

public class FileHistory
extends MemoryHistory {
    private final File file;

    public FileHistory(File file) throws IOException {
        this.file = Objects.requireNonNull(file).getAbsoluteFile();
        this.load(file);
    }

    public File getFile() {
        return this.file;
    }

    public void load(File file) throws IOException {
        Objects.requireNonNull(file);
        if (file.exists()) {
            Log.trace("Loading history from: ", file);
            try (FileReader reader = null;){
                reader = new FileReader(file);
                this.load(reader);
            }
        }
    }

    public void load(InputStream input) throws IOException {
        Objects.requireNonNull(input);
        this.load(new InputStreamReader(input));
    }

    public void load(Reader reader) throws IOException {
        String item;
        Objects.requireNonNull(reader);
        BufferedReader input = new BufferedReader(reader);
        while ((item = input.readLine()) != null) {
            this.internalAdd(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Log.trace("Flushing history");
        if (!this.file.exists()) {
            File dir = this.file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                Log.warn("Failed to create directory: ", dir);
            }
            if (!this.file.createNewFile()) {
                Log.warn("Failed to create file: ", this.file);
            }
        }
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.file)));){
            for (History.Entry entry : this) {
                out.println(entry.value());
            }
        }
    }

    @Override
    public void clear() {
        Log.trace("Purging history");
        super.clear();
        if (!this.file.delete()) {
            Log.warn("Failed to delete history file: ", this.file);
        }
    }
}

