/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.util;

import java.io.IOException;
import java.io.Writer;

public abstract class StringBufferedWriter
extends Writer {
    StringBuilder sbuf = new StringBuilder();
    protected boolean autoflush = true;

    public StringBufferedWriter(boolean bl) {
        this.autoflush = bl;
    }

    @Override
    public synchronized void write(char[] cArray, int n, int n2) throws IOException {
        this.sbuf.append(cArray, n, n2);
        if (this.autoflush) {
            this.flush();
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.sbuf.append((char)n);
        if (this.autoflush && n == 10) {
            this.flush();
        }
    }

    @Override
    public synchronized void write(String string) throws IOException {
        if (this.sbuf.length() > 0) {
            this.sbuf.append(string);
            if (this.autoflush) {
                this.flush();
            }
        } else {
            this.writeRaw(string);
        }
    }

    protected abstract void writeRaw(String var1) throws IOException;

    @Override
    public synchronized void flush() throws IOException {
        if (this.sbuf.length() > 0) {
            this.writeRaw(this.sbuf.toString());
            this.sbuf.setLength(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

